/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.AbortedTxn;
import kafka.log.CompletedTxn;
import kafka.log.LogConfig;
import kafka.log.LogFlushStats$;
import kafka.log.LogSegment$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetPosition;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateManager;
import kafka.log.RollParams;
import kafka.log.TimeIndex;
import kafka.log.TimestampOffset;
import kafka.log.TransactionIndex;
import kafka.log.TxnIndexSearchResult;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.LogOffsetMetadata;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.BufferSupplier;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r\rh\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h'\u0016<W.\u001a8u\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0004\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001eD\u0001b\u0001\u0001\u0003\u0006\u0004%\t!F\u000b\u0002-A\u0011q#I\u0007\u00021)\u0011\u0011DG\u0001\u0007e\u0016\u001cwN\u001d3\u000b\u0005ma\u0012AB2p[6|gN\u0003\u0002\u0006;)\u0011adH\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\n1a\u001c:h\u0013\t\u0011\u0003DA\u0006GS2,'+Z2pe\u0012\u001c\b\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\t1|w\r\t\u0005\tM\u0001\u0011)\u0019!C\u0001O\u0005YqN\u001a4tKRLe\u000eZ3y+\u0005A\u0003CA\u0015+\u001b\u0005\u0011\u0011BA\u0016\u0003\u0005-yeMZ:fi&sG-\u001a=\t\u00115\u0002!\u0011!Q\u0001\n!\nAb\u001c4gg\u0016$\u0018J\u001c3fq\u0002B\u0001b\f\u0001\u0003\u0006\u0004%\t\u0001M\u0001\ni&lW-\u00138eKb,\u0012!\r\t\u0003SIJ!a\r\u0002\u0003\u0013QKW.Z%oI\u0016D\b\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\u0002\u0015QLW.Z%oI\u0016D\b\u0005\u0003\u00058\u0001\t\u0015\r\u0011\"\u00019\u0003!!\bP\\%oI\u0016DX#A\u001d\u0011\u0005%R\u0014BA\u001e\u0003\u0005A!&/\u00198tC\u000e$\u0018n\u001c8J]\u0012,\u0007\u0010\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003:\u0003%!\bP\\%oI\u0016D\b\u0005\u0003\u0005@\u0001\t\u0015\r\u0011\"\u0001A\u0003)\u0011\u0017m]3PM\u001a\u001cX\r^\u000b\u0002\u0003B\u0011\u0011BQ\u0005\u0003\u0007*\u0011A\u0001T8oO\"AQ\t\u0001B\u0001B\u0003%\u0011)A\u0006cCN,wJ\u001a4tKR\u0004\u0003\u0002C$\u0001\u0005\u000b\u0007I\u0011\u0001%\u0002%%tG-\u001a=J]R,'O^1m\u0005f$Xm]\u000b\u0002\u0013B\u0011\u0011BS\u0005\u0003\u0017*\u00111!\u00138u\u0011!i\u0005A!A!\u0002\u0013I\u0015aE5oI\u0016D\u0018J\u001c;feZ\fGNQ=uKN\u0004\u0003\u0002C(\u0001\u0005\u000b\u0007I\u0011\u0001!\u0002\u0019I|G\u000e\u001c&jiR,'/T:\t\u0011E\u0003!\u0011!Q\u0001\n\u0005\u000bQB]8mY*KG\u000f^3s\u001bN\u0004\u0003\u0002C*\u0001\u0005\u000b\u0007I\u0011\u0001+\u0002\tQLW.Z\u000b\u0002+B\u0011a\u000bW\u0007\u0002/*\u0011\u0011CG\u0005\u00033^\u0013A\u0001V5nK\"A1\f\u0001B\u0001B\u0003%Q+A\u0003uS6,\u0007\u0005\u0003\u0004^\u0001\u0011\u0005!AX\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0013}\u0003\u0017MY2eK\u001a<\u0007CA\u0015\u0001\u0011\u0015\u0019A\f1\u0001\u0017\u0011\u00151C\f1\u0001)\u0011\u0015yC\f1\u00012\u0011\u00159D\f1\u0001:\u0011\u0015yD\f1\u0001B\u0011\u00159E\f1\u0001J\u0011\u0015yE\f1\u0001B\u0011\u0015\u0019F\f1\u0001V\u0011\u0015I\u0007\u0001\"\u0001k\u0003)\u0019\bn\\;mIJ{G\u000e\u001c\u000b\u0003W:\u0004\"!\u00037\n\u00055T!a\u0002\"p_2,\u0017M\u001c\u0005\u0006_\"\u0004\r\u0001]\u0001\u000be>dG\u000eU1sC6\u001c\bCA\u0015r\u0013\t\u0011(A\u0001\u0006S_2d\u0007+\u0019:b[NDQ\u0001\u001e\u0001\u0005\u0002U\fQB]3tSj,\u0017J\u001c3fq\u0016\u001cHC\u0001<z!\tIq/\u0003\u0002y\u0015\t!QK\\5u\u0011\u0015Q8\u000f1\u0001J\u0003\u0011\u0019\u0018N_3\t\u000bq\u0004A\u0011A?\u0002\u0017M\fg.\u001b;z\u0007\",7m\u001b\u000b\u0003mzDQa`>A\u0002-\f\u0011\u0004^5nK&sG-\u001a=GS2,g*Z<ms\u000e\u0013X-\u0019;fI\"A\u00111\u0001\u0001A\u0002\u0013%\u0001)A\u0004de\u0016\fG/\u001a3\t\u0013\u0005\u001d\u0001\u00011A\u0005\n\u0005%\u0011aC2sK\u0006$X\rZ0%KF$2A^A\u0006\u0011%\ti!!\u0002\u0002\u0002\u0003\u0007\u0011)A\u0002yIEBq!!\u0005\u0001A\u0003&\u0011)\u0001\u0005de\u0016\fG/\u001a3!\u0011!\t)\u0002\u0001a\u0001\n\u0013A\u0015\u0001\u00072zi\u0016\u001c8+\u001b8dK2\u000b7\u000f^%oI\u0016DXI\u001c;ss\"I\u0011\u0011\u0004\u0001A\u0002\u0013%\u00111D\u0001\u001dEf$Xm]*j]\u000e,G*Y:u\u0013:$W\r_#oiJLx\fJ3r)\r1\u0018Q\u0004\u0005\n\u0003\u001b\t9\"!AA\u0002%Cq!!\t\u0001A\u0003&\u0011*A\rcsR,7oU5oG\u0016d\u0015m\u001d;J]\u0012,\u00070\u00128uef\u0004\u0003\"CA\u0013\u0001\u0001\u0007I\u0011BA\u0014\u0003U\u0011x\u000e\u001c7j]\u001e\u0014\u0015m]3e)&lWm\u001d;b[B,\"!!\u000b\u0011\t%\tY#Q\u0005\u0004\u0003[Q!AB(qi&|g\u000eC\u0005\u00022\u0001\u0001\r\u0011\"\u0003\u00024\u0005I\"o\u001c7mS:<')Y:fIRKW.Z:uC6\u0004x\fJ3r)\r1\u0018Q\u0007\u0005\u000b\u0003\u001b\ty#!AA\u0002\u0005%\u0002\u0002CA\u001d\u0001\u0001\u0006K!!\u000b\u0002-I|G\u000e\\5oO\n\u000b7/\u001a3US6,7\u000f^1na\u0002B\u0001\"!\u0010\u0001\u0001\u0004%I\u0001Q\u0001\u0012[\u0006DH+[7fgR\fW\u000e]*p\r\u0006\u0014\b\"CA!\u0001\u0001\u0007I\u0011BA\"\u0003Ui\u0017\r\u001f+j[\u0016\u001cH/Y7q'>4\u0015M]0%KF$2A^A#\u0011%\ti!a\u0010\u0002\u0002\u0003\u0007\u0011\tC\u0004\u0002J\u0001\u0001\u000b\u0015B!\u0002%5\f\u0007\u0010V5nKN$\u0018-\u001c9T_\u001a\u000b'\u000f\t\u0015\u0005\u0003\u000f\ni\u0005E\u0002\n\u0003\u001fJ1!!\u0015\u000b\u0005!1x\u000e\\1uS2,\u0007\u0002CA+\u0001\u0001\u0007I\u0011\u0002!\u0002)=4gm]3u\u001f\u001al\u0015\r\u001f+j[\u0016\u001cH/Y7q\u0011%\tI\u0006\u0001a\u0001\n\u0013\tY&\u0001\rpM\u001a\u001cX\r^(g\u001b\u0006DH+[7fgR\fW\u000e]0%KF$2A^A/\u0011%\ti!a\u0016\u0002\u0002\u0003\u0007\u0011\tC\u0004\u0002b\u0001\u0001\u000b\u0015B!\u0002+=4gm]3u\u001f\u001al\u0015\r\u001f+j[\u0016\u001cH/Y7qA!\"\u0011qLA'\u0011\u0015Q\b\u0001\"\u0001I\u0011\u001d\tI\u0007\u0001C\u0001\u0003W\n!dY1o\u0007>tg/\u001a:u)>\u0014V\r\\1uSZ,wJ\u001a4tKR$2a[A7\u0011\u001d\ty'a\u001aA\u0002\u0005\u000baa\u001c4gg\u0016$\bbBA:\u0001\u0011\u0005\u0011QO\u0001\u0007CB\u0004XM\u001c3\u0015\u0013Y\f9(a\u001f\u0002\u0000\u0005\r\u0005bBA=\u0003c\u0002\r!Q\u0001\u000eY\u0006\u0014x-Z:u\u001f\u001a47/\u001a;\t\u000f\u0005u\u0014\u0011\u000fa\u0001\u0003\u0006\u0001B.\u0019:hKN$H+[7fgR\fW\u000e\u001d\u0005\b\u0003\u0003\u000b\t\b1\u0001B\u0003m\u0019\b.\u00197m_^|eMZ:fi>3W*\u0019=US6,7\u000f^1na\"A\u0011QQA9\u0001\u0004\t9)A\u0004sK\u000e|'\u000fZ:\u0011\u0007]\tI)C\u0002\u0002\fb\u0011Q\"T3n_JL(+Z2pe\u0012\u001c\b\u0006BA9\u0003\u001f\u00032aDAI\u0013\r\t\u0019\n\u0005\u0002\u000e]>tG\u000f\u001b:fC\u0012\u001c\u0018MZ3\t\u000f\u0005]\u0005\u0001\"\u0003\u0002\u001a\u0006\u0019RM\\:ve\u0016|eMZ:fi&s'+\u00198hKR\u0019a/a'\t\u000f\u0005=\u0014Q\u0013a\u0001\u0003\"9\u0011q\u0014\u0001\u0005\n\u0005\u0005\u0016aE1qa\u0016tGm\u00115v].4%o\\7GS2,GcB%\u0002$\u0006\u0015\u0016\u0011\u0016\u0005\b\u0003\u000b\u000bi\n1\u0001\u0017\u0011\u001d\t9+!(A\u0002%\u000b\u0001\u0002]8tSRLwN\u001c\u0005\t\u0003W\u000bi\n1\u0001\u0002.\u0006q!-\u001e4gKJ\u001cV\u000f\u001d9mS\u0016\u0014\bcA\f\u00020&\u0019\u0011\u0011\u0017\r\u0003\u001d\t+hMZ3s'V\u0004\b\u000f\\5fe\"9\u0011Q\u0017\u0001\u0005\u0002\u0005]\u0016AD1qa\u0016tGM\u0012:p[\u001aKG.\u001a\u000b\u0006\u0013\u0006e\u00161\u0018\u0005\b\u0003\u000b\u000b\u0019\f1\u0001\u0017\u0011\u001d\ti,a-A\u0002%\u000bQa\u001d;beRDq!!1\u0001\t\u0003\t\u0019-\u0001\bva\u0012\fG/\u001a+y]&sG-\u001a=\u0015\u000bY\f)-a4\t\u0011\u0005\u001d\u0017q\u0018a\u0001\u0003\u0013\fAbY8na2,G/\u001a3Uq:\u00042!KAf\u0013\r\tiM\u0001\u0002\r\u0007>l\u0007\u000f\\3uK\u0012$\u0006P\u001c\u0005\b\u0003#\fy\f1\u0001B\u0003Aa\u0017m\u001d;Ti\u0006\u0014G.Z(gMN,G\u000f\u000b\u0003\u0002@\u0006=\u0005bBAl\u0001\u0011%\u0011\u0011\\\u0001\u0014kB$\u0017\r^3Qe>$WoY3s'R\fG/\u001a\u000b\u0006m\u0006m\u0017Q\u001d\u0005\t\u0003;\f)\u000e1\u0001\u0002`\u0006!\u0002O]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJ\u00042!KAq\u0013\r\t\u0019O\u0001\u0002\u0015!J|G-^2feN#\u0018\r^3NC:\fw-\u001a:\t\u0011\u0005\u001d\u0018Q\u001ba\u0001\u0003S\fQAY1uG\"\u00042aFAv\u0013\r\ti\u000f\u0007\u0002\f%\u0016\u001cwN\u001d3CCR\u001c\u0007\u000e\u0003\u0005\u0002r\u0002!\tAAAz\u0003=!(/\u00198tY\u0006$Xm\u00144gg\u0016$HCBA{\u0005;\u0011y\u0002\u0005\u0003\u0002x\n]a\u0002BA}\u0005'qA!a?\u0003\u00129!\u0011Q B\b\u001d\u0011\tyP!\u0004\u000f\t\t\u0005!1\u0002\b\u0005\u0005\u0007\u0011I!\u0004\u0002\u0003\u0006)\u0019!q\u0001\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0013B\u0001\u0010 \u0013\t)Q$\u0003\u0002\u001c9%\u0011\u0011DG\u0005\u0004\u0005+A\u0012a\u0003$jY\u0016\u0014VmY8sINLAA!\u0007\u0003\u001c\t\tBj\\4PM\u001a\u001cX\r\u001e)pg&$\u0018n\u001c8\u000b\u0007\tU\u0001\u0004C\u0004\u0002p\u0005=\b\u0019A!\t\u0013\t\u0005\u0012q\u001eI\u0001\u0002\u0004I\u0015\u0001F:uCJ$\u0018N\\4GS2,\u0007k\\:ji&|g\u000e\u000b\u0003\u0002p\n\u0015\u0002cA\b\u0003(%\u0019!\u0011\u0006\t\u0003\u0015QD'/Z1eg\u00064W\rC\u0004\u0003.\u0001!\tAa\f\u0002\tI,\u0017\r\u001a\u000b\r\u0005c\u0011iD!\u0011\u0003F\t%#Q\n\t\u0005\u0005g\u0011I$\u0004\u0002\u00036)\u0019!q\u0007\u0003\u0002\rM,'O^3s\u0013\u0011\u0011YD!\u000e\u0003\u001b\u0019+Go\u00195ECR\f\u0017J\u001c4p\u0011\u001d\u0011yDa\u000bA\u0002\u0005\u000b1b\u001d;beR|eMZ:fi\"A!1\tB\u0016\u0001\u0004\tI#A\u0005nCb|eMZ:fi\"9!q\tB\u0016\u0001\u0004I\u0015aB7bqNK'0\u001a\u0005\n\u0005\u0017\u0012Y\u0003%AA\u0002\u0005\u000b1\"\\1y!>\u001c\u0018\u000e^5p]\"I!q\nB\u0016!\u0003\u0005\ra[\u0001\u000e[&twJ\\3NKN\u001c\u0018mZ3)\t\t-\"Q\u0005\u0005\b\u0005+\u0002A\u0011\u0001B,\u0003U1W\r^2i+B\u0004XM\u001d\"pk:$wJ\u001a4tKR$b!!\u000b\u0003Z\t\r\u0004\u0002\u0003B.\u0005'\u0002\rA!\u0018\u0002'M$\u0018M\u001d;PM\u001a\u001cX\r\u001e)pg&$\u0018n\u001c8\u0011\u0007%\u0012y&C\u0002\u0003b\t\u0011ab\u00144gg\u0016$\bk\\:ji&|g\u000eC\u0004\u0003f\tM\u0003\u0019A%\u0002\u0013\u0019,Go\u00195TSj,\u0007b\u0002B5\u0001\u0011\u0005!1N\u0001\be\u0016\u001cwN^3s)\u0015I%Q\u000eB8\u0011!\tiNa\u001aA\u0002\u0005}\u0007B\u0003B9\u0005O\u0002\n\u00111\u0001\u0003t\u0005\u0001B.Z1eKJ,\u0005o\\2i\u0007\u0006\u001c\u0007.\u001a\t\u0006\u0013\u0005-\"Q\u000f\t\u0005\u0005o\u0012i(\u0004\u0002\u0003z)!!1\u0010B\u001b\u0003\u0015)\u0007o\\2i\u0013\u0011\u0011yH!\u001f\u0003)1+\u0017\rZ3s\u000bB|7\r\u001b$jY\u0016\u001c\u0015m\u00195fQ\u0011\u00119'a$\t\u000f\t\u0015\u0005\u0001\"\u0003\u0003\b\u0006!Bn\\1e\u0019\u0006\u0014x-Z:u)&lWm\u001d;b[B$\u0012A\u001e\u0005\b\u0005\u0017\u0003A\u0011\u0001BG\u0003-A\u0017m](wKJ4Gn\\<\u0016\u0003-DqA!%\u0001\t\u0003\u0011\u0019*\u0001\nd_2dWm\u0019;BE>\u0014H/\u001a3Uq:\u001cHC\u0002BK\u00057\u0013y\nE\u0002*\u0005/K1A!'\u0003\u0005Q!\u0006P\\%oI\u0016D8+Z1sG\"\u0014Vm];mi\"9!Q\u0014BH\u0001\u0004\t\u0015a\u00034fi\u000eDwJ\u001a4tKRDqA!)\u0003\u0010\u0002\u0007\u0011)\u0001\tvaB,'OQ8v]\u0012|eMZ:fi\"9!Q\u0015\u0001\u0005B\t\u001d\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t%\u0006\u0003\u0002BV\u0005kk!A!,\u000b\t\t=&\u0011W\u0001\u0005Y\u0006twM\u0003\u0002\u00034\u0006!!.\u0019<b\u0013\u0011\u00119L!,\u0003\rM#(/\u001b8h\u0011\u001d\u0011Y\f\u0001C\u0001\u0005{\u000b!\u0002\u001e:v]\u000e\fG/\u001a+p)\rI%q\u0018\u0005\b\u0003_\u0012I\f1\u0001BQ\u0011\u0011I,a$\t\r\t\u0015\u0007\u0001\"\u0001A\u00039\u0011X-\u00193OKb$xJ\u001a4tKRDCAa1\u0003&!9!1\u001a\u0001\u0005\u0002\t\u001d\u0015!\u00024mkND\u0007\u0006\u0002Be\u0005KAqA!5\u0001\t\u0003\u0011\u0019.A\u0005va\u0012\fG/\u001a#jeR\u0019aO!6\t\u0011\t]'q\u001aa\u0001\u00053\f1\u0001Z5s!\u0011\u0011YN!9\u000e\u0005\tu'\u0002\u0002Bp\u0005c\u000b!![8\n\t\t\r(Q\u001c\u0002\u0005\r&dW\rC\u0004\u0003h\u0002!\tA!;\u0002%\rD\u0017M\\4f\r&dWmU;gM&DXm\u001d\u000b\u0006m\n-(Q \u0005\t\u0005[\u0014)\u000f1\u0001\u0003p\u0006Iq\u000e\u001c3Tk\u001a4\u0017\u000e\u001f\t\u0005\u0005c\u0014IP\u0004\u0003\u0003t\nU\bc\u0001B\u0002\u0015%\u0019!q\u001f\u0006\u0002\rA\u0013X\rZ3g\u0013\u0011\u00119La?\u000b\u0007\t](\u0002\u0003\u0005\u0003\u0000\n\u0015\b\u0019\u0001Bx\u0003%qWm^*vM\u001aL\u0007\u0010C\u0004\u0004\u0004\u0001!\tAa\"\u0002/=t')Z2p[\u0016Le.Y2uSZ,7+Z4nK:$\bbBB\u0004\u0001\u0011\u00051\u0011B\u0001\u0012i&lWmV1ji\u0016$gi\u001c:S_2dG#B!\u0004\f\r=\u0001bBB\u0007\u0007\u000b\u0001\r!Q\u0001\u0004]><\bbBB\t\u0007\u000b\u0001\r!Q\u0001\u0011[\u0016\u001c8/Y4f)&lWm\u001d;b[BDqa!\u0006\u0001\t\u0003\u00199\"A\u000bgS:$wJ\u001a4tKR\u0014\u0015\u0010V5nKN$\u0018-\u001c9\u0015\r\re1\u0011EB\u0013!\u0015I\u00111FB\u000e!\rI3QD\u0005\u0004\u0007?\u0011!a\u0004+j[\u0016\u001cH/Y7q\u001f\u001a47/\u001a;\t\u000f\r\r21\u0003a\u0001\u0003\u0006IA/[7fgR\fW\u000e\u001d\u0005\n\u0007O\u0019\u0019\u0002%AA\u0002\u0005\u000bab\u001d;beRLgnZ(gMN,G\u000fC\u0004\u0004,\u0001!\tAa\"\u0002\u000b\rdwn]3\t\u000f\r=\u0002\u0001\"\u0001\u0003\b\u0006i1\r\\8tK\"\u000bg\u000e\u001a7feNDqaa\r\u0001\t\u0003\u00119)\u0001\beK2,G/Z%g\u000bbL7\u000f^:\t\r\r]\u0002\u0001\"\u0001A\u00031a\u0017m\u001d;N_\u0012Lg-[3e\u0011\u0019\ti\b\u0001C\u0001\u0001\"91Q\b\u0001\u0005\u0002\r}\u0012\u0001\u00057bgRlu\u000eZ5gS\u0016$w\fJ3r)\u0011\u0019\te!\u0015\u0011\t\r\r3QJ\u0007\u0003\u0007\u000bRAaa\u0012\u0004J\u0005!a-\u001b7f\u0015\u0011\u0019YE!-\u0002\u00079Lw.\u0003\u0003\u0004P\r\u0015#\u0001\u0002)bi\"Dqaa\u0015\u0004<\u0001\u0007\u0011)\u0001\u0002ng\"I1q\u000b\u0001\u0012\u0002\u0013\u00051\u0011L\u0001\u0012e\u0016\u001cwN^3sI\u0011,g-Y;mi\u0012\u0012TCAB.U\u0011\u0011\u0019h!\u0018,\u0005\r}\u0003\u0003BB1\u0007Wj!aa\u0019\u000b\t\r\u00154qM\u0001\nk:\u001c\u0007.Z2lK\u0012T1a!\u001b\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007[\u001a\u0019GA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011b!\u001d\u0001#\u0003%\taa\u001d\u0002\u001dI,\u0017\r\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\u00111Q\u000f\u0016\u0004\u0003\u000eu\u0003\"CB=\u0001E\u0005I\u0011AB>\u00039\u0011X-\u00193%I\u00164\u0017-\u001e7uIU*\"a! +\u0007-\u001ci\u0006\u0003\u0006\u0004\u0002\u0002\t\n\u0011\"\u0001\u0003\u0007\u0007\u000b\u0011\u0004\u001e:b]Nd\u0017\r^3PM\u001a\u001cX\r\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u00111Q\u0011\u0016\u0004\u0013\u000eu\u0003\"CBE\u0001E\u0005I\u0011AB:\u0003}1\u0017N\u001c3PM\u001a\u001cX\r\u001e\"z)&lWm\u001d;b[B$C-\u001a4bk2$HE\r\u0015\u0004\u0001\u0005=uaBBH\u0005!\u00051\u0011S\u0001\u000b\u0019><7+Z4nK:$\bcA\u0015\u0004\u0014\u001a1\u0011A\u0001E\u0001\u0007+\u001b2aa%\t\u0011\u001di61\u0013C\u0001\u00073#\"a!%\t\u0011\ru51\u0013C\u0001\u0007?\u000bAa\u001c9f]R\trl!)\u0004$\u000e\u00156qVBY\u0007k\u001bIl!0\t\u0011\t]71\u0014a\u0001\u00053DaaPBN\u0001\u0004\t\u0005\u0002CBT\u00077\u0003\ra!+\u0002\r\r|gNZ5h!\rI31V\u0005\u0004\u0007[\u0013!!\u0003'pO\u000e{gNZ5h\u0011\u0019\u001961\u0014a\u0001+\"I11WBN!\u0003\u0005\ra[\u0001\u0012M&dW-\u00117sK\u0006$\u00170\u0012=jgR\u001c\b\"CB\\\u00077\u0003\n\u00111\u0001J\u00031Ig.\u001b;GS2,7+\u001b>f\u0011%\u0019Yla'\u0011\u0002\u0003\u00071.A\u0006qe\u0016\fG\u000e\\8dCR,\u0007BCB`\u00077\u0003\n\u00111\u0001\u0003p\u0006Qa-\u001b7f'V4g-\u001b=\t\u0011\rM21\u0013C\u0001\u0007\u0007$rA^Bc\u0007\u000f\u001cI\r\u0003\u0005\u0003X\u000e\u0005\u0007\u0019\u0001Bm\u0011\u0019y4\u0011\u0019a\u0001\u0003\"Q1qXBa!\u0003\u0005\rAa<\t\u0015\r571SI\u0001\n\u0003\u0019Y(\u0001\bpa\u0016tG\u0005Z3gCVdG\u000fJ\u001b\t\u0015\rE71SI\u0001\n\u0003\u0019\u0019)\u0001\bpa\u0016tG\u0005Z3gCVdG\u000f\n\u001c\t\u0015\rU71SI\u0001\n\u0003\u0019Y(\u0001\bpa\u0016tG\u0005Z3gCVdG\u000fJ\u001c\t\u0015\re71SI\u0001\n\u0003\u0019Y.\u0001\bpa\u0016tG\u0005Z3gCVdG\u000f\n\u001d\u0016\u0005\ru'\u0006\u0002Bx\u0007;B!b!9\u0004\u0014F\u0005I\u0011ABn\u0003a!W\r\\3uK&3W\t_5tiN$C-\u001a4bk2$He\r")
public class LogSegment
implements Logging {
    private final FileRecords log;
    private final OffsetIndex offsetIndex;
    private final TimeIndex timeIndex;
    private final TransactionIndex txnIndex;
    private final long baseOffset;
    private final int indexIntervalBytes;
    private final long rollJitterMs;
    private final Time time;
    private long created;
    private int bytesSinceLastIndexEntry;
    private Option<Object> rollingBasedTimestamp;
    private volatile long maxTimestampSoFar;
    private volatile long offsetOfMaxTimestamp;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String deleteIfExists$default$3() {
        return LogSegment$.MODULE$.deleteIfExists$default$3();
    }

    public static String open$default$8() {
        return LogSegment$.MODULE$.open$default$8();
    }

    public static boolean open$default$7() {
        return LogSegment$.MODULE$.open$default$7();
    }

    public static int open$default$6() {
        return LogSegment$.MODULE$.open$default$6();
    }

    public static boolean open$default$5() {
        return LogSegment$.MODULE$.open$default$5();
    }

    public static LogSegment open(File file, long l, LogConfig logConfig, Time time, boolean bl, int n, boolean bl2, String string) {
        return LogSegment$.MODULE$.open(file, l, logConfig, time, bl, n, bl2, string);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        LogSegment logSegment = this;
        synchronized (logSegment) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public FileRecords log() {
        return this.log;
    }

    public OffsetIndex offsetIndex() {
        return this.offsetIndex;
    }

    public TimeIndex timeIndex() {
        return this.timeIndex;
    }

    public TransactionIndex txnIndex() {
        return this.txnIndex;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int indexIntervalBytes() {
        return this.indexIntervalBytes;
    }

    public long rollJitterMs() {
        return this.rollJitterMs;
    }

    public Time time() {
        return this.time;
    }

    public boolean shouldRoll(RollParams rollParams) {
        boolean reachedRollMs = this.timeWaitedForRoll(rollParams.now(), rollParams.maxTimestampInMessages()) > rollParams.maxSegmentMs() - this.rollJitterMs();
        return this.size() > rollParams.maxSegmentBytes() - rollParams.messagesSize() || this.size() > 0 && reachedRollMs || this.offsetIndex().isFull() || this.timeIndex().isFull() || !this.canConvertToRelativeOffset(rollParams.maxOffsetInMessages());
    }

    public void resizeIndexes(int size) {
        this.offsetIndex().resize(size);
        this.timeIndex().resize(size);
    }

    public void sanityCheck(boolean timeIndexFileNewlyCreated) {
        if (!this.offsetIndex().file().exists()) {
            throw new NoSuchFileException(new StringBuilder(33).append("Offset index file ").append(this.offsetIndex().file().getAbsolutePath()).append(" does not exist").toString());
        }
        this.offsetIndex().sanityCheck();
        Object object = timeIndexFileNewlyCreated ? BoxesRunTime.boxToBoolean((boolean)this.timeIndex().resize(0)) : BoxedUnit.UNIT;
        this.timeIndex().sanityCheck();
        this.txnIndex().sanityCheck();
    }

    private long created() {
        return this.created;
    }

    private void created_$eq(long x$1) {
        this.created = x$1;
    }

    private int bytesSinceLastIndexEntry() {
        return this.bytesSinceLastIndexEntry;
    }

    private void bytesSinceLastIndexEntry_$eq(int x$1) {
        this.bytesSinceLastIndexEntry = x$1;
    }

    private Option<Object> rollingBasedTimestamp() {
        return this.rollingBasedTimestamp;
    }

    private void rollingBasedTimestamp_$eq(Option<Object> x$1) {
        this.rollingBasedTimestamp = x$1;
    }

    private long maxTimestampSoFar() {
        return this.maxTimestampSoFar;
    }

    private void maxTimestampSoFar_$eq(long x$1) {
        this.maxTimestampSoFar = x$1;
    }

    private long offsetOfMaxTimestamp() {
        return this.offsetOfMaxTimestamp;
    }

    private void offsetOfMaxTimestamp_$eq(long x$1) {
        this.offsetOfMaxTimestamp = x$1;
    }

    public int size() {
        return this.log().sizeInBytes();
    }

    public boolean canConvertToRelativeOffset(long offset) {
        return this.offsetIndex().canAppendOffset(offset);
    }

    public void append(long largestOffset, long largestTimestamp, long shallowOffsetOfMaxTimestamp, MemoryRecords records) {
        block3: {
            if (records.sizeInBytes() <= 0) break block3;
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Inserting ").append(records.sizeInBytes()).append(" bytes at end offset ").append(largestOffset).append(" at position ").append(this.log().sizeInBytes()).append(" ").append(new StringBuilder(42).append("with largest timestamp ").append(largestTimestamp).append(" at shallow offset ").append(shallowOffsetOfMaxTimestamp).toString()).toString());
            int physicalPosition = this.log().sizeInBytes();
            if (physicalPosition == 0) {
                this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)largestTimestamp)));
            }
            this.ensureOffsetInRange(largestOffset);
            int appendedBytes = this.log().append(records);
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Appended ").append(appendedBytes).append(" to ").append(this.log().file()).append(" at end offset ").append(largestOffset).toString());
            if (largestTimestamp > this.maxTimestampSoFar()) {
                this.maxTimestampSoFar_$eq(largestTimestamp);
                this.offsetOfMaxTimestamp_$eq(shallowOffsetOfMaxTimestamp);
            }
            if (this.bytesSinceLastIndexEntry() > this.indexIntervalBytes()) {
                this.offsetIndex().append(largestOffset, physicalPosition);
                this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestamp(), this.timeIndex().maybeAppend$default$3());
                this.bytesSinceLastIndexEntry_$eq(0);
            }
            this.bytesSinceLastIndexEntry_$eq(this.bytesSinceLastIndexEntry() + records.sizeInBytes());
        }
    }

    private void ensureOffsetInRange(long offset) {
        if (!this.canConvertToRelativeOffset(offset)) {
            throw new LogSegmentOffsetOverflowException(this, offset);
        }
    }

    private int appendChunkFromFile(FileRecords records, int position, BufferSupplier bufferSupplier) {
        IntRef bytesToAppend = IntRef.create((int)0);
        LongRef maxTimestamp = LongRef.create((long)Long.MIN_VALUE);
        LongRef offsetOfMaxTimestamp = LongRef.create((long)Long.MIN_VALUE);
        LongRef maxOffset = LongRef.create((long)Long.MIN_VALUE);
        ObjectRef readBuffer = ObjectRef.create((Object)bufferSupplier.get(0x100000));
        Iterator nextBatches = ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batchesFrom(position)).asScala()).iterator();
        nextBatches.takeWhile((Function1 & Serializable & scala.Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)this.canAppend$1(batch, bytesToAppend, readBuffer))).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            LogSegment.$anonfun$appendChunkFromFile$2(bytesToAppend, maxTimestamp, offsetOfMaxTimestamp, maxOffset, batch);
            return BoxedUnit.UNIT;
        });
        if (bytesToAppend.elem > 0) {
            if (((ByteBuffer)readBuffer.elem).capacity() < bytesToAppend.elem) {
                readBuffer.elem = bufferSupplier.get(bytesToAppend.elem);
            }
            ((ByteBuffer)readBuffer.elem).limit(bytesToAppend.elem);
            records.readInto((ByteBuffer)readBuffer.elem, position);
            this.append(maxOffset.elem, maxTimestamp.elem, offsetOfMaxTimestamp.elem, MemoryRecords.readableRecords((ByteBuffer)((ByteBuffer)readBuffer.elem)));
        }
        bufferSupplier.release((ByteBuffer)readBuffer.elem);
        return bytesToAppend.elem;
    }

    public int appendFromFile(FileRecords records, int start) {
        int position;
        int bytesAppended;
        BufferSupplier.GrowableBufferSupplier bufferSupplier = new BufferSupplier.GrowableBufferSupplier();
        for (position = start; position < start + records.sizeInBytes(); position += bytesAppended) {
            bytesAppended = this.appendChunkFromFile(records, position, (BufferSupplier)bufferSupplier);
            if (bytesAppended != 0) continue;
            return position - start;
        }
        return position - start;
    }

    public void updateTxnIndex(CompletedTxn completedTxn, long lastStableOffset) {
        block0: {
            if (!completedTxn.isAborted()) break block0;
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Writing aborted transaction ").append(completedTxn).append(" to transaction index, last stable offset is ").append(lastStableOffset).toString());
            this.txnIndex().append(new AbortedTxn(completedTxn, lastStableOffset));
        }
    }

    private void updateProducerState(ProducerStateManager producerStateManager, RecordBatch batch) {
        if (batch.hasProducerId()) {
            long producerId = batch.producerId();
            ProducerAppendInfo appendInfo = producerStateManager.prepareUpdate(producerId, false);
            Option<CompletedTxn> maybeCompletedTxn = appendInfo.append(batch);
            producerStateManager.update(appendInfo);
            maybeCompletedTxn.foreach((Function1 & Serializable & scala.Serializable)completedTxn -> {
                LogSegment.$anonfun$updateProducerState$1(this, producerStateManager, completedTxn);
                return BoxedUnit.UNIT;
            });
        }
        producerStateManager.updateMapEndOffset(batch.lastOffset() + 1L);
    }

    public FileRecords.LogOffsetPosition translateOffset(long offset, int startingFilePosition) {
        OffsetPosition mapping = this.offsetIndex().lookup(offset);
        return this.log().searchForOffsetWithSize(offset, package$.MODULE$.max(mapping.position(), startingFilePosition));
    }

    public int translateOffset$default$2() {
        return 0;
    }

    public FetchDataInfo read(long startOffset, Option<Object> maxOffset, int maxSize, long maxPosition, boolean minOneMessage) {
        int n;
        int adjustedMaxSize;
        if (maxSize < 0) {
            throw new IllegalArgumentException(new StringBuilder(44).append("Invalid max size ").append(maxSize).append(" for log read from segment ").append(this.log()).toString());
        }
        int logSize = this.log().sizeInBytes();
        FileRecords.LogOffsetPosition startOffsetAndSize = this.translateOffset(startOffset, this.translateOffset$default$2());
        if (startOffsetAndSize == null) {
            return null;
        }
        int startPosition = startOffsetAndSize.position;
        LogOffsetMetadata offsetMetadata = new LogOffsetMetadata(startOffset, this.baseOffset(), startPosition);
        int n2 = adjustedMaxSize = minOneMessage ? package$.MODULE$.max(maxSize, startOffsetAndSize.size) : maxSize;
        if (adjustedMaxSize == 0) {
            return new FetchDataInfo(offsetMetadata, (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4());
        }
        Option<Object> option = maxOffset;
        if (None$.MODULE$.equals(option)) {
            n = package$.MODULE$.min((int)(maxPosition - (long)startPosition), adjustedMaxSize);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            long offset = BoxesRunTime.unboxToLong((Object)some.value());
            if (offset < startOffset) {
                return new FetchDataInfo(offsetMetadata, (Records)MemoryRecords.EMPTY, false, FetchDataInfo$.MODULE$.apply$default$4());
            }
            FileRecords.LogOffsetPosition mapping = this.translateOffset(offset, startPosition);
            int endPosition = mapping == null ? logSize : mapping.position;
            n = (int)package$.MODULE$.min(package$.MODULE$.min(maxPosition, (long)endPosition) - (long)startPosition, (long)adjustedMaxSize);
        } else {
            throw new MatchError(option);
        }
        int fetchSize = n;
        return new FetchDataInfo(offsetMetadata, (Records)this.log().slice(startPosition, fetchSize), adjustedMaxSize < startOffsetAndSize.size, FetchDataInfo$.MODULE$.apply$default$4());
    }

    public long read$default$4() {
        return this.size();
    }

    public boolean read$default$5() {
        return false;
    }

    public Option<Object> fetchUpperBoundOffset(OffsetPosition startOffsetPosition, int fetchSize) {
        return this.offsetIndex().fetchUpperBoundOffset(startOffsetPosition, fetchSize).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.offset()));
    }

    public int recover(ProducerStateManager producerStateManager, Option<LeaderEpochFileCache> leaderEpochCache) {
        this.offsetIndex().reset();
        this.timeIndex().reset();
        this.txnIndex().reset();
        IntRef validBytes = IntRef.create((int)0);
        IntRef lastIndexEntry = IntRef.create((int)0);
        this.maxTimestampSoFar_$eq(-1L);
        try {
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(this.log().batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                LogSegment.$anonfun$recover$1(this, producerStateManager, leaderEpochCache, validBytes, lastIndexEntry, batch);
                return BoxedUnit.UNIT;
            });
        }
        catch (CorruptRecordException e) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Found invalid messages in log segment %s at byte offset %d: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log().file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)validBytes$1.elem), e.getMessage()})));
        }
        int truncated = this.log().sizeInBytes() - validBytes.elem;
        if (truncated > 0) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Truncated ").append(truncated).append(" invalid bytes at the end of segment ").append(this.log().file().getAbsoluteFile()).append(" during recovery").toString());
        }
        this.log().truncateTo(validBytes.elem);
        this.offsetIndex().trimToValidSize();
        this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestamp(), true);
        this.timeIndex().trimToValidSize();
        return truncated;
    }

    public Option<LeaderEpochFileCache> recover$default$2() {
        return None$.MODULE$;
    }

    private void loadLargestTimestamp() {
        block0: {
            TimestampOffset lastTimeIndexEntry = this.timeIndex().lastEntry();
            this.maxTimestampSoFar_$eq(lastTimeIndexEntry.timestamp());
            this.offsetOfMaxTimestamp_$eq(lastTimeIndexEntry.offset());
            OffsetPosition offsetPosition = this.offsetIndex().lookup(lastTimeIndexEntry.offset());
            FileRecords.TimestampAndOffset maxTimestampOffsetAfterLastEntry = this.log().largestTimestampAfter(offsetPosition.position());
            if (maxTimestampOffsetAfterLastEntry.timestamp <= lastTimeIndexEntry.timestamp()) break block0;
            this.maxTimestampSoFar_$eq(maxTimestampOffsetAfterLastEntry.timestamp);
            this.offsetOfMaxTimestamp_$eq(maxTimestampOffsetAfterLastEntry.offset);
        }
    }

    public boolean hasOverflow() {
        long nextOffset = this.readNextOffset();
        return nextOffset > this.baseOffset() && !this.canConvertToRelativeOffset(nextOffset - 1L);
    }

    public TxnIndexSearchResult collectAbortedTxns(long fetchOffset, long upperBoundOffset) {
        return this.txnIndex().collectAbortedTxns(fetchOffset, upperBoundOffset);
    }

    public String toString() {
        return new StringBuilder(30).append("LogSegment(baseOffset=").append(this.baseOffset()).append(", size=").append(this.size()).append(")").toString();
    }

    public int truncateTo(long offset) {
        int bytesTruncated;
        block1: {
            FileRecords.LogOffsetPosition mapping = this.translateOffset(offset, this.translateOffset$default$2());
            this.offsetIndex().truncateTo(offset);
            this.timeIndex().truncateTo(offset);
            this.txnIndex().truncateTo(offset);
            this.offsetIndex().resize(this.offsetIndex().maxIndexSize());
            this.timeIndex().resize(this.timeIndex().maxIndexSize());
            int n = bytesTruncated = mapping == null ? 0 : this.log().truncateTo(mapping.position);
            if (this.log().sizeInBytes() == 0) {
                this.created_$eq(this.time().milliseconds());
                this.rollingBasedTimestamp_$eq((Option<Object>)None$.MODULE$);
            }
            this.bytesSinceLastIndexEntry_$eq(0);
            if (this.maxTimestampSoFar() < 0L) break block1;
            this.loadLargestTimestamp();
        }
        return bytesTruncated;
    }

    public long readNextOffset() {
        FetchDataInfo fetchData = this.read(this.offsetIndex().lastOffset(), (Option<Object>)None$.MODULE$, this.log().sizeInBytes(), this.read$default$4(), this.read$default$5());
        return fetchData == null ? this.baseOffset() : BoxesRunTime.unboxToLong((Object)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).lastOption().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.nextOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.baseOffset()));
    }

    public void flush() {
        LogFlushStats$.MODULE$.logFlushTimer().time((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.log().flush();
            this.offsetIndex().flush();
            this.timeIndex().flush();
            this.txnIndex().flush();
        });
    }

    public void updateDir(File dir) {
        this.log().setFile(new File(dir, this.log().file().getName()));
        this.offsetIndex().file_$eq(new File(dir, this.offsetIndex().file().getName()));
        this.timeIndex().file_$eq(new File(dir, this.timeIndex().file().getName()));
        this.txnIndex().file_$eq(new File(dir, this.txnIndex().file().getName()));
    }

    public void changeFileSuffixes(String oldSuffix, String newSuffix) {
        this.log().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.log().file().getPath(), oldSuffix, newSuffix)));
        this.offsetIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.offsetIndex().file().getPath(), oldSuffix, newSuffix)));
        this.timeIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.timeIndex().file().getPath(), oldSuffix, newSuffix)));
        this.txnIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.txnIndex().file().getPath(), oldSuffix, newSuffix)));
    }

    public void onBecomeInactiveSegment() {
        this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestamp(), true);
        this.offsetIndex().trimToValidSize();
        this.timeIndex().trimToValidSize();
        this.log().trim();
    }

    public long timeWaitedForRoll(long now, long messageTimestamp) {
        Some some;
        long t;
        Option<Object> option;
        java.util.Iterator iter;
        if (this.rollingBasedTimestamp().isEmpty() && (iter = this.log().batches().iterator()).hasNext()) {
            this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)((FileLogInputStream.FileChannelRecordBatch)iter.next()).maxTimestamp())));
        }
        long l = (option = this.rollingBasedTimestamp()) instanceof Some && (t = BoxesRunTime.unboxToLong((Object)(some = (Some)option).value())) >= 0L ? messageTimestamp - t : now - this.created();
        return l;
    }

    public Option<TimestampOffset> findOffsetByTimestamp(long timestamp, long startingOffset) {
        TimestampOffset timestampOffset = this.timeIndex().lookup(timestamp);
        int position = this.offsetIndex().lookup(package$.MODULE$.max(timestampOffset.offset(), startingOffset)).position();
        return Option$.MODULE$.apply((Object)this.log().searchForTimestamp(timestamp, position, startingOffset)).map((Function1 & Serializable & scala.Serializable)timestampAndOffset -> new TimestampOffset(timestampAndOffset.timestamp, timestampAndOffset.offset));
    }

    public long findOffsetByTimestamp$default$2() {
        return this.baseOffset();
    }

    public void close() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestamp(), true), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.offsetIndex().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.timeIndex().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.log().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.txnIndex().close(), this, CoreUtils$.MODULE$.swallow$default$3());
    }

    public void closeHandlers() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.offsetIndex().closeHandler(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.timeIndex().closeHandler(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.log().closeHandlers(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.txnIndex().close(), this, CoreUtils$.MODULE$.swallow$default$3());
    }

    public void deleteIfExists() {
        CoreUtils$.MODULE$.tryAll((Seq<Function0<BoxedUnit>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.delete$1((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.log().deleteIfExists(), "log", this.log().file(), true), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.delete$1((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.offsetIndex().deleteIfExists(), "offset index", this.offsetIndex().file(), true), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.delete$1((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.timeIndex().deleteIfExists(), "time index", this.timeIndex().file(), true), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.delete$1((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.txnIndex().deleteIfExists(), "transaction index", this.txnIndex().file(), false)}))));
    }

    public long lastModified() {
        return this.log().file().lastModified();
    }

    public long largestTimestamp() {
        return this.maxTimestampSoFar() >= 0L ? this.maxTimestampSoFar() : this.lastModified();
    }

    public Path lastModified_$eq(long ms) {
        FileTime fileTime = FileTime.fromMillis(ms);
        Files.setLastModifiedTime(this.log().file().toPath(), fileTime);
        Files.setLastModifiedTime(this.offsetIndex().file().toPath(), fileTime);
        return Files.setLastModifiedTime(this.timeIndex().file().toPath(), fileTime);
    }

    private final boolean canAppend$1(RecordBatch batch, IntRef bytesToAppend$1, ObjectRef readBuffer$1) {
        return this.canConvertToRelativeOffset(batch.lastOffset()) && (bytesToAppend$1.elem == 0 || bytesToAppend$1.elem + batch.sizeInBytes() < ((ByteBuffer)readBuffer$1.elem).capacity());
    }

    public static final /* synthetic */ void $anonfun$appendChunkFromFile$2(IntRef bytesToAppend$1, LongRef maxTimestamp$1, LongRef offsetOfMaxTimestamp$1, LongRef maxOffset$1, FileLogInputStream.FileChannelRecordBatch batch) {
        if (batch.maxTimestamp() > maxTimestamp$1.elem) {
            maxTimestamp$1.elem = batch.maxTimestamp();
            offsetOfMaxTimestamp$1.elem = batch.lastOffset();
        }
        maxOffset$1.elem = batch.lastOffset();
        bytesToAppend$1.elem += batch.sizeInBytes();
    }

    public static final /* synthetic */ void $anonfun$updateProducerState$1(LogSegment $this, ProducerStateManager producerStateManager$2, CompletedTxn completedTxn) {
        long lastStableOffset = producerStateManager$2.completeTxn(completedTxn);
        $this.updateTxnIndex(completedTxn, lastStableOffset);
    }

    public static final /* synthetic */ void $anonfun$recover$2(FileLogInputStream.FileChannelRecordBatch batch$1, LeaderEpochFileCache cache) {
        block0: {
            if (batch$1.partitionLeaderEpoch() <= 0 || !cache.latestEpoch().forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> batch$1.partitionLeaderEpoch() > x$2)) break block0;
            cache.assign(batch$1.partitionLeaderEpoch(), batch$1.baseOffset());
        }
    }

    public static final /* synthetic */ void $anonfun$recover$1(LogSegment $this, ProducerStateManager producerStateManager$1, Option leaderEpochCache$1, IntRef validBytes$1, IntRef lastIndexEntry$1, FileLogInputStream.FileChannelRecordBatch batch) {
        block2: {
            batch.ensureValid();
            $this.ensureOffsetInRange(batch.lastOffset());
            if (batch.maxTimestamp() > $this.maxTimestampSoFar()) {
                $this.maxTimestampSoFar_$eq(batch.maxTimestamp());
                $this.offsetOfMaxTimestamp_$eq(batch.lastOffset());
            }
            if (validBytes$1.elem - lastIndexEntry$1.elem > $this.indexIntervalBytes()) {
                $this.offsetIndex().append(batch.lastOffset(), validBytes$1.elem);
                $this.timeIndex().maybeAppend($this.maxTimestampSoFar(), $this.offsetOfMaxTimestamp(), $this.timeIndex().maybeAppend$default$3());
                lastIndexEntry$1.elem = validBytes$1.elem;
            }
            validBytes$1.elem += batch.sizeInBytes();
            if (batch.magic() < 2) break block2;
            leaderEpochCache$1.foreach((Function1 & Serializable & scala.Serializable)cache -> {
                LogSegment.$anonfun$recover$2(batch, cache);
                return BoxedUnit.UNIT;
            });
            $this.updateProducerState(producerStateManager$1, (RecordBatch)batch);
        }
    }

    private final void delete$1(Function0 delete, String fileType, File file, boolean logIfMissing) {
        try {
            if (delete.apply$mcZ$sp()) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Deleted ").append(fileType).append(" ").append(file.getAbsolutePath()).append(".").toString());
            } else if (logIfMissing) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(fileType).append(" ").append(file.getAbsolutePath()).append(" because it does not exist.").toString());
            }
        }
        catch (IOException e) {
            throw new IOException(new StringBuilder(19).append("Delete of ").append(fileType).append(" ").append(file.getAbsolutePath()).append(" failed.").toString(), e);
        }
    }

    public LogSegment(FileRecords log, OffsetIndex offsetIndex, TimeIndex timeIndex, TransactionIndex txnIndex, long baseOffset, int indexIntervalBytes, long rollJitterMs, Time time) {
        this.log = log;
        this.offsetIndex = offsetIndex;
        this.timeIndex = timeIndex;
        this.txnIndex = txnIndex;
        this.baseOffset = baseOffset;
        this.indexIntervalBytes = indexIntervalBytes;
        this.rollJitterMs = rollJitterMs;
        this.time = time;
        Logging.$init$(this);
        this.created = time.milliseconds();
        this.bytesSinceLastIndexEntry = 0;
        this.rollingBasedTimestamp = None$.MODULE$;
        this.maxTimestampSoFar = timeIndex.lastEntry().timestamp();
        this.offsetOfMaxTimestamp = timeIndex.lastEntry().offset();
    }
}

