/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import kafka.log.BatchMetadata;
import kafka.log.ProducerStateEntry$;
import org.apache.kafka.common.record.RecordBatch;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.Queue;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005etAB\u0001\u0003\u0011\u0003\u0011a!\u0001\nQe>$WoY3s'R\fG/Z#oiJL(BA\u0002\u0005\u0003\rawn\u001a\u0006\u0002\u000b\u0005)1.\u00194lCB\u0011q\u0001C\u0007\u0002\u0005\u00191\u0011B\u0001E\u0001\u0005)\u0011!\u0003\u0015:pIV\u001cWM]*uCR,WI\u001c;ssN\u0011\u0001b\u0003\t\u0003\u0019=i\u0011!\u0004\u0006\u0002\u001d\u0005)1oY1mC&\u0011\u0001#\u0004\u0002\u0007\u0003:L(+\u001a4\t\u000bIAA\u0011\u0001\u000b\u0002\rqJg.\u001b;?\u0007\u0001!\u0012A\u0002\u0005\t-!\u0011\r\u0011\"\u0001\u0003/\u0005\u0011b*^7CCR\u001c\u0007.Z:U_J+G/Y5o+\u0005A\u0002C\u0001\u0007\u001a\u0013\tQRBA\u0002J]RDa\u0001\b\u0005!\u0002\u0013A\u0012a\u0005(v[\n\u000bGo\u00195fgR{'+\u001a;bS:\u0004\u0003\"\u0002\u0010\t\t\u0003y\u0012!B3naRLHc\u0001\u0011\u0002xA\u0011q!\t\u0004\u0006\u0013\t\u0001!AI\n\u0003C-A\u0001\u0002J\u0011\u0003\u0006\u0004%\t!J\u0001\u000baJ|G-^2fe&#W#\u0001\u0014\u0011\u000519\u0013B\u0001\u0015\u000e\u0005\u0011auN\\4\t\u0011)\n#\u0011!Q\u0001\n\u0019\n1\u0002\u001d:pIV\u001cWM]%eA!AA&\tBC\u0002\u0013\u0005Q&A\u0007cCR\u001c\u0007.T3uC\u0012\fG/Y\u000b\u0002]A\u0019q\u0006\u000e\u001c\u000e\u0003AR!!\r\u001a\u0002\u000f5,H/\u00192mK*\u00111'D\u0001\u000bG>dG.Z2uS>t\u0017BA\u001b1\u0005\u0015\tV/Z;f!\t9q'\u0003\u00029\u0005\ti!)\u0019;dQ6+G/\u00193bi\u0006D\u0001BO\u0011\u0003\u0002\u0003\u0006IAL\u0001\u000fE\u0006$8\r['fi\u0006$\u0017\r^1!\u0011!a\u0014E!a\u0001\n\u0003i\u0014!\u00049s_\u0012,8-\u001a:Fa>\u001c\u0007.F\u0001?!\taq(\u0003\u0002A\u001b\t)1\u000b[8si\"A!)\tBA\u0002\u0013\u00051)A\tqe>$WoY3s\u000bB|7\r[0%KF$\"\u0001R$\u0011\u00051)\u0015B\u0001$\u000e\u0005\u0011)f.\u001b;\t\u000f!\u000b\u0015\u0011!a\u0001}\u0005\u0019\u0001\u0010J\u0019\t\u0011)\u000b#\u0011!Q!\ny\na\u0002\u001d:pIV\u001cWM]#q_\u000eD\u0007\u0005\u0003\u0005MC\t\u0005\r\u0011\"\u0001\u0018\u0003A\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007\u000e\u0003\u0005OC\t\u0005\r\u0011\"\u0001P\u0003Q\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007n\u0018\u0013fcR\u0011A\t\u0015\u0005\b\u00116\u000b\t\u00111\u0001\u0019\u0011!\u0011\u0016E!A!B\u0013A\u0012!E2p_J$\u0017N\\1u_J,\u0005o\\2iA!AA+\tBA\u0002\u0013\u0005Q+A\u000bdkJ\u0014XM\u001c;Uq:4\u0015N]:u\u001f\u001a47/\u001a;\u0016\u0003Y\u00032\u0001D,'\u0013\tAVB\u0001\u0004PaRLwN\u001c\u0005\t5\u0006\u0012\t\u0019!C\u00017\u0006I2-\u001e:sK:$H\u000b\u001f8GSJ\u001cHo\u00144gg\u0016$x\fJ3r)\t!E\fC\u0004I3\u0006\u0005\t\u0019\u0001,\t\u0011y\u000b#\u0011!Q!\nY\u000bacY;se\u0016tG\u000f\u0016=o\r&\u00148\u000f^(gMN,G\u000f\t\u0005\u0006%\u0005\"\t\u0001\u0019\u000b\u0007A\u0005\u00147\rZ3\t\u000b\u0011z\u0006\u0019\u0001\u0014\t\u000b1z\u0006\u0019\u0001\u0018\t\u000bqz\u0006\u0019\u0001 \t\u000b1{\u0006\u0019\u0001\r\t\u000bQ{\u0006\u0019\u0001,\t\u000b\u001d\fC\u0011A\f\u0002\u0011\u0019L'o\u001d;TKFDQ![\u0011\u0005\u0002\u0015\n1BZ5sgR|eMZ:fi\")1.\tC\u0001/\u00059A.Y:u'\u0016\f\b\"B7\"\t\u0003)\u0013A\u00047bgR$\u0015\r^1PM\u001a\u001cX\r\u001e\u0005\u0006_\u0006\"\t!J\u0001\u000eY\u0006\u001cH\u000fV5nKN$\u0018-\u001c9\t\u000bE\fC\u0011A\f\u0002\u001f1\f7\u000f^(gMN,G\u000fR3mi\u0006DQa]\u0011\u0005\u0002Q\fq![:F[B$\u00180F\u0001v!\taa/\u0003\u0002x\u001b\t9!i\\8mK\u0006t\u0007\"B=\"\t\u0003Q\u0018\u0001C1eI\n\u000bGo\u00195\u0015\u000f\u0011[H0`@\u0002\u0004!)A\b\u001fa\u0001}!)1\u000e\u001fa\u00011!)a\u0010\u001fa\u0001M\u0005QA.Y:u\u001f\u001a47/\u001a;\t\r\u0005\u0005\u0001\u00101\u0001\u0019\u0003-ygMZ:fi\u0012+G\u000e^1\t\r\u0005\u0015\u0001\u00101\u0001'\u0003%!\u0018.\\3ti\u0006l\u0007\u000fC\u0004\u0002\n\u0005\"\t!a\u0003\u0002!5\f\u0017PY3Va\u0012\fG/Z#q_\u000eDGcA;\u0002\u000e!1A(a\u0002A\u0002yBq!!\u0005\"\t\u0013\t\u0019\"\u0001\tbI\u0012\u0014\u0015\r^2i\u001b\u0016$\u0018\rZ1uCR\u0019A)!\u0006\t\u000f\u0005]\u0011q\u0002a\u0001m\u0005)!-\u0019;dQ\"9\u00111D\u0011\u0005\u0002\u0005u\u0011AB;qI\u0006$X\rF\u0002E\u0003?Aq!!\t\u0002\u001a\u0001\u0007\u0001%A\u0005oKb$XI\u001c;ss\"9\u0011QE\u0011\u0005\u0002\u0005\u001d\u0012A\u0006:f[>4XMQ1uG\",7o\u00147eKJ$\u0006.\u00198\u0015\u0007\u0011\u000bI\u0003C\u0004\u0002,\u0005\r\u0002\u0019\u0001\u0014\u0002\r=4gm]3u\u0011\u001d\ty#\tC\u0001\u0003c\t!CZ5oI\u0012+\b\u000f\\5dCR,')\u0019;dQR!\u00111GA\u001b!\raqK\u000e\u0005\t\u0003/\ti\u00031\u0001\u00028A!\u0011\u0011HA'\u001b\t\tYD\u0003\u0003\u0002>\u0005}\u0012A\u0002:fG>\u0014HM\u0003\u0003\u0002B\u0005\r\u0013AB2p[6|gNC\u0002\u0006\u0003\u000bRA!a\u0012\u0002J\u00051\u0011\r]1dQ\u0016T!!a\u0013\u0002\u0007=\u0014x-\u0003\u0003\u0002P\u0005m\"a\u0003*fG>\u0014HMQ1uG\"Dq!a\u0015\"\t\u0003\t)&\u0001\fcCR\u001c\u0007nV5uQN+\u0017/^3oG\u0016\u0014\u0016M\\4f)\u0019\t\u0019$a\u0016\u0002Z!1q-!\u0015A\u0002aAaa[A)\u0001\u0004A\u0002bBA/C\u0011\u0005\u0013qL\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011\r\t\u0005\u0003G\n\tH\u0004\u0003\u0002f\u00055\u0004cAA4\u001b5\u0011\u0011\u0011\u000e\u0006\u0004\u0003W\u001a\u0012A\u0002\u001fs_>$h(C\u0002\u0002p5\ta\u0001\u0015:fI\u00164\u0017\u0002BA:\u0003k\u0012aa\u0015;sS:<'bAA8\u001b!)A%\ba\u0001M\u0001")
public class ProducerStateEntry {
    private final long producerId;
    private final Queue<BatchMetadata> batchMetadata;
    private short producerEpoch;
    private int coordinatorEpoch;
    private Option<Object> currentTxnFirstOffset;

    public static ProducerStateEntry empty(long l) {
        return ProducerStateEntry$.MODULE$.empty(l);
    }

    public long producerId() {
        return this.producerId;
    }

    public Queue<BatchMetadata> batchMetadata() {
        return this.batchMetadata;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public void producerEpoch_$eq(short x$1) {
        this.producerEpoch = x$1;
    }

    public int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    public void coordinatorEpoch_$eq(int x$1) {
        this.coordinatorEpoch = x$1;
    }

    public Option<Object> currentTxnFirstOffset() {
        return this.currentTxnFirstOffset;
    }

    public void currentTxnFirstOffset_$eq(Option<Object> x$1) {
        this.currentTxnFirstOffset = x$1;
    }

    public int firstSeq() {
        return this.isEmpty() ? -1 : ((BatchMetadata)this.batchMetadata().front()).firstSeq();
    }

    public long firstOffset() {
        return this.isEmpty() ? -1L : ((BatchMetadata)this.batchMetadata().front()).firstOffset();
    }

    public int lastSeq() {
        return this.isEmpty() ? -1 : ((BatchMetadata)this.batchMetadata().last()).lastSeq();
    }

    public long lastDataOffset() {
        return this.isEmpty() ? -1L : ((BatchMetadata)this.batchMetadata().last()).lastOffset();
    }

    public long lastTimestamp() {
        return this.isEmpty() ? -1L : ((BatchMetadata)this.batchMetadata().last()).timestamp();
    }

    public int lastOffsetDelta() {
        return this.isEmpty() ? 0 : ((BatchMetadata)this.batchMetadata().last()).offsetDelta();
    }

    public boolean isEmpty() {
        return this.batchMetadata().isEmpty();
    }

    public void addBatch(short producerEpoch, int lastSeq, long lastOffset, int offsetDelta, long timestamp) {
        this.maybeUpdateEpoch(producerEpoch);
        this.addBatchMetadata(new BatchMetadata(lastSeq, lastOffset, offsetDelta, timestamp));
    }

    public boolean maybeUpdateEpoch(short producerEpoch) {
        boolean bl;
        if (this.producerEpoch() != producerEpoch) {
            this.batchMetadata().clear();
            this.producerEpoch_$eq(producerEpoch);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private void addBatchMetadata(BatchMetadata batch) {
        Object object = this.batchMetadata().size() == ProducerStateEntry$.MODULE$.NumBatchesToRetain() ? this.batchMetadata().dequeue() : BoxedUnit.UNIT;
        this.batchMetadata().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BatchMetadata[]{batch}));
    }

    public void update(ProducerStateEntry nextEntry) {
        this.maybeUpdateEpoch(nextEntry.producerEpoch());
        while (nextEntry.batchMetadata().nonEmpty()) {
            this.addBatchMetadata((BatchMetadata)nextEntry.batchMetadata().dequeue());
        }
        this.coordinatorEpoch_$eq(nextEntry.coordinatorEpoch());
        this.currentTxnFirstOffset_$eq(nextEntry.currentTxnFirstOffset());
    }

    public void removeBatchesOlderThan(long offset) {
        this.batchMetadata().dropWhile((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ProducerStateEntry.$anonfun$removeBatchesOlderThan$1(offset, x$1)));
    }

    public Option<BatchMetadata> findDuplicateBatch(RecordBatch batch) {
        return batch.producerEpoch() != this.producerEpoch() ? None$.MODULE$ : this.batchWithSequenceRange(batch.baseSequence(), batch.lastSequence());
    }

    public Option<BatchMetadata> batchWithSequenceRange(int firstSeq, int lastSeq) {
        Queue duplicate = (Queue)this.batchMetadata().filter((Function1 & java.io.Serializable & Serializable)metadata -> BoxesRunTime.boxToBoolean((boolean)ProducerStateEntry.$anonfun$batchWithSequenceRange$1(firstSeq, lastSeq, metadata)));
        return duplicate.headOption();
    }

    public String toString() {
        return new StringBuilder(19).append("ProducerStateEntry(").append(new StringBuilder(13).append("producerId=").append(this.producerId()).append(", ").toString()).append(new StringBuilder(16).append("producerEpoch=").append(this.producerEpoch()).append(", ").toString()).append(new StringBuilder(24).append("currentTxnFirstOffset=").append(this.currentTxnFirstOffset()).append(", ").toString()).append(new StringBuilder(19).append("coordinatorEpoch=").append(this.coordinatorEpoch()).append(", ").toString()).append(new StringBuilder(14).append("batchMetadata=").append(this.batchMetadata()).toString()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$removeBatchesOlderThan$1(long offset$1, BatchMetadata x$1) {
        return x$1.lastOffset() < offset$1;
    }

    public static final /* synthetic */ boolean $anonfun$batchWithSequenceRange$1(int firstSeq$1, int lastSeq$1, BatchMetadata metadata) {
        return firstSeq$1 == metadata.firstSeq() && lastSeq$1 == metadata.lastSeq();
    }

    public ProducerStateEntry(long producerId, Queue<BatchMetadata> batchMetadata, short producerEpoch, int coordinatorEpoch, Option<Object> currentTxnFirstOffset) {
        this.producerId = producerId;
        this.batchMetadata = batchMetadata;
        this.producerEpoch = producerEpoch;
        this.coordinatorEpoch = coordinatorEpoch;
        this.currentTxnFirstOffset = currentTxnFirstOffset;
    }
}

