/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.net.InetAddress;
import kafka.network.TooManyConnectionsException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001M4A!\u0001\u0002\u0001\u000f\t\u00012i\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m\u001d\u0006\u0003\u0007\u0011\tqA\\3uo>\u00148NC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g\u0011!y\u0001A!b\u0001\n\u0003\u0001\u0012A\u00033fM\u0006,H\u000e^'bqV\t\u0011\u0003\u0005\u0002\n%%\u00111C\u0003\u0002\u0004\u0013:$\b\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0011B\t\u0002\u0017\u0011,g-Y;mi6\u000b\u0007\u0010\t\u0005\t/\u0001\u0011\t\u0011)A\u00051\u0005qqN^3se&$W-U;pi\u0006\u001c\b\u0003B\r\u001d=Ei\u0011A\u0007\u0006\u00037)\t!bY8mY\u0016\u001cG/[8o\u0013\ti\"DA\u0002NCB\u0004\"a\b\u0014\u000f\u0005\u0001\"\u0003CA\u0011\u000b\u001b\u0005\u0011#BA\u0012\u0007\u0003\u0019a$o\\8u}%\u0011QEC\u0001\u0007!J,G-\u001a4\n\u0005\u001dB#AB*ue&twM\u0003\u0002&\u0015!)!\u0006\u0001C\u0001W\u00051A(\u001b8jiz\"2\u0001\f\u00180!\ti\u0003!D\u0001\u0003\u0011\u0015y\u0011\u00061\u0001\u0012\u0011\u00159\u0012\u00061\u0001\u0019\u0011\u001d\t\u0004\u00011A\u0005\nA\t!\u0004Z3gCVdG/T1y\u0007>tg.Z2uS>t7\u000fU3s\u0013BDqa\r\u0001A\u0002\u0013%A'\u0001\u0010eK\u001a\fW\u000f\u001c;NCb\u001cuN\u001c8fGRLwN\\:QKJL\u0005o\u0018\u0013fcR\u0011Q\u0007\u000f\t\u0003\u0013YJ!a\u000e\u0006\u0003\tUs\u0017\u000e\u001e\u0005\bsI\n\t\u00111\u0001\u0012\u0003\rAH%\r\u0005\u0007w\u0001\u0001\u000b\u0015B\t\u00027\u0011,g-Y;mi6\u000b\u0007pQ8o]\u0016\u001cG/[8ogB+'/\u00139!Q\tQT\b\u0005\u0002\n}%\u0011qH\u0003\u0002\tm>d\u0017\r^5mK\"9\u0011\t\u0001a\u0001\n\u0013\u0011\u0015\u0001H7bq\u000e{gN\\3di&|gn\u001d)fe&\u0003xJ^3se&$Wm]\u000b\u0002\u0007B!\u0011\u0004\b#\u0012!\t)%*D\u0001G\u0015\t9\u0005*A\u0002oKRT\u0011!S\u0001\u0005U\u00064\u0018-\u0003\u0002L\r\nY\u0011J\\3u\u0003\u0012$'/Z:t\u0011\u001di\u0005\u00011A\u0005\n9\u000b\u0001%\\1y\u0007>tg.Z2uS>t7\u000fU3s\u0013B|e/\u001a:sS\u0012,7o\u0018\u0013fcR\u0011Qg\u0014\u0005\bs1\u000b\t\u00111\u0001D\u0011\u0019\t\u0006\u0001)Q\u0005\u0007\u0006iR.\u0019=D_:tWm\u0019;j_:\u001c\b+\u001a:Ja>3XM\u001d:jI\u0016\u001c\b\u0005\u000b\u0002Q{!9A\u000b\u0001b\u0001\n\u0013)\u0016AB2pk:$8/F\u0001W!\u00119&\fR\t\u000e\u0003aS!!\u0017\u000e\u0002\u000f5,H/\u00192mK&\u0011Q\u0004\u0017\u0005\u00079\u0002\u0001\u000b\u0011\u0002,\u0002\u000f\r|WO\u001c;tA!)a\f\u0001C\u0001?\u0006\u0019\u0011N\\2\u0015\u0005U\u0002\u0007\"B1^\u0001\u0004!\u0015aB1eIJ,7o\u001d\u0005\u0006G\u0002!\t\u0001Z\u0001\u001akB$\u0017\r^3NCb\u001cuN\u001c8fGRLwN\\:QKJL\u0005\u000f\u0006\u00026K\")aM\u0019a\u0001#\u0005\u0019R.\u0019=D_:tWm\u0019;j_:\u001c\b+\u001a:Ja\")\u0001\u000e\u0001C\u0001S\u0006\tS\u000f\u001d3bi\u0016l\u0015\r_\"p]:,7\r^5p]N\u0004VM]%q\u001fZ,'O]5eKR\u0011QG\u001b\u0005\u0006/\u001d\u0004\r\u0001\u0007\u0005\u0006Y\u0002!\t!\\\u0001\u0004I\u0016\u001cGCA\u001bo\u0011\u0015\t7\u000e1\u0001E\u0011\u0015\u0001\b\u0001\"\u0001r\u0003\r9W\r\u001e\u000b\u0003#IDQ!Y8A\u0002\u0011\u0003")
public class ConnectionQuotas {
    private final int defaultMax;
    private volatile int defaultMaxConnectionsPerIp;
    private volatile Map<InetAddress, Object> maxConnectionsPerIpOverrides;
    private final scala.collection.mutable.Map<InetAddress, Object> counts;

    public int defaultMax() {
        return this.defaultMax;
    }

    private int defaultMaxConnectionsPerIp() {
        return this.defaultMaxConnectionsPerIp;
    }

    private void defaultMaxConnectionsPerIp_$eq(int x$1) {
        this.defaultMaxConnectionsPerIp = x$1;
    }

    private Map<InetAddress, Object> maxConnectionsPerIpOverrides() {
        return this.maxConnectionsPerIpOverrides;
    }

    private void maxConnectionsPerIpOverrides_$eq(Map<InetAddress, Object> x$1) {
        this.maxConnectionsPerIpOverrides = x$1;
    }

    private scala.collection.mutable.Map<InetAddress, Object> counts() {
        return this.counts;
    }

    public void inc(InetAddress address) {
        scala.collection.mutable.Map<InetAddress, Object> map = this.counts();
        synchronized (map) {
            int count = BoxesRunTime.unboxToInt((Object)this.counts().getOrElseUpdate((Object)address, (Function0)(JFunction0.mcI.sp & java.io.Serializable & Serializable)() -> 0));
            this.counts().put((Object)address, (Object)BoxesRunTime.boxToInteger((int)(count + 1)));
            int max = BoxesRunTime.unboxToInt((Object)this.maxConnectionsPerIpOverrides().getOrElse((Object)address, (Function0)(JFunction0.mcI.sp & java.io.Serializable & Serializable)() -> this.defaultMaxConnectionsPerIp()));
            if (count >= max) {
                throw new TooManyConnectionsException(address, max);
            }
        }
    }

    public void updateMaxConnectionsPerIp(int maxConnectionsPerIp) {
        this.defaultMaxConnectionsPerIp_$eq(maxConnectionsPerIp);
    }

    public void updateMaxConnectionsPerIpOverride(Map<String, Object> overrideQuotas) {
        this.maxConnectionsPerIpOverrides_$eq((Map<InetAddress, Object>)((Map)overrideQuotas.map((Function1 & java.io.Serializable & Serializable)x0$6 -> {
            Tuple2 tuple2 = x0$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String host = (String)tuple2._1();
            int count = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)InetAddress.getByName(host), (Object)BoxesRunTime.boxToInteger((int)count));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom())));
    }

    public void dec(InetAddress address) {
        scala.collection.mutable.Map<InetAddress, Object> map = this.counts();
        synchronized (map) {
            int count = BoxesRunTime.unboxToInt((Object)this.counts().getOrElse((Object)address, (Function0 & java.io.Serializable & Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(81).append("Attempted to decrease connection count for address with no connections, address: ").append(address).toString());
            }));
            Option option = count == 1 ? this.counts().remove((Object)address) : this.counts().put((Object)address, (Object)BoxesRunTime.boxToInteger((int)(count - 1)));
        }
    }

    public int get(InetAddress address) {
        int n;
        scala.collection.mutable.Map<InetAddress, Object> map = this.counts();
        synchronized (map) {
            n = BoxesRunTime.unboxToInt((Object)this.counts().getOrElse((Object)address, (Function0)(JFunction0.mcI.sp & java.io.Serializable & Serializable)() -> 0));
        }
        return n;
    }

    public ConnectionQuotas(int defaultMax, Map<String, Object> overrideQuotas) {
        this.defaultMax = defaultMax;
        this.defaultMaxConnectionsPerIp = defaultMax;
        this.maxConnectionsPerIpOverrides = (Map)overrideQuotas.map((Function1 & java.io.Serializable & Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String host = (String)tuple2._1();
            int count = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)InetAddress.getByName(host), (Object)BoxesRunTime.boxToInteger((int)count));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        this.counts = (scala.collection.mutable.Map)scala.collection.mutable.Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

