/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.BrokerReconfigurable;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicClientQuotaCallback;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicConnectionQuota;
import kafka.server.DynamicListenerConfig;
import kafka.server.DynamicLogConfig;
import kafka.server.DynamicMetricsReporters;
import kafka.server.DynamicThreadPool;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.PasswordEncoder;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ListenerReconfigurable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\rUw!B\u0001\u0003\u0011\u00039\u0011a\u0005#z]\u0006l\u0017n\u0019\"s_.,'oQ8oM&<'BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005!IQ\"\u0001\u0002\u0007\u000b)\u0011\u0001\u0012A\u0006\u0003'\u0011Kh.Y7jG\n\u0013xn[3s\u0007>tg-[4\u0014\u0005%a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\rC\u0003\u0014\u0013\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002\u000f!Aa#\u0003b\u0001\n\u0003\u0011q#\u0001\fEs:\fW.[2TK\u000e,(/\u001b;z\u0007>tg-[4t+\u0005A\u0002cA\r\u001fA5\t!D\u0003\u0002\u001c9\u00059Q.\u001e;bE2,'BA\u000f\u000f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003?i\u00111aU3u!\t\tc%D\u0001#\u0015\t\u0019C%\u0001\u0003mC:<'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\t\u0012aa\u0015;sS:<\u0007BB\u0015\nA\u0003%\u0001$A\fEs:\fW.[2TK\u000e,(/\u001b;z\u0007>tg-[4tA!91&\u0003b\u0001\n\u00039\u0012!E!mY\u0012Kh.Y7jG\u000e{gNZ5hg\"1Q&\u0003Q\u0001\na\t!#\u00117m\tft\u0017-\\5d\u0007>tg-[4tA!9q&\u0003b\u0001\n\u00139\u0012\u0001\u0005)fe\n\u0013xn[3s\u0007>tg-[4t\u0011\u0019\t\u0014\u0002)A\u00051\u0005\t\u0002+\u001a:Ce>\\WM]\"p]\u001aLwm\u001d\u0011\t\u000fMJ!\u0019!C\u0005i\u0005AB*[:uK:,'/T3dQ\u0006t\u0017n]7D_:4\u0017nZ:\u0016\u0003U\u00022AN\u001c!\u001b\u0005a\u0012BA\u0010\u001d\u0011\u0019I\u0014\u0002)A\u0005k\u0005IB*[:uK:,'/T3dQ\u0006t\u0017n]7D_:4\u0017nZ:!\u0011\u001dY\u0014B1A\u0005\nQ\nQCU3m_\u0006$\u0017M\u00197f\r&dWmQ8oM&<7\u000f\u0003\u0004>\u0013\u0001\u0006I!N\u0001\u0017%\u0016dw.\u00193bE2,g)\u001b7f\u0007>tg-[4tA!9q(\u0003b\u0001\n\u0003\u0001\u0015a\u0005'jgR,g.\u001a:D_:4\u0017n\u001a*fO\u0016DX#A!\u0011\u0005\t;U\"A\"\u000b\u0005\u0011+\u0015\u0001C7bi\u000eD\u0017N\\4\u000b\u0005\u0019s\u0011\u0001B;uS2L!\u0001S\"\u0003\u000bI+w-\u001a=\t\r)K\u0001\u0015!\u0003B\u0003Qa\u0015n\u001d;f]\u0016\u00148i\u001c8gS\u001e\u0014VmZ3yA!9A*\u0003b\u0001\n\u00139\u0012A\u0006#z]\u0006l\u0017n\u0019)bgN<xN\u001d3D_:4\u0017nZ:\t\r9K\u0001\u0015!\u0003\u0019\u0003]!\u0015P\\1nS\u000e\u0004\u0016m]:x_J$7i\u001c8gS\u001e\u001c\b\u0005C\u0003Q\u0013\u0011\u0005\u0011+\u0001\tjgB\u000b7o]<pe\u0012\u001cuN\u001c4jOR\u0011!+\u0016\t\u0003\u001bMK!\u0001\u0016\b\u0003\u000f\t{w\u000e\\3b]\")ak\u0014a\u0001/\u0006!a.Y7f!\tAvL\u0004\u0002Z;B\u0011!LD\u0007\u00027*\u0011ALB\u0001\u0007yI|w\u000e\u001e \n\u0005ys\u0011A\u0002)sK\u0012,g-\u0003\u0002(A*\u0011aL\u0004\u0005\u0006E&!\taY\u0001\u0015EJ|7.\u001a:D_:4\u0017nZ*z]>t\u00170\\:\u0015\u0007\u0011lg\u000eE\u0002fU^s!A\u001a5\u000f\u0005i;\u0017\"A\b\n\u0005%t\u0011a\u00029bG.\fw-Z\u0005\u0003W2\u0014A\u0001T5ti*\u0011\u0011N\u0004\u0005\u0006-\u0006\u0004\ra\u0016\u0005\u0006_\u0006\u0004\rAU\u0001\u0016[\u0006$8\r\u001b'jgR,g.\u001a:Pm\u0016\u0014(/\u001b3f\u0011\u0015\t\u0018\u0002\"\u0001s\u0003=1\u0018\r\\5eCR,7i\u001c8gS\u001e\u001cHcA:w{B\u0011Q\u0002^\u0005\u0003k:\u0011A!\u00168ji\")q\u000f\u001da\u0001q\u0006)\u0001O]8qgB\u0011\u0011p_\u0007\u0002u*\u0011a\tJ\u0005\u0003yj\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u0015q\b\u000f1\u0001S\u0003=\u0001XM\u001d\"s_.,'oQ8oM&<\u0007bBA\u0001\u0013\u0011%\u00111A\u0001\u0011a\u0016\u0014(I]8lKJ\u001cuN\u001c4jON$B!!\u0002\u0002\bA\u0019agN,\t\u000b]|\b\u0019\u0001=\t\u000f\u0005-\u0011\u0002\"\u0003\u0002\u000e\u0005\tbn\u001c8Es:\fW.[2D_:4\u0017nZ:\u0015\t\u0005\u0015\u0011q\u0002\u0005\u0007o\u0006%\u0001\u0019\u0001=\t\u000f\u0005M\u0011\u0002\"\u0003\u0002\u0016\u0005!3/Z2ve&$\u0018pQ8oM&<7oV5uQ>,H\u000fT5ti\u0016tWM\u001d)sK\u001aL\u0007\u0010\u0006\u0003\u0002\u0006\u0005]\u0001BB<\u0002\u0012\u0001\u0007\u0001\u0010C\u0004\u0002\u001c%!I!!\b\u0002'Y\fG.\u001b3bi\u0016\u001cuN\u001c4jORK\b/Z:\u0015\u0007M\fy\u0002\u0003\u0004x\u00033\u0001\r\u0001\u001f\u0005\t\u0003GIA\u0011\u0001\u0002\u0002&\u0005\t\u0012\r\u001a3Es:\fW.[2D_:4\u0017nZ:\u0015\u0007M\f9\u0003\u0003\u0005\u0002*\u0005\u0005\u0002\u0019AA\u0016\u0003%\u0019wN\u001c4jO\u0012+g\r\u0005\u0003\u0002.\u0005\u0005SBAA\u0018\u0015\u0011\t\t$a\r\u0002\r\r|gNZ5h\u0015\u0011\t)$a\u000e\u0002\r\r|W.\\8o\u0015\r)\u0011\u0011\b\u0006\u0005\u0003w\ti$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u007f\t1a\u001c:h\u0013\u0011\t\u0019%a\f\u0003\u0013\r{gNZ5h\t\u00164\u0007\u0002CA$\u0013\u0011\u0005!!!\u0013\u00021\u0011Lh.Y7jG\u000e{gNZ5h+B$\u0017\r^3N_\u0012,7/\u0006\u0002\u0002LA)\u00110!\u0014X/&\u0019\u0011q\n>\u0003\u00075\u000b\u0007OB\u0003\u000b\u0005\u0001\t\u0019fE\u0003\u0002R1\t)\u0006\u0005\u0003\u0002X\u0005uSBAA-\u0015\r\tY\u0006B\u0001\u0006kRLGn]\u0005\u0005\u0003?\nIFA\u0004M_\u001e<\u0017N\\4\t\u0017\u0005\r\u0014\u0011\u000bBC\u0002\u0013%\u0011QM\u0001\fW\u000647.Y\"p]\u001aLw-\u0006\u0002\u0002hA\u0019\u0001\"!\u001b\n\u0007\u0005-$AA\u0006LC\u001a\\\u0017mQ8oM&<\u0007bCA8\u0003#\u0012\t\u0011)A\u0005\u0003O\nAb[1gW\u0006\u001cuN\u001c4jO\u0002BqaEA)\t\u0003\t\u0019\b\u0006\u0003\u0002v\u0005]\u0004c\u0001\u0005\u0002R!A\u00111MA9\u0001\u0004\t9\u0007C\u0006\u0002|\u0005E#\u0019!C\u0001\u0005\u0005u\u0014aE:uCRL7M\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001cXCAA@!\u0015I\u0012\u0011\u0011\u0011!\u0013\r\tyE\u0007\u0005\n\u0003\u000b\u000b\t\u0006)A\u0005\u0003\u007f\nAc\u001d;bi&\u001c'I]8lKJ\u001cuN\u001c4jON\u0004\u0003bCAE\u0003#\u0012\r\u0011\"\u0001\u0003\u0003{\nAc\u001d;bi&\u001cG)\u001a4bk2$8i\u001c8gS\u001e\u001c\b\"CAG\u0003#\u0002\u000b\u0011BA@\u0003U\u0019H/\u0019;jG\u0012+g-Y;mi\u000e{gNZ5hg\u0002B!\"!%\u0002R\t\u0007I\u0011BAJ\u0003Q!\u0017P\\1nS\u000e\u0014%o\\6fe\u000e{gNZ5hgV\u0011\u0011Q\u0013\t\u00063\u0005\u0005uk\u0016\u0005\n\u00033\u000b\t\u0006)A\u0005\u0003+\u000bQ\u0003Z=oC6L7M\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001c\b\u0005\u0003\u0006\u0002\u001e\u0006E#\u0019!C\u0005\u0003'\u000bQ\u0003Z=oC6L7\rR3gCVdGoQ8oM&<7\u000fC\u0005\u0002\"\u0006E\u0003\u0015!\u0003\u0002\u0016\u00061B-\u001f8b[&\u001cG)\u001a4bk2$8i\u001c8gS\u001e\u001c\b\u0005\u0003\u0006\u0002&\u0006E#\u0019!C\u0005\u0003O\u000bqB]3d_:4\u0017nZ;sC\ndWm]\u000b\u0003\u0003S\u0003R!GAV\u0003_K1!!,\u001b\u0005\u0019\u0011UO\u001a4feB!\u0011\u0011WAZ\u001b\t\t\u0019$\u0003\u0003\u00026\u0006M\"A\u0004*fG>tg-[4ve\u0006\u0014G.\u001a\u0005\n\u0003s\u000b\t\u0006)A\u0005\u0003S\u000b\u0001C]3d_:4\u0017nZ;sC\ndWm\u001d\u0011\t\u0015\u0005u\u0016\u0011\u000bb\u0001\n\u0013\ty,A\u000bce>\\WM\u001d*fG>tg-[4ve\u0006\u0014G.Z:\u0016\u0005\u0005\u0005\u0007#B\r\u0002,\u0006\r\u0007c\u0001\u0005\u0002F&\u0019\u0011q\u0019\u0002\u0003)\t\u0013xn[3s%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0011%\tY-!\u0015!\u0002\u0013\t\t-\u0001\fce>\\WM\u001d*fG>tg-[4ve\u0006\u0014G.Z:!\u0011)\ty-!\u0015C\u0002\u0013%\u0011\u0011[\u0001\u0005Y>\u001c7.\u0006\u0002\u0002TB!\u0011Q[Ap\u001b\t\t9N\u0003\u0003\u0002Z\u0006m\u0017!\u00027pG.\u001c(bAAou\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005\u0005\u0018q\u001b\u0002\u0017%\u0016,g\u000e\u001e:b]R\u0014V-\u00193Xe&$X\rT8dW\"I\u0011Q]A)A\u0003%\u00111[\u0001\u0006Y>\u001c7\u000e\t\u0005\u000b\u0003S\f\t\u00061A\u0005\n\u0005\u0015\u0014!D2veJ,g\u000e^\"p]\u001aLw\r\u0003\u0006\u0002n\u0006E\u0003\u0019!C\u0005\u0003_\f\u0011cY;se\u0016tGoQ8oM&<w\fJ3r)\r\u0019\u0018\u0011\u001f\u0005\u000b\u0003g\fY/!AA\u0002\u0005\u001d\u0014a\u0001=%c!I\u0011q_A)A\u0003&\u0011qM\u0001\u000fGV\u0014(/\u001a8u\u0007>tg-[4!\u0011)\tY0!\u0015C\u0002\u0013%\u0011Q`\u0001\u001dIft\u0017-\\5d\u0007>tg-[4QCN\u001cxo\u001c:e\u000b:\u001cw\u000eZ3s+\t\ty\u0010E\u0003\u000e\u0005\u0003\u0011)!C\u0002\u0003\u00049\u0011aa\u00149uS>t\u0007\u0003BA,\u0005\u000fIAA!\u0003\u0002Z\ty\u0001+Y:to>\u0014H-\u00128d_\u0012,'\u000fC\u0005\u0003\u000e\u0005E\u0003\u0015!\u0003\u0002\u0000\u0006iB-\u001f8b[&\u001c7i\u001c8gS\u001e\u0004\u0016m]:x_J$WI\\2pI\u0016\u0014\b\u0005C\u0005\u0003\u0012\u0005EC\u0011\u0001\u0002\u0003\u0014\u0005Q\u0011N\\5uS\u0006d\u0017N_3\u0015\u0007M\u0014)\u0002\u0003\u0005\u0003\u0018\t=\u0001\u0019\u0001B\r\u0003!Q8n\u00117jK:$\b\u0003\u0002B\u000e\u0005Ci!A!\b\u000b\u0007\t}A!\u0001\u0002{W&!!1\u0005B\u000f\u00055Y\u0015MZ6b5.\u001cE.[3oi\"I!qEA)\t\u0003\u0011!\u0011F\u0001\u0006G2,\u0017M\u001d\u000b\u0002g\"A!QFA)\t\u0003\u0011y#\u0001\nbI\u0012\u0014VmY8oM&<WO]1cY\u0016\u001cHcA:\u00032!A!1\u0007B\u0016\u0001\u0004\u0011)$A\u0006lC\u001a\\\u0017mU3sm\u0016\u0014\bc\u0001\u0005\u00038%\u0019!\u0011\b\u0002\u0003\u0017-\u000bgm[1TKJ4XM\u001d\u0005\t\u0005{\t\t\u0006\"\u0001\u0003@\u0005\t\u0012\r\u001a3SK\u000e|gNZ5hkJ\f'\r\\3\u0015\u0007M\u0014\t\u0005\u0003\u0005\u0003D\tm\u0002\u0019AAX\u00039\u0011XmY8oM&<WO]1cY\u0016D\u0001Ba\u0012\u0002R\u0011\u0005!\u0011J\u0001\u0018C\u0012$'I]8lKJ\u0014VmY8oM&<WO]1cY\u0016$2a\u001dB&\u0011!\u0011\u0019E!\u0012A\u0002\u0005\r\u0007\u0002\u0003B(\u0003#\"\tA!\u0015\u0002)I,Wn\u001c<f%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f)\r\u0019(1\u000b\u0005\t\u0005\u0007\u0012i\u00051\u0001\u00020\"A!qKA)\t\u0013\u0011I&A\u000ewKJLg-\u001f*fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm\u001d\u000b\u0004g\nm\u0003\u0002\u0003B/\u0005+\u0002\r!!\u0002\u0002\u0017\r|gNZ5h\u001d\u0006lWm\u001d\u0005\n\u0005C\n\t\u0006\"\u0001\u0003\u0003K\n!cY;se\u0016tGoS1gW\u0006\u001cuN\u001c4jO\"I!QMA)\t\u0003\u0011!qM\u0001\u001cGV\u0014(/\u001a8u\tft\u0017-\\5d\u0005J|7.\u001a:D_:4\u0017nZ:\u0016\u0005\t%\u0004#\u0002\u001c\u0003l];\u0016bAA(9!I!qNA)\t\u0003\u0011!qM\u0001\u001dGV\u0014(/\u001a8u\tft\u0017-\\5d\t\u00164\u0017-\u001e7u\u0007>tg-[4t\u0011%\u0011\u0019(!\u0015\u0005\u0002\t\u0011)(\u0001\nva\u0012\fG/\u001a\"s_.,'oQ8oM&<G#B:\u0003x\t\u0005\u0005\u0002\u0003B=\u0005c\u0002\rAa\u001f\u0002\u0011\t\u0014xn[3s\u0013\u0012\u00042!\u0004B?\u0013\r\u0011yH\u0004\u0002\u0004\u0013:$\bb\u0002BB\u0005c\u0002\r\u0001_\u0001\u0010a\u0016\u00148/[:uK:$\bK]8qg\"I!qQA)\t\u0003\u0011!\u0011R\u0001\u0014kB$\u0017\r^3EK\u001a\fW\u000f\u001c;D_:4\u0017n\u001a\u000b\u0004g\n-\u0005b\u0002BB\u0005\u000b\u0003\r\u0001\u001f\u0005\n\u0005\u001f\u000b\t\u0006\"\u0001\u0003\u0005#\u000bQE]3m_\u0006$W\u000b\u001d3bi\u0016$g)\u001b7fg^KG\u000f[8vi\u000e{gNZ5h\u0007\"\fgnZ3\u0015\u0007M\u0014\u0019\nC\u0004\u0003\u0016\n5\u0005\u0019\u0001=\u0002\u00119,w\u000f\u0015:paND\u0001B!'\u0002R\u0011%!1T\u0001\u001b[\u0006L(-Z\"sK\u0006$X\rU1tg^|'\u000fZ#oG>$WM\u001d\u000b\u0005\u0003\u007f\u0014i\n\u0003\u0005\u0003 \n]\u0005\u0019\u0001BQ\u0003\u0019\u0019Xm\u0019:fiB)QB!\u0001\u0003$B!!Q\u0015BV\u001b\t\u00119K\u0003\u0003\u0003*\u0006=\u0012!\u0002;za\u0016\u001c\u0018\u0002\u0002BW\u0005O\u0013\u0001\u0002U1tg^|'\u000f\u001a\u0005\t\u0005c\u000b\t\u0006\"\u0003\u00034\u0006y\u0001/Y:to>\u0014H-\u00128d_\u0012,'/\u0006\u0002\u0003\u0006!I!qWA)\t\u0003\u0011!\u0011X\u0001\u0012i>\u0004VM]:jgR,g\u000e\u001e)s_B\u001cH#\u0002=\u0003<\n}\u0006b\u0002B_\u0005k\u0003\r\u0001_\u0001\fG>tg-[4Qe>\u00048\u000f\u0003\u0004\u007f\u0005k\u0003\rA\u0015\u0005\n\u0005\u0007\f\t\u0006\"\u0001\u0003\u0005\u000b\f1C\u001a:p[B+'o]5ti\u0016tG\u000f\u0015:paN$R\u0001\u001fBd\u0005\u0013DqAa!\u0003B\u0002\u0007\u0001\u0010\u0003\u0004\u007f\u0005\u0003\u0004\rA\u0015\u0005\t\u0005\u001b\f\t\u0006\"\u0003\u0003P\u00061R.Y=cKJ+WI\\2pI\u0016\u0004\u0016m]:x_J$7\u000fF\u0003y\u0005#\u0014\u0019\u000eC\u0004\u0003\u0004\n-\u0007\u0019\u0001=\t\u0011\tU'1\u001aa\u0001\u0005/\fQ\"\u00193nS:T6n\u00117jK:$\b\u0003\u0002B\u000e\u00053LAAa7\u0003\u001e\ti\u0011\tZ7j]j[7\t\\5f]RD\u0001Ba8\u0002R\u0011%!\u0011]\u0001\u0014m\u0006d\u0017\u000eZ1uK\u0012\\\u0015MZ6b!J|\u0007o\u001d\u000b\u0007\u0005S\u0012\u0019Oa:\t\u000f\t\u0015(Q\u001ca\u0001q\u0006i\u0001O]8qg>3XM\u001d:jI\u0016DaA Bo\u0001\u0004\u0011\u0006\"\u0003Bv\u0003#\"\tA\u0001Bw\u0003!1\u0018\r\\5eCR,G#B:\u0003p\nE\bBB<\u0003j\u0002\u0007\u0001\u0010\u0003\u0004\u007f\u0005S\u0004\rA\u0015\u0005\t\u0005k\f\t\u0006\"\u0003\u0003x\u0006!\"/Z7pm\u0016LeN^1mS\u0012\u001cuN\u001c4jON$Ra\u001dB}\u0005wDaa\u001eBz\u0001\u0004A\bB\u0002@\u0003t\u0002\u0007!\u000bC\u0005\u0003\u0000\u0006EC\u0011\u0001\u0002\u0004\u0002\u0005\u0001R.Y=cKJ+7m\u001c8gS\u001e,(/\u001a\u000b\bg\u000e\r1QAB\u0005\u0011!\u0011\u0019E!@A\u0002\u0005=\u0006\u0002CB\u0004\u0005{\u0004\r!a\u001a\u0002\u0013=dGmQ8oM&<\u0007\u0002CB\u0006\u0005{\u0004\ra!\u0004\u0002\u00139,woQ8oM&<\u0007\u0007BB\b\u0007+\u0001b!_A'/\u000eE\u0001\u0003BB\n\u0007+a\u0001\u0001\u0002\u0007\u0004\u0018\r%\u0011\u0011!A\u0001\u0006\u0003\u0019IBA\u0002`IE\nBaa\u0007\u0004\"A\u0019Qb!\b\n\u0007\r}aBA\u0004O_RD\u0017N\\4\u0011\u00075\u0019\u0019#C\u0002\u0004&9\u00111!\u00118z\u0011!\u0019I#!\u0015\u0005\n\r-\u0012AD;qI\u0006$X\rZ\"p]\u001aLwm\u001d\u000b\u0007\u0007[\u00199da\u00111\t\r=21\u0007\t\u00073\u0005\u0005uk!\r\u0011\t\rM11\u0007\u0003\r\u0007k\u00199#!A\u0001\u0002\u000b\u00051\u0011\u0004\u0002\u0004?\u0012*\u0004\u0002\u0003BK\u0007O\u0001\ra!\u000f1\t\rm2q\b\t\u0007s\u00065sk!\u0010\u0011\t\rM1q\b\u0003\r\u0007\u0003\u001a9$!A\u0001\u0002\u000b\u00051\u0011\u0004\u0002\u0004?\u0012\u0012\u0004\u0002CB#\u0007O\u0001\raa\u0012\u0002\u0019\r,(O]3oiB\u0013x\u000e]:1\r\r%3QJB*!\u001dI\u0018QJB&\u0007#\u0002Baa\u0005\u0004N\u0011a1qJB\"\u0003\u0003\u0005\tQ!\u0001\u0004\u001a\t\u0019q\fJ\u001a\u0011\t\rM11\u000b\u0003\r\u0007+\u001a\u0019%!A\u0001\u0002\u000b\u00051\u0011\u0004\u0002\u0004?\u0012\"\u0004\u0002CB-\u0003#\"Iaa\u0017\u0002\u001b=4XM\u001d:jI\u0016\u0004&o\u001c9t)\u0015\u00198QLB0\u0011\u001d98q\u000ba\u0001\u0003+C\u0001B!:\u0004X\u0001\u0007\u0011Q\u0013\u0005\t\u0007G\n\t\u0006\"\u0003\u0003*\u0005\u0019R\u000f\u001d3bi\u0016\u001cUO\u001d:f]R\u001cuN\u001c4jO\"A1qMA)\t\u0013\u0019I'\u0001\fqe>\u001cWm]:SK\u000e|gNZ5hkJ\fG/[8o)\u0019\u0019Yga\u001d\u0004vA9Qb!\u001c\u0002h\rE\u0014bAB8\u001d\t1A+\u001e9mKJ\u0002B!\u001a6\u0002D\"A!QSB3\u0001\u0004\u0011I\u0007C\u0004\u0004x\r\u0015\u0004\u0019\u0001*\u0002\u0019Y\fG.\u001b3bi\u0016|e\u000e\\=\t\u0011\rm\u0014\u0011\u000bC\u0005\u0007{\nAC\\3fIN\u0014VmY8oM&<WO]1uS>tG#\u0002*\u0004\u0000\r\u001d\u0005\u0002CBA\u0007s\u0002\raa!\u0002+I,7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hgB!\u0011p!\"X\u0013\ty\"\u0010\u0003\u0005\u0004\n\u000ee\u0004\u0019AA\u0003\u0003-)\b\u000fZ1uK\u0012\\U-_:\t\u0011\r5\u0015\u0011\u000bC\u0005\u0007\u001f\u000bQ\u0004\u001d:pG\u0016\u001c8\u000fT5ti\u0016tWM\u001d*fG>tg-[4ve\u0006\u0014G.\u001a\u000b\fg\u000eE5\u0011UBR\u0007_\u001b\t\f\u0003\u0005\u0004\u0014\u000e-\u0005\u0019ABK\u0003Ya\u0017n\u001d;f]\u0016\u0014(+Z2p]\u001aLw-\u001e:bE2,\u0007\u0003BBL\u0007;k!a!'\u000b\t\rm\u00151G\u0001\b]\u0016$xo\u001c:l\u0013\u0011\u0019yj!'\u0003-1K7\u000f^3oKJ\u0014VmY8oM&<WO]1cY\u0016D\u0001ba\u0003\u0004\f\u0002\u0007\u0011q\r\u0005\t\u0007K\u001bY\t1\u0001\u0004(\u0006i1-^:u_6\u001cuN\u001c4jON\u0004b!_A'/\u000e%\u0006cA\u0011\u0004,&\u00191Q\u0016\u0012\u0003\r=\u0013'.Z2u\u0011\u001d\u00199ha#A\u0002ICqaa-\u0004\f\u0002\u0007!+\u0001\u0006sK2|\u0017\rZ(oYfD\u0001ba.\u0002R\u0011%1\u0011X\u0001\u0016aJ|7-Z:t%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f)-\u001981XB_\u0007\u0003\u001cyma5\t\u0011\t\r3Q\u0017a\u0001\u0003_C\u0001ba0\u00046\u0002\u0007\u0011QA\u0001\u0013kB$\u0017\r^3e\u0007>tg-[4OC6,7\u000f\u0003\u0005\u0004D\u000eU\u0006\u0019ABc\u00035\tG\u000e\u001c(fo\u000e{gNZ5hgB\"1qYBf!\u0019I\u0018QJ,\u0004JB!11CBf\t1\u0019im!1\u0002\u0002\u0003\u0005)\u0011AB\r\u0005\ryFE\u000e\u0005\t\u0007#\u001c)\f1\u0001\u0004(\u0006\u0001b.Z<DkN$x.\\\"p]\u001aLwm\u001d\u0005\b\u0007o\u001a)\f1\u0001S\u0001")
public class DynamicBrokerConfig
implements Logging {
    private final KafkaConfig kafkaConfig;
    private final scala.collection.mutable.Map<String, String> staticBrokerConfigs;
    private final scala.collection.mutable.Map<String, String> staticDefaultConfigs;
    private final scala.collection.mutable.Map<String, String> dynamicBrokerConfigs;
    private final scala.collection.mutable.Map<String, String> dynamicDefaultConfigs;
    private final Buffer<Reconfigurable> reconfigurables;
    private final Buffer<BrokerReconfigurable> brokerReconfigurables;
    private final ReentrantReadWriteLock lock;
    private KafkaConfig currentConfig;
    private final Option<PasswordEncoder> dynamicConfigPasswordEncoder;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void validateConfigs(Properties properties, boolean bl) {
        DynamicBrokerConfig$.MODULE$.validateConfigs(properties, bl);
    }

    public static List<String> brokerConfigSynonyms(String string, boolean bl) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(string, bl);
    }

    public static boolean isPasswordConfig(String string) {
        return DynamicBrokerConfig$.MODULE$.isPasswordConfig(string);
    }

    public static Regex ListenerConfigRegex() {
        return DynamicBrokerConfig$.MODULE$.ListenerConfigRegex();
    }

    public static scala.collection.mutable.Set<String> AllDynamicConfigs() {
        return DynamicBrokerConfig$.MODULE$.AllDynamicConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        DynamicBrokerConfig dynamicBrokerConfig = this;
        synchronized (dynamicBrokerConfig) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig kafkaConfig() {
        return this.kafkaConfig;
    }

    public scala.collection.mutable.Map<String, String> staticBrokerConfigs() {
        return this.staticBrokerConfigs;
    }

    public scala.collection.mutable.Map<String, String> staticDefaultConfigs() {
        return this.staticDefaultConfigs;
    }

    private scala.collection.mutable.Map<String, String> dynamicBrokerConfigs() {
        return this.dynamicBrokerConfigs;
    }

    private scala.collection.mutable.Map<String, String> dynamicDefaultConfigs() {
        return this.dynamicDefaultConfigs;
    }

    private Buffer<Reconfigurable> reconfigurables() {
        return this.reconfigurables;
    }

    private Buffer<BrokerReconfigurable> brokerReconfigurables() {
        return this.brokerReconfigurables;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private KafkaConfig currentConfig() {
        return this.currentConfig;
    }

    private void currentConfig_$eq(KafkaConfig x$1) {
        this.currentConfig = x$1;
    }

    private Option<PasswordEncoder> dynamicConfigPasswordEncoder() {
        return this.dynamicConfigPasswordEncoder;
    }

    public void initialize(KafkaZkClient zkClient) {
        this.currentConfig_$eq(new KafkaConfig(this.kafkaConfig().props(), false, (Option<DynamicBrokerConfig>)None$.MODULE$));
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        this.updateDefaultConfig(adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), ConfigEntityName$.MODULE$.Default()));
        Properties props = adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger((int)this.kafkaConfig().brokerId())).toString());
        Properties brokerConfig = this.maybeReEncodePasswords(props, adminZkClient);
        this.updateBrokerConfig(this.kafkaConfig().brokerId(), brokerConfig);
    }

    public void clear() {
        this.dynamicBrokerConfigs().clear();
        this.dynamicDefaultConfigs().clear();
        this.reconfigurables().clear();
        this.brokerReconfigurables().clear();
    }

    public void addReconfigurables(KafkaServer kafkaServer) {
        this.addBrokerReconfigurable(new DynamicThreadPool(kafkaServer));
        if (kafkaServer.logManager().cleaner() != null) {
            this.addBrokerReconfigurable(kafkaServer.logManager().cleaner());
        }
        this.addReconfigurable(new DynamicLogConfig(kafkaServer.logManager(), kafkaServer));
        this.addReconfigurable(new DynamicMetricsReporters(this.kafkaConfig().brokerId(), kafkaServer));
        this.addReconfigurable(new DynamicClientQuotaCallback(this.kafkaConfig().brokerId(), kafkaServer));
        this.addBrokerReconfigurable(new DynamicListenerConfig(kafkaServer));
        this.addBrokerReconfigurable(new DynamicConnectionQuota(kafkaServer));
    }

    public void addReconfigurable(Reconfigurable reconfigurable) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            this.verifyReconfigurableConfigs((Set<String>)((Set)JavaConverters$.MODULE$.asScalaSetConverter(reconfigurable.reconfigurableConfigs()).asScala()));
            return this.reconfigurables().$plus$eq((Object)reconfigurable);
        });
    }

    public void addBrokerReconfigurable(BrokerReconfigurable reconfigurable) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            this.verifyReconfigurableConfigs(reconfigurable.reconfigurableConfigs());
            return this.brokerReconfigurables().$plus$eq((Object)reconfigurable);
        });
    }

    public void removeReconfigurable(Reconfigurable reconfigurable) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.reconfigurables().$minus$eq((Object)reconfigurable));
    }

    private void verifyReconfigurableConfigs(Set<String> configNames) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Set nonDynamic = (Set)configNames.filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$verifyReconfigurableConfigs$2(elem)));
            Predef$.MODULE$.require(nonDynamic.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Reconfigurable contains non-dynamic configs ").append(nonDynamic).toString());
        });
    }

    public KafkaConfig currentKafkaConfig() {
        return (KafkaConfig)((Object)CoreUtils$.MODULE$.inReadLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.currentConfig()));
    }

    public Map<String, String> currentDynamicBrokerConfigs() {
        return (Map)CoreUtils$.MODULE$.inReadLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.dynamicBrokerConfigs().clone());
    }

    public Map<String, String> currentDynamicDefaultConfigs() {
        return (Map)CoreUtils$.MODULE$.inReadLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.dynamicDefaultConfigs().clone());
    }

    public void updateBrokerConfig(int brokerId, Properties persistentProps) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try {
                Properties props = this.fromPersistentProps(persistentProps, true);
                this.dynamicBrokerConfigs().clear();
                this.dynamicBrokerConfigs().$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala());
                this.updateCurrentConfig();
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Per-broker configs of ").append(brokerId).append(" could not be applied: ").append(persistentProps).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            }
        });
    }

    public void updateDefaultConfig(Properties persistentProps) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try {
                Properties props = this.fromPersistentProps(persistentProps, false);
                this.dynamicDefaultConfigs().clear();
                this.dynamicDefaultConfigs().$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala());
                this.updateCurrentConfig();
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Cluster default configs could not be applied: ").append(persistentProps).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            }
        });
    }

    public void reloadUpdatedFilesWithoutConfigChange(Properties newProps) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)this.reconfigurables().filter((Function1 & Serializable & scala.Serializable)reconfigurable -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$2(reconfigurable)))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$4(this, newProps, x0$2);
            return BoxedUnit.UNIT;
        }));
    }

    private Option<PasswordEncoder> maybeCreatePasswordEncoder(Option<Password> secret2) {
        return secret2.map((Function1 & Serializable & scala.Serializable)secret -> new PasswordEncoder((Password)secret, this.kafkaConfig().passwordEncoderKeyFactoryAlgorithm(), this.kafkaConfig().passwordEncoderCipherAlgorithm(), Predef$.MODULE$.Integer2int(this.kafkaConfig().passwordEncoderKeyLength()), Predef$.MODULE$.Integer2int(this.kafkaConfig().passwordEncoderIterations())));
    }

    private PasswordEncoder passwordEncoder() {
        return (PasswordEncoder)this.dynamicConfigPasswordEncoder().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ConfigException("Password encoder secret not configured");
        });
    }

    /*
     * WARNING - void declaration
     */
    public Properties toPersistentProps(Properties configProps, boolean perBrokerConfig) {
        void var3_3;
        Properties props = (Properties)configProps.clone();
        ((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(configProps).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name))).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            DynamicBrokerConfig.$anonfun$toPersistentProps$2(this, perBrokerConfig, props, x0$3);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Properties fromPersistentProps(Properties persistentProps, boolean perBrokerConfig) {
        void var3_3;
        Properties props = (Properties)persistentProps.clone();
        this.removeInvalidConfigs(props, perBrokerConfig);
        this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$nonDynamicConfigs(props), "Non-dynamic configs configured in ZooKeeper will be ignored", props);
        this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$securityConfigsWithoutListenerPrefix(props), "Security configs can be dynamically updated only using listener prefix, base configs will be ignored", props);
        if (!perBrokerConfig) {
            this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$perBrokerConfigs(props), "Per-broker configs defined at default cluster level will be ignored", props);
        }
        ((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name))).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
            DynamicBrokerConfig.$anonfun$fromPersistentProps$6(this, props, x0$4);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Properties maybeReEncodePasswords(Properties persistentProps, AdminZkClient adminZkClient) {
        void var3_3;
        block0: {
            Properties props = (Properties)persistentProps.clone();
            if (!((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).keySet().exists((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)))) break block0;
            this.maybeCreatePasswordEncoder(this.kafkaConfig().passwordEncoderOldSecret()).foreach((Function1 & Serializable & scala.Serializable)passwordDecoder -> {
                DynamicBrokerConfig.$anonfun$maybeReEncodePasswords$2(this, persistentProps, adminZkClient, props, passwordDecoder);
                return BoxedUnit.UNIT;
            });
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, String> validatedKafkaProps(Properties propsOverride, boolean perBrokerConfig) {
        void var3_3;
        DynamicBrokerConfig$.MODULE$.validateConfigs(propsOverride, perBrokerConfig);
        scala.collection.mutable.Map newProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        newProps.$plus$plus$eq(this.staticBrokerConfigs());
        if (perBrokerConfig) {
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicDefaultConfigs());
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)((scala.collection.mutable.Map)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(propsOverride).asScala()));
        } else {
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)((scala.collection.mutable.Map)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(propsOverride).asScala()));
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicBrokerConfigs());
        }
        return var3_3;
    }

    public void validate(Properties props, boolean perBrokerConfig) {
        CoreUtils$.MODULE$.inReadLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            Map<String, String> newProps = this.validatedKafkaProps(props, perBrokerConfig);
            return this.processReconfiguration(newProps, true);
        });
    }

    private void removeInvalidConfigs(Properties props, boolean perBrokerConfig) {
        try {
            DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props);
            JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala();
        }
        catch (Exception e) {
            scala.collection.mutable.Map invalidProps = (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$6 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$removeInvalidConfigs$1(x0$6)));
            invalidProps.foreach((Function1 & Serializable & scala.Serializable)x$1 -> props.remove(x$1));
            String configSource = perBrokerConfig ? "broker" : "default cluster";
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Dynamic ").append(configSource).append(" config contains invalid values: ").append(invalidProps).append(", these configs will be ignored").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
    }

    public void maybeReconfigure(Reconfigurable reconfigurable, KafkaConfig oldConfig, java.util.Map<String, ?> newConfig) {
        block0: {
            if (!((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(reconfigurable.reconfigurableConfigs()).asScala()).exists((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$maybeReconfigure$1(oldConfig, newConfig, key)))) break block0;
            reconfigurable.reconfigure(newConfig);
        }
    }

    private scala.collection.mutable.Map<String, ?> updatedConfigs(java.util.Map<String, ?> newProps, java.util.Map<?, ?> currentProps) {
        return (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(newProps).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$7 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$updatedConfigs$1(currentProps, x0$7)));
    }

    private void overrideProps(scala.collection.mutable.Map<String, String> props, scala.collection.mutable.Map<String, String> propsOverride) {
        propsOverride.foreach((Function1 & Serializable & scala.Serializable)x0$8 -> {
            Tuple2 tuple2 = x0$8;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(k, false).foreach((Function1 & Serializable & scala.Serializable)key -> props.remove(key));
            Option option = props.put((Object)k, (Object)v);
            return option;
        });
    }

    private void updateCurrentConfig() {
        block1: {
            scala.collection.mutable.Map newProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            newProps.$plus$plus$eq(this.staticBrokerConfigs());
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicDefaultConfigs());
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicBrokerConfigs());
            KafkaConfig oldConfig = this.currentConfig();
            Tuple2<KafkaConfig, List<BrokerReconfigurable>> tuple2 = this.processReconfiguration((Map<String, String>)newProps, false);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            KafkaConfig newConfig = (KafkaConfig)((Object)tuple2._1());
            List brokerReconfigurablesToUpdate = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)newConfig, (Object)brokerReconfigurablesToUpdate);
            Tuple2 tuple23 = tuple22;
            KafkaConfig newConfig2 = (KafkaConfig)((Object)tuple23._1());
            List brokerReconfigurablesToUpdate2 = (List)tuple23._2();
            if (newConfig2 == this.currentConfig()) break block1;
            this.currentConfig_$eq(newConfig2);
            this.kafkaConfig().updateCurrentConfig(newConfig2);
            brokerReconfigurablesToUpdate2.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.reconfigure(oldConfig, newConfig2);
                return BoxedUnit.UNIT;
            });
        }
    }

    private Tuple2<KafkaConfig, List<BrokerReconfigurable>> processReconfiguration(Map<String, String> newProps, boolean validateOnly) {
        Tuple2 tuple2;
        KafkaConfig newConfig = new KafkaConfig((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(newProps).asJava(), !validateOnly, (Option<DynamicBrokerConfig>)None$.MODULE$);
        scala.collection.mutable.Map<String, ?> updatedMap = this.updatedConfigs(newConfig.originalsFromThisConfig(), this.currentConfig().originals());
        if (updatedMap.nonEmpty()) {
            try {
                HashMap<String, Object> customConfigs = new HashMap<String, Object>(newConfig.originalsFromThisConfig());
                ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(newConfig.valuesFromThisConfig().keySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> customConfigs.remove(x$1));
                this.reconfigurables().foreach((Function1 & Serializable & scala.Serializable)x0$9 -> {
                    DynamicBrokerConfig.$anonfun$processReconfiguration$2(this, validateOnly, newConfig, updatedMap, customConfigs, x0$9);
                    return BoxedUnit.UNIT;
                });
                Buffer brokerReconfigurablesToUpdate = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.brokerReconfigurables().foreach((Function1 & Serializable & scala.Serializable)reconfigurable -> {
                    Object object;
                    if (this.needsReconfiguration((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter(reconfigurable.reconfigurableConfigs()).asJava(), (Set<String>)updatedMap.keySet())) {
                        reconfigurable.validateReconfiguration(newConfig);
                        object = !validateOnly ? brokerReconfigurablesToUpdate.$plus$eq(reconfigurable) : BoxedUnit.UNIT;
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    return object;
                });
                tuple2 = new Tuple2((Object)newConfig, (Object)brokerReconfigurablesToUpdate.toList());
            }
            catch (Exception e) {
                if (!validateOnly) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Failed to update broker configuration with configs : ").append(newConfig.originalsFromThisConfig()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
                throw new ConfigException("Invalid dynamic configuration", (Object)e);
            }
        } else {
            tuple2 = new Tuple2((Object)this.currentConfig(), (Object)List$.MODULE$.empty());
        }
        return tuple2;
    }

    private boolean needsReconfiguration(java.util.Set<String> reconfigurableConfigs, Set<String> updatedKeys) {
        return ((TraversableOnce)((GenSetLike)JavaConverters$.MODULE$.asScalaSetConverter(reconfigurableConfigs).asScala()).intersect(updatedKeys)).nonEmpty();
    }

    private void processListenerReconfigurable(ListenerReconfigurable listenerReconfigurable, KafkaConfig newConfig, java.util.Map<String, Object> customConfigs, boolean validateOnly, boolean reloadOnly) {
        block0: {
            ListenerName listenerName = listenerReconfigurable.listenerName();
            java.util.Map<String, Object> oldValues = this.currentConfig().valuesWithPrefixOverride(listenerName.configPrefix());
            java.util.Map<String, Object> newValues = newConfig.valuesFromThisConfigWithPrefixOverride(listenerName.configPrefix());
            Set updatedKeys = this.updatedConfigs(newValues, oldValues).keySet();
            boolean configsChanged = this.needsReconfiguration(listenerReconfigurable.reconfigurableConfigs(), (Set<String>)updatedKeys);
            if (reloadOnly == configsChanged) break block0;
            this.processReconfigurable((Reconfigurable)listenerReconfigurable, (Set<String>)updatedKeys, newValues, customConfigs, validateOnly);
        }
    }

    private void processReconfigurable(Reconfigurable reconfigurable, Set<String> updatedConfigNames, java.util.Map<String, ?> allNewConfigs, java.util.Map<String, Object> newCustomConfigs, boolean validateOnly) {
        block3: {
            HashMap<String, Object> newConfigs = new HashMap<String, Object>();
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(allNewConfigs).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$10 -> {
                Tuple2 tuple2 = x0$10;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                Object object = newConfigs.put(k, v);
                return object;
            });
            newConfigs.putAll(newCustomConfigs);
            try {
                reconfigurable.validateReconfiguration(newConfigs);
            }
            catch (ConfigException e) {
                throw e;
            }
            catch (Exception exception) {
                throw new ConfigException(new StringBuilder(58).append("Validation of dynamic config update of ").append(updatedConfigNames).append(" failed with class ").append(reconfigurable.getClass()).toString());
            }
            if (validateOnly) break block3;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Reconfiguring ").append(reconfigurable).append(", updated configs: ").append(updatedConfigNames).append(" custom configs: ").append(newCustomConfigs).toString());
            reconfigurable.reconfigure(newConfigs);
        }
    }

    public static final /* synthetic */ boolean $anonfun$verifyReconfigurableConfigs$2(String elem) {
        return DynamicConfig$Broker$.MODULE$.nonDynamicProps().contains((Object)elem);
    }

    public static final /* synthetic */ boolean $anonfun$reloadUpdatedFilesWithoutConfigChange$2(Reconfigurable reconfigurable) {
        java.util.Set set = reconfigurable.reconfigurableConfigs();
        return DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)set.contains(x$1)));
    }

    public static final /* synthetic */ void $anonfun$reloadUpdatedFilesWithoutConfigChange$4(DynamicBrokerConfig $this, Properties newProps$1, Reconfigurable x0$2) {
        Reconfigurable reconfigurable = x0$2;
        if (reconfigurable instanceof ListenerReconfigurable) {
            ListenerReconfigurable listenerReconfigurable = (ListenerReconfigurable)reconfigurable;
            Map<String, String> kafkaProps = $this.validatedKafkaProps(newProps$1, true);
            KafkaConfig newConfig = new KafkaConfig((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(kafkaProps).asJava(), false, (Option<DynamicBrokerConfig>)None$.MODULE$);
            $this.processListenerReconfigurable(listenerReconfigurable, newConfig, Collections.emptyMap(), false, true);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Files will not be reloaded without config change for ").append(reconfigurable).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private final void encodePassword$1(String configName, String value, boolean perBrokerConfig$2, Properties props$3) {
        block1: {
            if (value == null) break block1;
            if (!perBrokerConfig$2) {
                throw new ConfigException("Password config can be defined only at broker level");
            }
            props$3.setProperty(configName, this.passwordEncoder().encode(new Password(value)));
        }
    }

    public static final /* synthetic */ void $anonfun$toPersistentProps$2(DynamicBrokerConfig $this, boolean perBrokerConfig$2, Properties props$3, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        String value = (String)tuple2._2();
        $this.encodePassword$1(name, value, perBrokerConfig$2, props$3);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void removeInvalidProps$1(Set invalidPropNames, String errorMessage, Properties props$4) {
        block0: {
            if (!invalidPropNames.nonEmpty()) break block0;
            invalidPropNames.foreach((Function1 & Serializable & scala.Serializable)x$1 -> props$4.remove(x$1));
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(2).append(errorMessage).append(": ").append(invalidPropNames).toString());
        }
    }

    private final void decodePassword$1(String configName, String value, Properties props$4) {
        block2: {
            if (value == null) break block2;
            try {
                props$4.setProperty(configName, this.passwordEncoder().decode(value).value());
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Dynamic password config ").append(configName).append(" could not be decoded, ignoring.").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                props$4.remove(configName);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$fromPersistentProps$6(DynamicBrokerConfig $this, Properties props$4, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        String value = (String)tuple2._2();
        $this.decodePassword$1(name, value, props$4);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$maybeReEncodePasswords$4(DynamicBrokerConfig $this, Properties props$6, PasswordEncoder passwordDecoder$1, Tuple2 x0$5) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$5;
        if (tuple2 != null) {
            String configName = (String)tuple2._1();
            String value2 = (String)tuple2._2();
            if (value2 != null) {
                Some some;
                try {
                    some = new Some((Object)passwordDecoder$1.decode(value2).value());
                }
                catch (Exception exception) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(88).append("Dynamic password config ").append(configName).append(" could not be decoded using old secret, new secret will be used.").toString());
                    some = None$.MODULE$;
                }
                Some decoded = some;
                decoded.foreach((Function1 & Serializable & scala.Serializable)value -> props$6.put(configName, $this.passwordEncoder().encode(new Password(value))));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$maybeReEncodePasswords$2(DynamicBrokerConfig $this, Properties persistentProps$3, AdminZkClient adminZkClient$1, Properties props$6, PasswordEncoder passwordDecoder) {
        ((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(persistentProps$3).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name))).foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
            DynamicBrokerConfig.$anonfun$maybeReEncodePasswords$4($this, props$6, passwordDecoder, x0$5);
            return BoxedUnit.UNIT;
        });
        adminZkClient$1.changeBrokerConfig((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)$this.kafkaConfig().brokerId())), props$6);
    }

    public static final /* synthetic */ boolean $anonfun$removeInvalidConfigs$1(Tuple2 x0$6) {
        boolean bl;
        Tuple2 tuple2 = x0$6;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Properties props1 = new Properties();
            props1.put(k, v);
            try {
                DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props1);
                bl = false;
            }
            catch (Exception exception) {
                bl = true;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ boolean $anonfun$maybeReconfigure$1(KafkaConfig oldConfig$1, java.util.Map newConfig$1, String key) {
        return !BoxesRunTime.equals((Object)oldConfig$1.originals().get(key), newConfig$1.get(key));
    }

    public static final /* synthetic */ boolean $anonfun$updatedConfigs$1(java.util.Map currentProps$1, Tuple2 x0$7) {
        Tuple2 tuple2 = x0$7;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        Object v = tuple2._2();
        boolean bl = !BoxesRunTime.equals((Object)v, currentProps$1.get(k));
        return bl;
    }

    public static final /* synthetic */ void $anonfun$processReconfiguration$2(DynamicBrokerConfig $this, boolean validateOnly$1, KafkaConfig newConfig$3, scala.collection.mutable.Map updatedMap$1, HashMap customConfigs$1, Reconfigurable x0$9) {
        Reconfigurable reconfigurable = x0$9;
        if (reconfigurable instanceof ListenerReconfigurable) {
            ListenerReconfigurable listenerReconfigurable = (ListenerReconfigurable)reconfigurable;
            $this.processListenerReconfigurable(listenerReconfigurable, newConfig$3, customConfigs$1, validateOnly$1, false);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if ($this.needsReconfiguration(reconfigurable.reconfigurableConfigs(), (Set<String>)updatedMap$1.keySet())) {
                $this.processReconfigurable(reconfigurable, (Set<String>)updatedMap$1.keySet(), newConfig$3.valuesFromThisConfig(), customConfigs$1, validateOnly$1);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public DynamicBrokerConfig(KafkaConfig kafkaConfig) {
        this.kafkaConfig = kafkaConfig;
        Logging.$init$(this);
        this.staticBrokerConfigs = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(ConfigDef.convertToStringMapWithPasswordValues(kafkaConfig.originalsFromThisConfig())).asScala();
        this.staticDefaultConfigs = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(ConfigDef.convertToStringMapWithPasswordValues((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(KafkaConfig$.MODULE$.defaultValues()).asJava()))).asScala();
        this.dynamicBrokerConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.dynamicDefaultConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.reconfigurables = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.brokerReconfigurables = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.lock = new ReentrantReadWriteLock();
        this.currentConfig = kafkaConfig;
        this.dynamicConfigPasswordEncoder = this.maybeCreatePasswordEncoder(kafkaConfig.passwordEncoderSecret());
    }
}

