/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.checkpoints.LeaderEpochCheckpoint;
import kafka.server.epoch.EpochEntry;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc\u0001B\u0001\u0003\u0001%\u0011A\u0003T3bI\u0016\u0014X\t]8dQ\u001aKG.Z\"bG\",'BA\u0002\u0005\u0003\u0015)\u0007o\\2i\u0015\t)a!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000f\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\u000b!A\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\t1\u0011I\\=SK\u001a\u0004\"!\u0005\u000b\u000e\u0003IQ!a\u0005\u0004\u0002\u000bU$\u0018\u000e\\:\n\u0005U\u0011\"a\u0002'pO\u001eLgn\u001a\u0005\t/\u0001\u0011\t\u0011)A\u00051\u0005qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007CA\r\"\u001b\u0005Q\"BA\u000e\u001d\u0003\u0019\u0019w.\\7p]*\u0011q!\b\u0006\u0003=}\ta!\u00199bG\",'\"\u0001\u0011\u0002\u0007=\u0014x-\u0003\u0002#5\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\u0002\u00191|w-\u00128e\u001f\u001a47/\u001a;\u0011\u0007-1\u0003&\u0003\u0002(\u0019\tIa)\u001e8di&|g\u000e\r\t\u0003\u0017%J!A\u000b\u0007\u0003\t1{gn\u001a\u0005\tY\u0001\u0011\t\u0011)A\u0005[\u0005Q1\r[3dWB|\u0017N\u001c;\u0011\u00059\nT\"A\u0018\u000b\u0005A\"\u0011aC2iK\u000e\\\u0007o\\5oiNL!AM\u0018\u0003+1+\u0017\rZ3s\u000bB|7\r[\"iK\u000e\\\u0007o\\5oi\")A\u0007\u0001C\u0001k\u00051A(\u001b8jiz\"BA\u000e\u001d:uA\u0011q\u0007A\u0007\u0002\u0005!)qc\ra\u00011!)Ae\ra\u0001K!)Af\ra\u0001[!9A\b\u0001b\u0001\n\u0013i\u0014\u0001\u00027pG.,\u0012A\u0010\t\u0003\u007f!k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000bQ\u0001\\8dWNT!a\u0011#\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002F\r\u0006!Q\u000f^5m\u0015\u00059\u0015\u0001\u00026bm\u0006L!!\u0013!\u0003-I+WM\u001c;sC:$(+Z1e/JLG/\u001a'pG.Daa\u0013\u0001!\u0002\u0013q\u0014!\u00027pG.\u0004\u0003bB'\u0001\u0001\u0004%IAT\u0001\u0007KB|7\r[:\u0016\u0003=\u00032\u0001U+X\u001b\u0005\t&B\u0001*T\u0003\u001diW\u000f^1cY\u0016T!\u0001\u0016\u0007\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002W#\nQA*[:u\u0005V4g-\u001a:\u0011\u0005]B\u0016BA-\u0003\u0005))\u0005o\\2i\u000b:$(/\u001f\u0005\b7\u0002\u0001\r\u0011\"\u0003]\u0003))\u0007o\\2ig~#S-\u001d\u000b\u0003;\u0002\u0004\"a\u00030\n\u0005}c!\u0001B+oSRDq!\u0019.\u0002\u0002\u0003\u0007q*A\u0002yIEBaa\u0019\u0001!B\u0013y\u0015aB3q_\u000eD7\u000f\t\u0005\u0006K\u0002!\tAZ\u0001\u0007CN\u001c\u0018n\u001a8\u0015\u0007u;7\u000eC\u0003\u0004I\u0002\u0007\u0001\u000e\u0005\u0002\fS&\u0011!\u000e\u0004\u0002\u0004\u0013:$\b\"\u00027e\u0001\u0004A\u0013aC:uCJ$xJ\u001a4tKRDQA\u001c\u0001\u0005\n=\f\u0011\u0003\u001e:v]\u000e\fG/Z!oI\u0006\u0003\b/\u001a8e)\ti\u0006\u000fC\u0003r[\u0002\u0007q+A\u0007f]R\u0014\u0018\u0010V8BaB,g\u000e\u001a\u0005\u0006g\u0002!\t\u0001^\u0001\t]>tW)\u001c9usV\tQ\u000f\u0005\u0002\fm&\u0011q\u000f\u0004\u0002\b\u0005>|G.Z1o\u0011\u0015I\b\u0001\"\u0001{\u0003-a\u0017\r^3ti\u0016\u0003xn\u00195\u0016\u0003m\u00042a\u0003?i\u0013\tiHB\u0001\u0004PaRLwN\u001c\u0005\u0007\u007f\u0002!\t!!\u0001\u0002\u0019\u0015tGm\u00144gg\u0016$hi\u001c:\u0015\t\u0005\r\u0011\u0011\u0002\t\u0006\u0017\u0005\u0015\u0001\u000eK\u0005\u0004\u0003\u000fa!A\u0002+va2,'\u0007\u0003\u0004\u0002\fy\u0004\r\u0001[\u0001\u000fe\u0016\fX/Z:uK\u0012,\u0005o\\2i\u0011\u001d\ty\u0001\u0001C\u0001\u0003#\tq\u0002\u001e:v]\u000e\fG/\u001a$s_6,e\u000e\u001a\u000b\u0004;\u0006M\u0001bBA\u000b\u0003\u001b\u0001\r\u0001K\u0001\nK:$wJ\u001a4tKRDq!!\u0007\u0001\t\u0003\tY\"A\tueVt7-\u0019;f\rJ|Wn\u0015;beR$2!XA\u000f\u0011\u0019a\u0017q\u0003a\u0001Q!9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0012!D2mK\u0006\u0014\u0018I\u001c3GYV\u001c\b\u000eF\u0001^\u0011\u001d\t9\u0003\u0001C\u0001\u0003G\tQa\u00197fCJDa!a\u000b\u0001\t\u0003q\u0015\u0001D3q_\u000eDWI\u001c;sS\u0016\u001c\bbBA\u0018\u0001\u0011%\u0011\u0011G\u0001\fY\u0006$Xm\u001d;F]R\u0014\u00180\u0006\u0002\u00024A\u00191\u0002`,\t\u000f\u0005]\u0002\u0001\"\u0003\u0002$\u0005)a\r\\;tQ\"9\u00111\b\u0001\u0005\n\u0005u\u0012\u0001\u0006<bY&$\u0017\r^3B]\u0012l\u0015-\u001f2f/\u0006\u0014h\u000eF\u0002^\u0003\u007fAq!!\u0011\u0002:\u0001\u0007q+A\u0003f]R\u0014\u0018\u0010")
public class LeaderEpochFileCache
implements Logging {
    private final Function0<Object> logEndOffset;
    private final LeaderEpochCheckpoint checkpoint;
    private final ReentrantReadWriteLock lock;
    private ListBuffer<EpochEntry> epochs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        LeaderEpochFileCache leaderEpochFileCache = this;
        synchronized (leaderEpochFileCache) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private ListBuffer<EpochEntry> epochs() {
        return this.epochs;
    }

    private void epochs_$eq(ListBuffer<EpochEntry> x$1) {
        this.epochs = x$1;
    }

    public void assign(int epoch, long startOffset) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                EpochEntry lastEntry;
                boolean updateNeeded;
                boolean bl = this.epochs().isEmpty() ? true : (updateNeeded = (lastEntry = (EpochEntry)this.epochs().last()).epoch() != epoch || startOffset < lastEntry.startOffset());
                if (!updateNeeded) break block0;
                this.truncateAndAppend(new EpochEntry(epoch, startOffset));
                this.flush();
            }
        });
    }

    private void truncateAndAppend(EpochEntry entryToAppend) {
        this.validateAndMaybeWarn(entryToAppend);
        Tuple2 tuple2 = this.epochs().partition((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$truncateAndAppend$1(entryToAppend, entry)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ListBuffer retainedEpochs = (ListBuffer)tuple2._1();
        ListBuffer removedEpochs = (ListBuffer)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)retainedEpochs, (Object)removedEpochs);
        Tuple2 tuple23 = tuple22;
        ListBuffer retainedEpochs2 = (ListBuffer)tuple23._1();
        ListBuffer removedEpochs2 = (ListBuffer)tuple23._2();
        this.epochs_$eq((ListBuffer<EpochEntry>)((ListBuffer)retainedEpochs2.$colon$plus((Object)entryToAppend, ListBuffer$.MODULE$.canBuildFrom())));
        if (removedEpochs2.isEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Appended new epoch entry ").append(entryToAppend).append(". Cache now contains ").append(this.epochs().size()).append(" entries.").toString());
        } else {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("New epoch entry ").append(entryToAppend).append(" caused truncation of conflicting entries ").append(removedEpochs2).append(". ").append(new StringBuilder(28).append("Cache now contains ").append(this.epochs().size()).append(" entries.").toString()).toString());
        }
    }

    public boolean nonEmpty() {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inReadLock(this.lock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.epochs().nonEmpty()));
    }

    public Option<Object> latestEpoch() {
        return (Option)CoreUtils$.MODULE$.inReadLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.epochs().lastOption().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.epoch())));
    }

    public Tuple2<Object, Object> endOffsetFor(int requestedEpoch) {
        return (Tuple2)CoreUtils$.MODULE$.inReadLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            void var3_9;
            Tuple2.mcIJ.sp sp2;
            if (requestedEpoch == -1) {
                sp2 = new Tuple2.mcIJ.sp(-1, -1L);
            } else if (this.latestEpoch().contains((Object)BoxesRunTime.boxToInteger((int)requestedEpoch))) {
                sp2 = new Tuple2.mcIJ.sp(requestedEpoch, $this.logEndOffset.apply$mcJ$sp());
            } else {
                Tuple2 tuple2 = this.epochs().partition((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$endOffsetFor$2(requestedEpoch, e)));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ListBuffer subsequentEpochs = (ListBuffer)tuple2._1();
                ListBuffer previousEpochs = (ListBuffer)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)subsequentEpochs, (Object)previousEpochs);
                Tuple2 tuple23 = tuple22;
                ListBuffer subsequentEpochs2 = (ListBuffer)tuple23._1();
                ListBuffer previousEpochs2 = (ListBuffer)tuple23._2();
                sp2 = subsequentEpochs2.isEmpty() ? new Tuple2.mcIJ.sp(-1, -1L) : (previousEpochs2.isEmpty() ? new Tuple2.mcIJ.sp(requestedEpoch, ((EpochEntry)subsequentEpochs2.head()).startOffset()) : new Tuple2.mcIJ.sp(((EpochEntry)previousEpochs2.last()).epoch(), ((EpochEntry)subsequentEpochs2.head()).startOffset()));
            }
            Tuple2.mcIJ.sp epochAndOffset = sp2;
            this.debug((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> LeaderEpochFileCache.$anonfun$endOffsetFor$3(this, requestedEpoch, (Tuple2)epochAndOffset)));
            return var3_9;
        });
    }

    public void truncateFromEnd(long endOffset) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block1: {
                if (endOffset < 0L || !this.latestEntry().exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$truncateFromEnd$2(endOffset, x$4)))) break block1;
                Tuple2 tuple2 = this.epochs().partition((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$truncateFromEnd$3(endOffset, x$5)));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ListBuffer subsequentEntries = (ListBuffer)tuple2._1();
                ListBuffer previousEntries = (ListBuffer)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)subsequentEntries, (Object)previousEntries);
                Tuple2 tuple23 = tuple22;
                ListBuffer subsequentEntries2 = (ListBuffer)tuple23._1();
                ListBuffer previousEntries2 = (ListBuffer)tuple23._2();
                this.epochs_$eq((ListBuffer<EpochEntry>)previousEntries2);
                this.flush();
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Cleared entries ").append(subsequentEntries2).append(" from epoch cache after ").append(new StringBuilder(57).append("truncating to end offset ").append(endOffset).append(", leaving ").append(this.epochs().size()).append(" entries in the cache.").toString()).toString());
            }
        });
    }

    public void truncateFromStart(long startOffset) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block1: {
                if (!this.epochs().nonEmpty()) break block1;
                Tuple2 tuple2 = this.epochs().partition((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$truncateFromStart$2(startOffset, x$7)));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ListBuffer subsequentEntries = (ListBuffer)tuple2._1();
                ListBuffer previousEntries = (ListBuffer)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)subsequentEntries, (Object)previousEntries);
                Tuple2 tuple23 = tuple22;
                ListBuffer subsequentEntries2 = (ListBuffer)tuple23._1();
                ListBuffer previousEntries2 = (ListBuffer)tuple23._2();
                previousEntries2.lastOption().foreach((Function1 & Serializable & scala.Serializable)firstBeforeStartOffset -> {
                    LeaderEpochFileCache.$anonfun$truncateFromStart$3(this, startOffset, subsequentEntries2, previousEntries2, firstBeforeStartOffset);
                    return BoxedUnit.UNIT;
                });
            }
        });
    }

    public void clearAndFlush() {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.epochs().clear();
            this.flush();
        });
    }

    public void clear() {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.epochs().clear());
    }

    public ListBuffer<EpochEntry> epochEntries() {
        return this.epochs();
    }

    private Option<EpochEntry> latestEntry() {
        return this.epochs().lastOption();
    }

    private void flush() {
        this.checkpoint.write((Seq<EpochEntry>)this.epochs());
    }

    private void validateAndMaybeWarn(EpochEntry entry) {
        if (entry.epoch() < 0) {
            throw new IllegalArgumentException(new StringBuilder(46).append("Received invalid partition leader epoch entry ").append(entry).toString());
        }
        this.latestEntry().foreach((Function1 & Serializable & scala.Serializable)latest -> {
            LeaderEpochFileCache.$anonfun$validateAndMaybeWarn$1(this, entry, latest);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$truncateAndAppend$1(EpochEntry entryToAppend$1, EpochEntry entry) {
        return entry.epoch() < entryToAppend$1.epoch() && entry.startOffset() < entryToAppend$1.startOffset();
    }

    public static final /* synthetic */ boolean $anonfun$endOffsetFor$2(int requestedEpoch$1, EpochEntry e) {
        return e.epoch() > requestedEpoch$1;
    }

    public static final /* synthetic */ String $anonfun$endOffsetFor$3(LeaderEpochFileCache $this, int requestedEpoch$1, Tuple2 epochAndOffset$1) {
        return new StringBuilder(61).append("Processed end offset request for epoch ").append(requestedEpoch$1).append(" and returning epoch ").append(epochAndOffset$1._1$mcI$sp()).append(" ").append(new StringBuilder(42).append("with end offset ").append(epochAndOffset$1._2$mcJ$sp()).append(" from epoch cache of size ").append($this.epochs().size()).toString()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$truncateFromEnd$2(long endOffset$1, EpochEntry x$4) {
        return x$4.startOffset() >= endOffset$1;
    }

    public static final /* synthetic */ boolean $anonfun$truncateFromEnd$3(long endOffset$1, EpochEntry x$5) {
        return x$5.startOffset() >= endOffset$1;
    }

    public static final /* synthetic */ boolean $anonfun$truncateFromStart$2(long startOffset$1, EpochEntry x$7) {
        return x$7.startOffset() > startOffset$1;
    }

    public static final /* synthetic */ void $anonfun$truncateFromStart$3(LeaderEpochFileCache $this, long startOffset$1, ListBuffer subsequentEntries$2, ListBuffer previousEntries$1, EpochEntry firstBeforeStartOffset) {
        EpochEntry updatedFirstEntry;
        EpochEntry epochEntry = updatedFirstEntry = new EpochEntry(firstBeforeStartOffset.epoch(), startOffset$1);
        $this.epochs_$eq((ListBuffer<EpochEntry>)((ListBuffer)subsequentEntries$2.$plus$colon((Object)epochEntry, ListBuffer$.MODULE$.canBuildFrom())));
        $this.flush();
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Cleared entries ").append(previousEntries$1).append(" and rewrote first entry ").append(updatedFirstEntry).append(" after ").append(new StringBuilder(51).append("truncating to start offset ").append(startOffset$1).append(", leaving ").append($this.epochs().size()).append(" in the cache.").toString()).toString());
    }

    public static final /* synthetic */ void $anonfun$validateAndMaybeWarn$1(LeaderEpochFileCache $this, EpochEntry entry$1, EpochEntry latest) {
        block1: {
            block0: {
                if (entry$1.epoch() >= latest.epoch()) break block0;
                $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Received leader epoch assignment ").append(entry$1).append(" which has an epoch less than the epoch ").append(new StringBuilder(70).append("of the latest entry ").append(latest).append(". This implies messages have arrived out of order.").toString()).toString());
                break block1;
            }
            if (entry$1.startOffset() >= latest.startOffset()) break block1;
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(81).append("Received leader epoch assignment ").append(entry$1).append(" which has a starting offset which is less than ").append(new StringBuilder(90).append("the starting offset of the latest entry ").append(latest).append(". This implies messages have arrived out of order.").toString()).toString());
        }
    }

    public LeaderEpochFileCache(TopicPartition topicPartition, Function0<Object> logEndOffset, LeaderEpochCheckpoint checkpoint) {
        this.logEndOffset = logEndOffset;
        this.checkpoint = checkpoint;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(20).append("[LeaderEpochCache ").append(topicPartition).append("] ").toString());
        this.lock = new ReentrantReadWriteLock();
        this.epochs = (ListBuffer)CoreUtils$.MODULE$.inWriteLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> (ListBuffer)ListBuffer$.MODULE$.apply($this.checkpoint.read()));
    }
}

