/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.PasswordEncoder$;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u00055x!B\u0001\u0003\u0011\u00039\u0011a\u0004)bgN<xN\u001d3F]\u000e|G-\u001a:\u000b\u0005\r!\u0011!B;uS2\u001c(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0001\u0017\ty\u0001+Y:to>\u0014H-\u00128d_\u0012,'o\u0005\u0002\n\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001aDQaE\u0005\u0005\u0002Q\ta\u0001P5oSRtD#A\u0004\t\u000fYI!\u0019!C\u0001/\u000592*Z=GC\u000e$xN]=BY\u001e|'/\u001b;i[B\u0013x\u000e]\u000b\u00021A\u0011\u0011DH\u0007\u00025)\u00111\u0004H\u0001\u0005Y\u0006twMC\u0001\u001e\u0003\u0011Q\u0017M^1\n\u0005}Q\"AB*ue&tw\r\u0003\u0004\"\u0013\u0001\u0006I\u0001G\u0001\u0019\u0017\u0016Lh)Y2u_JL\u0018\t\\4pe&$\b.\u001c)s_B\u0004\u0003bB\u0012\n\u0005\u0004%\taF\u0001\u0014\u0007&\u0004\b.\u001a:BY\u001e|'/\u001b;i[B\u0013x\u000e\u001d\u0005\u0007K%\u0001\u000b\u0011\u0002\r\u0002)\rK\u0007\u000f[3s\u00032<wN]5uQ6\u0004&o\u001c9!\u0011\u001d9\u0013B1A\u0005\u0002]\t\u0001$\u00138ji&\fG.\u001b>bi&|gNV3di>\u0014\bK]8q\u0011\u0019I\u0013\u0002)A\u00051\u0005I\u0012J\\5uS\u0006d\u0017N_1uS>tg+Z2u_J\u0004&o\u001c9!\u0011\u001dY\u0013B1A\u0005\u0002]\tQbS3z\u0019\u0016tw\r\u001e5Qe>\u0004\bBB\u0017\nA\u0003%\u0001$\u0001\bLKfdUM\\4uQB\u0013x\u000e\u001d\u0011\t\u000f=J!\u0019!C\u0001/\u0005A1+\u00197u!J|\u0007\u000f\u0003\u00042\u0013\u0001\u0006I\u0001G\u0001\n'\u0006dG\u000f\u0015:pa\u0002BqaM\u0005C\u0002\u0013\u0005q#\u0001\bJi\u0016\u0014\u0018\r^5p]N\u0004&o\u001c9\t\rUJ\u0001\u0015!\u0003\u0019\u0003=IE/\u001a:bi&|gn\u001d)s_B\u0004\u0003bB\u001c\n\u0005\u0004%\taF\u0001\u0016\u000b:\u001c\u0017P\u001d9uK\u0012\u0004\u0016m]:x_J$\u0007K]8q\u0011\u0019I\u0014\u0002)A\u00051\u00051RI\\2zeB$X\r\u001a)bgN<xN\u001d3Qe>\u0004\b\u0005C\u0004<\u0013\t\u0007I\u0011A\f\u0002%A\u000b7o]<pe\u0012dUM\\4uQB\u0013x\u000e\u001d\u0005\u0007{%\u0001\u000b\u0011\u0002\r\u0002'A\u000b7o]<pe\u0012dUM\\4uQB\u0013x\u000e\u001d\u0011\u0007\t)\u0011\u0001aP\n\u0004}1\u0001\u0005C\u0001\u0005B\u0013\t\u0011%AA\u0004M_\u001e<\u0017N\\4\t\u0011\u0011s$\u0011!Q\u0001\n\u0015\u000baa]3de\u0016$\bC\u0001$S\u001b\u00059%B\u0001%J\u0003\u0015!\u0018\u0010]3t\u0015\tQ5*\u0001\u0004d_:4\u0017n\u001a\u0006\u0003\u00196\u000baaY8n[>t'BA\u0003O\u0015\ty\u0005+\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0006\u0019qN]4\n\u0005M;%\u0001\u0003)bgN<xN\u001d3\t\u0011Us$\u0011!Q\u0001\nY\u000b1c[3z\r\u0006\u001cGo\u001c:z\u00032<wN]5uQ6\u00042!D,Z\u0013\tAfB\u0001\u0004PaRLwN\u001c\t\u00035\u0006t!aW0\u0011\u0005qsQ\"A/\u000b\u0005y3\u0011A\u0002\u001fs_>$h(\u0003\u0002a\u001d\u00051\u0001K]3eK\u001aL!a\b2\u000b\u0005\u0001t\u0001\u0002\u00033?\u0005\u0003\u0005\u000b\u0011B-\u0002\u001f\rL\u0007\u000f[3s\u00032<wN]5uQ6D\u0001B\u001a \u0003\u0002\u0003\u0006IaZ\u0001\nW\u0016LH*\u001a8hi\"\u0004\"!\u00045\n\u0005%t!aA%oi\"A1N\u0010B\u0001B\u0003%q-\u0001\u0006ji\u0016\u0014\u0018\r^5p]NDQa\u0005 \u0005\u00025$bA\\8qcJ\u001c\bC\u0001\u0005?\u0011\u0015!E\u000e1\u0001F\u0011\u0015)F\u000e1\u0001W\u0011\u0015!G\u000e1\u0001Z\u0011\u00151G\u000e1\u0001h\u0011\u0015YG\u000e1\u0001h\u0011\u001d)hH1A\u0005\nY\fAb]3dkJ,'+\u00198e_6,\u0012a\u001e\t\u0003qnl\u0011!\u001f\u0006\u0003ur\t\u0001b]3dkJLG/_\u0005\u0003yf\u0014AbU3dkJ,'+\u00198e_6DaA  !\u0002\u00139\u0018!D:fGV\u0014XMU1oI>l\u0007\u0005C\u0005\u0002\u0002y\u0012\r\u0011\"\u0003\u0002\u0004\u0005\u00192-\u001b9iKJ\u0004\u0016M]1ng\u0016s7m\u001c3feV\u0011\u0011Q\u0001\t\u0005\u0003\u000f\tI!D\u0001?\r%\tYA\u0010I\u0001$\u0013\tiAA\nDSBDWM\u001d)be\u0006l7/\u00128d_\u0012,'oE\u0002\u0002\n1A\u0001\"!\u0005\u0002\n\u0019\u0005\u00111C\u0001\u0006i>l\u0015\r\u001d\u000b\u0005\u0003+\t\t\u0003\u0005\u0004\u0002\u0018\u0005u\u0011,W\u0007\u0003\u00033Q1!a\u0007\u000f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003?\tIBA\u0002NCBD\u0001\"a\t\u0002\u0010\u0001\u0007\u0011QE\u0001\u0007G&\u0004\b.\u001a:\u0011\u0007a\f9#C\u0002\u0002*e\u00141#\u00117h_JLG\u000f[7QCJ\fW.\u001a;feND\u0001\"!\f\u0002\n\u0019\u0005\u0011qF\u0001\u0010i>\u0004\u0016M]1nKR,'o\u00159fGR!\u0011\u0011GA\u001f!\u0011\t\u0019$!\u000f\u000e\u0005\u0005U\"bAA\u001cs\u0006!1\u000f]3d\u0013\u0011\tY$!\u000e\u0003-\u0005cwm\u001c:ji\"l\u0007+\u0019:b[\u0016$XM]*qK\u000eD\u0001\"a\u0010\u0002,\u0001\u0007\u0011QC\u0001\ta\u0006\u0014\u0018-\\'ba\"A\u00111\t !\u0002\u0013\t)!\u0001\u000bdSBDWM\u001d)be\u0006l7/\u00128d_\u0012,'\u000f\t\u0005\b\u0003\u000frD\u0011AA%\u0003\u0019)gnY8eKR\u0019\u0011,a\u0013\t\u000f\u00055\u0013Q\ta\u0001\u000b\u0006A\u0001/Y:to>\u0014H\rC\u0004\u0002Ry\"\t!a\u0015\u0002\r\u0011,7m\u001c3f)\r)\u0015Q\u000b\u0005\b\u0003/\ny\u00051\u0001Z\u0003=)gnY8eK\u0012\u0004\u0016m]:x_J$\u0007bBA.}\u0011%\u0011QL\u0001\u0011g\u0016\u001c'/\u001a;LKf4\u0015m\u0019;pef$B!a\u0018\u0002pA!\u0011\u0011MA6\u001b\t\t\u0019G\u0003\u0003\u0002f\u0005\u001d\u0014AB2ssB$xN\u0003\u0002\u0002j\u0005)!.\u0019<bq&!\u0011QNA2\u0005A\u0019Vm\u0019:fi.+\u0017PR1di>\u0014\u0018\u0010C\u0004\u0002r\u0005e\u0003\u0019\u0001,\u0002\u001b-,\u0017PR1di>\u0014\u00180\u00117h\u0011\u001d\t)H\u0010C\u0005\u0003o\nQb]3de\u0016$8*Z=Ta\u0016\u001cG\u0003DA=\u0003\u0007\u000b9)a#\u0002\u000e\u0006u\u0005\u0003BA>\u0003\u007fj!!! \u000b\t\u0005]\u00121M\u0005\u0005\u0003\u0003\u000biHA\u0007TK\u000e\u0014X\r^&fsN\u0003Xm\u0019\u0005\t\u0003\u000b\u000b\u0019\b1\u0001\u0002`\u0005Q1.Z=GC\u000e$xN]=\t\u000f\u0005%\u00151\u000fa\u00013\u0006I1-\u001b9iKJ\fEn\u001a\u0005\u0007M\u0006M\u0004\u0019A4\t\u0011\u0005=\u00151\u000fa\u0001\u0003#\u000bAa]1miB)Q\"a%\u0002\u0018&\u0019\u0011Q\u0013\b\u0003\u000b\u0005\u0013(/Y=\u0011\u00075\tI*C\u0002\u0002\u001c:\u0011AAQ=uK\"11.a\u001dA\u0002\u001dDq!!)?\t\u0013\t\u0019+\u0001\u0007cCN,g\u0007N#oG>$W\rF\u0002Z\u0003KC\u0001\"a*\u0002 \u0002\u0007\u0011\u0011S\u0001\u0006Ef$Xm\u001d\u0005\t\u0003WsD\u0011\u0001\u0002\u0002.\u0006a!-Y:fmQ\"UmY8eKR!\u0011\u0011SAX\u0011\u001d\t\t,!+A\u0002e\u000bq!\u001a8d_\u0012,G\rC\u0004\u00026z\"I!a.\u0002)\rL\u0007\u000f[3s!\u0006\u0014\u0018-\\:J]N$\u0018M\\2f)\u0011\t)!!/\t\r\u0011\f\u0019\f1\u0001Z\r\u0019\tiL\u0010\u0003\u0002@\ny\u0011J\u001e)be\u0006l7/\u00128d_\u0012,'oE\u0003\u0002<2\t)\u0001C\u0004\u0014\u0003w#\t!a1\u0015\u0005\u0005\u0015\u0007\u0003BA\u0004\u0003wC\u0001\"!\u0005\u0002<\u0012\u0005\u0011\u0011\u001a\u000b\u0005\u0003+\tY\r\u0003\u0005\u0002N\u0006\u001d\u0007\u0019AA\u0013\u00031\u0019\u0017\u000e\u001d5feB\u000b'/Y7t\u0011!\ti#a/\u0005\u0002\u0005EG\u0003BA\u0019\u0003'D\u0001\"a\u0010\u0002P\u0002\u0007\u0011Q\u0003\u0004\u0007\u0003/tD!!7\u0003!\u001d\u001bW\u000eU1sC6\u001cXI\\2pI\u0016\u00148#BAk\u0019\u0005\u0015\u0001bB\n\u0002V\u0012\u0005\u0011Q\u001c\u000b\u0003\u0003?\u0004B!a\u0002\u0002V\"A\u0011\u0011CAk\t\u0003\t\u0019\u000f\u0006\u0003\u0002\u0016\u0005\u0015\b\u0002CAg\u0003C\u0004\r!!\n\t\u0011\u00055\u0012Q\u001bC\u0001\u0003S$B!!\r\u0002l\"A\u0011qHAt\u0001\u0004\t)\u0002")
public class PasswordEncoder
implements Logging {
    private final Password secret;
    private final Option<String> keyFactoryAlgorithm;
    private final String cipherAlgorithm;
    private final int keyLength;
    private final int iterations;
    private final SecureRandom secureRandom;
    private final CipherParamsEncoder cipherParamsEncoder;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String PasswordLengthProp() {
        return PasswordEncoder$.MODULE$.PasswordLengthProp();
    }

    public static String EncyrptedPasswordProp() {
        return PasswordEncoder$.MODULE$.EncyrptedPasswordProp();
    }

    public static String IterationsProp() {
        return PasswordEncoder$.MODULE$.IterationsProp();
    }

    public static String SaltProp() {
        return PasswordEncoder$.MODULE$.SaltProp();
    }

    public static String KeyLengthProp() {
        return PasswordEncoder$.MODULE$.KeyLengthProp();
    }

    public static String InitializationVectorProp() {
        return PasswordEncoder$.MODULE$.InitializationVectorProp();
    }

    public static String CipherAlgorithmProp() {
        return PasswordEncoder$.MODULE$.CipherAlgorithmProp();
    }

    public static String KeyFactoryAlgorithmProp() {
        return PasswordEncoder$.MODULE$.KeyFactoryAlgorithmProp();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        PasswordEncoder passwordEncoder = this;
        synchronized (passwordEncoder) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private SecureRandom secureRandom() {
        return this.secureRandom;
    }

    private CipherParamsEncoder cipherParamsEncoder() {
        return this.cipherParamsEncoder;
    }

    public String encode(Password password) {
        byte[] salt = new byte[256];
        this.secureRandom().nextBytes(salt);
        Cipher cipher = Cipher.getInstance(this.cipherAlgorithm);
        SecretKeyFactory keyFactory = this.secretKeyFactory(this.keyFactoryAlgorithm);
        SecretKeySpec keySpec = this.secretKeySpec(keyFactory, this.cipherAlgorithm, this.keyLength, salt, this.iterations);
        cipher.init(1, keySpec);
        byte[] encryptedPassword = cipher.doFinal(password.value().getBytes(StandardCharsets.UTF_8));
        Map encryptedMap = ((MapLike)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PasswordEncoder$.MODULE$.KeyFactoryAlgorithmProp()), (Object)keyFactory.getAlgorithm()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PasswordEncoder$.MODULE$.CipherAlgorithmProp()), (Object)this.cipherAlgorithm), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PasswordEncoder$.MODULE$.KeyLengthProp()), (Object)BoxesRunTime.boxToInteger((int)this.keyLength)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PasswordEncoder$.MODULE$.SaltProp()), (Object)this.kafka$utils$PasswordEncoder$$base64Encode(salt)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PasswordEncoder$.MODULE$.IterationsProp()), (Object)((Object)BoxesRunTime.boxToInteger((int)this.iterations)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PasswordEncoder$.MODULE$.EncyrptedPasswordProp()), (Object)this.kafka$utils$PasswordEncoder$$base64Encode(encryptedPassword)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PasswordEncoder$.MODULE$.PasswordLengthProp()), (Object)BoxesRunTime.boxToInteger((int)password.value().length()))}))).$plus$plus(this.cipherParamsEncoder().toMap(cipher.getParameters()));
        return ((TraversableOnce)encryptedMap.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            Object v = tuple2._2();
            String string = new StringBuilder(1).append(k).append(":").append(v).toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString(",");
    }

    public Password decode(String encodedPassword) {
        String string;
        Map<String, String> params = CoreUtils$.MODULE$.parseCsvMap(encodedPassword);
        String keyFactoryAlg = (String)params.apply((Object)PasswordEncoder$.MODULE$.KeyFactoryAlgorithmProp());
        String cipherAlg = (String)params.apply((Object)PasswordEncoder$.MODULE$.CipherAlgorithmProp());
        int keyLength = new StringOps(Predef$.MODULE$.augmentString((String)params.apply((Object)PasswordEncoder$.MODULE$.KeyLengthProp()))).toInt();
        byte[] salt = this.base64Decode((String)params.apply((Object)PasswordEncoder$.MODULE$.SaltProp()));
        int iterations = new StringOps(Predef$.MODULE$.augmentString((String)params.apply((Object)PasswordEncoder$.MODULE$.IterationsProp()))).toInt();
        byte[] encryptedPassword = this.base64Decode((String)params.apply((Object)PasswordEncoder$.MODULE$.EncyrptedPasswordProp()));
        int passwordLengthProp = new StringOps(Predef$.MODULE$.augmentString((String)params.apply((Object)PasswordEncoder$.MODULE$.PasswordLengthProp()))).toInt();
        Cipher cipher = Cipher.getInstance(cipherAlg);
        SecretKeyFactory keyFactory = this.secretKeyFactory((Option<String>)new Some((Object)keyFactoryAlg));
        SecretKeySpec keySpec = this.secretKeySpec(keyFactory, cipherAlg, keyLength, salt, iterations);
        cipher.init(2, (Key)keySpec, this.cipherParamsEncoder().toParameterSpec(params));
        try {
            byte[] decrypted = cipher.doFinal(encryptedPassword);
            string = new String(decrypted, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new ConfigException("Password could not be decoded", (Object)e);
        }
        String password = string;
        if (password.length() != passwordLengthProp) {
            throw new ConfigException("Password could not be decoded, sanity check of length failed");
        }
        return new Password(password);
    }

    private SecretKeyFactory secretKeyFactory(Option<String> keyFactoryAlg) {
        SecretKeyFactory secretKeyFactory;
        Option<String> option = keyFactoryAlg;
        if (option instanceof Some) {
            Some some = (Some)option;
            String algorithm = (String)some.value();
            secretKeyFactory = SecretKeyFactory.getInstance(algorithm);
        } else if (None$.MODULE$.equals(option)) {
            SecretKeyFactory secretKeyFactory2;
            try {
                secretKeyFactory2 = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                secretKeyFactory2 = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            }
            secretKeyFactory = secretKeyFactory2;
        } else {
            throw new MatchError(option);
        }
        return secretKeyFactory;
    }

    private SecretKeySpec secretKeySpec(SecretKeyFactory keyFactory, String cipherAlg, int keyLength, byte[] salt, int iterations) {
        PBEKeySpec keySpec = new PBEKeySpec(this.secret.value().toCharArray(), salt, iterations, keyLength);
        String algorithm = cipherAlg.indexOf(47) > 0 ? cipherAlg.substring(0, cipherAlg.indexOf(47)) : cipherAlg;
        return new SecretKeySpec(keyFactory.generateSecret(keySpec).getEncoded(), algorithm);
    }

    public String kafka$utils$PasswordEncoder$$base64Encode(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public byte[] base64Decode(String encoded) {
        return Base64.getDecoder().decode(encoded);
    }

    private CipherParamsEncoder cipherParamsInstance(String cipherAlgorithm) {
        String string;
        String string2;
        Regex aesPattern = new StringOps(Predef$.MODULE$.augmentString("AES/(.*)/.*")).r();
        Option option = aesPattern.unapplySeq((CharSequence)(string2 = cipherAlgorithm));
        CipherParamsEncoder cipherParamsEncoder = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0 && "GCM".equals(string = (String)((LinearSeqOptimized)option.get()).apply(0)) ? new GcmParamsEncoder() : new IvParamsEncoder();
        return cipherParamsEncoder;
    }

    public PasswordEncoder(Password secret, Option<String> keyFactoryAlgorithm, String cipherAlgorithm, int keyLength, int iterations) {
        this.secret = secret;
        this.keyFactoryAlgorithm = keyFactoryAlgorithm;
        this.cipherAlgorithm = cipherAlgorithm;
        this.keyLength = keyLength;
        this.iterations = iterations;
        Logging.$init$(this);
        this.secureRandom = new SecureRandom();
        this.cipherParamsEncoder = this.cipherParamsInstance(cipherAlgorithm);
    }

    public interface CipherParamsEncoder {
        public Map<String, String> toMap(AlgorithmParameters var1);

        public AlgorithmParameterSpec toParameterSpec(Map<String, String> var1);
    }

    public class GcmParamsEncoder
    implements CipherParamsEncoder {
        @Override
        public Map<String, String> toMap(AlgorithmParameters cipherParams) {
            if (cipherParams == null) {
                throw new IllegalStateException("Could not determine initialization vector for cipher");
            }
            GCMParameterSpec spec = cipherParams.getParameterSpec(GCMParameterSpec.class);
            return (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PasswordEncoder$.MODULE$.InitializationVectorProp()), (Object)this.kafka$utils$PasswordEncoder$GcmParamsEncoder$$$outer().kafka$utils$PasswordEncoder$$base64Encode(spec.getIV())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"authenticationTagLength"), (Object)((Object)BoxesRunTime.boxToInteger((int)spec.getTLen())).toString())}));
        }

        @Override
        public AlgorithmParameterSpec toParameterSpec(Map<String, String> paramMap) {
            return new GCMParameterSpec(new StringOps(Predef$.MODULE$.augmentString((String)paramMap.apply((Object)"authenticationTagLength"))).toInt(), this.kafka$utils$PasswordEncoder$GcmParamsEncoder$$$outer().base64Decode((String)paramMap.apply((Object)PasswordEncoder$.MODULE$.InitializationVectorProp())));
        }

        public /* synthetic */ PasswordEncoder kafka$utils$PasswordEncoder$GcmParamsEncoder$$$outer() {
            return PasswordEncoder.this;
        }

        public GcmParamsEncoder() {
            if (PasswordEncoder.this == null) {
                throw null;
            }
        }
    }

    public class IvParamsEncoder
    implements CipherParamsEncoder {
        @Override
        public Map<String, String> toMap(AlgorithmParameters cipherParams) {
            if (cipherParams == null) {
                throw new IllegalStateException("Could not determine initialization vector for cipher");
            }
            IvParameterSpec ivSpec = cipherParams.getParameterSpec(IvParameterSpec.class);
            return (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PasswordEncoder$.MODULE$.InitializationVectorProp()), (Object)this.kafka$utils$PasswordEncoder$IvParamsEncoder$$$outer().kafka$utils$PasswordEncoder$$base64Encode(ivSpec.getIV()))}));
        }

        @Override
        public AlgorithmParameterSpec toParameterSpec(Map<String, String> paramMap) {
            return new IvParameterSpec(this.kafka$utils$PasswordEncoder$IvParamsEncoder$$$outer().base64Decode((String)paramMap.apply((Object)PasswordEncoder$.MODULE$.InitializationVectorProp())));
        }

        public /* synthetic */ PasswordEncoder kafka$utils$PasswordEncoder$IvParamsEncoder$$$outer() {
            return PasswordEncoder.this;
        }

        public IvParamsEncoder() {
            if (PasswordEncoder.this == null) {
                throw null;
            }
        }
    }
}

