/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import joptsimple.OptionSpec;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.utils.Exit$;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001u4A\u0001G\r\u0001=!)\u0011\u0006\u0001C\u0001U!)Q\u0006\u0001C\u0001]!)1\b\u0001C\u0001]!)\u0001\t\u0001C\u0001]!)Q\t\u0001C\u0001]!)q\t\u0001C\u0001]!)\u0011\n\u0001C\u0001]!)1\n\u0001C\u0001]!)Q\n\u0001C\u0001]!)q\n\u0001C\u0001]!)\u0011\u000b\u0001C\u0001]!)1\u000b\u0001C\u0001]!)Q\u000b\u0001C\u0001]!)q\u000b\u0001C\u0001]!)\u0011\f\u0001C\u0001]!)1\f\u0001C\u0001]!)Q\f\u0001C\u0001]!)q\f\u0001C\u0001]!)\u0011\r\u0001C\u0001]!)1\r\u0001C\u0001]!)Q\r\u0001C\u0001]!)q\r\u0001C\u0001]!)\u0011\u000e\u0001C\u0001U\n\t#+Z1tg&<g\u000eU1si&$\u0018n\u001c8t\u0007>lW.\u00198e\u0003J<7\u000fV3ti*\u0011!dG\u0001\u0006C\u0012l\u0017N\u001c\u0006\u00029\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001 !\t\u0001s%D\u0001\"\u0015\t\u00113%A\u0003kk:LGO\u0003\u0002%K\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002M\u0005\u0019qN]4\n\u0005!\n#A\u0003&V]&$8+^5uK\u00061A(\u001b8jiz\"\u0012a\u000b\t\u0003Y\u0001i\u0011!G\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002_A\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t!QK\\5uQ\t\u0011a\u0007\u0005\u00028s5\t\u0001H\u0003\u0002#K%\u0011!\b\u000f\u0002\u0007\u0005\u00164wN]3\u0002\u0011Q,\u0017M\u001d#po:D#aA\u001f\u0011\u0005]r\u0014BA 9\u0005\u0015\te\r^3s\u0003=\u001a\bn\\;mI\u000e{'O]3di2L\b+\u0019:tKZ\u000bG.\u001b3NS:LW.^7HK:,'/\u0019;f\u001fB$\u0018n\u001c8tQ\t!!\t\u0005\u00028\u0007&\u0011A\t\u000f\u0002\u0005)\u0016\u001cH/\u0001\u0018tQ>,H\u000eZ\"peJ,7\r\u001e7z!\u0006\u00148/\u001a,bY&$W*\u001b8j[VlW\t_3dkR,w\n\u001d;j_:\u001c\bFA\u0003C\u00035\u001a\bn\\;mI\u000e{'O]3di2L\b+\u0019:tKZ\u000bG.\u001b3NS:LW.^7WKJLg-_(qi&|gn\u001d\u0015\u0003\r\t\u000b!e\u001d5pk2$\u0017\t\u001c7poRC'o\u001c;uY\u0016|\u0005\u000f^5p]>sW\t_3dkR,\u0007FA\u0004C\u0003i\u0019\bn\\;mIV\u001bX\rR3gCVdGo]%g\u000b:\f'\r\\3eQ\tA!)\u0001\ntQ>,H\u000e\u001a$bS2LeMT8Be\u001e\u001c\bFA\u0005C\u0003Q\u0019\bn\\;mI\u001a\u000b\u0017\u000e\\%g\u00052\fgn[!sO\"\u0012!BQ\u0001&g\"|W\u000f\u001c3O_R\fE\u000e\\8x\u000bb,7-\u001e;f/&$\b\u000eV8qS\u000e\u001cx\n\u001d;j_:D#a\u0003\"\u0002AMDw.\u001e7e\u001d>$\u0018\t\u001c7po\u0016CXmY;uK^KG\u000f\u001b\"s_.,'o\u001d\u0015\u0003\u0019\t\u000baf\u001d5pk2$gj\u001c;BY2|w/\u0012=fGV$XmV5uQ>,HOU3bgNLwM\\7f]R|\u0005\u000f^5p]\"\u0012QBQ\u00015g\"|W\u000f\u001c3O_R\fE\u000e\\8x\u000f\u0016tWM]1uK^KG\u000f[8vi\n\u0013xn[3sg\u0006sG\rV8qS\u000e\u001cx\n\u001d;j_:\u001c\bF\u0001\bC\u0003)\u001a\bn\\;mI:{G/\u00117m_^<UM\\3sCR,w+\u001b;i_V$(I]8lKJ\u001cx\n\u001d;j_:D#a\u0004\"\u0002SMDw.\u001e7e\u001d>$\u0018\t\u001c7po\u001e+g.\u001a:bi\u0016<\u0016\u000e\u001e5pkR$v\u000e]5dg>\u0003H/[8oQ\t\u0001\")\u0001\u0015tQ>,H\u000e\u001a(pi\u0006cGn\\<HK:,'/\u0019;f/&$\b\u000e\u00165s_R$H.Z(qi&|g\u000e\u000b\u0002\u0012\u0005\u0006a3\u000f[8vY\u0012tu\u000e^!mY><x)\u001a8fe\u0006$XmV5uQJ+\u0017m]:jO:lWM\u001c;PaRLwN\u001c\u0015\u0003%\t\u000bQf\u001d5pk2$gj\u001c;BY2|wOV3sS\u001aLx+\u001b;i_V$(+Z1tg&<g.\\3oi>\u0003H/[8oQ\t\u0019\")A\u0015tQ>,H\u000e\u001a(pi\u0006cGn\\<Ce>\\WM]:MSN$x+\u001b;i-\u0016\u0014\u0018NZ=PaRLwN\u001c\u0015\u0003)\t\u000bae\u001d5pk2$gj\u001c;BY2|w\u000f\u00165s_R$H.Z,ji\"4VM]5gs>\u0003H/[8oQ\t)\")\u0001\u0013tQ>,H\u000e\u001a(pi\u0006cGn\\<U_BL7m](qi&|gnV5uQZ+'/\u001b4zQ\t1\")\u0001\btQ>,H\u000e\u001a$bS2<\u0016\u000e\u001e5\u0015\u0007=Z\u0007\u0010C\u0003m/\u0001\u0007Q.A\u0002ng\u001e\u0004\"A\\;\u000f\u0005=\u001c\bC\u000192\u001b\u0005\t(B\u0001:\u001e\u0003\u0019a$o\\8u}%\u0011A/M\u0001\u0007!J,G-\u001a4\n\u0005Y<(AB*ue&twM\u0003\u0002uc!)\u0011p\u0006a\u0001u\u0006!\u0011M]4t!\r\u000140\\\u0005\u0003yF\u0012Q!\u0011:sCf\u0004")
public class ReassignPartitionsCommandArgsTest
extends JUnitSuite {
    @Before
    public void setUp() {
        Exit$.MODULE$.setExitProcedure((Function2 & Serializable & scala.Serializable)(x$1, message) -> ReassignPartitionsCommandArgsTest.$anonfun$setUp$1(BoxesRunTime.unboxToInt((Object)x$1), message));
    }

    @After
    public void tearDown() {
        Exit$.MODULE$.resetExitProcedure();
    }

    @Test
    public void shouldCorrectlyParseValidMinimumGenerateOptions() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--generate", "--broker-list", "101,102", "--topics-to-move-json-file", "myfile.json"});
        ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
    }

    @Test
    public void shouldCorrectlyParseValidMinimumExecuteOptions() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--execute", "--reassignment-json-file", "myfile.json"});
        ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
    }

    @Test
    public void shouldCorrectlyParseValidMinimumVerifyOptions() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--verify", "--reassignment-json-file", "myfile.json"});
        ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
    }

    @Test
    public void shouldAllowThrottleOptionOnExecute() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--execute", "--throttle", "100", "--reassignment-json-file", "myfile.json"});
        ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
    }

    @Test
    public void shouldUseDefaultsIfEnabled() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--execute", "--reassignment-json-file", "myfile.json"});
        ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts = ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
        Assert.assertEquals((long)10000L, (long)BoxesRunTime.unboxToLong((Object)opts.options().valueOf((OptionSpec)opts.timeoutOpt())));
        Assert.assertEquals((long)-1L, (long)BoxesRunTime.unboxToLong((Object)opts.options().valueOf((OptionSpec)opts.interBrokerThrottleOpt())));
    }

    @Test
    public void shouldFailIfNoArgs() {
        String[] args = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        this.shouldFailWith(ReassignPartitionsCommand$.MODULE$.helpText(), args);
    }

    @Test
    public void shouldFailIfBlankArg() {
        String[] args = (String[])((Object[])new String[]{" "});
        this.shouldFailWith("Command must include exactly one action: --generate, --execute or --verify", args);
    }

    @Test
    public void shouldNotAllowExecuteWithTopicsOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--execute", "--reassignment-json-file", "myfile.json", "--topics-to-move-json-file", "myfile.json"});
        this.shouldFailWith("Option \"[execute]\" can't be used with option \"[topics-to-move-json-file]\"", args);
    }

    @Test
    public void shouldNotAllowExecuteWithBrokers() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--execute", "--reassignment-json-file", "myfile.json", "--broker-list", "101,102"});
        this.shouldFailWith("Option \"[execute]\" can't be used with option \"[broker-list]\"", args);
    }

    @Test
    public void shouldNotAllowExecuteWithoutReassignmentOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--execute"});
        this.shouldFailWith("If --execute option is used, command must include --reassignment-json-file that was output during the --generate option", args);
    }

    @Test
    public void shouldNotAllowGenerateWithoutBrokersAndTopicsOptions() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--generate"});
        this.shouldFailWith("If --generate option is used, command must include both --topics-to-move-json-file and --broker-list options", args);
    }

    @Test
    public void shouldNotAllowGenerateWithoutBrokersOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--topics-to-move-json-file", "myfile.json", "--generate"});
        this.shouldFailWith("If --generate option is used, command must include both --topics-to-move-json-file and --broker-list options", args);
    }

    @Test
    public void shouldNotAllowGenerateWithoutTopicsOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--broker-list", "101,102", "--generate"});
        this.shouldFailWith("If --generate option is used, command must include both --topics-to-move-json-file and --broker-list options", args);
    }

    @Test
    public void shouldNotAllowGenerateWithThrottleOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--generate", "--broker-list", "101,102", "--throttle", "100", "--topics-to-move-json-file", "myfile.json"});
        this.shouldFailWith("Option \"[generate]\" can't be used with option \"[throttle]\"", args);
    }

    @Test
    public void shouldNotAllowGenerateWithReassignmentOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--generate", "--broker-list", "101,102", "--topics-to-move-json-file", "myfile.json", "--reassignment-json-file", "myfile.json"});
        this.shouldFailWith("Option \"[generate]\" can't be used with option \"[reassignment-json-file]\"", args);
    }

    @Test
    public void shouldNotAllowVerifyWithoutReassignmentOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--verify"});
        this.shouldFailWith("If --verify option is used, command must include --reassignment-json-file that was used during the --execute option", args);
    }

    @Test
    public void shouldNotAllowBrokersListWithVerifyOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--verify", "--broker-list", "100,101", "--reassignment-json-file", "myfile.json"});
        this.shouldFailWith("Option \"[verify]\" can't be used with option \"[broker-list]\"", args);
    }

    @Test
    public void shouldNotAllowThrottleWithVerifyOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--verify", "--throttle", "100", "--reassignment-json-file", "myfile.json"});
        this.shouldFailWith("Option \"[verify]\" can't be used with option \"[throttle]\"", args);
    }

    @Test
    public void shouldNotAllowTopicsOptionWithVerify() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--verify", "--reassignment-json-file", "myfile.json", "--topics-to-move-json-file", "myfile.json"});
        this.shouldFailWith("Option \"[verify]\" can't be used with option \"[topics-to-move-json-file]\"", args);
    }

    public void shouldFailWith(String msg, String[] args) {
        try {
            ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
            throw this.fail(new StringBuilder(51).append("Should have failed with [").append(msg).append("] but no failure occurred.").toString(), new Position("ReassignPartitionsCommandArgsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        }
        catch (Exception e) {
            Assert.assertTrue((String)new StringBuilder(46).append("Expected exception with message:\n[").append(msg).append("]\nbut was\n[").append(e.getMessage()).append("]").toString(), (boolean)e.getMessage().startsWith(msg));
            return;
        }
    }

    public static final /* synthetic */ Nothing$ $anonfun$setUp$1(int x$1, Option message) {
        throw new IllegalArgumentException((String)message.orNull(Predef$.MODULE$.$conforms()));
    }
}

