/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.util.Collections;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.api.QuotaTestClients;
import kafka.api.QuotaTestClients$;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaType;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua!B\u000f\u001f\u0003\u0003\u0019\u0003\"\u0002\u0015\u0001\t\u0003I\u0003bB\u0016\u0001\u0005\u0004%\t\u0005\f\u0005\u0007g\u0001\u0001\u000b\u0011B\u0017\t\u000bQ\u0002A\u0011C\u001b\t\u000by\u0002A\u0011C\u001b\t\u000b}\u0002a\u0011\u0003!\t\u000fa\u0003!\u0019!C\u0001Y!1\u0011\f\u0001Q\u0001\n5BqA\u0017\u0001C\u0002\u0013\u0005A\u0006\u0003\u0004\\\u0001\u0001\u0006I!\f\u0005\b9\u0002\u0011\r\u0011\"\u0001-\u0011\u0019i\u0006\u0001)A\u0005[!9a\f\u0001b\u0001\n\u0003)\u0004BB0\u0001A\u0003%a\u0007C\u0005R\u0001\u0001\u0007\t\u0019!C\u0001A\"I\u0011\r\u0001a\u0001\u0002\u0004%\tA\u0019\u0005\nQ\u0002\u0001\r\u0011!Q!\nIC\u0011\"\u001b\u0001A\u0002\u0003\u0007I\u0011\u00011\t\u0013)\u0004\u0001\u0019!a\u0001\n\u0003Y\u0007\"C7\u0001\u0001\u0004\u0005\t\u0015)\u0003S\u0011%q\u0007\u00011AA\u0002\u0013\u0005q\u000eC\u0005q\u0001\u0001\u0007\t\u0019!C\u0001c\"I1\u000f\u0001a\u0001\u0002\u0003\u0006K!\u0011\u0005\u0006i\u0002!\t%\u001e\u0005\u0006\u007f\u0002!\t!\u001e\u0005\u0007\u0003\u0013\u0001A\u0011A;\t\r\u00055\u0001\u0001\"\u0001v\u0011\u0019\t\t\u0002\u0001C\u0001k\ni!)Y:f#V|G/\u0019+fgRT!a\b\u0011\u0002\u0007\u0005\u0004\u0018NC\u0001\"\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0013\u0011\u0005\u00152S\"\u0001\u0010\n\u0005\u001dr\"AF%oi\u0016<'/\u0019;j_:$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005Q\u0003CA\u0013\u0001\u0003-\u0019XM\u001d<fe\u000e{WO\u001c;\u0016\u00035\u0002\"AL\u0019\u000e\u0003=R\u0011\u0001M\u0001\u0006g\u000e\fG.Y\u0005\u0003e=\u00121!\u00138u\u00031\u0019XM\u001d<fe\u000e{WO\u001c;!\u0003A\u0001(o\u001c3vG\u0016\u00148\t\\5f]RLE-F\u00017!\t9D(D\u00019\u0015\tI$(\u0001\u0003mC:<'\"A\u001e\u0002\t)\fg/Y\u0005\u0003{a\u0012aa\u0015;sS:<\u0017\u0001E2p]N,X.\u001a:DY&,g\u000e^%e\u0003Y\u0019'/Z1uKF+x\u000e^1UKN$8\t\\5f]R\u001cHcA!E!B\u0011QEQ\u0005\u0003\u0007z\u0011\u0001#U;pi\u0006$Vm\u001d;DY&,g\u000e^:\t\u000b\u00153\u0001\u0019\u0001$\u0002\u000bQ|\u0007/[2\u0011\u0005\u001dseB\u0001%M!\tIu&D\u0001K\u0015\tY%%\u0001\u0004=e>|GOP\u0005\u0003\u001b>\na\u0001\u0015:fI\u00164\u0017BA\u001fP\u0015\tiu\u0006C\u0003R\r\u0001\u0007!+\u0001\u0006mK\u0006$WM\u001d(pI\u0016\u0004\"a\u0015,\u000e\u0003QS!!\u0016\u0011\u0002\rM,'O^3s\u0013\t9FKA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\u0018\u0001\u00063fM\u0006,H\u000e\u001e)s_\u0012,8-\u001a:Rk>$\u0018-A\u000beK\u001a\fW\u000f\u001c;Qe>$WoY3s#V|G/\u0019\u0011\u0002)\u0011,g-Y;mi\u000e{gn];nKJ\fVo\u001c;b\u0003U!WMZ1vYR\u001cuN\\:v[\u0016\u0014\u0018+^8uC\u0002\n1\u0003Z3gCVdGOU3rk\u0016\u001cH/U;pi\u0006\fA\u0003Z3gCVdGOU3rk\u0016\u001cH/U;pi\u0006\u0004\u0013A\u0002;pa&\u001c\u0017'A\u0004u_BL7-\r\u0011\u0016\u0003I\u000ba\u0002\\3bI\u0016\u0014hj\u001c3f?\u0012*\u0017\u000f\u0006\u0002dMB\u0011a\u0006Z\u0005\u0003K>\u0012A!\u00168ji\"9q\rEA\u0001\u0002\u0004\u0011\u0016a\u0001=%c\u0005YA.Z1eKJtu\u000eZ3!\u000311w\u000e\u001c7po\u0016\u0014hj\u001c3f\u0003A1w\u000e\u001c7po\u0016\u0014hj\u001c3f?\u0012*\u0017\u000f\u0006\u0002dY\"9qmEA\u0001\u0002\u0004\u0011\u0016!\u00044pY2|w/\u001a:O_\u0012,\u0007%\u0001\trk>$\u0018\rV3ti\u000ec\u0017.\u001a8ugV\t\u0011)\u0001\u000brk>$\u0018\rV3ti\u000ec\u0017.\u001a8ug~#S-\u001d\u000b\u0003GJDqa\u001a\f\u0002\u0002\u0003\u0007\u0011)A\trk>$\u0018\rV3ti\u000ec\u0017.\u001a8ug\u0002\nQa]3u+B$\u0012a\u0019\u0015\u00031]\u0004\"\u0001_?\u000e\u0003eT!A_>\u0002\u000b),h.\u001b;\u000b\u0003q\f1a\u001c:h\u0013\tq\u0018P\u0001\u0004CK\u001a|'/Z\u0001\u001ei\u0016\u001cH\u000f\u00165s_R$H.\u001a3Qe>$WoY3s\u0007>t7/^7fe\"\u001a\u0011$a\u0001\u0011\u0007a\f)!C\u0002\u0002\be\u0014A\u0001V3ti\u00069C/Z:u!J|G-^2fe\u000e{gn];nKJ|e/\u001a:sS\u0012,WK\u001c;ie>$H\u000f\\3eQ\rQ\u00121A\u0001\u0018i\u0016\u001cH/U;pi\u0006|e/\u001a:sS\u0012,G)\u001a7fi\u0016D3aGA\u0002\u0003Q!Xm\u001d;UQJ|G\u000f\u001e7fIJ+\u0017/^3ti\"\u001aA$a\u0001")
public abstract class BaseQuotaTest
extends IntegrationTestHarness {
    private final int serverCount;
    private final int defaultProducerQuota;
    private final int defaultConsumerQuota;
    private final int defaultRequestQuota;
    private final String topic1;
    private KafkaServer leaderNode;
    private KafkaServer followerNode;
    private QuotaTestClients quotaTestClients;

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    public String producerClientId() {
        return "QuotasTestProducer-1";
    }

    public String consumerClientId() {
        return "QuotasTestConsumer-1";
    }

    public abstract QuotaTestClients createQuotaTestClients(String var1, KafkaServer var2);

    public int defaultProducerQuota() {
        return this.defaultProducerQuota;
    }

    public int defaultConsumerQuota() {
        return this.defaultConsumerQuota;
    }

    public int defaultRequestQuota() {
        return this.defaultRequestQuota;
    }

    public String topic1() {
        return this.topic1;
    }

    public KafkaServer leaderNode() {
        return this.leaderNode;
    }

    public void leaderNode_$eq(KafkaServer x$1) {
        this.leaderNode = x$1;
    }

    public KafkaServer followerNode() {
        return this.followerNode;
    }

    public void followerNode_$eq(KafkaServer x$1) {
        this.followerNode = x$1;
    }

    public QuotaTestClients quotaTestClients() {
        return this.quotaTestClients;
    }

    public void quotaTestClients_$eq(QuotaTestClients x$1) {
        this.quotaTestClients = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        int numPartitions = 1;
        Map<Object, Object> leaders = this.createTopic(this.topic1(), numPartitions, this.serverCount(), this.createTopic$default$4());
        this.leaderNode_$eq(BoxesRunTime.unboxToInt((Object)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0))) == ((KafkaServer)this.servers().head()).config().brokerId() ? (KafkaServer)this.servers().head() : (KafkaServer)this.servers().apply(1));
        this.followerNode_$eq(BoxesRunTime.unboxToInt((Object)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0))) != ((KafkaServer)this.servers().head()).config().brokerId() ? (KafkaServer)this.servers().head() : (KafkaServer)this.servers().apply(1));
        this.quotaTestClients_$eq(this.createQuotaTestClients(this.topic1(), this.leaderNode()));
    }

    @Test
    public void testThrottledProducerConsumer() {
        int numRecords = 1000;
        QuotaTestClients qual$1 = this.quotaTestClients();
        int x$1 = numRecords;
        boolean x$2 = qual$1.produceUntilThrottled$default$2();
        int produced = qual$1.produceUntilThrottled(x$1, x$2);
        QuotaTestClients qual$2 = this.quotaTestClients();
        boolean x$3 = true;
        boolean x$4 = qual$2.verifyProduceThrottle$default$2();
        qual$2.verifyProduceThrottle(x$3, x$4);
        QuotaTestClients qual$3 = this.quotaTestClients();
        int x$5 = produced;
        boolean x$6 = qual$3.consumeUntilThrottled$default$2();
        qual$3.consumeUntilThrottled(x$5, x$6);
        QuotaTestClients qual$4 = this.quotaTestClients();
        boolean x$7 = true;
        boolean x$8 = qual$4.verifyConsumeThrottle$default$2();
        qual$4.verifyConsumeThrottle(x$7, x$8);
    }

    @Test
    public void testProducerConsumerOverrideUnthrottled() {
        Properties props = new Properties();
        props.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        props.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        this.quotaTestClients().overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE, 2.147483647E9);
        QuotaTestClients qual$1 = this.quotaTestClients();
        long x$1 = Long.MAX_VALUE;
        long x$2 = Long.MAX_VALUE;
        double x$3 = 2.147483647E9;
        KafkaServer x$4 = qual$1.waitForQuotaUpdate$default$4();
        qual$1.waitForQuotaUpdate(x$1, x$2, x$3, x$4);
        int numRecords = 1000;
        QuotaTestClients qual$2 = this.quotaTestClients();
        int x$5 = numRecords;
        boolean x$6 = qual$2.produceUntilThrottled$default$2();
        Assert.assertEquals((long)numRecords, (long)qual$2.produceUntilThrottled(x$5, x$6));
        QuotaTestClients qual$3 = this.quotaTestClients();
        boolean x$7 = false;
        boolean x$8 = qual$3.verifyProduceThrottle$default$2();
        qual$3.verifyProduceThrottle(x$7, x$8);
        QuotaTestClients qual$4 = this.quotaTestClients();
        int x$9 = numRecords;
        boolean x$10 = qual$4.consumeUntilThrottled$default$2();
        Assert.assertEquals((long)numRecords, (long)qual$4.consumeUntilThrottled(x$9, x$10));
        QuotaTestClients qual$5 = this.quotaTestClients();
        boolean x$11 = false;
        boolean x$12 = qual$5.verifyConsumeThrottle$default$2();
        qual$5.verifyConsumeThrottle(x$11, x$12);
    }

    @Test
    public void testQuotaOverrideDelete() {
        this.quotaTestClients().overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE, 2.147483647E9);
        QuotaTestClients qual$1 = this.quotaTestClients();
        long x$1 = Long.MAX_VALUE;
        long x$2 = Long.MAX_VALUE;
        double x$3 = 2.147483647E9;
        KafkaServer x$4 = qual$1.waitForQuotaUpdate$default$4();
        qual$1.waitForQuotaUpdate(x$1, x$2, x$3, x$4);
        int numRecords = 1000;
        QuotaTestClients qual$2 = this.quotaTestClients();
        int x$5 = numRecords;
        boolean x$6 = qual$2.produceUntilThrottled$default$2();
        Assert.assertEquals((long)numRecords, (long)qual$2.produceUntilThrottled(x$5, x$6));
        QuotaTestClients qual$3 = this.quotaTestClients();
        boolean x$7 = false;
        boolean x$8 = qual$3.verifyProduceThrottle$default$2();
        qual$3.verifyProduceThrottle(x$7, x$8);
        QuotaTestClients qual$4 = this.quotaTestClients();
        int x$9 = numRecords;
        boolean x$10 = qual$4.consumeUntilThrottled$default$2();
        Assert.assertEquals((long)numRecords, (long)qual$4.consumeUntilThrottled(x$9, x$10));
        QuotaTestClients qual$5 = this.quotaTestClients();
        boolean x$11 = false;
        boolean x$12 = qual$5.verifyConsumeThrottle$default$2();
        qual$5.verifyConsumeThrottle(x$11, x$12);
        this.quotaTestClients().removeQuotaOverrides();
        QuotaTestClients qual$6 = this.quotaTestClients();
        int x$13 = numRecords;
        boolean x$14 = qual$6.produceUntilThrottled$default$2();
        int produced = qual$6.produceUntilThrottled(x$13, x$14);
        QuotaTestClients qual$7 = this.quotaTestClients();
        boolean x$15 = true;
        boolean x$16 = qual$7.verifyProduceThrottle$default$2();
        qual$7.verifyProduceThrottle(x$15, x$16);
        this.quotaTestClients().consumer().seekToBeginning(Collections.singleton(new TopicPartition(this.topic1(), 0)));
        QuotaTestClients qual$8 = this.quotaTestClients();
        int x$17 = numRecords + produced;
        boolean x$18 = qual$8.consumeUntilThrottled$default$2();
        qual$8.consumeUntilThrottled(x$17, x$18);
        QuotaTestClients qual$9 = this.quotaTestClients();
        boolean x$19 = true;
        boolean x$20 = qual$9.verifyConsumeThrottle$default$2();
        qual$9.verifyConsumeThrottle(x$19, x$20);
    }

    @Test
    public void testThrottledRequest() {
        this.quotaTestClients().overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE, 0.1);
        QuotaTestClients qual$1 = this.quotaTestClients();
        long x$1 = Long.MAX_VALUE;
        long x$2 = Long.MAX_VALUE;
        double x$3 = 0.1;
        KafkaServer x$4 = qual$1.waitForQuotaUpdate$default$4();
        qual$1.waitForQuotaUpdate(x$1, x$2, x$3, x$4);
        KafkaConsumer<byte[], byte[]> consumer = this.quotaTestClients().consumer();
        consumer.subscribe(Collections.singleton(this.topic1()));
        long endTimeMs = System.currentTimeMillis() + 10000L;
        boolean throttled = false;
        while (!(throttled && this.quotaTestClients().exemptRequestMetric() != null || System.currentTimeMillis() >= endTimeMs)) {
            consumer.poll(100L);
            KafkaMetric throttleMetric = this.quotaTestClients().throttleMetric((QuotaType)QuotaType.Request$.MODULE$, this.consumerClientId());
            throttled = throttleMetric != null && QuotaTestClients$.MODULE$.metricValue((Metric)throttleMetric) > 0.0;
        }
        Assert.assertTrue((String)"Should have been throttled", (boolean)throttled);
        this.quotaTestClients().verifyConsumerClientThrottleTimeMetric(true, (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)((double)ClientQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds() * 1000.0))));
        KafkaMetric exemptMetric = this.quotaTestClients().exemptRequestMetric();
        Assert.assertNotNull((String)"Exempt requests not recorded", (Object)exemptMetric);
        Assert.assertTrue((String)"Exempt requests not recorded", (QuotaTestClients$.MODULE$.metricValue((Metric)exemptMetric) > 0.0 ? 1 : 0) != 0);
    }

    public BaseQuotaTest() {
        this.serverCount = 2;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "2");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp(), "30000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        this.producerConfig().setProperty("acks", "-1");
        this.producerConfig().setProperty("buffer.memory", "300000");
        this.producerConfig().setProperty("client.id", this.producerClientId());
        this.consumerConfig().setProperty("group.id", "QuotasTest");
        this.consumerConfig().setProperty("max.partition.fetch.bytes", ((Object)BoxesRunTime.boxToInteger((int)4096)).toString());
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("client.id", this.consumerClientId());
        this.consumerConfig().setProperty("fetch.min.bytes", "0");
        this.consumerConfig().setProperty("fetch.max.wait.ms", "0");
        this.defaultProducerQuota = 8000;
        this.defaultConsumerQuota = 2500;
        this.defaultRequestQuota = Integer.MAX_VALUE;
        this.topic1 = "topic-1";
    }
}

