/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.util.Properties;
import kafka.api.BaseQuotaTest;
import kafka.api.QuotaTestClients;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Sanitizer;
import org.junit.Before;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001%3AAB\u0004\u0001\u0019!)\u0011\u0003\u0001C\u0001%!)A\u0003\u0001C!+!)a\u0004\u0001C!+!)q\u0004\u0001C!A!)\u0001\u0007\u0001C!c\t\t2\t\\5f]RLE-U;pi\u0006$Vm\u001d;\u000b\u0005!I\u0011aA1qS*\t!\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001i\u0001C\u0001\b\u0010\u001b\u00059\u0011B\u0001\t\b\u00055\u0011\u0015m]3Rk>$\u0018\rV3ti\u00061A(\u001b8jiz\"\u0012a\u0005\t\u0003\u001d\u0001\t\u0001\u0003\u001d:pIV\u001cWM]\"mS\u0016tG/\u00133\u0016\u0003Y\u0001\"a\u0006\u000f\u000e\u0003aQ!!\u0007\u000e\u0002\t1\fgn\u001a\u0006\u00027\u0005!!.\u0019<b\u0013\ti\u0002D\u0001\u0004TiJLgnZ\u0001\u0011G>t7/^7fe\u000ec\u0017.\u001a8u\u0013\u0012\fQa]3u+B$\u0012!\t\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0005+:LG\u000f\u000b\u0002\u0005QA\u0011\u0011FL\u0007\u0002U)\u00111\u0006L\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002[\u0005\u0019qN]4\n\u0005=R#A\u0002\"fM>\u0014X-\u0001\fde\u0016\fG/Z)v_R\fG+Z:u\u00072LWM\u001c;t)\r\u0011T'\u0011\t\u0003\u001dMJ!\u0001N\u0004\u0003!E+x\u000e^1UKN$8\t\\5f]R\u001c\b\"\u0002\u001c\u0006\u0001\u00049\u0014!\u0002;pa&\u001c\u0007C\u0001\u001d@\u001d\tIT\b\u0005\u0002;G5\t1H\u0003\u0002=\u0017\u00051AH]8pizJ!AP\u0012\u0002\rA\u0013X\rZ3g\u0013\ti\u0002I\u0003\u0002?G!)!)\u0002a\u0001\u0007\u0006QA.Z1eKJtu\u000eZ3\u0011\u0005\u0011;U\"A#\u000b\u0005\u0019K\u0011AB:feZ,'/\u0003\u0002I\u000b\nY1*\u00194lCN+'O^3s\u0001")
public class ClientIdQuotaTest
extends BaseQuotaTest {
    @Override
    public String producerClientId() {
        return "QuotasTestProducer-!@#$%^&*()";
    }

    @Override
    public String consumerClientId() {
        return "QuotasTestConsumer-!@#$%^&*()";
    }

    @Override
    @Before
    public void setUp() {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ProducerQuotaBytesPerSecondDefaultProp(), ((Object)BoxesRunTime.boxToInteger((int)this.defaultProducerQuota())).toString());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ConsumerQuotaBytesPerSecondDefaultProp(), ((Object)BoxesRunTime.boxToInteger((int)this.defaultConsumerQuota())).toString());
        super.setUp();
    }

    @Override
    public QuotaTestClients createQuotaTestClients(String topic, KafkaServer leaderNode) {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        return new QuotaTestClients(this, topic, leaderNode, producer, consumer){
            private final /* synthetic */ ClientIdQuotaTest $outer;

            public KafkaPrincipal userPrincipal() {
                return KafkaPrincipal.ANONYMOUS;
            }

            public Map<String, String> quotaMetricTags(String clientId) {
                return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)clientId)}));
            }

            public void overrideQuotas(long producerQuota, long consumerQuota, double requestQuota) {
                Properties producerProps = new Properties();
                producerProps.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)producerQuota)).toString());
                producerProps.put(DynamicConfig.Client$.MODULE$.RequestPercentageOverrideProp(), ((Object)BoxesRunTime.boxToDouble((double)requestQuota)).toString());
                this.updateQuotaOverride(this.$outer.producerClientId(), producerProps);
                Properties consumerProps = new Properties();
                consumerProps.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)consumerQuota)).toString());
                consumerProps.put(DynamicConfig.Client$.MODULE$.RequestPercentageOverrideProp(), ((Object)BoxesRunTime.boxToDouble((double)requestQuota)).toString());
                this.updateQuotaOverride(this.$outer.consumerClientId(), consumerProps);
            }

            public void removeQuotaOverrides() {
                Properties emptyProps = new Properties();
                this.updateQuotaOverride(this.$outer.producerClientId(), emptyProps);
                this.updateQuotaOverride(this.$outer.consumerClientId(), emptyProps);
            }

            private void updateQuotaOverride(String clientId, Properties properties) {
                this.$outer.adminZkClient().changeClientIdConfig(Sanitizer.sanitize((String)clientId), properties);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(topic$1, leaderNode$1, $outer.producerClientId(), $outer.consumerClientId(), (KafkaProducer<byte[], byte[]>)producer$1, (KafkaConsumer<byte[], byte[]>)consumer$1);
            }
        };
    }
}

