/*
 * Decompiled with CFR 0.152.
 */
package kafka.api.test;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.api.test.ProducerCompressionTest$;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001\u0002\u000b\u0016\u0001qA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\u0006c\u0001!\tA\r\u0005\bm\u0001\u0011\r\u0011\"\u00038\u0011\u0019a\u0004\u0001)A\u0005q!9Q\b\u0001b\u0001\n\u0013q\u0004B\u0002$\u0001A\u0003%q\bC\u0004H\u0001\t\u0007I\u0011B\u001c\t\r!\u0003\u0001\u0015!\u00039\u0011\u001dI\u0005\u00011A\u0005\n)Cq\u0001\u0015\u0001A\u0002\u0013%\u0011\u000b\u0003\u0004X\u0001\u0001\u0006Ka\u0013\u0005\u00061\u0002!\t%\u0017\u0005\u0006G\u0002!\t%\u0017\u0005\u0006Q\u0002!\t!W\u0004\u0006yVA\t! \u0004\u0006)UA\tA \u0005\u0007cA!\t!a\u0003\t\u000f\u00055\u0001\u0003\"\u0001\u0002\u0010!I\u0011Q\t\t\u0002\u0002\u0013%\u0011q\t\u0002\u0018!J|G-^2fe\u000e{W\u000e\u001d:fgNLwN\u001c+fgRT!AF\f\u0002\tQ,7\u000f\u001e\u0006\u00031e\t1!\u00199j\u0015\u0005Q\u0012!B6bM.\f7\u0001A\n\u0003\u0001u\u0001\"AH\u0011\u000e\u0003}Q!\u0001I\r\u0002\u0005i\\\u0017B\u0001\u0012 \u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tg\u0006Y1m\\7qe\u0016\u001c8/[8o!\t)cF\u0004\u0002'YA\u0011qEK\u0007\u0002Q)\u0011\u0011fG\u0001\u0007yI|w\u000e\u001e \u000b\u0003-\nQa]2bY\u0006L!!\f\u0016\u0002\rA\u0013X\rZ3g\u0013\ty\u0003G\u0001\u0004TiJLgn\u001a\u0006\u0003[)\na\u0001P5oSRtDCA\u001a6!\t!\u0004!D\u0001\u0016\u0011\u0015\u0019#\u00011\u0001%\u0003!\u0011'o\\6fe&#W#\u0001\u001d\u0011\u0005eRT\"\u0001\u0016\n\u0005mR#aA%oi\u0006I!M]8lKJLE\rI\u0001\u0006i>\u0004\u0018nY\u000b\u0002\u007fA\u0011\u0001)R\u0007\u0002\u0003*\u0011!iQ\u0001\u0005Y\u0006twMC\u0001E\u0003\u0011Q\u0017M^1\n\u0005=\n\u0015A\u0002;pa&\u001c\u0007%\u0001\u0006ok6\u0014VmY8sIN\f1B\\;n%\u0016\u001cwN\u001d3tA\u000511/\u001a:wKJ,\u0012a\u0013\t\u0003\u0019:k\u0011!\u0014\u0006\u0003\u0013fI!aT'\u0003\u0017-\u000bgm[1TKJ4XM]\u0001\u000bg\u0016\u0014h/\u001a:`I\u0015\fHC\u0001*V!\tI4+\u0003\u0002UU\t!QK\\5u\u0011\u001d1&\"!AA\u0002-\u000b1\u0001\u001f\u00132\u0003\u001d\u0019XM\u001d<fe\u0002\nQa]3u+B$\u0012A\u0015\u0015\u0003\u0019m\u0003\"\u0001X1\u000e\u0003uS!AX0\u0002\u000b),h.\u001b;\u000b\u0003\u0001\f1a\u001c:h\u0013\t\u0011WL\u0001\u0004CK\u001a|'/Z\u0001\ti\u0016\f'\u000fR8x]\"\u0012Q\"\u001a\t\u00039\u001aL!aZ/\u0003\u000b\u00053G/\u001a:\u0002\u001fQ,7\u000f^\"p[B\u0014Xm]:j_:D#A\u00046\u0011\u0005q[\u0017B\u00017^\u0005\u0011!Vm\u001d;)\t\u0001qG/\u001e\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003cv\u000baA];o]\u0016\u0014\u0018BA:q\u0005\u001d\u0011VO\\,ji\"\fQA^1mk\u0016\u001c\u0013A\u001e\t\u0003ojl\u0011\u0001\u001f\u0006\u0003sv\u000bqA];o]\u0016\u00148/\u0003\u0002|q\ni\u0001+\u0019:b[\u0016$XM]5{K\u0012\fq\u0003\u0015:pIV\u001cWM]\"p[B\u0014Xm]:j_:$Vm\u001d;\u0011\u0005Q\u00022\u0003\u0002\t\u0000\u0003\u000b\u00012!OA\u0001\u0013\r\t\u0019A\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u0007e\n9!C\u0002\u0002\n)\u0012AbU3sS\u0006d\u0017N_1cY\u0016$\u0012!`\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001cXCAA\t!\u0019\t\u0019\"!\u0007\u0002\u001e5\u0011\u0011Q\u0003\u0006\u0004\u0003/\u0019\u0015\u0001B;uS2LA!a\u0007\u0002\u0016\tQ1i\u001c7mK\u000e$\u0018n\u001c8\u0011\te\ny\u0002J\u0005\u0004\u0003CQ#!B!se\u0006L\bf\u0002\n\u0002&\u0005}\u0012\u0011\t\t\u0005\u0003O\tID\u0004\u0003\u0002*\u0005Ub\u0002BA\u0016\u0003gqA!!\f\u000229\u0019q%a\f\n\u0003\u0001L!AX0\n\u0005el\u0016bAA\u001cq\u0006i\u0001+\u0019:b[\u0016$XM]5{K\u0012LA!a\u000f\u0002>\tQ\u0001+\u0019:b[\u0016$XM]:\u000b\u0007\u0005]\u00020\u0001\u0003oC6,\u0017EAA\"\u0003uY\u0018N\u001c3fqv\u00043m\\7qe\u0016\u001c8/[8o)f\u0004X\rI\u001f!wBj\u0018a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!\u0013\u0011\u0007\u0001\u000bY%C\u0002\u0002N\u0005\u0013aa\u00142kK\u000e$\b")
public class ProducerCompressionTest
extends ZooKeeperTestHarness {
    private final String compression;
    private final int brokerId;
    private final String topic;
    private final int numRecords;
    private KafkaServer server;

    @Parameterized.Parameters(name="{index} compressionType = {0}")
    public static Collection<String[]> parameters() {
        return ProducerCompressionTest$.MODULE$.parameters();
    }

    private int brokerId() {
        return this.brokerId;
    }

    private String topic() {
        return this.topic;
    }

    private int numRecords() {
        return this.numRecords;
    }

    private KafkaServer server() {
        return this.server;
    }

    private void server_$eq(KafkaServer x$1) {
        this.server = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        this.server_$eq(TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2()));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}))));
        super.tearDown();
    }

    @Test
    public void testCompression() {
        Properties producerProps = new Properties();
        String bootstrapServers = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}))), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        producerProps.put("bootstrap.servers", bootstrapServers);
        producerProps.put("compression.type", this.compression);
        producerProps.put("batch.size", "66000");
        producerProps.put("linger.ms", "200");
        KafkaProducer producer = new KafkaProducer(producerProps, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
        KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(bootstrapServers, TestUtils$.MODULE$.createConsumer$default$2(), TestUtils$.MODULE$.createConsumer$default$3(), TestUtils$.MODULE$.createConsumer$default$4(), TestUtils$.MODULE$.createConsumer$default$5(), TestUtils$.MODULE$.createConsumer$default$6(), TestUtils$.MODULE$.createConsumer$default$7(), TestUtils$.MODULE$.createConsumer$default$8(), TestUtils$.MODULE$.createConsumer$default$9(), TestUtils$.MODULE$.createConsumer$default$10(), TestUtils$.MODULE$.createConsumer$default$11());
        try {
            TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), 1, 1, (Seq<KafkaServer>)new .colon.colon((Object)this.server(), (List)Nil$.MODULE$), TestUtils$.MODULE$.createTopic$default$6());
            int partition = 0;
            IndexedSeq messageValues = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numRecords()).map((Function1 & Serializable & scala.Serializable)i -> ProducerCompressionTest.$anonfun$testCompression$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            long now = System.currentTimeMillis();
            IndexedSeq responses = (IndexedSeq)messageValues.map((Function1 & Serializable & scala.Serializable)message -> producer.send(new ProducerRecord(this.topic(), null, Predef$.MODULE$.long2Long(now), null, (Object)message.getBytes())), IndexedSeq$.MODULE$.canBuildFrom());
            ((TraversableLike)responses.zipWithIndex(IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ProducerCompressionTest.$anonfun$testCompression$3(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                ProducerCompressionTest.$anonfun$testCompression$4(x$1);
                return BoxedUnit.UNIT;
            });
            TopicPartition tp = new TopicPartition(this.topic(), partition);
            consumer.assign(Collections.singleton(tp));
            consumer.seek(tp, 0L);
            Seq records = TestUtils$.MODULE$.consumeRecords(consumer, this.numRecords(), TestUtils$.MODULE$.consumeRecords$default$3());
            ((TraversableLike)((IterableLike)messageValues.zip(records, IndexedSeq$.MODULE$.canBuildFrom())).zipWithIndex(IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)ProducerCompressionTest.$anonfun$testCompression$5(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                ProducerCompressionTest.$anonfun$testCompression$6(now, x$2);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            producer.close();
            consumer.close();
        }
    }

    public static final /* synthetic */ String $anonfun$testCompression$1(int i) {
        return new StringBuilder(5).append("value").append(i).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testCompression$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testCompression$4(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Future future = (Future)tuple2._1();
        int offset = tuple2._2$mcI$sp();
        Assert.assertEquals((long)offset, (long)((RecordMetadata)future.get()).offset());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$testCompression$5(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2;
        Tuple2 tuple22 = check$ifrefutable$2;
        boolean bl = tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testCompression$6(long now$1, Tuple2 x$2) {
        int index;
        Tuple2 tuple2;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = x$2;
                if (tuple22 == null) break block2;
                tuple2 = (Tuple2)tuple22._1();
                index = tuple22._2$mcI$sp();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        String messageValue = (String)tuple2._1();
        ConsumerRecord record = (ConsumerRecord)tuple2._2();
        Assert.assertEquals((Object)messageValue, (Object)new String((byte[])record.value()));
        Assert.assertEquals((long)now$1, (long)record.timestamp());
        Assert.assertEquals((long)index, (long)record.offset());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public ProducerCompressionTest(String compression) {
        this.compression = compression;
        this.brokerId = 0;
        this.topic = "topic";
        this.numRecords = 2000;
        this.server = null;
    }
}

