/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.controller.ControllerEvent;
import kafka.controller.ControllerEventManager;
import kafka.controller.ControllerState;
import kafka.controller.ControllerStats;
import kafka.controller.ControllerTestUtils$;
import kafka.utils.TestUtils$;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t4AAC\u0006\u0001!!)q\u0003\u0001C\u00011!I1\u0004\u0001a\u0001\u0002\u0004%I\u0001\b\u0005\nA\u0001\u0001\r\u00111A\u0005\n\u0005B\u0011b\n\u0001A\u0002\u0003\u0005\u000b\u0015B\u000f\t\u000b!\u0002A\u0011A\u0015\t\u000bM\u0002A\u0011A\u0015\t\u000ba\u0002A\u0011A\u0015\t\u000bi\u0002A\u0011B\u001e\t\u000bM\u0003A\u0011\u0002+\u00035\r{g\u000e\u001e:pY2,'/\u0012<f]Rl\u0015M\\1hKJ$Vm\u001d;\u000b\u00051i\u0011AC2p]R\u0014x\u000e\u001c7fe*\ta\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\t\u0002C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00023A\u0011!\u0004A\u0007\u0002\u0017\u000512m\u001c8ue>dG.\u001a:Fm\u0016tG/T1oC\u001e,'/F\u0001\u001e!\tQb$\u0003\u0002 \u0017\t12i\u001c8ue>dG.\u001a:Fm\u0016tG/T1oC\u001e,'/\u0001\u000ed_:$(o\u001c7mKJ,e/\u001a8u\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0002#KA\u0011!cI\u0005\u0003IM\u0011A!\u00168ji\"9aeAA\u0001\u0002\u0004i\u0012a\u0001=%c\u000592m\u001c8ue>dG.\u001a:Fm\u0016tG/T1oC\u001e,'\u000fI\u0001\ti\u0016\f'\u000fR8x]R\t!\u0005\u000b\u0002\u0006WA\u0011A&M\u0007\u0002[)\u0011afL\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002a\u0005\u0019qN]4\n\u0005Ij#!B!gi\u0016\u0014\u0018a\u0005;fgR\u001cVoY2fgN4W\u000f\\#wK:$\bF\u0001\u00046!\tac'\u0003\u00028[\t!A+Z:u\u0003q!Xm\u001d;Fm\u0016tG\u000f\u00165biRC'o\\<t\u000bb\u001cW\r\u001d;j_:D#aB\u001b\u0002\u000b\rDWmY6\u0015\t\tb\u0014J\u0014\u0005\u0006{!\u0001\rAP\u0001\u000b[\u0016$(/[2OC6,\u0007CA G\u001d\t\u0001E\t\u0005\u0002B'5\t!I\u0003\u0002D\u001f\u00051AH]8pizJ!!R\n\u0002\rA\u0013X\rZ3g\u0013\t9\u0005J\u0001\u0004TiJLgn\u001a\u0006\u0003\u000bNAQA\u0013\u0005A\u0002-\u000bqbY8oiJ|G\u000e\\3s'R\fG/\u001a\t\u000351K!!T\u0006\u0003\u001f\r{g\u000e\u001e:pY2,'o\u0015;bi\u0016DQa\u0014\u0005A\u0002A\u000bq\u0001\u001d:pG\u0016\u001c8\u000fE\u0002\u0013#\nJ!AU\n\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0014!\u0002;j[\u0016\u0014HCA+b!\t1v,D\u0001X\u0015\tA\u0016,\u0001\u0003d_J,'B\u0001.\\\u0003\u001diW\r\u001e:jGNT!\u0001X/\u0002\re\fW.\\3s\u0015\u0005q\u0016aA2p[&\u0011\u0001m\u0016\u0002\u0006)&lWM\u001d\u0005\u0006{%\u0001\rA\u0010")
public class ControllerEventManagerTest {
    private ControllerEventManager controllerEventManager;

    private ControllerEventManager controllerEventManager() {
        return this.controllerEventManager;
    }

    private void controllerEventManager_$eq(ControllerEventManager x$1) {
        this.controllerEventManager = x$1;
    }

    @After
    public void tearDown() {
        block0: {
            if (this.controllerEventManager() == null) break block0;
            this.controllerEventManager().close();
        }
    }

    @Test
    public void testSuccessfulEvent() {
        this.check("kafka.controller:type=ControllerStats,name=AutoLeaderBalanceRateAndTimeMs", (ControllerState)ControllerState.AutoLeaderBalance$.MODULE$, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {});
    }

    @Test
    public void testEventThatThrowsException() {
        this.check("kafka.controller:type=ControllerStats,name=LeaderElectionRateAndTimeMs", (ControllerState)ControllerState.BrokerChange$.MODULE$, (Function0<BoxedUnit>)(Function0 & Serializable & scala.Serializable)() -> {
            throw new NullPointerException();
        });
    }

    private void check(String metricName, ControllerState controllerState, Function0<BoxedUnit> process) {
        ControllerStats controllerStats = new ControllerStats();
        AtomicInteger eventProcessedListenerCount = new AtomicInteger();
        this.controllerEventManager_$eq(new ControllerEventManager(0, controllerStats.rateAndTimeMetrics(), (Function1 & Serializable & scala.Serializable)x$1 -> {
            eventProcessedListenerCount.incrementAndGet();
            return BoxedUnit.UNIT;
        }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {}));
        this.controllerEventManager().start();
        long initialTimerCount = this.timer(metricName).count();
        CountDownLatch latch = new CountDownLatch(1);
        ControllerEvent eventMock = ControllerTestUtils$.MODULE$.createMockControllerEvent(controllerState, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            latch.await();
            process.apply$mcV$sp();
        });
        this.controllerEventManager().put(eventMock);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            ControllerState controllerState = this.controllerEventManager().state();
            ControllerState controllerState2 = controllerState;
            return !(controllerState != null ? !controllerState.equals(controllerState2) : controllerState2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Controller state is not ").append(controllerState).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        latch.countDown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            ControllerState controllerState = this.controllerEventManager().state();
            ControllerState.Idle$ idle$ = ControllerState.Idle$.MODULE$;
            return !(controllerState != null ? !controllerState.equals(idle$) : idle$ != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Controller state has not changed back to Idle", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertEquals((long)1L, (long)eventProcessedListenerCount.get());
        Assert.assertEquals((String)"Timer has not been updated", (long)(initialTimerCount + 1L), (long)this.timer(metricName).count());
    }

    private Timer timer(String metricName) {
        return (Timer)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ControllerEventManagerTest.$anonfun$timer$1(metricName, x$2))).values().headOption().getOrElse((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Assert.fail((String)new StringBuilder(22).append("Unable to find metric ").append(metricName).toString()));
    }

    public static final /* synthetic */ boolean $anonfun$timer$1(String metricName$1, MetricName x$2) {
        String string = x$2.getMBeanName();
        String string2 = metricName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }
}

