/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import kafka.api.LeaderAndIsr$;
import kafka.controller.ControllerEvent;
import kafka.controller.ControllerState;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.LogCaptureAppender;
import kafka.utils.LogCaptureAppender$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.PreferredReplicaElectionZNode$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.kafka.common.errors.StaleBrokerEpochException;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeqLike;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\t=c\u0001\u0002\u001a4\u0001aBQa\u0010\u0001\u0005\u0002\u0001Cqa\u0011\u0001A\u0002\u0013\u0005A\tC\u0004T\u0001\u0001\u0007I\u0011\u0001+\t\rm\u0003\u0001\u0015)\u0003F\u0011\u001da\u0006A1A\u0005\u0002uCa!\u0019\u0001!\u0002\u0013q\u0006b\u00022\u0001\u0005\u0004%\t!\u0018\u0005\u0007G\u0002\u0001\u000b\u0011\u00020\t\u000b\u0011\u0004A\u0011I3\t\u000b=\u0004A\u0011I3\t\u000bQ\u0004A\u0011A3\t\u000be\u0004A\u0011A3\t\u000bm\u0004A\u0011A3\t\u000bu\u0004A\u0011A3\t\u000b}\u0004A\u0011A3\t\r\u0005\r\u0001\u0001\"\u0001f\u0011\u0019\t9\u0001\u0001C\u0001K\"1\u00111\u0002\u0001\u0005\u0002\u0015Da!a\u0004\u0001\t\u0003)\u0007BBA\n\u0001\u0011\u0005Q\r\u0003\u0004\u0002\u0018\u0001!\t!\u001a\u0005\u0007\u00037\u0001A\u0011A3\t\r\u0005}\u0001\u0001\"\u0001f\u0011\u0019\t\u0019\u0003\u0001C\u0001K\"1\u0011q\u0005\u0001\u0005\u0002\u0015Da!a\u000b\u0001\t\u0003)\u0007BBA\u0018\u0001\u0011\u0005Q\r\u0003\u0004\u00024\u0001!\t!\u001a\u0005\u0007\u0003o\u0001A\u0011A3\t\r\u0005m\u0002\u0001\"\u0001f\u0011\u0019\ty\u0004\u0001C\u0001K\"1\u00111\t\u0001\u0005\u0002\u0015Da!a\u0012\u0001\t\u0003)\u0007BBA&\u0001\u0011\u0005Q\r\u0003\u0004\u0002P\u0001!\t!\u001a\u0005\b\u0003'\u0002A\u0011BA+\u0011\u001d\t\t\u0007\u0001C\u0005\u0003GBq!!)\u0001\t\u0013\t\u0019\u000bC\u0004\u00024\u0002!I!!.\t\u000f\u0005\u0015\u0007\u0001\"\u0003\u0002H\"9\u0011q\u001c\u0001\u0005\n\u0005\u0005\b\"\u0003B\u0003\u0001E\u0005I\u0011\u0002B\u0004\u0011%\u0011i\u0002AI\u0001\n\u0013\u00119\u0001C\u0005\u0003 \u0001\t\n\u0011\"\u0003\u0003\b!I!\u0011\u0005\u0001\u0012\u0002\u0013%!1\u0005\u0005\n\u0005O\u0001\u0011\u0013!C\u0005\u0005GA\u0011B!\u000b\u0001#\u0003%IAa\t\t\u000f\t-\u0002\u0001\"\u0003\u0003.!9!1\n\u0001\u0005\n\t5#!G\"p]R\u0014x\u000e\u001c7fe&sG/Z4sCRLwN\u001c+fgRT!\u0001N\u001b\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u00017\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u001d\u0011\u0005ijT\"A\u001e\u000b\u0005q*\u0014A\u0001>l\u0013\tq4H\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0005\u0003\"A\u0011\u0001\u000e\u0003M\nqa]3sm\u0016\u00148/F\u0001F!\r15*T\u0007\u0002\u000f*\u0011\u0001*S\u0001\u000bG>dG.Z2uS>t'\"\u0001&\u0002\u000bM\u001c\u0017\r\\1\n\u00051;%aA*fcB\u0011a*U\u0007\u0002\u001f*\u0011\u0001+N\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005I{%aC&bM.\f7+\u001a:wKJ\f1b]3sm\u0016\u00148o\u0018\u0013fcR\u0011Q+\u0017\t\u0003-^k\u0011!S\u0005\u00031&\u0013A!\u00168ji\"9!lAA\u0001\u0002\u0004)\u0015a\u0001=%c\u0005A1/\u001a:wKJ\u001c\b%\u0001\u000bgSJ\u001cHoQ8oiJ|G\u000e\\3s\u000bB|7\r[\u000b\u0002=B\u0011akX\u0005\u0003A&\u00131!\u00138u\u0003U1\u0017N]:u\u0007>tGO]8mY\u0016\u0014X\t]8dQ\u0002\nQDZ5sgR\u001cuN\u001c;s_2dWM]#q_\u000eD'l\u001b,feNLwN\\\u0001\u001fM&\u00148\u000f^\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195[WZ+'o]5p]\u0002\nQa]3u+B$\u0012!\u0016\u0015\u0003\u0013\u001d\u0004\"\u0001[7\u000e\u0003%T!A[6\u0002\u000b),h.\u001b;\u000b\u00031\f1a\u001c:h\u0013\tq\u0017N\u0001\u0004CK\u001a|'/Z\u0001\ti\u0016\f'\u000fR8x]\"\u0012!\"\u001d\t\u0003QJL!a]5\u0003\u000b\u00053G/\u001a:\u0002!Q,7\u000f^#naRL8\t\\;ti\u0016\u0014\bFA\u0006w!\tAw/\u0003\u0002yS\n!A+Z:u\u00035\"Xm\u001d;D_:$(o\u001c7mKJ,\u0005o\\2i!\u0016\u00148/[:ug^CWM\\!mY\n\u0013xn[3sg\u0012{wO\u001c\u0015\u0003\u0019Y\f1\u0006^3ti\u000e{g\u000e\u001e:pY2,'/T8wK&s7M]3nK:$8oQ8oiJ|G\u000e\\3s\u000bB|7\r\u001b\u0015\u0003\u001bY\fQ\u0005^3ti6+G/\u00193bi\u0006\u0004&o\u001c9bO\u0006$\u0018n\u001c8P]\u000e{g\u000e\u001e:pYBc\u0017M\\3)\u000591\u0018!\n;fgRlU\r^1eCR\f\u0007K]8qC\u001e\fG/[8o\u001f:\u0014%o\\6fe\u000eC\u0017M\\4fQ\tya/A\tuKN$Hk\u001c9jG\u000e\u0013X-\u0019;j_:D#\u0001\u0005<\u0002GQ,7\u000f\u001e+pa&\u001c7I]3bi&|gnV5uQ>3g\r\\5oKJ+\u0007\u000f\\5dC\"\u0012\u0011C^\u0001\u001ci\u0016\u001cH\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0012=qC:\u001c\u0018n\u001c8)\u0005I1\u0018!\f;fgR$v\u000e]5d!\u0006\u0014H/\u001b;j_:,\u0005\u0010]1og&|gnV5uQ>3g\r\\5oKJ+\u0007\u000f\\5dC\"\u00121C^\u0001\u001ai\u0016\u001cH\u000fU1si&$\u0018n\u001c8SK\u0006\u001c8/[4o[\u0016tG\u000f\u000b\u0002\u0015m\u0006QD/Z:u!\u0006\u0014H/\u001b;j_:\u0014V-Y:tS\u001etW.\u001a8u/&$\bn\u00144gY&tWMU3qY&\u001c\u0017\rS1mi&tw\r\u0015:pOJ,7o\u001d\u0015\u0003+Y\fq\u0007^3tiB\u000b'\u000f^5uS>t'+Z1tg&<g.\\3oiJ+7/^7fg\u00063G/\u001a:SKBd\u0017nY1D_6,7o\u00148mS:,\u0007F\u0001\fw\u0003\t\"Xm\u001d;Qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dC2+\u0017\rZ3s\u000b2,7\r^5p]\"\u0012qC^\u0001.i\u0016\u001cHOQ1dWR{')Y2l!J,g-\u001a:sK\u0012\u0014V\r\u001d7jG\u0006dU-\u00193fe\u0016cWm\u0019;j_:\u001c\bF\u0001\rw\u0003u\"Xm\u001d;Qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dC2+\u0017\rZ3s\u000b2,7\r^5p]^KG\u000f[(gM2Lg.\u001a)sK\u001a,'O]3e%\u0016\u0004H.[2bQ\tIb/\u0001\u0014uKN$\u0018)\u001e;p!J,g-\u001a:sK\u0012\u0014V\r\u001d7jG\u0006dU-\u00193fe\u0016cWm\u0019;j_:D#A\u0007<\u0002\tR,7\u000f\u001e'fC\u0012,'/\u00118e\u0013N\u0014x\u000b[3o\u000b:$\u0018N]3JgJ|eM\u001a7j]\u0016\fe\u000eZ+oG2,\u0017M\u001c'fC\u0012,'/\u00127fGRLwN\u001c#jg\u0006\u0014G.\u001a3)\u0005m1\u0018a\u0011;fgRdU-\u00193fe\u0006sG-S:s/\",g.\u00128uSJ,\u0017j\u001d:PM\u001ad\u0017N\\3B]\u0012,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:,e.\u00192mK\u0012D#\u0001\b<\u0002-Q,7\u000f^\"p]R\u0014x\u000e\u001c7fINCW\u000f\u001e3po:D#!\b<\u0002\u0003R,7\u000f^\"p]R\u0014x\u000e\u001c7feJ+'.Z2u\u0007>tGO]8mY\u0016$7\u000b[;uI><hNU3rk\u0016\u001cHoV5uQN#\u0018\r\\3Ce>\\WM]#q_\u000eD\u0007F\u0001\u0010w\u0003\u0005\"Xm\u001d;D_:$(o\u001c7mKJluN^3P]R{\u0007/[2De\u0016\fG/[8oQ\tyb/A\u0011uKN$8i\u001c8ue>dG.\u001a:N_Z,wJ\u001c+pa&\u001cG)\u001a7fi&|g\u000e\u000b\u0002!m\u0006aC/Z:u\u0007>tGO]8mY\u0016\u0014Xj\u001c<f\u001f:\u0004&/\u001a4feJ,GMU3qY&\u001c\u0017-\u00127fGRLwN\u001c\u0015\u0003CY\f\u0011\u0006^3ti\u000e{g\u000e\u001e:pY2,'/T8wK>s\u0007+\u0019:uSRLwN\u001c*fCN\u001c\u0018n\u001a8nK:$\bF\u0001\u0012w\u0003\r\"Xm\u001d;D_:$(o\u001c7mKJ$U\r^3diN\u0014u.\u001e8dK\u0012\u0014%o\\6feND#a\t<\u0002%Q,7\u000f^\"p]R\u0014x\u000e\u001c7fe6{g/\u001a\u000b\u0004+\u0006]\u0003bBA-I\u0001\u0007\u00111L\u0001\u0004MVt\u0007\u0003\u0002,\u0002^UK1!a\u0018J\u0005%1UO\\2uS>t\u0007'\u0001\u0010qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dC2+\u0017\rZ3s\u000b2,7\r^5p]RYQ+!\u001a\u0002j\u00055\u00141QAO\u0011\u0019\t9'\na\u0001=\u0006a1m\u001c8ue>dG.\u001a:JI\"1\u00111N\u0013A\u00025\u000b1b\u001c;iKJ\u0014%o\\6fe\"9\u0011qN\u0013A\u0002\u0005E\u0014A\u0001;q!\u0011\t\u0019(a \u000e\u0005\u0005U$\u0002BA<\u0003s\naaY8n[>t'b\u0001\u001c\u0002|)\u0019\u0011QP6\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\t\t)!\u001e\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"9\u0011QQ\u0013A\u0002\u0005\u001d\u0015\u0001\u0003:fa2L7-Y:\u0011\u000b\u0005%\u0015q\u00130\u000f\t\u0005-\u00151\u0013\t\u0004\u0003\u001bKUBAAH\u0015\r\t\tjN\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005U\u0015*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00033\u000bYJA\u0002TKRT1!!&J\u0011\u0019\ty*\na\u0001=\u0006YA.Z1eKJ,\u0005o\\2i\u0003a9\u0018-\u001b;V]RLGnQ8oiJ|G\u000e\\3s\u000bB|7\r\u001b\u000b\u0006+\u0006\u0015\u0016\u0011\u0016\u0005\u0007\u0003O3\u0003\u0019\u00010\u0002\u000b\u0015\u0004xn\u00195\t\u000f\u0005-f\u00051\u0001\u0002.\u00069Q.Z:tC\u001e,\u0007\u0003BAE\u0003_KA!!-\u0002\u001c\n11\u000b\u001e:j]\u001e\fQc^1ji\u001a{'\u000fU1si&$\u0018n\u001c8Ti\u0006$X\rF\u0006V\u0003o\u000bI,!0\u0002B\u0006\r\u0007bBA8O\u0001\u0007\u0011\u0011\u000f\u0005\u0007\u0003w;\u0003\u0019\u00010\u0002\u001f\r|g\u000e\u001e:pY2,'/\u00129pG\"Da!a0(\u0001\u0004q\u0016A\u00027fC\u0012,'\u000f\u0003\u0004\u0002 \u001e\u0002\rA\u0018\u0005\b\u0003W;\u0003\u0019AAW\u0003aI7/\u0012=qK\u000e$X\r\u001a)beRLG/[8o'R\fG/\u001a\u000b\u000b\u0003\u0013\fy-!7\u0002\\\u0006u\u0007c\u0001,\u0002L&\u0019\u0011QZ%\u0003\u000f\t{w\u000e\\3b]\"9\u0011\u0011\u001b\u0015A\u0002\u0005M\u0017a\u00077fC\u0012,'/S:s\u0003:$7i\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000eE\u0002C\u0003+L1!a64\u0005maU-\u00193fe&\u001b(/\u00118e\u0007>tGO]8mY\u0016\u0014X\t]8dQ\"1\u00111\u0018\u0015A\u0002yCa!a0)\u0001\u0004q\u0006BBAPQ\u0001\u0007a,A\u0006nC.,7+\u001a:wKJ\u001cHcD#\u0002d\u0006\u001d\u00181^Ax\u0003g\fiP!\u0001\t\r\u0005\u0015\u0018\u00061\u0001_\u0003)qW/\\\"p]\u001aLwm\u001d\u0005\n\u0003SL\u0003\u0013!a\u0001\u0003\u0013\f\u0011$Y;u_2+\u0017\rZ3s%\u0016\u0014\u0017\r\\1oG\u0016,e.\u00192mK\"I\u0011Q^\u0015\u0011\u0002\u0003\u0007\u0011\u0011Z\u0001\u001ck:\u001cG.Z1o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o\u000b:\f'\r\\3\t\u0013\u0005E\u0018\u0006%AA\u0002\u0005%\u0017\u0001G3oC\ndWmQ8oiJ|G\u000e\\3e'\",H\u000fZ8x]\"I\u0011Q_\u0015\u0011\u0002\u0003\u0007\u0011q_\u0001\nY&\u001cH/\u001a8feN\u0004RAVA}\u0003[K1!a?J\u0005\u0019y\u0005\u000f^5p]\"I\u0011q`\u0015\u0011\u0002\u0003\u0007\u0011q_\u0001\u001cY&\u001cH/\u001a8feN+7-\u001e:jif\u0004&o\u001c;pG>dW*\u00199\t\u0013\t\r\u0011\u0006%AA\u0002\u0005]\u0018\u0001G2p]R\u0014x\u000e\u001c)mC:,G*[:uK:,'OT1nK\u0006)R.Y6f'\u0016\u0014h/\u001a:tI\u0011,g-Y;mi\u0012\u0012TC\u0001B\u0005U\u0011\tIMa\u0003,\u0005\t5\u0001\u0003\u0002B\b\u00053i!A!\u0005\u000b\t\tM!QC\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u0006J\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00057\u0011\tBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ#\\1lKN+'O^3sg\u0012\"WMZ1vYR$3'A\u000bnC.,7+\u001a:wKJ\u001cH\u0005Z3gCVdG\u000f\n\u001b\u0002+5\f7.Z*feZ,'o\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!Q\u0005\u0016\u0005\u0003o\u0014Y!A\u000bnC.,7+\u001a:wKJ\u001cH\u0005Z3gCVdG\u000f\n\u001c\u0002+5\f7.Z*feZ,'o\u001d\u0013eK\u001a\fW\u000f\u001c;%o\u0005)A/[7feR!!q\u0006B$!\u0011\u0011\tDa\u0011\u000e\u0005\tM\"\u0002\u0002B\u001b\u0005o\tAaY8sK*!!\u0011\bB\u001e\u0003\u001diW\r\u001e:jGNTAA!\u0010\u0003@\u00051\u00110Y7nKJT!A!\u0011\u0002\u0007\r|W.\u0003\u0003\u0003F\tM\"!\u0002+j[\u0016\u0014\bb\u0002B%a\u0001\u0007\u0011QV\u0001\u000b[\u0016$(/[2OC6,\u0017!D4fi\u000e{g\u000e\u001e:pY2,'\u000fF\u0001N\u0001")
public class ControllerIntegrationTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.empty();
    private final int firstControllerEpoch = KafkaController$.MODULE$.InitialControllerEpoch() + 1;
    private final int firstControllerEpochZkVersion = KafkaController$.MODULE$.InitialControllerEpochZkVersion() + 1;

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public int firstControllerEpoch() {
        return this.firstControllerEpoch;
    }

    public int firstControllerEpochZkVersion() {
        return this.firstControllerEpochZkVersion;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.empty()));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testEmptyCluster() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.zkClient().getControllerId().isDefined(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to elect a controller", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.waitUntilControllerEpoch(this.firstControllerEpoch(), "broker failed to set controller epoch");
    }

    @Test
    public void testControllerEpochPersistsWhenAllBrokersDown() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.zkClient().getControllerId().isDefined(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to elect a controller", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.waitUntilControllerEpoch(this.firstControllerEpoch(), "broker failed to set controller epoch");
        ((KafkaServer)this.servers().head()).shutdown();
        ((KafkaServer)this.servers().head()).awaitShutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !this.zkClient().getControllerId().isDefined(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to kill controller", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.waitUntilControllerEpoch(this.firstControllerEpoch(), "controller epoch was not persisted after broker failure");
    }

    @Test
    public void testControllerMoveIncrementsControllerEpoch() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.zkClient().getControllerId().isDefined(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to elect a controller", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.waitUntilControllerEpoch(this.firstControllerEpoch(), "broker failed to set controller epoch");
        ((KafkaServer)this.servers().head()).shutdown();
        ((KafkaServer)this.servers().head()).awaitShutdown();
        ((KafkaServer)this.servers().head()).startup();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.zkClient().getControllerId().isDefined(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to elect a controller", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.waitUntilControllerEpoch(this.firstControllerEpoch() + 1, "controller epoch was not incremented after controller move");
    }

    @Test
    public void testMetadataPropagationOnControlPlane() {
        int x$1 = 1;
        Some x$2 = new Some((Object)"PLAINTEXT://localhost:0,CONTROLLER://localhost:5000");
        Some x$3 = new Some((Object)"PLAINTEXT:PLAINTEXT,CONTROLLER:PLAINTEXT");
        Some x$4 = new Some((Object)"CONTROLLER");
        boolean x$5 = this.makeServers$default$2();
        boolean x$6 = this.makeServers$default$3();
        boolean x$7 = this.makeServers$default$4();
        this.servers_$eq(this.makeServers(x$1, x$5, x$6, x$7, (Option<String>)x$2, (Option<String>)x$3, (Option<String>)x$4));
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
        scala.collection.mutable.Map controlPlaneMetricMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Map dataPlaneMetricMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((KafkaServer)this.servers().head()).metrics().metrics().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)kafkaMetric -> {
            Object object = kafkaMetric.metricName().tags().values().contains("CONTROLLER") ? controlPlaneMetricMap.put((Object)kafkaMetric.metricName().name(), kafkaMetric) : BoxedUnit.UNIT;
            return kafkaMetric.metricName().tags().values().contains("PLAINTEXT") ? dataPlaneMetricMap.put((Object)kafkaMetric.metricName().name(), kafkaMetric) : BoxedUnit.UNIT;
        });
        Assert.assertEquals((double)1.0, (double)BoxesRunTime.unboxToDouble((Object)((KafkaMetric)controlPlaneMetricMap.get((Object)"response-total").get()).metricValue()), (double)0.0);
        Assert.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)((KafkaMetric)dataPlaneMetricMap.get((Object)"response-total").get()).metricValue()), (double)0.0);
        Assert.assertEquals((double)1.0, (double)BoxesRunTime.unboxToDouble((Object)((KafkaMetric)controlPlaneMetricMap.get((Object)"request-total").get()).metricValue()), (double)0.0);
        Assert.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)((KafkaMetric)dataPlaneMetricMap.get((Object)"request-total").get()).metricValue()), (double)0.0);
        Assert.assertTrue((BoxesRunTime.unboxToDouble((Object)((KafkaMetric)controlPlaneMetricMap.get((Object)"incoming-byte-total").get()).metricValue()) > 1.0 ? 1 : 0) != 0);
        Assert.assertTrue((BoxesRunTime.unboxToDouble((Object)((KafkaMetric)dataPlaneMetricMap.get((Object)"incoming-byte-total").get()).metricValue()) == 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((BoxesRunTime.unboxToDouble((Object)((KafkaMetric)controlPlaneMetricMap.get((Object)"network-io-total").get()).metricValue()) == 2.0 ? 1 : 0) != 0);
        Assert.assertTrue((BoxesRunTime.unboxToDouble((Object)((KafkaMetric)dataPlaneMetricMap.get((Object)"network-io-total").get()).metricValue()) == 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testMetadataPropagationOnBrokerChange() {
        this.servers_$eq(this.makeServers(3, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaServer testBroker = (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerChange$1(controllerId, e)))).head();
        Seq remainingBrokers = (Seq)this.servers().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerChange$2(testBroker, x$1)));
        String topic = "topic1";
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaServer)remainingBrokers.apply(0)).config().brokerId(), testBroker.config().brokerId()}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), remainingBrokers.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerChange$3(x$2)), Seq$.MODULE$.canBuildFrom()))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)assignment, this.servers());
        testBroker.shutdown();
        testBroker.awaitShutdown();
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated((Seq<KafkaServer>)remainingBrokers, TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
        remainingBrokers.foreach((Function1 & Serializable & scala.Serializable)server -> {
            ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerChange$4(topic, testBroker, assignment, remainingBrokers, server);
            return BoxedUnit.UNIT;
        });
        testBroker.startup();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !this.servers().exists((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)assignment.exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerChange$7(server, topic$1, x0$1))))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Inconsistent metadata after broker startup", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testTopicCreation() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
    }

    @Test
    public void testTopicCreationWithOfflineReplica() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testTopicCreationWithOfflineReplica$1(x$3)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> x$4 != controllerId)).head());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, (Seq<KafkaServer>)((Seq)this.servers().take(1)));
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
    }

    @Test
    public void testTopicPartitionExpansion() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        TopicPartition tp0 = new TopicPartition("t", 0);
        TopicPartition tp1 = new TopicPartition("t", 1);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp0.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        scala.collection.immutable.Map expandedAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp0.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.zkClient().setTopicAssignment(tp0.topic(), expandedAssignment, this.firstControllerEpochZkVersion());
        this.waitForPartitionState(tp1, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic partition expansion");
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), tp1.topic(), tp1.partition(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
    }

    @Test
    public void testTopicPartitionExpansionWithOfflineReplica() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testTopicPartitionExpansionWithOfflineReplica$1(x$5)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$6 -> x$6 != controllerId)).head());
        TopicPartition tp0 = new TopicPartition("t", 0);
        TopicPartition tp1 = new TopicPartition("t", 1);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp0.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})))}));
        scala.collection.immutable.Map expandedAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp0.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        this.zkClient().setTopicAssignment(tp0.topic(), expandedAssignment, this.firstControllerEpochZkVersion());
        this.waitForPartitionState(tp1, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic partition expansion");
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{(KafkaServer)this.servers().apply(controllerId)}))), tp1.topic(), tp1.partition(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
    }

    @Test
    public void testPartitionReassignment() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        String metricName = new StringBuilder(43).append("kafka.controller:type=ControllerStats,name=").append(ControllerState.PartitionReassignment$.MODULE$.rateAndTimeMetricName().get()).toString();
        long timerCount = this.timer(metricName).count();
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testPartitionReassignment$1(x$7)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$8 -> x$8 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        scala.collection.immutable.Map reassignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.zkClient().createPartitionReassignment(reassignment);
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 3, "failed to get expected partition state after partition reassignment");
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            scala.collection.immutable.Map map = this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()})));
            scala.collection.immutable.Map map2 = reassignment;
            return !(map != null ? !map.equals(map2) : map2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to get updated partition assignment on topic znode after partition reassignment", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !this.zkClient().reassignPartitionsInProgress(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to remove reassign partitions path after completion", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        long updatedTimerCount = this.timer(metricName).count();
        Assert.assertTrue((String)new StringBuilder(36).append("Timer count ").append(updatedTimerCount).append(" should be greater than ").append(timerCount).toString(), (updatedTimerCount > timerCount ? 1 : 0) != 0);
    }

    @Test
    public void testPartitionReassignmentWithOfflineReplicaHaltingProgress() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testPartitionReassignmentWithOfflineReplicaHaltingProgress$1(x$9)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$10 -> x$10 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        scala.collection.immutable.Map reassignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        KafkaServer controller = this.getController();
        this.zkClient().setOrCreatePartitionReassignment((Map)reassignment, controller.kafkaController().controllerContext().epochZkVersion());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state during partition reassignment with offline replica");
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.zkClient().reassignPartitionsInProgress(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "partition reassignment path should remain while reassignment in progress", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testPartitionReassignmentResumesAfterReplicaComesOnline() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$1(x$11)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$12 -> x$12 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        scala.collection.immutable.Map reassignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        this.zkClient().createPartitionReassignment(reassignment);
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state during partition reassignment with offline replica");
        ((KafkaServer)this.servers().apply(otherBrokerId)).startup();
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 4, "failed to get expected partition state after partition reassignment");
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            scala.collection.immutable.Map map = this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()})));
            scala.collection.immutable.Map map2 = reassignment;
            return !(map != null ? !map.equals(map2) : map2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to get updated partition assignment on topic znode after partition reassignment", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !this.zkClient().reassignPartitionsInProgress(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to remove reassign partitions path after completion", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testPreferredReplicaLeaderElection() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testPreferredReplicaLeaderElection$1(controllerId, x$13))).get();
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBroker.config().brokerId(), controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.preferredReplicaLeaderElection(controllerId, otherBroker, tp, (scala.collection.immutable.Set<Object>)((TraversableOnce)assignment.apply((Object)BoxesRunTime.boxToInteger((int)tp.partition()))).toSet(), LeaderAndIsr$.MODULE$.initialLeaderEpoch());
    }

    @Test
    public void testBackToBackPreferredReplicaLeaderElections() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testBackToBackPreferredReplicaLeaderElections$1(controllerId, x$14))).get();
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBroker.config().brokerId(), controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.preferredReplicaLeaderElection(controllerId, otherBroker, tp, (scala.collection.immutable.Set<Object>)((TraversableOnce)assignment.apply((Object)BoxesRunTime.boxToInteger((int)tp.partition()))).toSet(), LeaderAndIsr$.MODULE$.initialLeaderEpoch());
        this.preferredReplicaLeaderElection(controllerId, otherBroker, tp, (scala.collection.immutable.Set<Object>)((TraversableOnce)assignment.apply((Object)BoxesRunTime.boxToInteger((int)tp.partition()))).toSet(), LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 2);
    }

    @Test
    public void testPreferredReplicaLeaderElectionWithOfflinePreferredReplica() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testPreferredReplicaLeaderElectionWithOfflinePreferredReplica$1(x$15)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$16 -> x$16 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        this.zkClient().createPreferredReplicaElection((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !this.zkClient().pathExists(PreferredReplicaElectionZNode$.MODULE$.path()), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to remove preferred replica leader election path after giving up", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state upon broker shutdown");
    }

    @Test
    public void testAutoPreferredReplicaLeaderElection() {
        this.servers_$eq(this.makeServers(2, true, this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testAutoPreferredReplicaLeaderElection$1(x$17)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$18 -> x$18 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state upon broker shutdown");
        ((KafkaServer)this.servers().apply(otherBrokerId)).startup();
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 2, "failed to get expected partition state upon broker startup");
    }

    @Test
    public void testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled$1(x$19)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$20 -> x$20 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            scala.collection.immutable.Map leaderIsrAndControllerEpochMap = this.zkClient().getTopicPartitionStates((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
            if (!leaderIsrAndControllerEpochMap.contains((Object)tp)) return false;
            if (!this.isExpectedPartitionState((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp), this.firstControllerEpoch(), LeaderAndIsr$.MODULE$.NoLeader(), LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1)) return false;
            List list = ((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp)).leaderAndIsr().isr();
            List list2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId}));
            if (list != null) {
                if (!list.equals(list2)) return false;
                return true;
            }
            if (list2 == null) return true;
            return false;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to get expected partition state after entire isr went offline", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled() {
        int x$1 = 2;
        boolean x$2 = true;
        boolean x$3 = this.makeServers$default$2();
        boolean x$4 = this.makeServers$default$4();
        Option<String> x$5 = this.makeServers$default$5();
        Option<String> x$6 = this.makeServers$default$6();
        Option<String> x$7 = this.makeServers$default$7();
        this.servers_$eq(this.makeServers(x$1, x$3, x$2, x$4, x$5, x$6, x$7));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled$1(x$21)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$22 -> x$22 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        ((KafkaServer)this.servers().apply(1)).shutdown();
        ((KafkaServer)this.servers().apply(1)).awaitShutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            scala.collection.immutable.Map leaderIsrAndControllerEpochMap = this.zkClient().getTopicPartitionStates((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
            if (!leaderIsrAndControllerEpochMap.contains((Object)tp)) return false;
            if (!this.isExpectedPartitionState((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp), this.firstControllerEpoch(), LeaderAndIsr$.MODULE$.NoLeader(), LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1)) return false;
            List list = ((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp)).leaderAndIsr().isr();
            List list2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId}));
            if (list != null) {
                if (!list.equals(list2)) return false;
                return true;
            }
            if (list2 == null) return true;
            return false;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to get expected partition state after entire isr went offline", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testControlledShutdown() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        int partition = 1;
        Seq serverConfigs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
        this.servers_$eq((Seq<KafkaServer>)((Seq)serverConfigs.reverseMap((Function1 & Serializable & scala.Serializable)s -> TestUtils$.MODULE$.createServer((KafkaConfig)s, TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, this.servers());
        int controllerId = BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().get());
        KafkaController controller = ((KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$3(controllerId, p))).get()).kafkaController();
        LinkedBlockingQueue resultQueue = new LinkedBlockingQueue();
        Function1 & Serializable & scala.Serializable controlledShutdownCallback = (Function1 & Serializable & scala.Serializable)controlledShutdownResult -> {
            resultQueue.put(controlledShutdownResult);
            return BoxedUnit.UNIT;
        };
        controller.controlledShutdown(2, ((KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$5(x$23))).get()).kafkaController().brokerEpoch(), (Function1)controlledShutdownCallback);
        Set partitionsRemaining = (Set)((Try)resultQueue.take()).get();
        ObjectRef activeServers = ObjectRef.create((Object)((Seq)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$6(s)))));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((Seq)activeServers$1.elem).forall((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$8(topic, partition, x$24))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Topic test not created after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertEquals((long)0L, (long)partitionsRemaining.size());
        UpdateMetadataRequest.PartitionState partitionStateInfo = (UpdateMetadataRequest.PartitionState)((KafkaServer)((Seq)activeServers.elem).head()).dataPlaneRequestProcessor().metadataCache().getPartitionInfo(topic, partition).get();
        int leaderAfterShutdown = partitionStateInfo.basePartitionState.leader;
        Assert.assertEquals((long)0L, (long)leaderAfterShutdown);
        Assert.assertEquals((long)2L, (long)partitionStateInfo.basePartitionState.isr.size());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)JavaConverters$.MODULE$.asScalaBufferConverter(partitionStateInfo.basePartitionState.isr).asScala());
        controller.controlledShutdown(1, ((KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$10(x$25))).get()).kafkaController().brokerEpoch(), (Function1)controlledShutdownCallback);
        partitionsRemaining = (Set)((Try)resultQueue.take()).get();
        Assert.assertEquals((long)0L, (long)partitionsRemaining.size());
        activeServers.elem = (Seq)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$11(s)));
        partitionStateInfo = (UpdateMetadataRequest.PartitionState)((KafkaServer)((Seq)activeServers.elem).head()).dataPlaneRequestProcessor().metadataCache().getPartitionInfo(topic, partition).get();
        leaderAfterShutdown = partitionStateInfo.basePartitionState.leader;
        Assert.assertEquals((long)0L, (long)leaderAfterShutdown);
        Assert.assertTrue((boolean)this.servers().forall((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$12(topic, partition, x$26))));
        controller.controlledShutdown(0, ((KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$13(x$27))).get()).kafkaController().brokerEpoch(), (Function1)controlledShutdownCallback);
        partitionsRemaining = (Set)((Try)resultQueue.take()).get();
        Assert.assertEquals((long)1L, (long)partitionsRemaining.size());
        Assert.assertTrue((boolean)this.servers().forall((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$14(topic, partition, x$28))));
    }

    @Test
    public void testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch() {
        Seq serverConfigs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
        this.servers_$eq((Seq<KafkaServer>)((Seq)serverConfigs.reverseMap((Function1 & Serializable & scala.Serializable)s -> TestUtils$.MODULE$.createServer((KafkaConfig)s, TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        KafkaController controller = this.getController().kafkaController();
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch$3(controller, e))).get();
        VolatileBooleanRef staleBrokerEpochDetected = VolatileBooleanRef.create((boolean)false);
        controller.controlledShutdown(otherBroker.config().brokerId(), otherBroker.kafkaController().brokerEpoch() - 1L, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            ControllerIntegrationTest.$anonfun$testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch$4(staleBrokerEpochDetected, x0$1);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> staleBrokerEpochDetected$1.elem, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Fail to detect stale broker epoch", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testControllerMoveOnTopicCreation() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        this.testControllerMove((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AdminZkClient adminZkClient = new AdminZkClient(this.zkClient());
            adminZkClient.createTopicWithAssignment(tp.topic(), new Properties(), (Map)assignment);
        });
    }

    @Test
    public void testControllerMoveOnTopicDeletion() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.testControllerMove((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AdminZkClient adminZkClient = new AdminZkClient(this.zkClient());
            adminZkClient.deleteTopic(tp.topic());
        });
    }

    @Test
    public void testControllerMoveOnPreferredReplicaElection() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.testControllerMove((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.zkClient().createPreferredReplicaElection((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))));
    }

    @Test
    public void testControllerMoveOnPartitionReassignment() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7()));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        scala.collection.immutable.Map reassignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        this.testControllerMove((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.zkClient().createPartitionReassignment(reassignment));
    }

    @Test
    public void testControllerDetectsBouncedBrokers() {
        int x$1 = 2;
        boolean x$2 = false;
        boolean x$3 = this.makeServers$default$2();
        boolean x$4 = this.makeServers$default$3();
        Option<String> x$5 = this.makeServers$default$5();
        Option<String> x$6 = this.makeServers$default$6();
        Option<String> x$7 = this.makeServers$default$7();
        this.servers_$eq(this.makeServers(x$1, x$3, x$4, x$2, x$5, x$6, x$7));
        KafkaController controller = this.getController().kafkaController();
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControllerDetectsBouncedBrokers$1(controller, e))).get();
        TopicPartition tp = new TopicPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            ControllerState controllerState = controller.eventManager().state();
            ControllerState.Idle$ idle$ = ControllerState.Idle$.MODULE$;
            return !(controllerState != null ? !controllerState.equals(idle$) : idle$ != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Controller event thread is still busy", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        CountDownLatch latch = new CountDownLatch(1);
        controller.eventManager().put((ControllerEvent)new KafkaController.AwaitOnLatch(latch));
        otherBroker.shutdown();
        otherBroker.startup();
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToInt((Object)otherBroker.replicaManager().partitionCount().value()));
        latch.countDown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)otherBroker.replicaManager().partitionCount().value()) == 1 && otherBroker.replicaManager().metadataCache().getAllTopics().size() == 1 && otherBroker.replicaManager().metadataCache().getAliveBrokers().size() == 2, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Broker fail to initialize after restart", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private void testControllerMove(Function0<BoxedUnit> fun) {
        KafkaController controller = this.getController().kafkaController();
        LogCaptureAppender appender = LogCaptureAppender$.MODULE$.createAndRegister();
        Level previousLevel = LogCaptureAppender$.MODULE$.setClassLoggerLevel(controller.eventManager().thread().getClass(), Level.INFO);
        try {
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                ControllerState controllerState = controller.eventManager().state();
                ControllerState.Idle$ idle$ = ControllerState.Idle$.MODULE$;
                return !(controllerState != null ? !controllerState.equals(idle$) : idle$ != null);
            }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Controller event thread is still busy", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            CountDownLatch latch = new CountDownLatch(1);
            controller.eventManager().put((ControllerEvent)new KafkaController.AwaitOnLatch(latch));
            fun.apply$mcV$sp();
            this.zkClient().deleteController(controller.controllerContext().epochZkVersion());
            this.zkClient().registerControllerAndIncrementControllerEpoch(this.servers().size());
            latch.countDown();
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !controller.isActive(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Controller fails to resign", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            Option event = appender.getMessages().find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControllerMove$5(e)));
            Assert.assertTrue((boolean)event.isDefined());
        }
        finally {
            LogCaptureAppender$.MODULE$.unregister(appender);
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(controller.eventManager().thread().getClass(), previousLevel);
        }
    }

    private void preferredReplicaLeaderElection(int controllerId, KafkaServer otherBroker, TopicPartition tp, scala.collection.immutable.Set<Object> replicas, int leaderEpoch) {
        otherBroker.shutdown();
        otherBroker.awaitShutdown();
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, leaderEpoch + 1, "failed to get expected partition state upon broker shutdown");
        otherBroker.startup();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            scala.collection.immutable.Set set = ((TraversableOnce)this.zkClient().getInSyncReplicasForPartition(new TopicPartition(tp.topic(), tp.partition())).get()).toSet();
            scala.collection.immutable.Set set2 = replicas;
            return !(set != null ? !set.equals(set2) : set2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "restarted broker failed to join in-sync replicas", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.zkClient().createPreferredReplicaElection((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !this.zkClient().pathExists(PreferredReplicaElectionZNode$.MODULE$.path()), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to remove preferred replica leader election path after completion", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBroker.config().brokerId(), leaderEpoch + 2, "failed to get expected partition state upon broker startup");
    }

    private void waitUntilControllerEpoch(int epoch, String message) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.zkClient().getControllerEpoch().map((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToInteger((int)x$29._1$mcI$sp())).contains((Object)BoxesRunTime.boxToInteger((int)epoch)), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private void waitForPartitionState(TopicPartition tp, int controllerEpoch, int leader, int leaderEpoch, String message) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            scala.collection.immutable.Map leaderIsrAndControllerEpochMap = this.zkClient().getTopicPartitionStates((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
            return leaderIsrAndControllerEpochMap.contains((Object)tp) && this.isExpectedPartitionState((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp), controllerEpoch, leader, leaderEpoch);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private boolean isExpectedPartitionState(LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch, int controllerEpoch, int leader, int leaderEpoch) {
        return leaderIsrAndControllerEpoch.controllerEpoch() == controllerEpoch && leaderIsrAndControllerEpoch.leaderAndIsr().leader() == leader && leaderIsrAndControllerEpoch.leaderAndIsr().leaderEpoch() == leaderEpoch;
    }

    private Seq<KafkaServer> makeServers(int numConfigs, boolean autoLeaderRebalanceEnable, boolean uncleanLeaderElectionEnable, boolean enableControlledShutdown, Option<String> listeners, Option<String> listenerSecurityProtocolMap, Option<String> controlPlaneListenerName) {
        Seq<Properties> configs = TestUtils$.MODULE$.createBrokerConfigs(numConfigs, this.zkConnect(), enableControlledShutdown, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14());
        configs.foreach((Function1 & Serializable & scala.Serializable)config -> {
            ControllerIntegrationTest.$anonfun$makeServers$1(autoLeaderRebalanceEnable, uncleanLeaderElectionEnable, listeners, listenerSecurityProtocolMap, controlPlaneListenerName, config);
            return BoxedUnit.UNIT;
        });
        return (Seq)configs.map((Function1 & Serializable & scala.Serializable)config -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom());
    }

    private boolean makeServers$default$2() {
        return false;
    }

    private boolean makeServers$default$3() {
        return false;
    }

    private boolean makeServers$default$4() {
        return true;
    }

    private Option<String> makeServers$default$5() {
        return None$.MODULE$;
    }

    private Option<String> makeServers$default$6() {
        return None$.MODULE$;
    }

    private Option<String> makeServers$default$7() {
        return None$.MODULE$;
    }

    private Timer timer(String metricName) {
        return (Timer)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$timer$1(metricName, x$30))).values().headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fail(new StringBuilder(22).append("Unable to find metric ").append(metricName).toString(), new Position("ControllerIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 633)));
    }

    private KafkaServer getController() {
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        return (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$getController$1(controllerId, s)))).head();
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationOnBrokerChange$1(int controllerId$1, KafkaServer e) {
        return e.config().brokerId() != controllerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationOnBrokerChange$2(KafkaServer testBroker$1, KafkaServer x$1) {
        return x$1.config().brokerId() != testBroker$1.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testMetadataPropagationOnBrokerChange$3(KafkaServer x$2) {
        return x$2.config().brokerId();
    }

    public static final /* synthetic */ void $anonfun$testMetadataPropagationOnBrokerChange$4(String topic$1, KafkaServer testBroker$1, scala.collection.immutable.Map assignment$1, Seq remainingBrokers$1, KafkaServer server) {
        UpdateMetadataRequest.PartitionState offlineReplicaPartitionInfo = (UpdateMetadataRequest.PartitionState)server.metadataCache().getPartitionInfo(topic$1, 0).get();
        Assert.assertEquals((long)1L, (long)offlineReplicaPartitionInfo.offlineReplicas.size());
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)testBroker$1.config().brokerId()), offlineReplicaPartitionInfo.offlineReplicas.get(0));
        Assert.assertEquals((Object)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)assignment$1.apply((Object)BoxesRunTime.boxToInteger((int)0))).asJava(), (Object)offlineReplicaPartitionInfo.basePartitionState.replicas);
        Assert.assertEquals((Object)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaServer)remainingBrokers$1.head()).config().brokerId()}))).asJava(), (Object)offlineReplicaPartitionInfo.basePartitionState.isr);
        UpdateMetadataRequest.PartitionState onlinePartitionInfo = (UpdateMetadataRequest.PartitionState)server.metadataCache().getPartitionInfo(topic$1, 1).get();
        Assert.assertEquals((Object)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)assignment$1.apply((Object)BoxesRunTime.boxToInteger((int)1))).asJava(), (Object)onlinePartitionInfo.basePartitionState.replicas);
        Assert.assertTrue((boolean)onlinePartitionInfo.offlineReplicas.isEmpty());
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationOnBrokerChange$7(KafkaServer server$1, String topic$1, Tuple2 x0$1) {
        boolean bl;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int partitionId = tuple2._1$mcI$sp();
            Seq replicas = (Seq)tuple2._2();
            Option partitionInfoOpt = server$1.metadataCache().getPartitionInfo(topic$1, partitionId);
            if (partitionInfoOpt.isDefined()) {
                UpdateMetadataRequest.PartitionState partitionInfo = (UpdateMetadataRequest.PartitionState)partitionInfoOpt.get();
                bl = !partitionInfo.offlineReplicas.isEmpty() || !((GenSeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionInfo.basePartitionState.replicas).asScala()).equals((Object)replicas);
            } else {
                bl = true;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ int $anonfun$testTopicCreationWithOfflineReplica$1(KafkaServer x$3) {
        return x$3.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testTopicPartitionExpansionWithOfflineReplica$1(KafkaServer x$5) {
        return x$5.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testPartitionReassignment$1(KafkaServer x$7) {
        return x$7.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testPartitionReassignmentWithOfflineReplicaHaltingProgress$1(KafkaServer x$9) {
        return x$9.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$1(KafkaServer x$11) {
        return x$11.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testPreferredReplicaLeaderElection$1(int controllerId$7, KafkaServer x$13) {
        return x$13.config().brokerId() != controllerId$7;
    }

    public static final /* synthetic */ boolean $anonfun$testBackToBackPreferredReplicaLeaderElections$1(int controllerId$8, KafkaServer x$14) {
        return x$14.config().brokerId() != controllerId$8;
    }

    public static final /* synthetic */ int $anonfun$testPreferredReplicaLeaderElectionWithOfflinePreferredReplica$1(KafkaServer x$15) {
        return x$15.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testAutoPreferredReplicaLeaderElection$1(KafkaServer x$17) {
        return x$17.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled$1(KafkaServer x$19) {
        return x$19.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled$1(KafkaServer x$21) {
        return x$21.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$3(int controllerId$13, KafkaServer p) {
        return p.config().brokerId() == controllerId$13;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$5(KafkaServer x$23) {
        return x$23.config().brokerId() == 2;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$6(KafkaServer s) {
        return s.config().brokerId() != 2;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$8(String topic$2, int partition$1, KafkaServer x$24) {
        return ((UpdateMetadataRequest.PartitionState)x$24.dataPlaneRequestProcessor().metadataCache().getPartitionInfo((String)topic$2, (int)partition$1).get()).basePartitionState.isr.size() != 3;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$10(KafkaServer x$25) {
        return x$25.config().brokerId() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$11(KafkaServer s) {
        return s.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$12(String topic$2, int partition$1, KafkaServer x$26) {
        return ((UpdateMetadataRequest.PartitionState)x$26.dataPlaneRequestProcessor().metadataCache().getPartitionInfo((String)topic$2, (int)partition$1).get()).basePartitionState.leader == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$13(KafkaServer x$27) {
        return x$27.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$14(String topic$2, int partition$1, KafkaServer x$28) {
        return ((UpdateMetadataRequest.PartitionState)x$28.dataPlaneRequestProcessor().metadataCache().getPartitionInfo((String)topic$2, (int)partition$1).get()).basePartitionState.leader == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch$3(KafkaController controller$1, KafkaServer e) {
        return e.config().brokerId() != controller$1.config().brokerId();
    }

    public static final /* synthetic */ void $anonfun$testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch$4(VolatileBooleanRef staleBrokerEpochDetected$1, Try x0$1) {
        Failure failure;
        Throwable exception;
        Try try_ = x0$1;
        if (try_ instanceof Failure && (exception = (failure = (Failure)try_).exception()) instanceof StaleBrokerEpochException) {
            staleBrokerEpochDetected$1.elem = true;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$testControllerDetectsBouncedBrokers$1(KafkaController controller$2, KafkaServer e) {
        return e.config().brokerId() != controller$2.config().brokerId();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$testControllerMove$5(LoggingEvent e) {
        Level level = e.getLevel();
        Level level2 = Level.INFO;
        if (level == null) {
            if (level2 != null) {
                return false;
            }
        } else if (!level.equals(level2)) return false;
        if (e.getThrowableInformation() == null) return false;
        if (!e.getThrowableInformation().getThrowable().getClass().getName().equals(new ControllerMovedException("").getClass().getName())) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$makeServers$1(boolean autoLeaderRebalanceEnable$1, boolean uncleanLeaderElectionEnable$1, Option listeners$1, Option listenerSecurityProtocolMap$1, Option controlPlaneListenerName$1, Properties config) {
        config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)autoLeaderRebalanceEnable$1)).toString());
        config.setProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)uncleanLeaderElectionEnable$1)).toString());
        config.setProperty(KafkaConfig$.MODULE$.LeaderImbalanceCheckIntervalSecondsProp(), "1");
        listeners$1.foreach((Function1 & Serializable & scala.Serializable)listener -> config.setProperty(KafkaConfig$.MODULE$.ListenersProp(), (String)listener));
        listenerSecurityProtocolMap$1.foreach((Function1 & Serializable & scala.Serializable)listenerMap -> config.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), (String)listenerMap));
        controlPlaneListenerName$1.foreach((Function1 & Serializable & scala.Serializable)controlPlaneListener -> config.setProperty(KafkaConfig$.MODULE$.ControlPlaneListenerNameProp(), (String)controlPlaneListener));
    }

    public static final /* synthetic */ boolean $anonfun$timer$1(String metricName$1, MetricName x$30) {
        String string = x$30.getMBeanName();
        String string2 = metricName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getController$1(int controllerId$14, KafkaServer s) {
        return s.config().brokerId() == controllerId$14;
    }
}

