/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import kafka.controller.ControllerContext;
import kafka.controller.ControllerStats;
import kafka.controller.PartitionLeaderElectionAlgorithms$;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u3Aa\u0005\u000b\u00013!)A\u0005\u0001C\u0001K!9\u0001\u0006\u0001a\u0001\n\u0013I\u0003bB\u0017\u0001\u0001\u0004%IA\f\u0005\u0007o\u0001\u0001\u000b\u0015\u0002\u0016\t\u000ba\u0002A\u0011A\u001d\t\u000b\u0001\u0003A\u0011A\u001d\t\u000b\u0015\u0003A\u0011A\u001d\t\u000b\u001d\u0003A\u0011A\u001d\t\u000b%\u0003A\u0011A\u001d\t\u000b-\u0003A\u0011A\u001d\t\u000b5\u0003A\u0011A\u001d\t\u000b=\u0003A\u0011A\u001d\t\u000bE\u0003A\u0011A\u001d\t\u000bM\u0003A\u0011A\u001d\t\u000bU\u0003A\u0011A\u001d\t\u000b]\u0003A\u0011A\u001d\t\u000be\u0003A\u0011A\u001d\t\u000bm\u0003A\u0011A\u001d\u0003KA\u000b'\u000f^5uS>tG*Z1eKJ,E.Z2uS>t\u0017\t\\4pe&$\b.\\:UKN$(BA\u000b\u0017\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002/\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u001b!\tY\"%D\u0001\u001d\u0015\tib$A\u0003kk:LGO\u0003\u0002 A\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002C\u0005\u0019qN]4\n\u0005\rb\"A\u0003&V]&$8+^5uK\u00061A(\u001b8jiz\"\u0012A\n\t\u0003O\u0001i\u0011\u0001F\u0001\u0012G>tGO]8mY\u0016\u00148i\u001c8uKb$X#\u0001\u0016\u0011\u0005\u001dZ\u0013B\u0001\u0017\u0015\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010^\u0001\u0016G>tGO]8mY\u0016\u00148i\u001c8uKb$x\fJ3r)\tyS\u0007\u0005\u00021g5\t\u0011GC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014G\u0001\u0003V]&$\bb\u0002\u001c\u0004\u0003\u0003\u0005\rAK\u0001\u0004q\u0012\n\u0014AE2p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yi\u0002\nQa]3u+B$\u0012a\f\u0015\u0003\u000bm\u0002\"\u0001\u0010 \u000e\u0003uR!!\b\u0011\n\u0005}j$A\u0002\"fM>\u0014X-\u0001\u0012uKN$xJ\u001a4mS:,\u0007+\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\u001c\u0015\u0003\r\t\u0003\"\u0001P\"\n\u0005\u0011k$\u0001\u0002+fgR\fQ\n^3ti>3g\r\\5oKB\u000b'\u000f^5uS>tG*Z1eKJ,E.Z2uS>tG*Y:u\u0013N\u0014xJ\u001a4mS:,WK\\2mK\u0006tG*Z1eKJ,E.Z2uS>tG)[:bE2,G\r\u000b\u0002\b\u0005\u0006aE/Z:u\u001f\u001a4G.\u001b8f!\u0006\u0014H/\u001b;j_:dU-\u00193fe\u0016cWm\u0019;j_:d\u0015m\u001d;JgJ|eM\u001a7j]\u0016,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:,e.\u00192mK\u0012D#\u0001\u0003\"\u0002GQ,7\u000f\u001e*fCN\u001c\u0018n\u001a8QCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000b2,7\r^5p]\"\u0012\u0011BQ\u00011i\u0016\u001cHOU3bgNLwM\u001c)beRLG/[8o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o/&$\bNT8MSZ,\u0017j\u001d:)\u0005)\u0011\u0015a\f;fgR\u0014V-Y:tS\u001et\u0007+\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\\,ji\",U\u000e\u001d;z\u0013N\u0014\bFA\u0006C\u0003-\"Xm\u001d;Qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dCB\u000b'\u000f^5uS>tG*Z1eKJ,E.Z2uS>t\u0007F\u0001\u0007C\u0003\u001d#Xm\u001d;Qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dCB\u000b'\u000f^5uS>tG*Z1eKJ,E.Z2uS>t\u0007K]3gKJ\u0014X\r\u001a*fa2L7-Y%o\u0013N\u0014hj\u001c;MSZ,\u0007FA\u0007C\u0003\u001d#Xm\u001d;Qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dCB\u000b'\u000f^5uS>tG*Z1eKJ,E.Z2uS>t\u0007K]3gKJ\u0014X\r\u001a*fa2L7-\u0019(pi&s\u0017j\u001d:MSZ,\u0007F\u0001\bC\u0003)#Xm\u001d;Qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dCB\u000b'\u000f^5uS>tG*Z1eKJ,E.Z2uS>t\u0007K]3gKJ\u0014X\r\u001a*fa2L7-\u0019(pi&s\u0017j\u001d:O_Rd\u0015N^3)\u0005=\u0011\u0015!\f;fgR\u001cuN\u001c;s_2dW\rZ*ikR$wn\u001e8QCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000b2,7\r^5p]\"\u0012\u0001CQ\u0001Ai\u0016\u001cHoQ8oiJ|G\u000e\\3e'\",H\u000fZ8x]B\u000b'\u000f^5uS>tG*Z1eKJ,E.Z2uS>tG*Y:u\u0013N\u00148\u000b[;ui&tw\rR8x]\"\u0012\u0011CQ\u0001Ji\u0016\u001cHoQ8oiJ|G\u000e\\3e'\",H\u000fZ8x]B\u000b'\u000f^5uS>tG*Z1eKJ,E.Z2uS>t\u0017\t\u001c7JgJ\u001c\u0016.\\;mi\u0006tWm\\;tYf\u001c\u0006.\u001e;e_^t\u0007F\u0001\nC\u0001")
public class PartitionLeaderElectionAlgorithmsTest
extends JUnitSuite {
    private ControllerContext controllerContext = null;

    private ControllerContext controllerContext() {
        return this.controllerContext;
    }

    private void controllerContext_$eq(ControllerContext x$1) {
        this.controllerContext = x$1;
    }

    @Before
    public void setUp() {
        this.controllerContext_$eq(new ControllerContext());
        ControllerStats qual$1 = this.controllerContext().stats();
        String x$1 = "UncleanLeaderElectionsPerSec";
        Map x$2 = qual$1.removeMetric$default$2();
        qual$1.removeMetric(x$1, x$2);
    }

    @Test
    public void testOfflinePartitionLeaderElection() {
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.offlinePartitionLeaderElection(assignment, isr, liveReplicas, false, this.controllerContext());
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)), (Object)leaderOpt);
    }

    @Test
    public void testOfflinePartitionLeaderElectionLastIsrOfflineUncleanLeaderElectionDisabled() {
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.offlinePartitionLeaderElection(assignment, isr, liveReplicas, false, this.controllerContext());
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
        Assert.assertEquals((long)0L, (long)this.controllerContext().stats().uncleanLeaderElectionRate().count());
    }

    @Test
    public void testOfflinePartitionLeaderElectionLastIsrOfflineUncleanLeaderElectionEnabled() {
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.offlinePartitionLeaderElection(assignment, isr, liveReplicas, true, this.controllerContext());
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)), (Object)leaderOpt);
        Assert.assertEquals((long)1L, (long)this.controllerContext().stats().uncleanLeaderElectionRate().count());
    }

    @Test
    public void testReassignPartitionLeaderElection() {
        Seq reassignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.reassignPartitionLeaderElection(reassignment, isr, liveReplicas);
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)), (Object)leaderOpt);
    }

    @Test
    public void testReassignPartitionLeaderElectionWithNoLiveIsr() {
        Seq reassignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Set liveReplicas = Predef$.MODULE$.Set().empty();
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.reassignPartitionLeaderElection(reassignment, isr, liveReplicas);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testReassignPartitionLeaderElectionWithEmptyIsr() {
        Seq reassignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.empty();
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.reassignPartitionLeaderElection(reassignment, isr, liveReplicas);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testPreferredReplicaPartitionLeaderElection() {
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection(assignment, isr, liveReplicas);
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), (Object)leaderOpt);
    }

    @Test
    public void testPreferredReplicaPartitionLeaderElectionPreferredReplicaInIsrNotLive() {
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Set liveReplicas = Predef$.MODULE$.Set().empty();
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection(assignment, isr, liveReplicas);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testPreferredReplicaPartitionLeaderElectionPreferredReplicaNotInIsrLive() {
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection(assignment, isr, liveReplicas);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testPreferredReplicaPartitionLeaderElectionPreferredReplicaNotInIsrNotLive() {
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.empty();
        Set liveReplicas = Predef$.MODULE$.Set().empty();
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection(assignment, isr, liveReplicas);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testControlledShutdownPartitionLeaderElection() {
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set shuttingDownBrokers = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.controlledShutdownPartitionLeaderElection(assignment, isr, liveReplicas, shuttingDownBrokers);
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)), (Object)leaderOpt);
    }

    @Test
    public void testControlledShutdownPartitionLeaderElectionLastIsrShuttingDown() {
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set shuttingDownBrokers = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.controlledShutdownPartitionLeaderElection(assignment, isr, liveReplicas, shuttingDownBrokers);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testControlledShutdownPartitionLeaderElectionAllIsrSimultaneouslyShutdown() {
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set shuttingDownBrokers = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.controlledShutdownPartitionLeaderElection(assignment, isr, liveReplicas, shuttingDownBrokers);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }
}

