/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Properties;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.Log;
import kafka.log.LogCleaner$;
import kafka.log.LogSegment;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.immutable.Set;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001-3A!\u0003\u0006\u0001\u001f!)A\u0003\u0001C\u0001+!9q\u0003\u0001b\u0001\n\u0003A\u0002B\u0002\u0014\u0001A\u0003%\u0011\u0004C\u0004(\u0001\t\u0007I\u0011\u0001\u0015\t\r=\u0002\u0001\u0015!\u0003*\u0011\u001d\u0001\u0004A1A\u0005\u0002EBa\u0001\u0010\u0001!\u0002\u0013\u0011\u0004\"B\u001f\u0001\t\u0003q$!\u0007'pO\u000ecW-\u00198fe&sG/Z4sCRLwN\u001c+fgRT!a\u0003\u0007\u0002\u00071|wMC\u0001\u000e\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E\u0011R\"\u0001\u0006\n\u0005MQ!!I!cgR\u0014\u0018m\u0019;M_\u001e\u001cE.Z1oKJLe\u000e^3he\u0006$\u0018n\u001c8UKN$\u0018A\u0002\u001fj]&$h\bF\u0001\u0017!\t\t\u0002!A\u0003d_\u0012,7-F\u0001\u001a!\tQB%D\u0001\u001c\u0015\taR$\u0001\u0004sK\u000e|'\u000f\u001a\u0006\u0003=}\taaY8n[>t'BA\u0007!\u0015\t\t#%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002G\u0005\u0019qN]4\n\u0005\u0015Z\"aD\"p[B\u0014Xm]:j_:$\u0016\u0010]3\u0002\r\r|G-Z2!\u0003\u0011!\u0018.\\3\u0016\u0003%\u0002\"AK\u0017\u000e\u0003-R!\u0001\f\u0007\u0002\u000bU$\u0018\u000e\\:\n\u00059Z#\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N,\u0012A\r\t\u0004gYBT\"\u0001\u001b\u000b\u0003U\nQa]2bY\u0006L!a\u000e\u001b\u0003\u000b\u0005\u0013(/Y=\u0011\u0005eRT\"A\u000f\n\u0005mj\"A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0011i>\u0004\u0018n\u0019)beRLG/[8og\u0002\n!\b^3ti6\u000b'o[:QCJ$\u0018\u000e^5p]N\f5o\u00144gY&tW-\u00118e!>\u0004X\u000f\\1uKN,fn\u00197fC:\f'\r\\3NKR\u0014\u0018nY:\u0015\u0003}\u0002\"a\r!\n\u0005\u0005#$\u0001B+oSRDC\u0001C\"J\u0015B\u0011AiR\u0007\u0002\u000b*\u0011aII\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u0011\u0016\u0013A\u0001V3ti\u00069A/[7f_V$hD\u0001\u001e\u0019\u0002")
public class LogCleanerIntegrationTest
extends AbstractLogCleanerIntegrationTest {
    private final CompressionType codec = CompressionType.LZ4;
    private final MockTime time = new MockTime();
    private final TopicPartition[] topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});

    @Override
    public CompressionType codec() {
        return this.codec;
    }

    @Override
    public MockTime time() {
        return this.time;
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    @Test(timeout=15000L)
    public void testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics() {
        MemoryRecords largeMessageSet;
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        MemoryRecords memoryRecords = largeMessageSet = (MemoryRecords)tuple2._2();
        MemoryRecords largeMessageSet2 = memoryRecords;
        int maxMessageSize = largeMessageSet2.sizeInBytes();
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        int x$2 = maxMessageSize;
        long x$3 = 100L;
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        long x$6 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        Option<Object> x$9 = this.makeCleaner$default$9();
        Properties x$10 = this.makeCleaner$default$10();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$4, x$5, x$3, x$2, x$6, x$7, x$8, x$9, x$10));
        this.breakPartitionLog$1(this.topicPartitions()[0]);
        this.breakPartitionLog$1(this.topicPartitions()[1]);
        this.cleaner().startup();
        Log log = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Log log2 = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[1]);
        String uncleanableDirectory = log.dir().getParent();
        Gauge uncleanablePartitionsCountGauge = LogCleanerIntegrationTest.getGauge$1("uncleanable-partitions-count", uncleanableDirectory);
        Gauge uncleanableBytesGauge = LogCleanerIntegrationTest.getGauge$1("uncleanable-bytes", uncleanableDirectory);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)uncleanablePartitionsCountGauge.value()) == 2, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "There should be 2 uncleanable partitions", 2000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        long expectedTotalUncleanableBytes = LogCleaner$.MODULE$.calculateCleanableBytes(log, 0L, ((LogSegment)log.logSegments().last()).baseOffset())._2$mcJ$sp() + LogCleaner$.MODULE$.calculateCleanableBytes(log2, 0L, ((LogSegment)log2.logSegments().last()).baseOffset())._2$mcJ$sp();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)uncleanableBytesGauge.value()) == expectedTotalUncleanableBytes, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("There should be ").append(expectedTotalUncleanableBytes).append(" uncleanable bytes").toString(), 1000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Set uncleanablePartitions = this.cleaner().cleanerManager().uncleanablePartitions(uncleanableDirectory);
        Assert.assertTrue((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[0]));
        Assert.assertTrue((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[1]));
        Assert.assertFalse((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[2]));
    }

    private final void breakPartitionLog$1(TopicPartition tp) {
        Log log = (Log)this.cleaner().logs().get((Object)tp);
        this.writeDups(20, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
        File partitionFile = ((LogSegment)log.logSegments().last()).log().file();
        PrintWriter writer = new PrintWriter(partitionFile);
        writer.write("jogeajgoea");
        writer.close();
        this.writeDups(20, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$1(String metricName$1, String metricScope$1, MetricName k) {
        return k.getName().endsWith(metricName$1) && k.getScope().endsWith(metricScope$1);
    }

    private static final Gauge getGauge$1(String metricName, String metricScope) {
        return (Gauge)((Tuple2)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$1(metricName, metricScope, k))).headOption().getOrElse((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Assert.fail((String)new StringBuilder(22).append("Unable to find metric ").append(metricName).toString())))._2();
    }
}

