/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Properties;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005}a\u0001\u0002\u0007\u000e\u0001IAQ!\u0007\u0001\u0005\u0002iAQ!\b\u0001\u0005ByAq!\n\u0001C\u0002\u0013\u0005a\u0005\u0003\u00040\u0001\u0001\u0006Ia\n\u0005\u0006a\u0001!\t%\r\u0005\u0006}\u0001!\t!\r\u0005\u0006\u0007\u0002!I\u0001\u0012\u0005\u0006C\u0002!IA\u0019\u0005\u0006]\u0002!Ia\u001c\u0005\bs\u0002\t\n\u0011\"\u0003{\u0011\u001d\tY\u0001\u0001C\u0005\u0003\u001b\u0011!\u0004R=oC6L7mQ8o]\u0016\u001cG/[8o#V|G/\u0019+fgRT!AD\b\u0002\u000f9,Go^8sW*\t\u0001#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u0018\u001b\u0005)\"B\u0001\f\u0010\u0003\u0019\u0019XM\u001d<fe&\u0011\u0001$\u0006\u0002\u0010\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti\u00061A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011!D\u0001\u000b]Vl'I]8lKJ\u001cX#A\u0010\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\u0007%sG/A\u0003u_BL7-F\u0001(!\tAS&D\u0001*\u0015\tQ3&\u0001\u0003mC:<'\"\u0001\u0017\u0002\t)\fg/Y\u0005\u0003]%\u0012aa\u0015;sS:<\u0017A\u0002;pa&\u001c\u0007%A\u0003tKR,\u0006\u000fF\u00013!\t\u00013'\u0003\u00025C\t!QK\\5uQ\t)a\u0007\u0005\u00028y5\t\u0001H\u0003\u0002:u\u0005)!.\u001e8ji*\t1(A\u0002pe\u001eL!!\u0010\u001d\u0003\r\t+gm\u001c:f\u0003i!Xm\u001d;Es:\fW.[2D_:tWm\u0019;j_:\fVo\u001c;bQ\t1\u0001\t\u0005\u00028\u0003&\u0011!\t\u000f\u0002\u0005)\u0016\u001cH/\u0001\nsK\u000e|gNZ5hkJ,7+\u001a:wKJ\u001cH\u0003\u0002\u001aF\u001bJCQAR\u0004A\u0002\u001d\u000b\u0001B\\3x!J|\u0007o\u001d\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015.\nA!\u001e;jY&\u0011A*\u0013\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\b\"\u0002(\b\u0001\u0004y\u0015a\u00049fe\n\u0013xn[3s\u0007>tg-[4\u0011\u0005\u0001\u0002\u0016BA)\"\u0005\u001d\u0011un\u001c7fC:DQaU\u0004A\u0002Q\u000bQ\"\u0019)s_B$vNV3sS\u001aL\b\u0003\u0002\u0011V/^K!AV\u0011\u0003\rQ+\b\u000f\\33!\tAvL\u0004\u0002Z;B\u0011!,I\u0007\u00027*\u0011A,E\u0001\u0007yI|w\u000e\u001e \n\u0005y\u000b\u0013A\u0002)sK\u0012,g-\u0003\u0002/A*\u0011a,I\u0001\u0012GJ,\u0017\r^3BI6Lgn\u00117jK:$H#A2\u0011\u0005\u0011dW\"A3\u000b\u0005\u0019<\u0017!B1e[&t'B\u00015j\u0003\u001d\u0019G.[3oiNT!\u0001\u00056\u000b\u0005-T\u0014AB1qC\u000eDW-\u0003\u0002nK\nY\u0011\tZ7j]\u000ec\u0017.\u001a8u\u0003U9\u0018-\u001b;G_J\u001cuN\u001c4jO>s7+\u001a:wKJ$BA\r9si\")\u0011/\u0003a\u0001/\u0006A\u0001O]8q\u001d\u0006lW\rC\u0003t\u0013\u0001\u0007q+A\u0005qe>\u0004h+\u00197vK\"9Q/\u0003I\u0001\u0002\u00041\u0018!C7bq^\u000b\u0017\u000e^'t!\t\u0001s/\u0003\u0002yC\t!Aj\u001c8h\u0003}9\u0018-\u001b;G_J\u001cuN\u001c4jO>s7+\u001a:wKJ$C-\u001a4bk2$HeM\u000b\u0002w*\u0012a\u000f`\u0016\u0002{B\u0019a0a\u0002\u000e\u0003}TA!!\u0001\u0002\u0004\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u000b\t\u0013AC1o]>$\u0018\r^5p]&\u0019\u0011\u0011B@\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\ntK:$\u0007K]8ek\u000e,'+Z9vKN$HCAA\b!\u0011\t\t\"a\u0007\u000e\u0005\u0005M!\u0002BA\u000b\u0003/\t\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0004\u00033I\u0017AB2p[6|g.\u0003\u0003\u0002\u001e\u0005M!a\u0004)s_\u0012,8-\u001a*fgB|gn]3")
public class DynamicConnectionQuotaTest
extends BaseRequestTest {
    private final String topic;

    @Override
    public int numBrokers() {
        return 1;
    }

    public String topic() {
        return this.topic;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), this.numBrokers(), this.numBrokers(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
    }

    @Test
    public void testDynamicConnectionQuota() {
        SocketServer socketServer = ((KafkaServer)this.servers().head()).socketServer();
        InetAddress localAddress = InetAddress.getByName("127.0.0.1");
        int initialConnectionCount = DynamicConnectionQuotaTest.connectionCount$1(socketServer, localAddress);
        int maxConnectionsPerIP = 5;
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), ((Object)BoxesRunTime.boxToInteger((int)maxConnectionsPerIP)).toString());
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), (Object)((Object)BoxesRunTime.boxToInteger((int)maxConnectionsPerIP)).toString()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> initialConnectionCount == DynamicConnectionQuotaTest.connectionCount$1(socketServer, localAddress), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Connection count mismatch", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        IndexedSeq conns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(DynamicConnectionQuotaTest.connectionCount$1(socketServer, localAddress)), maxConnectionsPerIP - 1).map((Function1 & Serializable & scala.Serializable)x$1 -> DynamicConnectionQuotaTest.connect$1(socketServer, DynamicConnectionQuotaTest.connect$default$2$1(), DynamicConnectionQuotaTest.connect$default$3$1()), IndexedSeq$.MODULE$.canBuildFrom());
        ProduceResponse produceResponse = this.sendProduceRequest();
        Assert.assertEquals((long)1L, (long)produceResponse.responses().size());
        Tuple2 tuple2 = (Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(produceResponse.responses()).asScala()).head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        ProduceResponse.PartitionResponse partitionResponse = (ProduceResponse.PartitionResponse)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tp, (Object)partitionResponse);
        Tuple2 tuple23 = tuple22;
        TopicPartition tp2 = (TopicPartition)tuple23._1();
        ProduceResponse.PartitionResponse partitionResponse2 = (ProduceResponse.PartitionResponse)tuple23._2();
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionResponse2.error);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> DynamicConnectionQuotaTest.connectionCount$1(socketServer, localAddress) == maxConnectionsPerIP - 1, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "produce request connection is not closed", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        conns = (IndexedSeq)conns.$colon$plus((Object)DynamicConnectionQuotaTest.connect$1(socketServer, DynamicConnectionQuotaTest.connect$default$2$1(), DynamicConnectionQuotaTest.connect$default$3$1()), IndexedSeq$.MODULE$.canBuildFrom());
        this.intercept((Function0 & Serializable & scala.Serializable)() -> this.sendProduceRequest(), ClassTag$.MODULE$.apply(IOException.class), new Position("DynamicConnectionQuotaTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        conns.foreach((Function1 & Serializable & scala.Serializable)conn -> {
            conn.close();
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> initialConnectionCount == DynamicConnectionQuotaTest.connectionCount$1(socketServer, localAddress), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Connection count mismatch", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        int maxConnectionsPerIPOverride = 7;
        props.put(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), new StringBuilder(10).append("localhost:").append(maxConnectionsPerIPOverride).toString());
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), (Object)new StringBuilder(10).append("localhost:").append(maxConnectionsPerIPOverride).toString()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> initialConnectionCount == DynamicConnectionQuotaTest.connectionCount$1(socketServer, localAddress), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Connection count mismatch", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        conns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(DynamicConnectionQuotaTest.connectionCount$1(socketServer, localAddress)), maxConnectionsPerIPOverride - 1).map((Function1 & Serializable & scala.Serializable)x$3 -> DynamicConnectionQuotaTest.connect$1(socketServer, DynamicConnectionQuotaTest.connect$default$2$1(), DynamicConnectionQuotaTest.connect$default$3$1()), IndexedSeq$.MODULE$.canBuildFrom());
        produceResponse = this.sendProduceRequest();
        Assert.assertEquals((long)1L, (long)produceResponse.responses().size());
        Tuple2 tuple24 = (Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(produceResponse.responses()).asScala()).head();
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        TopicPartition tp1 = (TopicPartition)tuple24._1();
        ProduceResponse.PartitionResponse partitionResponse1 = (ProduceResponse.PartitionResponse)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)tp1, (Object)partitionResponse1);
        Tuple2 tuple26 = tuple25;
        TopicPartition tp12 = (TopicPartition)tuple26._1();
        ProduceResponse.PartitionResponse partitionResponse12 = (ProduceResponse.PartitionResponse)tuple26._2();
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionResponse12.error);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> DynamicConnectionQuotaTest.connectionCount$1(socketServer, localAddress) == maxConnectionsPerIPOverride - 1, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "produce request connection is not closed", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        conns = (IndexedSeq)conns.$colon$plus((Object)DynamicConnectionQuotaTest.connect$1(socketServer, DynamicConnectionQuotaTest.connect$default$2$1(), DynamicConnectionQuotaTest.connect$default$3$1()), IndexedSeq$.MODULE$.canBuildFrom());
        this.intercept((Function0 & Serializable & scala.Serializable)() -> this.sendProduceRequest(), ClassTag$.MODULE$.apply(IOException.class), new Position("DynamicConnectionQuotaTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        ((Socket)conns.head()).close();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> DynamicConnectionQuotaTest.connectionCount$1(socketServer, localAddress) == maxConnectionsPerIPOverride - 1, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "connection is not closed", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.sendProduceRequest();
    }

    private void reconfigureServers(Properties newProps, boolean perBrokerConfig, Tuple2<String, String> aPropToVerify) {
        AdminClient adminClient = this.createAdminClient();
        TestUtils$.MODULE$.alterConfigs((Seq<KafkaServer>)this.servers(), adminClient, newProps, perBrokerConfig).all().get();
        this.waitForConfigOnServer((String)aPropToVerify._1(), (String)aPropToVerify._2(), this.waitForConfigOnServer$default$3());
        adminClient.close();
    }

    /*
     * WARNING - void declaration
     */
    private AdminClient createAdminClient() {
        void var3_3;
        String bootstrapServers = TestUtils$.MODULE$.bootstrapServers((Seq<KafkaServer>)this.servers(), new ListenerName(this.securityProtocol().name));
        Properties config = new Properties();
        config.put("bootstrap.servers", bootstrapServers);
        config.put("metadata.max.age.ms", "10");
        AdminClient adminClient = AdminClient.create((Properties)config);
        return var3_3;
    }

    private void waitForConfigOnServer(String propName, String propValue, long maxWaitMs) {
        TestUtils$.MODULE$.retry(maxWaitMs, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Assert.assertEquals((Object)propValue, ((KafkaServer)this.servers().head()).config().originals().get(propName)));
    }

    private long waitForConfigOnServer$default$3() {
        return 10000L;
    }

    private ProduceResponse sendProduceRequest() {
        TopicPartition topicPartition = new TopicPartition(this.topic(), 0);
        MemoryRecords memoryRecords = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())});
        scala.collection.immutable.Map partitionRecords = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)memoryRecords)}));
        ProduceRequest request = (ProduceRequest)ProduceRequest.Builder.forCurrentMagic((short)-1, (int)3000, (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRecords).asJava())).build();
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.PRODUCE, ((KafkaServer)this.servers().head()).socketServer(), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return ProduceResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private static final Socket connect$1(SocketServer socketServer, SecurityProtocol protocol, InetAddress localAddr) {
        return new Socket("localhost", socketServer.boundPort(ListenerName.forSecurityProtocol((SecurityProtocol)protocol)), localAddr, 0);
    }

    private static final SecurityProtocol connect$default$2$1() {
        return SecurityProtocol.PLAINTEXT;
    }

    private static final InetAddress connect$default$3$1() {
        return null;
    }

    private static final int connectionCount$1(SocketServer socketServer$1, InetAddress localAddress$1) {
        return socketServer$1.connectionCount(localAddress$1);
    }

    public DynamicConnectionQuotaTest() {
        this.topic = "test";
    }
}

