/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.auth;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_2_0_IV0$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.network.RequestChannel;
import kafka.security.auth.Acl;
import kafka.security.auth.Acl$;
import kafka.security.auth.All$;
import kafka.security.auth.Allow$;
import kafka.security.auth.Alter$;
import kafka.security.auth.AlterConfigs$;
import kafka.security.auth.Authorizer;
import kafka.security.auth.Cluster$;
import kafka.security.auth.ClusterAction$;
import kafka.security.auth.Create$;
import kafka.security.auth.Delete$;
import kafka.security.auth.Deny$;
import kafka.security.auth.Describe$;
import kafka.security.auth.DescribeConfigs$;
import kafka.security.auth.Group$;
import kafka.security.auth.IdempotentWrite$;
import kafka.security.auth.Operation;
import kafka.security.auth.Operation$;
import kafka.security.auth.PermissionType;
import kafka.security.auth.Read$;
import kafka.security.auth.Resource;
import kafka.security.auth.Resource$;
import kafka.security.auth.ResourceType;
import kafka.security.auth.SimpleAclAuthorizer;
import kafka.security.auth.SimpleAclAuthorizer$;
import kafka.security.auth.Topic$;
import kafka.security.auth.Write$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.ZkAclStore;
import kafka.zk.ZkAclStore$;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zookeeper.AsyncRequest;
import kafka.zookeeper.GetChildrenRequest;
import kafka.zookeeper.GetChildrenRequest$;
import kafka.zookeeper.GetChildrenResponse;
import kafka.zookeeper.GetDataRequest;
import kafka.zookeeper.GetDataRequest$;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.ZooKeeperClient;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rEb\u0001B*U\u0001mCQA\u0019\u0001\u0005\u0002\rDqA\u001a\u0001C\u0002\u0013%q\r\u0003\u0004l\u0001\u0001\u0006I\u0001\u001b\u0005\bY\u0002\u0011\r\u0011\"\u0003h\u0011\u0019i\u0007\u0001)A\u0005Q\"9a\u000e\u0001b\u0001\n\u00139\u0007BB8\u0001A\u0003%\u0001\u000eC\u0004q\u0001\t\u0007I\u0011B9\t\rU\u0004\u0001\u0015!\u0003s\u0011\u001d1\bA1A\u0005\nEDaa\u001e\u0001!\u0002\u0013\u0011\bb\u0002=\u0001\u0005\u0004%I!\u001f\u0005\u0007{\u0002\u0001\u000b\u0011\u0002>\t\u000fy\u0004!\u0019!C\u0005s\"1q\u0010\u0001Q\u0001\niD!\"!\u0001\u0001\u0001\u0004\u0005\r\u0011\"\u0003r\u0011-\t\u0019\u0001\u0001a\u0001\u0002\u0004%I!!\u0002\t\u0015\u0005]\u0001\u00011A\u0001B\u0003&!\u000fC\u0005\u0002\u001a\u0001\u0011\r\u0011\"\u0003\u0002\u001c!A\u0011Q\u0006\u0001!\u0002\u0013\ti\u0002C\u0005\u00020\u0001\u0011\r\u0011\"\u0003\u0002\u001c!A\u0011\u0011\u0007\u0001!\u0002\u0013\ti\u0002C\u0005\u00024\u0001\u0011\r\u0011\"\u0003\u00026!A\u0011\u0011\u000b\u0001!\u0002\u0013\t9\u0004C\u0005\u0002T\u0001\u0011\r\u0011\"\u0003\u0002V!A\u0011q\u000f\u0001!\u0002\u0013\t9\u0006C\u0006\u0002z\u0001\u0001\r\u00111A\u0005\n\u0005m\u0004bCAE\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0017C1\"a$\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002~!Y\u0011\u0011\u0013\u0001A\u0002\u0003\u0007I\u0011BAJ\u0011-\t\t\u000b\u0001a\u0001\u0002\u0004%I!a)\t\u0017\u0005\u001d\u0006\u00011A\u0001B\u0003&\u0011Q\u0013\u0004\u0007\u0003S\u0003\u0001!a+\t\u0015\u00055\u0016E!A!\u0002\u0013\ty\u000b\u0003\u0006\u0002>\u0006\u0012\t\u0011)A\u0005\u0003_CaAY\u0011\u0005\u0002\u0005}\u0006bBAeC\u0011\u0005\u00131\u001a\u0005\b\u0003;\u0004A\u0011IAp\u0011\u001d\ty\u000f\u0001C!\u0003?Dq!!?\u0001\t\u0003\ty\u000eC\u0004\u0003\u001a\u0001!\t!a8\t\u000f\tu\u0001\u0001\"\u0001\u0002`\"9!\u0011\u0005\u0001\u0005\u0002\u0005}\u0007b\u0002B\u0013\u0001\u0011\u0005\u0011q\u001c\u0005\b\u0005S\u0001A\u0011AAp\u0011\u001d\u0011i\u0003\u0001C\u0001\u0003?DqA!\r\u0001\t\u0003\ty\u000eC\u0004\u00036\u0001!\t!a8\t\u000f\te\u0002\u0001\"\u0001\u0002`\"9!Q\b\u0001\u0005\u0002\u0005}\u0007b\u0002B!\u0001\u0011\u0005\u0011q\u001c\u0005\b\u0005\u000b\u0002A\u0011AAp\u0011\u001d\u0011I\u0005\u0001C\u0001\u0003?DqA!\u0014\u0001\t\u0003\ty\u000eC\u0004\u0003R\u0001!\t!a8\t\u000f\tU\u0003\u0001\"\u0001\u0002`\"9!\u0011\f\u0001\u0005\u0002\u0005}\u0007b\u0002B/\u0001\u0011\u0005\u0011q\u001c\u0005\b\u0005C\u0002A\u0011\u0002B2\u0011\u001d\u0011I\b\u0001C\u0005\u0005wBqAa!\u0001\t\u0003\ty\u000eC\u0004\u0003\b\u0002!\t!a8\t\u000f\t-\u0005\u0001\"\u0001\u0002`\"9!q\u0012\u0001\u0005\u0002\u0005}\u0007b\u0002BJ\u0001\u0011\u0005\u0011q\u001c\u0005\b\u0005/\u0003A\u0011AAp\u0011\u001d\u0011Y\n\u0001C\u0001\u0003?DqAa(\u0001\t\u0003\ty\u000eC\u0004\u0003$\u0002!\t!a8\t\u000f\t\u001d\u0006\u0001\"\u0001\u0002`\"9!1\u0016\u0001\u0005\u0002\u0005}\u0007b\u0002BX\u0001\u0011\u0005\u0011q\u001c\u0005\b\u0005g\u0003A\u0011AAp\u0011\u001d\u00119\f\u0001C\u0001\u0003?DqA!3\u0001\t\u0003\ty\u000eC\u0004\u0003N\u0002!\t!a8\t\u000f\tE\u0007\u0001\"\u0001\u0002`\"9!Q\u001b\u0001\u0005\u0002\u0005}\u0007b\u0002Bm\u0001\u0011%!1\u001c\u0005\b\u0005g\u0004A\u0011\u0002B{\u0011\u001d\u0019)\u0001\u0001C\u0005\u0007\u000fA\u0011b!\u0007\u0001#\u0003%Iaa\u0007\u0003/MKW\u000e\u001d7f\u0003\u000ed\u0017)\u001e;i_JL'0\u001a:UKN$(BA+W\u0003\u0011\tW\u000f\u001e5\u000b\u0005]C\u0016\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0003e\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00019B\u0011Q\fY\u0007\u0002=*\u0011q\fW\u0001\u0003u.L!!\u00190\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\tA\r\u0005\u0002f\u00015\tA+\u0001\u0007bY2|wOU3bI\u0006\u001bG.F\u0001i!\t)\u0017.\u0003\u0002k)\n\u0019\u0011i\u00197\u0002\u001b\u0005dGn\\<SK\u0006$\u0017i\u00197!\u00035\tG\u000e\\8x/JLG/Z!dY\u0006q\u0011\r\u001c7po^\u0013\u0018\u000e^3BG2\u0004\u0013a\u00033f]f\u0014V-\u00193BG2\fA\u0002Z3osJ+\u0017\rZ!dY\u0002\n\u0001c^5mI\u000e\u000b'\u000f\u001a*fg>,(oY3\u0016\u0003I\u0004\"!Z:\n\u0005Q$&\u0001\u0003*fg>,(oY3\u0002#]LG\u000eZ\"be\u0012\u0014Vm]8ve\u000e,\u0007%\u0001\tqe\u00164\u0017\u000e_3e%\u0016\u001cx.\u001e:dK\u0006\t\u0002O]3gSb,GMU3t_V\u00148-\u001a\u0011\u0002'MLW\u000e\u001d7f\u0003\u000ed\u0017)\u001e;i_JL'0\u001a:\u0016\u0003i\u0004\"!Z>\n\u0005q$&aE*j[BdW-Q2m\u0003V$\bn\u001c:ju\u0016\u0014\u0018\u0001F:j[BdW-Q2m\u0003V$\bn\u001c:ju\u0016\u0014\b%\u0001\u000btS6\u0004H.Z!dY\u0006+H\u000f[8sSj,'OM\u0001\u0016g&l\u0007\u000f\\3BG2\fU\u000f\u001e5pe&TXM\u001d\u001a!\u0003!\u0011Xm]8ve\u000e,\u0017\u0001\u0004:fg>,(oY3`I\u0015\fH\u0003BA\u0004\u0003'\u0001B!!\u0003\u0002\u00105\u0011\u00111\u0002\u0006\u0003\u0003\u001b\tQa]2bY\u0006LA!!\u0005\u0002\f\t!QK\\5u\u0011!\t)\"EA\u0001\u0002\u0004\u0011\u0018a\u0001=%c\u0005I!/Z:pkJ\u001cW\rI\u0001\u000bgV\u0004XM]+tKJ\u001cXCAA\u000f!\u0011\ty\"!\u000b\u000e\u0005\u0005\u0005\"\u0002BA\u0012\u0003K\tA\u0001\\1oO*\u0011\u0011qE\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002,\u0005\u0005\"AB*ue&tw-A\u0006tkB,'/V:feN\u0004\u0013\u0001C;tKJt\u0017-\\3\u0002\u0013U\u001cXM\u001d8b[\u0016\u0004\u0013!\u00039sS:\u001c\u0017\u000e]1m+\t\t9\u0004\u0005\u0003\u0002:\u00055SBAA\u001e\u0015\r)\u0016Q\b\u0006\u0004/\u0006}\"\u0002BA!\u0003\u0007\naaY8n[>t'bA-\u0002F)!\u0011qIA%\u0003\u0019\t\u0007/Y2iK*\u0011\u00111J\u0001\u0004_J<\u0017\u0002BA(\u0003w\u0011abS1gW\u0006\u0004&/\u001b8dSB\fG.\u0001\u0006qe&t7-\u001b9bY\u0002\nqa]3tg&|g.\u0006\u0002\u0002XA!\u0011\u0011LA9\u001d\u0011\tY&a\u001b\u000f\t\u0005u\u0013q\r\b\u0005\u0003?\n)'\u0004\u0002\u0002b)\u0019\u00111\r.\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0016bAA51\u00069a.\u001a;x_J\\\u0017\u0002BA7\u0003_\naBU3rk\u0016\u001cHo\u00115b]:,GNC\u0002\u0002jaKA!a\u001d\u0002v\t91+Z:tS>t'\u0002BA7\u0003_\n\u0001b]3tg&|g\u000eI\u0001\u0007G>tg-[4\u0016\u0005\u0005u\u0004\u0003BA@\u0003\u000bk!!!!\u000b\u0007\u0005\r\u0005,\u0001\u0004tKJ4XM]\u0005\u0005\u0003\u000f\u000b\tIA\u0006LC\u001a\\\u0017mQ8oM&<\u0017AC2p]\u001aLwm\u0018\u0013fcR!\u0011qAAG\u0011%\t)\u0002HA\u0001\u0002\u0004\ti(A\u0004d_:4\u0017n\u001a\u0011\u0002\u001fi|wnS3fa\u0016\u00148\t\\5f]R,\"!!&\u0011\t\u0005]\u0015QT\u0007\u0003\u00033S1!a'Y\u0003%Qxn\\6fKB,'/\u0003\u0003\u0002 \u0006e%a\u0004.p_.+W\r]3s\u00072LWM\u001c;\u0002'i|wnS3fa\u0016\u00148\t\\5f]R|F%Z9\u0015\t\u0005\u001d\u0011Q\u0015\u0005\n\u0003+y\u0012\u0011!a\u0001\u0003+\u000b\u0001C_8p\u0017\u0016,\u0007/\u001a:DY&,g\u000e\u001e\u0011\u0003\u001f\r+8\u000f^8n!JLgnY5qC2\u001c2!IA\u001c\u00035\u0001(/\u001b8dSB\fG\u000eV=qKB!\u0011\u0011WA]\u001d\u0011\t\u0019,!.\u0011\t\u0005}\u00131B\u0005\u0005\u0003o\u000bY!\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003W\tYL\u0003\u0003\u00028\u0006-\u0011\u0001\u00028b[\u0016$b!!1\u0002F\u0006\u001d\u0007cAAbC5\t\u0001\u0001C\u0004\u0002.\u0012\u0002\r!a,\t\u000f\u0005uF\u00051\u0001\u00020\u00061Q-];bYN$B!!4\u0002TB!\u0011\u0011BAh\u0013\u0011\t\t.a\u0003\u0003\u000f\t{w\u000e\\3b]\"9\u0011Q[\u0013A\u0002\u0005]\u0017!A8\u0011\t\u0005%\u0011\u0011\\\u0005\u0005\u00037\fYAA\u0002B]f\fQa]3u+B$\"!a\u0002)\u0007\u0019\n\u0019\u000f\u0005\u0003\u0002f\u0006-XBAAt\u0015\u0011\tI/!\u0013\u0002\u000b),h.\u001b;\n\t\u00055\u0018q\u001d\u0002\u0007\u0005\u00164wN]3\u0002\u0011Q,\u0017M\u001d#po:D3aJAz!\u0011\t)/!>\n\t\u0005]\u0018q\u001d\u0002\u0006\u0003\u001a$XM]\u0001)i\u0016\u001cH/Q;uQ>\u0014\u0018N_3UQJ|wo](o\u001d>tW\rT5uKJ\fGNU3t_V\u00148-\u001a\u0015\bQ\u0005u(1\u0001B\u0003!\u0011\t)/a@\n\t\t\u0005\u0011q\u001d\u0002\u0005)\u0016\u001cH/\u0001\u0005fqB,7\r^3eG\t\u00119\u0001\u0005\u0003\u0003\n\tMa\u0002\u0002B\u0006\u0005\u001fqA!a\u0018\u0003\u000e%\u0011\u0011QB\u0005\u0005\u0005#\tY!A\u0004qC\u000e\\\u0017mZ3\n\t\tU!q\u0003\u0002\u0019\u00132dWmZ1m\u0003J<W/\\3oi\u0016C8-\u001a9uS>t'\u0002\u0002B\t\u0003\u0017\t!\u0005^3ti\u0006+H\u000f[8sSj,w+\u001b;i\u000b6\u0004H/\u001f*fg>,(oY3OC6,\u0007fA\u0015\u0002~\u0006YB/Z:u\u000b6\u0004H/_!dYRC'o\\<t\u000bb\u001cW\r\u001d;j_:DsAKA\u007f\u0005\u0007\u0011)!\u0001\u0007uKN$Hk\u001c9jG\u0006\u001bG\u000eK\u0002,\u0003{\f!\u0005^3ti\u0006cGn\\<BG\u000e,7o],ji\"\u001cUo\u001d;p[B\u0013\u0018N\\2ja\u0006d\u0007f\u0001\u0017\u0002~\u00069B/Z:u\t\u0016t\u0017\u0010V1lKN\u0004&/Z2fI\u0016t7-\u001a\u0015\u0004[\u0005u\u0018A\u0005;fgR\fE\u000e\\8x\u00032d\u0017iY2fgND3ALA\u007f\u0003Y!Xm\u001d;TkB,'/V:fe\"\u000b7/Q2dKN\u001c\bfA\u0018\u0002~\u0006IC/Z:u'V\u0004XM]+tKJ<\u0016\u000e\u001e5DkN$x.\u001c)sS:\u001c\u0017\u000e]1m\u0011\u0006\u001c\u0018iY2fgND3\u0001MA\u007f\u0003A!Xm\u001d;XS2$7)\u0019:e\u0003\u000ed7\u000fK\u00022\u0003{\fa\u0002^3ti:{\u0017i\u00197G_VtG\rK\u00023\u0003{\fa\u0003^3ti:{\u0017i\u00197G_VtGm\u0014<feJLG-\u001a\u0015\u0004g\u0005u\u0018!\u0006;fgR\f5\r\\'b]\u0006<W-\\3oi\u0006\u0003\u0016j\u001d\u0015\u0004i\u0005u\u0018!\u0004;fgRdu.\u00193DC\u000eDW\rK\u00026\u0003{\f\u0001\u0004^3ti\u000eC\u0017M\\4f\u0019&\u001cH/\u001a8feRKW.\u001b8hQ\r1\u0014Q`\u0001.i\u0016\u001cH\u000fT8dC2\u001cuN\\2veJ,g\u000e^'pI&4\u0017nY1uS>twJ\u001a*fg>,(oY3BG2\u001c\bfA\u001c\u0002~\u0006\u0019D/Z:u\t&\u001cHO]5ckR,GmQ8oGV\u0014(/\u001a8u\u001b>$\u0017NZ5dCRLwN\\(g%\u0016\u001cx.\u001e:dK\u0006\u001bGn\u001d\u0015\u0004q\u0005u\u0018!\f;fgRD\u0015n\u001a5D_:\u001cWO\u001d:f]\u000eLXj\u001c3jM&\u001c\u0017\r^5p]>3'+Z:pkJ\u001cW-Q2mg\"\u001a\u0011(!@\u0002%Q,7\u000f^!dY&s\u0007.\u001a:ji\u0006t7-\u001a\u0015\u0004u\u0005u\u0018a\u0006;fgRLU\u000e\u001d7jG\u0006$\u0018n\u001c8t\u001f\u001a\fE\u000e\\8x)\u0019\t9A!\u001a\u0003p!9!qM\u001eA\u0002\t%\u0014\u0001\u00039be\u0016tGo\u00149\u0011\u0007\u0015\u0014Y'C\u0002\u0003nQ\u0013\u0011b\u00149fe\u0006$\u0018n\u001c8\t\u000f\tE4\b1\u0001\u0003t\u0005Q\u0011\r\u001c7po\u0016$w\n]:\u0011\r\u0005E&Q\u000fB5\u0013\u0011\u00119(a/\u0003\u0007M+G/\u0001\fuKN$\u0018*\u001c9mS\u000e\fG/[8og>3G)\u001a8z)\u0019\t9A! \u0003\u0000!9!q\r\u001fA\u0002\t%\u0004b\u0002BAy\u0001\u0007!1O\u0001\nI\u0016t\u0017.\u001a3PaN\f\u0011\u0006^3ti\"Kw\r[\"p]\u000e,(O]3oGf$U\r\\3uS>twJ\u001a*fg>,(oY3BG2\u001c\bfA\u001f\u0002~\u0006\u0019D/Z:u\u0003\u000e\u001cWm]:BY2|w/\u001a3JM\u0006cGn\\<BG2,\u00050[:ug>sw+\u001b7eG\u0006\u0014HMU3t_V\u00148-\u001a\u0015\u0004}\u0005u\u0018a\b;fgR$U\r\\3uK\u0006\u001bGn\u00148XS2$7-\u0019:e%\u0016\u001cx.\u001e:dK\"\u001aq(!@\u0002EQ,7\u000f\u001e#fY\u0016$X-\u00117m\u0003\u000edwJ\\,jY\u0012\u001c\u0017M\u001d3SKN|WO]2fQ\r\u0001\u0015Q`\u00014i\u0016\u001cH/Q2dKN\u001c\u0018\t\u001c7po\u0016$\u0017JZ!mY><\u0018i\u00197Fq&\u001cHo](o!J,g-\u001b=fIJ+7o\\;sG\u0016D3!QA\u007f\u0003}!Xm\u001d;EK2,G/Z!dY>s\u0007K]3gSb,GMU3t_V\u00148-\u001a\u0015\u0004\u0005\u0006u\u0018A\t;fgR$U\r\\3uK\u0006cG.Q2m\u001f:\u0004&/\u001a4jq\u0016$'+Z:pkJ\u001cW\rK\u0002D\u0003{\fA\u0004^3ti\u0006#G-Q2mg>sG*\u001b;fe\u0006d'+Z:pkJ\u001cW\rK\u0002E\u0003{\fQ\u0004^3ti\u0006#G-Q2mg>sw+\u001b7eG\u0006\u0014HMU3t_V\u00148-\u001a\u0015\u0004\u000b\u0006u\u0018A\b;fgR\fE\rZ!dYN|e\u000e\u0015:fM&,\u00070\u001a3SKN|WO]2fQ\r1\u0015Q`\u0001\"i\u0016\u001cH/Q;uQ>\u0014\u0018N_3XSRD\u0007K]3gSb,GMU3t_V\u00148-\u001a\u0015\u0004\u000f\u0006u\u0018a\b;fgR\u001c\u0016N\\4mK\u000eC\u0017M]1di\u0016\u0014(+Z:pkJ\u001cW-Q2mg\"\u001a\u0001*!@\u0002)Q,7\u000f^$fi\u0006\u001bGn\u001d)sS:\u001c\u0017\u000e]1mQ\rI\u0015Q`\u0001=i\u0016\u001cH\u000f\u00165s_^\u001cxJ\\!eIB\u0013XMZ5yK\u0012\f5\r\\%g\u0013:$XM\u001d\"s_.,'\u000f\u0015:pi>\u001cw\u000e\u001c,feNLwN\u001c+p_2{w\u000fK\u0004K\u0003{\u0014\u0019Aa/$\u0005\tu\u0006\u0003\u0002B`\u0005\u000bl!A!1\u000b\t\t\r\u0017qH\u0001\u0007KJ\u0014xN]:\n\t\t\u001d'\u0011\u0019\u0002\u001c+:\u001cX\u000f\u001d9peR,GMV3sg&|g.\u0012=dKB$\u0018n\u001c8\u0002wQ,7\u000f^,sSR,7/\u0012=uK:$W\rZ!dY\u000eC\u0017M\\4f\u000bZ,g\u000e^%g\u0013:$XM\u001d\"s_.,'\u000f\u0015:pi>\u001cw\u000e\u001c(piN+G\u000fK\u0002L\u0003{\fQ\t^3ti^\u0013\u0018\u000e^3t\u000bb$XM\u001c3fI\u0006\u001bGn\u00115b]\u001e,WI^3oi^CWM\\%oi\u0016\u0014(I]8lKJ\u0004&o\u001c;pG>d\u0017\t\u001e'fCN$8*\u00194lCZ\u0013\u0004f\u0001'\u0002~\u0006AH/Z:u/JLG/Z:MSR,'/\u00197Xe&$Xm\u001d'ji\u0016\u0014\u0018\r\\!dY\u000eC\u0017M\\4f\u000bZ,g\u000e^,iK:Le\u000e^3s\u0005J|7.\u001a:Qe>$xnY8m\u0019\u0016\u001c8\u000f\u00165b].\u000bgm[1We\u0015\u0014\u0018\r\\!dY\u000eC\u0017M\\4fg\u001a{'o\u00147eKJ\u0004&o\u001c;pG>dg+\u001a:tS>t7\u000fK\u0002N\u0003{\fq\b^3ti^\u0013\u0018\u000e^3t\u0019&$XM]1m\u0003\u000ed7\t[1oO\u0016,e/\u001a8u/\",g.\u00138uKJ\u0014%o\\6feB\u0013x\u000e^8d_2L5oS1gW\u00064&\u0007K\u0002O\u0003{\f!eZ5wK:\fU\u000f\u001e5pe&TXM],ji\"\u0004&o\u001c;pG>dg+\u001a:tS>tG\u0003BA\u0004\u0005;DqAa8P\u0001\u0004\u0011\t/A\bqe>$xnY8m-\u0016\u00148/[8o!\u0019\tIAa9\u0003h&!!Q]A\u0006\u0005\u0019y\u0005\u000f^5p]B!!\u0011\u001eBx\u001b\t\u0011YOC\u0002\u0003nb\u000b1!\u00199j\u0013\u0011\u0011\tPa;\u0003\u0015\u0005\u0003\u0018NV3sg&|g.A\rhKR\f5\r\\\"iC:<W-\u0012<f]R\f5o\u0015;sS:<G\u0003BA\u000f\u0005oDqA!?Q\u0001\u0004\u0011Y0A\u0006qCR$XM\u001d8UsB,\u0007\u0003\u0002B\u007f\u0007\u0003i!Aa@\u000b\t\u0005\u0005\u0011qH\u0005\u0005\u0007\u0007\u0011yPA\u0006QCR$XM\u001d8UsB,\u0017AE2iC:<W-Q2m\u0003:$g+\u001a:jMf$\"b!\u0003\u0004\f\r=11CB\f!\u0015\t\tL!\u001ei\u0011\u001d\u0019i!\u0015a\u0001\u0007\u0013\tAb\u001c:jO&t\u0017\r\\!dYNDqa!\u0005R\u0001\u0004\u0019I!A\u0005bI\u0012,G-Q2mg\"91QC)A\u0002\r%\u0011a\u0003:f[>4X\rZ!dYND\u0001\"!\u0001R!\u0003\u0005\rA]\u0001\u001dG\"\fgnZ3BG2\fe\u000e\u001a,fe&4\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019iBK\u0002s\u0007?Y#a!\t\u0011\t\r\r2QF\u0007\u0003\u0007KQAaa\n\u0004*\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0005\u0007W\tY!\u0001\u0006b]:|G/\u0019;j_:LAaa\f\u0004&\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class SimpleAclAuthorizerTest
extends ZooKeeperTestHarness {
    private final Acl allowReadAcl = new Acl(Acl$.MODULE$.WildCardPrincipal(), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
    private final Acl allowWriteAcl = new Acl(Acl$.MODULE$.WildCardPrincipal(), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Write$.MODULE$);
    private final Acl denyReadAcl = new Acl(Acl$.MODULE$.WildCardPrincipal(), (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
    private final Resource wildCardResource = new Resource((ResourceType)Topic$.MODULE$, Acl$.MODULE$.WildCardResource(), PatternType.LITERAL);
    private final Resource prefixedResource = new Resource((ResourceType)Topic$.MODULE$, "foo", PatternType.PREFIXED);
    private final SimpleAclAuthorizer simpleAclAuthorizer = new SimpleAclAuthorizer();
    private final SimpleAclAuthorizer simpleAclAuthorizer2 = new SimpleAclAuthorizer();
    private Resource resource;
    private final String superUsers;
    private final String username;
    private final KafkaPrincipal principal = new KafkaPrincipal("User", this.username());
    private final RequestChannel.Session session = new RequestChannel.Session(this.principal(), InetAddress.getByName("192.168.0.1"));
    private KafkaConfig config;
    private ZooKeeperClient zooKeeperClient;

    private Acl allowReadAcl() {
        return this.allowReadAcl;
    }

    private Acl allowWriteAcl() {
        return this.allowWriteAcl;
    }

    private Acl denyReadAcl() {
        return this.denyReadAcl;
    }

    private Resource wildCardResource() {
        return this.wildCardResource;
    }

    private Resource prefixedResource() {
        return this.prefixedResource;
    }

    private SimpleAclAuthorizer simpleAclAuthorizer() {
        return this.simpleAclAuthorizer;
    }

    private SimpleAclAuthorizer simpleAclAuthorizer2() {
        return this.simpleAclAuthorizer2;
    }

    private Resource resource() {
        return this.resource;
    }

    private void resource_$eq(Resource x$1) {
        this.resource = x$1;
    }

    private String superUsers() {
        return this.superUsers;
    }

    private String username() {
        return this.username;
    }

    private KafkaPrincipal principal() {
        return this.principal;
    }

    private RequestChannel.Session session() {
        return this.session;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    private ZooKeeperClient zooKeeperClient() {
        return this.zooKeeperClient;
    }

    private void zooKeeperClient_$eq(ZooKeeperClient x$1) {
        this.zooKeeperClient = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.simpleAclAuthorizer().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        this.simpleAclAuthorizer2().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        props.put(SimpleAclAuthorizer$.MODULE$.SuperUsersProp(), this.superUsers());
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.simpleAclAuthorizer().configure(this.config().originals());
        this.simpleAclAuthorizer2().configure(this.config().originals());
        this.resource_$eq(new Resource((ResourceType)Topic$.MODULE$, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.LITERAL));
        this.zooKeeperClient_$eq(new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, "kafka.test", "SimpleAclAuthorizerTest"));
    }

    @Override
    @After
    public void tearDown() {
        this.simpleAclAuthorizer().close();
        this.simpleAclAuthorizer2().close();
        this.zooKeeperClient().close();
        super.tearDown();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAuthorizeThrowsOnNoneLiteralResource() {
        this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, new Resource((ResourceType)Topic$.MODULE$, "something", PatternType.PREFIXED));
    }

    @Test
    public void testAuthorizeWithEmptyResourceName() {
        Assert.assertFalse((boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, new Resource((ResourceType)Group$.MODULE$, "", PatternType.LITERAL)));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), new Resource((ResourceType)Group$.MODULE$, Acl$.MODULE$.WildCardResource(), PatternType.LITERAL));
        Assert.assertTrue((boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, new Resource((ResourceType)Group$.MODULE$, "", PatternType.LITERAL)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyAclThrowsException() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), new Resource((ResourceType)Group$.MODULE$, "", PatternType.LITERAL));
    }

    @Test
    public void testTopicAcl() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "rob");
        KafkaPrincipal user3 = new KafkaPrincipal("User", "batman");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        Acl acl1 = new Acl(user1, (PermissionType)Allow$.MODULE$, host1.getHostAddress(), (Operation)Read$.MODULE$);
        Acl acl2 = new Acl(user1, (PermissionType)Allow$.MODULE$, host2.getHostAddress(), (Operation)Read$.MODULE$);
        Acl acl3 = new Acl(user1, (PermissionType)Deny$.MODULE$, host1.getHostAddress(), (Operation)Read$.MODULE$);
        Acl acl4 = new Acl(user1, (PermissionType)Allow$.MODULE$, host1.getHostAddress(), (Operation)Write$.MODULE$);
        Acl acl5 = new Acl(user1, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Describe$.MODULE$);
        Acl acl6 = new Acl(user2, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        Acl acl7 = new Acl(user3, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Write$.MODULE$);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2, acl3, acl4, acl5, acl6, acl7}));
        this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)acls, (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestChannel.Session host1Session = new RequestChannel.Session(user1, host1);
        RequestChannel.Session host2Session = new RequestChannel.Session(user1, host2);
        Assert.assertTrue((String)"User1 should have READ access from host2", (boolean)this.simpleAclAuthorizer().authorize(host2Session, (Operation)Read$.MODULE$, this.resource()));
        Assert.assertFalse((String)"User1 should not have READ access from host1 due to denyAcl", (boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Read$.MODULE$, this.resource()));
        Assert.assertTrue((String)"User1 should have WRITE access from host1", (boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Write$.MODULE$, this.resource()));
        Assert.assertFalse((String)"User1 should not have WRITE access from host2 as no allow acl is defined", (boolean)this.simpleAclAuthorizer().authorize(host2Session, (Operation)Write$.MODULE$, this.resource()));
        Assert.assertTrue((String)"User1 should not have DESCRIBE access from host1", (boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Describe$.MODULE$, this.resource()));
        Assert.assertTrue((String)"User1 should have DESCRIBE access from host2", (boolean)this.simpleAclAuthorizer().authorize(host2Session, (Operation)Describe$.MODULE$, this.resource()));
        Assert.assertFalse((String)"User1 should not have edit access from host1", (boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Alter$.MODULE$, this.resource()));
        Assert.assertFalse((String)"User1 should not have edit access from host2", (boolean)this.simpleAclAuthorizer().authorize(host2Session, (Operation)Alter$.MODULE$, this.resource()));
        RequestChannel.Session user2Session = new RequestChannel.Session(user2, host1);
        RequestChannel.Session user3Session = new RequestChannel.Session(user3, host1);
        Assert.assertTrue((String)"User2 should have DESCRIBE access from host1", (boolean)this.simpleAclAuthorizer().authorize(user2Session, (Operation)Describe$.MODULE$, this.resource()));
        Assert.assertTrue((String)"User3 should have DESCRIBE access from host2", (boolean)this.simpleAclAuthorizer().authorize(user3Session, (Operation)Describe$.MODULE$, this.resource()));
        Assert.assertTrue((String)"User2 should have READ access from host1", (boolean)this.simpleAclAuthorizer().authorize(user2Session, (Operation)Read$.MODULE$, this.resource()));
        Assert.assertTrue((String)"User3 should have WRITE access from host2", (boolean)this.simpleAclAuthorizer().authorize(user3Session, (Operation)Write$.MODULE$, this.resource()));
    }

    @Test
    public void testAllowAccessWithCustomPrincipal() {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        CustomPrincipal customUserPrincipal = new CustomPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        Acl acl1 = new Acl(user, (PermissionType)Deny$.MODULE$, host1.getHostAddress(), (Operation)Read$.MODULE$);
        Acl acl2 = new Acl(user, (PermissionType)Allow$.MODULE$, host2.getHostAddress(), (Operation)Read$.MODULE$);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}));
        this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)acls, (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestChannel.Session host1Session = new RequestChannel.Session((KafkaPrincipal)customUserPrincipal, host1);
        RequestChannel.Session host2Session = new RequestChannel.Session((KafkaPrincipal)customUserPrincipal, host2);
        Assert.assertTrue((String)"User1 should have READ access from host2", (boolean)this.simpleAclAuthorizer().authorize(host2Session, (Operation)Read$.MODULE$, this.resource()));
        Assert.assertFalse((String)"User1 should not have READ access from host1 due to denyAcl", (boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testDenyTakesPrecedence() {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.2.1");
        RequestChannel.Session session = new RequestChannel.Session(user, host);
        Acl allowAll = Acl$.MODULE$.AllowAllAcl();
        Acl denyAcl = new Acl(user, (PermissionType)Deny$.MODULE$, host.getHostAddress(), (Operation)All$.MODULE$);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{allowAll, denyAcl}));
        this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)acls, (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        Assert.assertFalse((String)"deny should take precedence over allow.", (boolean)this.simpleAclAuthorizer().authorize(session, (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testAllowAllAccess() {
        Acl allowAllAcl = Acl$.MODULE$.AllowAllAcl();
        this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{allowAllAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestChannel.Session session = new RequestChannel.Session(new KafkaPrincipal("User", "random"), InetAddress.getByName("192.0.4.4"));
        Assert.assertTrue((String)"allow all acl should allow access to all.", (boolean)this.simpleAclAuthorizer().authorize(session, (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testSuperUserHasAccess() {
        Acl denyAllAcl = new Acl(Acl$.MODULE$.WildCardPrincipal(), (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)All$.MODULE$);
        this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{denyAllAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestChannel.Session session1 = new RequestChannel.Session(new KafkaPrincipal("User", "superuser1"), InetAddress.getByName("192.0.4.4"));
        RequestChannel.Session session2 = new RequestChannel.Session(new KafkaPrincipal("User", "superuser2"), InetAddress.getByName("192.0.4.4"));
        Assert.assertTrue((String)"superuser always has access, no matter what acls.", (boolean)this.simpleAclAuthorizer().authorize(session1, (Operation)Read$.MODULE$, this.resource()));
        Assert.assertTrue((String)"superuser always has access, no matter what acls.", (boolean)this.simpleAclAuthorizer().authorize(session2, (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testSuperUserWithCustomPrincipalHasAccess() {
        Acl denyAllAcl = new Acl(Acl$.MODULE$.WildCardPrincipal(), (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)All$.MODULE$);
        this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{denyAllAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestChannel.Session session = new RequestChannel.Session((KafkaPrincipal)new CustomPrincipal("User", "superuser1"), InetAddress.getByName("192.0.4.4"));
        Assert.assertTrue((String)"superuser with custom principal always has access, no matter what acls.", (boolean)this.simpleAclAuthorizer().authorize(session, (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testWildCardAcls() {
        Assert.assertFalse((String)"when acls = [],  authorizer should fail close.", (boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, this.resource()));
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        Acl readAcl = new Acl(user1, (PermissionType)Allow$.MODULE$, host1.getHostAddress(), (Operation)Read$.MODULE$);
        Set<Acl> acls = this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{readAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        RequestChannel.Session host1Session = new RequestChannel.Session(user1, host1);
        Assert.assertTrue((String)"User1 should have Read access from host1", (boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Read$.MODULE$, this.resource()));
        Acl writeAcl = new Acl(user1, (PermissionType)Allow$.MODULE$, host1.getHostAddress(), (Operation)Write$.MODULE$);
        this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{writeAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        Acl denyWriteOnWildCardResourceAcl = new Acl(user1, (PermissionType)Deny$.MODULE$, host1.getHostAddress(), (Operation)Write$.MODULE$);
        this.changeAclAndVerify(acls, (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{denyWriteOnWildCardResourceAcl}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        Assert.assertFalse((String)"User1 should not have Write access from host1", (boolean)this.simpleAclAuthorizer().authorize(host1Session, (Operation)Write$.MODULE$, this.resource()));
    }

    @Test
    public void testNoAclFound() {
        Assert.assertFalse((String)"when acls = [],  authorizer should fail close.", (boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testNoAclFoundOverride() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        props.put(SimpleAclAuthorizer$.MODULE$.AllowEveryoneIfNoAclIsFoundProp(), "true");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        try (SimpleAclAuthorizer testAuthorizer = new SimpleAclAuthorizer();){
            testAuthorizer.configure(cfg.originals());
            Assert.assertTrue((String)"when acls = null or [],  authorizer should fail open with allow.everyone = true.", (boolean)testAuthorizer.authorize(this.session(), (Operation)Read$.MODULE$, this.resource()));
        }
    }

    @Test
    public void testAclManagementAPIs() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        String host1 = "host1";
        String host2 = "host2";
        Acl acl1 = new Acl(user1, (PermissionType)Allow$.MODULE$, host1, (Operation)Read$.MODULE$);
        Acl acl2 = new Acl(user1, (PermissionType)Allow$.MODULE$, host1, (Operation)Write$.MODULE$);
        Acl acl3 = new Acl(user2, (PermissionType)Allow$.MODULE$, host2, (Operation)Read$.MODULE$);
        Acl acl4 = new Acl(user2, (PermissionType)Allow$.MODULE$, host2, (Operation)Write$.MODULE$);
        ObjectRef acls = ObjectRef.create(this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2, acl3, acl4}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4()));
        Acl acl5 = new Acl(user2, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        acls.elem = this.changeAclAndVerify((Set<Acl>)((Set)acls.elem), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl5}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            GenMap genMap = Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.resource()), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2})))}));
            Map map = this.simpleAclAuthorizer().getAcls(user1);
            return !(genMap != null ? !genMap.equals(map) : map != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "changes not propagated in timeout period", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            GenMap genMap = Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.resource()), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl3, acl4, acl5})))}));
            Map map = this.simpleAclAuthorizer().getAcls(user2);
            return !(genMap != null ? !genMap.equals(map) : map != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "changes not propagated in timeout period", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Map resourceToAcls = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Resource((ResourceType)Topic$.MODULE$, Resource$.MODULE$.WildCardResource(), PatternType.LITERAL)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(user2, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Resource((ResourceType)Cluster$.MODULE$, Resource$.MODULE$.WildCardResource(), PatternType.LITERAL)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(user2, (PermissionType)Allow$.MODULE$, host1, (Operation)Read$.MODULE$)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Resource((ResourceType)Group$.MODULE$, Resource$.MODULE$.WildCardResource(), PatternType.LITERAL)), (Object)((Set)acls.elem)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Resource((ResourceType)Group$.MODULE$, "test-ConsumerGroup", PatternType.LITERAL)), (Object)((Set)acls.elem))}));
        resourceToAcls.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Resource key = (Resource)tuple2._1();
            Set value = (Set)tuple2._2();
            Set<Acl> set = this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)value, (Set<Acl>)Predef$.MODULE$.Set().empty(), key);
            return set;
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map map = resourceToAcls.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.resource()), (Object)((Set)acls$1.elem)));
            Map map2 = this.simpleAclAuthorizer().getAcls();
            return !(map != null ? !map.equals(map2) : map2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "changes not propagated in timeout period.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        acls.elem = this.changeAclAndVerify((Set<Acl>)((Set)acls.elem), (Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl5}))), this.changeAclAndVerify$default$4());
        this.simpleAclAuthorizer().removeAcls(this.resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)Predef$.MODULE$.Set().empty(), (Authorizer)this.simpleAclAuthorizer(), this.resource());
        Assert.assertTrue((!this.zkClient().resourceExists(this.resource()) ? 1 : 0) != 0);
        acls.elem = this.changeAclAndVerify((Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1}))), (Set<Acl>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        this.changeAclAndVerify((Set<Acl>)((Set)acls.elem), (Set<Acl>)Predef$.MODULE$.Set().empty(), (Set<Acl>)((Set)acls.elem), this.changeAclAndVerify$default$4());
        Assert.assertTrue((!this.zkClient().resourceExists(this.resource()) ? 1 : 0) != 0);
    }

    @Test
    public void testLoadCache() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        Acl acl1 = new Acl(user1, (PermissionType)Allow$.MODULE$, "host-1", (Operation)Read$.MODULE$);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1}));
        this.simpleAclAuthorizer().addAcls(acls, this.resource());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        Resource resource1 = new Resource((ResourceType)Topic$.MODULE$, "test-2", PatternType.LITERAL);
        Acl acl2 = new Acl(user2, (PermissionType)Deny$.MODULE$, "host3", (Operation)Read$.MODULE$);
        Set acls1 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl2}));
        this.simpleAclAuthorizer().addAcls(acls1, resource1);
        this.zkClient().deleteAclChangeNotifications();
        try (SimpleAclAuthorizer authorizer = new SimpleAclAuthorizer();){
            authorizer.configure(this.config().originals());
            Assert.assertEquals((Object)acls, (Object)authorizer.getAcls(this.resource()));
            Assert.assertEquals((Object)acls1, (Object)authorizer.getAcls(resource1));
        }
    }

    @Test
    public void testChangeListenerTiming() {
        Semaphore configureSemaphore = new Semaphore(0);
        Semaphore listenerSemaphore = new Semaphore(0);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        SimpleAclAuthorizer simpleAclAuthorizer3 = new SimpleAclAuthorizer(null, configureSemaphore, listenerSemaphore){
            private final Semaphore configureSemaphore$1;
            private final Semaphore listenerSemaphore$1;

            public void startZkChangeListeners() {
                this.configureSemaphore$1.release();
                this.listenerSemaphore$1.acquireUninterruptibly();
                super.startZkChangeListeners();
            }
            {
                this.configureSemaphore$1 = configureSemaphore$1;
                this.listenerSemaphore$1 = listenerSemaphore$1;
            }
        };
        try {
            Future<?> future = executor.submit(CoreUtils$.MODULE$.runnable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> simpleAclAuthorizer3.configure(this.config().originals())));
            configureSemaphore.acquire();
            KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
            Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(user1, (PermissionType)Deny$.MODULE$, "host-1", (Operation)Read$.MODULE$)}));
            this.simpleAclAuthorizer().addAcls(acls, this.resource());
            listenerSemaphore.release();
            future.get(10L, TimeUnit.SECONDS);
            Assert.assertEquals((Object)acls, (Object)simpleAclAuthorizer3.getAcls(this.resource()));
        }
        finally {
            simpleAclAuthorizer3.close();
            executor.shutdownNow();
        }
    }

    @Test
    public void testLocalConcurrentModificationOfResourceAcls() {
        Resource commonResource = new Resource((ResourceType)Topic$.MODULE$, "test", PatternType.LITERAL);
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        Acl acl1 = new Acl(user1, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        Acl acl2 = new Acl(user2, (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1})), commonResource);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl2})), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}))), (Authorizer)this.simpleAclAuthorizer(), commonResource);
    }

    @Test
    public void testDistributedConcurrentModificationOfResourceAcls() {
        Resource commonResource = new Resource((ResourceType)Topic$.MODULE$, "test", PatternType.LITERAL);
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        Acl acl1 = new Acl(user1, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        Acl acl2 = new Acl(user2, (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1})), commonResource);
        this.simpleAclAuthorizer2().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl2})), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}))), (Authorizer)this.simpleAclAuthorizer(), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}))), (Authorizer)this.simpleAclAuthorizer2(), commonResource);
        KafkaPrincipal user3 = new KafkaPrincipal("User", "joe");
        Acl acl3 = new Acl(user3, (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl3})), commonResource);
        boolean deleted = this.simpleAclAuthorizer2().removeAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl3})), commonResource);
        Assert.assertTrue((String)"The authorizer should see a value that needs to be deleted", (boolean)deleted);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}))), (Authorizer)this.simpleAclAuthorizer(), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2}))), (Authorizer)this.simpleAclAuthorizer2(), commonResource);
    }

    @Test
    public void testHighConcurrencyModificationOfResourceAcls() {
        Resource commonResource = new Resource((ResourceType)Topic$.MODULE$, "test", PatternType.LITERAL);
        IndexedSeq acls = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 50).map((Function1 & Serializable & scala.Serializable)i -> SimpleAclAuthorizerTest.$anonfun$testHighConcurrencyModificationOfResourceAcls$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq concurrentFuctions = (IndexedSeq)acls.map((Function1 & Serializable & scala.Serializable)acl -> (Function0 & Serializable & scala.Serializable)() -> {
            int aclId = new StringOps(Predef$.MODULE$.augmentString(acl.principal().getName())).toInt();
            if (aclId % 2 == 0) {
                this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl})), commonResource);
            } else {
                this.simpleAclAuthorizer2().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl})), commonResource);
            }
            return aclId % 10 == 0 ? BoxesRunTime.boxToBoolean((boolean)this.simpleAclAuthorizer2().removeAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl})), commonResource)) : BoxedUnit.UNIT;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Set expectedAcls = ((TraversableOnce)acls.filter((Function1 & Serializable & scala.Serializable)acl -> BoxesRunTime.boxToBoolean((boolean)SimpleAclAuthorizerTest.$anonfun$testHighConcurrencyModificationOfResourceAcls$4(acl)))).toSet();
        TestUtils$.MODULE$.assertConcurrent("Should support many concurrent calls", (Seq<Function0<Object>>)concurrentFuctions, 30000);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)expectedAcls, (Authorizer)this.simpleAclAuthorizer(), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)expectedAcls, (Authorizer)this.simpleAclAuthorizer2(), commonResource);
    }

    @Test
    public void testAclInheritance() {
        this.testImplicationsOfAllow((Operation)All$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$, Write$.MODULE$, Create$.MODULE$, Delete$.MODULE$, Alter$.MODULE$, Describe$.MODULE$, ClusterAction$.MODULE$, DescribeConfigs$.MODULE$, AlterConfigs$.MODULE$, IdempotentWrite$.MODULE$}))));
        this.testImplicationsOfDeny((Operation)All$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$, Write$.MODULE$, Create$.MODULE$, Delete$.MODULE$, Alter$.MODULE$, Describe$.MODULE$, ClusterAction$.MODULE$, DescribeConfigs$.MODULE$, AlterConfigs$.MODULE$, IdempotentWrite$.MODULE$}))));
        this.testImplicationsOfAllow((Operation)Read$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Describe$.MODULE$}))));
        this.testImplicationsOfAllow((Operation)Write$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Describe$.MODULE$}))));
        this.testImplicationsOfAllow((Operation)Delete$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Describe$.MODULE$}))));
        this.testImplicationsOfAllow((Operation)Alter$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Describe$.MODULE$}))));
        this.testImplicationsOfDeny((Operation)Describe$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        this.testImplicationsOfAllow((Operation)AlterConfigs$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{DescribeConfigs$.MODULE$}))));
        this.testImplicationsOfDeny((Operation)DescribeConfigs$.MODULE$, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
    }

    private void testImplicationsOfAllow(Operation parentOp, Set<Operation> allowedOps) {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.3.1");
        RequestChannel.Session hostSession = new RequestChannel.Session(user, host);
        Acl acl = new Acl(user, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), parentOp);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl})), Resource$.MODULE$.ClusterResource());
        Operation$.MODULE$.values().foreach((Function1 & Serializable & scala.Serializable)op -> {
            SimpleAclAuthorizerTest.$anonfun$testImplicationsOfAllow$1(this, hostSession, allowedOps, parentOp, op);
            return BoxedUnit.UNIT;
        });
        this.simpleAclAuthorizer().removeAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl})), Resource$.MODULE$.ClusterResource());
    }

    private void testImplicationsOfDeny(Operation parentOp, Set<Operation> deniedOps) {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        RequestChannel.Session host1Session = new RequestChannel.Session(user1, host1);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(user1, (PermissionType)Deny$.MODULE$, Acl$.MODULE$.WildCardHost(), parentOp), new Acl(user1, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)All$.MODULE$)}));
        this.simpleAclAuthorizer().addAcls(acls, Resource$.MODULE$.ClusterResource());
        Operation$.MODULE$.values().foreach((Function1 & Serializable & scala.Serializable)op -> {
            SimpleAclAuthorizerTest.$anonfun$testImplicationsOfDeny$1(this, host1Session, deniedOps, parentOp, op);
            return BoxedUnit.UNIT;
        });
        this.simpleAclAuthorizer().removeAcls(acls, Resource$.MODULE$.ClusterResource());
    }

    @Test
    public void testHighConcurrencyDeletionOfResourceAcls() {
        Acl acl = new Acl(new KafkaPrincipal("User", this.username()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)All$.MODULE$);
        IndexedSeq concurrentFuctions = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 50).map((Function1 & Serializable & scala.Serializable)x$1 -> SimpleAclAuthorizerTest.$anonfun$testHighConcurrencyDeletionOfResourceAcls$1(this, acl, BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.assertConcurrent("Should support many concurrent calls", (Seq<Function0<Object>>)concurrentFuctions, 30000);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)Predef$.MODULE$.Set().empty(), (Authorizer)this.simpleAclAuthorizer(), this.resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)Predef$.MODULE$.Set().empty(), (Authorizer)this.simpleAclAuthorizer2(), this.resource());
    }

    @Test
    public void testAccessAllowedIfAllowAclExistsOnWildcardResource() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), this.wildCardResource());
        Assert.assertTrue((boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testDeleteAclOnWildcardResource() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl()})), this.wildCardResource());
        this.simpleAclAuthorizer().removeAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), this.wildCardResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowWriteAcl()})), (Object)this.simpleAclAuthorizer().getAcls(this.wildCardResource()));
    }

    @Test
    public void testDeleteAllAclOnWildcardResource() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), this.wildCardResource());
        this.simpleAclAuthorizer().removeAcls(this.wildCardResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Object)this.simpleAclAuthorizer().getAcls());
    }

    @Test
    public void testAccessAllowedIfAllowAclExistsOnPrefixedResource() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), this.prefixedResource());
        Assert.assertTrue((boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testDeleteAclOnPrefixedResource() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl()})), this.prefixedResource());
        this.simpleAclAuthorizer().removeAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), this.prefixedResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowWriteAcl()})), (Object)this.simpleAclAuthorizer().getAcls(this.prefixedResource()));
    }

    @Test
    public void testDeleteAllAclOnPrefixedResource() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl()})), this.prefixedResource());
        this.simpleAclAuthorizer().removeAcls(this.prefixedResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Object)this.simpleAclAuthorizer().getAcls());
    }

    @Test
    public void testAddAclsOnLiteralResource() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl()})), this.resource());
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowWriteAcl(), this.denyReadAcl()})), this.resource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), (Object)this.simpleAclAuthorizer().getAcls(this.resource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.simpleAclAuthorizer().getAcls(this.wildCardResource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.simpleAclAuthorizer().getAcls(this.prefixedResource()));
    }

    @Test
    public void testAddAclsOnWildcardResource() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl()})), this.wildCardResource());
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowWriteAcl(), this.denyReadAcl()})), this.wildCardResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), (Object)this.simpleAclAuthorizer().getAcls(this.wildCardResource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.simpleAclAuthorizer().getAcls(this.resource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.simpleAclAuthorizer().getAcls(this.prefixedResource()));
    }

    @Test
    public void testAddAclsOnPrefiexedResource() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl()})), this.prefixedResource());
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowWriteAcl(), this.denyReadAcl()})), this.prefixedResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), (Object)this.simpleAclAuthorizer().getAcls(this.prefixedResource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.simpleAclAuthorizer().getAcls(this.wildCardResource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.simpleAclAuthorizer().getAcls(this.resource()));
    }

    @Test
    public void testAuthorizeWithPrefixedResource() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, "a_other", PatternType.LITERAL));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, "a_other", PatternType.PREFIXED));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, new StringBuilder(8).append("foo-").append(UUID.randomUUID()).append("-zzz").toString(), PatternType.PREFIXED));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, new StringBuilder(5).append("fooo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, new StringBuilder(3).append("fo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, new StringBuilder(4).append("fop-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, new StringBuilder(4).append("fon-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, "fon-", PatternType.PREFIXED));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, "z_other", PatternType.PREFIXED));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, "z_other", PatternType.LITERAL));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), this.prefixedResource());
        Assert.assertTrue((boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, this.resource()));
    }

    @Test
    public void testSingleCharacterResourceAcls() {
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, "f", PatternType.LITERAL));
        Assert.assertTrue((boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, new Resource((ResourceType)Topic$.MODULE$, "f", PatternType.LITERAL)));
        Assert.assertFalse((boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, new Resource((ResourceType)Topic$.MODULE$, "foo", PatternType.LITERAL)));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.allowReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, "_", PatternType.PREFIXED));
        Assert.assertTrue((boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, new Resource((ResourceType)Topic$.MODULE$, "_foo", PatternType.LITERAL)));
        Assert.assertTrue((boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, new Resource((ResourceType)Topic$.MODULE$, "_", PatternType.LITERAL)));
        Assert.assertFalse((boolean)this.simpleAclAuthorizer().authorize(this.session(), (Operation)Read$.MODULE$, new Resource((ResourceType)Topic$.MODULE$, "foo_", PatternType.LITERAL)));
    }

    @Test
    public void testGetAclsPrincipal() {
        Acl aclOnSpecificPrincipal = new Acl(this.principal(), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Write$.MODULE$);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{aclOnSpecificPrincipal})), this.resource());
        Assert.assertEquals((String)"acl on specific should not be returned for wildcard request", (long)0L, (long)this.simpleAclAuthorizer().getAcls(Acl$.MODULE$.WildCardPrincipal()).size());
        Assert.assertEquals((String)"acl on specific should be returned for specific request", (long)1L, (long)this.simpleAclAuthorizer().getAcls(this.principal()).size());
        Assert.assertEquals((String)"acl on specific should be returned for different principal instance", (long)1L, (long)this.simpleAclAuthorizer().getAcls(new KafkaPrincipal(this.principal().getPrincipalType(), this.principal().getName())).size());
        this.simpleAclAuthorizer().removeAcls(this.resource());
        Acl aclOnWildcardPrincipal = new Acl(Acl$.MODULE$.WildCardPrincipal(), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Write$.MODULE$);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{aclOnWildcardPrincipal})), this.resource());
        Assert.assertEquals((String)"acl on wildcard should be returned for wildcard request", (long)1L, (long)this.simpleAclAuthorizer().getAcls(Acl$.MODULE$.WildCardPrincipal()).size());
        Assert.assertEquals((String)"acl on wildcard should not be returned for specific request", (long)0L, (long)this.simpleAclAuthorizer().getAcls(this.principal()).size());
    }

    @Test(expected=UnsupportedVersionException.class)
    public void testThrowsOnAddPrefixedAclIfInterBrokerProtocolVersionTooLow() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV0$.MODULE$));
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), new Resource((ResourceType)Topic$.MODULE$, "z_other", PatternType.PREFIXED));
    }

    @Test
    public void testWritesExtendedAclChangeEventIfInterBrokerProtocolNotSet() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.empty());
        Resource resource = new Resource((ResourceType)Topic$.MODULE$, "z_other", PatternType.PREFIXED);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.PREFIXED).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), resource);
        String actual = this.getAclChangeEventAsString(PatternType.PREFIXED);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWritesExtendedAclChangeEventWhenInterBrokerProtocolAtLeastKafkaV2() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV1$.MODULE$));
        Resource resource = new Resource((ResourceType)Topic$.MODULE$, "z_other", PatternType.PREFIXED);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.PREFIXED).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), resource);
        String actual = this.getAclChangeEventAsString(PatternType.PREFIXED);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWritesLiteralWritesLiteralAclChangeEventWhenInterBrokerProtocolLessThanKafkaV2eralAclChangesForOlderProtocolVersions() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV0$.MODULE$));
        Resource resource = new Resource((ResourceType)Topic$.MODULE$, "z_other", PatternType.LITERAL);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.LITERAL).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), resource);
        String actual = this.getAclChangeEventAsString(PatternType.LITERAL);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWritesLiteralAclChangeEventWhenInterBrokerProtocolIsKafkaV2() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV1$.MODULE$));
        Resource resource = new Resource((ResourceType)Topic$.MODULE$, "z_other", PatternType.LITERAL);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.LITERAL).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{this.denyReadAcl()})), resource);
        String actual = this.getAclChangeEventAsString(PatternType.LITERAL);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private void givenAuthorizerWithProtocolVersion(Option<ApiVersion> protocolVersion) {
        this.simpleAclAuthorizer().close();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        props.put(SimpleAclAuthorizer$.MODULE$.SuperUsersProp(), this.superUsers());
        protocolVersion.foreach((Function1 & Serializable & scala.Serializable)version -> props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), version.toString()));
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.simpleAclAuthorizer().configure(this.config().originals());
    }

    private String getAclChangeEventAsString(PatternType patternType) {
        ZkAclStore store = ZkAclStore$.MODULE$.apply(patternType);
        GetChildrenResponse children = (GetChildrenResponse)this.zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(store.changeStore().aclChangePath(), GetChildrenRequest$.MODULE$.apply$default$2()));
        children.maybeThrow();
        Assert.assertEquals((String)"Expecting 1 change event", (long)1L, (long)children.children().size());
        GetDataResponse data = (GetDataResponse)this.zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(new StringBuilder(1).append(store.changeStore().aclChangePath()).append("/").append(children.children().head()).toString(), GetDataRequest$.MODULE$.apply$default$2()));
        data.maybeThrow();
        return new String(data.data(), StandardCharsets.UTF_8);
    }

    private Set<Acl> changeAclAndVerify(Set<Acl> originalAcls, Set<Acl> addedAcls, Set<Acl> removedAcls, Resource resource) {
        Set acls = originalAcls;
        if (addedAcls.nonEmpty()) {
            this.simpleAclAuthorizer().addAcls(addedAcls, resource);
            acls = (Set)acls.$plus$plus(addedAcls);
        }
        if (removedAcls.nonEmpty()) {
            this.simpleAclAuthorizer().removeAcls(removedAcls, resource);
            acls = (Set)acls.$minus$minus(removedAcls);
        }
        TestUtils$.MODULE$.waitAndVerifyAcls(acls, (Authorizer)this.simpleAclAuthorizer(), resource);
        return acls;
    }

    private Resource changeAclAndVerify$default$4() {
        return this.resource();
    }

    public static final /* synthetic */ Acl $anonfun$testHighConcurrencyModificationOfResourceAcls$1(int i) {
        KafkaPrincipal useri = new KafkaPrincipal("User", ((Object)BoxesRunTime.boxToInteger((int)i)).toString());
        return new Acl(useri, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$testHighConcurrencyModificationOfResourceAcls$4(Acl acl) {
        int aclId = new StringOps(Predef$.MODULE$.augmentString(acl.principal().getName())).toInt();
        return aclId % 10 != 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$testImplicationsOfAllow$1(SimpleAclAuthorizerTest $this, RequestChannel.Session hostSession$1, Set allowedOps$1, Operation parentOp$1, Operation op) {
        boolean authorized;
        block3: {
            block2: {
                authorized = $this.simpleAclAuthorizer().authorize(hostSession$1, op, Resource$.MODULE$.ClusterResource());
                if (allowedOps$1.contains((Object)op)) break block2;
                Operation operation = op;
                Operation operation2 = parentOp$1;
                if (operation != null ? !operation.equals(operation2) : operation2 != null) break block3;
            }
            Assert.assertTrue((String)new StringBuilder(26).append("ALLOW ").append(parentOp$1).append(" should imply ALLOW ").append(op).toString(), (boolean)authorized);
            return;
        }
        Assert.assertFalse((String)new StringBuilder(30).append("ALLOW ").append(parentOp$1).append(" should not imply ALLOW ").append(op).toString(), (boolean)authorized);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$testImplicationsOfDeny$1(SimpleAclAuthorizerTest $this, RequestChannel.Session host1Session$1, Set deniedOps$1, Operation parentOp$2, Operation op) {
        boolean authorized;
        block3: {
            block2: {
                authorized = $this.simpleAclAuthorizer().authorize(host1Session$1, op, Resource$.MODULE$.ClusterResource());
                if (deniedOps$1.contains((Object)op)) break block2;
                Operation operation = op;
                Operation operation2 = parentOp$2;
                if (operation != null ? !operation.equals(operation2) : operation2 != null) break block3;
            }
            Assert.assertFalse((String)new StringBuilder(24).append("DENY ").append(parentOp$2).append(" should imply DENY ").append(op).toString(), (boolean)authorized);
            return;
        }
        Assert.assertTrue((String)new StringBuilder(28).append("DENY ").append(parentOp$2).append(" should not imply DENY ").append(op).toString(), (boolean)authorized);
    }

    public static final /* synthetic */ Function0 $anonfun$testHighConcurrencyDeletionOfResourceAcls$1(SimpleAclAuthorizerTest $this, Acl acl$2, int x$1) {
        return (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            $this.simpleAclAuthorizer().addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl$2})), $this.resource());
            return $this.simpleAclAuthorizer2().removeAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl$2})), $this.resource());
        };
    }

    public SimpleAclAuthorizerTest() {
        this.superUsers = "User:superuser1; User:superuser2";
        this.username = "alice";
    }

    public class CustomPrincipal
    extends KafkaPrincipal {
        public boolean equals(Object o) {
            return false;
        }

        public /* synthetic */ SimpleAclAuthorizerTest kafka$security$auth$SimpleAclAuthorizerTest$CustomPrincipal$$$outer() {
            return SimpleAclAuthorizerTest.this;
        }

        public CustomPrincipal(String principalType, String name) {
            if (SimpleAclAuthorizerTest.this == null) {
                throw null;
            }
            super(principalType, name);
        }
    }
}

