/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.nio.ByteBuffer;
import java.util.Properties;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.collection.JavaConverters$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001I4Aa\u0003\u0007\u0001#!)a\u0003\u0001C\u0001/!9\u0011\u0004\u0001b\u0001\n\u0013Q\u0002BB\u0012\u0001A\u0003%1\u0004C\u0004%\u0001\t\u0007I\u0011A\u0013\t\r1\u0002\u0001\u0015!\u0003'\u0011\u0015i\u0003\u0001\"\u0011/\u0011\u0015Q\u0004\u0001\"\u0011<\u0011\u0015)\u0005\u0001\"\u0001<\u0011\u0015Q\u0005\u0001\"\u0003L\u0011\u0015q\u0006\u0001\"\u0003`\u0005u\tE\r\u001a)beRLG/[8ogR{G\u000b\u001f8SKF,Xm\u001d;UKN$(BA\u0007\u000f\u0003\u0019\u0019XM\u001d<fe*\tq\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u0015\u001b\u0005a\u0011BA\u000b\r\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\u0018A\u0002\u001fj]&$h\bF\u0001\u0019!\t\u0019\u0002!\u0001\u0004u_BL7-M\u000b\u00027A\u0011A$I\u0007\u0002;)\u0011adH\u0001\u0005Y\u0006twMC\u0001!\u0003\u0011Q\u0017M^1\n\u0005\tj\"AB*ue&tw-A\u0004u_BL7-\r\u0011\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t+\u00051\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#aA%oi\u0006qa.^7QCJ$\u0018\u000e^5p]N\u0004\u0013!\u00059s_B,'\u000f^=Pm\u0016\u0014(/\u001b3fgR\u0011qF\r\t\u0003OAJ!!\r\u0015\u0003\tUs\u0017\u000e\u001e\u0005\u0006g\u0019\u0001\r\u0001N\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\bCA\u001b9\u001b\u00051$BA\u001c \u0003\u0011)H/\u001b7\n\u0005e2$A\u0003)s_B,'\u000f^5fg\u0006)1/\u001a;VaR\tq\u0006\u000b\u0002\b{A\u0011ahQ\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u0005\u0006\u0019qN]4\n\u0005\u0011{$A\u0002\"fM>\u0014X-\u0001\u001ftQ>,H\u000e\u001a*fG\u0016Lg/Z(qKJ\fG/[8o\u001d>$\u0018\t\u001e;f[B$X\rZ,iK:|E\u000f[3s!\u0006\u0014H/\u001b;j_:D\u0015m]#se>\u0014\bF\u0001\u0005H!\tq\u0004*\u0003\u0002J\u007f\t!A+Z:u\u0003a\u0019XM\u001c3BI\u0012\u0004\u0016M\u001d;ji&|gn\u001d*fcV,7\u000f\u001e\u000b\u0004\u0019^K\u0006CA'V\u001b\u0005q%BA(Q\u0003!\u0011X-];fgR\u001c(BA)S\u0003\u0019\u0019w.\\7p]*\u0011qb\u0015\u0006\u0003)\u0006\u000ba!\u00199bG\",\u0017B\u0001,O\u0005i\tE\r\u001a)beRLG/[8ogR{G\u000b\u001f8SKN\u0004xN\\:f\u0011\u0015A\u0016\u00021\u0001'\u0003!aW-\u00193fe&#\u0007\"\u0002.\n\u0001\u0004Y\u0016a\u0002:fcV,7\u000f\u001e\t\u0003\u001brK!!\u0018(\u00033\u0005#G\rU1si&$\u0018n\u001c8t)>$\u0006P\u001c*fcV,7\u000f^\u0001\u000eGJ,\u0017\r^3SKF,Xm\u001d;\u0015\u0005m\u0003\u0007\"B1\u000b\u0001\u0004\u0011\u0017A\u00039beRLG/[8ogB\u00191m\u001b8\u000f\u0005\u0011LgBA3i\u001b\u00051'BA4\u0011\u0003\u0019a$o\\8u}%\t\u0011&\u0003\u0002kQ\u00059\u0001/Y2lC\u001e,\u0017B\u00017n\u0005\u0011a\u0015n\u001d;\u000b\u0005)D\u0003CA8q\u001b\u0005\u0001\u0016BA9Q\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004")
public class AddPartitionsToTxnRequestTest
extends BaseRequestTest {
    private final String topic1;
    private final int numPartitions;

    private String topic1() {
        return this.topic1;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    @Override
    public void propertyOverrides(Properties properties) {
        properties.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.createTopic(this.topic1(), this.numPartitions(), this.servers().size(), new Properties());
    }

    @Test
    public void shouldReceiveOperationNotAttemptedWhenOtherPartitionHasError() {
        TopicPartition nonExistentTopic = new TopicPartition("unknownTopic", 0);
        TopicPartition createdTopicPartition = new TopicPartition(this.topic1(), 0);
        AddPartitionsToTxnRequest request = this.createRequest((List<TopicPartition>)new .colon.colon((Object)createdTopicPartition, (List)new .colon.colon((Object)nonExistentTopic, (List)Nil$.MODULE$)));
        int leaderId = ((KafkaServer)this.servers().head()).config().brokerId();
        AddPartitionsToTxnResponse response = this.sendAddPartitionsRequest(leaderId, request);
        Assert.assertEquals((long)2L, (long)response.errors().size());
        Assert.assertTrue((boolean)response.errors().containsKey(createdTopicPartition));
        Assert.assertEquals((Object)Errors.OPERATION_NOT_ATTEMPTED, response.errors().get(createdTopicPartition));
        Assert.assertTrue((boolean)response.errors().containsKey(nonExistentTopic));
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, response.errors().get(nonExistentTopic));
    }

    private AddPartitionsToTxnResponse sendAddPartitionsRequest(int leaderId, AddPartitionsToTxnRequest request) {
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.ADD_PARTITIONS_TO_TXN, this.brokerSocketServer(leaderId), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return AddPartitionsToTxnResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private AddPartitionsToTxnRequest createRequest(List<TopicPartition> partitions) {
        String transactionalId = "foobar";
        long producerId = 1000L;
        short producerEpoch = 0;
        AddPartitionsToTxnRequest.Builder builder = new AddPartitionsToTxnRequest.Builder(transactionalId, producerId, producerEpoch, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(partitions).asJava());
        return (AddPartitionsToTxnRequest)builder.build();
    }

    public AddPartitionsToTxnRequestTest() {
        this.topic1 = "foobartopic";
        this.numPartitions = 3;
    }
}

