/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.controller.ControllerChannelManager;
import kafka.controller.ControllerChannelManager$;
import kafka.controller.ControllerContext;
import kafka.controller.StateChangeLogger;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001\u0002\u000b\u0016\u0001iAQ!\t\u0001\u0005\u0002\tBq!\n\u0001C\u0002\u0013\u0005a\u0005\u0003\u0004.\u0001\u0001\u0006Ia\n\u0005\b]\u0001\u0011\r\u0011\"\u0001'\u0011\u0019y\u0003\u0001)A\u0005O!9\u0001\u0007\u0001a\u0001\n\u0003\t\u0004bB!\u0001\u0001\u0004%\tA\u0011\u0005\u0007\u0011\u0002\u0001\u000b\u0015\u0002\u001a\t\u000b%\u0003A\u0011\t&\t\u000bQ\u0003A\u0011\t&\t\u000be\u0003A\u0011\u0001&\t\u000by\u0003A\u0011\u0001&\t\u000b\u0001\u0004A\u0011\u0001&\t\u000b\t\u0004A\u0011\u0001&\t\u000b\u0011\u0004A\u0011B3\t\u000b-\u0004A\u0011\u00027\t\u000b5\u0004A\u0011\u00028\t\u000b]\u0004A\u0011\u0002=\t\u000f\u0005\u001d\u0003\u0001\"\u0003\u0002J\tQ\"I]8lKJ,\u0005o\\2i\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u0011acF\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003a\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00017A\u0011AdH\u0007\u0002;)\u0011adF\u0001\u0003u.L!\u0001I\u000f\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\t1\u0005\u0005\u0002%\u00015\tQ#A\u0005ce>\\WM]%ecU\tq\u0005\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013FA\u0002J]R\f!B\u0019:pW\u0016\u0014\u0018\nZ\u0019!\u0003%\u0011'o\\6fe&#''\u0001\u0006ce>\\WM]%ee\u0001\nqa]3sm\u0016\u00148/F\u00013!\r\u00194H\u0010\b\u0003ier!!\u000e\u001d\u000e\u0003YR!aN\r\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0013B\u0001\u001e*\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001P\u001f\u0003\u0007M+\u0017O\u0003\u0002;SA\u0011AeP\u0005\u0003\u0001V\u00111bS1gW\u0006\u001cVM\u001d<fe\u0006Y1/\u001a:wKJ\u001cx\fJ3r)\t\u0019e\t\u0005\u0002)\t&\u0011Q)\u000b\u0002\u0005+:LG\u000fC\u0004H\u000f\u0005\u0005\t\u0019\u0001\u001a\u0002\u0007a$\u0013'\u0001\u0005tKJ4XM]:!\u0003\u0015\u0019X\r^+q)\u0005\u0019\u0005FA\u0005M!\ti%+D\u0001O\u0015\ty\u0005+A\u0003kk:LGOC\u0001R\u0003\ry'oZ\u0005\u0003':\u0013aAQ3g_J,\u0017\u0001\u0003;fCJ$un\u001e8)\u0005)1\u0006CA'X\u0013\tAfJA\u0003BMR,'/\u0001\u0016uKN$(+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014(I]8lKJ,\u0005o\\2i\u001b\u0006$8\r[3t/&$\bNW6)\u0005-Y\u0006CA']\u0013\tifJ\u0001\u0003UKN$\u0018a\u000b;fgR\u001cuN\u001c;s_2dWM\u001d\"s_.,'/\u00129pG\"\u001c\u0015m\u00195f\u001b\u0006$8\r[3t/&$\bNW6)\u00051Y\u0016\u0001\u000b;fgR\u001cuN\u001c;s_2\u0014V-];fgR<\u0016\u000e\u001e5D_J\u0014Xm\u0019;Ce>\\WM]#q_\u000eD\u0007FA\u0007\\\u0003\u0019\"Xm\u001d;D_:$(o\u001c7SKF,Xm\u001d;XSRD7\u000b^1mK\n\u0013xn[3s\u000bB|7\r\u001b\u0015\u0003\u001dm\u000b\u0011\u0005^3ti\u000e{g\u000e\u001e:pYJ+\u0017/^3ti^KG\u000f\u001b\"s_.,'/\u00129pG\"$\"a\u00114\t\u000b\u001d|\u0001\u0019\u00015\u0002+%\u001cX\t]8dQ&s'+Z9vKN$8\u000b^1mKB\u0011\u0001&[\u0005\u0003U&\u0012qAQ8pY\u0016\fg.A\u0007hKR\u001cuN\u001c;s_2dWM]\u000b\u0002}\u0005i3\r[3dW\u000e{g\u000e\u001e:pY2,'O\u0011:pW\u0016\u0014X\t]8dQN\u001c\u0015m\u00195f\u001b\u0006$8\r[3t/&$\bNW6\u0015\u0005\r{\u0007\"\u00029\u0012\u0001\u0004\t\u0018!E2p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yiB\u0011!/^\u0007\u0002g*\u0011AoF\u0001\u000bG>tGO]8mY\u0016\u0014\u0018B\u0001<t\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010^\u0001(g\u0016tG-\u00118e-\u0016\u0014\u0018NZ=Ti\u0006dWM\u0011:pW\u0016\u0014X\t]8dQ&s'+Z:q_:\u001cX\rF\u0003Dsz\f9\u0002C\u0003{%\u0001\u000710\u0001\rd_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ\u0004\"A\u001d?\n\u0005u\u001c(\u0001G\"p]R\u0014x\u000e\u001c7fe\u000eC\u0017M\u001c8fY6\u000bg.Y4fe\"1qP\u0005a\u0001\u0003\u0003\tq!\u00199j\u0017\u0016L8\u000f\u0005\u0003\u0002\u0004\u0005MQBAA\u0003\u0015\u0011\t9!!\u0003\u0002\u0011A\u0014x\u000e^8d_2TA!a\u0003\u0002\u000e\u000511m\\7n_:T1\u0001GA\b\u0015\r\t\t\u0002U\u0001\u0007CB\f7\r[3\n\t\u0005U\u0011Q\u0001\u0002\b\u0003BL7*Z=t\u0011\u001d\tIB\u0005a\u0001\u00037\tqAY;jY\u0012,'\u000f\r\u0003\u0002\u001e\u0005U\u0002CBA\u0010\u0003W\t\tD\u0004\u0003\u0002\"\u0005\u001dRBAA\u0012\u0015\u0011\t)#!\u0003\u0002\u0011I,\u0017/^3tiNLA!!\u000b\u0002$\u00051\u0012IY:ue\u0006\u001cGoQ8oiJ|GNU3rk\u0016\u001cH/\u0003\u0003\u0002.\u0005=\"a\u0002\"vS2$WM\u001d\u0006\u0005\u0003S\t\u0019\u0003\u0005\u0003\u00024\u0005UB\u0002\u0001\u0003\r\u0003o\t9\"!A\u0001\u0002\u000b\u0005\u0011\u0011\b\u0002\u0004?\u0012\n\u0014\u0003BA\u001e\u0003\u0003\u00022\u0001KA\u001f\u0013\r\ty$\u000b\u0002\b\u001d>$\b.\u001b8h!\u0011\t\t#a\u0011\n\t\u0005\u0015\u00131\u0005\u0002\u0017\u0003\n\u001cHO]1di\u000e{g\u000e\u001e:pYJ+\u0017/^3ti\u0006y2/\u001a8e\u0003:$g+\u001a:jMf\u001cVoY2fgN4W\u000f\u001c*fgB|gn]3\u0015\u000f\r\u000bY%!\u0014\u0002P!)!p\u0005a\u0001w\"1qp\u0005a\u0001\u0003\u0003Aq!!\u0007\u0014\u0001\u0004\t\t\u0006\r\u0003\u0002T\u0005]\u0003CBA\u0010\u0003W\t)\u0006\u0005\u0003\u00024\u0005]C\u0001DA-\u0003\u001f\n\t\u0011!A\u0003\u0002\u0005e\"aA0%e\u0001")
public class BrokerEpochIntegrationTest
extends ZooKeeperTestHarness {
    private final int brokerId1;
    private final int brokerId2;
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.empty();

    public int brokerId1() {
        return this.brokerId1;
    }

    public int brokerId2() {
        return this.brokerId2;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Seq configs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{TestUtils$.MODULE$.createBrokerConfig(this.brokerId1(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()), TestUtils$.MODULE$.createBrokerConfig(this.brokerId2(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18())}));
        configs.foreach((Function1 & Serializable & scala.Serializable)config -> config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString()));
        this.servers_$eq((Seq<KafkaServer>)((Seq)configs.map((Function1 & Serializable & scala.Serializable)config -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testReplicaManagerBrokerEpochMatchesWithZk() {
        scala.collection.immutable.Map brokerAndEpochs = this.zkClient().getAllBrokerAndEpochsInCluster();
        Assert.assertEquals((long)brokerAndEpochs.size(), (long)this.servers().size());
        brokerAndEpochs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BrokerEpochIntegrationTest.$anonfun$testReplicaManagerBrokerEpochMatchesWithZk$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testControllerBrokerEpochCacheMatchesWithZk() {
        KafkaServer controller = this.getController();
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)BrokerEpochIntegrationTest.$anonfun$testControllerBrokerEpochCacheMatchesWithZk$1(controller, e))).get();
        this.checkControllerBrokerEpochsCacheMatchesWithZk(controller.kafkaController().controllerContext());
        otherBroker.shutdown();
        this.checkControllerBrokerEpochsCacheMatchesWithZk(controller.kafkaController().controllerContext());
        otherBroker.startup();
        this.checkControllerBrokerEpochsCacheMatchesWithZk(controller.kafkaController().controllerContext());
    }

    @Test
    public void testControlRequestWithCorrectBrokerEpoch() {
        this.testControlRequestWithBrokerEpoch(false);
    }

    @Test
    public void testControlRequestWithStaleBrokerEpoch() {
        this.testControlRequestWithBrokerEpoch(true);
    }

    private void testControlRequestWithBrokerEpoch(boolean isEpochInRequestStale) {
        TopicPartition tp = new TopicPartition("new-topic", 0);
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}))), this.servers());
        int controllerId = 2;
        int controllerEpoch = ((Tuple2)this.zkClient().getControllerEpoch().get())._1$mcI$sp();
        KafkaConfig controllerConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(controllerId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        scala.collection.immutable.Map brokerAndEpochs = ((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)s -> new Tuple2((Object)new Broker(s.config().brokerId(), "localhost", TestUtils$.MODULE$.boundPort((KafkaServer)s, TestUtils$.MODULE$.boundPort$default$2()), listenerName, securityProtocol), (Object)BoxesRunTime.boxToLong((long)s.kafkaController().brokerEpoch())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Iterable nodes = (Iterable)brokerAndEpochs.keys().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.node(listenerName), scala.collection.Iterable$.MODULE$.canBuildFrom());
        ControllerContext controllerContext = new ControllerContext();
        controllerContext.setLiveBrokerAndEpochs(brokerAndEpochs);
        Metrics metrics = new Metrics();
        ControllerChannelManager controllerChannelManager = new ControllerChannelManager(controllerContext, controllerConfig, Time.SYSTEM, metrics, new StateChangeLogger(controllerId, true, (Option)None$.MODULE$), ControllerChannelManager$.MODULE$.$lessinit$greater$default$6());
        controllerChannelManager.startup();
        KafkaServer broker2 = (KafkaServer)this.servers().apply(this.brokerId2());
        long epochInRequest = isEpochInRequestStale ? broker2.kafkaController().brokerEpoch() - 1L : broker2.kafkaController().brokerEpoch();
        try {
            Object object;
            scala.collection.immutable.Map partitionStates = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new LeaderAndIsrRequest.PartitionState(controllerEpoch, this.brokerId2(), LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()}))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava(), LeaderAndIsr$.MODULE$.initialZKVersion(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava(), false))}));
            LeaderAndIsrRequest.Builder requestBuilder = new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), controllerId, controllerEpoch, epochInRequest, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionStates).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)nodes.toSet()).asJava());
            if (isEpochInRequestStale) {
                this.sendAndVerifyStaleBrokerEpochInResponse(controllerChannelManager, ApiKeys.LEADER_AND_ISR, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)requestBuilder);
                object = BoxedUnit.UNIT;
            } else {
                this.sendAndVerifySuccessfulResponse(controllerChannelManager, ApiKeys.LEADER_AND_ISR, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)requestBuilder);
                object = BoxesRunTime.boxToInteger((int)TestUtils$.MODULE$.waitUntilLeaderIsKnown((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{broker2}))), tp, 10000L));
            }
            scala.collection.immutable.Map partitionStates2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new UpdateMetadataRequest.PartitionState(controllerEpoch, this.brokerId2(), LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()}))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava(), LeaderAndIsr$.MODULE$.initialZKVersion(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.empty()).asJava()))}));
            scala.collection.immutable.Iterable liverBrokers = (scala.collection.immutable.Iterable)brokerAndEpochs.map((Function1 & Serializable & scala.Serializable)brokerAndEpoch -> {
                Broker broker = (Broker)brokerAndEpoch._1();
                SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
                ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
                Node node = broker.node(listenerName);
                Seq endPoints = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint(node.host(), node.port(), securityProtocol, listenerName)}));
                return new UpdateMetadataRequest.Broker(broker.id(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(endPoints).asJava(), (String)broker.rack().orNull(Predef$.MODULE$.$conforms()));
            }, Iterable$.MODULE$.canBuildFrom());
            UpdateMetadataRequest.Builder requestBuilder2 = new UpdateMetadataRequest.Builder(ApiKeys.UPDATE_METADATA.latestVersion(), controllerId, controllerEpoch, epochInRequest, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionStates2).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)liverBrokers.toSet()).asJava());
            if (isEpochInRequestStale) {
                this.sendAndVerifyStaleBrokerEpochInResponse(controllerChannelManager, ApiKeys.UPDATE_METADATA, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)requestBuilder2);
            } else {
                this.sendAndVerifySuccessfulResponse(controllerChannelManager, ApiKeys.UPDATE_METADATA, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)requestBuilder2);
                TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{broker2}))), tp.topic(), tp.partition(), 10000L);
                Assert.assertEquals((long)this.brokerId2(), (long)((UpdateMetadataRequest.PartitionState)broker2.metadataCache().getPartitionInfo((String)tp.topic(), (int)tp.partition()).get()).basePartitionState.leader);
            }
            StopReplicaRequest.Builder requestBuilder3 = new StopReplicaRequest.Builder(ApiKeys.STOP_REPLICA.latestVersion(), controllerId, controllerEpoch, epochInRequest, true, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava());
            if (isEpochInRequestStale) {
                this.sendAndVerifyStaleBrokerEpochInResponse(controllerChannelManager, ApiKeys.STOP_REPLICA, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)requestBuilder3);
            } else {
                this.sendAndVerifySuccessfulResponse(controllerChannelManager, ApiKeys.STOP_REPLICA, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)requestBuilder3);
                Assert.assertTrue((boolean)broker2.replicaManager().getPartition(tp).isEmpty());
            }
        }
        finally {
            controllerChannelManager.shutdown();
            metrics.close();
        }
    }

    private KafkaServer getController() {
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        return (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)BrokerEpochIntegrationTest.$anonfun$getController$1(controllerId, s)))).head();
    }

    private void checkControllerBrokerEpochsCacheMatchesWithZk(ControllerContext controllerContext) {
        scala.collection.immutable.Map brokerAndEpochs = this.zkClient().getAllBrokerAndEpochsInCluster();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            scala.collection.immutable.Map brokerEpochsInControllerContext = controllerContext.liveBrokerIdAndEpochs();
            return brokerAndEpochs.size() != brokerEpochsInControllerContext.size() ? false : brokerAndEpochs.forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerEpochIntegrationTest.$anonfun$checkControllerBrokerEpochsCacheMatchesWithZk$2(brokerEpochsInControllerContext, x0$1)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Broker epoch mismatches", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private void sendAndVerifyStaleBrokerEpochInResponse(ControllerChannelManager controllerChannelManager, ApiKeys apiKeys, AbstractControlRequest.Builder<? extends AbstractControlRequest> builder) {
        BooleanRef staleBrokerEpochDetected = BooleanRef.create((boolean)false);
        controllerChannelManager.sendRequest(this.brokerId2(), apiKeys, builder, (Function1 & Serializable & scala.Serializable)response -> {
            staleBrokerEpochDetected.elem = response.errorCounts().containsKey(Errors.STALE_BROKER_EPOCH);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> staleBrokerEpochDetected$1.elem, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Broker epoch should be stale", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertTrue((String)"Stale broker epoch not detected by the broker", (boolean)staleBrokerEpochDetected.elem);
    }

    private void sendAndVerifySuccessfulResponse(ControllerChannelManager controllerChannelManager, ApiKeys apiKeys, AbstractControlRequest.Builder<? extends AbstractControlRequest> builder) {
        VolatileBooleanRef succeed = VolatileBooleanRef.create((boolean)false);
        controllerChannelManager.sendRequest(this.brokerId2(), apiKeys, builder, (Function1 & Serializable & scala.Serializable)response -> {
            succeed.elem = response.errorCounts().isEmpty() || response.errorCounts().containsKey(Errors.NONE) && response.errorCounts().size() == 1;
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> succeed$1.elem, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Should receive response with no errors", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaManagerBrokerEpochMatchesWithZk$2(Broker broker$1, KafkaServer e) {
        return e.config().brokerId() == broker$1.id();
    }

    public static final /* synthetic */ void $anonfun$testReplicaManagerBrokerEpochMatchesWithZk$1(BrokerEpochIntegrationTest $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Broker broker = (Broker)tuple2._1();
        long epoch = tuple2._2$mcJ$sp();
        Option brokerServer = $this.servers().find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)BrokerEpochIntegrationTest.$anonfun$testReplicaManagerBrokerEpochMatchesWithZk$2(broker, e)));
        Assert.assertTrue((boolean)brokerServer.isDefined());
        Assert.assertEquals((long)epoch, (long)((KafkaServer)brokerServer.get()).kafkaController().brokerEpoch());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$testControllerBrokerEpochCacheMatchesWithZk$1(KafkaServer controller$1, KafkaServer e) {
        return e.config().brokerId() != controller$1.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$getController$1(int controllerId$1, KafkaServer s) {
        return s.config().brokerId() == controllerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$checkControllerBrokerEpochsCacheMatchesWithZk$2(scala.collection.immutable.Map brokerEpochsInControllerContext$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Broker broker = (Broker)tuple2._1();
        long epoch = tuple2._2$mcJ$sp();
        boolean bl = brokerEpochsInControllerContext$1.get((Object)BoxesRunTime.boxToInteger((int)broker.id())).contains((Object)BoxesRunTime.boxToLong((long)epoch));
        return bl;
    }

    public BrokerEpochIntegrationTest() {
        this.brokerId1 = 0;
        this.brokerId2 = 1;
    }
}

