/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.api.KAFKA_0_11_0_IV2$;
import kafka.log.LogConfig$;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.ProducerCompressionCodec$;
import kafka.message.ZStdCompressionCodec$;
import kafka.server.BaseRequestTest;
import kafka.server.FetchRequestTest$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.AbstractRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.SetLike;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h\u0001\u0002\u000e\u001c\u0001\u0001BQ!\n\u0001\u0005\u0002\u0019Bq\u0001\u000b\u0001A\u0002\u0013%\u0011\u0006C\u0004D\u0001\u0001\u0007I\u0011\u0002#\t\r-\u0003\u0001\u0015)\u0003+\u0011\u0015a\u0005\u0001\"\u0011N\u0011\u0015q\u0005\u0001\"\u0003P\u0011\u00151\b\u0001\"\u0003x\u0011%\t)\u0002AI\u0001\n\u0013\t9\u0002C\u0004\u0002.\u0001!I!a\f\t\r\u0005-\u0003\u0001\"\u0003N\u0011\u0019\ti\u0005\u0001C\u0001\u001b\"1\u0011Q\f\u0001\u0005\u00025Ca!!\u0019\u0001\t\u0003i\u0005BBA3\u0001\u0011\u0005Q\n\u0003\u0004\u0002j\u0001!\t!\u0014\u0005\u0007\u0003[\u0002A\u0011A'\t\r\u0005E\u0004\u0001\"\u0001N\u0011\u0019\t)\b\u0001C\u0001\u001b\"1\u0011\u0011\u0010\u0001\u0005\u00025Ca!! \u0001\t\u0003i\u0005bBAA\u0001\u0011%\u00111\u0011\u0005\b\u0003;\u0003A\u0011BAP\u0011\u001d\t\t\f\u0001C\u0005\u0003gC\u0011\"!2\u0001#\u0003%I!a2\t\u000f\u0005-\u0007\u0001\"\u0003\u0002N\n\u0001b)\u001a;dQJ+\u0017/^3tiR+7\u000f\u001e\u0006\u00039u\taa]3sm\u0016\u0014(\"\u0001\u0010\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\t\t\u0003E\rj\u0011aG\u0005\u0003Im\u0011qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001d\u0002\"A\t\u0001\u0002\u0011A\u0014x\u000eZ;dKJ,\u0012A\u000b\t\u0005WQ2d'D\u0001-\u0015\tASF\u0003\u0002/_\u000591\r\\5f]R\u001c(B\u0001\u00101\u0015\t\t$'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002g\u0005\u0019qN]4\n\u0005Ub#!D&bM.\f\u0007K]8ek\u000e,'\u000f\u0005\u00028\u0001:\u0011\u0001H\u0010\t\u0003sqj\u0011A\u000f\u0006\u0003w}\ta\u0001\u0010:p_Rt$\"A\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}b\u0014A\u0002)sK\u0012,g-\u0003\u0002B\u0005\n11\u000b\u001e:j]\u001eT!a\u0010\u001f\u0002\u0019A\u0014x\u000eZ;dKJ|F%Z9\u0015\u0005\u0015K\u0005C\u0001$H\u001b\u0005a\u0014B\u0001%=\u0005\u0011)f.\u001b;\t\u000f)\u001b\u0011\u0011!a\u0001U\u0005\u0019\u0001\u0010J\u0019\u0002\u0013A\u0014x\u000eZ;dKJ\u0004\u0013\u0001\u0003;fCJ$un\u001e8\u0015\u0003\u0015\u000b!c\u0019:fCR,g)\u001a;dQJ+\u0017/^3tiR)\u0001\u000bW/`]B\u0011\u0011KV\u0007\u0002%*\u00111\u000bV\u0001\te\u0016\fX/Z:ug*\u0011QkL\u0001\u0007G>lWn\u001c8\n\u0005]\u0013&\u0001\u0004$fi\u000eD'+Z9vKN$\b\"B-\u0007\u0001\u0004Q\u0016\u0001E7bqJ+7\u000f]8og\u0016\u0014\u0015\u0010^3t!\t15,\u0003\u0002]y\t\u0019\u0011J\u001c;\t\u000by3\u0001\u0019\u0001.\u0002#5\f\u0007\u0010U1si&$\u0018n\u001c8CsR,7\u000fC\u0003a\r\u0001\u0007\u0011-A\bu_BL7\rU1si&$\u0018n\u001c8t!\r\u0011wM\u001b\b\u0003G\u0016t!!\u000f3\n\u0003uJ!A\u001a\u001f\u0002\u000fA\f7m[1hK&\u0011\u0001.\u001b\u0002\u0004'\u0016\f(B\u00014=!\tYG.D\u0001U\u0013\tiGK\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000b=4\u0001\u0019\u00019\u0002\u0013=4gm]3u\u001b\u0006\u0004\b\u0003B\u001crUNL!A\u001d\"\u0003\u00075\u000b\u0007\u000f\u0005\u0002Gi&\u0011Q\u000f\u0010\u0002\u0005\u0019>tw-\u0001\nde\u0016\fG/\u001a)beRLG/[8o\u001b\u0006\u0004Hc\u0002=\u0002\u0010\u0005E\u00111\u0003\t\u0006szT\u0017\u0011A\u0007\u0002u*\u00111\u0010`\u0001\u0005kRLGNC\u0001~\u0003\u0011Q\u0017M^1\n\u0005}T(!\u0004'j].,G\rS1tQ6\u000b\u0007\u000f\u0005\u0003\u0002\u0004\u0005%abA)\u0002\u0006%\u0019\u0011q\u0001*\u0002\u0019\u0019+Go\u00195SKF,Xm\u001d;\n\t\u0005-\u0011Q\u0002\u0002\u000e!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u000b\u0007\u0005\u001d!\u000bC\u0003_\u000f\u0001\u0007!\fC\u0003a\u000f\u0001\u0007\u0011\rC\u0004p\u000fA\u0005\t\u0019\u00019\u00029\r\u0014X-\u0019;f!\u0006\u0014H/\u001b;j_:l\u0015\r\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\u0004\u0016\u0004a\u0006m1FAA\u000f!\u0011\ty\"!\u000b\u000e\u0005\u0005\u0005\"\u0002BA\u0012\u0003K\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001dB(\u0001\u0006b]:|G/\u0019;j_:LA!a\u000b\u0002\"\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002!M,g\u000e\u001a$fi\u000eD'+Z9vKN$HCBA\u0019\u0003\u0007\n9\u0005E\u0003R\u0003g\t9$C\u0002\u00026I\u0013QBR3uG\"\u0014Vm\u001d9p]N,\u0007\u0003BA\u001d\u0003\u007fi!!a\u000f\u000b\u0007\u0005uB+\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0003\u0003\nYDA\u0007NK6|'/\u001f*fG>\u0014Hm\u001d\u0005\u0007\u0003\u000bJ\u0001\u0019\u0001.\u0002\u00111,\u0017\rZ3s\u0013\u0012Da!!\u0013\n\u0001\u0004\u0001\u0016a\u0002:fcV,7\u000f^\u0001\rS:LG\u000f\u0015:pIV\u001cWM]\u0001/i\u0016\u001cHO\u0011:pW\u0016\u0014(+Z:qK\u000e$8\u000fU1si&$\u0018n\u001c8t\u001fJ$WM]!oINK'0\u001a'j[&$8\u000fK\u0002\f\u0003#\u0002B!a\u0015\u0002Z5\u0011\u0011Q\u000b\u0006\u0004\u0003/\u0012\u0014!\u00026v]&$\u0018\u0002BA.\u0003+\u0012A\u0001V3ti\u00061C/Z:u\r\u0016$8\r\u001b*fcV,7\u000f\u001e,3/&$\bn\u0014<feNL'0\u001a3NKN\u001c\u0018mZ3)\u00071\t\t&A\u0012uKN$h)\u001a;dQJ+\u0017/^3tiZ#t+\u001b;i%\u0016\fGmQ8n[&$H/\u001a3)\u00075\t\t&\u0001\u000fuKN$h)\u001a;dQJ+\u0017/^3tiR{gj\u001c8SKBd\u0017nY1)\u00079\t\t&\u0001\u000euKN$8)\u001e:sK:$X\t]8dQZ\u000bG.\u001b3bi&|g\u000eK\u0002\u0010\u0003#\nq\u0005^3ti\u0012{wO\\\"p]Z,'o]5p]^KG\u000f[\"p]:,7\r^5p]\u001a\u000b\u0017\u000e\\;sK\"\u001a\u0001#!\u0015\u0002mQ,7\u000f\u001e#po:\u001cuN\u001c<feNLwN\u001c$s_6\u0014\u0015\r^2iK\u0012$v.\u00168cCR\u001c\u0007.\u001a3SKN\u0004Xm\u0019;t\u001f\u001a47/\u001a;)\u0007E\t\t&A\u0018uKN$8I]3bi\u0016Len\u0019:f[\u0016tG/\u00197GKR\u001c\u0007nV5uQB\u000b'\u000f^5uS>t7/\u00138FeJ|'\u000fK\u0002\u0013\u0003#\nq\u0003^3tij\u001bF\u000fZ\"p[B\u0014Xm]:fIR{\u0007/[2)\u0007M\t\t&A\ruKN$(l\u0015;e\u0007>l\u0007O]3tg\u0016$'+Z2pe\u0012\u001c\bf\u0001\u000b\u0002R\u00059!/Z2pe\u0012\u001cH\u0003BAC\u0003\u001b\u0003BAY4\u0002\bB!\u0011\u0011HAE\u0013\u0011\tY)a\u000f\u0003\rI+7m\u001c:e\u0011\u001d\ty)\u0006a\u0001\u0003#\u000bQ\u0002]1si&$\u0018n\u001c8ECR\f\u0007CBAJ\u00033\u000b9DD\u0002R\u0003+K1!a&S\u000351U\r^2i%\u0016\u001c\bo\u001c8tK&!\u00111BAN\u0015\r\t9JU\u0001\u0013G\",7m\u001b$fi\u000eD'+Z:q_:\u001cX\rF\u0006F\u0003C\u000b)+!+\u0002,\u00065\u0006BBAR-\u0001\u0007\u0011-\u0001\nfqB,7\r^3e!\u0006\u0014H/\u001b;j_:\u001c\bbBAT-\u0001\u0007\u0011\u0011G\u0001\u000eM\u0016$8\r\u001b*fgB|gn]3\t\u000by3\u0002\u0019\u0001.\t\u000be3\u0002\u0019\u0001.\t\r\u0005=f\u00031\u0001[\u0003]qW/\\'fgN\fw-Z:QKJ\u0004\u0016M\u001d;ji&|g.\u0001\u0007de\u0016\fG/\u001a+pa&\u001c7\u000f\u0006\u0005\u00026\u0006]\u00161XA`!\u00119\u0014O\u001b.\t\r\u0005ev\u00031\u0001[\u0003%qW/\u001c+pa&\u001c7\u000f\u0003\u0004\u0002>^\u0001\rAW\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\t\u0013\u0005\u0005w\u0003%AA\u0002\u0005\r\u0017aB2p]\u001aLwm\u001d\t\u0005oE4d'\u0001\fde\u0016\fG/\u001a+pa&\u001c7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tIM\u000b\u0003\u0002D\u0006m\u0011a\u00039s_\u0012,8-\u001a#bi\u0006$b!a4\u0002X\u0006}\u0007\u0003\u00022h\u0003#\u0004RaKAjmYJ1!!6-\u00059\u0001&o\u001c3vG\u0016\u0014(+Z2pe\u0012Da\u0001Y\rA\u0002\u0005e\u0007\u0003\u00022\u0002\\*L1!!8j\u0005!IE/\u001a:bE2,\u0007BBAX3\u0001\u0007!\f")
public class FetchRequestTest
extends BaseRequestTest {
    private KafkaProducer<String, String> producer = null;

    private KafkaProducer<String, String> producer() {
        return this.producer;
    }

    private void producer_$eq(KafkaProducer<String, String> x$1) {
        this.producer = x$1;
    }

    @Override
    public void tearDown() {
        if (this.producer() != null) {
            this.producer().close();
        }
        super.tearDown();
    }

    private FetchRequest createFetchRequest(int maxResponseBytes, int maxPartitionBytes, Seq<TopicPartition> topicPartitions, scala.collection.immutable.Map<TopicPartition, Object> offsetMap) {
        return (FetchRequest)FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, topicPartitions, offsetMap)).setMaxBytes(maxResponseBytes).build();
    }

    private LinkedHashMap<TopicPartition, FetchRequest.PartitionData> createPartitionMap(int maxPartitionBytes, Seq<TopicPartition> topicPartitions, scala.collection.immutable.Map<TopicPartition, Object> offsetMap) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        topicPartitions.foreach((Function1 & Serializable & scala.Serializable)tp -> partitionMap.put((TopicPartition)tp, new FetchRequest.PartitionData(BoxesRunTime.unboxToLong((Object)offsetMap.getOrElse(tp, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), 0L, maxPartitionBytes, Optional.empty())));
        return partitionMap;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> createPartitionMap$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    private FetchResponse<MemoryRecords> sendFetchRequest(int leaderId, FetchRequest request) {
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.FETCH, this.brokerSocketServer(leaderId), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return FetchResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private void initProducer() {
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        StringSerializer x$2 = new StringSerializer();
        StringSerializer x$3 = new StringSerializer();
        int x$4 = TestUtils$.MODULE$.createProducer$default$2();
        long x$5 = TestUtils$.MODULE$.createProducer$default$3();
        long x$6 = TestUtils$.MODULE$.createProducer$default$4();
        int x$7 = TestUtils$.MODULE$.createProducer$default$5();
        int x$8 = TestUtils$.MODULE$.createProducer$default$6();
        int x$9 = TestUtils$.MODULE$.createProducer$default$7();
        int x$10 = TestUtils$.MODULE$.createProducer$default$8();
        String x$11 = TestUtils$.MODULE$.createProducer$default$9();
        int x$12 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$13 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$14 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$15 = TestUtils$.MODULE$.createProducer$default$13();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$2, x$3));
    }

    @Test
    public void testBrokerRespectsPartitionsOrderAndSizeLimits() {
        this.initProducer();
        int messagesPerPartition = 9;
        int maxResponseBytes = 800;
        int maxPartitionBytes = 190;
        scala.collection.immutable.Map<TopicPartition, Object> topicPartitionToLeader = this.createTopics(5, 6, this.createTopics$default$3());
        Random random = new Random(0);
        Set topicPartitions = topicPartitionToLeader.keySet();
        this.produceData((Iterable<TopicPartition>)topicPartitions, messagesPerPartition);
        int leaderId = ((KafkaServer)this.servers().head()).config().brokerId();
        Vector partitionsForLeader = (Vector)topicPartitionToLeader.toVector().collect((PartialFunction)new scala.Serializable(null, leaderId){
            public static final long serialVersionUID = 0L;
            private final int leaderId$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<TopicPartition, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    TopicPartition tp = (TopicPartition)A1._1();
                    int partitionLeaderId = A1._2$mcI$sp();
                    if (partitionLeaderId == this.leaderId$1) {
                        object = tp;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<TopicPartition, Object> x1) {
                int partitionLeaderId;
                Tuple2<TopicPartition, Object> tuple2 = x1;
                boolean bl = tuple2 != null && (partitionLeaderId = tuple2._2$mcI$sp()) == this.leaderId$1;
                return bl;
            }
            {
                this.leaderId$1 = leaderId$1;
            }
        }, Vector$.MODULE$.canBuildFrom());
        Vector partitionsWithLargeMessages = partitionsForLeader.takeRight(2);
        TopicPartition partitionWithLargeMessage1 = (TopicPartition)partitionsWithLargeMessages.head();
        TopicPartition partitionWithLargeMessage2 = (TopicPartition)partitionsWithLargeMessages.apply(1);
        this.producer().send(new ProducerRecord(partitionWithLargeMessage1.topic(), Predef$.MODULE$.int2Integer(partitionWithLargeMessage1.partition()), (Object)"larger than partition limit", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
        this.producer().send(new ProducerRecord(partitionWithLargeMessage2.topic(), Predef$.MODULE$.int2Integer(partitionWithLargeMessage2.partition()), (Object)"larger than response limit", (Object)new String(new byte[maxResponseBytes + 1]))).get();
        Vector partitionsWithoutLargeMessages = (Vector)partitionsForLeader.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)partitionsWithLargeMessages.contains(elem)));
        Vector shuffledTopicPartitions1 = (Vector)((Vector)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)partitionsWithLargeMessages, Vector$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest1 = this.createFetchRequest$1((Seq)shuffledTopicPartitions1, FetchRequestTest.createFetchRequest$default$2$1(), maxResponseBytes, maxPartitionBytes);
        FetchResponse<MemoryRecords> fetchResponse1 = this.sendFetchRequest(leaderId, fetchRequest1);
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions1, fetchResponse1, maxPartitionBytes, maxResponseBytes, messagesPerPartition);
        Vector shuffledTopicPartitions2 = (Vector)((Vector)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)partitionsWithLargeMessages, Vector$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest2 = this.createFetchRequest$1((Seq)shuffledTopicPartitions2, FetchRequestTest.createFetchRequest$default$2$1(), maxResponseBytes, maxPartitionBytes);
        FetchResponse<MemoryRecords> fetchResponse2 = this.sendFetchRequest(leaderId, fetchRequest2);
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions2, fetchResponse2, maxPartitionBytes, maxResponseBytes, messagesPerPartition);
        Seq shuffledTopicPartitions3 = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partitionWithLargeMessage1, partitionWithLargeMessage2}))).$plus$plus((GenTraversableOnce)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest3 = this.createFetchRequest$1(shuffledTopicPartitions3, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionWithLargeMessage1), (Object)BoxesRunTime.boxToLong((long)messagesPerPartition))})), maxResponseBytes, maxPartitionBytes);
        FetchResponse<MemoryRecords> fetchResponse3 = this.sendFetchRequest(leaderId, fetchRequest3);
        Assert.assertEquals((Object)shuffledTopicPartitions3, (Object)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(fetchResponse3.responseData().keySet()).asScala()).toSeq());
        int responseSize3 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)fetchResponse3.responseData()).asScala()).values().map((Function1 & Serializable & scala.Serializable)partitionData -> BoxesRunTime.boxToInteger((int)FetchRequestTest.$anonfun$testBrokerRespectsPartitionsOrderAndSizeLimits$2(this, partitionData)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((responseSize3 <= maxResponseBytes ? 1 : 0) != 0);
        FetchResponse.PartitionData partitionData3 = (FetchResponse.PartitionData)fetchResponse3.responseData().get(partitionWithLargeMessage1);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData3.error);
        Assert.assertTrue((partitionData3.highWatermark > 0L ? 1 : 0) != 0);
        int size3 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData3).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.sizeInBytes()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringBuilder(29).append("Expected ").append(size3).append(" to be smaller than ").append(maxResponseBytes).toString(), (size3 <= maxResponseBytes ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringBuilder(28).append("Expected ").append(size3).append(" to be larger than ").append(maxPartitionBytes).toString(), (size3 > maxPartitionBytes ? 1 : 0) != 0);
        Assert.assertTrue((maxPartitionBytes < ((MemoryRecords)partitionData3.records).sizeInBytes() ? 1 : 0) != 0);
        Seq shuffledTopicPartitions4 = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partitionWithLargeMessage2, partitionWithLargeMessage1}))).$plus$plus((GenTraversableOnce)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest4 = this.createFetchRequest$1(shuffledTopicPartitions4, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionWithLargeMessage2), (Object)BoxesRunTime.boxToLong((long)messagesPerPartition))})), maxResponseBytes, maxPartitionBytes);
        FetchResponse<MemoryRecords> fetchResponse4 = this.sendFetchRequest(leaderId, fetchRequest4);
        Assert.assertEquals((Object)shuffledTopicPartitions4, (Object)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(fetchResponse4.responseData().keySet()).asScala()).toSeq());
        Seq nonEmptyPartitions4 = (Seq)((scala.collection.mutable.MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)fetchResponse4.responseData()).asScala()).toSeq().collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<TopicPartition, FetchResponse.PartitionData<MemoryRecords>>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 != null) {
                    TopicPartition tp = (TopicPartition)A1._1();
                    FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)A1._2();
                    if (BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.$outer.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)$anonfun$2.$anonfun$applyOrElse$1(x$3)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0) {
                        object = tp;
                        return (B1)object;
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<TopicPartition, FetchResponse.PartitionData<MemoryRecords>> x2) {
                FetchResponse.PartitionData partitionData;
                Tuple2<TopicPartition, FetchResponse.PartitionData<MemoryRecords>> tuple2 = x2;
                boolean bl = tuple2 != null && BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.$outer.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)(partitionData = (FetchResponse.PartitionData)tuple2._2())).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)$anonfun$2.$anonfun$isDefinedAt$1(x$3)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0;
                return bl;
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$1(Record x$3) {
                return x$3.sizeInBytes();
            }

            public static final /* synthetic */ int $anonfun$isDefinedAt$1(Record x$3) {
                return x$3.sizeInBytes();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.kafka.common.record.Record ), $anonfun$isDefinedAt$1$adapted(org.apache.kafka.common.record.Record )}, serializedLambda);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partitionWithLargeMessage2})), (Object)nonEmptyPartitions4);
        FetchResponse.PartitionData partitionData4 = (FetchResponse.PartitionData)fetchResponse4.responseData().get(partitionWithLargeMessage2);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData4.error);
        Assert.assertTrue((partitionData4.highWatermark > 0L ? 1 : 0) != 0);
        int size4 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData4).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.sizeInBytes()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringBuilder(28).append("Expected ").append(size4).append(" to be larger than ").append(maxResponseBytes).toString(), (size4 > maxResponseBytes ? 1 : 0) != 0);
        Assert.assertTrue((maxResponseBytes < ((MemoryRecords)partitionData4.records).sizeInBytes() ? 1 : 0) != 0);
    }

    @Test
    public void testFetchRequestV2WithOversizedMessage() {
        this.initProducer();
        int maxPartitionBytes = 200;
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, this.createTopics$default$3()).head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int leaderId = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
        Tuple2 tuple23 = tuple22;
        TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
        int leaderId2 = tuple23._2$mcI$sp();
        this.producer().send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
        FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), this.createPartitionMap$default$3())).build((short)2);
        FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(leaderId2, fetchRequest);
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition2);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
        Assert.assertTrue((partitionData.highWatermark > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)maxPartitionBytes, (long)((MemoryRecords)partitionData.records).sizeInBytes());
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.sizeInBytes()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
    }

    @Test
    public void testFetchRequestV4WithReadCommitted() {
        this.initProducer();
        int maxPartitionBytes = 200;
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, this.createTopics$default$3()).head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int leaderId = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
        Tuple2 tuple23 = tuple22;
        TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
        int leaderId2 = tuple23._2$mcI$sp();
        this.producer().send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
        FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), this.createPartitionMap$default$3())).isolationLevel(IsolationLevel.READ_COMMITTED).build((short)4);
        FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(leaderId2, fetchRequest);
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition2);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
        Assert.assertTrue((partitionData.lastStableOffset > 0L ? 1 : 0) != 0);
        Assert.assertTrue((BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.sizeInBytes()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFetchRequestToNonReplica() {
        String topic = "topic";
        int partition = 0;
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        Option nonReplicaOpt = this.servers().find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)FetchRequestTest.$anonfun$testFetchRequestToNonReplica$1(leader, x$9)));
        Assert.assertTrue((boolean)nonReplicaOpt.isDefined());
        int nonReplicaId = ((KafkaServer)nonReplicaOpt.get()).config().brokerId();
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(1024, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), this.createPartitionMap$default$3())).build();
        FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(nonReplicaId, fetchRequest);
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition);
        Assert.assertEquals((Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)partitionData.error);
    }

    @Test
    public void testCurrentEpochValidation() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange((Seq<KafkaServer>)this.servers(), topicPartition, firstLeaderId, TestUtils$.MODULE$.awaitLeaderChange$default$4());
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaServer>)this.servers());
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition);
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaServer>)this.servers());
        this.assertResponseErrorForEpoch$1(Errors.NOT_LEADER_FOR_PARTITION, followerId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NOT_LEADER_FOR_PARTITION, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition);
    }

    @Test
    public void testDownConversionWithConnectionFailure() {
        IndexedSeq indexedSeq;
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, this.createTopics$default$3()).head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int leaderId = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
        Tuple2 tuple23 = tuple22;
        TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
        int leaderId2 = tuple23._2$mcI$sp();
        int msgValueLen = 100000;
        int batchSize = 4 * msgValueLen;
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$2 = Integer.MAX_VALUE;
        int x$3 = batchSize;
        StringSerializer x$4 = new StringSerializer();
        ByteArraySerializer x$5 = new ByteArraySerializer();
        int x$6 = TestUtils$.MODULE$.createProducer$default$2();
        long x$7 = TestUtils$.MODULE$.createProducer$default$3();
        long x$8 = TestUtils$.MODULE$.createProducer$default$4();
        int x$9 = TestUtils$.MODULE$.createProducer$default$5();
        int x$10 = TestUtils$.MODULE$.createProducer$default$6();
        String x$112 = TestUtils$.MODULE$.createProducer$default$9();
        int x$122 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$132 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$14 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$15 = TestUtils$.MODULE$.createProducer$default$13();
        byte[] bytes = new byte[msgValueLen];
        try (KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$1, x$6, x$7, x$8, x$9, x$10, x$2, x$3, x$112, x$122, x$132, x$14, x$15, x$4, x$5);){
            indexedSeq = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1000).map((Function1 & Serializable & scala.Serializable)x$11 -> producer.send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key", (Object)bytes)), IndexedSeq$.MODULE$.canBuildFrom());
        }
        IndexedSeq futures = indexedSeq;
        futures.foreach((Function1 & Serializable & scala.Serializable)x$12 -> (RecordMetadata)x$12.get());
        short version = (short)1;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 15).foreach((Function1 & Serializable & scala.Serializable)x$13 -> this.fetch$1(version, msgValueLen * 1000, true, topicPartition2, leaderId2, batchSize));
        Option response = this.fetch$1(version, batchSize, false, topicPartition2, leaderId2, batchSize);
        FetchResponse fetchResponse = (FetchResponse)response.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("No fetch response");
        });
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition2);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
        Buffer batches = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((MemoryRecords)partitionData.records).batches()).asScala()).toBuffer();
        Assert.assertEquals((long)3L, (long)batches.size());
    }

    @Test
    public void testDownConversionFromBatchedToUnbatchedRespectsOffset() {
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$2 = 5;
        StringSerializer x$3 = new StringSerializer();
        StringSerializer x$4 = new StringSerializer();
        int x$5 = 30000;
        int x$6 = 60000;
        int x$7 = TestUtils$.MODULE$.createProducer$default$2();
        long x$8 = TestUtils$.MODULE$.createProducer$default$3();
        long x$9 = TestUtils$.MODULE$.createProducer$default$4();
        int x$10 = TestUtils$.MODULE$.createProducer$default$8();
        String x$11 = TestUtils$.MODULE$.createProducer$default$9();
        int x$12 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$13 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$14 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$152 = TestUtils$.MODULE$.createProducer$default$13();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(x$1, x$7, x$8, x$9, x$2, x$6, x$5, x$10, x$11, x$12, x$13, x$14, x$152, x$3, x$4));
        scala.collection.immutable.Map topicConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageFormatVersionProp()), (Object)KAFKA_0_11_0_IV2$.MODULE$.version())}));
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, (scala.collection.immutable.Map<String, String>)topicConfig).head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int leaderId = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
        Tuple2 tuple23 = tuple22;
        TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
        int leaderId2 = tuple23._2$mcI$sp();
        String topic = topicPartition2.topic();
        IndexedSeq firstBatchFutures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable & scala.Serializable)i -> FetchRequestTest.$anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$1(this, topic, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.producer().flush();
        IndexedSeq secondBatchFutures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(10), 25).map((Function1 & Serializable & scala.Serializable)i -> FetchRequestTest.$anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$2(this, topic, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.producer().flush();
        firstBatchFutures.foreach((Function1 & Serializable & scala.Serializable)x$15 -> (RecordMetadata)x$15.get());
        secondBatchFutures.foreach((Function1 & Serializable & scala.Serializable)x$16 -> (RecordMetadata)x$16.get());
        long x$162 = 3L;
        long x$17 = 3L;
        short x$18 = 1;
        int x$19 = 22;
        byte x$20 = 0;
        this.check$1(x$162, x$18, x$17, x$19, x$20, topicPartition2, leaderId2);
        long x$21 = 15L;
        long x$22 = 15L;
        short x$23 = 1;
        int x$24 = 10;
        byte x$25 = 0;
        this.check$1(x$21, x$23, x$22, x$24, x$25, topicPartition2, leaderId2);
        long x$26 = 3L;
        long x$27 = 3L;
        short x$28 = 3;
        int x$29 = 22;
        byte x$30 = 1;
        this.check$1(x$26, x$28, x$27, x$29, x$30, topicPartition2, leaderId2);
        long x$31 = 15L;
        long x$32 = 15L;
        short x$33 = 3;
        int x$34 = 10;
        byte x$35 = 1;
        this.check$1(x$31, x$33, x$32, x$34, x$35, topicPartition2, leaderId2);
        long x$36 = 3L;
        long x$37 = 0L;
        short x$38 = 4;
        int x$39 = 2;
        byte x$40 = 2;
        this.check$1(x$36, x$38, x$37, x$39, x$40, topicPartition2, leaderId2);
        long x$41 = 15L;
        long x$42 = 10L;
        short x$43 = 4;
        int x$44 = 1;
        byte x$45 = 2;
        this.check$1(x$41, x$43, x$42, x$44, x$45, topicPartition2, leaderId2);
        long x$46 = 10L;
        long x$47 = 10L;
        short x$48 = 4;
        int x$49 = 1;
        byte x$50 = 2;
        this.check$1(x$46, x$48, x$47, x$49, x$50, topicPartition2, leaderId2);
    }

    @Test
    public void testCreateIncrementalFetchWithPartitionsInError() {
        TopicPartition foo0 = new TopicPartition("foo", 0);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        this.createTopic("foo", (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2})))}))));
        TopicPartition bar0 = new TopicPartition("bar", 0);
        FetchRequest req1 = this.createFetchRequest$2((Seq)new .colon.colon((Object)foo0, (List)new .colon.colon((Object)foo1, (List)new .colon.colon((Object)bar0, (List)Nil$.MODULE$))), FetchMetadata.INITIAL, (Seq)Nil$.MODULE$);
        FetchResponse<MemoryRecords> resp1 = this.sendFetchRequest(0, req1);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assert.assertTrue((String)"Expected the broker to create a new incremental fetch session", (resp1.sessionId() > 0 ? 1 : 0) != 0);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Test created an incremental fetch session ").append(resp1.sessionId()).toString());
        Assert.assertTrue((boolean)resp1.responseData().containsKey(foo0));
        Assert.assertTrue((boolean)resp1.responseData().containsKey(foo1));
        Assert.assertTrue((boolean)resp1.responseData().containsKey(bar0));
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchResponse.PartitionData)resp1.responseData().get((Object)foo0)).error);
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchResponse.PartitionData)resp1.responseData().get((Object)foo1)).error);
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)((FetchResponse.PartitionData)resp1.responseData().get((Object)bar0)).error);
        FetchRequest req2 = this.createFetchRequest$2((Seq)Nil$.MODULE$, new FetchMetadata(resp1.sessionId(), 1), (Seq)Nil$.MODULE$);
        FetchResponse<MemoryRecords> resp2 = this.sendFetchRequest(0, req2);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assert.assertEquals((String)"Expected the broker to continue the incremental fetch session", (long)resp1.sessionId(), (long)resp2.sessionId());
        Assert.assertFalse((boolean)resp2.responseData().containsKey(foo0));
        Assert.assertFalse((boolean)resp2.responseData().containsKey(foo1));
        Assert.assertTrue((boolean)resp2.responseData().containsKey(bar0));
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)((FetchResponse.PartitionData)resp2.responseData().get((Object)bar0)).error);
        this.createTopic("bar", (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))));
        FetchRequest req3 = this.createFetchRequest$2((Seq)Nil$.MODULE$, new FetchMetadata(resp1.sessionId(), 2), (Seq)Nil$.MODULE$);
        FetchResponse<MemoryRecords> resp3 = this.sendFetchRequest(0, req3);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp3.error());
        Assert.assertFalse((boolean)resp3.responseData().containsKey(foo0));
        Assert.assertFalse((boolean)resp3.responseData().containsKey(foo1));
        Assert.assertTrue((boolean)resp3.responseData().containsKey(bar0));
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchResponse.PartitionData)resp3.responseData().get((Object)bar0)).error);
        FetchRequest req4 = this.createFetchRequest$2((Seq)Nil$.MODULE$, new FetchMetadata(resp1.sessionId(), 3), (Seq)Nil$.MODULE$);
        FetchResponse<MemoryRecords> resp4 = this.sendFetchRequest(0, req4);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp4.error());
        Assert.assertFalse((boolean)resp4.responseData().containsKey(foo0));
        Assert.assertFalse((boolean)resp4.responseData().containsKey(foo1));
        Assert.assertFalse((boolean)resp4.responseData().containsKey(bar0));
    }

    @Test
    public void testZStdCompressedTopic() {
        scala.collection.immutable.Map topicConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CompressionTypeProp()), (Object)ZStdCompressionCodec$.MODULE$.name())}));
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, (scala.collection.immutable.Map<String, String>)topicConfig).head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int leaderId = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
        Tuple2 tuple23 = tuple22;
        TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
        int leaderId2 = tuple23._2$mcI$sp();
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        StringSerializer x$2 = new StringSerializer();
        StringSerializer x$3 = new StringSerializer();
        int x$4 = TestUtils$.MODULE$.createProducer$default$2();
        long x$5 = TestUtils$.MODULE$.createProducer$default$3();
        long x$6 = TestUtils$.MODULE$.createProducer$default$4();
        int x$7 = TestUtils$.MODULE$.createProducer$default$5();
        int x$8 = TestUtils$.MODULE$.createProducer$default$6();
        int x$9 = TestUtils$.MODULE$.createProducer$default$7();
        int x$10 = TestUtils$.MODULE$.createProducer$default$8();
        String x$11 = TestUtils$.MODULE$.createProducer$default$9();
        int x$12 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$13 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$14 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$15 = TestUtils$.MODULE$.createProducer$default$13();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$2, x$3));
        this.producer().send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key1", (Object)"value1")).get();
        this.producer().send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key2", (Object)"value2")).get();
        this.producer().send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key3", (Object)"value3")).get();
        this.producer().close();
        FetchRequest req0 = (FetchRequest)new FetchRequest.Builder(0, 9, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
        FetchResponse<MemoryRecords> res0 = this.sendFetchRequest(leaderId2, req0);
        FetchResponse.PartitionData data0 = (FetchResponse.PartitionData)res0.responseData().get(topicPartition2);
        Assert.assertEquals((Object)Errors.UNSUPPORTED_COMPRESSION_TYPE, (Object)data0.error);
        FetchRequest req1 = (FetchRequest)new FetchRequest.Builder(0, 10, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
        FetchResponse<MemoryRecords> res1 = this.sendFetchRequest(leaderId2, req1);
        FetchResponse.PartitionData data1 = (FetchResponse.PartitionData)res1.responseData().get(topicPartition2);
        Assert.assertEquals((Object)Errors.NONE, (Object)data1.error);
        Assert.assertEquals((long)3L, (long)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)data1).size());
    }

    @Test
    public void testZStdCompressedRecords() {
        scala.collection.immutable.Map topicConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CompressionTypeProp()), (Object)ProducerCompressionCodec$.MODULE$.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageFormatVersionProp()), (Object)"2.0.0")}));
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, (scala.collection.immutable.Map<String, String>)topicConfig).head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int leaderId = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToInteger((int)leaderId));
        Tuple2 tuple23 = tuple22;
        TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
        int leaderId2 = tuple23._2$mcI$sp();
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        String x$2 = GZIPCompressionCodec$.MODULE$.name();
        StringSerializer x$3 = new StringSerializer();
        StringSerializer x$4 = new StringSerializer();
        int x$5 = TestUtils$.MODULE$.createProducer$default$2();
        long x$6 = TestUtils$.MODULE$.createProducer$default$3();
        long x$7 = TestUtils$.MODULE$.createProducer$default$4();
        int x$8 = TestUtils$.MODULE$.createProducer$default$5();
        int x$9 = TestUtils$.MODULE$.createProducer$default$6();
        int x$10 = TestUtils$.MODULE$.createProducer$default$7();
        int x$11 = TestUtils$.MODULE$.createProducer$default$8();
        int x$12 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$13 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$14 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$15 = TestUtils$.MODULE$.createProducer$default$13();
        KafkaProducer producer1 = TestUtils$.MODULE$.createProducer(x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$2, x$12, x$13, x$14, x$15, x$3, x$4);
        producer1.send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key1", (Object)"value1")).get();
        producer1.close();
        String x$16 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        String x$17 = ZStdCompressionCodec$.MODULE$.name();
        StringSerializer x$18 = new StringSerializer();
        StringSerializer x$19 = new StringSerializer();
        int x$20 = TestUtils$.MODULE$.createProducer$default$2();
        long x$21 = TestUtils$.MODULE$.createProducer$default$3();
        long x$22 = TestUtils$.MODULE$.createProducer$default$4();
        int x$23 = TestUtils$.MODULE$.createProducer$default$5();
        int x$24 = TestUtils$.MODULE$.createProducer$default$6();
        int x$25 = TestUtils$.MODULE$.createProducer$default$7();
        int x$26 = TestUtils$.MODULE$.createProducer$default$8();
        int x$27 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$28 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$29 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$30 = TestUtils$.MODULE$.createProducer$default$13();
        KafkaProducer producer2 = TestUtils$.MODULE$.createProducer(x$16, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$17, x$27, x$28, x$29, x$30, x$18, x$19);
        producer2.send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key2", (Object)"value2")).get();
        producer2.send(new ProducerRecord(topicPartition2.topic(), Predef$.MODULE$.int2Integer(topicPartition2.partition()), (Object)"key3", (Object)"value3")).get();
        producer2.close();
        FetchRequest req0 = (FetchRequest)new FetchRequest.Builder(0, 1, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
        FetchResponse<MemoryRecords> res0 = this.sendFetchRequest(leaderId2, req0);
        FetchResponse.PartitionData data0 = (FetchResponse.PartitionData)res0.responseData().get(topicPartition2);
        Assert.assertEquals((Object)Errors.NONE, (Object)data0.error);
        Assert.assertEquals((long)1L, (long)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)data0).size());
        FetchRequest req1 = (FetchRequest)new FetchRequest.Builder(0, 1, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition2), (Object)BoxesRunTime.boxToLong((long)1L))}))))).setMaxBytes(800).build();
        FetchResponse<MemoryRecords> res1 = this.sendFetchRequest(leaderId2, req1);
        FetchResponse.PartitionData data1 = (FetchResponse.PartitionData)res1.responseData().get(topicPartition2);
        Assert.assertEquals((Object)Errors.UNSUPPORTED_COMPRESSION_TYPE, (Object)data1.error);
        FetchRequest req2 = (FetchRequest)new FetchRequest.Builder(2, 3, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
        FetchResponse<MemoryRecords> res2 = this.sendFetchRequest(leaderId2, req2);
        FetchResponse.PartitionData data2 = (FetchResponse.PartitionData)res2.responseData().get(topicPartition2);
        Assert.assertEquals((Object)Errors.NONE, (Object)data2.error);
        Assert.assertEquals((long)1L, (long)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)data2).size());
        FetchRequest req3 = (FetchRequest)new FetchRequest.Builder(0, 1, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition2), (Object)BoxesRunTime.boxToLong((long)1L))}))))).setMaxBytes(800).build();
        FetchResponse<MemoryRecords> res3 = this.sendFetchRequest(leaderId2, req3);
        FetchResponse.PartitionData data3 = (FetchResponse.PartitionData)res3.responseData().get(topicPartition2);
        Assert.assertEquals((Object)Errors.UNSUPPORTED_COMPRESSION_TYPE, (Object)data3.error);
        FetchRequest req4 = (FetchRequest)new FetchRequest.Builder(0, 10, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition2}))), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
        FetchResponse<MemoryRecords> res4 = this.sendFetchRequest(leaderId2, req4);
        FetchResponse.PartitionData data4 = (FetchResponse.PartitionData)res4.responseData().get(topicPartition2);
        Assert.assertEquals((Object)Errors.NONE, (Object)data4.error);
        Assert.assertEquals((long)3L, (long)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)data4).size());
    }

    public Seq<Record> kafka$server$FetchRequestTest$$records(FetchResponse.PartitionData<MemoryRecords> partitionData) {
        return ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((AbstractRecords)partitionData.records).records()).asScala()).toIndexedSeq();
    }

    private void checkFetchResponse(Seq<TopicPartition> expectedPartitions, FetchResponse<MemoryRecords> fetchResponse, int maxPartitionBytes, int maxResponseBytes, int numMessagesPerPartition) {
        Assert.assertEquals(expectedPartitions, (Object)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(fetchResponse.responseData().keySet()).asScala()).toSeq());
        BooleanRef emptyResponseSeen = BooleanRef.create((boolean)false);
        IntRef responseSize = IntRef.create((int)0);
        IntRef responseBufferSize = IntRef.create((int)0);
        expectedPartitions.foreach((Function1 & Serializable & scala.Serializable)tp -> {
            FetchRequestTest.$anonfun$checkFetchResponse$1(this, fetchResponse, responseBufferSize, numMessagesPerPartition, responseSize, emptyResponseSeen, maxPartitionBytes, tp);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)(maxResponseBytes - maxResponseBytes % maxPartitionBytes), (long)responseBufferSize.elem);
        Assert.assertTrue((responseSize.elem <= maxResponseBytes ? 1 : 0) != 0);
    }

    private scala.collection.immutable.Map<TopicPartition, Object> createTopics(int numTopics, int numPartitions, scala.collection.immutable.Map<String, String> configs) {
        IndexedSeq topics = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTopics).map((Function1 & Serializable & scala.Serializable)t -> FetchRequestTest.$anonfun$createTopics$1(BoxesRunTime.unboxToInt((Object)t)), IndexedSeq$.MODULE$.canBuildFrom());
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        configs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Object object = topicConfig.setProperty(k, v);
            return object;
        });
        return ((TraversableOnce)topics.flatMap((Function1 & Serializable & scala.Serializable)topic -> {
            scala.collection.immutable.Map<Object, Object> partitionToLeader = this.createTopic((String)topic, numPartitions, 2, topicConfig);
            return (scala.collection.immutable.Map)partitionToLeader.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int partition = tuple2._1$mcI$sp();
                int leader = tuple2._2$mcI$sp();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, partition)), (Object)BoxesRunTime.boxToInteger((int)leader));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
        }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private scala.collection.immutable.Map<String, String> createTopics$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    /*
     * WARNING - void declaration
     */
    private Seq<ProducerRecord<String, String>> produceData(Iterable<TopicPartition> topicPartitions, int numMessagesPerPartition) {
        void var3_3;
        Seq records = (Seq)topicPartitions.toSeq().flatMap((Function1 & Serializable & scala.Serializable)tp -> (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessagesPerPartition).map((Function1 & Serializable & scala.Serializable)messageIndex -> FetchRequestTest.$anonfun$produceData$2(tp, BoxesRunTime.unboxToInt((Object)messageIndex)), IndexedSeq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        records.map((Function1 & Serializable & scala.Serializable)x$20 -> (RecordMetadata)this.producer().send(x$20).get(), Seq$.MODULE$.canBuildFrom());
        return var3_3;
    }

    private final FetchRequest createFetchRequest$1(Seq topicPartitions, scala.collection.immutable.Map offsetMap, int maxResponseBytes$1, int maxPartitionBytes$2) {
        return this.createFetchRequest(maxResponseBytes$1, maxPartitionBytes$2, (Seq<TopicPartition>)topicPartitions, (scala.collection.immutable.Map<TopicPartition, Object>)offsetMap);
    }

    private static final scala.collection.immutable.Map createFetchRequest$default$2$1() {
        return Predef$.MODULE$.Map().empty();
    }

    public static final /* synthetic */ int $anonfun$testBrokerRespectsPartitionsOrderAndSizeLimits$2(FetchRequestTest $this, FetchResponse.PartitionData partitionData) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)$this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.sizeInBytes()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRequestToNonReplica$1(int leader$1, KafkaServer x$9) {
        return x$9.config().brokerId() != leader$1;
    }

    private final void assertResponseErrorForEpoch$1(Errors error, int brokerId, Optional leaderEpoch, TopicPartition topicPartition$1) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitionMap.put(topicPartition$1, new FetchRequest.PartitionData(0L, 0L, 1024, leaderEpoch));
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)0, (int)1, partitionMap).build();
        FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(brokerId, fetchRequest);
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition$1);
        Assert.assertEquals((Object)error, (Object)partitionData.error);
    }

    private final Option fetch$1(short version, int maxPartitionBytes, boolean closeAfterPartialResponse, TopicPartition topicPartition$2, int leaderId$2, int batchSize$1) {
        Some some;
        FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition$2}))), this.createPartitionMap$default$3())).build(version);
        try (Socket socket = this.connect(this.brokerSocketServer(leaderId$2), this.connect$default$2());){
            this.send((AbstractRequest)fetchRequest, ApiKeys.FETCH, socket, this.send$default$4());
            if (closeAfterPartialResponse) {
                int size = new DataInputStream(socket.getInputStream()).readInt();
                Assert.assertTrue((String)new StringBuilder(56).append("Fetch size too small ").append(size).append(", broker may have run out of memory").toString(), (size > maxPartitionBytes - batchSize$1 ? 1 : 0) != 0);
                some = None$.MODULE$;
            } else {
                some = new Some((Object)FetchResponse.parse((ByteBuffer)this.receive(socket), (short)version));
            }
        }
        return some;
    }

    public static final /* synthetic */ Future $anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$1(FetchRequestTest $this, String topic$1, int i) {
        return $this.producer().send(new ProducerRecord(topic$1, (Object)new StringBuilder(4).append("key-").append(i).toString(), (Object)new StringBuilder(6).append("value-").append(i).toString()));
    }

    public static final /* synthetic */ Future $anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$2(FetchRequestTest $this, String topic$1, int i) {
        return $this.producer().send(new ProducerRecord(topic$1, (Object)new StringBuilder(4).append("key-").append(i).toString(), (Object)new StringBuilder(6).append("value-").append(i).toString()));
    }

    private final void check$1(long fetchOffset, short requestVersion, long expectedOffset, int expectedNumBatches, byte expectedMagic, TopicPartition topicPartition$3, int leaderId$3) {
        int batchesReceived;
        Buffer batches;
        long currentFetchOffset = fetchOffset;
        long currentExpectedOffset = expectedOffset;
        for (batchesReceived = 0; batchesReceived < expectedNumBatches; batchesReceived += batches.size()) {
            FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(Integer.MAX_VALUE, (Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition$3}))), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition$3), (Object)BoxesRunTime.boxToLong((long)currentFetchOffset))}))))).build(requestVersion);
            FetchResponse<MemoryRecords> fetchResponse = this.sendFetchRequest(leaderId$3, fetchRequest);
            FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse.responseData().get(topicPartition$3);
            Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
            Assert.assertTrue((partitionData.highWatermark > 0L ? 1 : 0) != 0);
            batches = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((MemoryRecords)partitionData.records).batches()).asScala()).toBuffer();
            MutableRecordBatch batch = (MutableRecordBatch)batches.head();
            Assert.assertEquals((long)expectedMagic, (long)batch.magic());
            Assert.assertEquals((long)currentExpectedOffset, (long)batch.baseOffset());
            currentFetchOffset = ((RecordBatch)batches.last()).lastOffset() + 1L;
            currentExpectedOffset += ((RecordBatch)batches.last()).lastOffset() - ((RecordBatch)batches.head()).baseOffset() + 1L;
        }
        Assert.assertEquals((long)expectedNumBatches, (long)batchesReceived);
    }

    private final FetchRequest createFetchRequest$2(Seq topicPartitions, FetchMetadata metadata, Seq toForget) {
        return (FetchRequest)FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(Integer.MAX_VALUE, (Seq<TopicPartition>)topicPartitions, (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).toForget((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(toForget).asJava()).metadata(metadata).build();
    }

    public static final /* synthetic */ void $anonfun$checkFetchResponse$1(FetchRequestTest $this, FetchResponse fetchResponse$1, IntRef responseBufferSize$1, int numMessagesPerPartition$1, IntRef responseSize$1, BooleanRef emptyResponseSeen$1, int maxPartitionBytes$3, TopicPartition tp) {
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse$1.responseData().get(tp);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
        Assert.assertTrue((partitionData.highWatermark > 0L ? 1 : 0) != 0);
        MemoryRecords records = (MemoryRecords)partitionData.records;
        responseBufferSize$1.elem += records.sizeInBytes();
        IndexedSeq batches = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).toIndexedSeq();
        Assert.assertTrue((batches.size() < numMessagesPerPartition$1 ? 1 : 0) != 0);
        int batchesSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)batches.map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToInteger((int)x$19.sizeInBytes()), IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        responseSize$1.elem += batchesSize;
        if (batchesSize == 0 && !emptyResponseSeen$1.elem) {
            Assert.assertEquals((long)0L, (long)records.sizeInBytes());
            emptyResponseSeen$1.elem = true;
        } else if (batchesSize != 0 && !emptyResponseSeen$1.elem) {
            Assert.assertTrue((batchesSize <= maxPartitionBytes$3 ? 1 : 0) != 0);
            Assert.assertEquals((long)maxPartitionBytes$3, (long)records.sizeInBytes());
        } else {
            if (batchesSize != 0 && emptyResponseSeen$1.elem) {
                throw $this.fail(new StringBuilder(53).append("Expected partition with size 0, but found ").append(tp).append(" with size ").append(batchesSize).toString(), new Position("FetchRequestTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 589));
            }
            if (records.sizeInBytes() != 0 && emptyResponseSeen$1.elem) {
                throw $this.fail(new StringBuilder(60).append("Expected partition buffer with size 0, but found ").append(tp).append(" with size ").append(records.sizeInBytes()).toString(), new Position("FetchRequestTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 591));
            }
        }
    }

    public static final /* synthetic */ String $anonfun$createTopics$1(int t) {
        return new StringBuilder(5).append("topic").append(t).toString();
    }

    public static final /* synthetic */ ProducerRecord $anonfun$produceData$2(TopicPartition tp$1, int messageIndex) {
        String suffix = new StringBuilder(1).append(tp$1).append("-").append(messageIndex).toString();
        return new ProducerRecord(tp$1.topic(), Predef$.MODULE$.int2Integer(tp$1.partition()), (Object)new StringBuilder(4).append("key ").append(suffix).toString(), (Object)new StringBuilder(6).append("value ").append(suffix).toString());
    }
}

