/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_0_10_2_IV0$;
import kafka.controller.KafkaController;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.network.RequestChannel;
import kafka.security.auth.Authorizer;
import kafka.server.AdminManager;
import kafka.server.BrokerTopicStats;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.FetchManager;
import kafka.server.FetchPartitionData;
import kafka.server.FetchSessionCache;
import kafka.server.FullFetchContext;
import kafka.server.KafkaApis;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicationQuotaManager;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.TxnOffsetCommitRequest;
import org.apache.kafka.common.requests.TxnOffsetCommitResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\r=g\u0001B'O\u0001MCQA\u0017\u0001\u0005\u0002mCqA\u0018\u0001C\u0002\u0013%q\f\u0003\u0004g\u0001\u0001\u0006I\u0001\u0019\u0005\bO\u0002\u0011\r\u0011\"\u0003i\u0011\u0019\u0001\b\u0001)A\u0005S\"9\u0011\u000f\u0001b\u0001\n\u0013\u0011\bB\u0002<\u0001A\u0003%1\u000fC\u0004x\u0001\t\u0007I\u0011\u0002=\t\u000f\u0005\r\u0001\u0001)A\u0005s\"I\u0011Q\u0001\u0001C\u0002\u0013%\u0011q\u0001\u0005\t\u0003\u001f\u0001\u0001\u0015!\u0003\u0002\n!I\u0011\u0011\u0003\u0001C\u0002\u0013%\u00111\u0003\u0005\t\u0003C\u0001\u0001\u0015!\u0003\u0002\u0016!I\u00111\u0005\u0001C\u0002\u0013%\u0011Q\u0005\u0005\t\u0003c\u0001\u0001\u0015!\u0003\u0002(!I\u00111\u0007\u0001C\u0002\u0013%\u0011Q\u0007\u0005\t\u0003\u0007\u0002\u0001\u0015!\u0003\u00028!I\u0011Q\t\u0001C\u0002\u0013%\u0011q\t\u0005\t\u0003?\u0002\u0001\u0015!\u0003\u0002J!I\u0011\u0011\r\u0001C\u0002\u0013%\u00111\r\u0005\t\u0003W\u0002\u0001\u0015!\u0003\u0002f!I\u0011Q\u000e\u0001C\u0002\u0013%\u0011q\u000e\u0005\t\u0003o\u0002\u0001\u0015!\u0003\u0002r!I\u0011\u0011\u0010\u0001C\u0002\u0013%\u00111\u0010\u0005\t\u0003'\u0003\u0001\u0015!\u0003\u0002~!I\u0011Q\u0013\u0001C\u0002\u0013%\u0011q\u0013\u0005\t\u0003?\u0003\u0001\u0015!\u0003\u0002\u001a\"I\u0011\u0011\u0015\u0001C\u0002\u0013%\u00111\u0015\u0005\t\u0003W\u0003\u0001\u0015!\u0003\u0002&\"I\u0011Q\u0016\u0001C\u0002\u0013%\u0011q\u0016\u0005\t\u0003o\u0003\u0001\u0015!\u0003\u00022\"I\u0011\u0011\u0018\u0001C\u0002\u0013%\u00111\u0018\u0005\t\u00033\u0004\u0001\u0015!\u0003\u0002>\"I\u00111\u001c\u0001C\u0002\u0013%\u0011Q\u001c\u0005\t\u0003K\u0004\u0001\u0015!\u0003\u0002`\"I\u0011q\u001d\u0001C\u0002\u0013%\u0011\u0011\u001e\u0005\t\u0003c\u0004\u0001\u0015!\u0003\u0002l\"I\u00111\u001f\u0001C\u0002\u0013%\u0011Q\u001f\u0005\t\u0005\u000f\u0001\u0001\u0015!\u0003\u0002x\"I!\u0011\u0002\u0001C\u0002\u0013%!1\u0002\u0005\t\u00053\u0001\u0001\u0015!\u0003\u0003\u000e!9!1\u0004\u0001\u0005\u0002\tu\u0001b\u0002B\u001a\u0001\u0011\u0005!Q\u0007\u0005\n\u0005\u001b\u0002\u0011\u0013!C\u0001\u0005\u001fBqA!\u001a\u0001\t\u0003\u0011i\u0002C\u0004\u0003p\u0001!\tA!\b\t\u000f\tM\u0004\u0001\"\u0001\u0003\u001e!9!q\u000f\u0001\u0005\u0002\tu\u0001b\u0002BF\u0001\u0011\u0005!Q\u0004\u0005\b\u0005\u001f\u0003A\u0011\u0001B\u000f\u0011\u001d\u0011\u0019\n\u0001C\u0001\u0005;AqAa&\u0001\t\u0003\u0011i\u0002C\u0004\u0003\u001c\u0002!\tA!\b\t\u000f\t}\u0005\u0001\"\u0001\u0003\u001e!9!1\u0015\u0001\u0005\u0002\tu\u0001b\u0002BT\u0001\u0011\u0005!Q\u0004\u0005\b\u0005W\u0003A\u0011\u0001B\u000f\u0011\u001d\u0011y\u000b\u0001C\u0001\u0005;AqAa-\u0001\t\u0003\u0011i\u0002C\u0004\u00038\u0002!\tA!\b\t\u000f\tm\u0006\u0001\"\u0001\u0003\u001e!9!q\u0018\u0001\u0005\n\t\u0005\u0007b\u0002Bj\u0001\u0011\u0005!Q\u0004\u0005\b\u0005/\u0004A\u0011\u0001B\u000f\u0011\u001d\u0011Y\u000e\u0001C\u0001\u0005;AqAa8\u0001\t\u0003\u0011i\u0002C\u0004\u0003d\u0002!\tA!\b\t\u000f\t\u001d\b\u0001\"\u0003\u0003j\"9!1 \u0001\u0005\n\tu\bbBB\b\u0001\u0011%1\u0011\u0003\u0005\b\u0007;\u0001A\u0011BB\u0010\u0011\u001d\u00199\u0005\u0001C\u0005\u0007\u0013B\u0011ba\u001f\u0001#\u0003%Ia! \t\u000f\r\u0015\u0005\u0001\"\u0003\u0004\b\"91\u0011\u0017\u0001\u0005\n\rM\u0006bBB[\u0001\u0011%1q\u0017\u0002\u000e\u0017\u000647.Y!qSN$Vm\u001d;\u000b\u0005=\u0003\u0016AB:feZ,'OC\u0001R\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001+\u0011\u0005UCV\"\u0001,\u000b\u0003]\u000bQa]2bY\u0006L!!\u0017,\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tA\f\u0005\u0002^\u00015\ta*\u0001\bsKF,Xm\u001d;DQ\u0006tg.\u001a7\u0016\u0003\u0001\u0004\"!\u00193\u000e\u0003\tT!a\u0019)\u0002\u000f9,Go^8sW&\u0011QM\u0019\u0002\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0003=\u0011X-];fgR\u001c\u0005.\u00198oK2\u0004\u0013!\u0006:fcV,7\u000f^\"iC:tW\r\\'fiJL7m]\u000b\u0002SB\u0011!.\u001c\b\u0003C.L!\u0001\u001c2\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&\u0011an\u001c\u0002\b\u001b\u0016$(/[2t\u0015\ta'-\u0001\fsKF,Xm\u001d;DQ\u0006tg.\u001a7NKR\u0014\u0018nY:!\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ,\u0012a\u001d\t\u0003;RL!!\u001e(\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006y!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b%\u0001\the>,\boQ8pe\u0012Lg.\u0019;peV\t\u0011\u0010\u0005\u0002{\u007f6\t1P\u0003\u0002}{\u0006)qM]8va*\u0011a\u0010U\u0001\fG>|'\u000fZ5oCR|'/C\u0002\u0002\u0002m\u0014\u0001c\u0012:pkB\u001cun\u001c:eS:\fGo\u001c:\u0002#\u001d\u0014x.\u001e9D_>\u0014H-\u001b8bi>\u0014\b%\u0001\u0007bI6Lg.T1oC\u001e,'/\u0006\u0002\u0002\nA\u0019Q,a\u0003\n\u0007\u00055aJ\u0001\u0007BI6Lg.T1oC\u001e,'/A\u0007bI6Lg.T1oC\u001e,'\u000fI\u0001\u000fibt7i\\8sI&t\u0017\r^8s+\t\t)\u0002\u0005\u0003\u0002\u0018\u0005uQBAA\r\u0015\r\tY\"`\u0001\fiJ\fgn]1di&|g.\u0003\u0003\u0002 \u0005e!A\u0006+sC:\u001c\u0018m\u0019;j_:\u001cun\u001c:eS:\fGo\u001c:\u0002\u001fQDhnQ8pe\u0012Lg.\u0019;pe\u0002\n!bY8oiJ|G\u000e\\3s+\t\t9\u0003\u0005\u0003\u0002*\u00055RBAA\u0016\u0015\r\t\u0019\u0003U\u0005\u0005\u0003_\tYCA\bLC\u001a\\\u0017mQ8oiJ|G\u000e\\3s\u0003-\u0019wN\u001c;s_2dWM\u001d\u0011\u0002\u0011i\\7\t\\5f]R,\"!a\u000e\u0011\t\u0005e\u0012qH\u0007\u0003\u0003wQ1!!\u0010Q\u0003\tQ8.\u0003\u0003\u0002B\u0005m\"!D&bM.\f'l[\"mS\u0016tG/A\u0005{W\u000ec\u0017.\u001a8uA\u00059Q.\u001a;sS\u000e\u001cXCAA%!\u0011\tY%!\u0018\u000e\u0005\u00055#\u0002BA#\u0003\u001fRA!!\u0015\u0002T\u000511m\\7n_:T1!UA+\u0015\u0011\t9&!\u0017\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\tY&A\u0002pe\u001eL1A\\A'\u0003!iW\r\u001e:jGN\u0004\u0013\u0001\u00032s_.,'/\u00133\u0016\u0005\u0005\u0015\u0004cA+\u0002h%\u0019\u0011\u0011\u000e,\u0003\u0007%sG/A\u0005ce>\\WM]%eA\u0005iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016,\"!!\u001d\u0011\u0007u\u000b\u0019(C\u0002\u0002v9\u0013Q\"T3uC\u0012\fG/Y\"bG\",\u0017AD7fi\u0006$\u0017\r^1DC\u000eDW\rI\u0001\u000bCV$\bn\u001c:ju\u0016\u0014XCAA?!\u0015)\u0016qPAB\u0013\r\t\tI\u0016\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005\u0015\u0015qR\u0007\u0003\u0003\u000fSA!!#\u0002\f\u0006!\u0011-\u001e;i\u0015\r\ti\tU\u0001\tg\u0016\u001cWO]5us&!\u0011\u0011SAD\u0005)\tU\u000f\u001e5pe&TXM]\u0001\fCV$\bn\u001c:ju\u0016\u0014\b%\u0001\ndY&,g\u000e^)v_R\fW*\u00198bO\u0016\u0014XCAAM!\ri\u00161T\u0005\u0004\u0003;s%AE\"mS\u0016tG/U;pi\u0006l\u0015M\\1hKJ\f1c\u00197jK:$\u0018+^8uC6\u000bg.Y4fe\u0002\n\u0011d\u00197jK:$(+Z9vKN$\u0018+^8uC6\u000bg.Y4feV\u0011\u0011Q\u0015\t\u0004;\u0006\u001d\u0016bAAU\u001d\nI2\t\\5f]R\u0014V-];fgR\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0003i\u0019G.[3oiJ+\u0017/^3tiF+x\u000e^1NC:\fw-\u001a:!\u0003M\u0011X\r\u001d7jG\u0006\fVo\u001c;b\u001b\u0006t\u0017mZ3s+\t\t\t\fE\u0002^\u0003gK1!!.O\u0005]\u0011V\r\u001d7jG\u0006$\u0018n\u001c8Rk>$\u0018-T1oC\u001e,'/\u0001\u000bsKBd\u0017nY1Rk>$\u0018-T1oC\u001e,'\u000fI\u0001\u0007cV|G/Y:\u0016\u0005\u0005u\u0006\u0003BA`\u0003'tA!!1\u0002P:!\u00111YAg\u001d\u0011\t)-a3\u000e\u0005\u0005\u001d'bAAe%\u00061AH]8pizJ\u0011!U\u0005\u0003\u001fBK1!!5O\u00031\tVo\u001c;b\r\u0006\u001cGo\u001c:z\u0013\u0011\t).a6\u0003\u001bE+x\u000e^1NC:\fw-\u001a:t\u0015\r\t\tNT\u0001\bcV|G/Y:!\u000311W\r^2i\u001b\u0006t\u0017mZ3s+\t\ty\u000eE\u0002^\u0003CL1!a9O\u000511U\r^2i\u001b\u0006t\u0017mZ3s\u000351W\r^2i\u001b\u0006t\u0017mZ3sA\u0005\u0001\"M]8lKJ$v\u000e]5d'R\fGo]\u000b\u0003\u0003W\u00042!XAw\u0013\r\tyO\u0014\u0002\u0011\u0005J|7.\u001a:U_BL7m\u0015;biN\f\u0011C\u0019:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:!\u0003%\u0019G.^:uKJLE-\u0006\u0002\u0002xB!\u0011\u0011 B\u0002\u001b\t\tYP\u0003\u0003\u0002~\u0006}\u0018\u0001\u00027b]\u001eT!A!\u0001\u0002\t)\fg/Y\u0005\u0005\u0005\u000b\tYP\u0001\u0004TiJLgnZ\u0001\u000bG2,8\u000f^3s\u0013\u0012\u0004\u0013\u0001\u0002;j[\u0016,\"A!\u0004\u0011\t\t=!QC\u0007\u0003\u0005#Q1Aa\u0005Q\u0003\u0015)H/\u001b7t\u0013\u0011\u00119B!\u0005\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\n\u0001\u0002^3be\u0012{wO\u001c\u000b\u0003\u0005?\u00012!\u0016B\u0011\u0013\r\u0011\u0019C\u0016\u0002\u0005+:LG\u000fK\u0002+\u0005O\u0001BA!\u000b\u000305\u0011!1\u0006\u0006\u0005\u0005[\tI&A\u0003kk:LG/\u0003\u0003\u00032\t-\"!B!gi\u0016\u0014\u0018aD2sK\u0006$XmS1gW\u0006\f\u0005/[:\u0015\t\t]\"Q\b\t\u0004;\ne\u0012b\u0001B\u001e\u001d\nI1*\u00194lC\u0006\u0003\u0018n\u001d\u0005\n\u0005\u007fY\u0003\u0013!a\u0001\u0005\u0003\n!$\u001b8uKJ\u0014%o\\6feB\u0013x\u000e^8d_24VM]:j_:\u0004BAa\u0011\u0003J5\u0011!Q\t\u0006\u0004\u0005\u000f\u0002\u0016aA1qS&!!1\nB#\u0005)\t\u0005/\u001b,feNLwN\\\u0001\u001aGJ,\u0017\r^3LC\u001a\\\u0017-\u00119jg\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003R)\"!\u0011\tB*W\t\u0011)\u0006\u0005\u0003\u0003X\t\u0005TB\u0001B-\u0015\u0011\u0011YF!\u0018\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B0-\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\r$\u0011\f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001\n;fgR|eMZ:fi\u000e{W.\\5u/&$\b.\u00138wC2LG\rU1si&$\u0018n\u001c8)\u00075\u0012I\u0007\u0005\u0003\u0003*\t-\u0014\u0002\u0002B7\u0005W\u0011A\u0001V3ti\u00069C/Z:u)btwJ\u001a4tKR\u001cu.\\7ji^KG\u000f[%om\u0006d\u0017\u000e\u001a)beRLG/[8oQ\rq#\u0011N\u0001+i\u0016\u001cH/\u00113e!\u0006\u0014H/\u001b;j_:\u001cHk\u001c+y]^KG\u000f[%om\u0006d\u0017\u000e\u001a)beRLG/[8oQ\ry#\u0011N\u0001gg\"|W\u000f\u001c3UQJ|w/\u00168tkB\u0004xN\u001d;fIZ+'o]5p]\u0016C8-\u001a9uS>twJ\u001c%b]\u0012dW-\u00113e\u001f\u001a47/\u001a;U_RChNU3rk\u0016\u001cHo\u00165f]&sG/\u001a:Ce>\\WM\u001d)s_R|7m\u001c7O_R\u001cV\u000f\u001d9peR,G\rK\u00041\u0005S\u0012YH! \u0002\u0011\u0015D\b/Z2uK\u0012\u001c#Aa \u0011\t\t\u0005%qQ\u0007\u0003\u0005\u0007SAA!\"\u0002P\u00051QM\u001d:peNLAA!#\u0003\u0004\nYRK\\:vaB|'\u000f^3e-\u0016\u00148/[8o\u000bb\u001cW\r\u001d;j_:\f!n\u001d5pk2$G\u000b\u001b:poVs7/\u001e9q_J$X\r\u001a,feNLwN\\#yG\u0016\u0004H/[8o\u001f:D\u0015M\u001c3mK\u0006#G\rU1si&$\u0018n\u001c8t)>$\u0006P\u001c*fcV,7\u000f^,iK:Le\u000e^3s\u0005J|7.\u001a:Qe>$xnY8m\u001d>$8+\u001e9q_J$X\r\u001a\u0015\bc\t%$1\u0010B?\u0003\u001d\u001c\bn\\;mIRC'o\\<V]N,\b\u000f]8si\u0016$g+\u001a:tS>tW\t_2faRLwN\\(o\u0011\u0006tG\r\\3Uq:|eMZ:fi\u000e{W.\\5u%\u0016\fX/Z:u/\",g.\u00138uKJ\u0014%o\\6feB\u0013x\u000e^8d_2tu\u000e^*vaB|'\u000f^3eQ\u001d\u0011$\u0011\u000eB>\u0005{\nal\u001d5pk2$G\u000b\u001b:poVs7/\u001e9q_J$X\r\u001a,feNLwN\\#yG\u0016\u0004H/[8o\u001f:D\u0015M\u001c3mK\u0016sG\r\u0016=o%\u0016\fX/Z:u/\",g.\u00138uKJ\u0014%o\\6feB\u0013x\u000e^8d_2tu\u000e^*vaB|'\u000f^3eQ\u001d\u0019$\u0011\u000eB>\u0005{\nqm\u001d5pk2$G\u000b\u001b:poVs7/\u001e9q_J$X\r\u001a,feNLwN\\#yG\u0016\u0004H/[8o\u001f:D\u0015M\u001c3mK^\u0013\u0018\u000e^3Uq:l\u0015M]6feN\u0014V-];fgR<\u0006.\u001a8J]R,'O\u0011:pW\u0016\u0014\bK]8u_\u000e|GNT8u'V\u0004\bo\u001c:uK\u0012Ds\u0001\u000eB5\u0005w\u0012i(A/tQ>,H\u000e\u001a*fgB|g\u000eZ,ji\",fn];qa>\u0014H/\u001a3G_JlUm]:bO\u00164uN]7bi>s\u0007*\u00198eY\u0016<&/\u001b;f)btW*\u0019:lKJ\u001cx\u000b[3o\u001b\u0006<\u0017n\u0019'po\u0016\u0014H\u000b[1o%\u0016\fX/\u001b:fI\"\u001aQG!\u001b\u0002kMDw.\u001e7e%\u0016\u001c\bo\u001c8e/&$\b.\u00168l]><h\u000eV8qS\u000e<\u0006.\u001a8QCJ$\u0018\u000e^5p]&\u001bhj\u001c;I_N$X\r\u001a\u0015\u0004m\t%\u0014aU:i_VdGMU3ta>tGmV5uQVs7/\u001e9q_J$X\rZ'fgN\fw-\u001a$pe6\fGOR8s\u0005\u0006$\u0007+\u0019:uSRLwN\\!oI:{WI\u001d:peN4uN]$p_\u0012\u0004\u0016M\u001d;ji&|g\u000eK\u00028\u0005S\n!k\u001d5pk2$'+Z:q_:$w+\u001b;i+:\\gn\\<o)>\u0004\u0018nY(s!\u0006\u0014H/\u001b;j_:4uN\u001d\"bIB\u000b'\u000f^5uS>t\u0017I\u001c3O_\u0016\u0013(o\u001c:t\r>\u0014xi\\8e!\u0006\u0014H/\u001b;j_:D3\u0001\u000fB5\u0003e\u001a\bn\\;mI\u0006\u0003\b/\u001a8e)>dunZ(o/JLG/\u001a+y]6\u000b'o[3sg^CWM\\\"peJ,7\r^'bO&\u001cg+\u001a:tS>t\u0007fA\u001d\u0003j\u0005yC/Z:u\u0019\u0016\fG-\u001a:SKBd\u0017nY1JM2{7-\u00197SC&\u001cXm\u001d$f]\u000e,G\rT3bI\u0016\u0014X\t]8dQ\"\u001a!H!\u001b\u0002aQ,7\u000f\u001e'fC\u0012,'OU3qY&\u001c\u0017-\u00134M_\u000e\fGNU1jg\u0016\u001cXK\\6o_^tG*Z1eKJ,\u0005o\\2iQ\rY$\u0011N\u00014i\u0016\u001cH\u000fT3bI\u0016\u0014(+\u001a9mS\u000e\f\u0017J\u001a'pG\u0006d'+Y5tKNtu\u000e\u001e'fC\u0012,'OR8s!\u0006\u0014H/\u001b;j_:D3\u0001\u0010B5\u0003U\"Xm\u001d;MK\u0006$WM\u001d*fa2L7-Y%g\u0019>\u001c\u0017\r\u001c*bSN,7/\u00168l]><h\u000eV8qS\u000e|%\u000fU1si&$\u0018n\u001c8)\u0007u\u0012I'\u0001\u0013uKN$H*[:u\u001f\u001a47/\u001a;GC&dW\rZ$fi2+\u0017\rZ3s%\u0016\u0004H.[2b)\u0011\u0011yBa1\t\u000f\t\u0015g\b1\u0001\u0003H\u0006)QM\u001d:peB!!\u0011\u001aBh\u001b\t\u0011YM\u0003\u0003\u0003N\u0006=\u0013\u0001\u00039s_R|7m\u001c7\n\t\tE'1\u001a\u0002\u0007\u000bJ\u0014xN]:\u0002WQ,7\u000f\u001e*fC\u0012,fnY8n[&$H/\u001a3D_:\u001cX/\\3s\u0019&\u001cHo\u00144gg\u0016$H*\u0019;fgRD3a\u0010B5\u0003%\"Xm\u001d;SK\u0006$7i\\7nSR$X\rZ\"p]N,X.\u001a:MSN$xJ\u001a4tKRd\u0015\r^3ti\"\u001a\u0001I!\u001b\u0002\u0013R,7\u000f^'fi\u0006$\u0017\r^1SKF,Xm\u001d;P]NC\u0017M]3e\u0019&\u001cH/\u001a8fe^KG\u000f[%oG>t7/[:uK:$H*[:uK:,'o]!de>\u001c8O\u0011:pW\u0016\u00148\u000fK\u0002B\u0005S\n1\n^3ti6+G/\u00193bi\u0006\u0014V-];fgR|e\u000eR5ti&t7\r\u001e'jgR,g.\u001a:XSRD\u0017J\\2p]NL7\u000f^3oi2K7\u000f^3oKJ\u001c\u0018i\u0019:pgN\u0014%o\\6feND3A\u0011B5\u0003\u0005\"Xm\u001d;GKR\u001c\u0007NU3rk\u0016\u001cHOV\u001dXSRDgj\u001c'pO\u000e{gNZ5hQ\r\u0019%\u0011N\u0001-kB$\u0017\r^3NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z,ji\"LenY8og&\u001cH/\u001a8u\u0019&\u001cH/\u001a8feN$\"Aa;\u0011\u000fU\u0013iO!=\u0003r&\u0019!q\u001e,\u0003\rQ+\b\u000f\\33!\u0011\u0011\u0019Pa>\u000e\u0005\tU(bA2\u0002P%!!\u0011 B{\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f\u00031\u001aXM\u001c3NKR\fG-\u0019;b%\u0016\fX/Z:u/&$\b.\u00138d_:\u001c\u0018n\u001d;f]Rd\u0015n\u001d;f]\u0016\u00148\u000f\u0006\u0003\u0003\u0000\u000e-\u0001\u0003BB\u0001\u0007\u000fi!aa\u0001\u000b\t\r\u0015\u0011qJ\u0001\te\u0016\fX/Z:ug&!1\u0011BB\u0002\u0005AiU\r^1eCR\f'+Z:q_:\u001cX\rC\u0004\u0004\u000e\u0015\u0003\rA!=\u0002\u001fI,\u0017/^3ti2K7\u000f^3oKJ\fA\u0004^3ti\u000e{gn];nKJd\u0015n\u001d;PM\u001a\u001cX\r\u001e'bi\u0016\u001cH\u000f\u0006\u0003\u0003 \rM\u0001bBB\u000b\r\u0002\u00071qC\u0001\u000fSN|G.\u0019;j_:dUM^3m!\u0011\u0019\ta!\u0007\n\t\rm11\u0001\u0002\u000f\u0013N|G.\u0019;j_:dUM^3m\u0003q\u0019'/Z1uK^\u0013\u0018\u000e^3Uq:l\u0015M]6feN\u0014V-];fgR$Ba!\t\u00040A9QK!<\u0004$\r%\u0002\u0003BB\u0001\u0007KIAaa\n\u0004\u0004\t1rK]5uKRCh.T1sW\u0016\u00148OU3rk\u0016\u001cH\u000fE\u0002k\u0007WI1a!\fp\u0005\u001d\u0011V-];fgRDqa!\rH\u0001\u0004\u0019\u0019$\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004ba!\u000e\u0004<\r}RBAB\u001c\u0015\u0011\u0019I$a@\u0002\tU$\u0018\u000e\\\u0005\u0005\u0007{\u00199D\u0001\u0003MSN$\b\u0003BB!\u0007\u0007j!!a\u0014\n\t\r\u0015\u0013q\n\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u00031\u0011W/\u001b7e%\u0016\fX/Z:u+\u0011\u0019Yea\u0015\u0015\r\r53QMB<!\u001d)&Q^B(\u0007S\u0001Ba!\u0015\u0004T1\u0001AaBB+\u0011\n\u00071q\u000b\u0002\u0002)F!1\u0011LB0!\r)61L\u0005\u0004\u0007;2&a\u0002(pi\"Lgn\u001a\t\u0005\u0007\u0003\u0019\t'\u0003\u0003\u0004d\r\r!aD!cgR\u0014\u0018m\u0019;SKF,Xm\u001d;\t\u000f\r\u001d\u0004\n1\u0001\u0004j\u00059!-^5mI\u0016\u0014\bCBB6\u0007c\u001ayE\u0004\u0003\u0004\u0002\r5\u0014\u0002BB8\u0007\u0007\tq\"\u00112tiJ\f7\r\u001e*fcV,7\u000f^\u0005\u0005\u0007g\u001a)HA\u0004Ck&dG-\u001a:\u000b\t\r=41\u0001\u0005\n\u0007sB\u0005\u0013!a\u0001\u0005c\fA\u0002\\5ti\u0016tWM\u001d(b[\u0016\faCY;jY\u0012\u0014V-];fgR$C-\u001a4bk2$HEM\u000b\u0005\u0007\u007f\u001a\u0019)\u0006\u0002\u0004\u0002*\"!\u0011\u001fB*\t\u001d\u0019)&\u0013b\u0001\u0007/\nAB]3bIJ+7\u000f]8og\u0016$\u0002b!#\u0004\u0010\u000e]51\u0014\t\u0005\u0007\u0003\u0019Y)\u0003\u0003\u0004\u000e\u000e\r!\u0001E!cgR\u0014\u0018m\u0019;SKN\u0004xN\\:f\u0011\u001d\u00119E\u0013a\u0001\u0007#\u0003BA!3\u0004\u0014&!1Q\u0013Bf\u0005\u001d\t\u0005/[&fsNDqa!'K\u0001\u0004\u0019y&A\u0004sKF,Xm\u001d;\t\u000f\ru%\n1\u0001\u0004 \u0006\u00012-\u00199ukJ,GMU3ta>t7/\u001a\t\u0007\u0007C\u001b9ka+\u000e\u0005\r\r&\u0002BBS\u00033\n\u0001\"Z1ts6|7m[\u0005\u0005\u0007S\u001b\u0019KA\u0004DCB$XO]3\u0011\u0007)\u001ci+C\u0002\u00040>\u0014\u0001BU3ta>t7/Z\u0001\u0013Kb\u0004Xm\u0019;O_RC'o\u001c;uY&tw\r\u0006\u0002\u0004 \u000692/\u001a;va\n\u000b7/[2NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u000b\u0007\u0005?\u0019Ila3\t\u000f\rmF\n1\u0001\u0004>\u0006)Ao\u001c9jGB!1qXBd\u001d\u0011\u0019\tma1\u0011\u0007\u0005\u0015g+C\u0002\u0004FZ\u000ba\u0001\u0015:fI\u00164\u0017\u0002\u0002B\u0003\u0007\u0013T1a!2W\u0011\u001d\u0019i\r\u0014a\u0001\u0003K\nQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\b")
public class KafkaApisTest {
    private final RequestChannel requestChannel = (RequestChannel)EasyMock.createNiceMock(RequestChannel.class);
    private final RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)EasyMock.createNiceMock(RequestChannel.Metrics.class);
    private final ReplicaManager replicaManager = (ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class);
    private final GroupCoordinator groupCoordinator = (GroupCoordinator)EasyMock.createNiceMock(GroupCoordinator.class);
    private final AdminManager adminManager = (AdminManager)EasyMock.createNiceMock(AdminManager.class);
    private final TransactionCoordinator txnCoordinator = (TransactionCoordinator)EasyMock.createNiceMock(TransactionCoordinator.class);
    private final KafkaController controller = (KafkaController)EasyMock.createNiceMock(KafkaController.class);
    private final KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
    private final Metrics metrics = new Metrics();
    private final int brokerId;
    private final MetadataCache metadataCache = new MetadataCache(this.brokerId());
    private final Option<Authorizer> authorizer = None$.MODULE$;
    private final ClientQuotaManager clientQuotaManager = (ClientQuotaManager)EasyMock.createNiceMock(ClientQuotaManager.class);
    private final ClientRequestQuotaManager clientRequestQuotaManager = (ClientRequestQuotaManager)EasyMock.createNiceMock(ClientRequestQuotaManager.class);
    private final ReplicationQuotaManager replicaQuotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
    private final QuotaFactory.QuotaManagers quotas = new QuotaFactory.QuotaManagers(this.clientQuotaManager(), this.clientQuotaManager(), this.clientRequestQuotaManager(), this.replicaQuotaManager(), this.replicaQuotaManager(), this.replicaQuotaManager(), (Option)None$.MODULE$);
    private final FetchManager fetchManager = (FetchManager)EasyMock.createNiceMock(FetchManager.class);
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final String clusterId;
    private final MockTime time = new MockTime();

    private RequestChannel requestChannel() {
        return this.requestChannel;
    }

    private RequestChannel.Metrics requestChannelMetrics() {
        return this.requestChannelMetrics;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private GroupCoordinator groupCoordinator() {
        return this.groupCoordinator;
    }

    private AdminManager adminManager() {
        return this.adminManager;
    }

    private TransactionCoordinator txnCoordinator() {
        return this.txnCoordinator;
    }

    private KafkaController controller() {
        return this.controller;
    }

    private KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private Option<Authorizer> authorizer() {
        return this.authorizer;
    }

    private ClientQuotaManager clientQuotaManager() {
        return this.clientQuotaManager;
    }

    private ClientRequestQuotaManager clientRequestQuotaManager() {
        return this.clientRequestQuotaManager;
    }

    private ReplicationQuotaManager replicaQuotaManager() {
        return this.replicaQuotaManager;
    }

    private QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    private FetchManager fetchManager() {
        return this.fetchManager;
    }

    private BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    private String clusterId() {
        return this.clusterId;
    }

    private MockTime time() {
        return this.time;
    }

    @After
    public void tearDown() {
        this.quotas().shutdown();
        this.metrics().close();
    }

    public KafkaApis createKafkaApis(ApiVersion interBrokerProtocolVersion) {
        Properties properties = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zk", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        properties.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), interBrokerProtocolVersion.toString());
        properties.put(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), interBrokerProtocolVersion.toString());
        return new KafkaApis(this.requestChannel(), this.replicaManager(), this.adminManager(), this.groupCoordinator(), this.txnCoordinator(), this.controller(), this.zkClient(), this.brokerId(), new KafkaConfig((java.util.Map)properties), this.metadataCache(), this.metrics(), this.authorizer(), this.quotas(), this.fetchManager(), this.brokerTopicStats(), this.clusterId(), (Time)this.time(), null);
    }

    public ApiVersion createKafkaApis$default$1() {
        return ApiVersion$.MODULE$.latestVersion();
    }

    @Test
    public void testOffsetCommitWithInvalidPartition() {
        String topic = "topic";
        this.setupBasicMetadataCache(topic, 1);
        this.checkInvalidPartition$1(-1, topic);
        this.checkInvalidPartition$1(1, topic);
    }

    @Test
    public void testTxnOffsetCommitWithInvalidPartition() {
        String topic = "topic";
        this.setupBasicMetadataCache(topic, 1);
        this.checkInvalidPartition$2(-1, topic);
        this.checkInvalidPartition$2(1, topic);
    }

    @Test
    public void testAddPartitionsToTxnWithInvalidPartition() {
        String topic = "topic";
        this.setupBasicMetadataCache(topic, 1);
        this.checkInvalidPartition$3(-1, topic);
        this.checkInvalidPartition$3(1, topic);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowUnsupportedVersionExceptionOnHandleAddOffsetToTxnRequestWhenInterBrokerProtocolNotSupported() {
        this.createKafkaApis((ApiVersion)KAFKA_0_10_2_IV0$.MODULE$).handleAddOffsetsToTxnRequest(null);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowUnsupportedVersionExceptionOnHandleAddPartitionsToTxnRequestWhenInterBrokerProtocolNotSupported() {
        this.createKafkaApis((ApiVersion)KAFKA_0_10_2_IV0$.MODULE$).handleAddPartitionToTxnRequest(null);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowUnsupportedVersionExceptionOnHandleTxnOffsetCommitRequestWhenInterBrokerProtocolNotSupported() {
        this.createKafkaApis((ApiVersion)KAFKA_0_10_2_IV0$.MODULE$).handleAddPartitionToTxnRequest(null);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowUnsupportedVersionExceptionOnHandleEndTxnRequestWhenInterBrokerProtocolNotSupported() {
        this.createKafkaApis((ApiVersion)KAFKA_0_10_2_IV0$.MODULE$).handleEndTxnRequest(null);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowUnsupportedVersionExceptionOnHandleWriteTxnMarkersRequestWhenInterBrokerProtocolNotSupported() {
        this.createKafkaApis((ApiVersion)KAFKA_0_10_2_IV0$.MODULE$).handleWriteTxnMarkersRequest(null);
    }

    @Test
    public void shouldRespondWithUnsupportedForMessageFormatOnHandleWriteTxnMarkersWhenMagicLowerThanRequired() {
        TopicPartition topicPartition = new TopicPartition("t", 0);
        Tuple2<WriteTxnMarkersRequest, RequestChannel.Request> tuple2 = this.createWriteTxnMarkersRequest(Arrays.asList((Object[])new TopicPartition[]{topicPartition}));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        WriteTxnMarkersRequest writeTxnMarkersRequest = (WriteTxnMarkersRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)writeTxnMarkersRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        WriteTxnMarkersRequest writeTxnMarkersRequest2 = (WriteTxnMarkersRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        java.util.Map expectedErrors = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)Errors.UNSUPPORTED_FOR_MESSAGE_FORMAT)}))).asJava();
        Capture capturedResponse = EasyMock.newCapture();
        EasyMock.expect((Object)this.replicaManager().getMagic(topicPartition)).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)1)));
        this.requestChannel().sendResponse((RequestChannel.Response)EasyMock.capture((Capture)capturedResponse));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.replicaQuotaManager(), this.requestChannel()});
        this.createKafkaApis(this.createKafkaApis$default$1()).handleWriteTxnMarkersRequest(request2);
        WriteTxnMarkersResponse markersResponse = (WriteTxnMarkersResponse)this.readResponse(ApiKeys.WRITE_TXN_MARKERS, (AbstractRequest)writeTxnMarkersRequest2, (Capture<RequestChannel.Response>)capturedResponse);
        Assert.assertEquals((Object)expectedErrors, (Object)markersResponse.errors(1L));
    }

    @Test
    public void shouldRespondWithUnknownTopicWhenPartitionIsNotHosted() {
        TopicPartition topicPartition = new TopicPartition("t", 0);
        Tuple2<WriteTxnMarkersRequest, RequestChannel.Request> tuple2 = this.createWriteTxnMarkersRequest(Arrays.asList((Object[])new TopicPartition[]{topicPartition}));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        WriteTxnMarkersRequest writeTxnMarkersRequest = (WriteTxnMarkersRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)writeTxnMarkersRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        WriteTxnMarkersRequest writeTxnMarkersRequest2 = (WriteTxnMarkersRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        java.util.Map expectedErrors = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)Errors.UNKNOWN_TOPIC_OR_PARTITION)}))).asJava();
        Capture capturedResponse = EasyMock.newCapture();
        EasyMock.expect((Object)this.replicaManager().getMagic(topicPartition)).andReturn((Object)None$.MODULE$);
        this.requestChannel().sendResponse((RequestChannel.Response)EasyMock.capture((Capture)capturedResponse));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.replicaQuotaManager(), this.requestChannel()});
        this.createKafkaApis(this.createKafkaApis$default$1()).handleWriteTxnMarkersRequest(request2);
        WriteTxnMarkersResponse markersResponse = (WriteTxnMarkersResponse)this.readResponse(ApiKeys.WRITE_TXN_MARKERS, (AbstractRequest)writeTxnMarkersRequest2, (Capture<RequestChannel.Response>)capturedResponse);
        Assert.assertEquals((Object)expectedErrors, (Object)markersResponse.errors(1L));
    }

    @Test
    public void shouldRespondWithUnsupportedMessageFormatForBadPartitionAndNoErrorsForGoodPartition() {
        TopicPartition tp1 = new TopicPartition("t", 0);
        TopicPartition tp2 = new TopicPartition("t1", 0);
        Tuple2<WriteTxnMarkersRequest, RequestChannel.Request> tuple2 = this.createWriteTxnMarkersRequest(Arrays.asList((Object[])new TopicPartition[]{tp1, tp2}));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        WriteTxnMarkersRequest writeTxnMarkersRequest = (WriteTxnMarkersRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)writeTxnMarkersRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        WriteTxnMarkersRequest writeTxnMarkersRequest2 = (WriteTxnMarkersRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        java.util.Map expectedErrors = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)Errors.UNSUPPORTED_FOR_MESSAGE_FORMAT), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)Errors.NONE)}))).asJava();
        Capture capturedResponse = EasyMock.newCapture();
        Capture responseCallback = EasyMock.newCapture();
        EasyMock.expect((Object)this.replicaManager().getMagic(tp1)).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)1)));
        EasyMock.expect((Object)this.replicaManager().getMagic(tp2)).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)2)));
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false), (Map)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)responseCallback), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, responseCallback, tp2){
            private final Capture responseCallback$1;
            private final TopicPartition tp2$1;

            public void answer() {
                ((Function1)this.responseCallback$1.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp2$1), (Object)new ProduceResponse.PartitionResponse(Errors.NONE))})));
            }
            {
                this.responseCallback$1 = responseCallback$1;
                this.tp2$1 = tp2$1;
            }
        });
        this.requestChannel().sendResponse((RequestChannel.Response)EasyMock.capture((Capture)capturedResponse));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.replicaQuotaManager(), this.requestChannel()});
        this.createKafkaApis(this.createKafkaApis$default$1()).handleWriteTxnMarkersRequest(request2);
        WriteTxnMarkersResponse markersResponse = (WriteTxnMarkersResponse)this.readResponse(ApiKeys.WRITE_TXN_MARKERS, (AbstractRequest)writeTxnMarkersRequest2, (Capture<RequestChannel.Response>)capturedResponse);
        Assert.assertEquals((Object)expectedErrors, (Object)markersResponse.errors(1L));
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void shouldRespondWithUnknownTopicOrPartitionForBadPartitionAndNoErrorsForGoodPartition() {
        TopicPartition tp1 = new TopicPartition("t", 0);
        TopicPartition tp2 = new TopicPartition("t1", 0);
        Tuple2<WriteTxnMarkersRequest, RequestChannel.Request> tuple2 = this.createWriteTxnMarkersRequest(Arrays.asList((Object[])new TopicPartition[]{tp1, tp2}));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        WriteTxnMarkersRequest writeTxnMarkersRequest = (WriteTxnMarkersRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)writeTxnMarkersRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        WriteTxnMarkersRequest writeTxnMarkersRequest2 = (WriteTxnMarkersRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        java.util.Map expectedErrors = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)Errors.UNKNOWN_TOPIC_OR_PARTITION), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)Errors.NONE)}))).asJava();
        Capture capturedResponse = EasyMock.newCapture();
        Capture responseCallback = EasyMock.newCapture();
        EasyMock.expect((Object)this.replicaManager().getMagic(tp1)).andReturn((Object)None$.MODULE$);
        EasyMock.expect((Object)this.replicaManager().getMagic(tp2)).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)2)));
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false), (Map)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)responseCallback), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, responseCallback, tp2){
            private final Capture responseCallback$2;
            private final TopicPartition tp2$2;

            public void answer() {
                ((Function1)this.responseCallback$2.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp2$2), (Object)new ProduceResponse.PartitionResponse(Errors.NONE))})));
            }
            {
                this.responseCallback$2 = responseCallback$2;
                this.tp2$2 = tp2$2;
            }
        });
        this.requestChannel().sendResponse((RequestChannel.Response)EasyMock.capture((Capture)capturedResponse));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.replicaQuotaManager(), this.requestChannel()});
        this.createKafkaApis(this.createKafkaApis$default$1()).handleWriteTxnMarkersRequest(request2);
        WriteTxnMarkersResponse markersResponse = (WriteTxnMarkersResponse)this.readResponse(ApiKeys.WRITE_TXN_MARKERS, (AbstractRequest)writeTxnMarkersRequest2, (Capture<RequestChannel.Response>)capturedResponse);
        Assert.assertEquals((Object)expectedErrors, (Object)markersResponse.errors(1L));
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void shouldAppendToLogOnWriteTxnMarkersWhenCorrectMagicVersion() {
        TopicPartition topicPartition = new TopicPartition("t", 0);
        RequestChannel.Request request = (RequestChannel.Request)this.createWriteTxnMarkersRequest(Arrays.asList((Object[])new TopicPartition[]{topicPartition}))._2();
        EasyMock.expect((Object)this.replicaManager().getMagic(topicPartition)).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)2)));
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false), (Map)EasyMock.anyObject(), (Function1)EasyMock.anyObject(), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.createKafkaApis(this.createKafkaApis$default$1()).handleWriteTxnMarkersRequest(request);
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testLeaderReplicaIfLocalRaisesFencedLeaderEpoch() {
        this.testListOffsetFailedGetLeaderReplica(Errors.FENCED_LEADER_EPOCH);
    }

    @Test
    public void testLeaderReplicaIfLocalRaisesUnknownLeaderEpoch() {
        this.testListOffsetFailedGetLeaderReplica(Errors.UNKNOWN_LEADER_EPOCH);
    }

    @Test
    public void testLeaderReplicaIfLocalRaisesNotLeaderForPartition() {
        this.testListOffsetFailedGetLeaderReplica(Errors.NOT_LEADER_FOR_PARTITION);
    }

    @Test
    public void testLeaderReplicaIfLocalRaisesUnknownTopicOrPartition() {
        this.testListOffsetFailedGetLeaderReplica(Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    private void testListOffsetFailedGetLeaderReplica(Errors error) {
        TopicPartition tp = new TopicPartition("foo", 0);
        IsolationLevel isolationLevel = IsolationLevel.READ_UNCOMMITTED;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(15));
        EasyMock.expect((Object)this.replicaManager().fetchOffsetForTimestamp((TopicPartition)EasyMock.eq((Object)tp), EasyMock.eq((long)-2L), (Option)EasyMock.eq((Object)new Some((Object)isolationLevel)), (Optional)EasyMock.eq(currentLeaderEpoch), EasyMock.eq((boolean)true))).andThrow((Throwable)error.exception());
        Capture<RequestChannel.Response> capturedResponse = this.expectNoThrottling();
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.clientRequestQuotaManager(), this.requestChannel()});
        Map targetTimes = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new ListOffsetRequest.PartitionData(-2L, currentLeaderEpoch))}));
        ListOffsetRequest.Builder builder = ListOffsetRequest.Builder.forConsumer((boolean)true, (IsolationLevel)isolationLevel).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(targetTimes).asJava());
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)builder, this.buildRequest$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ListOffsetRequest listOffsetRequest = (ListOffsetRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)listOffsetRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        ListOffsetRequest listOffsetRequest2 = (ListOffsetRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        this.createKafkaApis(this.createKafkaApis$default$1()).handleListOffsetRequest(request2);
        ListOffsetResponse response = (ListOffsetResponse)this.readResponse(ApiKeys.LIST_OFFSETS, (AbstractRequest)listOffsetRequest2, capturedResponse);
        Assert.assertTrue((boolean)response.responseData().containsKey(tp));
        ListOffsetResponse.PartitionData partitionData = (ListOffsetResponse.PartitionData)response.responseData().get(tp);
        Assert.assertEquals((Object)error, (Object)partitionData.error);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)-1L), (Object)partitionData.offset);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)-1L), (Object)partitionData.timestamp);
    }

    @Test
    public void testReadUncommittedConsumerListOffsetLatest() {
        this.testConsumerListOffsetLatest(IsolationLevel.READ_UNCOMMITTED);
    }

    @Test
    public void testReadCommittedConsumerListOffsetLatest() {
        this.testConsumerListOffsetLatest(IsolationLevel.READ_COMMITTED);
    }

    @Test
    public void testMetadataRequestOnSharedListenerWithInconsistentListenersAcrossBrokers() {
        ListenerName plaintextListener;
        Tuple2<ListenerName, ListenerName> tuple2 = this.updateMetadataCacheWithInconsistentListeners();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ListenerName listenerName = plaintextListener = (ListenerName)tuple2._1();
        ListenerName plaintextListener2 = listenerName;
        MetadataResponse response = this.sendMetadataRequestWithInconsistentListeners(plaintextListener2);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.brokers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.id()), Iterable$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void testMetadataRequestOnDistinctListenerWithInconsistentListenersAcrossBrokers() {
        ListenerName anotherListener;
        Tuple2<ListenerName, ListenerName> tuple2 = this.updateMetadataCacheWithInconsistentListeners();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ListenerName listenerName = anotherListener = (ListenerName)tuple2._2();
        ListenerName anotherListener2 = listenerName;
        MetadataResponse response = this.sendMetadataRequestWithInconsistentListeners(anotherListener2);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.brokers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.id()), Iterable$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void testFetchRequestV9WithNoLogConfig() {
        TopicPartition tp = new TopicPartition("foo", 0);
        this.setupBasicMetadataCache(tp.topic(), 1);
        int hw = 3;
        int timestamp = 1000;
        EasyMock.expect((Object)this.replicaManager().getLogConfig((TopicPartition)EasyMock.eq((Object)tp))).andReturn((Object)None$.MODULE$);
        this.replicaManager().fetchMessages(EasyMock.anyLong(), EasyMock.anyInt(), EasyMock.anyInt(), EasyMock.anyInt(), EasyMock.anyBoolean(), (Seq)EasyMock.anyObject(), (ReplicaQuota)EasyMock.anyObject(), (Function1)EasyMock.anyObject(), (IsolationLevel)EasyMock.anyObject());
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, timestamp, tp, hw){
            private final int timestamp$1;
            private final TopicPartition tp$1;
            private final int hw$1;

            public void answer() {
                Function1 callback = (Function1)EasyMock.getCurrentArguments()[7];
                MemoryRecords records = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord((long)this.timestamp$1, "foo".getBytes(StandardCharsets.UTF_8))});
                callback.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp$1), (Object)new FetchPartitionData(Errors.NONE, (long)this.hw$1, 0L, (Records)records, (Option)None$.MODULE$, (Option)None$.MODULE$))})));
            }
            {
                this.timestamp$1 = timestamp$1;
                this.tp$1 = tp$1;
                this.hw$1 = hw$1;
            }
        });
        java.util.Map fetchData = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new FetchRequest.PartitionData(0L, 0L, 1000, Optional.empty()))}))).asJava();
        FetchMetadata fetchMetadata = new FetchMetadata(0, 0);
        FullFetchContext fetchContext = new FullFetchContext((Time)this.time(), new FetchSessionCache(1000, 100L), fetchMetadata, fetchData, false);
        EasyMock.expect((Object)this.fetchManager().newContext((FetchMetadata)EasyMock.anyObject(), (java.util.Map)EasyMock.anyObject(), (java.util.List)EasyMock.anyObject(), EasyMock.anyBoolean())).andReturn((Object)fetchContext);
        Capture<RequestChannel.Response> capturedResponse = this.expectNoThrottling();
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)this.clientQuotaManager().maybeRecordAndGetThrottleTimeMs((RequestChannel.Request)EasyMock.anyObject(), EasyMock.anyDouble(), EasyMock.anyLong()))).andReturn((Object)BoxesRunTime.boxToInteger((int)0));
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.clientQuotaManager(), this.clientRequestQuotaManager(), this.requestChannel(), this.fetchManager()});
        FetchRequest.Builder builder = new FetchRequest.Builder(9, 9, -1, 100, 0, fetchData);
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)builder, this.buildRequest$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        FetchRequest fetchRequest = (FetchRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)fetchRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        FetchRequest fetchRequest2 = (FetchRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        this.createKafkaApis(this.createKafkaApis$default$1()).handleFetchRequest(request2);
        FetchResponse response = (FetchResponse)this.readResponse(ApiKeys.FETCH, (AbstractRequest)fetchRequest2, capturedResponse);
        Assert.assertTrue((boolean)response.responseData().containsKey(tp));
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)response.responseData().get(tp);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
        Assert.assertEquals((long)hw, (long)partitionData.highWatermark);
        Assert.assertEquals((long)-1L, (long)partitionData.lastStableOffset);
        Assert.assertEquals((long)0L, (long)partitionData.logStartOffset);
        Assert.assertEquals((long)timestamp, (long)((RecordBatch)((MemoryRecords)partitionData.records).batches().iterator().next()).maxTimestamp());
        Assert.assertNull((Object)partitionData.abortedTransactions);
    }

    private Tuple2<ListenerName, ListenerName> updateMetadataCacheWithInconsistentListeners() {
        ListenerName plaintextListener = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        ListenerName anotherListener = new ListenerName("LISTENER2");
        scala.collection.immutable.Set brokers = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.Broker[]{new UpdateMetadataRequest.Broker(0, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint("broker0", 9092, SecurityProtocol.PLAINTEXT, plaintextListener), new UpdateMetadataRequest.EndPoint("broker0", 9093, SecurityProtocol.PLAINTEXT, anotherListener)}))).asJava(), "rack"), new UpdateMetadataRequest.Broker(1, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint("broker1", 9092, SecurityProtocol.PLAINTEXT, plaintextListener)}))).asJava(), "rack")}));
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(ApiKeys.UPDATE_METADATA.latestVersion(), 0, 0, 0L, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.empty()).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)brokers).asJava()).build();
        this.metadataCache().updateMetadata(0, updateMetadataRequest);
        return new Tuple2((Object)plaintextListener, (Object)anotherListener);
    }

    private MetadataResponse sendMetadataRequestWithInconsistentListeners(ListenerName requestListener) {
        Capture<RequestChannel.Response> capturedResponse = this.expectNoThrottling();
        EasyMock.replay((Object[])new Object[]{this.clientRequestQuotaManager(), this.requestChannel()});
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)MetadataRequest.Builder.allTopics(), requestListener);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        MetadataRequest metadataRequest = (MetadataRequest)tuple2._1();
        RequestChannel.Request requestChannelRequest = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)metadataRequest, (Object)requestChannelRequest);
        Tuple2 tuple23 = tuple22;
        MetadataRequest metadataRequest2 = (MetadataRequest)tuple23._1();
        RequestChannel.Request requestChannelRequest2 = (RequestChannel.Request)tuple23._2();
        this.createKafkaApis(this.createKafkaApis$default$1()).handleTopicMetadataRequest(requestChannelRequest2);
        return (MetadataResponse)this.readResponse(ApiKeys.METADATA, (AbstractRequest)metadataRequest2, capturedResponse);
    }

    private void testConsumerListOffsetLatest(IsolationLevel isolationLevel) {
        TopicPartition tp = new TopicPartition("foo", 0);
        long latestOffset = 15L;
        Optional currentLeaderEpoch = Optional.empty();
        EasyMock.expect((Object)this.replicaManager().fetchOffsetForTimestamp((TopicPartition)EasyMock.eq((Object)tp), EasyMock.eq((long)-1L), (Option)EasyMock.eq((Object)new Some((Object)isolationLevel)), (Optional)EasyMock.eq(currentLeaderEpoch), EasyMock.eq((boolean)true))).andReturn((Object)new Some((Object)new FileRecords.TimestampAndOffset(-1L, latestOffset, currentLeaderEpoch)));
        Capture<RequestChannel.Response> capturedResponse = this.expectNoThrottling();
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.clientRequestQuotaManager(), this.requestChannel()});
        Map targetTimes = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new ListOffsetRequest.PartitionData(-1L, currentLeaderEpoch))}));
        ListOffsetRequest.Builder builder = ListOffsetRequest.Builder.forConsumer((boolean)true, (IsolationLevel)isolationLevel).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(targetTimes).asJava());
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)builder, this.buildRequest$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ListOffsetRequest listOffsetRequest = (ListOffsetRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)listOffsetRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        ListOffsetRequest listOffsetRequest2 = (ListOffsetRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        this.createKafkaApis(this.createKafkaApis$default$1()).handleListOffsetRequest(request2);
        ListOffsetResponse response = (ListOffsetResponse)this.readResponse(ApiKeys.LIST_OFFSETS, (AbstractRequest)listOffsetRequest2, capturedResponse);
        Assert.assertTrue((boolean)response.responseData().containsKey(tp));
        ListOffsetResponse.PartitionData partitionData = (ListOffsetResponse.PartitionData)response.responseData().get(tp);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)latestOffset), (Object)partitionData.offset);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)-1L), (Object)partitionData.timestamp);
    }

    private Tuple2<WriteTxnMarkersRequest, RequestChannel.Request> createWriteTxnMarkersRequest(java.util.List<TopicPartition> partitions) {
        WriteTxnMarkersRequest.Builder requestBuilder = new WriteTxnMarkersRequest.Builder(Arrays.asList((Object[])new WriteTxnMarkersRequest.TxnMarkerEntry[]{new WriteTxnMarkersRequest.TxnMarkerEntry(1L, (short)1, 0, TransactionResult.COMMIT, partitions)}));
        return this.buildRequest((AbstractRequest.Builder)requestBuilder, this.buildRequest$default$2());
    }

    private <T extends AbstractRequest> Tuple2<T, RequestChannel.Request> buildRequest(AbstractRequest.Builder<T> builder, ListenerName listenerName) {
        AbstractRequest request = builder.build();
        ByteBuffer buffer = request.serialize(new RequestHeader(builder.apiKey(), request.version(), "", 0));
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        RequestContext context = new RequestContext(header, "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, listenerName, SecurityProtocol.PLAINTEXT);
        return new Tuple2((Object)request, (Object)new RequestChannel.Request(1, context, 0L, MemoryPool.NONE, buffer, this.requestChannelMetrics()));
    }

    private <T extends AbstractRequest> ListenerName buildRequest$default$2() {
        return ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    }

    private AbstractResponse readResponse(ApiKeys api, AbstractRequest request, Capture<RequestChannel.Response> capturedResponse) {
        RequestChannel.Response response = (RequestChannel.Response)capturedResponse.getValue();
        Assert.assertTrue((String)new StringBuilder(26).append("Unexpected response type: ").append(response.getClass()).toString(), (boolean)(response instanceof RequestChannel.SendResponse));
        RequestChannel.SendResponse sendResponse = (RequestChannel.SendResponse)response;
        Send send = sendResponse.responseSend();
        ByteBufferChannel channel = new ByteBufferChannel(send.size());
        send.writeTo((GatheringByteChannel)channel);
        channel.close();
        channel.buffer().getInt();
        ResponseHeader.parse((ByteBuffer)channel.buffer());
        Struct struct = api.responseSchema(request.version()).read(channel.buffer());
        return AbstractResponse.parseResponse((ApiKeys)api, (Struct)struct, (short)request.version());
    }

    /*
     * WARNING - void declaration
     */
    private Capture<RequestChannel.Response> expectNoThrottling() {
        void var1_1;
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)this.clientRequestQuotaManager().maybeRecordAndGetThrottleTimeMs((RequestChannel.Request)EasyMock.anyObject()))).andReturn((Object)BoxesRunTime.boxToInteger((int)0));
        this.clientRequestQuotaManager().throttle((RequestChannel.Request)EasyMock.anyObject(), EasyMock.eq((int)0), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        Capture capturedResponse = EasyMock.newCapture();
        this.requestChannel().sendResponse((RequestChannel.Response)EasyMock.capture((Capture)capturedResponse));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        return var1_1;
    }

    private void setupBasicMetadataCache(String topic, int numPartitions) {
        java.util.List replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)0), (List)Nil$.MODULE$)).asJava();
        UpdateMetadataRequest.PartitionState partitionState = new UpdateMetadataRequest.PartitionState(1, 0, 1, replicas, 0, replicas, Collections.emptyList());
        ListenerName plaintextListener = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        UpdateMetadataRequest.Broker broker = new UpdateMetadataRequest.Broker(0, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint("broker0", 9092, SecurityProtocol.PLAINTEXT, plaintextListener)}))).asJava(), "rack");
        scala.collection.immutable.Map partitions = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1 & Serializable & scala.Serializable)x$14 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, BoxesRunTime.unboxToInt((Object)x$14))), (Object)partitionState), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(ApiKeys.UPDATE_METADATA.latestVersion(), 0, 0, 0L, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitions).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.Broker[]{broker}))).asJava()).build();
        this.metadataCache().updateMetadata(0, updateMetadataRequest);
    }

    private final void checkInvalidPartition$1(int invalidPartitionId, String topic$1) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager(), this.clientRequestQuotaManager(), this.requestChannel()});
        TopicPartition invalidTopicPartition = new TopicPartition(topic$1, invalidPartitionId);
        OffsetCommitRequest.PartitionData partitionOffsetCommitData = new OffsetCommitRequest.PartitionData(15L, Optional.empty(), "");
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)new OffsetCommitRequest.Builder("groupId", (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)invalidTopicPartition), (Object)partitionOffsetCommitData)}))).asJava()), this.buildRequest$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        OffsetCommitRequest offsetCommitRequest = (OffsetCommitRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)offsetCommitRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        OffsetCommitRequest offsetCommitRequest2 = (OffsetCommitRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        Capture<RequestChannel.Response> capturedResponse = this.expectNoThrottling();
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.clientRequestQuotaManager(), this.requestChannel()});
        this.createKafkaApis(this.createKafkaApis$default$1()).handleOffsetCommitRequest(request2);
        OffsetCommitResponse response = (OffsetCommitResponse)this.readResponse(ApiKeys.OFFSET_COMMIT, (AbstractRequest)offsetCommitRequest2, capturedResponse);
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, response.responseData().get(invalidTopicPartition));
    }

    private final void checkInvalidPartition$2(int invalidPartitionId, String topic$2) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager(), this.clientRequestQuotaManager(), this.requestChannel()});
        TopicPartition invalidTopicPartition = new TopicPartition(topic$2, invalidPartitionId);
        TxnOffsetCommitRequest.CommittedOffset partitionOffsetCommitData = new TxnOffsetCommitRequest.CommittedOffset(15L, "", Optional.empty());
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)new TxnOffsetCommitRequest.Builder("txnlId", "groupId", 15L, (short)0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)invalidTopicPartition), (Object)partitionOffsetCommitData)}))).asJava()), this.buildRequest$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        TxnOffsetCommitRequest offsetCommitRequest = (TxnOffsetCommitRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)offsetCommitRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        TxnOffsetCommitRequest offsetCommitRequest2 = (TxnOffsetCommitRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        Capture<RequestChannel.Response> capturedResponse = this.expectNoThrottling();
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.clientRequestQuotaManager(), this.requestChannel()});
        this.createKafkaApis(this.createKafkaApis$default$1()).handleTxnOffsetCommitRequest(request2);
        TxnOffsetCommitResponse response = (TxnOffsetCommitResponse)this.readResponse(ApiKeys.TXN_OFFSET_COMMIT, (AbstractRequest)offsetCommitRequest2, capturedResponse);
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, response.errors().get(invalidTopicPartition));
    }

    private final void checkInvalidPartition$3(int invalidPartitionId, String topic$3) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager(), this.clientRequestQuotaManager(), this.requestChannel()});
        TopicPartition invalidTopicPartition = new TopicPartition(topic$3, invalidPartitionId);
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)new AddPartitionsToTxnRequest.Builder("txnlId", 15L, (short)0, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)invalidTopicPartition, (List)Nil$.MODULE$)).asJava()), this.buildRequest$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        AddPartitionsToTxnRequest addPartitionsToTxnRequest = (AddPartitionsToTxnRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)addPartitionsToTxnRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        AddPartitionsToTxnRequest addPartitionsToTxnRequest2 = (AddPartitionsToTxnRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        Capture<RequestChannel.Response> capturedResponse = this.expectNoThrottling();
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.clientRequestQuotaManager(), this.requestChannel()});
        this.createKafkaApis(this.createKafkaApis$default$1()).handleAddPartitionToTxnRequest(request2);
        AddPartitionsToTxnResponse response = (AddPartitionsToTxnResponse)this.readResponse(ApiKeys.ADD_PARTITIONS_TO_TXN, (AbstractRequest)addPartitionsToTxnRequest2, capturedResponse);
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, response.errors().get(invalidTopicPartition));
    }

    public KafkaApisTest() {
        this.brokerId = 1;
        this.clusterId = "clusterId";
    }
}

