/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.server.BaseRequestTest;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaMetricReporterExceptionHandlingTest$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ListGroupsRequest;
import org.apache.kafka.common.requests.ListGroupsResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\u000e\u001d\u0001\u0005BQA\n\u0001\u0005\u0002\u001dBQ!\u000b\u0001\u0005B)BQ!\r\u0001\u0005BIBQ\u0001\u0011\u0001\u0005B\u0005CQa\u0013\u0001\u0005B\u0005CQ\u0001\u0015\u0001\u0005\u0002\u0005;Q!\u0016\u000f\t\u0002Y3Qa\u0007\u000f\t\u0002]CQA\n\u0005\u0005\u0002yCqa\u0018\u0005A\u0002\u0013\u0005\u0001\rC\u0004j\u0011\u0001\u0007I\u0011\u00016\t\r5D\u0001\u0015)\u0003b\u0011\u001dq\u0007\u00021A\u0005\u0002\u0001Dqa\u001c\u0005A\u0002\u0013\u0005\u0001\u000f\u0003\u0004s\u0011\u0001\u0006K!\u0019\u0004\u0005g\"\u0001A\u000f\u0003\u0004'!\u0011\u0005\u0011Q\u0002\u0005\b\u0003'\u0001B\u0011AA\u000b\u0011\u001d\ty\u0005\u0005C\u0001\u0003#Bq!!\u0019\u0011\t\u0003\t\u0019\u0007C\u0004\u0002jA!\t!a\u001b\t\r\u0005=\u0004\u0003\"\u0001B\r\u0019\t\t\b\u0003\u0001\u0002t!1ae\u0006C\u0001\u0003kBq!!\u0019\u0018\t\u0003\nI\bC\u0005\u0002~!\t\t\u0011\"\u0003\u0002\u0000\tA3*\u00194lC6+GO]5d%\u0016\u0004xN\u001d;fe\u0016C8-\u001a9uS>t\u0007*\u00198eY&tw\rV3ti*\u0011QDH\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003}\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001EA\u00111\u0005J\u0007\u00029%\u0011Q\u0005\b\u0002\u0010\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti\u00061A(\u001b8jiz\"\u0012\u0001\u000b\t\u0003G\u0001\t!B\\;n\u0005J|7.\u001a:t+\u0005Y\u0003C\u0001\u00170\u001b\u0005i#\"\u0001\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Aj#aA%oi\u0006\t\u0002O]8qKJ$\u0018p\u0014<feJLG-Z:\u0015\u0005M2\u0004C\u0001\u00175\u0013\t)TF\u0001\u0003V]&$\b\"B\u001c\u0004\u0001\u0004A\u0014A\u00039s_B,'\u000f^5fgB\u0011\u0011HP\u0007\u0002u)\u00111\bP\u0001\u0005kRLGNC\u0001>\u0003\u0011Q\u0017M^1\n\u0005}R$A\u0003)s_B,'\u000f^5fg\u0006)1/\u001a;VaR\t1\u0007\u000b\u0002\u0005\u0007B\u0011A)S\u0007\u0002\u000b*\u0011aiR\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u0011\u0006\u0019qN]4\n\u0005)+%A\u0002\"fM>\u0014X-\u0001\u0005uK\u0006\u0014Hi\\<oQ\t)Q\n\u0005\u0002E\u001d&\u0011q*\u0012\u0002\u0006\u0003\u001a$XM]\u0001\u001ci\u0016\u001cHOQ8uQJ+\u0007o\u001c:uKJ\u001c\u0018I]3J]Z|7.\u001a3)\u0005\u0019\u0011\u0006C\u0001#T\u0013\t!VI\u0001\u0003UKN$\u0018\u0001K&bM.\fW*\u001a;sS\u000e\u0014V\r]8si\u0016\u0014X\t_2faRLwN\u001c%b]\u0012d\u0017N\\4UKN$\bCA\u0012\t'\rA\u0001l\u0017\t\u0003YeK!AW\u0017\u0003\r\u0005s\u0017PU3g!\taC,\u0003\u0002^[\ta1+\u001a:jC2L'0\u00192mKR\ta+\u0001\fh_>$'+\u001a9peR,'OU3hSN$XM]3e+\u0005\t\u0007C\u00012h\u001b\u0005\u0019'B\u00013f\u0003\u0019\tGo\\7jG*\u0011aMO\u0001\u000bG>t7-\u001e:sK:$\u0018B\u00015d\u00055\tEo\\7jG&sG/Z4fe\u0006Qrm\\8e%\u0016\u0004xN\u001d;feJ+w-[:uKJ,Gm\u0018\u0013fcR\u00111g\u001b\u0005\bY.\t\t\u00111\u0001b\u0003\rAH%M\u0001\u0018O>|GMU3q_J$XM\u001d*fO&\u001cH/\u001a:fI\u0002\nQCY1e%\u0016\u0004xN\u001d;feJ+w-[:uKJ,G-A\rcC\u0012\u0014V\r]8si\u0016\u0014(+Z4jgR,'/\u001a3`I\u0015\fHCA\u001ar\u0011\u001dag\"!AA\u0002\u0005\faCY1e%\u0016\u0004xN\u001d;feJ+w-[:uKJ,G\r\t\u0002\r\u000f>|GMU3q_J$XM]\n\u0004!U\\\bC\u0001<z\u001b\u00059(B\u0001==\u0003\u0011a\u0017M\\4\n\u0005i<(AB(cU\u0016\u001cG\u000fE\u0002}\u0003\u0013i\u0011! \u0006\u0003}~\fq!\\3ue&\u001c7O\u0003\u0003\u0002\u0002\u0005\r\u0011AB2p[6|gNC\u0002 \u0003\u000bQ1!a\u0002H\u0003\u0019\t\u0007/Y2iK&\u0019\u00111B?\u0003\u001f5+GO]5dgJ+\u0007o\u001c:uKJ$\"!a\u0004\u0011\u0007\u0005E\u0001#D\u0001\t\u0003%\u0019wN\u001c4jOV\u0014X\rF\u00024\u0003/Aq!!\u0007\u0013\u0001\u0004\tY\"A\u0004d_:4\u0017nZ:1\t\u0005u\u0011Q\b\t\bs\u0005}\u00111EA\u001d\u0013\r\t\tC\u000f\u0002\u0004\u001b\u0006\u0004\b\u0003BA\u0013\u0003gqA!a\n\u00020A\u0019\u0011\u0011F\u0017\u000e\u0005\u0005-\"bAA\u0017A\u00051AH]8pizJ1!!\r.\u0003\u0019\u0001&/\u001a3fM&!\u0011QGA\u001c\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011G\u0017\u0011\t\u0005m\u0012Q\b\u0007\u0001\t1\ty$a\u0006\u0002\u0002\u0003\u0005)\u0011AA!\u0005\ryF%M\t\u0005\u0003\u0007\nI\u0005E\u0002-\u0003\u000bJ1!a\u0012.\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001LA&\u0013\r\ti%\f\u0002\u0004\u0003:L\u0018\u0001B5oSR$2aMA*\u0011\u0019q8\u00031\u0001\u0002VA)\u0011(a\u0016\u0002\\%\u0019\u0011\u0011\f\u001e\u0003\t1K7\u000f\u001e\t\u0004y\u0006u\u0013bAA0{\nY1*\u00194lC6+GO]5d\u00031iW\r\u001e:jG\u000eC\u0017M\\4f)\r\u0019\u0014Q\r\u0005\b\u0003O\"\u0002\u0019AA.\u0003\u0019iW\r\u001e:jG\u0006iQ.\u001a;sS\u000e\u0014V-\\8wC2$2aMA7\u0011\u001d\t9'\u0006a\u0001\u00037\nQa\u00197pg\u0016\u00141BQ1e%\u0016\u0004xN\u001d;feN\u0019q#a\u0004\u0015\u0005\u0005]\u0004cAA\t/Q\u00191'a\u001f\t\u000f\u0005\u001d\u0014\u00041\u0001\u0002\\\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005)\b")
public class KafkaMetricReporterExceptionHandlingTest
extends BaseRequestTest {
    public static void badReporterRegistered_$eq(AtomicInteger atomicInteger) {
        KafkaMetricReporterExceptionHandlingTest$.MODULE$.badReporterRegistered_$eq(atomicInteger);
    }

    public static AtomicInteger badReporterRegistered() {
        return KafkaMetricReporterExceptionHandlingTest$.MODULE$.badReporterRegistered();
    }

    public static void goodReporterRegistered_$eq(AtomicInteger atomicInteger) {
        KafkaMetricReporterExceptionHandlingTest$.MODULE$.goodReporterRegistered_$eq(atomicInteger);
    }

    public static AtomicInteger goodReporterRegistered() {
        return KafkaMetricReporterExceptionHandlingTest$.MODULE$.goodReporterRegistered();
    }

    @Override
    public int numBrokers() {
        return 1;
    }

    @Override
    public void propertyOverrides(Properties properties) {
        properties.put(KafkaConfig$.MODULE$.MetricReporterClassesProp(), new StringBuilder(1).append(BadReporter.class.getName()).append(",").append(GoodReporter.class.getName()).toString());
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Properties quotaProps = new Properties();
        quotaProps.put(DynamicConfig.Client$.MODULE$.RequestPercentageOverrideProp(), "0.1");
        this.adminZkClient().changeClientIdConfig("<default>", quotaProps);
    }

    @Override
    @After
    public void tearDown() {
        KafkaMetricReporterExceptionHandlingTest$.MODULE$.goodReporterRegistered().set(0);
        KafkaMetricReporterExceptionHandlingTest$.MODULE$.badReporterRegistered().set(0);
        super.tearDown();
    }

    @Test
    public void testBothReportersAreInvoked() {
        int port = this.anySocketServer().boundPort(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
        socket.setSoTimeout(10000);
        try (Socket socket = new Socket("localhost", port);){
            TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Errors error = new ListGroupsResponse(this.requestResponse(socket, "clientId", 0, (AbstractRequest.Builder<? extends AbstractRequest>)new ListGroupsRequest.Builder())).error();
                Assert.assertEquals((Object)Errors.NONE, (Object)error);
                Assert.assertEquals((long)KafkaMetricReporterExceptionHandlingTest$.MODULE$.goodReporterRegistered().get(), (long)KafkaMetricReporterExceptionHandlingTest$.MODULE$.badReporterRegistered().get());
                Assert.assertTrue((KafkaMetricReporterExceptionHandlingTest$.MODULE$.goodReporterRegistered().get() > 0 ? 1 : 0) != 0);
            });
        }
    }

    public static class BadReporter
    extends GoodReporter {
        @Override
        public void metricChange(KafkaMetric metric) {
            String string = metric.metricName().group();
            String string2 = "Request";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                KafkaMetricReporterExceptionHandlingTest$.MODULE$.badReporterRegistered().incrementAndGet();
                throw new RuntimeException(metric.metricName().toString());
            }
        }
    }

    public static class GoodReporter
    implements MetricsReporter {
        public void configure(Map<String, ?> configs) {
        }

        public void init(List<KafkaMetric> metrics) {
        }

        public void metricChange(KafkaMetric metric) {
            block0: {
                String string = metric.metricName().group();
                String string2 = "Request";
                if (string != null ? !string.equals(string2) : string2 != null) break block0;
                KafkaMetricReporterExceptionHandlingTest$.MODULE$.goodReporterRegistered().incrementAndGet();
            }
        }

        public void metricRemoval(KafkaMetric metric) {
        }

        public void close() {
        }
    }
}

