/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.api.IntegrationTestHarness;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaState;
import kafka.log.Log;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.LogDirFailureTest$Checkpoint$;
import kafka.server.LogDirFailureTest$Roll$;
import kafka.server.ReplicaFetcherThread;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderForPartitionException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.VolatileObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005}f\u0001\u0002\u00192\u0001YBQ!\u0010\u0001\u0005\u0002yBq!\u0011\u0001C\u0002\u0013\u0005!\t\u0003\u0004J\u0001\u0001\u0006Ia\u0011\u0005\b\u0015\u0002\u0011\r\u0011\"\u0001C\u0011\u0019Y\u0005\u0001)A\u0005\u0007\"9A\n\u0001b\u0001\n\u0003\u0011\u0005BB'\u0001A\u0003%1\tC\u0004O\u0001\t\u0007I\u0011B(\t\ra\u0003\u0001\u0015!\u0003Q\u0011\u001dI\u0006A1A\u0005\n\tCaA\u0017\u0001!\u0002\u0013\u0019\u0005bB.\u0001\u0005\u0004%\tE\u0011\u0005\u00079\u0002\u0001\u000b\u0011B\"\t\u000bu\u0003A\u0011\t0\t\u000b-\u0004A\u0011\u00010\t\u000bA\u0004A\u0011\u00010\t\u000bI\u0004A\u0011\u00010\t\u000bQ\u0004A\u0011\u00010\t\u000bY\u0004A\u0011A<\t\u000f\u0005\u001d\u0005\u0001\"\u0003\u0002\n\u001e9\u0011qA\u0019\t\u0002\u0005%aA\u0002\u00192\u0011\u0003\tY\u0001\u0003\u0004>-\u0011\u0005\u0011\u0011\u0004\u0004\n\u000371\u0002\u0013aI\u0011\u0003;9q!a!\u0017\u0011\u0003\u000bIHB\u0004\u0002tYA\t)!\u001e\t\ruRB\u0011AA<\u0011!\t\u0019DGA\u0001\n\u0003z\u0005\u0002CA\u001b5\u0005\u0005I\u0011\u0001\"\t\u0013\u0005]\"$!A\u0005\u0002\u0005m\u0004\"CA#5\u0005\u0005I\u0011IA$\u0011%\t)FGA\u0001\n\u0003\ty\bC\u0005\u0002bi\t\t\u0011\"\u0011\u0002d!I\u0011Q\r\u000e\u0002\u0002\u0013\u0005\u0013q\r\u0005\n\u0003SR\u0012\u0011!C\u0005\u0003W:q!!\"\u0017\u0011\u0003\u000b\tDB\u0004\u0002\"YA\t)a\t\t\ru*C\u0011AA\u0018\u0011!\t\u0019$JA\u0001\n\u0003z\u0005\u0002CA\u001bK\u0005\u0005I\u0011\u0001\"\t\u0013\u0005]R%!A\u0005\u0002\u0005e\u0002\"CA#K\u0005\u0005I\u0011IA$\u0011%\t)&JA\u0001\n\u0003\t9\u0006C\u0005\u0002b\u0015\n\t\u0011\"\u0011\u0002d!I\u0011QM\u0013\u0002\u0002\u0013\u0005\u0013q\r\u0005\n\u0003S*\u0013\u0011!C\u0005\u0003WB\u0011\"!\u001b\u0017\u0003\u0003%I!a\u001b\u0003#1{w\rR5s\r\u0006LG.\u001e:f)\u0016\u001cHO\u0003\u00023g\u000511/\u001a:wKJT\u0011\u0001N\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0007\u0005\u00029w5\t\u0011H\u0003\u0002;g\u0005\u0019\u0011\r]5\n\u0005qJ$AF%oi\u0016<'/\u0019;j_:$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005y\u0004C\u0001!\u0001\u001b\u0005\t\u0014!\u00049s_\u0012,8-\u001a:D_VtG/F\u0001D!\t!u)D\u0001F\u0015\u00051\u0015!B:dC2\f\u0017B\u0001%F\u0005\rIe\u000e^\u0001\u000faJ|G-^2fe\u000e{WO\u001c;!\u00035\u0019wN\\:v[\u0016\u00148i\\;oi\u0006q1m\u001c8tk6,'oQ8v]R\u0004\u0013aC:feZ,'oQ8v]R\fAb]3sm\u0016\u00148i\\;oi\u0002\nQ\u0001^8qS\u000e,\u0012\u0001\u0015\t\u0003#Zk\u0011A\u0015\u0006\u0003'R\u000bA\u0001\\1oO*\tQ+\u0001\u0003kCZ\f\u0017BA,S\u0005\u0019\u0019FO]5oO\u00061Ao\u001c9jG\u0002\nA\u0002]1si&$\u0018n\u001c8Ok6\fQ\u0002]1si&$\u0018n\u001c8Ok6\u0004\u0013a\u00037pO\u0012K'oQ8v]R\fA\u0002\\8h\t&\u00148i\\;oi\u0002\nQa]3u+B$\u0012a\u0018\t\u0003\t\u0002L!!Y#\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u001d\r\u0004\"\u0001Z5\u000e\u0003\u0015T!AZ4\u0002\u000b),h.\u001b;\u000b\u0003!\f1a\u001c:h\u0013\tQWM\u0001\u0004CK\u001a|'/Z\u0001\u001di\u0016\u001cH/S(Fq\u000e,\u0007\u000f^5p]\u0012+(/\u001b8h\u0019><'k\u001c7mQ\tyQ\u000e\u0005\u0002e]&\u0011q.\u001a\u0002\u0005)\u0016\u001cH/A\u001dce>\\WM],ji\"|E\u000eZ%oi\u0016\u0014(I]8lKJ\u0004&o\u001c;pG>d7\u000b[8vY\u0012D\u0015\r\u001c;P]2{w\rR5s\r\u0006LG.\u001e:fQ\t\u0001R.A\u0010uKN$\u0018jT#yG\u0016\u0004H/[8o\tV\u0014\u0018N\\4DQ\u0016\u001c7\u000e]8j]RD#!E7\u0002iQ,7\u000f\u001e*fa2L7-\u0019$fi\u000eDWM\u001d+ie\u0016\fG-\u00114uKJdun\u001a#je\u001a\u000b\u0017\u000e\\;sK>sgi\u001c7m_^,'\u000f\u000b\u0002\u0013[\u0006)C/Z:u!J|G-^2f\u0003\u001a$XM\u001d'pO\u0012K'OR1jYV\u0014Xm\u00148MK\u0006$WM\u001d\u000b\u0003?bDQ!_\nA\u0002i\f1BZ1jYV\u0014X\rV=qKB\u00111\u0010\u0007\b\u0003yVq1!`A\u0003\u001d\rq\u00181A\u0007\u0002\u007f*\u0019\u0011\u0011A\u001b\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0014B\u0001\u001a4\u0003Eaun\u001a#je\u001a\u000b\u0017\u000e\\;sKR+7\u000f\u001e\t\u0003\u0001Z\u0019RAFA\u0007\u0003'\u00012\u0001RA\b\u0013\r\t\t\"\u0012\u0002\u0007\u0003:L(+\u001a4\u0011\u0007\u0011\u000b)\"C\u0002\u0002\u0018\u0015\u0013AbU3sS\u0006d\u0017N_1cY\u0016$\"!!\u0003\u0003#1{w\rR5s\r\u0006LG.\u001e:f)f\u0004XmE\u0002\u0019\u0003\u001bI3\u0001G\u0013\u001b\u0005)\u0019\u0005.Z2la>Lg\u000e^\n\nK\u00055\u0011QEA\u0015\u0003'\u00012!a\n\u0019\u001b\u00051\u0002c\u0001#\u0002,%\u0019\u0011QF#\u0003\u000fA\u0013x\u000eZ;diR\u0011\u0011\u0011\u0007\t\u0004\u0003O)\u0013!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005m\u0012\u0011\t\t\u0004\t\u0006u\u0012bAA \u000b\n\u0019\u0011I\\=\t\u0011\u0005\r\u0013&!AA\u0002\r\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA%!\u0019\tY%!\u0015\u0002<5\u0011\u0011Q\n\u0006\u0004\u0003\u001f*\u0015AC2pY2,7\r^5p]&!\u00111KA'\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005e\u0013q\f\t\u0004\t\u0006m\u0013bAA/\u000b\n9!i\\8mK\u0006t\u0007\"CA\"W\u0005\u0005\t\u0019AA\u001e\u0003!A\u0017m\u001d5D_\u0012,G#A\"\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012\u0001U\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002nA\u0019\u0011+a\u001c\n\u0007\u0005E$K\u0001\u0004PE*,7\r\u001e\u0002\u0005%>dGnE\u0005\u001b\u0003\u001b\t)#!\u000b\u0002\u0014Q\u0011\u0011\u0011\u0010\t\u0004\u0003OQB\u0003BA\u001e\u0003{B\u0001\"a\u0011\u001f\u0003\u0003\u0005\ra\u0011\u000b\u0005\u00033\n\t\tC\u0005\u0002D\u0001\n\t\u00111\u0001\u0002<\u0005!!k\u001c7m\u0003)\u0019\u0005.Z2la>Lg\u000e^\u0001\u001egV\u00147o\u0019:jE\u0016\fe\u000eZ,bSR4uN]!tg&<g.\\3oiR)q,a#\u0002\u001c\"1a\n\u0006a\u0001\u0003\u001b\u0003B!a$\u0002\u0018:!\u0011\u0011SAJ!\tqX)C\u0002\u0002\u0016\u0016\u000ba\u0001\u0015:fI\u00164\u0017bA,\u0002\u001a*\u0019\u0011QS#\t\u000f\u0005uE\u00031\u0001\u0002 \u0006A1m\u001c8tk6,'\u000f\u0005\u0005\u0002\"\u0006=\u00161WAZ\u001b\t\t\u0019K\u0003\u0003\u0002\u001e\u0006\u0015&\u0002BAT\u0003S\u000bqa\u00197jK:$8OC\u00025\u0003WS1!!,h\u0003\u0019\t\u0007/Y2iK&!\u0011\u0011WAR\u00055Y\u0015MZ6b\u0007>t7/^7feB)A)!.\u0002:&\u0019\u0011qW#\u0003\u000b\u0005\u0013(/Y=\u0011\u0007\u0011\u000bY,C\u0002\u0002>\u0016\u0013AAQ=uK\u0002")
public class LogDirFailureTest
extends IntegrationTestHarness {
    private final int producerCount;
    private final int consumerCount;
    private final int serverCount;
    private final String topic;
    private final int partitionNum;
    private final int logDirCount;

    public int producerCount() {
        return this.producerCount;
    }

    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    private String topic() {
        return this.topic;
    }

    private int partitionNum() {
        return this.partitionNum;
    }

    @Override
    public int logDirCount() {
        return this.logDirCount;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.createTopic(this.topic(), this.partitionNum(), this.serverCount(), this.createTopic$default$4());
    }

    @Test
    public void testIOExceptionDuringLogRoll() {
        this.testProduceAfterLogDirFailureOnLeader(LogDirFailureTest$Roll$.MODULE$);
    }

    @Test
    public void brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure() {
        block3: {
            VolatileObjectRef statusCodeOption = VolatileObjectRef.create((Object)None$.MODULE$);
            Exit$.MODULE$.setHaltProcedure((Function2 & Serializable & scala.Serializable)(statusCode, x$1) -> LogDirFailureTest.$anonfun$brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure$1(statusCodeOption, BoxesRunTime.unboxToInt((Object)statusCode), x$1));
            KafkaServer server = null;
            try {
                int x$12 = this.serverCount();
                String x$2 = this.zkConnect();
                int x$3 = 3;
                boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
                boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
                int x$6 = TestUtils$.MODULE$.createBrokerConfig$default$5();
                Option<SecurityProtocol> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$6();
                Option<File> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$7();
                Option<Properties> x$9 = TestUtils$.MODULE$.createBrokerConfig$default$8();
                boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$9();
                boolean x$11 = TestUtils$.MODULE$.createBrokerConfig$default$10();
                int x$122 = TestUtils$.MODULE$.createBrokerConfig$default$11();
                boolean x$13 = TestUtils$.MODULE$.createBrokerConfig$default$12();
                int x$14 = TestUtils$.MODULE$.createBrokerConfig$default$13();
                boolean x$15 = TestUtils$.MODULE$.createBrokerConfig$default$14();
                int x$16 = TestUtils$.MODULE$.createBrokerConfig$default$15();
                Option<String> x$17 = TestUtils$.MODULE$.createBrokerConfig$default$16();
                boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
                Properties props = TestUtils$.MODULE$.createBrokerConfig(x$12, x$2, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$122, x$13, x$14, x$15, x$16, x$17, x$3, x$18);
                props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "0.11.0");
                props.put(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), "0.11.0");
                KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
                File logDir = new File((String)kafkaConfig.logDirs().head());
                CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Utils.delete((File)logDir), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
                logDir.createNewFile();
                Assert.assertTrue((boolean)logDir.isFile());
                server = TestUtils$.MODULE$.createServer(kafkaConfig, TestUtils$.MODULE$.createServer$default$2());
                TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((Option)statusCodeOption$1.elem).contains((Object)BoxesRunTime.boxToInteger((int)1)), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "timed out waiting for broker to halt", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            }
            catch (Throwable throwable) {
                Exit$.MODULE$.resetHaltProcedure();
                if (server != null) {
                    TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)new .colon.colon(server, (List)Nil$.MODULE$));
                }
                throw throwable;
            }
            Exit$.MODULE$.resetHaltProcedure();
            if (server == null) break block3;
            TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)new .colon.colon((Object)server, (List)Nil$.MODULE$));
        }
    }

    @Test
    public void testIOExceptionDuringCheckpoint() {
        this.testProduceAfterLogDirFailureOnLeader(LogDirFailureTest$Checkpoint$.MODULE$);
    }

    @Test
    public void testReplicaFetcherThreadAfterLogDirFailureOnFollower() {
        this.producerConfig().setProperty("retries", "0");
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.topic(), 0);
        PartitionInfo partitionInfo = (PartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(producer.partitionsFor(this.topic())).asScala()).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$1(x$2))).get();
        int leaderServerId = partitionInfo.leader().id();
        KafkaServer leaderServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$2(leaderServerId, x$3))).get();
        int followerServerId = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.replicas())).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$5 -> x$5 != leaderServerId).get());
        KafkaServer followerServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$5(followerServerId, x$6))).get();
        followerServer.replicaManager().markPartitionOffline(partition);
        int anotherPartitionWithTheSameLeader = BoxesRunTime.unboxToInt((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), this.partitionNum()).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> leaderServer.replicaManager().getPartition(new TopicPartition(this.topic(), i)).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> x$7.leaderReplicaIfLocal()).isDefined()).get());
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(anotherPartitionWithTheSameLeader), (Object)this.topic().getBytes(), (Object)"message".getBytes());
        producer.send(record).get();
        Assert.assertEquals((long)this.serverCount(), (long)((Partition)leaderServer.replicaManager().getPartition(new TopicPartition(this.topic(), anotherPartitionWithTheSameLeader)).get()).inSyncReplicas().size());
        followerServer.replicaManager().replicaFetcherManager().fetcherThreadMap().values().foreach((Function1 & Serializable & scala.Serializable)thread -> {
            LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$8(thread);
            return BoxedUnit.UNIT;
        });
    }

    public void testProduceAfterLogDirFailureOnLeader(LogDirFailureType failureType) {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        this.producerConfig().setProperty("retries", "0");
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.topic(), 0);
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
        int leaderServerId = ((PartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(producer.partitionsFor(this.topic())).asScala()).find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$1(x$8))).get()).leader().id();
        KafkaServer leaderServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$2(leaderServerId, x$9))).get();
        producer.send(record).get();
        TestUtils$.MODULE$.consumeRecords(consumer, 1, TestUtils$.MODULE$.consumeRecords$default$3());
        Replica replica = leaderServer.replicaManager().localReplicaOrException(partition);
        File logDir = ((Log)replica.log().get()).dir().getParentFile();
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Utils.delete((File)logDir), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
        logDir.createNewFile();
        Assert.assertTrue((boolean)logDir.isFile());
        LogDirFailureType logDirFailureType = failureType;
        LogDirFailureTest$Roll$ logDirFailureTest$Roll$ = LogDirFailureTest$Roll$.MODULE$;
        if (!(logDirFailureType != null ? !logDirFailureType.equals(logDirFailureTest$Roll$) : logDirFailureTest$Roll$ != null)) {
            try {
                Log qual$1 = (Log)leaderServer.replicaManager().getLog(partition).get();
                Option x$1 = qual$1.roll$default$1();
                qual$1.roll(x$1);
                throw this.fail("Log rolling should fail with KafkaStorageException", new Position("LogDirFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
            }
            catch (KafkaStorageException e) {}
        } else {
            LogDirFailureType logDirFailureType2 = failureType;
            LogDirFailureTest$Checkpoint$ logDirFailureTest$Checkpoint$ = LogDirFailureTest$Checkpoint$.MODULE$;
            if (!(logDirFailureType2 != null ? !logDirFailureType2.equals(logDirFailureTest$Checkpoint$) : logDirFailureTest$Checkpoint$ != null)) {
                leaderServer.replicaManager().checkpointHighWatermarks();
            }
        }
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !leaderServer.logManager().isLogDirOnline(logDir.getAbsolutePath()), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected log directory offline", 3000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertTrue((boolean)leaderServer.replicaManager().localReplica(partition).isEmpty());
        try {
            producer.send(record).get(6000L, TimeUnit.MILLISECONDS);
            throw this.fail("send() should fail with either KafkaStorageException or NotLeaderForPartitionException", new Position("LogDirFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof KafkaStorageException) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (throwable instanceof NotLeaderForPartitionException) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                if (throwable != null) {
                    Throwable throwable2 = throwable;
                    throw this.fail(new StringBuilder(98).append("send() should fail with either KafkaStorageException or NotLeaderForPartitionException instead of ").append(throwable2.toString()).toString(), new Position("LogDirFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
                }
                throw new MatchError((Object)throwable);
            }
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                producer.send(record);
                return ((PartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(producer.partitionsFor(this.topic())).asScala()).find((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$7(x$10))).get()).leader().id() != leaderServerId;
            }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected new leader for the partition", 6000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            producer.send(record).get(6000L, TimeUnit.MILLISECONDS);
            TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
            Assert.assertTrue((boolean)this.zkClient().getAllLogDirEventNotifications().isEmpty());
            KafkaServer controllerServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$9(x$11))).get();
            Set offlineReplicas = controllerServer.kafkaController().replicaStateMachine().replicasInState(this.topic(), (ReplicaState)OfflineReplica$.MODULE$);
            Assert.assertTrue((boolean)offlineReplicas.contains((Object)new PartitionAndReplica(new TopicPartition(this.topic(), 0), leaderServerId)));
            return;
        }
    }

    private void subscribeAndWaitForAssignment(String topic, KafkaConsumer<byte[], byte[]> consumer) {
        consumer.subscribe(Collections.singletonList(topic));
        TestUtils$.MODULE$.pollUntilTrue((Consumer<?, ?>)consumer, (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !consumer.assignment().isEmpty(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected non-empty assignment", TestUtils$.MODULE$.pollUntilTrue$default$4());
    }

    public static final /* synthetic */ Nothing$ $anonfun$brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure$1(VolatileObjectRef statusCodeOption$1, int statusCode, Option x$1) {
        statusCodeOption$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)statusCode));
        throw new IllegalArgumentException();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$1(PartitionInfo x$2) {
        return x$2.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$2(int leaderServerId$1, KafkaServer x$3) {
        return x$3.config().brokerId() == leaderServerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$5(int followerServerId$1, KafkaServer x$6) {
        return x$6.config().brokerId() == followerServerId$1;
    }

    public static final /* synthetic */ void $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$8(ReplicaFetcherThread thread) {
        Assert.assertFalse((String)"ReplicaFetcherThread should still be working if its partition count > 0", (boolean)thread.isShutdownComplete());
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$1(PartitionInfo x$8) {
        return x$8.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$2(int leaderServerId$2, KafkaServer x$9) {
        return x$9.config().brokerId() == leaderServerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$7(PartitionInfo x$10) {
        return x$10.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$9(KafkaServer x$11) {
        return x$11.kafkaController().isActive();
    }

    public LogDirFailureTest() {
        this.producerCount = 1;
        this.consumerCount = 1;
        this.serverCount = 2;
        this.topic = "topic";
        this.partitionNum = 12;
        this.logDirCount = 3;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ReplicaHighWatermarkCheckpointIntervalMsProp(), "60000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.NumReplicaFetchersProp(), "1");
    }

    public static interface LogDirFailureType {
    }
}

