/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.cluster.EndPoint;
import kafka.coordinator.group.OffsetConfig$;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.MultipleListenersWithSameSecurityProtocolBaseTest$;
import kafka.server.MultipleListenersWithSameSecurityProtocolBaseTest$ClientMetadata$;
import kafka.utils.Implicits$;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.ResizableArray;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t=x!\u0002 @\u0011\u0003!e!\u0002$@\u0011\u00039\u0005\"B)\u0002\t\u0003\u0011\u0006bB*\u0002\u0005\u0004%\t\u0001\u0016\u0005\u0007;\u0006\u0001\u000b\u0011B+\t\u000fy\u000b!\u0019!C\u0001)\"1q,\u0001Q\u0001\nUCq\u0001Y\u0001C\u0002\u0013\u0005A\u000b\u0003\u0004b\u0003\u0001\u0006I!\u0016\u0005\bE\u0006\u0011\r\u0011\"\u0001U\u0011\u0019\u0019\u0017\u0001)A\u0005+\"9A-\u0001b\u0001\n\u0003!\u0006BB3\u0002A\u0003%Q\u000bC\u0004g\u0003\t\u0007I\u0011\u0001+\t\r\u001d\f\u0001\u0015!\u0003V\u0011\u001dA\u0017!!A\u0005\n%4QAR \u0002\u00025DQ!\u0015\t\u0005\u0002iDq\u0001 \tC\u0002\u0013%Q\u0010C\u0004\u0002\nA\u0001\u000b\u0011\u0002@\t\u0013\u0005-\u0001C1A\u0005\n\u00055\u0001\u0002CA\u0013!\u0001\u0006I!a\u0004\t\u0013\u0005\u001d\u0002C1A\u0005\n\u0005%\u0002\u0002\u0003B\u0007!\u0001\u0006I!a\u000b\t\u0013\t=\u0001C1A\u0005\n\tE\u0001\u0002\u0003B\u0011!\u0001\u0006IAa\u0005\t\u0011\t\r\u0002C1A\u0005\u0012QCqA!\n\u0011A\u0003%Q\u000bC\u0005\u0003(A\u0011\r\u0011\"\u0005\u0003*!A!1\b\t!\u0002\u0013\u0011Y\u0003C\u0004\u0003>A1\tBa\u0010\t\u000f\t-\u0004C\"\u0005\u0003n!9!1\u0010\t\u0005B\tu\u0004b\u0002BJ!\u0011\u0005#Q\u0010\u0005\b\u0005;\u0003B\u0011\u0001B?\u0011\u001d\u00119\u000b\u0005C\t\u0005S3a!!\u000e\u0011\u0001\u0006]\u0002BCA I\tU\r\u0011\"\u0001\u0002B!Q\u0011Q\f\u0013\u0003\u0012\u0003\u0006I!a\u0011\t\u0015\u0005}CE!f\u0001\n\u0003\t\t\u0007\u0003\u0006\u0002x\u0011\u0012\t\u0012)A\u0005\u0003GB!\"!\u001f%\u0005+\u0007I\u0011AA1\u0011)\tY\b\nB\tB\u0003%\u00111\r\u0005\u0007#\u0012\"\t!! \t\u000f\u0005\u0015E\u0005\"\u0011\u0002\b\"9\u0011q\u0012\u0013\u0005B\u0005E\u0005bBARI\u0011\u0005\u0013Q\u0015\u0005\n\u0003O#\u0013\u0011!C\u0001\u0003SC\u0011\"!-%#\u0003%\t!a-\t\u0013\u0005%G%%A\u0005\u0002\u0005-\u0007\"CAhIE\u0005I\u0011AAf\u0011!\t\t\u000eJA\u0001\n\u0003\"\u0006\"CAjI\u0005\u0005I\u0011AAk\u0011%\t9\u000eJA\u0001\n\u0003\tI\u000eC\u0005\u0002`\u0012\n\t\u0011\"\u0011\u0002b\"I\u00111\u001e\u0013\u0002\u0002\u0013\u0005\u0011Q^\u0004\n\u0005w\u0003\u0012\u0011!E\u0001\u0005{3\u0011\"!\u000e\u0011\u0003\u0003E\tAa0\t\rEKD\u0011\u0001Bg\u0011%\t\u0019+OA\u0001\n\u000b\u0012y\rC\u0005\u0003Rf\n\t\u0011\"!\u0003T\"I!1\\\u001d\u0002\u0002\u0013\u0005%Q\\\u00012\u001bVdG/\u001b9mK2K7\u000f^3oKJ\u001cx+\u001b;i'\u0006lWmU3dkJLG/\u001f)s_R|7m\u001c7CCN,G+Z:u\u0015\t\u0001\u0015)\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0005\u0006)1.\u00194lC\u000e\u0001\u0001CA#\u0002\u001b\u0005y$!M'vYRL\u0007\u000f\\3MSN$XM\\3sg^KG\u000f[*b[\u0016\u001cVmY;sSRL\bK]8u_\u000e|GNQ1tKR+7\u000f^\n\u0004\u0003!s\u0005CA%M\u001b\u0005Q%\"A&\u0002\u000bM\u001c\u0017\r\\1\n\u00055S%AB!osJ+g\r\u0005\u0002J\u001f&\u0011\u0001K\u0013\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0011\u000babU3dkJ,\u0017J\u001c;fe:\fG.F\u0001V!\t16,D\u0001X\u0015\tA\u0016,\u0001\u0003mC:<'\"\u0001.\u0002\t)\fg/Y\u0005\u00039^\u0013aa\u0015;sS:<\u0017aD*fGV\u0014X-\u00138uKJt\u0017\r\u001c\u0011\u0002\u001dM+7-\u001e:f\u000bb$XM\u001d8bY\u0006y1+Z2ve\u0016,\u0005\u0010^3s]\u0006d\u0007%\u0001\u0005J]R,'O\\1m\u0003%Ie\u000e^3s]\u0006d\u0007%\u0001\u0005FqR,'O\\1m\u0003%)\u0005\u0010^3s]\u0006d\u0007%\u0001\u0004HgN\f\u0005/[\u0001\b\u000fN\u001c\u0018\t]5!\u0003\u0015\u0001F.Y5o\u0003\u0019\u0001F.Y5oA\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005Q\u0007C\u0001,l\u0013\tawK\u0001\u0004PE*,7\r^\n\u0004!9$\bCA8s\u001b\u0005\u0001(BA9B\u0003\tQ8.\u0003\u0002ta\n!\"l\\8LK\u0016\u0004XM\u001d+fgRD\u0015M\u001d8fgN\u0004\"!\u001e=\u000e\u0003YT!a^!\u0002\u0007\u0005\u0004\u0018.\u0003\u0002zm\nI1+Y:m'\u0016$X\u000f\u001d\u000b\u0002wB\u0011Q\tE\u0001\u000fiJ,8\u000f^*u_J,g)\u001b7f+\u0005q\bcA@\u0002\u00065\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007I\u0016AA5p\u0013\u0011\t9!!\u0001\u0003\t\u0019KG.Z\u0001\u0010iJ,8\u000f^*u_J,g)\u001b7fA\u000591/\u001a:wKJ\u001cXCAA\b!\u0019\t\t\"a\u0007\u0002 5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"A\u0004nkR\f'\r\\3\u000b\u0007\u0005e!*\u0001\u0006d_2dWm\u0019;j_:LA!!\b\u0002\u0014\tY\u0011I\u001d:bs\n+hMZ3s!\r)\u0015\u0011E\u0005\u0004\u0003Gy$aC&bM.\f7+\u001a:wKJ\f\u0001b]3sm\u0016\u00148\u000fI\u0001\naJ|G-^2feN,\"!a\u000b\u0011\u0011\u0005E\u0011QFA\u0019\u0003cLA!a\f\u0002\u0014\t\u0019Q*\u00199\u0011\u0007\u0005MB%D\u0001\u0011\u00059\u0019E.[3oi6+G/\u00193bi\u0006\u001cR\u0001\n%\u0002:9\u00032!SA\u001e\u0013\r\tiD\u0013\u0002\b!J|G-^2u\u00031a\u0017n\u001d;f]\u0016\u0014h*Y7f+\t\t\u0019\u0005\u0005\u0003\u0002F\u0005eSBAA$\u0015\u0011\tI%a\u0013\u0002\u000f9,Go^8sW*!\u0011QJA(\u0003\u0019\u0019w.\\7p]*\u0019!)!\u0015\u000b\t\u0005M\u0013QK\u0001\u0007CB\f7\r[3\u000b\u0005\u0005]\u0013aA8sO&!\u00111LA$\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f\u00035a\u0017n\u001d;f]\u0016\u0014h*Y7fA\u0005i1/Y:m\u001b\u0016\u001c\u0007.\u00198jg6,\"!a\u0019\u0011\t\u0005\u0015\u00141\u000f\b\u0005\u0003O\ny\u0007E\u0002\u0002j)k!!a\u001b\u000b\u0007\u000554)\u0001\u0004=e>|GOP\u0005\u0004\u0003cR\u0015A\u0002)sK\u0012,g-C\u0002]\u0003kR1!!\u001dK\u00039\u0019\u0018m\u001d7NK\u000eD\u0017M\\5t[\u0002\nQ\u0001^8qS\u000e\fa\u0001^8qS\u000e\u0004C\u0003CA\u0019\u0003\u007f\n\t)a!\t\u000f\u0005}2\u00061\u0001\u0002D!9\u0011qL\u0016A\u0002\u0005\r\u0004bBA=W\u0001\u0007\u00111M\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011\u0011\u0012\t\u0004\u0013\u0006-\u0015bAAG\u0015\n\u0019\u0011J\u001c;\u0002\r\u0015\fX/\u00197t)\u0011\t\u0019*!'\u0011\u0007%\u000b)*C\u0002\u0002\u0018*\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0002\u001c6\u0002\r!!(\u0002\u0007=\u0014'\u000eE\u0002J\u0003?K1!!)K\u0005\r\te._\u0001\ti>\u001cFO]5oOR\u0011\u00111M\u0001\u0005G>\u0004\u0018\u0010\u0006\u0005\u00022\u0005-\u0016QVAX\u0011%\tyd\fI\u0001\u0002\u0004\t\u0019\u0005C\u0005\u0002`=\u0002\n\u00111\u0001\u0002d!I\u0011\u0011P\u0018\u0011\u0002\u0003\u0007\u00111M\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t)L\u000b\u0003\u0002D\u0005]6FAA]!\u0011\tY,!2\u000e\u0005\u0005u&\u0002BA`\u0003\u0003\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\r'*\u0001\u0006b]:|G/\u0019;j_:LA!a2\u0002>\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u001a\u0016\u0005\u0003G\n9,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tI)\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005u\u00151\u001c\u0005\n\u0003;,\u0014\u0011!a\u0001\u0003\u0013\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAr!\u0019\t)/a:\u0002\u001e6\u0011\u0011qC\u0005\u0005\u0003S\f9B\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAJ\u0003_D\u0011\"!88\u0003\u0003\u0005\r!!(\u0011\u0011\u0005M\u0018Q B\u0001\u0005\u0003i!!!>\u000b\t\u0005]\u0018\u0011`\u0001\taJ|G-^2fe*!\u00111`A(\u0003\u001d\u0019G.[3oiNLA!a@\u0002v\ni1*\u00194lCB\u0013x\u000eZ;dKJ\u0004R!\u0013B\u0002\u0005\u000fI1A!\u0002K\u0005\u0015\t%O]1z!\rI%\u0011B\u0005\u0004\u0005\u0017Q%\u0001\u0002\"zi\u0016\f!\u0002\u001d:pIV\u001cWM]:!\u0003%\u0019wN\\:v[\u0016\u00148/\u0006\u0002\u0003\u0014AA\u0011\u0011CA\u0017\u0003c\u0011)\u0002\u0005\u0005\u0003\u0018\tu!\u0011\u0001B\u0001\u001b\t\u0011IB\u0003\u0003\u0003\u001c\u0005e\u0018\u0001C2p]N,X.\u001a:\n\t\t}!\u0011\u0004\u0002\u000e\u0017\u000647.Y\"p]N,X.\u001a:\u0002\u0015\r|gn];nKJ\u001c\b%\u0001\rlC\u001a\\\u0017m\u00117jK:$8+Y:m\u001b\u0016\u001c\u0007.\u00198jg6\f\u0011d[1gW\u0006\u001cE.[3oiN\u000b7\u000f\\'fG\"\fg.[:nA\u0005I2.\u00194lCN+'O^3s'\u0006\u001cH.T3dQ\u0006t\u0017n]7t+\t\u0011Y\u0003E\u0004\u0003.\tMRK!\u000e\u000e\u0005\t=\"\u0002\u0002B\u0019\u0003/\t\u0011\"[7nkR\f'\r\\3\n\t\u0005=\"q\u0006\t\u0006\u0003K\u00149$V\u0005\u0005\u0005s\t9BA\u0002TKF\f!d[1gW\u0006\u001cVM\u001d<feN\u000b7\u000f\\'fG\"\fg.[:ng\u0002\n!c\u001d;bi&\u001c'*Y1t'\u0016\u001cG/[8ogV\u0011!\u0011\t\t\u0007\u0005\u0007\u0012iE!\u0015\u000f\t\t\u0015#\u0011\n\b\u0005\u0003S\u00129%C\u0001L\u0013\r\u0011YES\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011IDa\u0014\u000b\u0007\t-#\n\u0005\u0003\u0003T\t\u0015d\u0002\u0002B+\u0005?rAAa\u0016\u0003\\9!\u0011\u0011\u000eB-\u0013\u0005\u0011\u0015b\u0001B/\u0003\u0006)Q\u000f^5mg&!!\u0011\rB2\u00035Q\u0015-Y:UKN$X\u000b^5mg*\u0019!QL!\n\t\t\u001d$\u0011\u000e\u0002\f\u0015\u0006\f7oU3di&|gN\u0003\u0003\u0003b\t\r\u0014a\u00053z]\u0006l\u0017n\u0019&bCN\u001cVm\u0019;j_:\u001cXC\u0001B8!\u0011\u0011\tHa\u001e\u000e\u0005\tM$b\u0001B;3\u0006!Q\u000f^5m\u0013\u0011\u0011IHa\u001d\u0003\u0015A\u0013x\u000e]3si&,7/A\u0003tKR,\u0006\u000f\u0006\u0002\u0003\u0000A\u0019\u0011J!!\n\u0007\t\r%J\u0001\u0003V]&$\bf\u0001\u0011\u0003\bB!!\u0011\u0012BH\u001b\t\u0011YI\u0003\u0003\u0003\u000e\u0006U\u0013!\u00026v]&$\u0018\u0002\u0002BI\u0005\u0017\u0013aAQ3g_J,\u0017\u0001\u0003;fCJ$un\u001e8)\u0007\u0005\u00129\n\u0005\u0003\u0003\n\ne\u0015\u0002\u0002BN\u0005\u0017\u0013Q!\u00114uKJ\f!\u0003^3tiB\u0013x\u000eZ;dK\u000e{gn];nK\"\u001a!E!)\u0011\t\t%%1U\u0005\u0005\u0005K\u0013YI\u0001\u0003UKN$\u0018!F1eI\u0012Kh.Y7jG*\u000b\u0017m]*fGRLwN\u001c\u000b\u000b\u0005\u007f\u0012YKa,\u00034\n]\u0006b\u0002BWG\u0001\u0007!qN\u0001\u0006aJ|\u0007o\u001d\u0005\b\u0005c\u001b\u0003\u0019AA2\u0003!a\u0017n\u001d;f]\u0016\u0014\bb\u0002B[G\u0001\u0007\u00111M\u0001\n[\u0016\u001c\u0007.\u00198jg6DqA!/$\u0001\u0004\u0011\t&A\u0006kC\u0006\u001c8+Z2uS>t\u0017AD\"mS\u0016tG/T3uC\u0012\fG/\u0019\t\u0004\u0003gI4\u0003B\u001d\u0003B:\u0003BBa1\u0003J\u0006\r\u00131MA2\u0003ci!A!2\u000b\u0007\t\u001d'*A\u0004sk:$\u0018.\\3\n\t\t-'Q\u0019\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001cDC\u0001B_)\u0005)\u0016!B1qa2LH\u0003CA\u0019\u0005+\u00149N!7\t\u000f\u0005}B\b1\u0001\u0002D!9\u0011q\f\u001fA\u0002\u0005\r\u0004bBA=y\u0001\u0007\u00111M\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011yNa;\u0011\u000b%\u0013\tO!:\n\u0007\t\r(J\u0001\u0004PaRLwN\u001c\t\n\u0013\n\u001d\u00181IA2\u0003GJ1A!;K\u0005\u0019!V\u000f\u001d7fg!I!Q^\u001f\u0002\u0002\u0003\u0007\u0011\u0011G\u0001\u0004q\u0012\u0002\u0004")
public abstract class MultipleListenersWithSameSecurityProtocolBaseTest
extends ZooKeeperTestHarness
implements SaslSetup {
    private volatile MultipleListenersWithSameSecurityProtocolBaseTest$ClientMetadata$ ClientMetadata$module;
    private final File trustStoreFile;
    private final ArrayBuffer<KafkaServer> servers;
    private final Map<ClientMetadata, KafkaProducer<byte[], byte[]>> producers;
    private final Map<ClientMetadata, KafkaConsumer<byte[], byte[]>> consumers;
    private final String kafkaClientSaslMechanism;
    private final scala.collection.immutable.Map<String, Seq<String>> kafkaServerSaslMechanisms;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    public static String Plain() {
        return MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.Plain();
    }

    public static String GssApi() {
        return MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.GssApi();
    }

    public static String External() {
        return MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.External();
    }

    public static String Internal() {
        return MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.Internal();
    }

    public static String SecureExternal() {
        return MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureExternal();
    }

    public static String SecureInternal() {
        return MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureInternal();
    }

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$(this, zkConnect, userName, password);
    }

    public MultipleListenersWithSameSecurityProtocolBaseTest$ClientMetadata$ ClientMetadata() {
        if (this.ClientMetadata$module == null) {
            this.ClientMetadata$lzycompute$1();
        }
        return this.ClientMetadata$module;
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    private File trustStoreFile() {
        return this.trustStoreFile;
    }

    private ArrayBuffer<KafkaServer> servers() {
        return this.servers;
    }

    private Map<ClientMetadata, KafkaProducer<byte[], byte[]>> producers() {
        return this.producers;
    }

    private Map<ClientMetadata, KafkaConsumer<byte[], byte[]>> consumers() {
        return this.consumers;
    }

    public String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    public scala.collection.immutable.Map<String, Seq<String>> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    public abstract Seq<JaasTestUtils.JaasSection> staticJaasSections();

    public abstract Properties dynamicJaasSections();

    @Override
    @Before
    public void setUp() {
        this.startSasl(this.staticJaasSections());
        super.setUp();
        int numServers = 2;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numServers).foreach((Function1 & Serializable & scala.Serializable)brokerId -> MultipleListenersWithSameSecurityProtocolBaseTest.$anonfun$setUp$1(this, BoxesRunTime.unboxToInt((Object)brokerId)));
        ((ResizableArray)this.servers().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.config(), ArrayBuffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)config -> {
            MultipleListenersWithSameSecurityProtocolBaseTest.$anonfun$setUp$4(config);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.createTopic(this.zkClient(), "__consumer_offsets", OffsetConfig$.MODULE$.DefaultOffsetsTopicNumPartitions(), 2, (Seq<KafkaServer>)this.servers(), ((KafkaServer)this.servers().head()).groupCoordinator().offsetsTopicConfigs());
        this.createScramCredentials(this.zkConnect(), JaasTestUtils$.MODULE$.KafkaScramUser(), JaasTestUtils$.MODULE$.KafkaScramPassword());
        ((KafkaServer)this.servers().head()).config().listeners().foreach((Function1 & Serializable & scala.Serializable)endPoint -> {
            MultipleListenersWithSameSecurityProtocolBaseTest.$anonfun$setUp$5(this, endPoint);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    @After
    public void tearDown() {
        this.producers().values().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        this.consumers().values().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.close();
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)this.servers());
        super.tearDown();
        this.closeSasl();
    }

    @Test
    public void testProduceConsume() {
        this.producers().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ClientMetadata clientMetadata = (ClientMetadata)tuple2._1();
            KafkaProducer producer = (KafkaProducer)tuple2._2();
            IndexedSeq producerRecords = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)i -> MultipleListenersWithSameSecurityProtocolBaseTest.$anonfun$testProduceConsume$2(clientMetadata, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            ((TraversableLike)producerRecords.map((Function1 & Serializable & scala.Serializable)x$1 -> producer.send(x$1), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$4 -> (RecordMetadata)x$4.get(10L, TimeUnit.SECONDS), IndexedSeq$.MODULE$.canBuildFrom());
            KafkaConsumer consumer = (KafkaConsumer)this.consumers().apply((Object)clientMetadata);
            consumer.subscribe(Collections.singleton(clientMetadata.topic()));
            Seq seq = TestUtils$.MODULE$.consumeRecords(consumer, producerRecords.size(), TestUtils$.MODULE$.consumeRecords$default$3());
            return seq;
        });
    }

    public void addDynamicJaasSection(Properties props, String listener, String mechanism, JaasTestUtils.JaasSection jaasSection) {
        ListenerName listenerName = new ListenerName(listener);
        String prefix = listenerName.saslMechanismConfigPrefix(mechanism);
        String jaasConfig = ((JaasTestUtils.JaasModule)jaasSection.modules().head()).toString();
        props.put(new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.SaslJaasConfigProp()).toString(), jaasConfig);
    }

    private final void ClientMetadata$lzycompute$1() {
        MultipleListenersWithSameSecurityProtocolBaseTest multipleListenersWithSameSecurityProtocolBaseTest = this;
        synchronized (multipleListenersWithSameSecurityProtocolBaseTest) {
            if (this.ClientMetadata$module == null) {
                this.ClientMetadata$module = new MultipleListenersWithSameSecurityProtocolBaseTest$ClientMetadata$(this);
            }
        }
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$setUp$1(MultipleListenersWithSameSecurityProtocolBaseTest $this, int brokerId) {
        int x$1 = brokerId;
        String x$2 = $this.zkConnect();
        Some x$3 = new Some((Object)$this.trustStoreFile());
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        int x$6 = TestUtils$.MODULE$.createBrokerConfig$default$5();
        Option<SecurityProtocol> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$6, x$7, (Option<File>)x$3, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18);
        props.put(KafkaConfig$.MODULE$.ListenersProp(), new StringBuilder(32).append(MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureInternal()).append("://localhost:0, ").append(MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.Internal()).append("://localhost:0, ").append(new StringBuilder(30).append(MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureExternal()).append("://localhost:0, ").append(MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.External()).append("://localhost:0").toString()).toString());
        props.put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), new StringBuilder(22).append(MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.Internal()).append(":PLAINTEXT, ").append(MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureInternal()).append(":SASL_SSL,").append(new StringBuilder(21).append(MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.External()).append(":PLAINTEXT, ").append(MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureExternal()).append(":SASL_SSL").toString()).toString());
        props.put(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.Internal());
        props.put(KafkaConfig$.MODULE$.ZkEnableSecureAclsProp(), "true");
        props.put(KafkaConfig$.MODULE$.SaslMechanismInterBrokerProtocolProp(), $this.kafkaClientSaslMechanism());
        props.put(new StringBuilder(0).append(new ListenerName(MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureInternal()).configPrefix()).append(KafkaConfig$.MODULE$.SaslEnabledMechanismsProp()).toString(), ((TraversableOnce)$this.kafkaServerSaslMechanisms().apply((Object)MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureInternal())).mkString(","));
        props.put(new StringBuilder(0).append(new ListenerName(MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureExternal()).configPrefix()).append(KafkaConfig$.MODULE$.SaslEnabledMechanismsProp()).toString(), ((TraversableOnce)$this.kafkaServerSaslMechanisms().apply((Object)MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureExternal())).mkString(","));
        props.put(KafkaConfig$.MODULE$.SaslKerberosServiceNameProp(), "kafka");
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq($this.dynamicJaasSections());
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(TestUtils$.MODULE$.sslConfigs(Mode.SERVER, false, (Option<File>)new Some((Object)$this.trustStoreFile()), new StringBuilder(6).append("server").append(brokerId).toString(), TestUtils$.MODULE$.sslConfigs$default$5()));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureInternal(), MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureExternal()}))).foreach((Function1 & Serializable & scala.Serializable)listenerName -> props.put(new StringBuilder(21).append(new ListenerName(listenerName).configPrefix()).append("ssl.keystore.location").toString(), props.get("ssl.keystore.location")));
        props.put("ssl.keystore.location", "invalid/file/path");
        return $this.servers().$plus$eq((Object)TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2()));
    }

    public static final /* synthetic */ void $anonfun$setUp$4(KafkaConfig config) {
        Assert.assertEquals((String)new StringBuilder(37).append("Unexpected listener count for broker ").append(config.brokerId()).toString(), (long)4L, (long)config.listeners().size());
        Assert.assertEquals((String)new StringBuilder(23).append("Unexpected ").append(KafkaConfig$.MODULE$.InterBrokerListenerNameProp()).append(" for broker ").append(config.brokerId()).toString(), (Object)MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.Internal(), (Object)config.interBrokerListenerName().value());
    }

    private final void addProducerConsumer$1(ListenerName listenerName, String mechanism, Option saslProps, String bootstrapServers$1, EndPoint endPoint$1, Option trustStoreFile$1) {
        String topic = new StringBuilder(0).append(listenerName.value()).append(this.producers().size()).toString();
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 2, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        ClientMetadata clientMetadata = new ClientMetadata(this, listenerName, mechanism, topic);
        String x$1 = bootstrapServers$1;
        int x$2 = -1;
        SecurityProtocol x$3 = endPoint$1.securityProtocol();
        Option x$4 = trustStoreFile$1;
        Option x$5 = saslProps;
        long x$6 = TestUtils$.MODULE$.createProducer$default$3();
        long x$7 = TestUtils$.MODULE$.createProducer$default$4();
        int x$8 = TestUtils$.MODULE$.createProducer$default$5();
        int x$9 = TestUtils$.MODULE$.createProducer$default$6();
        int x$10 = TestUtils$.MODULE$.createProducer$default$7();
        int x$11 = TestUtils$.MODULE$.createProducer$default$8();
        String x$12 = TestUtils$.MODULE$.createProducer$default$9();
        int x$13 = TestUtils$.MODULE$.createProducer$default$10();
        ByteArraySerializer x$14 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$15 = TestUtils$.MODULE$.createProducer$default$15();
        this.producers().update((Object)clientMetadata, TestUtils$.MODULE$.createProducer(x$1, x$2, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$3, (Option<File>)x$4, (Option<Properties>)x$5, x$14, x$15));
        String x$16 = bootstrapServers$1;
        String x$17 = clientMetadata.toString();
        SecurityProtocol x$18 = endPoint$1.securityProtocol();
        Option x$19 = trustStoreFile$1;
        Option x$20 = saslProps;
        String x$21 = TestUtils$.MODULE$.createConsumer$default$3();
        boolean x$22 = TestUtils$.MODULE$.createConsumer$default$4();
        boolean x$23 = TestUtils$.MODULE$.createConsumer$default$5();
        int x$24 = TestUtils$.MODULE$.createConsumer$default$6();
        ByteArrayDeserializer x$25 = TestUtils$.MODULE$.createConsumer$default$10();
        ByteArrayDeserializer x$26 = TestUtils$.MODULE$.createConsumer$default$11();
        this.consumers().update((Object)clientMetadata, TestUtils$.MODULE$.createConsumer(x$16, x$17, x$21, x$22, x$23, x$24, x$18, (Option<File>)x$19, (Option<Properties>)x$20, x$25, x$26));
    }

    public static final /* synthetic */ void $anonfun$setUp$5(MultipleListenersWithSameSecurityProtocolBaseTest $this, EndPoint endPoint) {
        ListenerName listenerName = endPoint.listenerName();
        None$ trustStoreFile = TestUtils$.MODULE$.usesSslTransportLayer(endPoint.securityProtocol()) ? new Some((Object)$this.trustStoreFile()) : None$.MODULE$;
        String bootstrapServers = TestUtils$.MODULE$.bootstrapServers((Seq<KafkaServer>)$this.servers(), listenerName);
        if (TestUtils$.MODULE$.usesSaslAuthentication(endPoint.securityProtocol())) {
            ((IterableLike)$this.kafkaServerSaslMechanisms().apply((Object)endPoint.listenerName().value())).foreach(arg_0 -> MultipleListenersWithSameSecurityProtocolBaseTest.$anonfun$setUp$6$adapted($this, listenerName, bootstrapServers, endPoint, (Option)trustStoreFile, arg_0));
        } else {
            $this.addProducerConsumer$1(listenerName, "", (Option)None$.MODULE$, bootstrapServers, endPoint, (Option)trustStoreFile);
        }
    }

    public static final /* synthetic */ ProducerRecord $anonfun$testProduceConsume$2(ClientMetadata clientMetadata$1, int i) {
        return new ProducerRecord(clientMetadata$1.topic(), (Object)new StringBuilder(3).append("key").append(i).toString().getBytes(), (Object)new StringBuilder(5).append("value").append(i).toString().getBytes());
    }

    public MultipleListenersWithSameSecurityProtocolBaseTest() {
        SaslSetup.$init$(this);
        this.trustStoreFile = File.createTempFile("truststore", ".jks");
        this.servers = new ArrayBuffer();
        this.producers = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.consumers = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.kafkaClientSaslMechanism = MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.Plain();
        this.kafkaServerSaslMechanisms = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureExternal()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-256", MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.GssApi()}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureInternal()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.Plain(), "SCRAM-SHA-512"})))}));
    }

    public static final /* synthetic */ Object $anonfun$setUp$6$adapted(MultipleListenersWithSameSecurityProtocolBaseTest $this, ListenerName listenerName$1, String bootstrapServers$1, EndPoint endPoint$1, Option trustStoreFile$1, String mechanism) {
        $this.addProducerConsumer$1(listenerName$1, mechanism, (Option)new Some((Object)$this.kafkaClientSaslProperties(mechanism, true)), bootstrapServers$1, endPoint$1, trustStoreFile$1);
        return BoxedUnit.UNIT;
    }

    public class ClientMetadata
    implements Product,
    scala.Serializable {
        private final ListenerName listenerName;
        private final String saslMechanism;
        private final String topic;
        public final /* synthetic */ MultipleListenersWithSameSecurityProtocolBaseTest $outer;

        public ListenerName listenerName() {
            return this.listenerName;
        }

        public String saslMechanism() {
            return this.saslMechanism;
        }

        public String topic() {
            return this.topic;
        }

        public int hashCode() {
            return Objects.hash(this.listenerName(), this.saslMechanism());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            Object object = obj;
            if (!(object instanceof ClientMetadata)) return false;
            if (((ClientMetadata)object).kafka$server$MultipleListenersWithSameSecurityProtocolBaseTest$ClientMetadata$$$outer() != this.kafka$server$MultipleListenersWithSameSecurityProtocolBaseTest$ClientMetadata$$$outer()) return false;
            ClientMetadata clientMetadata = (ClientMetadata)object;
            ListenerName listenerName = this.listenerName();
            ListenerName listenerName2 = clientMetadata.listenerName();
            if (listenerName == null) {
                if (listenerName2 != null) {
                    return false;
                }
            } else if (!listenerName.equals(listenerName2)) return false;
            String string = this.saslMechanism();
            String string2 = clientMetadata.saslMechanism();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.topic();
            String string4 = clientMetadata.topic();
            if (string3 == null) {
                if (string4 == null) return true;
                return false;
            } else {
                if (!string3.equals(string4)) return false;
                return true;
            }
        }

        public String toString() {
            return new StringBuilder(2).append(this.listenerName().value()).append(":").append(this.saslMechanism()).append(":").append(this.topic()).toString();
        }

        public ClientMetadata copy(ListenerName listenerName, String saslMechanism, String topic) {
            return new ClientMetadata(this.kafka$server$MultipleListenersWithSameSecurityProtocolBaseTest$ClientMetadata$$$outer(), listenerName, saslMechanism, topic);
        }

        public ListenerName copy$default$1() {
            return this.listenerName();
        }

        public String copy$default$2() {
            return this.saslMechanism();
        }

        public String copy$default$3() {
            return this.topic();
        }

        public String productPrefix() {
            return "ClientMetadata";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.listenerName();
                    break;
                }
                case 1: {
                    object = this.saslMechanism();
                    break;
                }
                case 2: {
                    object = this.topic();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ClientMetadata;
        }

        public /* synthetic */ MultipleListenersWithSameSecurityProtocolBaseTest kafka$server$MultipleListenersWithSameSecurityProtocolBaseTest$ClientMetadata$$$outer() {
            return this.$outer;
        }

        public ClientMetadata(MultipleListenersWithSameSecurityProtocolBaseTest $outer, ListenerName listenerName, String saslMechanism, String topic) {
            this.listenerName = listenerName;
            this.saslMechanism = saslMechanism;
            this.topic = topic;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

