/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Properties;
import kafka.log.LogConfig$;
import kafka.message.ZStdCompressionCodec$;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y3A\u0001C\u0005\u0001\u001d!)1\u0003\u0001C\u0001)!)a\u0003\u0001C\u0001/!)q\u0005\u0001C\u0001/!)\u0011\u0006\u0001C\u0005U!)a\b\u0001C\u0001/!)\u0001\t\u0001C\u0001/!)!\t\u0001C\u0005\u0007\n\u0011\u0002K]8ek\u000e,'+Z9vKN$H+Z:u\u0015\tQ1\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0019\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0010!\t\u0001\u0012#D\u0001\n\u0013\t\u0011\u0012BA\bCCN,'+Z9vKN$H+Z:u\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0011\u0001\u0005AB/Z:u'&l\u0007\u000f\\3Qe>$WoY3SKF,Xm\u001d;\u0015\u0003a\u0001\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u0011A!\u00168ji\"\u0012!a\b\t\u0003A\u0015j\u0011!\t\u0006\u0003E\r\nQA[;oSRT\u0011\u0001J\u0001\u0004_J<\u0017B\u0001\u0014\"\u0005\u0011!Vm\u001d;\u0002/Q,7\u000f\u001e)s_\u0012,8-\u001a+p\u001d>t'+\u001a9mS\u000e\f\u0007FA\u0002 \u0003\u0015\u001a'/Z1uKR{\u0007/[2B]\u00124\u0015N\u001c3QCJ$\u0018\u000e^5p]^KG\u000f\u001b'fC\u0012,'\u000f\u0006\u0002,cA!\u0011\u0004\f\u0018/\u0013\ti#D\u0001\u0004UkBdWM\r\t\u00033=J!\u0001\r\u000e\u0003\u0007%sG\u000fC\u00033\t\u0001\u00071'A\u0003u_BL7\r\u0005\u00025w9\u0011Q'\u000f\t\u0003mii\u0011a\u000e\u0006\u0003q5\ta\u0001\u0010:p_Rt\u0014B\u0001\u001e\u001b\u0003\u0019\u0001&/\u001a3fM&\u0011A(\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005iR\u0012\u0001\b;fgR\u001cuN\u001d:vaRd%\u0010\u000e)s_\u0012,8-\u001a*fcV,7\u000f\u001e\u0015\u0003\u000b}\ta\u0003^3tij\u001bF\u000b\u0012)s_\u0012,8-\u001a*fcV,7\u000f\u001e\u0015\u0003\r}\t!c]3oIB\u0013x\u000eZ;dKJ+\u0017/^3tiR\u0019AiT)\u0011\u0005\u0015kU\"\u0001$\u000b\u0005\u001dC\u0015\u0001\u0003:fcV,7\u000f^:\u000b\u0005%S\u0015AB2p[6|gN\u0003\u0002\r\u0017*\u0011AjI\u0001\u0007CB\f7\r[3\n\u000593%a\u0004)s_\u0012,8-\u001a*fgB|gn]3\t\u000bA;\u0001\u0019\u0001\u0018\u0002\u00111,\u0017\rZ3s\u0013\u0012DQAU\u0004A\u0002M\u000bqA]3rk\u0016\u001cH\u000f\u0005\u0002F)&\u0011QK\u0012\u0002\u000f!J|G-^2f%\u0016\fX/Z:u\u0001")
public class ProduceRequestTest
extends BaseRequestTest {
    @Test
    public void testSimpleProduceRequest() {
        Tuple2<Object, Object> tuple2 = this.createTopicAndFindPartitionWithLeader("topic");
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int partition = tuple2._1$mcI$sp();
        int leader = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(partition, leader);
        Tuple2.mcII.sp sp3 = sp2;
        int partition2 = sp3._1$mcI$sp();
        int leader2 = sp3._2$mcI$sp();
        this.sendAndCheck$1(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())}), 0L, partition2, leader2);
        this.sendAndCheck$1(MemoryRecords.withRecords((CompressionType)CompressionType.GZIP, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key1".getBytes(), "value1".getBytes()), new SimpleRecord(System.currentTimeMillis(), "key2".getBytes(), "value2".getBytes())}), 1L, partition2, leader2);
    }

    @Test
    public void testProduceToNonReplica() {
        String topic = "topic";
        int partition = 0;
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        Option nonReplicaOpt = this.servers().find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ProduceRequestTest.$anonfun$testProduceToNonReplica$1(leader, x$3)));
        Assert.assertTrue((boolean)nonReplicaOpt.isDefined());
        int nonReplicaId = ((KafkaServer)nonReplicaOpt.get()).config().brokerId();
        MemoryRecords records = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("key".getBytes(), "value".getBytes())});
        TopicPartition topicPartition = new TopicPartition("topic", partition);
        scala.collection.immutable.Map partitionRecords = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)records)}));
        ProduceRequest produceRequest = (ProduceRequest)ProduceRequest.Builder.forCurrentMagic((short)-1, (int)3000, (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRecords).asJava())).build();
        ProduceResponse produceResponse = this.sendProduceRequest(nonReplicaId, produceRequest);
        Assert.assertEquals((long)1L, (long)produceResponse.responses().size());
        Assert.assertEquals((Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)((ProduceResponse.PartitionResponse)((Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)produceResponse.responses()).asScala()).head())._2()).error);
    }

    private Tuple2<Object, Object> createTopicAndFindPartitionWithLeader(String topic) {
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 3, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        return (Tuple2)partitionToLeader.collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    int partition = A1._1$mcI$sp();
                    int leader = A1._2$mcI$sp();
                    if (leader != -1) {
                        object = new Tuple2.mcII.sp(partition, leader);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, Object> x1) {
                int leader;
                Tuple2<Object, Object> tuple2 = x1;
                boolean bl = tuple2 != null && (leader = tuple2._2$mcI$sp()) != -1;
                return bl;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fail(new StringBuilder(28).append("No leader elected for topic ").append(topic).toString(), new Position("ProduceRequestTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94)));
    }

    @Test
    public void testCorruptLz4ProduceRequest() {
        Tuple2<Object, Object> tuple2 = this.createTopicAndFindPartitionWithLeader("topic");
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int partition = tuple2._1$mcI$sp();
        int leader = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(partition, leader);
        Tuple2.mcII.sp sp3 = sp2;
        int partition2 = sp3._1$mcI$sp();
        int leader2 = sp3._2$mcI$sp();
        int timestamp = 1000000;
        MemoryRecords memoryRecords = MemoryRecords.withRecords((CompressionType)CompressionType.LZ4, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord((long)timestamp, "key".getBytes(), "value".getBytes())});
        int lz4ChecksumOffset = 6;
        memoryRecords.buffer().array()[61 + lz4ChecksumOffset] = 0;
        TopicPartition topicPartition = new TopicPartition("topic", partition2);
        scala.collection.immutable.Map partitionRecords = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)memoryRecords)}));
        ProduceResponse produceResponse = this.sendProduceRequest(leader2, (ProduceRequest)ProduceRequest.Builder.forCurrentMagic((short)-1, (int)3000, (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRecords).asJava())).build());
        Assert.assertEquals((long)1L, (long)produceResponse.responses().size());
        Tuple2 tuple22 = (Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(produceResponse.responses()).asScala()).head();
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        TopicPartition tp = (TopicPartition)tuple22._1();
        ProduceResponse.PartitionResponse partitionResponse = (ProduceResponse.PartitionResponse)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)tp, (Object)partitionResponse);
        Tuple2 tuple24 = tuple23;
        TopicPartition tp2 = (TopicPartition)tuple24._1();
        ProduceResponse.PartitionResponse partitionResponse2 = (ProduceResponse.PartitionResponse)tuple24._2();
        Assert.assertEquals((Object)topicPartition, (Object)tp2);
        Assert.assertEquals((Object)Errors.CORRUPT_MESSAGE, (Object)partitionResponse2.error);
        Assert.assertEquals((long)-1L, (long)partitionResponse2.baseOffset);
        Assert.assertEquals((long)-1L, (long)partitionResponse2.logAppendTime);
    }

    @Test
    public void testZSTDProduceRequest() {
        String topic = "topic";
        int partition = 0;
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.CompressionTypeProp(), ZStdCompressionCodec$.MODULE$.name());
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaServer>)this.servers(), topicConfig);
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        MemoryRecords memoryRecords = MemoryRecords.withRecords((CompressionType)CompressionType.ZSTD, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())});
        TopicPartition topicPartition = new TopicPartition("topic", partition);
        scala.collection.immutable.Map partitionRecords = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)memoryRecords)}));
        ProduceResponse res1 = this.sendProduceRequest(leader, (ProduceRequest)new ProduceRequest.Builder(7, 7, -1, 3000, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRecords).asJava(), null).build());
        Tuple2 tuple2 = (Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(res1.responses()).asScala()).head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp1 = (TopicPartition)tuple2._1();
        ProduceResponse.PartitionResponse partitionResponse1 = (ProduceResponse.PartitionResponse)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tp1, (Object)partitionResponse1);
        Tuple2 tuple23 = tuple22;
        TopicPartition tp12 = (TopicPartition)tuple23._1();
        ProduceResponse.PartitionResponse partitionResponse12 = (ProduceResponse.PartitionResponse)tuple23._2();
        Assert.assertEquals((Object)topicPartition, (Object)tp12);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionResponse12.error);
        Assert.assertEquals((long)0L, (long)partitionResponse12.baseOffset);
        Assert.assertEquals((long)-1L, (long)partitionResponse12.logAppendTime);
        ProduceResponse res2 = this.sendProduceRequest(leader, new ProduceRequest.Builder(3, 3, -1, 3000, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRecords).asJava(), null).buildUnsafe((short)3));
        Tuple2 tuple24 = (Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(res2.responses()).asScala()).head();
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        TopicPartition tp2 = (TopicPartition)tuple24._1();
        ProduceResponse.PartitionResponse partitionResponse2 = (ProduceResponse.PartitionResponse)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)tp2, (Object)partitionResponse2);
        Tuple2 tuple26 = tuple25;
        TopicPartition tp22 = (TopicPartition)tuple26._1();
        ProduceResponse.PartitionResponse partitionResponse22 = (ProduceResponse.PartitionResponse)tuple26._2();
        Assert.assertEquals((Object)topicPartition, (Object)tp22);
        Assert.assertEquals((Object)Errors.UNSUPPORTED_COMPRESSION_TYPE, (Object)partitionResponse22.error);
    }

    private ProduceResponse sendProduceRequest(int leaderId, ProduceRequest request) {
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.PRODUCE, this.brokerSocketServer(leaderId), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return ProduceResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private final ProduceResponse.PartitionResponse sendAndCheck$1(MemoryRecords memoryRecords, long expectedOffset, int partition$1, int leader$1) {
        TopicPartition topicPartition = new TopicPartition("topic", partition$1);
        scala.collection.immutable.Map partitionRecords = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)memoryRecords)}));
        ProduceResponse produceResponse = this.sendProduceRequest(leader$1, (ProduceRequest)ProduceRequest.Builder.forCurrentMagic((short)-1, (int)3000, (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRecords).asJava())).build());
        Assert.assertEquals((long)1L, (long)produceResponse.responses().size());
        Tuple2 tuple2 = (Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(produceResponse.responses()).asScala()).head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        ProduceResponse.PartitionResponse partitionResponse = (ProduceResponse.PartitionResponse)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tp, (Object)partitionResponse);
        Tuple2 tuple23 = tuple22;
        TopicPartition tp2 = (TopicPartition)tuple23._1();
        ProduceResponse.PartitionResponse partitionResponse2 = (ProduceResponse.PartitionResponse)tuple23._2();
        Assert.assertEquals((Object)topicPartition, (Object)tp2);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionResponse2.error);
        Assert.assertEquals((long)expectedOffset, (long)partitionResponse2.baseOffset);
        Assert.assertEquals((long)-1L, (long)partitionResponse2.logAppendTime);
        return partitionResponse2;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceToNonReplica$1(int leader$2, KafkaServer x$3) {
        return x$3.config().brokerId() != leader$2;
    }
}

