/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.common.InconsistentBrokerIdException;
import kafka.server.BrokerMetadata;
import kafka.server.BrokerMetadataCheckpoint;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001\u0002\u000f\u001e\u0001\tBQ!\u000b\u0001\u0005\u0002)Bq!\f\u0001A\u0002\u0013\u0005a\u0006C\u00048\u0001\u0001\u0007I\u0011\u0001\u001d\t\r\u0005\u0003\u0001\u0015)\u00030\u0011\u001d\u0011\u0005\u00011A\u0005\u0002\rCqa\u0012\u0001A\u0002\u0013\u0005\u0001\n\u0003\u0004K\u0001\u0001\u0006K\u0001\u0012\u0005\b\u0017\u0002\u0001\r\u0011\"\u0001/\u0011\u001da\u0005\u00011A\u0005\u00025Caa\u0014\u0001!B\u0013y\u0003b\u0002)\u0001\u0001\u0004%\ta\u0011\u0005\b#\u0002\u0001\r\u0011\"\u0001S\u0011\u0019!\u0006\u0001)Q\u0005\t\"9Q\u000b\u0001b\u0001\n\u00031\u0006BB/\u0001A\u0003%q\u000bC\u0004_\u0001\u0001\u0007I\u0011A0\t\u000f=\u0004\u0001\u0019!C\u0001a\"1!\u000f\u0001Q!\n\u0001DQa\u001d\u0001\u0005BQDQA \u0001\u0005BQDa!a\u0002\u0001\t\u0003!\bBBA\t\u0001\u0011\u0005A\u000f\u0003\u0004\u0002\u0016\u0001!\t\u0001\u001e\u0005\u0007\u00033\u0001A\u0011\u0001;\t\r\u0005u\u0001\u0001\"\u0001u\u0011\u0019\t\t\u0003\u0001C\u0001i\"9\u0011Q\u0005\u0001\u0005\u0002\u0005\u001d\"AG*feZ,'oR3oKJ\fG/\u001a\"s_.,'/\u00133UKN$(B\u0001\u0010 \u0003\u0019\u0019XM\u001d<fe*\t\u0001%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0019\u0003C\u0001\u0013(\u001b\u0005)#B\u0001\u0014 \u0003\tQ8.\u0003\u0002)K\t!\"l\\8LK\u0016\u0004XM\u001d+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#A\u0016\u0011\u00051\u0002Q\"A\u000f\u0002\rA\u0014x\u000e]:2+\u0005y\u0003C\u0001\u00196\u001b\u0005\t$B\u0001\u001a4\u0003\u0011)H/\u001b7\u000b\u0003Q\nAA[1wC&\u0011a'\r\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018A\u00039s_B\u001c\u0018g\u0018\u0013fcR\u0011\u0011h\u0010\t\u0003uuj\u0011a\u000f\u0006\u0002y\u0005)1oY1mC&\u0011ah\u000f\u0002\u0005+:LG\u000fC\u0004A\u0007\u0005\u0005\t\u0019A\u0018\u0002\u0007a$\u0013'A\u0004qe>\u00048/\r\u0011\u0002\u000f\r|gNZ5hcU\tA\t\u0005\u0002-\u000b&\u0011a)\b\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0006d_:4\u0017nZ\u0019`I\u0015\fHCA\u001dJ\u0011\u001d\u0001e!!AA\u0002\u0011\u000b\u0001bY8oM&<\u0017\u0007I\u0001\u0007aJ|\u0007o\u001d\u001a\u0002\u0015A\u0014x\u000e]:3?\u0012*\u0017\u000f\u0006\u0002:\u001d\"9\u0001)CA\u0001\u0002\u0004y\u0013a\u00029s_B\u001c(\u0007I\u0001\bG>tg-[43\u0003-\u0019wN\u001c4jOJzF%Z9\u0015\u0005e\u001a\u0006b\u0002!\r\u0003\u0003\u0005\r\u0001R\u0001\tG>tg-[43A\u0005\u0019\"M]8lKJlU\r^1Qe>\u00048OR5mKV\tq\u000b\u0005\u0002Y76\t\u0011L\u0003\u0002[g\u0005!A.\u00198h\u0013\ta\u0016L\u0001\u0004TiJLgnZ\u0001\u0015EJ|7.\u001a:NKR\f\u0007K]8qg\u001aKG.\u001a\u0011\u0002\u000fM,'O^3sgV\t\u0001\rE\u0002bS2t!AY4\u000f\u0005\r4W\"\u00013\u000b\u0005\u0015\f\u0013A\u0002\u001fs_>$h(C\u0001=\u0013\tA7(A\u0004qC\u000e\\\u0017mZ3\n\u0005)\\'aA*fc*\u0011\u0001n\u000f\t\u0003Y5L!A\\\u000f\u0003\u0017-\u000bgm[1TKJ4XM]\u0001\fg\u0016\u0014h/\u001a:t?\u0012*\u0017\u000f\u0006\u0002:c\"9\u0001)EA\u0001\u0002\u0004\u0001\u0017\u0001C:feZ,'o\u001d\u0011\u0002\u000bM,G/\u00169\u0015\u0003eB#a\u0005<\u0011\u0005]dX\"\u0001=\u000b\u0005eT\u0018!\u00026v]&$(\"A>\u0002\u0007=\u0014x-\u0003\u0002~q\n1!)\u001a4pe\u0016\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004)\u0005\u0005\u0001cA<\u0002\u0004%\u0019\u0011Q\u0001=\u0003\u000b\u00053G/\u001a:\u00021Q,7\u000f^!vi><UM\\3sCR,'I]8lKJLE\rK\u0002\u0016\u0003\u0017\u00012a^A\u0007\u0013\r\ty\u0001\u001f\u0002\u0005)\u0016\u001cH/\u0001\u0012uKN$Xk]3s\u0007>tg-[4B]\u0012<UM\\3sCR,GM\u0011:pW\u0016\u0014\u0018\n\u001a\u0015\u0004-\u0005-\u0011\u0001\b;fgR$\u0015n]1cY\u0016<UM\\3sCR,GM\u0011:pW\u0016\u0014\u0018\n\u001a\u0015\u0004/\u0005-\u0011\u0001\b;fgRlU\u000f\u001c;ja2,Gj\\4ESJ\u001cX*\u001a;b!J|\u0007o\u001d\u0015\u00041\u0005-\u0011\u0001\r;fgR\u001cuN\\:jgR,g\u000e\u001e\"s_.,'/\u00133Ge>lWk]3s\u0007>tg-[4B]\u0012lU\r^1Qe>\u00048\u000fK\u0002\u001a\u0003\u0017\tq\u0004^3ti\n\u0013xn[3s\u001b\u0016$\u0018\rZ1uC>s\u0017\nZ\"pY2L7/[8oQ\rQ\u00121B\u0001\u0015m\u0016\u0014\u0018NZ=Ce>\\WM]'fi\u0006$\u0017\r^1\u0015\r\u0005%\u0012qFA\"!\rQ\u00141F\u0005\u0004\u0003[Y$a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003cY\u0002\u0019AA\u001a\u0003\u001dawn\u001a#jeN\u0004B!Y5\u00026A!\u0011qGA \u001d\u0011\tI$a\u000f\u0011\u0005\r\\\u0014bAA\u001fw\u00051\u0001K]3eK\u001aL1\u0001XA!\u0015\r\tid\u000f\u0005\b\u0003\u000bZ\u0002\u0019AA$\u0003!\u0011'o\\6fe&#\u0007c\u0001\u001e\u0002J%\u0019\u00111J\u001e\u0003\u0007%sG\u000f")
public class ServerGenerateBrokerIdTest
extends ZooKeeperTestHarness {
    private Properties props1 = null;
    private KafkaConfig config1 = null;
    private Properties props2 = null;
    private KafkaConfig config2 = null;
    private final String brokerMetaPropsFile;
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);

    public Properties props1() {
        return this.props1;
    }

    public void props1_$eq(Properties x$1) {
        this.props1 = x$1;
    }

    public KafkaConfig config1() {
        return this.config1;
    }

    public void config1_$eq(KafkaConfig x$1) {
        this.config1 = x$1;
    }

    public Properties props2() {
        return this.props2;
    }

    public void props2_$eq(Properties x$1) {
        this.props2 = x$1;
    }

    public KafkaConfig config2() {
        return this.config2;
    }

    public void config2_$eq(KafkaConfig x$1) {
        this.config2 = x$1;
    }

    public String brokerMetaPropsFile() {
        return this.brokerMetaPropsFile;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.props1_$eq(TestUtils$.MODULE$.createBrokerConfig(-1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(this.props1()));
        this.props2_$eq(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
        this.config2_$eq(KafkaConfig$.MODULE$.fromProps(this.props2()));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testAutoGenerateBrokerId() {
        KafkaConfig x$1 = this.config1();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        Seq x$4 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server1 = new KafkaServer(x$1, x$3, x$2, x$4);
        server1.startup();
        server1.shutdown();
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)this.config1().logDirs(), 1001));
        server1 = TestUtils$.MODULE$.createServer(this.config1(), TestUtils$.MODULE$.createServer$default$2());
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server1}))));
        Assert.assertEquals((long)server1.config().brokerId(), (long)1001L);
        server1.shutdown();
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(this.getClass().getName());
    }

    @Test
    public void testUserConfigAndGeneratedBrokerId() {
        KafkaConfig x$12 = this.config1();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        Seq x$4 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server1 = new KafkaServer(x$12, x$3, x$2, x$4);
        KafkaConfig x$5 = this.config2();
        Option x$6 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$7 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        Seq x$8 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server2 = new KafkaServer(x$5, x$7, x$6, x$8);
        Properties props3 = TestUtils$.MODULE$.createBrokerConfig(-1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        KafkaServer server3 = new KafkaServer(KafkaConfig$.MODULE$.fromProps(props3), KafkaServer$.MODULE$.$lessinit$greater$default$2(), KafkaServer$.MODULE$.$lessinit$greater$default$3(), KafkaServer$.MODULE$.$lessinit$greater$default$4());
        server1.startup();
        Assert.assertEquals((long)server1.config().brokerId(), (long)1001L);
        server2.startup();
        Assert.assertEquals((long)server2.config().brokerId(), (long)0L);
        server3.startup();
        Assert.assertEquals((long)server3.config().brokerId(), (long)1002L);
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server1, server2, server3}))));
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.shutdown();
            return BoxedUnit.UNIT;
        });
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server1.config().logDirs(), 1001));
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server2.config().logDirs(), 0));
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server3.config().logDirs(), 1002));
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(this.getClass().getName());
    }

    @Test
    public void testDisableGeneratedBrokerId() {
        Properties props3 = TestUtils$.MODULE$.createBrokerConfig(3, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        props3.put(KafkaConfig$.MODULE$.BrokerIdGenerationEnableProp(), "false");
        props3.put(KafkaConfig$.MODULE$.MaxReservedBrokerIdProp(), "0");
        KafkaConfig config3 = KafkaConfig$.MODULE$.fromProps(props3);
        KafkaServer server3 = TestUtils$.MODULE$.createServer(config3, TestUtils$.MODULE$.createServer$default$2());
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server3}))));
        Assert.assertEquals((long)server3.config().brokerId(), (long)3L);
        server3.shutdown();
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server3.config().logDirs(), 3));
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(this.getClass().getName());
    }

    @Test
    public void testMultipleLogDirsMetaProps() {
        String logDirs = new StringBuilder(2).append(this.props1().getProperty("log.dir")).append(",").append(TestUtils$.MODULE$.tempDir().getAbsolutePath()).append(",").append(TestUtils$.MODULE$.tempDir().getAbsolutePath()).toString();
        this.props1().setProperty("log.dir", logDirs);
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(this.props1()));
        KafkaConfig x$1 = this.config1();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        Seq x$4 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server1 = new KafkaServer(x$1, x$3, x$2, x$4);
        server1.startup();
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server1}))));
        server1.shutdown();
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)this.config1().logDirs(), 1001));
        String newLogDirs = new StringBuilder(1).append(this.props1().getProperty("log.dir")).append(",").append(TestUtils$.MODULE$.tempDir().getAbsolutePath()).toString();
        this.props1().setProperty("log.dir", newLogDirs);
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(this.props1()));
        KafkaConfig x$5 = this.config1();
        Option x$6 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$7 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        Seq x$8 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        server1 = new KafkaServer(x$5, x$7, x$6, x$8);
        server1.startup();
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server1}))));
        server1.shutdown();
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)this.config1().logDirs(), 1001));
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(this.getClass().getName());
    }

    @Test
    public void testConsistentBrokerIdFromUserConfigAndMetaProps() {
        KafkaConfig x$1 = this.config1();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        Seq x$4 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server1 = new KafkaServer(x$1, x$3, x$2, x$4);
        server1.startup();
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server1}))));
        server1.shutdown();
        KafkaConfig x$5 = this.config2();
        Option x$6 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$7 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        Seq x$8 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        server1 = new KafkaServer(x$5, x$7, x$6, x$8);
        try {
            server1.startup();
        }
        catch (InconsistentBrokerIdException inconsistentBrokerIdException) {}
        server1.shutdown();
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(this.getClass().getName());
    }

    @Test
    public void testBrokerMetadataOnIdCollision() {
        Properties propsA = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        KafkaConfig configA = KafkaConfig$.MODULE$.fromProps(propsA);
        KafkaServer serverA = TestUtils$.MODULE$.createServer(configA, TestUtils$.MODULE$.createServer$default$2());
        Properties propsB = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        KafkaConfig configB = KafkaConfig$.MODULE$.fromProps(propsB);
        KafkaServer serverB = new KafkaServer(configB, KafkaServer$.MODULE$.$lessinit$greater$default$2(), KafkaServer$.MODULE$.$lessinit$greater$default$3(), KafkaServer$.MODULE$.$lessinit$greater$default$4());
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> serverB.startup(), ClassTag$.MODULE$.apply(KeeperException.NodeExistsException.class), new Position("ServerGenerateBrokerIdTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{serverA}))));
        serverB.config().logDirs().foreach((Function1 & Serializable & scala.Serializable)logDir -> {
            ServerGenerateBrokerIdTest.$anonfun$testBrokerMetadataOnIdCollision$2(this, logDir);
            return BoxedUnit.UNIT;
        });
        propsB.setProperty(KafkaConfig$.MODULE$.BrokerIdProp(), "2");
        KafkaConfig newConfigB = KafkaConfig$.MODULE$.fromProps(propsB);
        KafkaServer newServerB = TestUtils$.MODULE$.createServer(newConfigB, TestUtils$.MODULE$.createServer$default$2());
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{serverA, newServerB}))));
        serverA.shutdown();
        newServerB.shutdown();
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)serverA.config().logDirs(), 1));
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)newServerB.config().logDirs(), 2));
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(this.getClass().getName());
    }

    public boolean verifyBrokerMetadata(Seq<String> logDirs, int brokerId) {
        boolean bl;
        Object object = new Object();
        try {
            logDirs.foreach((Function1 & Serializable & scala.Serializable)logDir -> {
                ServerGenerateBrokerIdTest.$anonfun$verifyBrokerMetadata$1(this, brokerId, object, logDir);
                return BoxedUnit.UNIT;
            });
            bl = true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testBrokerMetadataOnIdCollision$2(ServerGenerateBrokerIdTest $this, String logDir) {
        File brokerMetaFile = new File(new StringBuilder(0).append(logDir).append(File.separator).append($this.brokerMetaPropsFile()).toString());
        Assert.assertFalse((boolean)brokerMetaFile.exists());
    }

    public static final /* synthetic */ void $anonfun$verifyBrokerMetadata$1(ServerGenerateBrokerIdTest $this, int brokerId$1, Object nonLocalReturnKey1$1, String logDir) {
        Option brokerMetadataOpt = new BrokerMetadataCheckpoint(new File(new StringBuilder(0).append(logDir).append(File.separator).append($this.brokerMetaPropsFile()).toString())).read();
        Option option = brokerMetadataOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            BrokerMetadata brokerMetadata = (BrokerMetadata)some.value();
            if (brokerMetadata.brokerId() != brokerId$1) {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
            }
        } else {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public ServerGenerateBrokerIdTest() {
        this.brokerMetaPropsFile = "meta.properties";
    }
}

