/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u000114Aa\u0005\u000b\u00013!)\u0001\u0005\u0001C\u0001C!9A\u0005\u0001a\u0001\n\u0003)\u0003bB\u0015\u0001\u0001\u0004%\tA\u000b\u0005\u0007g\u0001\u0001\u000b\u0015\u0002\u0014\t\u000fQ\u0002\u0001\u0019!C\u0001K!9Q\u0007\u0001a\u0001\n\u00031\u0004B\u0002\u001d\u0001A\u0003&a\u0005C\u0004:\u0001\u0001\u0007I\u0011A\u0013\t\u000fi\u0002\u0001\u0019!C\u0001w!1Q\b\u0001Q!\n\u0019BqA\u0010\u0001A\u0002\u0013\u0005q\bC\u0004P\u0001\u0001\u0007I\u0011\u0001)\t\rI\u0003\u0001\u0015)\u0003A\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0011\u0015q\u0006\u0001\"\u0011U\u0011\u0015\u0019\u0007\u0001\"\u0001U\u0011\u0015A\u0007\u0001\"\u0001U\u0011\u0015Q\u0007\u0001\"\u0001U\u0005m\u0019VM\u001d<fe\u001e+g.\u001a:bi\u0016\u001cE.^:uKJLE\rV3ti*\u0011QCF\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003]\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00015A\u00111DH\u0007\u00029)\u0011QDF\u0001\u0003u.L!a\b\u000f\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\t!\u0005\u0005\u0002$\u00015\tA#A\u0004d_:4\u0017nZ\u0019\u0016\u0003\u0019\u0002\"aI\u0014\n\u0005!\"\"aC&bM.\f7i\u001c8gS\u001e\f1bY8oM&<\u0017g\u0018\u0013fcR\u00111&\r\t\u0003Y=j\u0011!\f\u0006\u0002]\u0005)1oY1mC&\u0011\u0001'\f\u0002\u0005+:LG\u000fC\u00043\u0007\u0005\u0005\t\u0019\u0001\u0014\u0002\u0007a$\u0013'\u0001\u0005d_:4\u0017nZ\u0019!\u0003\u001d\u0019wN\u001c4jOJ\n1bY8oM&<'g\u0018\u0013fcR\u00111f\u000e\u0005\be\u0019\t\t\u00111\u0001'\u0003!\u0019wN\u001c4jOJ\u0002\u0013aB2p]\u001aLwmM\u0001\fG>tg-[44?\u0012*\u0017\u000f\u0006\u0002,y!9!'CA\u0001\u0002\u00041\u0013\u0001C2p]\u001aLwm\r\u0011\u0002\u000fM,'O^3sgV\t\u0001\tE\u0002B\u00132s!AQ$\u000f\u0005\r3U\"\u0001#\u000b\u0005\u0015C\u0012A\u0002\u001fs_>$h(C\u0001/\u0013\tAU&A\u0004qC\u000e\\\u0017mZ3\n\u0005)[%aA*fc*\u0011\u0001*\f\t\u0003G5K!A\u0014\u000b\u0003\u0017-\u000bgm[1TKJ4XM]\u0001\fg\u0016\u0014h/\u001a:t?\u0012*\u0017\u000f\u0006\u0002,#\"9!\u0007DA\u0001\u0002\u0004\u0001\u0015\u0001C:feZ,'o\u001d\u0011\u0002\u000bM,G/\u00169\u0015\u0003-B#A\u0004,\u0011\u0005]cV\"\u0001-\u000b\u0005eS\u0016!\u00026v]&$(\"A.\u0002\u0007=\u0014x-\u0003\u0002^1\n1!)\u001a4pe\u0016\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0003\u001f\u0001\u0004\"aV1\n\u0005\tD&!B!gi\u0016\u0014\u0018!\u0007;fgR\fU\u000f^8HK:,'/\u0019;f\u00072,8\u000f^3s\u0013\u0012D#\u0001E3\u0011\u0005]3\u0017BA4Y\u0005\u0011!Vm\u001d;\u0002eQ,7\u000f^!vi><UM\\3sCR,7\t\\;ti\u0016\u0014\u0018\n\u001a$pe.\u000bgm[1DYV\u001cH/\u001a:TKF,XM\u001c;jC2D#!E3\u0002aQ,7\u000f^!vi><UM\\3sCR,7\t\\;ti\u0016\u0014\u0018\n\u001a$pe.\u000bgm[1DYV\u001cH/\u001a:QCJ\fG\u000e\\3mQ\t\u0011R\r")
public class ServerGenerateClusterIdTest
extends ZooKeeperTestHarness {
    private KafkaConfig config1 = null;
    private KafkaConfig config2 = null;
    private KafkaConfig config3 = null;
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);

    public KafkaConfig config1() {
        return this.config1;
    }

    public void config1_$eq(KafkaConfig x$1) {
        this.config1 = x$1;
    }

    public KafkaConfig config2() {
        return this.config2;
    }

    public void config2_$eq(KafkaConfig x$1) {
        this.config2 = x$1;
    }

    public KafkaConfig config3() {
        return this.config3;
    }

    public void config3_$eq(KafkaConfig x$1) {
        this.config3 = x$1;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18())));
        this.config2_$eq(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(2, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18())));
        this.config3_$eq(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(3, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18())));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testAutoGenerateClusterId() {
        Assert.assertFalse((boolean)this.zkClient().getClusterId().isDefined());
        KafkaServer server1 = TestUtils$.MODULE$.createServer(this.config1(), TestUtils$.MODULE$.createServer$default$2());
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server1}))));
        String clusterIdOnFirstBoot = server1.clusterId();
        TestUtils.isValidClusterId((String)clusterIdOnFirstBoot);
        server1.shutdown();
        Assert.assertTrue((boolean)this.zkClient().getClusterId().isDefined());
        Assert.assertEquals((Object)this.zkClient().getClusterId(), (Object)new Some((Object)clusterIdOnFirstBoot));
        server1 = TestUtils$.MODULE$.createServer(this.config1(), TestUtils$.MODULE$.createServer$default$2());
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server1}))));
        String clusterIdOnSecondBoot = server1.clusterId();
        Assert.assertEquals((Object)clusterIdOnFirstBoot, (Object)clusterIdOnSecondBoot);
        server1.shutdown();
        Assert.assertTrue((boolean)this.zkClient().getClusterId().isDefined());
        Assert.assertEquals((Object)this.zkClient().getClusterId(), (Object)new Some((Object)clusterIdOnFirstBoot));
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(this.getClass().getName());
    }

    @Test
    public void testAutoGenerateClusterIdForKafkaClusterSequential() {
        KafkaServer server1 = TestUtils$.MODULE$.createServer(this.config1(), TestUtils$.MODULE$.createServer$default$2());
        String clusterIdFromServer1 = server1.clusterId();
        KafkaServer server2 = TestUtils$.MODULE$.createServer(this.config2(), TestUtils$.MODULE$.createServer$default$2());
        String clusterIdFromServer2 = server2.clusterId();
        KafkaServer server3 = TestUtils$.MODULE$.createServer(this.config3(), TestUtils$.MODULE$.createServer$default$2());
        String clusterIdFromServer3 = server3.clusterId();
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server1, server2, server3}))));
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.shutdown();
            return BoxedUnit.UNIT;
        });
        TestUtils.isValidClusterId((String)clusterIdFromServer1);
        Assert.assertEquals((String)clusterIdFromServer1, (Object)clusterIdFromServer2, (Object)clusterIdFromServer3);
        server1.startup();
        Assert.assertEquals((Object)clusterIdFromServer1, (Object)server1.clusterId());
        server2.startup();
        Assert.assertEquals((Object)clusterIdFromServer2, (Object)server2.clusterId());
        server3.startup();
        Assert.assertEquals((Object)clusterIdFromServer3, (Object)server3.clusterId());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.shutdown();
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(this.getClass().getName());
    }

    @Test
    public void testAutoGenerateClusterIdForKafkaClusterParallel() {
        Future firstBoot = Future$.MODULE$.traverse((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{this.config1(), this.config2(), this.config3()})), (Function1 & Serializable & scala.Serializable)config -> Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.createServer((KafkaConfig)config, TestUtils$.MODULE$.createServer$default$2()), ExecutionContext.Implicits$.MODULE$.global()), Seq$.MODULE$.canBuildFrom(), ExecutionContext.Implicits$.MODULE$.global());
        this.servers_$eq((Seq<KafkaServer>)((Seq)Await$.MODULE$.result((Awaitable)firstBoot, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(100)).second())));
        Seq<KafkaServer> seq = this.servers();
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) {
            throw new MatchError(seq);
        }
        KafkaServer server1 = (KafkaServer)((SeqLike)some.get()).apply(0);
        KafkaServer server2 = (KafkaServer)((SeqLike)some.get()).apply(1);
        KafkaServer server3 = (KafkaServer)((SeqLike)some.get()).apply(2);
        Tuple3 tuple3 = new Tuple3((Object)server1, (Object)server2, (Object)server3);
        Tuple3 tuple32 = tuple3;
        KafkaServer server12 = (KafkaServer)tuple32._1();
        KafkaServer server22 = (KafkaServer)tuple32._2();
        KafkaServer server32 = (KafkaServer)tuple32._3();
        String clusterIdFromServer1 = server12.clusterId();
        String clusterIdFromServer2 = server22.clusterId();
        String clusterIdFromServer3 = server32.clusterId();
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        TestUtils.isValidClusterId((String)clusterIdFromServer1);
        Assert.assertEquals((String)clusterIdFromServer1, (Object)clusterIdFromServer2, (Object)clusterIdFromServer3);
        Future secondBoot = Future$.MODULE$.traverse((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server12, server22, server32})), (Function1 & Serializable & scala.Serializable)server -> Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            server.startup();
            return server;
        }, ExecutionContext.Implicits$.MODULE$.global()), Seq$.MODULE$.canBuildFrom(), ExecutionContext.Implicits$.MODULE$.global());
        this.servers_$eq((Seq<KafkaServer>)((Seq)Await$.MODULE$.result((Awaitable)secondBoot, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(100)).second())));
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            ServerGenerateClusterIdTest.$anonfun$testAutoGenerateClusterIdForKafkaClusterParallel$6(clusterIdFromServer1, server);
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(this.getClass().getName());
    }

    public static final /* synthetic */ void $anonfun$testAutoGenerateClusterIdForKafkaClusterParallel$6(String clusterIdFromServer1$1, KafkaServer server) {
        Assert.assertEquals((Object)clusterIdFromServer1$1, (Object)server.clusterId());
    }
}

