/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.utils;

import kafka.utils.Throttler;
import kafka.utils.Throttler$;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00112Aa\u0001\u0003\u0001\u0017!)!\u0003\u0001C\u0001'!)a\u0003\u0001C\u0001/\tiA\u000b\u001b:piRdWM\u001d+fgRT!!\u0002\u0004\u0002\u000bU$\u0018\u000e\\:\u000b\u0005\u001dA\u0011!B6bM.\f'\"A\u0005\u0002\tUt\u0017\u000e^\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Q\u0001\"!\u0006\u0001\u000e\u0003\u0011\tq\u0003^3tiRC'o\u001c;uY\u0016$Um]5sK\u0012\u0014\u0016\r^3\u0015\u0003a\u0001\"!D\r\n\u0005iq!\u0001B+oSRD#A\u0001\u000f\u0011\u0005u\u0011S\"\u0001\u0010\u000b\u0005}\u0001\u0013!\u00026v]&$(\"A\u0011\u0002\u0007=\u0014x-\u0003\u0002$=\t!A+Z:u\u0001")
public class ThrottlerTest {
    @Test
    public void testThrottleDesiredRate() {
        int throttleCheckIntervalMs = 100;
        double desiredCountPerSec = 1000.0;
        double desiredCountPerInterval = desiredCountPerSec * (double)throttleCheckIntervalMs / 1000.0;
        MockTime mockTime = new MockTime();
        double x$1 = desiredCountPerSec;
        long x$2 = throttleCheckIntervalMs;
        MockTime x$3 = mockTime;
        boolean x$4 = Throttler$.MODULE$.$lessinit$greater$default$3();
        String x$5 = Throttler$.MODULE$.$lessinit$greater$default$4();
        String x$6 = Throttler$.MODULE$.$lessinit$greater$default$5();
        Throttler throttler = new Throttler(x$1, x$2, x$4, x$5, x$6, (Time)x$3);
        long t1 = mockTime.milliseconds();
        throttler.maybeThrottle(desiredCountPerInterval);
        Assert.assertEquals((long)t1, (long)mockTime.milliseconds());
        mockTime.sleep((long)(throttleCheckIntervalMs + 1));
        throttler.maybeThrottle(desiredCountPerInterval);
        long t2 = mockTime.milliseconds();
        Assert.assertTrue((t2 >= t1 + (long)(2 * throttleCheckIntervalMs) ? 1 : 0) != 0);
        throttler.maybeThrottle(desiredCountPerInterval);
        Assert.assertEquals((long)t2, (long)mockTime.milliseconds());
        mockTime.sleep((long)(throttleCheckIntervalMs + 1));
        throttler.maybeThrottle(desiredCountPerInterval);
        long t3 = mockTime.milliseconds();
        Assert.assertTrue((t3 >= t2 + (long)(2 * throttleCheckIntervalMs) ? 1 : 0) != 0);
        long elapsedTimeMs = t3 - t1;
        double actualCountPerSec = (double)4 * desiredCountPerInterval * (double)1000 / (double)elapsedTimeMs;
        Assert.assertTrue((actualCountPerSec <= desiredCountPerSec ? 1 : 0) != 0);
    }
}

