/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.AbstractServerThread;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor$;
import kafka.network.Processor$ConnectionId$;
import kafka.network.RequestChannel;
import kafka.network.SocketServer$;
import kafka.security.CredentialProvider;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.stats.Total;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\u0011euAB6m\u0011\u0003q\u0007O\u0002\u0004sY\"\u0005an\u001d\u0005\u0006u\u0006!\t\u0001 \u0005\b{\u0006\u0011\r\u0011\"\u0001\u007f\u0011\u001d\ty!\u0001Q\u0001\n}D\u0001\"!\u0005\u0002\u0005\u0004%\tA \u0005\b\u0003'\t\u0001\u0015!\u0003\u0000\u0011!\t)\"\u0001b\u0001\n\u0003q\bbBA\f\u0003\u0001\u0006Ia \u0005\n\u00033\t!\u0019!C\u0001\u00037A\u0001\"a\t\u0002A\u0003%\u0011Q\u0004\u0005\n\u0003K\t\u0011\u0013!C\u0001\u0003O1aA\u001d7\u0001]\u0006u\u0002BCA)\u0019\t\u0015\r\u0011\"\u0001\u0002\u001c!Q\u00111\u000b\u0007\u0003\u0002\u0003\u0006I!!\b\t\u0015\u0005UCB!A!\u0002\u0013\t9\u0006\u0003\u0006\u0002r1\u0011\t\u0011)A\u0005\u0003;A!\"a\u001d\r\u0005\u0003\u0005\u000b\u0011BA;\u0011)\tY\b\u0004B\u0001B\u0003%\u0011Q\u0010\u0005\u000b\u0003\u0007c!\u0011!Q\u0001\n\u0005\u0015\u0005BCAF\u0019\t\u0005\t\u0015!\u0003\u0002\u001e!Q\u0011Q\u0012\u0007\u0003\u0002\u0003\u0006I!a$\t\u0015\u0005eEB!A!\u0002\u0013\tY\n\u0003\u0006\u0002,2\u0011\t\u0011)A\u0005\u0003[C!\"a\u0013\r\u0005\u0003\u0005\u000b\u0011BA]\u0011)\t\u0019\r\u0004B\u0001B\u0003%\u0011Q\u0019\u0005\u000b\u0003\u001fd!\u0011!Q\u0001\n\u0005E\u0007BCAo\u0019\t\u0005\t\u0015!\u0003\u0002`\"Q\u0011Q\u001d\u0007\u0003\u0002\u0003\u0006I!!\b\t\ridA\u0011AAt\u000f\u001d\u0011I\u0001\u0004E\u0005\u0005\u00171qAa\u0004\r\u0011\u0013\u0011\t\u0002\u0003\u0004{?\u0011\u0005!\u0011\u0004\u0005\b\u00057yB\u0011\u0001B\u000f\u0011%\u0011\tmHA\u0001\n\u0003\u0013\u0019\rC\u0005\u0003P~\t\t\u0011\"!\u0003R\u001a9!q\u0002\u0007AY\n\u001d\u0002B\u0003B\u0018I\tU\r\u0011\"\u0001\u00032!Q!q\t\u0013\u0003\u0012\u0003\u0006IAa\r\t\u0015\t%CE!f\u0001\n\u0003\tY\u0002\u0003\u0006\u0003L\u0011\u0012\t\u0012)A\u0005\u0003;A!B!\u0014%\u0005+\u0007I\u0011\u0001B\u0019\u0011)\u0011y\u0005\nB\tB\u0003%!1\u0007\u0005\u000b\u0005#\"#Q3A\u0005\u0002\u0005m\u0001B\u0003B*I\tE\t\u0015!\u0003\u0002\u001e!Q!Q\u000b\u0013\u0003\u0016\u0004%\t!a\u0007\t\u0015\t]CE!E!\u0002\u0013\ti\u0002\u0003\u0004{I\u0011\u0005!\u0011\f\u0005\b\u0005K\"C\u0011\tB4\u0011%\u0011I\u0007JA\u0001\n\u0003\u0011Y\u0007C\u0005\u0003x\u0011\n\n\u0011\"\u0001\u0003z!I!Q\u0010\u0013\u0012\u0002\u0013\u0005\u0011q\u0005\u0005\n\u0005\u007f\"\u0013\u0013!C\u0001\u0005sB\u0011B!!%#\u0003%\t!a\n\t\u0013\t\rE%%A\u0005\u0002\u0005\u001d\u0002\u0002\u0003BCI\u0005\u0005I\u0011\t@\t\u0013\t\u001dE%!A\u0005\u0002\u0005m\u0001\"\u0003BEI\u0005\u0005I\u0011\u0001BF\u0011%\u00119\nJA\u0001\n\u0003\u0012I\nC\u0005\u0003(\u0012\n\t\u0011\"\u0001\u0003*\"I!1\u0017\u0013\u0002\u0002\u0013\u0005#Q\u0017\u0005\n\u0005o#\u0013\u0011!C!\u0005sC\u0011Ba8\r\u0005\u0004%IA!9\t\u0011\r\rA\u0002)A\u0005\u0005GD\u0011b!\u0002\r\u0005\u0004%Iaa\u0002\t\u0011\r\rB\u0002)A\u0005\u0007\u0013A\u0011b!\n\r\u0005\u0004%Iaa\n\t\u0011\r=B\u0002)A\u0005\u0007SA!b!\r\r\u0005\u0004%\tA\\B\u001a\u0011!\u0019Y\u0004\u0004Q\u0001\n\rU\u0002\"CB\u001f\u0019\t\u0007I\u0011AB \u0011!\u0019i\u0005\u0004Q\u0001\n\r\u0005\u0003\"CB(\u0019\t\u0007I\u0011BB)\u0011!\u0019Y\u0006\u0004Q\u0001\n\rM\u0003\"CB/\u0019\t\u0007I\u0011BB0\u0011!\u00199\u0007\u0004Q\u0001\n\r\u0005\u0004\u0002CB5\u0019\u0011EAna\u001b\t\u0013\r]D\u00021A\u0005\n\u0005m\u0001\"CB=\u0019\u0001\u0007I\u0011BB>\u0011!\u0019)\t\u0004Q!\n\u0005u\u0001bBBD\u0019\u0011\u00053\u0011\u0012\u0005\b\u0007\u0017cA\u0011BBG\u0011\u001d\u0019I\u000b\u0004C\u0005\u0007WCqa!.\r\t\u0013\u0019I\t\u0003\u0005\u000482!\t\u0002\\B]\u0011\u001d\u0019I\r\u0004C\u0005\u0007\u0017Dqa!;\r\t\u0013\u0019I\tC\u0004\u0004l2!Ia!#\t\u000f\r5H\u0002\"\u0003\u0004\n\"91q\u001e\u0007\u0005\n\rE\bbBB{\u0019\u0011%1\u0011\u0012\u0005\b\u0007odA\u0011BB}\u0011\u001d\u0019y\u0010\u0004C\u0001\t\u0003Aq\u0001\"\n\r\t\u0013\u0019I\tC\u0004\u0005(1!Ia!#\t\u0011\ruH\u0002\"\u0005m\tSA\u0001\u0002b\u000f\r\t\u0003aGQ\b\u0005\b\t\u0003bA\u0011\u0002C\"\u0011!!)\u0005\u0004C\u0001Y\u0006m\u0001\u0002\u0003C$\u0019\u0011\u0005A.a\u0007\t\u0011\u0011%C\u0002\"\u0001m\t\u0017Bq\u0001b\u0016\r\t\u0013!I\u0006C\u0004\u0005\u00042!I\u0001\"\"\t\u0011\u0011%E\u0002\"\u0001m\t\u0017C\u0001\u0002b$\r\t\u0003aG\u0011\u0013\u0005\b\t+cA\u0011IBE\u0011\u001d!9\n\u0004C!\u0007\u0013\u000b\u0011\u0002\u0015:pG\u0016\u001c8o\u001c:\u000b\u00055t\u0017a\u00028fi^|'o\u001b\u0006\u0002_\u0006)1.\u00194lCB\u0011\u0011/A\u0007\u0002Y\nI\u0001K]8dKN\u001cxN]\n\u0003\u0003Q\u0004\"!\u001e=\u000e\u0003YT\u0011a^\u0001\u0006g\u000e\fG.Y\u0005\u0003sZ\u0014a!\u00118z%\u00164\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003A\fQ#\u00133mKB+'oY3oi6+GO]5d\u001d\u0006lW-F\u0001\u0000!\u0011\t\t!a\u0003\u000e\u0005\u0005\r!\u0002BA\u0003\u0003\u000f\tA\u0001\\1oO*\u0011\u0011\u0011B\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u000e\u0005\r!AB*ue&tw-\u0001\fJI2,\u0007+\u001a:dK:$X*\u001a;sS\u000et\u0015-\\3!\u0003eqU\r^<pe.\u0004&o\\2fgN|'/T3ue&\u001cG+Y4\u000259+Go^8sWB\u0013xnY3tg>\u0014X*\u001a;sS\u000e$\u0016m\u001a\u0011\u0002#1K7\u000f^3oKJlU\r\u001e:jGR\u000bw-\u0001\nMSN$XM\\3s\u001b\u0016$(/[2UC\u001e\u0004\u0013aE\"p]:,7\r^5p]F+X-^3TSj,WCAA\u000f!\r)\u0018qD\u0005\u0004\u0003C1(aA%oi\u0006!2i\u001c8oK\u000e$\u0018n\u001c8Rk\u0016,XmU5{K\u0002\nA\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\nT'\u0006\u0002\u0002*)\"\u0011QDA\u0016W\t\ti\u0003\u0005\u0003\u00020\u0005eRBAA\u0019\u0015\u0011\t\u0019$!\u000e\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001cm\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0012\u0011\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,7#\u0002\u0007\u0002@\u0005\u0015\u0003cA9\u0002B%\u0019\u00111\t7\u0003)\u0005\u00137\u000f\u001e:bGR\u001cVM\u001d<feRC'/Z1e!\u0011\t9%!\u0014\u000e\u0005\u0005%#bAA&]\u00069Q.\u001a;sS\u000e\u001c\u0018\u0002BA(\u0003\u0013\u0012\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0003\tIG-A\u0002jI\u0002\nA\u0001^5nKB!\u0011\u0011LA7\u001b\t\tYF\u0003\u0003\u0002^\u0005}\u0013!B;uS2\u001c(\u0002BA1\u0003G\naaY8n[>t'bA8\u0002f)!\u0011qMA5\u0003\u0019\t\u0007/Y2iK*\u0011\u00111N\u0001\u0004_J<\u0017\u0002BA8\u00037\u0012A\u0001V5nK\u0006qQ.\u0019=SKF,Xm\u001d;TSj,\u0017A\u0004:fcV,7\u000f^\"iC:tW\r\u001c\t\u0004c\u0006]\u0014bAA=Y\nq!+Z9vKN$8\t[1o]\u0016d\u0017\u0001E2p]:,7\r^5p]F+x\u000e^1t!\r\t\u0018qP\u0005\u0004\u0003\u0003c'\u0001E\"p]:,7\r^5p]F+x\u000e^1t\u0003Q\u0019wN\u001c8fGRLwN\\:NCbLE\r\\3NgB\u0019Q/a\"\n\u0007\u0005%eO\u0001\u0003M_:<\u0017a\u00074bS2,G-Q;uQ\u0016tG/[2bi&|g\u000eR3mCfl5/\u0001\u0007mSN$XM\\3s\u001d\u0006lW\r\u0005\u0003\u0002\u0012\u0006UUBAAJ\u0015\ri\u0017qL\u0005\u0005\u0003/\u000b\u0019J\u0001\u0007MSN$XM\\3s\u001d\u0006lW-\u0001\ttK\u000e,(/\u001b;z!J|Go\\2pYB!\u0011QTAT\u001b\t\tyJ\u0003\u0003\u0002\"\u0006\r\u0016\u0001B1vi\"TA!!*\u0002`\u0005A1/Z2ve&$\u00180\u0003\u0003\u0002*\u0006}%\u0001E*fGV\u0014\u0018\u000e^=Qe>$xnY8m\u0003\u0019\u0019wN\u001c4jOB!\u0011qVA[\u001b\t\t\tLC\u0002\u00024:\faa]3sm\u0016\u0014\u0018\u0002BA\\\u0003c\u00131bS1gW\u0006\u001cuN\u001c4jOB!\u00111XA`\u001b\t\tiL\u0003\u0003\u0002L\u0005}\u0013\u0002BAa\u0003{\u0013q!T3ue&\u001c7/\u0001\nde\u0016$WM\u001c;jC2\u0004&o\u001c<jI\u0016\u0014\b\u0003BAd\u0003\u0017l!!!3\u000b\u0007\u0005\u0015f.\u0003\u0003\u0002N\u0006%'AE\"sK\u0012,g\u000e^5bYB\u0013xN^5eKJ\f!\"\\3n_JL\bk\\8m!\u0011\t\u0019.!7\u000e\u0005\u0005U'\u0002BAl\u0003?\na!\\3n_JL\u0018\u0002BAn\u0003+\u0014!\"T3n_JL\bk\\8m\u0003)awnZ\"p]R,\u0007\u0010\u001e\t\u0005\u00033\n\t/\u0003\u0003\u0002d\u0006m#A\u0003'pO\u000e{g\u000e^3yi\u0006\u00192m\u001c8oK\u000e$\u0018n\u001c8Rk\u0016,XmU5{KR\u0001\u0013\u0011^Av\u0003[\fy/!=\u0002t\u0006U\u0018q_A}\u0003w\fi0a@\u0003\u0002\t\r!Q\u0001B\u0004!\t\tH\u0002C\u0004\u0002Ru\u0001\r!!\b\t\u000f\u0005US\u00041\u0001\u0002X!9\u0011\u0011O\u000fA\u0002\u0005u\u0001bBA:;\u0001\u0007\u0011Q\u000f\u0005\b\u0003wj\u0002\u0019AA?\u0011\u001d\t\u0019)\ba\u0001\u0003\u000bCq!a#\u001e\u0001\u0004\ti\u0002C\u0004\u0002\u000ev\u0001\r!a$\t\u000f\u0005eU\u00041\u0001\u0002\u001c\"9\u00111V\u000fA\u0002\u00055\u0006bBA&;\u0001\u0007\u0011\u0011\u0018\u0005\b\u0003\u0007l\u0002\u0019AAc\u0011\u001d\ty-\ba\u0001\u0003#Dq!!8\u001e\u0001\u0004\ty\u000eC\u0005\u0002fv\u0001\n\u00111\u0001\u0002\u001e\u0005a1i\u001c8oK\u000e$\u0018n\u001c8JIB\u0019!QB\u0010\u000e\u00031\u0011AbQ8o]\u0016\u001cG/[8o\u0013\u0012\u001cBa\b;\u0003\u0014A\u0019QO!\u0006\n\u0007\t]aO\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0003\f\u0005QaM]8n'R\u0014\u0018N\\4\u0015\t\t}!Q\u0018\t\u0006k\n\u0005\"QE\u0005\u0004\u0005G1(AB(qi&|g\u000eE\u0002\u0003\u000e\u0011\u001ab\u0001\n;\u0003*\tM\u0001cA;\u0003,%\u0019!Q\u0006<\u0003\u000fA\u0013x\u000eZ;di\u0006IAn\\2bY\"{7\u000f^\u000b\u0003\u0005g\u0001BA!\u000e\u0003D9!!q\u0007B !\r\u0011ID^\u0007\u0003\u0005wQ1A!\u0010|\u0003\u0019a$o\\8u}%\u0019!\u0011\t<\u0002\rA\u0013X\rZ3g\u0013\u0011\tiA!\u0012\u000b\u0007\t\u0005c/\u0001\u0006m_\u000e\fG\u000eS8ti\u0002\n\u0011\u0002\\8dC2\u0004vN\u001d;\u0002\u00151|7-\u00197Q_J$\b%\u0001\u0006sK6|G/\u001a%pgR\f1B]3n_R,\u0007j\\:uA\u0005Q!/Z7pi\u0016\u0004vN\u001d;\u0002\u0017I,Wn\u001c;f!>\u0014H\u000fI\u0001\u0006S:$W\r_\u0001\u0007S:$W\r\u001f\u0011\u0015\u0019\t\u0015\"1\fB/\u0005?\u0012\tGa\u0019\t\u000f\t=r\u00061\u0001\u00034!9!\u0011J\u0018A\u0002\u0005u\u0001b\u0002B'_\u0001\u0007!1\u0007\u0005\b\u0005#z\u0003\u0019AA\u000f\u0011\u001d\u0011)f\fa\u0001\u0003;\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005g\tAaY8qsRa!Q\u0005B7\u0005_\u0012\tHa\u001d\u0003v!I!qF\u0019\u0011\u0002\u0003\u0007!1\u0007\u0005\n\u0005\u0013\n\u0004\u0013!a\u0001\u0003;A\u0011B!\u00142!\u0003\u0005\rAa\r\t\u0013\tE\u0013\u0007%AA\u0002\u0005u\u0001\"\u0003B+cA\u0005\t\u0019AA\u000f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa\u001f+\t\tM\u00121F\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!$\u0003\u0014B\u0019QOa$\n\u0007\tEeOA\u0002B]fD\u0011B!&:\u0003\u0003\u0005\r!!\b\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011Y\n\u0005\u0004\u0003\u001e\n\r&QR\u0007\u0003\u0005?S1A!)w\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005K\u0013yJ\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002BV\u0005c\u00032!\u001eBW\u0013\r\u0011yK\u001e\u0002\b\u0005>|G.Z1o\u0011%\u0011)jOA\u0001\u0002\u0004\u0011i)\u0001\u0005iCND7i\u001c3f)\t\ti\"\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005W\u0013Y\fC\u0005\u0003\u0016v\n\t\u00111\u0001\u0003\u000e\"9!qX\u0011A\u0002\tM\u0012!A:\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0019\t\u0015\"Q\u0019Bd\u0005\u0013\u0014YM!4\t\u000f\t=\"\u00051\u0001\u00034!9!\u0011\n\u0012A\u0002\u0005u\u0001b\u0002B'E\u0001\u0007!1\u0007\u0005\b\u0005#\u0012\u0003\u0019AA\u000f\u0011\u001d\u0011)F\ta\u0001\u0003;\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003T\nm\u0007#B;\u0003\"\tU\u0007#D;\u0003X\nM\u0012Q\u0004B\u001a\u0003;\ti\"C\u0002\u0003ZZ\u0014a\u0001V;qY\u0016,\u0004\"\u0003BoG\u0005\u0005\t\u0019\u0001B\u0013\u0003\rAH\u0005M\u0001\u000f]\u0016<8i\u001c8oK\u000e$\u0018n\u001c8t+\t\u0011\u0019\u000f\u0005\u0004\u0003f\n=(1_\u0007\u0003\u0005OTAA!;\u0003l\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\t5\u0018qA\u0001\u0005kRLG.\u0003\u0003\u0003r\n\u001d(AE!se\u0006L(\t\\8dW&tw-U;fk\u0016\u0004BA!>\u0003\u00006\u0011!q\u001f\u0006\u0005\u0005s\u0014Y0\u0001\u0005dQ\u0006tg.\u001a7t\u0015\u0011\u0011i0a\u0002\u0002\u00079Lw.\u0003\u0003\u0004\u0002\t](!D*pG.,Go\u00115b]:,G.A\boK^\u001cuN\u001c8fGRLwN\\:!\u0003EIgN\u001a7jO\"$(+Z:q_:\u001cXm]\u000b\u0003\u0007\u0013\u0001\u0002ba\u0003\u0004\u0012\tM2QC\u0007\u0003\u0007\u001bQAaa\u0004\u0003 \u00069Q.\u001e;bE2,\u0017\u0002BB\n\u0007\u001b\u00111!T1q!\u0011\u00199b!\b\u000f\u0007E\u001cI\"C\u0002\u0004\u001c1\faBU3rk\u0016\u001cHo\u00115b]:,G.\u0003\u0003\u0004 \r\u0005\"\u0001\u0003*fgB|gn]3\u000b\u0007\rmA.\u0001\nj]\u001ad\u0017n\u001a5u%\u0016\u001c\bo\u001c8tKN\u0004\u0013!\u0004:fgB|gn]3Rk\u0016,X-\u0006\u0002\u0004*A1!Q]B\u0016\u0007+IAa!\f\u0003h\n\u0019B*\u001b8lK\u0012\u0014En\\2lS:<G)Z9vK\u0006q!/Z:q_:\u001cX-U;fk\u0016\u0004\u0013AC7fiJL7\rV1hgV\u00111Q\u0007\t\u0007\u0007o\u0019Id`@\u000e\u0005\t-\u0018\u0002BB\n\u0005W\f1\"\\3ue&\u001cG+Y4tA\u0005iR\r\u001f9je\u0016$7i\u001c8oK\u000e$\u0018n\u001c8t\u0017&dG.\u001a3D_VtG/\u0006\u0002\u0004BA!11IB%\u001b\t\u0019)E\u0003\u0003\u0004H\u0005u\u0016!B:uCR\u001c\u0018\u0002BB&\u0007\u000b\u0012Q\u0001V8uC2\fa$\u001a=qSJ,GmQ8o]\u0016\u001cG/[8og.KG\u000e\\3e\u0007>,h\u000e\u001e\u0011\u0002O\u0015D\b/\u001b:fI\u000e{gN\\3di&|gn]&jY2,GmQ8v]RlU\r\u001e:jG:\u000bW.Z\u000b\u0003\u0007'\u0002Ba!\u0016\u0004X5\u0011\u0011qL\u0005\u0005\u00073\nyF\u0001\u0006NKR\u0014\u0018n\u0019(b[\u0016\f\u0001&\u001a=qSJ,GmQ8o]\u0016\u001cG/[8og.KG\u000e\\3e\u0007>,h\u000e^'fiJL7MT1nK\u0002\n\u0001b]3mK\u000e$xN]\u000b\u0003\u0007C\u0002B!!%\u0004d%!1QMAJ\u0005!\u0019V\r\\3di>\u0014\u0018!C:fY\u0016\u001cGo\u001c:!\u00039\u0019'/Z1uKN+G.Z2u_J$Ba!\u0019\u0004n!91q\u000e'A\u0002\rE\u0014AD2iC:tW\r\u001c\"vS2$WM\u001d\t\u0005\u0003#\u001b\u0019(\u0003\u0003\u0004v\u0005M%AD\"iC:tW\r\u001c\"vS2$WM]\u0001\u0014]\u0016DHoQ8o]\u0016\u001cG/[8o\u0013:$W\r_\u0001\u0018]\u0016DHoQ8o]\u0016\u001cG/[8o\u0013:$W\r_0%KF$Ba! \u0004\u0004B\u0019Qoa \n\u0007\r\u0005eO\u0001\u0003V]&$\b\"\u0003BK\u001d\u0006\u0005\t\u0019AA\u000f\u0003QqW\r\u001f;D_:tWm\u0019;j_:Le\u000eZ3yA\u0005\u0019!/\u001e8\u0015\u0005\ru\u0014\u0001\u00059s_\u000e,7o]#yG\u0016\u0004H/[8o)\u0019\u0019iha$\u0004\u0014\"91\u0011S)A\u0002\tM\u0012\u0001D3se>\u0014X*Z:tC\u001e,\u0007bBBK#\u0002\u00071qS\u0001\ni\"\u0014xn^1cY\u0016\u0004Ba!'\u0004$:!11TBP\u001d\u0011\u0011Id!(\n\u0003]L1a!)w\u0003\u001d\u0001\u0018mY6bO\u0016LAa!*\u0004(\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0007C3\u0018a\u00069s_\u000e,7o]\"iC:tW\r\\#yG\u0016\u0004H/[8o)!\u0019ih!,\u00042\u000eM\u0006bBBX%\u0002\u0007!1G\u0001\nG\"\fgN\\3m\u0013\u0012Dqa!%S\u0001\u0004\u0011\u0019\u0004C\u0004\u0004\u0016J\u0003\raa&\u0002'A\u0014xnY3tg:+wOU3ta>t7/Z:\u0002\u0019M,g\u000e\u001a*fgB|gn]3\u0015\r\ru41XB`\u0011\u001d\u0019i\f\u0016a\u0001\u0007+\t\u0001B]3ta>t7/\u001a\u0005\b\u0007\u0003$\u0006\u0019ABb\u00031\u0011Xm\u001d9p]N,7+\u001a8e!\u0011\t\tj!2\n\t\r\u001d\u00171\u0013\u0002\u0005'\u0016tG-\u0001\to_^t\u0015M\\8t'V\u0004\b\u000f\\5feV\u00111Q\u001a\n\u0007\u0007\u001f\u001c\u0019n!7\u0007\r\rEW\u000bABg\u00051a$/\u001a4j]\u0016lWM\u001c;?!\u0011\t\ta!6\n\t\r]\u00171\u0001\u0002\u0007\u001f\nTWm\u0019;\u0011\r\rm7\u0011]Bs\u001b\t\u0019iN\u0003\u0003\u0004`\n-\u0018\u0001\u00034v]\u000e$\u0018n\u001c8\n\t\r\r8Q\u001c\u0002\t'V\u0004\b\u000f\\5feB!\u0011\u0011ABt\u0013\u0011\tI)a\u0001\u0002\tA|G\u000e\\\u0001\u0019aJ|7-Z:t\u0007>l\u0007\u000f\\3uK\u0012\u0014VmY3jm\u0016\u001c\u0018!\u00069s_\u000e,7o]\"p[BdW\r^3e'\u0016tGm]\u0001\u0015kB$\u0017\r^3SKF,Xm\u001d;NKR\u0014\u0018nY:\u0015\t\ru41\u001f\u0005\b\u0007{K\u0006\u0019AB\u000b\u0003M\u0001(o\\2fgN$\u0015n]2p]:,7\r^3e\u0003\u0015\u0019Gn\\:f)\u0011\u0019iha?\t\u000f\ru8\f1\u0001\u00034\u0005a1m\u001c8oK\u000e$\u0018n\u001c8JI\u00061\u0011mY2faR$\u0002Ba+\u0005\u0004\u0011\u001dA1\u0002\u0005\b\t\u000ba\u0006\u0019\u0001Bz\u00035\u0019xnY6fi\u000eC\u0017M\u001c8fY\"9A\u0011\u0002/A\u0002\t-\u0016\u0001C7bs\ncwnY6\t\u000f\u00115A\f1\u0001\u0005\u0010\u0005A\u0012mY2faR|'/\u00133mKB+'oY3oi6+G/\u001a:\u0011\t\u0011EA\u0011E\u0007\u0003\t'QA\u0001\"\u0006\u0005\u0018\u0005!1m\u001c:f\u0015\u0011\tY\u0005\"\u0007\u000b\t\u0011mAQD\u0001\u0007s\u0006lW.\u001a:\u000b\u0005\u0011}\u0011aA2p[&!A1\u0005C\n\u0005\u0015iU\r^3s\u0003]\u0019wN\u001c4jOV\u0014XMT3x\u0007>tg.Z2uS>t7/\u0001\u0005dY>\u001cX-\u00117m)\u0011\u0011\u0019\u0004b\u000b\t\u000f\u00115r\f1\u0001\u00050\u000511o\\2lKR\u0004B\u0001\"\r\u000585\u0011A1\u0007\u0006\u0005\tk\t9!A\u0002oKRLA\u0001\"\u000f\u00054\t11k\\2lKR\fq\"\u001a8rk\u0016,XMU3ta>t7/\u001a\u000b\u0005\u0007{\"y\u0004C\u0004\u0004>\u0002\u0004\ra!\u0006\u0002\u001f\u0011,\u0017/^3vKJ+7\u000f]8og\u0016$\"a!\u0006\u0002#I,7\u000f]8og\u0016\fV/Z;f'&TX-A\u000bj]\u001ad\u0017n\u001a5u%\u0016\u001c\bo\u001c8tK\u000e{WO\u001c;\u0002)=\u0004XM\\(s\u00072|7/\u001b8h\u0007\"\fgN\\3m)\u0011!i\u0005\"\u0016\u0011\u000bU\u0014\t\u0003b\u0014\u0011\t\u0005EE\u0011K\u0005\u0005\t'\n\u0019J\u0001\u0007LC\u001a\\\u0017m\u00115b]:,G\u000eC\u0004\u0004~\u0012\u0004\rAa\r\u0002-!\fg\u000e\u001a7f\u0007\"\fgN\\3m\u001bV$X-\u0012<f]R$ba! \u0005\\\u0011u\u0003bBB\u007fK\u0002\u0007!1\u0007\u0005\b\t?*\u0007\u0019\u0001C1\u0003\u0015)g/\u001a8u!\u0011!\u0019\u0007\" \u000f\t\u0011\u0015D\u0011\u0010\b\u0005\tO\"9H\u0004\u0003\u0005j\u0011Ud\u0002\u0002C6\tgrA\u0001\"\u001c\u0005r9!!\u0011\bC8\u0013\t\tY'\u0003\u0003\u0002h\u0005%\u0014bA8\u0002f%!\u0011\u0011MA2\u0013\ri\u0017qL\u0005\u0005\tw\n\u0019*\u0001\u0007LC\u001a\\\u0017m\u00115b]:,G.\u0003\u0003\u0005\u0000\u0011\u0005%\u0001E\"iC:tW\r\\'vi\u0016,e/\u001a8u\u0015\u0011!Y(a%\u0002!Q\u0014\u00180\u00168nkR,7\t[1o]\u0016dG\u0003BB?\t\u000fCqa!@g\u0001\u0004\u0011\u0019$A\u0004dQ\u0006tg.\u001a7\u0015\t\u00115CQ\u0012\u0005\b\u0007{<\u0007\u0019\u0001B\u001a\u0003EqW/\\*uC\u001e,GMU3dK&4Xm\u001d\u000b\u0005\u0003;!\u0019\nC\u0004\u0004~\"\u0004\rAa\r\u0002\r]\f7.Z;q\u0003!\u0019\b.\u001e;e_^t\u0007")
public class Processor
extends AbstractServerThread
implements KafkaMetricsGroup {
    private volatile Processor$ConnectionId$ ConnectionId$module;
    private final int id;
    public final Time kafka$network$Processor$$time;
    private final int maxRequestSize;
    private final RequestChannel requestChannel;
    private final ConnectionQuotas connectionQuotas;
    private final long connectionsMaxIdleMs;
    private final int failedAuthenticationDelayMs;
    private final ListenerName listenerName;
    private final SecurityProtocol securityProtocol;
    private final KafkaConfig config;
    public final Metrics kafka$network$Processor$$metrics;
    private final MemoryPool memoryPool;
    private final LogContext logContext;
    private final int connectionQueueSize;
    private final ArrayBlockingQueue<SocketChannel> newConnections;
    private final scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses;
    private final LinkedBlockingDeque<RequestChannel.Response> responseQueue;
    private final java.util.Map<String, String> metricTags;
    private final Total expiredConnectionsKilledCount;
    private final MetricName expiredConnectionsKilledCountMetricName;
    private final Selector selector;
    private int nextConnectionIndex;

    public static int $lessinit$greater$default$15() {
        return Processor$.MODULE$.$lessinit$greater$default$15();
    }

    public static int ConnectionQueueSize() {
        return Processor$.MODULE$.ConnectionQueueSize();
    }

    public static String ListenerMetricTag() {
        return Processor$.MODULE$.ListenerMetricTag();
    }

    public static String NetworkProcessorMetricTag() {
        return Processor$.MODULE$.NetworkProcessorMetricTag();
    }

    public static String IdlePercentMetricName() {
        return Processor$.MODULE$.IdlePercentMetricName();
    }

    @Override
    public com.yammer.metrics.core.MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public com.yammer.metrics.core.MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    private Processor$ConnectionId$ ConnectionId() {
        if (this.ConnectionId$module == null) {
            this.ConnectionId$lzycompute$1();
        }
        return this.ConnectionId$module;
    }

    public int id() {
        return this.id;
    }

    private ArrayBlockingQueue<SocketChannel> newConnections() {
        return this.newConnections;
    }

    private scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses() {
        return this.inflightResponses;
    }

    private LinkedBlockingDeque<RequestChannel.Response> responseQueue() {
        return this.responseQueue;
    }

    public java.util.Map<String, String> metricTags() {
        return this.metricTags;
    }

    public Total expiredConnectionsKilledCount() {
        return this.expiredConnectionsKilledCount;
    }

    private MetricName expiredConnectionsKilledCountMetricName() {
        return this.expiredConnectionsKilledCountMetricName;
    }

    private Selector selector() {
        return this.selector;
    }

    public Selector createSelector(ChannelBuilder channelBuilder) {
        ChannelBuilder channelBuilder2 = channelBuilder;
        if (channelBuilder2 instanceof Reconfigurable) {
            ChannelBuilder channelBuilder3 = channelBuilder2;
            this.config.addReconfigurable((Reconfigurable)channelBuilder3);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return new Selector(this.maxRequestSize, this.connectionsMaxIdleMs, this.failedAuthenticationDelayMs, this.kafka$network$Processor$$metrics, this.kafka$network$Processor$$time, "socket-server", this.metricTags(), false, true, channelBuilder, this.memoryPool, this.logContext);
    }

    private int nextConnectionIndex() {
        return this.nextConnectionIndex;
    }

    private void nextConnectionIndex_$eq(int x$1) {
        this.nextConnectionIndex = x$1;
    }

    @Override
    public void run() {
        block7: {
            this.startupComplete();
            block5: while (true) {
                while (this.isRunning()) {
                    try {
                        this.configureNewConnections();
                        this.processNewResponses();
                        this.poll();
                        this.processCompletedReceives();
                        this.processCompletedSends();
                        this.processDisconnected();
                        continue block5;
                    }
                    catch (Throwable e) {
                        this.processException("Processor got uncaught exception.", e);
                    }
                }
                break block7;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Closing selector - processor ").append(this.id()).toString());
                CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.closeAll(), this, Level.ERROR);
                this.shutdownComplete();
            }
        }
    }

    private void processException(String errorMessage, Throwable throwable) {
        Throwable throwable2 = throwable;
        if (throwable2 instanceof ControlThrowable) {
            ControlThrowable controlThrowable = (ControlThrowable)throwable2;
            throw (Throwable)controlThrowable;
        }
        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMessage, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable2);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void processChannelException(String channelId, String errorMessage, Throwable throwable) {
        if (this.openOrClosingChannel(channelId).isDefined()) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Closing socket for ").append(channelId).append(" because of error").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
            this.close(channelId);
        }
        this.processException(errorMessage, throwable);
    }

    private void processNewResponses() {
        RequestChannel.Response currentResponse = null;
        while ((currentResponse = this.dequeueResponse()) != null) {
            String channelId = currentResponse.request().context().connectionId;
            try {
                BoxedUnit boxedUnit;
                RequestChannel.Response response = currentResponse;
                if (response instanceof RequestChannel.NoOpResponse) {
                    RequestChannel.NoOpResponse noOpResponse = (RequestChannel.NoOpResponse)response;
                    this.updateRequestMetrics(noOpResponse);
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Socket server received empty response to send, registering for read: ").append(noOpResponse).toString());
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.RESPONSE_SENT);
                    this.tryUnmuteChannel(channelId);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (response instanceof RequestChannel.SendResponse) {
                    RequestChannel.SendResponse sendResponse = (RequestChannel.SendResponse)response;
                    this.sendResponse(sendResponse, sendResponse.responseSend());
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (response instanceof RequestChannel.CloseConnectionResponse) {
                    RequestChannel.CloseConnectionResponse closeConnectionResponse = (RequestChannel.CloseConnectionResponse)response;
                    this.updateRequestMetrics(closeConnectionResponse);
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing socket connection actively according to the response code.");
                    this.close(channelId);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (response instanceof RequestChannel.StartThrottlingResponse) {
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.THROTTLE_STARTED);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (response instanceof RequestChannel.EndThrottlingResponse) {
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.THROTTLE_ENDED);
                    this.tryUnmuteChannel(channelId);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw new IllegalArgumentException(new StringBuilder(23).append("Unknown response type: ").append(currentResponse.getClass()).toString());
            }
            catch (Throwable e) {
                this.processChannelException(channelId, new StringBuilder(40).append("Exception while processing response for ").append(channelId).toString(), e);
            }
        }
    }

    public void sendResponse(RequestChannel.Response response, Send responseSend) {
        block1: {
            String connectionId = response.request().context().connectionId;
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(85).append("Socket server received response to send to ").append(connectionId).append(", registering for write and sending data: ").append(response).toString());
            if (this.channel(connectionId).isEmpty()) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(93).append("Attempting to send response via channel for which there is no open connection, connection id ").append(connectionId).toString());
                response.request().updateRequestMetrics(0L, response);
            }
            if (!this.openOrClosingChannel(connectionId).isDefined()) break block1;
            this.selector().send(responseSend);
            this.inflightResponses().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)connectionId), (Object)response));
        }
    }

    private Supplier<Long> nowNanosSupplier() {
        return new Supplier<Long>(this){
            private final /* synthetic */ Processor $outer;

            public Long get() {
                return Predef$.MODULE$.long2Long(this.$outer.kafka$network$Processor$$time.nanoseconds());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    private void poll() {
        int pollTimeout = this.newConnections().isEmpty() ? 300 : 0;
        try {
            this.selector().poll((long)pollTimeout);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof IllegalStateException ? true : throwable2 instanceof IOException;
            if (bl) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Processor ").append(this.id()).append(" poll failed").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable2);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private void processCompletedReceives() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.selector().completedReceives()).asScala()).foreach((Function1 & Serializable & scala.Serializable)receive -> {
            Processor.$anonfun$processCompletedReceives$1(this, receive);
            return BoxedUnit.UNIT;
        });
    }

    private void processCompletedSends() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.selector().completedSends()).asScala()).foreach((Function1 & Serializable & scala.Serializable)send -> {
            Processor.$anonfun$processCompletedSends$1(this, send);
            return BoxedUnit.UNIT;
        });
    }

    private void updateRequestMetrics(RequestChannel.Response response) {
        RequestChannel.Request request = response.request();
        long networkThreadTimeNanos = BoxesRunTime.unboxToLong((Object)this.openOrClosingChannel(request.context().connectionId).fold((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L, (Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToLong((long)x$16.getAndResetNetworkThreadTimeNanos())));
        request.updateRequestMetrics(networkThreadTimeNanos, response);
    }

    private void processDisconnected() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.selector().disconnected().keySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)connectionId -> {
            Processor.$anonfun$processDisconnected$1(this, connectionId);
            return BoxedUnit.UNIT;
        });
    }

    private void close(String connectionId) {
        this.openOrClosingChannel(connectionId).foreach((Function1 & Serializable & scala.Serializable)channel -> {
            Processor.$anonfun$close$4(this, connectionId, channel);
            return BoxedUnit.UNIT;
        });
    }

    public boolean accept(SocketChannel socketChannel, boolean mayBlock, Meter acceptorIdlePercentMeter) {
        boolean accepted;
        block4: {
            boolean bl;
            if (this.newConnections().offer(socketChannel)) {
                bl = true;
            } else if (mayBlock) {
                long startNs = this.kafka$network$Processor$$time.nanoseconds();
                this.newConnections().put(socketChannel);
                acceptorIdlePercentMeter.mark(this.kafka$network$Processor$$time.nanoseconds() - startNs);
                bl = true;
            } else {
                bl = accepted = false;
            }
            if (!accepted) break block4;
            this.wakeup();
        }
        return accepted;
    }

    private void configureNewConnections() {
        int connectionsProcessed = 0;
        while (connectionsProcessed < this.connectionQueueSize && !this.newConnections().isEmpty()) {
            SocketChannel channel = this.newConnections().poll();
            try {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Processor ").append(this.id()).append(" listening to new connection from ").append(channel.socket().getRemoteSocketAddress()).toString());
                this.selector().register(this.connectionId(channel.socket()), channel);
                ++connectionsProcessed;
            }
            catch (Throwable e) {
                SocketAddress remoteAddress = channel.socket().getRemoteSocketAddress();
                this.close(channel);
                this.processException(new StringBuilder(34).append("Processor ").append(this.id()).append(" closed connection from ").append(remoteAddress).toString(), e);
            }
        }
    }

    private void closeAll() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.selector().channels()).asScala()).foreach((Function1 & Serializable & scala.Serializable)channel -> {
            this.close(channel.id());
            return BoxedUnit.UNIT;
        });
        this.selector().close();
        this.removeMetric(Processor$.MODULE$.IdlePercentMetricName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag()), (Object)((Object)BoxesRunTime.boxToInteger((int)this.id())).toString())}))));
    }

    public String connectionId(Socket socket) {
        String localHost = socket.getLocalAddress().getHostAddress();
        int localPort = socket.getLocalPort();
        String remoteHost = socket.getInetAddress().getHostAddress();
        int remotePort = socket.getPort();
        String connId = new ConnectionId(this, localHost, localPort, remoteHost, remotePort, this.nextConnectionIndex()).toString();
        this.nextConnectionIndex_$eq(this.nextConnectionIndex() == Integer.MAX_VALUE ? 0 : this.nextConnectionIndex() + 1);
        return connId;
    }

    public void enqueueResponse(RequestChannel.Response response) {
        this.responseQueue().put(response);
        this.wakeup();
    }

    /*
     * WARNING - void declaration
     */
    private RequestChannel.Response dequeueResponse() {
        void var1_1;
        block0: {
            RequestChannel.Response response = this.responseQueue().poll();
            if (response == null) break block0;
            response.request().responseDequeueTimeNanos_$eq(Time.SYSTEM.nanoseconds());
        }
        return var1_1;
    }

    public int responseQueueSize() {
        return this.responseQueue().size();
    }

    public int inflightResponseCount() {
        return this.inflightResponses().size();
    }

    public Option<KafkaChannel> openOrClosingChannel(String connectionId) {
        return Option$.MODULE$.apply((Object)this.selector().channel(connectionId)).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)this.selector().closingChannel(connectionId)));
    }

    private void handleChannelMuteEvent(String connectionId, KafkaChannel.ChannelMuteEvent event) {
        this.openOrClosingChannel(connectionId).foreach((Function1 & Serializable & scala.Serializable)c -> {
            c.handleChannelMuteEvent(event);
            return BoxedUnit.UNIT;
        });
    }

    private void tryUnmuteChannel(String connectionId) {
        this.openOrClosingChannel(connectionId).foreach((Function1 & Serializable & scala.Serializable)c -> {
            Processor.$anonfun$tryUnmuteChannel$1(this, c);
            return BoxedUnit.UNIT;
        });
    }

    public Option<KafkaChannel> channel(String connectionId) {
        return Option$.MODULE$.apply((Object)this.selector().channel(connectionId));
    }

    public int numStagedReceives(String connectionId) {
        return BoxesRunTime.unboxToInt((Object)this.openOrClosingChannel(connectionId).map((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToInteger((int)Processor.$anonfun$numStagedReceives$1(this, c))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    @Override
    public void wakeup() {
        this.selector().wakeup();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.removeMetric("IdlePercent", (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"networkProcessor"), (Object)((Object)BoxesRunTime.boxToInteger((int)this.id())).toString())}))));
        this.kafka$network$Processor$$metrics.removeMetric(this.expiredConnectionsKilledCountMetricName());
    }

    private final void ConnectionId$lzycompute$1() {
        Processor processor = this;
        synchronized (processor) {
            if (this.ConnectionId$module == null) {
                this.ConnectionId$module = new Processor$ConnectionId$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$processCompletedReceives$1(Processor $this, NetworkReceive receive) {
        try {
            BoxedUnit boxedUnit;
            Option<KafkaChannel> option = $this.openOrClosingChannel(receive.source());
            if (option instanceof Some) {
                Some some = (Some)option;
                KafkaChannel channel = (KafkaChannel)some.value();
                RequestHeader header = RequestHeader.parse((ByteBuffer)receive.payload());
                ApiKeys apiKeys = header.apiKey();
                ApiKeys apiKeys2 = ApiKeys.SASL_HANDSHAKE;
                if (!(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null) && channel.maybeBeginServerReauthentication(receive, $this.nowNanosSupplier())) {
                    $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Begin re-authentication: ").append(channel).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    long nowNanos = $this.kafka$network$Processor$$time.nanoseconds();
                    if (channel.serverAuthenticationSessionExpired(nowNanos)) {
                        channel.disconnect();
                        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Disconnected expired channel: ").append(channel).append(" : ").append(header).toString());
                        $this.expiredConnectionsKilledCount().record(null, 1.0, 0L);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        String connectionId = receive.source();
                        RequestContext context = new RequestContext(header, connectionId, channel.socketAddress(), channel.principal(), $this.listenerName, $this.securityProtocol);
                        RequestChannel.Request req = new RequestChannel.Request($this.id(), context, nowNanos, $this.memoryPool, receive.payload(), $this.requestChannel.metrics());
                        $this.requestChannel.sendRequest(req);
                        $this.selector().mute(connectionId);
                        $this.handleChannelMuteEvent(connectionId, KafkaChannel.ChannelMuteEvent.REQUEST_RECEIVED);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            } else {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException(new StringBuilder(66).append("Channel ").append(receive.source()).append(" removed from selector before processing completed receive").toString());
                }
                throw new MatchError(option);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
        catch (Throwable e) {
            $this.processChannelException(receive.source(), new StringBuilder(40).append("Exception while processing request from ").append(receive.source()).toString(), e);
        }
    }

    public static final /* synthetic */ void $anonfun$processCompletedSends$1(Processor $this, Send send) {
        try {
            RequestChannel.Response response = (RequestChannel.Response)$this.inflightResponses().remove((Object)send.destination()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException(new StringBuilder(51).append("Send for ").append(send.destination()).append(" completed, but not in `inflightResponses`").toString());
            });
            $this.updateRequestMetrics(response);
            response.onComplete().foreach((Function1 & Serializable & scala.Serializable)onComplete -> {
                onComplete.apply((Object)send);
                return BoxedUnit.UNIT;
            });
            $this.handleChannelMuteEvent(send.destination(), KafkaChannel.ChannelMuteEvent.RESPONSE_SENT);
            $this.tryUnmuteChannel(send.destination());
        }
        catch (Throwable e) {
            $this.processChannelException(send.destination(), new StringBuilder(45).append("Exception while processing completed send to ").append(send.destination()).toString(), e);
        }
    }

    public static final /* synthetic */ void $anonfun$processDisconnected$1(Processor $this, String connectionId) {
        try {
            String remoteHost = ((ConnectionId)$this.ConnectionId().fromString(connectionId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException(new StringBuilder(36).append("connectionId has unexpected format: ").append(connectionId).toString());
            })).remoteHost();
            $this.inflightResponses().remove((Object)connectionId).foreach((Function1 & Serializable & scala.Serializable)response -> {
                $this.updateRequestMetrics(response);
                return BoxedUnit.UNIT;
            });
            $this.connectionQuotas.dec(InetAddress.getByName(remoteHost));
        }
        catch (Throwable e) {
            $this.processException(new StringBuilder(44).append("Exception while processing disconnection of ").append(connectionId).toString(), e);
        }
    }

    public static final /* synthetic */ void $anonfun$close$4(Processor $this, String connectionId$3, KafkaChannel channel) {
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Closing selector connection ").append(connectionId$3).toString());
        InetAddress address = channel.socketAddress();
        if (address != null) {
            $this.connectionQuotas.dec(address);
        }
        $this.selector().close(connectionId$3);
        $this.inflightResponses().remove((Object)connectionId$3).foreach((Function1 & Serializable & scala.Serializable)response -> {
            $this.updateRequestMetrics(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$tryUnmuteChannel$1(Processor $this, KafkaChannel c) {
        $this.selector().unmute(c.id());
    }

    public static final /* synthetic */ int $anonfun$numStagedReceives$1(Processor $this, KafkaChannel c) {
        return $this.selector().numStagedReceives(c);
    }

    public Processor(int id, Time time, int maxRequestSize, RequestChannel requestChannel, ConnectionQuotas connectionQuotas, long connectionsMaxIdleMs, int failedAuthenticationDelayMs, ListenerName listenerName, SecurityProtocol securityProtocol, KafkaConfig config, Metrics metrics, CredentialProvider credentialProvider, MemoryPool memoryPool, LogContext logContext, int connectionQueueSize) {
        this.id = id;
        this.kafka$network$Processor$$time = time;
        this.maxRequestSize = maxRequestSize;
        this.requestChannel = requestChannel;
        this.connectionQuotas = connectionQuotas;
        this.connectionsMaxIdleMs = connectionsMaxIdleMs;
        this.failedAuthenticationDelayMs = failedAuthenticationDelayMs;
        this.listenerName = listenerName;
        this.securityProtocol = securityProtocol;
        this.config = config;
        this.kafka$network$Processor$$metrics = metrics;
        this.memoryPool = memoryPool;
        this.logContext = logContext;
        this.connectionQueueSize = connectionQueueSize;
        super(connectionQuotas);
        KafkaMetricsGroup.$init$(this);
        this.newConnections = new ArrayBlockingQueue(connectionQueueSize);
        this.inflightResponses = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.responseQueue = new LinkedBlockingDeque();
        this.metricTags = (java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)LinkedHashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)listenerName.value()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag()), (Object)((Object)BoxesRunTime.boxToInteger((int)id)).toString())}))).asJava();
        this.newGauge(Processor$.MODULE$.IdlePercentMetricName(), new Gauge<Object>(this){
            private final /* synthetic */ Processor $outer;

            public double value() {
                return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)this.$outer.kafka$network$Processor$$metrics.metric(this.$outer.kafka$network$Processor$$metrics.metricName("io-wait-ratio", SocketServer$.MODULE$.MetricsGroup(), this.$outer.metricTags()))).fold((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, (Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToDouble((double)$anon$7.$anonfun$value$20(m))));
            }

            public static final /* synthetic */ double $anonfun$value$20(KafkaMetric m) {
                return Math.min(BoxesRunTime.unboxToDouble((Object)m.metricValue()), 1.0);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$19(), $anonfun$value$20$adapted(org.apache.kafka.common.metrics.KafkaMetric )}, serializedLambda);
            }
        }, (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag()), (Object)((Object)BoxesRunTime.boxToInteger((int)id)).toString())}))));
        this.expiredConnectionsKilledCount = new Total();
        this.expiredConnectionsKilledCountMetricName = metrics.metricName("expired-connections-killed-count", "socket-server-metrics", this.metricTags());
        metrics.addMetric(this.expiredConnectionsKilledCountMetricName(), (Measurable)this.expiredConnectionsKilledCount());
        ListenerName listenerName2 = listenerName;
        ListenerName listenerName3 = config.interBrokerListenerName();
        this.selector = this.createSelector(ChannelBuilders.serverChannelBuilder((ListenerName)listenerName, (!(listenerName2 != null ? !listenerName2.equals(listenerName3) : listenerName3 != null) ? 1 : 0) != 0, (SecurityProtocol)securityProtocol, (AbstractConfig)config, (CredentialCache)credentialProvider.credentialCache(), (DelegationTokenCache)credentialProvider.tokenCache(), (Time)time));
        this.nextConnectionIndex = 0;
    }

    public class ConnectionId
    implements Product,
    scala.Serializable {
        private final String localHost;
        private final int localPort;
        private final String remoteHost;
        private final int remotePort;
        private final int index;
        public final /* synthetic */ Processor $outer;

        public String localHost() {
            return this.localHost;
        }

        public int localPort() {
            return this.localPort;
        }

        public String remoteHost() {
            return this.remoteHost;
        }

        public int remotePort() {
            return this.remotePort;
        }

        public int index() {
            return this.index;
        }

        public String toString() {
            return new StringBuilder(4).append(this.localHost()).append(":").append(this.localPort()).append("-").append(this.remoteHost()).append(":").append(this.remotePort()).append("-").append(this.index()).toString();
        }

        public ConnectionId copy(String localHost, int localPort, String remoteHost, int remotePort, int index) {
            return new ConnectionId(this.kafka$network$Processor$ConnectionId$$$outer(), localHost, localPort, remoteHost, remotePort, index);
        }

        public String copy$default$1() {
            return this.localHost();
        }

        public int copy$default$2() {
            return this.localPort();
        }

        public String copy$default$3() {
            return this.remoteHost();
        }

        public int copy$default$4() {
            return this.remotePort();
        }

        public int copy$default$5() {
            return this.index();
        }

        public String productPrefix() {
            return "ConnectionId";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.localHost();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this.localPort());
                    break;
                }
                case 2: {
                    object = this.remoteHost();
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToInteger((int)this.remotePort());
                    break;
                }
                case 4: {
                    object = BoxesRunTime.boxToInteger((int)this.index());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ConnectionId;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.localHost()));
            n = Statics.mix((int)n, (int)this.localPort());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.remoteHost()));
            n = Statics.mix((int)n, (int)this.remotePort());
            n = Statics.mix((int)n, (int)this.index());
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ConnectionId)) return false;
            if (((ConnectionId)object).kafka$network$Processor$ConnectionId$$$outer() != this.kafka$network$Processor$ConnectionId$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ConnectionId connectionId = (ConnectionId)x$1;
            String string = this.localHost();
            String string2 = connectionId.localHost();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.localPort() != connectionId.localPort()) return false;
            String string3 = this.remoteHost();
            String string4 = connectionId.remoteHost();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (this.remotePort() != connectionId.remotePort()) return false;
            if (this.index() != connectionId.index()) return false;
            if (!connectionId.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Processor kafka$network$Processor$ConnectionId$$$outer() {
            return this.$outer;
        }

        public ConnectionId(Processor $outer, String localHost, int localPort, String remoteHost, int remotePort, int index) {
            this.localHost = localHost;
            this.localPort = localPort;
            this.remoteHost = remoteHost;
            this.remotePort = remotePort;
            this.index = index;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

