/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.controller.Callbacks;
import kafka.controller.Callbacks$;
import kafka.controller.ControllerContext;
import kafka.controller.ControllerEventManager;
import kafka.controller.KafkaController;
import kafka.controller.NonExistentPartition$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.requests.AbstractResponse;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001B\u0012%\u0001%B\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005w!Aa\b\u0001B\u0001B\u0003%q\bC\u0003F\u0001\u0011\u0005a\tC\u0004L\u0001\t\u0007I\u0011\u0001'\t\rA\u0003\u0001\u0015!\u0003N\u0011\u001d\t\u0006A1A\u0005\u0002ICaa\u0017\u0001!\u0002\u0013\u0019\u0006b\u0002/\u0001\u0005\u0004%\t!\u0018\u0005\u0007c\u0002\u0001\u000b\u0011\u00020\t\u000fI\u0004!\u0019!C\u0001;\"11\u000f\u0001Q\u0001\nyCq\u0001\u001e\u0001C\u0002\u0013\u0005Q\f\u0003\u0004v\u0001\u0001\u0006IA\u0018\u0005\u0006m\u0002!\ta\u001e\u0005\b\u0003\u000b\u0001A\u0011AA\u0004\u0011\u001d\tI\u0001\u0001C\u0001\u0003\u000fAq!a\u0003\u0001\t\u0003\ti\u0001C\u0004\u0002\u0014\u0001!\t!!\u0006\t\u0013\u0005e\u0001!%A\u0005\u0002\u0005m\u0001bBA\u0019\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003\u0003\u0002A\u0011AA\"\u0011\u001d\t9\u0005\u0001C\u0005\u0003\u0013Bq!a\u0015\u0001\t\u0013\t)\u0006C\u0004\u0002Z\u0001!\t!a\u0017\t\u000f\u0005}\u0003\u0001\"\u0001\u0002b!9\u0011Q\r\u0001\u0005\u0002\u0005\u001d\u0004bBA6\u0001\u0011%\u0011Q\u000e\u0005\b\u0003c\u0002A\u0011BA:\u0011\u001d\t9\b\u0001C\u0005\u0003sBq!! \u0001\t\u0013\ty\bC\u0004\u0002\u0004\u0002!I!!\"\t\u000f\u0005-\u0005\u0001\"\u0003\u0002\u000e\"9\u00111\u0016\u0001\u0005\n\u0005\u001d!\u0001\u0006+pa&\u001cG)\u001a7fi&|g.T1oC\u001e,'O\u0003\u0002&M\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0003\u001d\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001UA\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012a!\u00118z%\u00164\u0007CA\u00195\u001b\u0005\u0011$BA\u001a'\u0003\u0015)H/\u001b7t\u0013\t)$GA\u0004M_\u001e<\u0017N\\4\u0011\u0005]BT\"\u0001\u0013\n\u0005e\"#aD&bM.\f7i\u001c8ue>dG.\u001a:\u0002\u0019\u00154XM\u001c;NC:\fw-\u001a:\u0011\u0005]b\u0014BA\u001f%\u0005Y\u0019uN\u001c;s_2dWM]#wK:$X*\u00198bO\u0016\u0014\u0018\u0001\u0003>l\u00072LWM\u001c;\u0011\u0005\u0001\u001bU\"A!\u000b\u0005\t3\u0013A\u0001>l\u0013\t!\u0015IA\u0007LC\u001a\\\u0017MW6DY&,g\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u001dC\u0015J\u0013\t\u0003o\u0001AQ!\n\u0003A\u0002YBQA\u000f\u0003A\u0002mBQA\u0010\u0003A\u0002}\n\u0011cY8oiJ|G\u000e\\3s\u0007>tG/\u001a=u+\u0005i\u0005CA\u001cO\u0013\tyEEA\tD_:$(o\u001c7mKJ\u001cuN\u001c;fqR\f!cY8oiJ|G\u000e\\3s\u0007>tG/\u001a=uA\u0005!\u0012n\u001d#fY\u0016$X\rV8qS\u000e,e.\u00192mK\u0012,\u0012a\u0015\t\u0003)fk\u0011!\u0016\u0006\u0003-^\u000bA\u0001\\1oO*\t\u0001,\u0001\u0003kCZ\f\u0017B\u0001.V\u0005\u001d\u0011un\u001c7fC:\fQ#[:EK2,G/\u001a+pa&\u001cWI\\1cY\u0016$\u0007%A\tu_BL7m\u001d+p\u0005\u0016$U\r\\3uK\u0012,\u0012A\u0018\t\u0004?\u00124W\"\u00011\u000b\u0005\u0005\u0014\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0003G2\n!bY8mY\u0016\u001cG/[8o\u0013\t)\u0007MA\u0002TKR\u0004\"a\u001a8\u000f\u0005!d\u0007CA5-\u001b\u0005Q'BA6)\u0003\u0019a$o\\8u}%\u0011Q\u000eL\u0001\u0007!J,G-\u001a4\n\u0005=\u0004(AB*ue&twM\u0003\u0002nY\u0005\u0011Bo\u001c9jGN$vNQ3EK2,G/\u001a3!\u0003e!x\u000e]5dg^KG\u000f\u001b#fY\u0016$\u0018n\u001c8Ti\u0006\u0014H/\u001a3\u00025Q|\u0007/[2t/&$\b\u000eR3mKRLwN\\*uCJ$X\r\u001a\u0011\u00027Q|\u0007/[2t\u0013:,G.[4jE2,gi\u001c:EK2,G/[8o\u0003q!x\u000e]5dg&sW\r\\5hS\ndWMR8s\t\u0016dW\r^5p]\u0002\nA!\u001b8jiR!\u0001p_A\u0001!\tY\u00130\u0003\u0002{Y\t!QK\\5u\u0011\u0015ax\u00021\u0001~\u0003aIg.\u001b;jC2$v\u000e]5dgR{')\u001a#fY\u0016$X\r\u001a\t\u0004}~4W\"\u00012\n\u0005\u0015\u0014\u0007BBA\u0002\u001f\u0001\u0007Q0\u0001\u0012j]&$\u0018.\u00197U_BL7m]%oK2Lw-\u001b2mK\u001a{'\u000fR3mKRLwN\\\u0001\u0011iJLHk\u001c9jG\u0012+G.\u001a;j_:$\u0012\u0001_\u0001\u0006e\u0016\u001cX\r^\u0001\u0019K:\fX/Z;f)>\u0004\u0018nY:G_J$U\r\\3uS>tGc\u0001=\u0002\u0010!1\u0011\u0011\u0003\nA\u0002u\fa\u0001^8qS\u000e\u001c\u0018a\u0006:fgVlW\rR3mKRLwN\u001c$peR{\u0007/[2t)\rA\u0018q\u0003\u0005\t\u0003#\u0019\u0002\u0013!a\u0001{\u0006\t#/Z:v[\u0016$U\r\\3uS>tgi\u001c:U_BL7m\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0004\u0016\u0004{\u0006}1FAA\u0011!\u0011\t\u0019#!\f\u000e\u0005\u0005\u0015\"\u0002BA\u0014\u0003S\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-B&\u0001\u0006b]:|G/\u0019;j_:LA!a\f\u0002&\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002'\u0019\f\u0017\u000e\u001c*fa2L7-\u0019#fY\u0016$\u0018n\u001c8\u0015\u0007a\f)\u0004C\u0004\u00028U\u0001\r!!\u000f\u0002\u0011I,\u0007\u000f\\5dCN\u0004BA`@\u0002<A\u0019q'!\u0010\n\u0007\u0005}BEA\nQCJ$\u0018\u000e^5p]\u0006sGMU3qY&\u001c\u0017-\u0001\u0010nCJ\\Gk\u001c9jG&sW\r\\5hS\ndWMR8s\t\u0016dW\r^5p]R\u0019\u00010!\u0012\t\r\u0005Ea\u00031\u0001~\u0003qI7\u000fV8qS\u000eLe.\u001a7jO&\u0014G.\u001a$pe\u0012+G.\u001a;j_:$B!a\u0013\u0002PA\u00191&!\u0014\n\u0005ic\u0003BBA)/\u0001\u0007a-A\u0003u_BL7-A\rjgR{\u0007/[2EK2,G/[8o\u0013:\u0004&o\\4sKN\u001cH\u0003BA&\u0003/Ba!!\u0015\u0019\u0001\u00041\u0017AG5t)>\u0004\u0018nY,ji\"$U\r\\3uS>t7\u000b^1si\u0016$G\u0003BA&\u0003;Ba!!\u0015\u001a\u0001\u00041\u0017AG5t)>\u0004\u0018nY)vKV,G-\u00169G_J$U\r\\3uS>tG\u0003BA&\u0003GBa!!\u0015\u001b\u0001\u00041\u0017aF2p[BdW\r^3SKBd\u0017nY1EK2,G/[8o)\rA\u0018\u0011\u000e\u0005\b\u0003oY\u0002\u0019AA\u001d\u0003iI7\u000fV8qS\u000e,E.[4jE2,gi\u001c:EK2,G/[8o)\u0011\tY%a\u001c\t\r\u0005EC\u00041\u0001g\u0003ei\u0017M]6U_BL7MR8s\t\u0016dW\r^5p]J+GO]=\u0015\u0007a\f)\b\u0003\u0004\u0002Ru\u0001\rAZ\u0001\u0014G>l\u0007\u000f\\3uK\u0012+G.\u001a;f)>\u0004\u0018n\u0019\u000b\u0004q\u0006m\u0004BBA)=\u0001\u0007a-A\bp]R{\u0007/[2EK2,G/[8o)\rA\u0018\u0011\u0011\u0005\u0007\u0003#y\u0002\u0019A?\u0002)M$\u0018M\u001d;SKBd\u0017nY1EK2,G/[8o)\rA\u0018q\u0011\u0005\b\u0003\u0013\u0003\u0003\u0019AA\u001d\u0003q\u0011X\r\u001d7jG\u0006\u001chi\u001c:U_BL7m\u001d+p\u0005\u0016$U\r\\3uK\u0012\f1c\u001c8QCJ$\u0018\u000e^5p]\u0012+G.\u001a;j_:$2\u0001_AH\u0011\u001d\t\t*\ta\u0001\u0003'\u000bQ\u0003]1si&$\u0018n\u001c8t)>\u0014U\rR3mKR,G\r\u0005\u0003\u007f\u007f\u0006U\u0005\u0003BAL\u0003Ok!!!'\u000b\t\u0005m\u0015QT\u0001\u0007G>lWn\u001c8\u000b\u0007\u001d\nyJ\u0003\u0003\u0002\"\u0006\r\u0016AB1qC\u000eDWM\u0003\u0002\u0002&\u0006\u0019qN]4\n\t\u0005%\u0016\u0011\u0014\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=\u0011Xm];nK\u0012+G.\u001a;j_:\u001c\b")
public class TopicDeletionManager
implements Logging {
    private final KafkaController controller;
    private final ControllerEventManager eventManager;
    private final KafkaZkClient zkClient;
    private final ControllerContext controllerContext;
    private final Boolean isDeleteTopicEnabled;
    private final scala.collection.mutable.Set<String> topicsToBeDeleted;
    private final scala.collection.mutable.Set<String> topicsWithDeletionStarted;
    private final scala.collection.mutable.Set<String> topicsIneligibleForDeletion;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TopicDeletionManager topicDeletionManager = this;
        synchronized (topicDeletionManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ControllerContext controllerContext() {
        return this.controllerContext;
    }

    public Boolean isDeleteTopicEnabled() {
        return this.isDeleteTopicEnabled;
    }

    public scala.collection.mutable.Set<String> topicsToBeDeleted() {
        return this.topicsToBeDeleted;
    }

    public scala.collection.mutable.Set<String> topicsWithDeletionStarted() {
        return this.topicsWithDeletionStarted;
    }

    public scala.collection.mutable.Set<String> topicsIneligibleForDeletion() {
        return this.topicsIneligibleForDeletion;
    }

    public void init(Set<String> initialTopicsToBeDeleted, Set<String> initialTopicsIneligibleForDeletion) {
        if (Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) {
            this.topicsToBeDeleted().$plus$plus$eq(initialTopicsToBeDeleted);
            this.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)initialTopicsIneligibleForDeletion.$amp(this.topicsToBeDeleted()));
        } else {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Removing ").append(initialTopicsToBeDeleted).append(" since delete topic is disabled").toString());
            this.zkClient.deleteTopicDeletions((Seq<String>)initialTopicsToBeDeleted.toSeq(), this.controllerContext().epochZkVersion());
        }
    }

    public void tryTopicDeletion() {
        block0: {
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) break block0;
            this.resumeDeletions();
        }
    }

    public void reset() {
        block0: {
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) break block0;
            this.topicsToBeDeleted().clear();
            this.topicsWithDeletionStarted().clear();
            this.topicsIneligibleForDeletion().clear();
        }
    }

    public void enqueueTopicsForDeletion(Set<String> topics) {
        block0: {
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) break block0;
            this.topicsToBeDeleted().$plus$plus$eq(topics);
            this.resumeDeletions();
        }
    }

    public void resumeDeletionForTopics(Set<String> topics) {
        block0: {
            Set topicsToResumeDeletion;
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) || !(topicsToResumeDeletion = (Set)topics.$amp(this.topicsToBeDeleted())).nonEmpty()) break block0;
            this.topicsIneligibleForDeletion().$minus$minus$eq((TraversableOnce)topicsToResumeDeletion);
            this.resumeDeletions();
        }
    }

    public Set<String> resumeDeletionForTopics$default$1() {
        return Set$.MODULE$.empty();
    }

    public void failReplicaDeletion(Set<PartitionAndReplica> replicas) {
        block0: {
            Set replicasThatFailedToDelete;
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) || !(replicasThatFailedToDelete = (Set)replicas.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)this.isTopicQueuedUpForDeletion(r.topic())))).nonEmpty()) break block0;
            Set topics = (Set)replicasThatFailedToDelete.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.topic(), Set$.MODULE$.canBuildFrom());
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Deletion failed for replicas ").append(replicasThatFailedToDelete.mkString(",")).append(". Halting deletion for topics ").append(topics).toString());
            this.controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)replicasThatFailedToDelete.toSeq(), ReplicaDeletionIneligible$.MODULE$, this.controller.replicaStateMachine().handleStateChanges$default$3());
            this.markTopicIneligibleForDeletion((Set<String>)topics);
            this.resumeDeletions();
        }
    }

    public void markTopicIneligibleForDeletion(Set<String> topics) {
        block1: {
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) break block1;
            scala.collection.mutable.Set newTopicsToHaltDeletion = (scala.collection.mutable.Set)this.topicsToBeDeleted().$amp(topics);
            this.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)newTopicsToHaltDeletion);
            if (newTopicsToHaltDeletion.nonEmpty()) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Halted deletion of topics ").append(newTopicsToHaltDeletion.mkString(",")).toString());
            }
        }
    }

    private boolean isTopicIneligibleForDeletion(String topic) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.topicsIneligibleForDeletion().contains((Object)topic) : true;
    }

    private boolean isTopicDeletionInProgress(String topic) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic) : false;
    }

    public boolean isTopicWithDeletionStarted(String topic) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.topicsWithDeletionStarted().contains((Object)topic) : false;
    }

    public boolean isTopicQueuedUpForDeletion(String topic) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.topicsToBeDeleted().contains((Object)topic) : false;
    }

    public void completeReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set successfullyDeletedReplicas = (Set)replicas.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)this.isTopicQueuedUpForDeletion(r.topic())));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Deletion successfully completed for replicas ").append(successfullyDeletedReplicas.mkString(",")).toString());
        this.controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)successfullyDeletedReplicas.toSeq(), ReplicaDeletionSuccessful$.MODULE$, this.controller.replicaStateMachine().handleStateChanges$default$3());
        this.resumeDeletions();
    }

    private boolean isTopicEligibleForDeletion(String topic) {
        return this.topicsToBeDeleted().contains((Object)topic) && !this.isTopicDeletionInProgress(topic) && !this.isTopicIneligibleForDeletion(topic);
    }

    private void markTopicForDeletionRetry(String topic) {
        scala.collection.immutable.Set<PartitionAndReplica> failedReplicas = this.controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionIneligible$.MODULE$);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Retrying delete topic for topic ").append(topic).append(" since replicas ").append(failedReplicas.mkString(",")).append(" were not successfully deleted").toString());
        this.controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)failedReplicas.toSeq(), OfflineReplica$.MODULE$, this.controller.replicaStateMachine().handleStateChanges$default$3());
    }

    private void completeDeleteTopic(String topic) {
        this.controller.unregisterPartitionModificationsHandlers((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
        scala.collection.immutable.Set<PartitionAndReplica> replicasForDeletedTopic = this.controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
        this.controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)replicasForDeletedTopic.toSeq(), NonExistentReplica$.MODULE$, this.controller.replicaStateMachine().handleStateChanges$default$3());
        this.topicsToBeDeleted().$minus$eq((Object)topic);
        this.topicsWithDeletionStarted().$minus$eq((Object)topic);
        this.zkClient.deleteTopicZNode(topic, this.controllerContext().epochZkVersion());
        this.zkClient.deleteTopicConfigs((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))), this.controllerContext().epochZkVersion());
        this.zkClient.deleteTopicDeletions((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))), this.controllerContext().epochZkVersion());
        this.controllerContext().removeTopic(topic);
    }

    private void onTopicDeletion(Set<String> topics) {
        BoxedUnit boxedUnit;
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Topic deletion callback for ").append(topics.mkString(",")).toString());
        Set partitions = (Set)topics.flatMap((Function1 & Serializable & scala.Serializable)topic -> this.controllerContext().partitionsForTopic((String)topic), Set$.MODULE$.canBuildFrom());
        Set unseenTopicsForDeletion = (Set)topics.$minus$minus(this.topicsWithDeletionStarted());
        if (unseenTopicsForDeletion.nonEmpty()) {
            Set unseenPartitionsForDeletion = (Set)unseenTopicsForDeletion.flatMap((Function1 & Serializable & scala.Serializable)topic -> this.controllerContext().partitionsForTopic((String)topic), Set$.MODULE$.canBuildFrom());
            this.controller.partitionStateMachine().handleStateChanges((Seq<TopicPartition>)unseenPartitionsForDeletion.toSeq(), OfflinePartition$.MODULE$, this.controller.partitionStateMachine().handleStateChanges$default$3());
            this.controller.partitionStateMachine().handleStateChanges((Seq<TopicPartition>)unseenPartitionsForDeletion.toSeq(), NonExistentPartition$.MODULE$, this.controller.partitionStateMachine().handleStateChanges$default$3());
            boxedUnit = this.topicsWithDeletionStarted().$plus$plus$eq((TraversableOnce)unseenTopicsForDeletion);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.controller.sendUpdateMetadataRequest((Seq<Object>)this.controllerContext().liveOrShuttingDownBrokerIds().toSeq(), (Set<TopicPartition>)partitions);
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            this.onPartitionDeletion(this.controllerContext().partitionsForTopic(topic));
            return BoxedUnit.UNIT;
        });
    }

    private void startReplicaDeletion(Set<PartitionAndReplica> replicasForTopicsToBeDeleted) {
        replicasForTopicsToBeDeleted.groupBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.topic()).keys().foreach((Function1 & Serializable & scala.Serializable)topic -> {
            TopicDeletionManager.$anonfun$startReplicaDeletion$2(this, replicasForTopicsToBeDeleted, topic);
            return BoxedUnit.UNIT;
        });
    }

    private void onPartitionDeletion(Set<TopicPartition> partitionsToBeDeleted) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Partition deletion callback for ").append(partitionsToBeDeleted.mkString(",")).toString());
        Set<PartitionAndReplica> replicasPerPartition = this.controllerContext().replicasForPartition(partitionsToBeDeleted);
        this.startReplicaDeletion(replicasPerPartition);
    }

    private void resumeDeletions() {
        Set topicsQueuedForDeletion = Set$.MODULE$.empty().$plus$plus(this.topicsToBeDeleted());
        if (topicsQueuedForDeletion.nonEmpty()) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Handling deletion for topics ").append(topicsQueuedForDeletion.mkString(",")).toString());
        }
        topicsQueuedForDeletion.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            TopicDeletionManager.$anonfun$resumeDeletions$2(this, topic);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$startReplicaDeletion$3(String topic$2, PartitionAndReplica p) {
        String string = p.topic();
        String string2 = topic$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$startReplicaDeletion$2(TopicDeletionManager $this, Set replicasForTopicsToBeDeleted$1, String topic) {
        block0: {
            Set aliveReplicasForTopic = (Set)$this.controllerContext().allLiveReplicas().filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManager.$anonfun$startReplicaDeletion$3(topic, p)));
            Set deadReplicasForTopic = (Set)replicasForTopicsToBeDeleted$1.$minus$minus((GenTraversableOnce)aliveReplicasForTopic);
            scala.collection.immutable.Set<PartitionAndReplica> successfullyDeletedReplicas = $this.controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
            Set replicasForDeletionRetry = (Set)aliveReplicasForTopic.$minus$minus(successfullyDeletedReplicas);
            $this.controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)deadReplicasForTopic.toSeq(), ReplicaDeletionIneligible$.MODULE$, new Callbacks(Callbacks$.MODULE$.$lessinit$greater$default$1()));
            $this.controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)replicasForDeletionRetry.toSeq(), OfflineReplica$.MODULE$, new Callbacks(Callbacks$.MODULE$.$lessinit$greater$default$1()));
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Deletion started for replicas ").append(replicasForDeletionRetry.mkString(",")).toString());
            $this.controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)replicasForDeletionRetry.toSeq(), ReplicaDeletionStarted$.MODULE$, new Callbacks((Function2<AbstractResponse, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(stopReplicaResponseObj, replicaId) -> {
                $this.eventManager.put(new KafkaController.TopicDeletionStopReplicaResponseReceived($this.controller, stopReplicaResponseObj, BoxesRunTime.unboxToInt((Object)replicaId)));
                return BoxedUnit.UNIT;
            }));
            if (!deadReplicasForTopic.nonEmpty()) break block0;
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Dead Replicas (").append(deadReplicasForTopic.mkString(",")).append(") found for topic ").append(topic).toString());
            $this.markTopicIneligibleForDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
        }
    }

    public static final /* synthetic */ void $anonfun$resumeDeletions$2(TopicDeletionManager $this, String topic) {
        block6: {
            block5: {
                if ($this.controller.replicaStateMachine().areAllReplicasForTopicDeleted(topic)) {
                    $this.completeDeleteTopic(topic);
                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Deletion of topic ").append(topic).append(" successfully completed").toString());
                } else if ($this.controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic)) {
                    scala.collection.immutable.Set<PartitionAndReplica> replicasInDeletionStartedState = $this.controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionStarted$.MODULE$);
                    scala.collection.immutable.Set replicaIds = (scala.collection.immutable.Set)replicasInDeletionStartedState.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.replica()), scala.collection.immutable.Set$.MODULE$.canBuildFrom());
                    scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)replicasInDeletionStartedState.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.topicPartition(), scala.collection.immutable.Set$.MODULE$.canBuildFrom());
                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Deletion for replicas ").append(replicaIds.mkString(",")).append(" for partition ").append(partitions.mkString(",")).append(" of topic ").append(topic).append(" in progress").toString());
                } else if ($this.controller.replicaStateMachine().isAnyReplicaInState(topic, ReplicaDeletionIneligible$.MODULE$)) {
                    $this.markTopicForDeletionRetry(topic);
                }
                if (!$this.isTopicEligibleForDeletion(topic)) break block5;
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Deletion of topic ").append(topic).append(" (re)started").toString());
                $this.onTopicDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
                break block6;
            }
            if (!$this.isTopicIneligibleForDeletion(topic)) break block6;
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Not retrying deletion of topic ").append(topic).append(" at this time since it is marked ineligible for deletion").toString());
        }
    }

    public TopicDeletionManager(KafkaController controller, ControllerEventManager eventManager, KafkaZkClient zkClient) {
        this.controller = controller;
        this.eventManager = eventManager;
        this.zkClient = zkClient;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(27).append("[Topic Deletion Manager ").append(controller.config().brokerId()).append("], ").toString());
        this.controllerContext = controller.controllerContext();
        this.isDeleteTopicEnabled = controller.config().deleteTopicEnable();
        this.topicsToBeDeleted = scala.collection.mutable.Set$.MODULE$.empty();
        this.topicsWithDeletionStarted = scala.collection.mutable.Set$.MODULE$.empty();
        this.topicsIneligibleForDeletion = scala.collection.mutable.Set$.MODULE$.empty();
    }
}

