/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.net.InetAddress;
import kafka.network.TooManyConnectionsException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001M4AAE\n\u00011!Aq\u0004\u0001BC\u0002\u0013\u0005\u0001\u0005\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003\"\u0011!)\u0003A!A!\u0002\u00131\u0003\"B\u001c\u0001\t\u0003A\u0004bB\u001f\u0001\u0001\u0004%I\u0001\t\u0005\b}\u0001\u0001\r\u0011\"\u0003@\u0011\u0019)\u0005\u0001)Q\u0005C!9!\n\u0001a\u0001\n\u0013Y\u0005bB+\u0001\u0001\u0004%IA\u0016\u0005\u00071\u0002\u0001\u000b\u0015\u0002'\t\u000fi\u0003!\u0019!C\u00057\"1\u0011\r\u0001Q\u0001\nqCQA\u0019\u0001\u0005\u0002\rDQA\u001a\u0001\u0005\u0002\u001dDQA\u001b\u0001\u0005\u0002-DQ!\u001c\u0001\u0005\u00029DQ\u0001\u001d\u0001\u0005\u0002E\u0014\u0001cQ8o]\u0016\u001cG/[8o#V|G/Y:\u000b\u0005Q)\u0012a\u00028fi^|'o\u001b\u0006\u0002-\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u001a!\tQR$D\u0001\u001c\u0015\u0005a\u0012!B:dC2\f\u0017B\u0001\u0010\u001c\u0005\u0019\te.\u001f*fM\u0006QA-\u001a4bk2$X*\u0019=\u0016\u0003\u0005\u0002\"A\u0007\u0012\n\u0005\rZ\"aA%oi\u0006YA-\u001a4bk2$X*\u0019=!\u00039yg/\u001a:sS\u0012,\u0017+^8uCN\u0004Ba\n\u0016-C5\t\u0001F\u0003\u0002*7\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005-B#aA'baB\u0011Q\u0006\u000e\b\u0003]I\u0002\"aL\u000e\u000e\u0003AR!!M\f\u0002\rq\u0012xn\u001c;?\u0013\t\u00194$\u0001\u0004Qe\u0016$WMZ\u0005\u0003kY\u0012aa\u0015;sS:<'BA\u001a\u001c\u0003\u0019a\u0014N\\5u}Q\u0019\u0011h\u000f\u001f\u0011\u0005i\u0002Q\"A\n\t\u000b}!\u0001\u0019A\u0011\t\u000b\u0015\"\u0001\u0019\u0001\u0014\u00025\u0011,g-Y;mi6\u000b\u0007pQ8o]\u0016\u001cG/[8ogB+'/\u00139\u0002=\u0011,g-Y;mi6\u000b\u0007pQ8o]\u0016\u001cG/[8ogB+'/\u00139`I\u0015\fHC\u0001!D!\tQ\u0012)\u0003\u0002C7\t!QK\\5u\u0011\u001d!e!!AA\u0002\u0005\n1\u0001\u001f\u00132\u0003m!WMZ1vYRl\u0015\r_\"p]:,7\r^5p]N\u0004VM]%qA!\u0012qa\u0012\t\u00035!K!!S\u000e\u0003\u0011Y|G.\u0019;jY\u0016\fA$\\1y\u0007>tg.Z2uS>t7\u000fU3s\u0013B|e/\u001a:sS\u0012,7/F\u0001M!\u00119#&T\u0011\u0011\u00059\u001bV\"A(\u000b\u0005A\u000b\u0016a\u00018fi*\t!+\u0001\u0003kCZ\f\u0017B\u0001+P\u0005-Ie.\u001a;BI\u0012\u0014Xm]:\u0002A5\f\u0007pQ8o]\u0016\u001cG/[8ogB+'/\u00139Pm\u0016\u0014(/\u001b3fg~#S-\u001d\u000b\u0003\u0001^Cq\u0001R\u0005\u0002\u0002\u0003\u0007A*A\u000fnCb\u001cuN\u001c8fGRLwN\\:QKJL\u0005o\u0014<feJLG-Z:!Q\tQq)\u0001\u0004d_VtGo]\u000b\u00029B!Q\fY'\"\u001b\u0005q&BA0)\u0003\u001diW\u000f^1cY\u0016L!a\u000b0\u0002\u000f\r|WO\u001c;tA\u0005\u0019\u0011N\\2\u0015\u0005\u0001#\u0007\"B3\u000e\u0001\u0004i\u0015aB1eIJ,7o]\u0001\u001akB$\u0017\r^3NCb\u001cuN\u001c8fGRLwN\\:QKJL\u0005\u000f\u0006\u0002AQ\")\u0011N\u0004a\u0001C\u0005\u0019R.\u0019=D_:tWm\u0019;j_:\u001c\b+\u001a:Ja\u0006\tS\u000f\u001d3bi\u0016l\u0015\r_\"p]:,7\r^5p]N\u0004VM]%q\u001fZ,'O]5eKR\u0011\u0001\t\u001c\u0005\u0006K=\u0001\rAJ\u0001\u0004I\u0016\u001cGC\u0001!p\u0011\u0015)\u0007\u00031\u0001N\u0003\r9W\r\u001e\u000b\u0003CIDQ!Z\tA\u00025\u0003")
public class ConnectionQuotas {
    private final int defaultMax;
    private volatile int defaultMaxConnectionsPerIp;
    private volatile Map<InetAddress, Object> maxConnectionsPerIpOverrides;
    private final scala.collection.mutable.Map<InetAddress, Object> counts;

    public int defaultMax() {
        return this.defaultMax;
    }

    private int defaultMaxConnectionsPerIp() {
        return this.defaultMaxConnectionsPerIp;
    }

    private void defaultMaxConnectionsPerIp_$eq(int x$1) {
        this.defaultMaxConnectionsPerIp = x$1;
    }

    private Map<InetAddress, Object> maxConnectionsPerIpOverrides() {
        return this.maxConnectionsPerIpOverrides;
    }

    private void maxConnectionsPerIpOverrides_$eq(Map<InetAddress, Object> x$1) {
        this.maxConnectionsPerIpOverrides = x$1;
    }

    private scala.collection.mutable.Map<InetAddress, Object> counts() {
        return this.counts;
    }

    public void inc(InetAddress address) {
        scala.collection.mutable.Map<InetAddress, Object> map = this.counts();
        synchronized (map) {
            int count = BoxesRunTime.unboxToInt((Object)this.counts().getOrElseUpdate((Object)address, (Function0)(JFunction0.mcI.sp & java.io.Serializable & Serializable)() -> 0));
            this.counts().put((Object)address, (Object)BoxesRunTime.boxToInteger((int)(count + 1)));
            int max = BoxesRunTime.unboxToInt((Object)this.maxConnectionsPerIpOverrides().getOrElse((Object)address, (Function0)(JFunction0.mcI.sp & java.io.Serializable & Serializable)() -> this.defaultMaxConnectionsPerIp()));
            if (count >= max) {
                throw new TooManyConnectionsException(address, max);
            }
        }
    }

    public void updateMaxConnectionsPerIp(int maxConnectionsPerIp) {
        this.defaultMaxConnectionsPerIp_$eq(maxConnectionsPerIp);
    }

    public void updateMaxConnectionsPerIpOverride(Map<String, Object> overrideQuotas) {
        this.maxConnectionsPerIpOverrides_$eq((Map<InetAddress, Object>)((Map)overrideQuotas.map((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String host = (String)tuple2._1();
            int count = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)InetAddress.getByName(host), (Object)BoxesRunTime.boxToInteger((int)count));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom())));
    }

    public void dec(InetAddress address) {
        scala.collection.mutable.Map<InetAddress, Object> map = this.counts();
        synchronized (map) {
            int count = BoxesRunTime.unboxToInt((Object)this.counts().getOrElse((Object)address, (Function0 & java.io.Serializable & Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(81).append("Attempted to decrease connection count for address with no connections, address: ").append(address).toString());
            }));
            Option option = count == 1 ? this.counts().remove((Object)address) : this.counts().put((Object)address, (Object)BoxesRunTime.boxToInteger((int)(count - 1)));
        }
    }

    public int get(InetAddress address) {
        int n;
        scala.collection.mutable.Map<InetAddress, Object> map = this.counts();
        synchronized (map) {
            n = BoxesRunTime.unboxToInt((Object)this.counts().getOrElse((Object)address, (Function0)(JFunction0.mcI.sp & java.io.Serializable & Serializable)() -> 0));
        }
        return n;
    }

    public ConnectionQuotas(int defaultMax, Map<String, Object> overrideQuotas) {
        this.defaultMax = defaultMax;
        this.defaultMaxConnectionsPerIp = defaultMax;
        this.maxConnectionsPerIpOverrides = (Map)overrideQuotas.map((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String host = (String)tuple2._1();
            int count = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)InetAddress.getByName(host), (Object)BoxesRunTime.boxToInteger((int)count));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        this.counts = (scala.collection.mutable.Map)scala.collection.mutable.Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

