/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import kafka.admin.AdminOperationException;
import kafka.admin.RackAwareMode;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df\u0001B\u0012%\u0001%BQ\u0001\r\u0001\u0005\u0002EBQ\u0001\u000e\u0001\u0005BUBq\u0001\u0010\u0001C\u0002\u0013\u0005Q\u0007\u0003\u0004>\u0001\u0001\u0006IA\u000e\u0005\b}\u0001\u0011\r\u0011\"\u0001@\u0011\u0019A\u0005\u0001)A\u0005\u0001\"9\u0011\n\u0001b\u0001\n\u0003Q\u0005BB,\u0001A\u0003%1\nC\u0004Y\u0001\t\u0007I\u0011A \t\re\u0003\u0001\u0015!\u0003A\u0011\u001dQ\u0006A1A\u0005\u0002)Caa\u0017\u0001!\u0002\u0013Y\u0005b\u0002/\u0001\u0005\u0004%\ta\u0010\u0005\u0007;\u0002\u0001\u000b\u0011\u0002!\t\u000fy\u0003!\u0019!C\u0001\u0015\"1q\f\u0001Q\u0001\n-Cq\u0001\u0019\u0001C\u0002\u0013\u0005q\b\u0003\u0004b\u0001\u0001\u0006I\u0001\u0011\u0005\bE\u0002\u0011\r\u0011\"\u0001K\u0011\u0019\u0019\u0007\u0001)A\u0005\u0017\"9A\r\u0001b\u0001\n\u0003y\u0004BB3\u0001A\u0003%\u0001\tC\u0004g\u0001\t\u0007I\u0011\u0001&\t\r\u001d\u0004\u0001\u0015!\u0003L\u0011\u0015A\u0007\u0001\"\u0011j\u0011\u00151\b\u0001\"\u0001j\u0011\u0015Y\b\u0001\"\u0001j\u0011\u0015i\b\u0001\"\u0001j\u0011\u0015y\b\u0001\"\u0001j\u0011\u0019\t\u0019\u0001\u0001C\u0001S\"1\u0011q\u0001\u0001\u0005\u0002%Dq!a\u0003\u0001\t\u0003\ti\u0001C\u0004\u0002d\u0001!I!!\u001a\t\u0013\u0005=\u0005!%A\u0005\n\u0005E%!E!eIB\u000b'\u000f^5uS>t7\u000fV3ti*\u0011QEJ\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0002O\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001+!\tYc&D\u0001-\u0015\tic%\u0001\u0004tKJ4XM]\u0005\u0003_1\u0012qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003I\u0002\"a\r\u0001\u000e\u0003\u0011\n1B\u0019:pW\u0016\u00148i\\;oiV\ta\u0007\u0005\u00028u5\t\u0001HC\u0001:\u0003\u0015\u00198-\u00197b\u0013\tY\u0004HA\u0002J]R\f1\u0002]1si&$\u0018n\u001c8JI\u0006a\u0001/\u0019:uSRLwN\\%eA\u00051Ao\u001c9jGF*\u0012\u0001\u0011\t\u0003\u0003\u001ak\u0011A\u0011\u0006\u0003\u0007\u0012\u000bA\u0001\\1oO*\tQ)\u0001\u0003kCZ\f\u0017BA$C\u0005\u0019\u0019FO]5oO\u00069Ao\u001c9jGF\u0002\u0013\u0001\u0005;pa&\u001c\u0017'Q:tS\u001etW.\u001a8u+\u0005Y\u0005\u0003\u0002'RmMk\u0011!\u0014\u0006\u0003\u001d>\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0005AC\u0014AC2pY2,7\r^5p]&\u0011!+\u0014\u0002\u0004\u001b\u0006\u0004\bc\u0001+Vm5\tq*\u0003\u0002W\u001f\n\u00191+Z9\u0002#Q|\u0007/[22\u0003N\u001c\u0018n\u001a8nK:$\b%\u0001\u0004u_BL7MM\u0001\bi>\u0004\u0018n\u0019\u001a!\u0003A!x\u000e]5de\u0005\u001b8/[4o[\u0016tG/A\tu_BL7MM!tg&<g.\\3oi\u0002\na\u0001^8qS\u000e\u001c\u0014a\u0002;pa&\u001c7\u0007I\u0001\u0011i>\u0004\u0018nY\u001aBgNLwM\\7f]R\f\u0011\u0003^8qS\u000e\u001c\u0014i]:jO:lWM\u001c;!\u0003\u0019!x\u000e]5di\u00059Ao\u001c9jGR\u0002\u0013\u0001\u0005;pa&\u001cG'Q:tS\u001etW.\u001a8u\u0003E!x\u000e]5di\u0005\u001b8/[4o[\u0016tG\u000fI\u0001\u0007i>\u0004\u0018nY\u001b\u0002\u000fQ|\u0007/[26A\u0005\u0001Bo\u001c9jGV\n5o]5h]6,g\u000e^\u0001\u0012i>\u0004\u0018nY\u001bBgNLwM\\7f]R\u0004\u0013!B:fiV\u0003H#\u00016\u0011\u0005]Z\u0017B\u000179\u0005\u0011)f.\u001b;)\u0005eq\u0007CA8u\u001b\u0005\u0001(BA9s\u0003\u0015QWO\\5u\u0015\u0005\u0019\u0018aA8sO&\u0011Q\u000f\u001d\u0002\u0007\u0005\u00164wN]3\u0002+Q,7\u000f^,s_:<'+\u001a9mS\u000e\f7i\\;oi\"\u0012!\u0004\u001f\t\u0003_fL!A\u001f9\u0003\tQ+7\u000f^\u0001\u0016i\u0016\u001cH/T5tg&tw\rU1si&$\u0018n\u001c81Q\tY\u00020A\fuKN$\u0018J\\2sK6,g\u000e\u001e)beRLG/[8og\"\u0012A\u0004_\u0001\u001fi\u0016\u001cH/T1ok\u0006d\u0017i]:jO:lWM\u001c;PMJ+\u0007\u000f\\5dCND#!\b=\u0002=Q,7\u000f\u001e*fa2L7-\u0019)mC\u000e,W.\u001a8u\u00032d7+\u001a:wKJ\u001c\bF\u0001\u0010y\u0003\t\"Xm\u001d;SKBd\u0017nY1QY\u0006\u001cW-\\3oiB\u000b'\u000f^5bYN+'O^3sg\"\u0012q\u0004_\u0001\u001am\u0006d\u0017\u000eZ1uK2+\u0017\rZ3s\u0003:$'+\u001a9mS\u000e\f7\u000fF\u0005k\u0003\u001f\tI%a\u0013\u0002P!9\u0011\u0011\u0003\u0011A\u0002\u0005M\u0011\u0001C7fi\u0006$\u0017\r^1\u0011\t\u0005U\u00111\t\b\u0005\u0003/\tiD\u0004\u0003\u0002\u001a\u0005]b\u0002BA\u000e\u0003cqA!!\b\u0002.9!\u0011qDA\u0015\u001d\u0011\t\t#a\n\u000e\u0005\u0005\r\"bAA\u0013Q\u00051AH]8pizJ\u0011a]\u0005\u0004\u0003W\u0011\u0018AB1qC\u000eDW-C\u0002(\u0003_Q1!a\u000bs\u0013\u0011\t\u0019$!\u000e\u0002\r\r|W.\\8o\u0015\r9\u0013qF\u0005\u0005\u0003s\tY$\u0001\u0005sKF,Xm\u001d;t\u0015\u0011\t\u0019$!\u000e\n\t\u0005}\u0012\u0011I\u0001\u0011\u001b\u0016$\u0018\rZ1uCJ+7\u000f]8og\u0016TA!!\u000f\u0002<%!\u0011QIA$\u00055!v\u000e]5d\u001b\u0016$\u0018\rZ1uC*!\u0011qHA!\u0011\u0015a\u0004\u00051\u00017\u0011\u0019\ti\u0005\ta\u0001m\u0005\u0001R\r\u001f9fGR,G\rT3bI\u0016\u0014\u0018\n\u001a\u0005\b\u0003#\u0002\u0003\u0019AA*\u0003A)\u0007\u0010]3di\u0016$'+\u001a9mS\u000e\f7\u000fE\u0003\u0002V\u0005ucG\u0004\u0003\u0002X\u0005e\u0003cAA\u0011q%\u0019\u00111\f\u001d\u0002\rA\u0013X\rZ3g\u0013\u0011\ty&!\u0019\u0003\u0007M+GOC\u0002\u0002\\a\n1c]3oI6+G/\u00193bi\u0006\u0014V-];fgR$b!a\u001a\u0002p\u0005e\u0004\u0003BA5\u0003Wj!!!\u0011\n\t\u00055\u0014\u0011\t\u0002\u0011\u001b\u0016$\u0018\rZ1uCJ+7\u000f]8og\u0016Dq!!\u001d\"\u0001\u0004\t\u0019(A\u0004sKF,Xm\u001d;\u0011\t\u0005%\u0014QO\u0005\u0005\u0003o\n\tEA\bNKR\fG-\u0019;b%\u0016\fX/Z:u\u0011%\tY(\tI\u0001\u0002\u0004\ti(A\u0006eKN$\u0018N\\1uS>t\u0007#B\u001c\u0002\u0000\u0005\r\u0015bAAAq\t1q\n\u001d;j_:\u0004B!!\"\u0002\f6\u0011\u0011q\u0011\u0006\u0004\u0003\u00133\u0013a\u00028fi^|'o[\u0005\u0005\u0003\u001b\u000b9I\u0001\u0007T_\u000e\\W\r^*feZ,'/A\u000ftK:$W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\t\u0019J\u000b\u0003\u0002~\u0005U5FAAL!\u0011\tI*a)\u000e\u0005\u0005m%\u0002BAO\u0003?\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005\u0006(\u0001\u0006b]:|G/\u0019;j_:LA!!*\u0002\u001c\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class AddPartitionsTest
extends BaseRequestTest {
    private final int partitionId;
    private final String topic1;
    private final scala.collection.immutable.Map<Object, Seq<Object>> topic1Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
    private final String topic2;
    private final scala.collection.immutable.Map<Object, Seq<Object>> topic2Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
    private final String topic3;
    private final scala.collection.immutable.Map<Object, Seq<Object>> topic3Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1})))}));
    private final String topic4;
    private final scala.collection.immutable.Map<Object, Seq<Object>> topic4Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3})))}));
    private final String topic5;
    private final scala.collection.immutable.Map<Object, Seq<Object>> topic5Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));

    @Override
    public int brokerCount() {
        return 4;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public String topic1() {
        return this.topic1;
    }

    public scala.collection.immutable.Map<Object, Seq<Object>> topic1Assignment() {
        return this.topic1Assignment;
    }

    public String topic2() {
        return this.topic2;
    }

    public scala.collection.immutable.Map<Object, Seq<Object>> topic2Assignment() {
        return this.topic2Assignment;
    }

    public String topic3() {
        return this.topic3;
    }

    public scala.collection.immutable.Map<Object, Seq<Object>> topic3Assignment() {
        return this.topic3Assignment;
    }

    public String topic4() {
        return this.topic4;
    }

    public scala.collection.immutable.Map<Object, Seq<Object>> topic4Assignment() {
        return this.topic4Assignment;
    }

    public String topic5() {
        return this.topic5;
    }

    public scala.collection.immutable.Map<Object, Seq<Object>> topic5Assignment() {
        return this.topic5Assignment;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.createTopic(this.topic1(), (Map<Object, Seq<Object>>)this.topic1Assignment());
        this.createTopic(this.topic2(), (Map<Object, Seq<Object>>)this.topic2Assignment());
        this.createTopic(this.topic3(), (Map<Object, Seq<Object>>)this.topic3Assignment());
        this.createTopic(this.topic4(), (Map<Object, Seq<Object>>)this.topic4Assignment());
    }

    @Test
    public void testWrongReplicaCount() {
        try {
            AdminZkClient qual$1 = this.adminZkClient();
            String x$3 = this.topic1();
            scala.collection.immutable.Map<Object, Seq<Object>> x$4 = this.topic1Assignment();
            AdminZkClient qual$2 = this.adminZkClient();
            RackAwareMode x$1 = qual$2.getBrokerMetadatas$default$1();
            Option x$2 = qual$2.getBrokerMetadatas$default$2();
            Seq x$5 = qual$2.getBrokerMetadatas(x$1, x$2);
            int x$6 = 2;
            Some x$7 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})));
            boolean x$8 = qual$1.addPartitions$default$6();
            qual$1.addPartitions(x$3, x$4, x$5, x$6, (Option)x$7, x$8);
            Assert.fail((String)"Add partitions should fail");
        }
        catch (InvalidReplicaAssignmentException invalidReplicaAssignmentException) {}
    }

    @Test
    public void testMissingPartition0() {
        try {
            AdminZkClient qual$1 = this.adminZkClient();
            String x$3 = this.topic5();
            scala.collection.immutable.Map<Object, Seq<Object>> x$4 = this.topic5Assignment();
            AdminZkClient qual$2 = this.adminZkClient();
            RackAwareMode x$1 = qual$2.getBrokerMetadatas$default$1();
            Option x$2 = qual$2.getBrokerMetadatas$default$2();
            Seq x$5 = qual$2.getBrokerMetadatas(x$1, x$2);
            int x$6 = 2;
            Some x$7 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})));
            boolean x$8 = qual$1.addPartitions$default$6();
            qual$1.addPartitions(x$3, x$4, x$5, x$6, (Option)x$7, x$8);
            Assert.fail((String)"Add partitions should fail");
        }
        catch (AdminOperationException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Unexpected existing replica assignment for topic 'new-topic5', partition id 0 is missing"));
        }
    }

    @Test
    public void testIncrementPartitions() {
        AdminZkClient qual$1 = this.adminZkClient();
        String x$3 = this.topic1();
        scala.collection.immutable.Map<Object, Seq<Object>> x$4 = this.topic1Assignment();
        AdminZkClient qual$2 = this.adminZkClient();
        RackAwareMode x$12 = qual$2.getBrokerMetadatas$default$1();
        Option x$2 = qual$2.getBrokerMetadatas$default$2();
        Seq x$5 = qual$2.getBrokerMetadatas(x$12, x$2);
        int x$6 = 3;
        Option x$7 = qual$1.addPartitions$default$5();
        boolean x$8 = qual$1.addPartitions$default$6();
        qual$1.addPartitions(x$3, x$4, x$5, x$6, x$7, x$8);
        int leader1 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic1(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic1(), 2, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader1FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic1(), 1)).get());
        int leader2FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic1(), 2)).get());
        Assert.assertEquals((long)leader1, (long)leader1FromZk);
        Assert.assertEquals((long)leader2, (long)leader2FromZk);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic1(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic1(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        MetadataResponse response = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()}))).asJava(), false).build(), this.sendMetadataRequest$default$2());
        Assert.assertEquals((long)1L, (long)response.topicMetadata().size());
        Buffer partitions = (Buffer)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head()).partitionMetadata()).asScala()).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.partition()), (Ordering)Ordering.Int$.MODULE$);
        Assert.assertEquals((long)partitions.size(), (long)3L);
        Assert.assertEquals((long)1L, (long)((MetadataResponse.PartitionMetadata)partitions.apply(1)).partition());
        Assert.assertEquals((long)2L, (long)((MetadataResponse.PartitionMetadata)partitions.apply(2)).partition());
        List replicas = ((MetadataResponse.PartitionMetadata)partitions.apply(1)).replicas();
        Assert.assertEquals((long)replicas.size(), (long)2L);
        Assert.assertTrue((boolean)replicas.contains(((MetadataResponse.PartitionMetadata)partitions.apply(1)).leader()));
    }

    @Test
    public void testManualAssignmentOfReplicas() {
        AdminZkClient qual$1 = this.adminZkClient();
        String x$3 = this.topic2();
        scala.collection.immutable.Map<Object, Seq<Object>> x$4 = this.topic2Assignment();
        AdminZkClient qual$2 = this.adminZkClient();
        RackAwareMode x$1 = qual$2.getBrokerMetadatas$default$1();
        Option x$22 = qual$2.getBrokerMetadatas$default$2();
        Seq x$5 = qual$2.getBrokerMetadatas(x$1, x$22);
        int x$6 = 3;
        Some x$7 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})))})));
        boolean x$8 = qual$1.addPartitions$default$6();
        qual$1.addPartitions(x$3, x$4, x$5, x$6, (Option)x$7, x$8);
        int leader1 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic2(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic2(), 2, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader1FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic2(), 1)).get());
        int leader2FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic2(), 2)).get());
        Assert.assertEquals((long)leader1, (long)leader1FromZk);
        Assert.assertEquals((long)leader2, (long)leader2FromZk);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic2(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic2(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        MetadataResponse response = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic2()}))).asJava(), false).build(), this.sendMetadataRequest$default$2());
        Assert.assertEquals((long)1L, (long)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head();
        Buffer partitionMetadata = (Buffer)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(topicMetadata.partitionMetadata()).asScala()).sortBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.partition()), (Ordering)Ordering.Int$.MODULE$);
        Assert.assertEquals((long)3L, (long)topicMetadata.partitionMetadata().size());
        Assert.assertEquals((long)0L, (long)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(0)).partition());
        Assert.assertEquals((long)1L, (long)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(1)).partition());
        Assert.assertEquals((long)2L, (long)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(2)).partition());
        List replicas = ((MetadataResponse.PartitionMetadata)partitionMetadata.apply(1)).replicas();
        Assert.assertEquals((long)2L, (long)replicas.size());
        Assert.assertTrue((((Node)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).head()).id() == 0 || ((Node)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).head()).id() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((Node)((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).apply(1)).id() == 0 || ((Node)((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).apply(1)).id() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testReplicaPlacementAllServers() {
        AdminZkClient qual$1 = this.adminZkClient();
        String x$3 = this.topic3();
        scala.collection.immutable.Map<Object, Seq<Object>> x$4 = this.topic3Assignment();
        AdminZkClient qual$2 = this.adminZkClient();
        RackAwareMode x$1 = qual$2.getBrokerMetadatas$default$1();
        Option x$2 = qual$2.getBrokerMetadatas$default$2();
        Seq x$5 = qual$2.getBrokerMetadatas(x$1, x$2);
        int x$6 = 7;
        Option x$7 = qual$1.addPartitions$default$5();
        boolean x$8 = qual$1.addPartitions$default$6();
        qual$1.addPartitions(x$3, x$4, x$5, x$6, x$7, x$8);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 3, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 4, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 5, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 6, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        MetadataResponse response = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic3()}))).asJava(), false).build(), this.sendMetadataRequest$default$2());
        Assert.assertEquals((long)1L, (long)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head();
        this.validateLeaderAndReplicas(topicMetadata, 0, 2, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1}))));
        this.validateLeaderAndReplicas(topicMetadata, 1, 3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 0, 1}))));
        this.validateLeaderAndReplicas(topicMetadata, 2, 0, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3, 1, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 3, 1, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0, 2, 3}))));
        this.validateLeaderAndReplicas(topicMetadata, 4, 2, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1}))));
        this.validateLeaderAndReplicas(topicMetadata, 5, 3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 1, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 6, 0, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))));
    }

    @Test
    public void testReplicaPlacementPartialServers() {
        AdminZkClient qual$1 = this.adminZkClient();
        String x$3 = this.topic2();
        scala.collection.immutable.Map<Object, Seq<Object>> x$4 = this.topic2Assignment();
        AdminZkClient qual$2 = this.adminZkClient();
        RackAwareMode x$1 = qual$2.getBrokerMetadatas$default$1();
        Option x$2 = qual$2.getBrokerMetadatas$default$2();
        Seq x$5 = qual$2.getBrokerMetadatas(x$1, x$2);
        int x$6 = 3;
        Option x$7 = qual$1.addPartitions$default$5();
        boolean x$8 = qual$1.addPartitions$default$6();
        qual$1.addPartitions(x$3, x$4, x$5, x$6, x$7, x$8);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic2(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic2(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        MetadataResponse response = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic2()}))).asJava(), false).build(), this.sendMetadataRequest$default$2());
        Assert.assertEquals((long)1L, (long)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head();
        this.validateLeaderAndReplicas(topicMetadata, 0, 1, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 1, 2, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 2, 3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3}))));
    }

    public void validateLeaderAndReplicas(MetadataResponse.TopicMetadata metadata, int partitionId, int expectedLeaderId, Set<Object> expectedReplicas) {
        Option partitionOpt = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(metadata.partitionMetadata()).asScala()).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AddPartitionsTest.$anonfun$validateLeaderAndReplicas$1(partitionId, x$3)));
        Assert.assertTrue((String)new StringBuilder(23).append("Partition ").append(partitionId).append(" should exist").toString(), (boolean)partitionOpt.isDefined());
        MetadataResponse.PartitionMetadata partition = (MetadataResponse.PartitionMetadata)partitionOpt.get();
        Assert.assertNotNull((String)"Partition leader should exist", (Object)partition.leader());
        Assert.assertEquals((String)"Partition leader id should match", (long)expectedLeaderId, (long)partition.leaderId());
        Assert.assertEquals((String)"Replica set should match", expectedReplicas, (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partition.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Buffer$.MODULE$.canBuildFrom())).toSet());
    }

    private MetadataResponse sendMetadataRequest(MetadataRequest request, Option<SocketServer> destination) {
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.METADATA, (SocketServer)destination.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.anySocketServer()), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return MetadataResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private Option<SocketServer> sendMetadataRequest$default$2() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$validateLeaderAndReplicas$1(int partitionId$1, MetadataResponse.PartitionMetadata x$3) {
        return x$3.partition() == partitionId$1;
    }

    public AddPartitionsTest() {
        this.partitionId = 0;
        this.topic1 = "new-topic1";
        this.topic2 = "new-topic2";
        this.topic3 = "new-topic3";
        this.topic4 = "new-topic4";
        this.topic5 = "new-topic5";
    }
}

