/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer$;
import kafka.server.ThrottledReplicaListValidator$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.ConfigException;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000193AAC\u0006\u0001!!)q\u0003\u0001C\u00011!)1\u0004\u0001C\u00019!)\u0011\u0006\u0001C\u00019!)1\u0006\u0001C\u00019!)Q\u0006\u0001C\u00019!)q\u0006\u0001C\u00019!)\u0011\u0007\u0001C\u00019!)1\u0007\u0001C\u0005i!)Q\t\u0001C\u0005\r\niAj\\4D_:4\u0017n\u001a+fgRT!\u0001D\u0007\u0002\u00071|wMC\u0001\u000f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\t\u0011\u0005I)R\"A\n\u000b\u0003Q\tQa]2bY\u0006L!AF\n\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u001b\u00015\t1\"A\u0016f]N,(/\u001a(p'R\fG/[2J]&$\u0018.\u00197ju\u0006$\u0018n\u001c8Pe\u0012,'\u000fR3qK:$WM\\2z)\u0005i\u0002C\u0001\n\u001f\u0013\ty2C\u0001\u0003V]&$\bF\u0001\u0002\"!\t\u0011s%D\u0001$\u0015\t!S%A\u0003kk:LGOC\u0001'\u0003\ry'oZ\u0005\u0003Q\r\u0012A\u0001V3ti\u00061B/Z:u\u0017\u000647.Y\"p]\u001aLw\rV8Qe>\u00048\u000f\u000b\u0002\u0004C\u0005\u0011B/Z:u\rJ|W\u000e\u0015:paN,U\u000e\u001d;zQ\t!\u0011%\u0001\u000buKN$hI]8n!J|\u0007o]%om\u0006d\u0017\u000e\u001a\u0015\u0003\u000b\u0005\na\u0004^3ti&sg/\u00197jI\u000e{W\u000e]1di&|g\u000eT1h\u0007>tg-[4)\u0005\u0019\t\u0013!J:i_VdGMV1mS\u0012\fG/\u001a+ie>$H\u000f\\3e%\u0016\u0004H.[2bg\u000e{gNZ5hQ\t9\u0011%A\u0004jgZ\u000bG.\u001b3\u0015\u0005UB\u0004C\u0001\n7\u0013\t94CA\u0004C_>dW-\u00198\t\u000beB\u0001\u0019\u0001\u001e\u0002\u0017\r|gNZ5h-\u0006dW/\u001a\t\u0003w\ts!\u0001\u0010!\u0011\u0005u\u001aR\"\u0001 \u000b\u0005}z\u0011A\u0002\u001fs_>$h(\u0003\u0002B'\u00051\u0001K]3eK\u001aL!a\u0011#\u0003\rM#(/\u001b8h\u0015\t\t5#A\u000bbgN,'\u000f\u001e)s_B,'\u000f^=J]Z\fG.\u001b3\u0015\u0007u9\u0015\nC\u0003I\u0013\u0001\u0007!(\u0001\u0003oC6,\u0007\"\u0002&\n\u0001\u0004Y\u0015A\u0002<bYV,7\u000fE\u0002\u0013\u0019FI!!T\n\u0003\u0015q\u0012X\r]3bi\u0016$g\b")
public class LogConfigTest {
    @Test
    public void ensureNoStaticInitializationOrderDependency() {
        Assert.assertTrue((KafkaConfig$.MODULE$.LogRetentionTimeMillisProp() != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)LogConfig$.MODULE$.configNames().forall((Function1 & Serializable & scala.Serializable)config -> BoxesRunTime.boxToBoolean((boolean)LogConfigTest.$anonfun$ensureNoStaticInitializationOrderDependency$1(config))));
    }

    @Test
    public void testKafkaConfigToProps() {
        long millisInHour = 3600000L;
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        kafkaProps.put(KafkaConfig$.MODULE$.LogRollTimeHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRollTimeJitterHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRetentionTimeHoursProp(), "2");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Map logProps = KafkaServer$.MODULE$.copyKafkaConfigToLog(kafkaConfig);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get(LogConfig$.MODULE$.SegmentMsProp()));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get(LogConfig$.MODULE$.SegmentJitterMsProp()));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get(LogConfig$.MODULE$.RetentionMsProp()));
    }

    @Test
    public void testFromPropsEmpty() {
        Properties p = new Properties();
        LogConfig config = new LogConfig((Map)p, LogConfig$.MODULE$.apply$default$2());
        Assert.assertEquals((Object)LogConfig$.MODULE$.apply(), (Object)config);
    }

    @Test
    public void testFromPropsInvalid() {
        LogConfig$.MODULE$.configNames().foreach((Function1 & Serializable & scala.Serializable)name -> {
            LogConfigTest.$anonfun$testFromPropsInvalid$1(this, name);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testInvalidCompactionLagConfig() {
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MaxCompactionLagMsProp(), "100");
        props.setProperty(LogConfig$.MODULE$.MinCompactionLagMsProp(), "200");
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> LogConfig$.MODULE$.validate(props), ClassTag$.MODULE$.apply(Exception.class), new Position("LogConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
    }

    @Test
    public void shouldValidateThrottledReplicasConfig() {
        Assert.assertTrue((boolean)this.isValid("*"));
        Assert.assertTrue((boolean)this.isValid("* "));
        Assert.assertTrue((boolean)this.isValid(""));
        Assert.assertTrue((boolean)this.isValid(" "));
        Assert.assertTrue((boolean)this.isValid("100:10"));
        Assert.assertTrue((boolean)this.isValid("100:10,12:10"));
        Assert.assertTrue((boolean)this.isValid("100:10,12:10,15:1"));
        Assert.assertTrue((boolean)this.isValid("100:10,12:10,15:1  "));
        Assert.assertTrue((boolean)this.isValid("100:0,"));
        Assert.assertFalse((boolean)this.isValid("100"));
        Assert.assertFalse((boolean)this.isValid("100:"));
        Assert.assertFalse((boolean)this.isValid("100:0,10"));
        Assert.assertFalse((boolean)this.isValid("100:0,10:"));
        Assert.assertFalse((boolean)this.isValid("100:0,10:   "));
        Assert.assertFalse((boolean)this.isValid("100 :0,10:   "));
        Assert.assertFalse((boolean)this.isValid("100: 0,10:   "));
        Assert.assertFalse((boolean)this.isValid("100:0,10 :   "));
    }

    private boolean isValid(String configValue) {
        boolean bl;
        try {
            ThrottledReplicaListValidator$.MODULE$.ensureValidString("", configValue);
            bl = true;
        }
        catch (ConfigException configException) {
            bl = false;
        }
        return bl;
    }

    private void assertPropertyInvalid(String name, Seq<Object> values) {
        values.foreach((Function1 & Serializable & scala.Serializable)value -> {
            Properties props = new Properties();
            props.setProperty(name, value.toString());
            return (Exception)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> new LogConfig((Map)props, LogConfig$.MODULE$.apply$default$2()), ClassTag$.MODULE$.apply(Exception.class), new Position("LogConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        });
    }

    public static final /* synthetic */ boolean $anonfun$ensureNoStaticInitializationOrderDependency$1(String config) {
        Option serverConfigOpt = LogConfig$.MODULE$.serverConfigName(config);
        return serverConfigOpt.isDefined() && serverConfigOpt.get() != null;
    }

    public static final /* synthetic */ void $anonfun$testFromPropsInvalid$1(LogConfigTest $this, String name) {
        String string = name;
        String string2 = LogConfig$.MODULE$.UncleanLeaderElectionEnableProp();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not a boolean"}));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            String string4 = LogConfig$.MODULE$.RetentionBytesProp();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                String string6 = LogConfig$.MODULE$.RetentionMsProp();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    String string8 = LogConfig$.MODULE$.CleanupPolicyProp();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"true", "foobar"}));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        String string10 = LogConfig$.MODULE$.MinCleanableDirtyRatioProp();
                        String string11 = string;
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            String string12 = LogConfig$.MODULE$.MinInSyncReplicasProp();
                            String string13 = string;
                            if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                                $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "0", "-1"}));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                String string14 = LogConfig$.MODULE$.MessageFormatVersionProp();
                                String string15 = string;
                                if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                                    $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{""}));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    $this.assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-1"}));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

