/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import kafka.cluster.Partition;
import kafka.server.DelayedFetch;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.FetchMetadata;
import kafka.server.FetchPartitionData;
import kafka.server.FetchPartitionStatus;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.FetchRequest;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001U4A\u0001D\u0007\u0001%!)1\u0004\u0001C\u00019!9q\u0004\u0001b\u0001\n\u0013\u0001\u0003BB\u0014\u0001A\u0003%\u0011\u0005C\u0004)\u0001\t\u0007I\u0011B\u0015\t\r5\u0002\u0001\u0015!\u0003+\u0011\u001dq\u0003A1A\u0005\n=Baa\r\u0001!\u0002\u0013\u0001\u0004\"\u0002\u001b\u0001\t\u0003)\u0004\"\u0002!\u0001\t\u0013\t\u0005\"B,\u0001\t\u0013A\u0006\"B8\u0001\t\u0013\u0001(\u0001\u0005#fY\u0006LX\r\u001a$fi\u000eDG+Z:u\u0015\tqq\"\u0001\u0004tKJ4XM\u001d\u0006\u0002!\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0014!\t!\u0012$D\u0001\u0016\u0015\t1r#\u0001\u0005fCNLXn\\2l\u0015\u0005A\u0012aA8sO&\u0011!$\u0006\u0002\u0010\u000b\u0006\u001c\u00180T8dWN+\b\u000f]8si\u00061A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011!D\u0001\t[\u0006D()\u001f;fgV\t\u0011\u0005\u0005\u0002#K5\t1EC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13EA\u0002J]R\f\u0011\"\\1y\u0005f$Xm\u001d\u0011\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\t!\u0006\u0005\u0002\u001fW%\u0011A&\u0004\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003=\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0013\u0001\u0004:fa2L7-Y)v_R\fW#\u0001\u0019\u0011\u0005y\t\u0014B\u0001\u001a\u000e\u00051\u0011V\r\u001d7jG\u0006\fVo\u001c;b\u00035\u0011X\r\u001d7jG\u0006\fVo\u001c;bA\u0005AB/Z:u\r\u0016$8\r[,ji\"4UM\\2fI\u0016\u0003xn\u00195\u0015\u0003Y\u0002\"AI\u001c\n\u0005a\u001a#\u0001B+oSRD#\u0001\u0003\u001e\u0011\u0005mrT\"\u0001\u001f\u000b\u0005u:\u0012!\u00026v]&$\u0018BA =\u0005\u0011!Vm\u001d;\u0002%\t,\u0018\u000e\u001c3GKR\u001c\u0007.T3uC\u0012\fG/\u0019\u000b\u0005\u0005\u0016;%\u000b\u0005\u0002\u001f\u0007&\u0011A)\u0004\u0002\u000e\r\u0016$8\r['fi\u0006$\u0017\r^1\t\u000b\u0019K\u0001\u0019A\u0011\u0002\u0013I,\u0007\u000f\\5dC&#\u0007\"\u0002%\n\u0001\u0004I\u0015A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0003\u0015Bk\u0011a\u0013\u0006\u0003\u00196\u000baaY8n[>t'B\u0001\tO\u0015\tyu#\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003#.\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0003T\u0013\u0001\u0007A+A\u0006gKR\u001c\u0007n\u0015;biV\u001c\bC\u0001\u0010V\u0013\t1VB\u0001\u000bGKR\u001c\u0007\u000eU1si&$\u0018n\u001c8Ti\u0006$Xo]\u0001\u001fKb\u0004Xm\u0019;SK\u0006$gI]8n%\u0016\u0004H.[2b/&$\b.\u0012:s_J$RAN-[7\u001eDQA\u0012\u0006A\u0002\u0005BQ\u0001\u0013\u0006A\u0002%CQ\u0001\u0018\u0006A\u0002u\u000b!CZ3uG\"\u0004\u0016M\u001d;ji&|g\u000eR1uCB\u0011a\f\u001a\b\u0003?\nl\u0011\u0001\u0019\u0006\u0003C.\u000b\u0001B]3rk\u0016\u001cHo]\u0005\u0003G\u0002\fABR3uG\"\u0014V-];fgRL!!\u001a4\u0003\u001bA\u000b'\u000f^5uS>tG)\u0019;b\u0015\t\u0019\u0007\rC\u0003i\u0015\u0001\u0007\u0011.A\u0003feJ|'\u000f\u0005\u0002k[6\t1N\u0003\u0002m\u0017\u0006A\u0001O]8u_\u000e|G.\u0003\u0002oW\n1QI\u001d:peN\f\u0001DY;jY\u0012\u0014V-\u00193SKN,H\u000e^,ji\",%O]8s)\t\tH\u000f\u0005\u0002\u001fe&\u00111/\u0004\u0002\u000e\u0019><'+Z1e%\u0016\u001cX\u000f\u001c;\t\u000b!\\\u0001\u0019A5")
public class DelayedFetchTest
extends EasyMockSupport {
    private final int maxBytes;
    private final ReplicaManager replicaManager = (ReplicaManager)this.mock(ReplicaManager.class);
    private final ReplicaQuota replicaQuota = (ReplicaQuota)this.mock(ReplicaQuota.class);

    private int maxBytes() {
        return this.maxBytes;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private ReplicaQuota replicaQuota() {
        return this.replicaQuota;
    }

    @Test
    public void testFetchWithFencedEpoch() {
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        int replicaId = 1;
        FetchPartitionStatus fetchStatus = new FetchPartitionStatus(new LogOffsetMetadata(fetchOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), new FetchRequest.PartitionData(fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch));
        FetchMetadata fetchMetadata = this.buildFetchMetadata(replicaId, topicPartition, fetchStatus);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Function1 & Serializable & scala.Serializable)responses -> {
            DelayedFetchTest.callback$1(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Partition partition = (Partition)this.mock(Partition.class);
        EasyMock.expect((Object)this.replicaManager().getPartitionOrException(topicPartition, true)).andReturn((Object)partition);
        EasyMock.expect((Object)partition.fetchOffsetSnapshot(currentLeaderEpoch, true)).andThrow((Throwable)new FencedLeaderEpochException("Requested epoch has been fenced"));
        this.expectReadFromReplicaWithError(replicaId, topicPartition, fetchStatus.fetchInfo(), Errors.FENCED_LEADER_EPOCH);
        this.replayAll();
        Assert.assertTrue((boolean)delayedFetch.tryComplete());
        Assert.assertTrue((boolean)delayedFetch.isCompleted());
        Assert.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
        FetchPartitionData fetchResult = (FetchPartitionData)((Option)fetchResultOpt.elem).get();
        Assert.assertEquals((Object)Errors.FENCED_LEADER_EPOCH, (Object)fetchResult.error());
    }

    private FetchMetadata buildFetchMetadata(int replicaId, TopicPartition topicPartition, FetchPartitionStatus fetchStatus) {
        return new FetchMetadata(1, this.maxBytes(), false, true, (FetchIsolation)FetchLogEnd$.MODULE$, true, replicaId, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicPartition, (Object)fetchStatus)})));
    }

    private void expectReadFromReplicaWithError(int replicaId, TopicPartition topicPartition, FetchRequest.PartitionData fetchPartitionData, Errors error) {
        EasyMock.expect((Object)this.replicaManager().readFromLocalLog(replicaId, true, (FetchIsolation)FetchLogEnd$.MODULE$, this.maxBytes(), false, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicPartition, (Object)fetchPartitionData)})), this.replicaQuota())).andReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicPartition, (Object)this.buildReadResultWithError(error))})));
    }

    private LogReadResult buildReadResultWithError(Errors error) {
        Some x$1 = new Some((Object)error.exception());
        FetchDataInfo x$2 = new FetchDataInfo(LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata(), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4());
        long x$3 = -1L;
        long x$4 = -1L;
        long x$5 = -1L;
        long x$6 = -1L;
        long x$7 = -1L;
        int x$8 = -1;
        None$ x$9 = None$.MODULE$;
        return new LogReadResult(x$2, x$3, x$4, x$5, x$6, x$7, x$8, (Option)x$9, (Option)x$1);
    }

    private static final void callback$1(Seq responses, ObjectRef fetchResultOpt$1) {
        fetchResultOpt$1.elem = new Some(((Tuple2)responses.head())._2());
    }

    public DelayedFetchTest() {
        this.maxBytes = 1024;
    }
}

