/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Properties;
import kafka.server.BrokerMetadata;
import kafka.utils.Logging;
import kafka.utils.VerifiableProperties;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\r3A\u0001C\u0005\u0001\u001d!A1\u0004\u0001BC\u0002\u0013\u0005A\u0004\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003\u001e\u0011\u00151\u0003\u0001\"\u0001(\u0011\u001dY\u0003A1A\u0005\n1Baa\r\u0001!\u0002\u0013i\u0003\"\u0002\u001b\u0001\t\u0003)\u0004\"\u0002 \u0001\t\u0003y$\u0001\u0007\"s_.,'/T3uC\u0012\fG/Y\"iK\u000e\\\u0007o\\5oi*\u0011!bC\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u00031\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u001fU\u0001\"\u0001E\n\u000e\u0003EQ\u0011AE\u0001\u0006g\u000e\fG.Y\u0005\u0003)E\u0011a!\u00118z%\u00164\u0007C\u0001\f\u001a\u001b\u00059\"B\u0001\r\f\u0003\u0015)H/\u001b7t\u0013\tQrCA\u0004M_\u001e<\u0017N\\4\u0002\t\u0019LG.Z\u000b\u0002;A\u0011adI\u0007\u0002?)\u0011\u0001%I\u0001\u0003S>T\u0011AI\u0001\u0005U\u00064\u0018-\u0003\u0002%?\t!a)\u001b7f\u0003\u00151\u0017\u000e\\3!\u0003\u0019a\u0014N\\5u}Q\u0011\u0001F\u000b\t\u0003S\u0001i\u0011!\u0003\u0005\u00067\r\u0001\r!H\u0001\u0005Y>\u001c7.F\u0001.!\tq\u0013'D\u00010\u0015\t\u0001\u0014%\u0001\u0003mC:<\u0017B\u0001\u001a0\u0005\u0019y%M[3di\u0006)An\\2lA\u0005)qO]5uKR\u0011a'\u000f\t\u0003!]J!\u0001O\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006u\u0019\u0001\raO\u0001\u000fEJ|7.\u001a:NKR\fG-\u0019;b!\tIC(\u0003\u0002>\u0013\tq!I]8lKJlU\r^1eCR\f\u0017\u0001\u0002:fC\u0012$\u0012\u0001\u0011\t\u0004!\u0005[\u0014B\u0001\"\u0012\u0005\u0019y\u0005\u000f^5p]\u0002")
public class BrokerMetadataCheckpoint
implements Logging {
    private final File file;
    private final Object lock;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        BrokerMetadataCheckpoint brokerMetadataCheckpoint = this;
        synchronized (brokerMetadataCheckpoint) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File file() {
        return this.file;
    }

    private Object lock() {
        return this.lock;
    }

    public void write(BrokerMetadata brokerMetadata) {
        Object object = this.lock();
        synchronized (object) {
            this.liftedTree1$1(brokerMetadata);
        }
    }

    public Option<BrokerMetadata> read() {
        Option option;
        Object object = new Object();
        try {
            Files.deleteIfExists(new File(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.file()), ".tmp")).toPath());
            Object object2 = this.lock();
            synchronized (object2) {
                Option option2 = this.liftedTree2$1(object);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                option = option2;
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    private final void liftedTree1$1(BrokerMetadata brokerMetadata$1) {
        try {
            Properties brokerMetaProps = new Properties();
            brokerMetaProps.setProperty("version", ((Object)BoxesRunTime.boxToInteger((int)0)).toString());
            brokerMetaProps.setProperty("broker.id", ((Object)BoxesRunTime.boxToInteger((int)brokerMetadata$1.brokerId())).toString());
            File temp = new File(new StringBuilder(4).append(this.file().getAbsolutePath()).append(".tmp").toString());
            FileOutputStream fileOutputStream = new FileOutputStream(temp);
            try {
                brokerMetaProps.store(fileOutputStream, "");
                fileOutputStream.flush();
                fileOutputStream.getFD().sync();
            }
            finally {
                Utils.closeQuietly((AutoCloseable)fileOutputStream, (String)temp.getName());
            }
            Utils.atomicMoveWithFallback((Path)temp.toPath(), (Path)this.file().toPath());
        }
        catch (IOException ie) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to write meta.properties due to", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> ie);
            throw ie;
        }
    }

    private final Option liftedTree2$1(Object nonLocalReturnKey1$1) {
        try {
            int version;
            VerifiableProperties brokerMetaProps = new VerifiableProperties(Utils.loadProps((String)this.file().getAbsolutePath()));
            int n = version = brokerMetaProps.getIntInRange("version", (Tuple2<Object, Object>)new Tuple2.mcII.sp(0, Integer.MAX_VALUE));
            switch (n) {
                case 0: {
                    int brokerId = brokerMetaProps.getIntInRange("broker.id", (Tuple2<Object, Object>)new Tuple2.mcII.sp(0, Integer.MAX_VALUE));
                    throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new BrokerMetadata(brokerId)));
                }
            }
            throw new IOException(new StringBuilder(57).append("Unrecognized version of the server meta.properties file: ").append(version).toString());
        }
        catch (NoSuchFileException noSuchFileException) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("No meta.properties file under dir %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file().getAbsolutePath()})));
        }
        catch (Exception e1) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Failed to read meta.properties file under dir %s due to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file().getAbsolutePath(), e1.getMessage()})));
            throw e1;
        }
        return None$.MODULE$;
    }

    public BrokerMetadataCheckpoint(File file) {
        this.file = file;
        Logging.$init$(this);
        this.lock = new Object();
    }
}

