/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Properties;
import kafka.log.LogCleaner$;
import kafka.network.SocketServer$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicListenerConfig$;
import kafka.server.DynamicLogConfig$;
import kafka.server.DynamicThreadPool$;
import kafka.server.KafkaConfig$;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.SslConfigs;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class DynamicBrokerConfig$ {
    public static DynamicBrokerConfig$ MODULE$;
    private final scala.collection.mutable.Set<String> DynamicSecurityConfigs;
    private final scala.collection.mutable.Set<String> AllDynamicConfigs;
    private final Set<String> ClusterLevelListenerConfigs;
    private final scala.collection.mutable.Set<String> PerBrokerConfigs;
    private final Set<String> ListenerMechanismConfigs;
    private final Set<String> kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs;
    private final Regex ListenerConfigRegex;
    private final scala.collection.mutable.Set<String> DynamicPasswordConfigs;

    static {
        new DynamicBrokerConfig$();
    }

    public scala.collection.mutable.Set<String> DynamicSecurityConfigs() {
        return this.DynamicSecurityConfigs;
    }

    public scala.collection.mutable.Set<String> AllDynamicConfigs() {
        return this.AllDynamicConfigs;
    }

    private Set<String> ClusterLevelListenerConfigs() {
        return this.ClusterLevelListenerConfigs;
    }

    private scala.collection.mutable.Set<String> PerBrokerConfigs() {
        return this.PerBrokerConfigs;
    }

    private Set<String> ListenerMechanismConfigs() {
        return this.ListenerMechanismConfigs;
    }

    public Set<String> kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs() {
        return this.kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs;
    }

    public Regex ListenerConfigRegex() {
        return this.ListenerConfigRegex;
    }

    private scala.collection.mutable.Set<String> DynamicPasswordConfigs() {
        return this.DynamicPasswordConfigs;
    }

    public boolean isPasswordConfig(String name) {
        return this.DynamicPasswordConfigs().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)name.endsWith(x$1)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> brokerConfigSynonyms(String name, boolean matchListenerOverride) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        String string = name;
        String string2 = KafkaConfig$.MODULE$.LogRollTimeMillisProp();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            bl3 = true;
        } else {
            String string4 = KafkaConfig$.MODULE$.LogRollTimeHoursProp();
            String string5 = string;
            bl3 = !(string4 != null ? !string4.equals(string5) : string5 != null);
        }
        if (bl3) {
            return new .colon.colon((Object)KafkaConfig$.MODULE$.LogRollTimeMillisProp(), (List)new .colon.colon((Object)KafkaConfig$.MODULE$.LogRollTimeHoursProp(), (List)Nil$.MODULE$));
        }
        String string6 = KafkaConfig$.MODULE$.LogRollTimeJitterMillisProp();
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            bl2 = true;
        } else {
            String string8 = KafkaConfig$.MODULE$.LogRollTimeJitterHoursProp();
            String string9 = string;
            bl2 = !(string8 != null ? !string8.equals(string9) : string9 != null);
        }
        if (bl2) {
            return new .colon.colon((Object)KafkaConfig$.MODULE$.LogRollTimeJitterMillisProp(), (List)new .colon.colon((Object)KafkaConfig$.MODULE$.LogRollTimeJitterHoursProp(), (List)Nil$.MODULE$));
        }
        String string10 = KafkaConfig$.MODULE$.LogFlushIntervalMsProp();
        String string11 = string;
        if (string10 == null) {
            if (string11 == null) return new .colon.colon((Object)KafkaConfig$.MODULE$.LogFlushIntervalMsProp(), (List)new .colon.colon((Object)KafkaConfig$.MODULE$.LogFlushSchedulerIntervalMsProp(), (List)Nil$.MODULE$));
        } else if (string10.equals(string11)) {
            return new .colon.colon((Object)KafkaConfig$.MODULE$.LogFlushIntervalMsProp(), (List)new .colon.colon((Object)KafkaConfig$.MODULE$.LogFlushSchedulerIntervalMsProp(), (List)Nil$.MODULE$));
        }
        String string12 = KafkaConfig$.MODULE$.LogRetentionTimeMillisProp();
        String string13 = string;
        if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
            bl = true;
        } else {
            String string14 = KafkaConfig$.MODULE$.LogRetentionTimeMinutesProp();
            String string15 = string;
            if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                bl = true;
            } else {
                String string16 = KafkaConfig$.MODULE$.LogRetentionTimeHoursProp();
                String string17 = string;
                bl = !(string16 != null ? !string16.equals(string17) : string17 != null);
            }
        }
        if (bl) {
            return new .colon.colon((Object)KafkaConfig$.MODULE$.LogRetentionTimeMillisProp(), (List)new .colon.colon((Object)KafkaConfig$.MODULE$.LogRetentionTimeMinutesProp(), (List)new .colon.colon((Object)KafkaConfig$.MODULE$.LogRetentionTimeHoursProp(), (List)Nil$.MODULE$)));
        }
        Option option = this.ListenerConfigRegex().unapplySeq((CharSequence)string);
        if (option.isEmpty()) return new .colon.colon((Object)name, (List)Nil$.MODULE$);
        if (option.get() == null) return new .colon.colon((Object)name, (List)Nil$.MODULE$);
        if (((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) return new .colon.colon((Object)name, (List)Nil$.MODULE$);
        String baseName = (String)((LinearSeqOptimized)option.get()).apply(0);
        if (!matchListenerOverride) return new .colon.colon((Object)name, (List)Nil$.MODULE$);
        Option mechanismConfig = this.ListenerMechanismConfigs().find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)baseName.endsWith(x$1)));
        return new .colon.colon((Object)name, (List)new .colon.colon((Object)((String)mechanismConfig.getOrElse((Function0 & Serializable & scala.Serializable)() -> baseName)), (List)Nil$.MODULE$));
    }

    public void validateConfigs(Properties props, boolean perBrokerConfig) {
        block0: {
            DynamicBrokerConfig$.checkInvalidProps$1(this.kafka$server$DynamicBrokerConfig$$nonDynamicConfigs(props), "Cannot update these configs dynamically");
            DynamicBrokerConfig$.checkInvalidProps$1(this.kafka$server$DynamicBrokerConfig$$securityConfigsWithoutListenerPrefix(props), "These security configs can be dynamically updated only per-listener using the listener prefix");
            this.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props);
            if (perBrokerConfig) break block0;
            DynamicBrokerConfig$.checkInvalidProps$1(this.kafka$server$DynamicBrokerConfig$$perBrokerConfigs(props), "Cannot update these configs at default cluster level, broker id must be specified");
        }
    }

    public Set<String> kafka$server$DynamicBrokerConfig$$perBrokerConfigs(Properties props) {
        Set configNames = ((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).keySet();
        return ((SetLike)configNames.intersect(this.PerBrokerConfigs())).$plus$plus((GenTraversableOnce)configNames.filter((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)this.perBrokerListenerConfig$1(name))));
    }

    public Set<String> kafka$server$DynamicBrokerConfig$$nonDynamicConfigs(Properties props) {
        return (Set)((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).keySet().intersect(DynamicConfig$Broker$.MODULE$.nonDynamicProps());
    }

    public Set<String> kafka$server$DynamicBrokerConfig$$securityConfigsWithoutListenerPrefix(Properties props) {
        return (Set)this.DynamicSecurityConfigs().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)props.containsKey(x$1)));
    }

    public void kafka$server$DynamicBrokerConfig$$validateConfigTypes(Properties props) {
        Properties baseProps = new Properties();
        ((IterableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                String v = (String)tuple2._2();
                Option option = MODULE$.ListenerConfigRegex().unapplySeq((CharSequence)string);
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                    String baseName = (String)((LinearSeqOptimized)option.get()).apply(0);
                    return baseProps.put(baseName, v);
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            return baseProps.put(k, v);
        });
        DynamicConfig$Broker$.MODULE$.validate(baseProps);
    }

    public void addDynamicConfigs(ConfigDef configDef) {
        KafkaConfig$.MODULE$.configKeys().filterKeys((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.$anonfun$addDynamicConfigs$1(elem))).values().foreach((Function1 & Serializable & scala.Serializable)config -> configDef.define(config.name, config.type, config.defaultValue, config.validator, config.importance, config.documentation, config.group, config.orderInGroup, config.width, config.displayName, config.dependents, config.recommender));
    }

    public java.util.Map<String, String> dynamicConfigUpdateModes() {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)this.AllDynamicConfigs().map((Function1 & Serializable & scala.Serializable)name -> {
            String mode = MODULE$.PerBrokerConfigs().contains(name) ? "per-broker" : "cluster-wide";
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), (Object)mode);
        }, scala.collection.mutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
    }

    public static final /* synthetic */ boolean $anonfun$DynamicPasswordConfigs$1(Tuple2 x$1) {
        ConfigDef.Type type = ((ConfigDef.ConfigKey)x$1._2()).type;
        ConfigDef.Type type2 = ConfigDef.Type.PASSWORD;
        return !(type != null ? !type.equals(type2) : type2 != null);
    }

    private static final void checkInvalidProps$1(Set invalidPropNames, String errorMessage) {
        if (invalidPropNames.nonEmpty()) {
            throw new ConfigException(new StringBuilder(2).append(errorMessage).append(": ").append(invalidPropNames).toString());
        }
    }

    private final boolean perBrokerListenerConfig$1(String name) {
        boolean bl;
        String string = name;
        Option option = this.ListenerConfigRegex().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String baseName = (String)((LinearSeqOptimized)option.get()).apply(0);
            bl = !this.ClusterLevelListenerConfigs().contains((Object)baseName);
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$addDynamicConfigs$1(String elem) {
        return MODULE$.AllDynamicConfigs().contains((Object)elem);
    }

    private DynamicBrokerConfig$() {
        MODULE$ = this;
        this.DynamicSecurityConfigs = (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(SslConfigs.RECONFIGURABLE_CONFIGS).asScala();
        this.AllDynamicConfigs = this.DynamicSecurityConfigs().$plus$plus(LogCleaner$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicLogConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicThreadPool$.MODULE$.ReconfigurableConfigs()).$plus$plus((GenTraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.MetricReporterClassesProp()}))).$plus$plus(DynamicListenerConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(SocketServer$.MODULE$.ReconfigurableConfigs());
        this.ClusterLevelListenerConfigs = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.MaxConnectionsProp()}));
        this.PerBrokerConfigs = this.DynamicSecurityConfigs().$plus$plus(DynamicListenerConfig$.MODULE$.ReconfigurableConfigs()).$minus$minus(this.ClusterLevelListenerConfigs());
        this.ListenerMechanismConfigs = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.SaslJaasConfigProp()}));
        this.kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ssl.keystore.location", "ssl.truststore.location"}));
        this.ListenerConfigRegex = new StringOps(Predef$.MODULE$.augmentString("listener\\.name\\.[^.]*\\.(.*)")).r();
        Set passwordConfigs = ((MapLike)KafkaConfig$.MODULE$.configKeys().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.$anonfun$DynamicPasswordConfigs$1(x$1)))).keySet();
        this.DynamicPasswordConfigs = (scala.collection.mutable.Set)this.AllDynamicConfigs().intersect((GenSet)passwordConfigs);
    }
}

