/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.util.Properties;
import kafka.metrics.KafkaMetricsReporter;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.server.KafkaServerStartable$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Option;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001!<Q\u0001E\t\t\u0002Y1Q\u0001G\t\t\u0002eAQ\u0001I\u0001\u0005\u0002\u0005BQAI\u0001\u0005\u0002\r2A\u0001G\t\u0001K!AA\u0006\u0002BC\u0002\u0013\u0005Q\u0006\u0003\u00052\t\t\u0005\t\u0015!\u0003/\u0011!\u0011DA!A!\u0002\u0013\u0019\u0004\"\u0002\u0011\u0005\t\u0003)\u0005b\u0002\n\u0005\u0005\u0004%I\u0001\u0013\u0005\u0007\u0019\u0012\u0001\u000b\u0011B%\t\u000b\u0001\"A\u0011A'\t\u000bA#A\u0011A)\t\u000bU#A\u0011A)\t\u000bY#A\u0011A,\t\u000bu#A\u0011A)\u0002)-\u000bgm[1TKJ4XM]*uCJ$\u0018M\u00197f\u0015\t\u00112#\u0001\u0004tKJ4XM\u001d\u0006\u0002)\u0005)1.\u00194lC\u000e\u0001\u0001CA\f\u0002\u001b\u0005\t\"\u0001F&bM.\f7+\u001a:wKJ\u001cF/\u0019:uC\ndWm\u0005\u0002\u00025A\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\f\u0002\u0013\u0019\u0014x.\u001c)s_B\u001cHC\u0001\u0013_!\t9BaE\u0002\u00055\u0019\u0002\"a\n\u0016\u000e\u0003!R!!K\n\u0002\u000bU$\u0018\u000e\\:\n\u0005-B#a\u0002'pO\u001eLgnZ\u0001\u0013gR\fG/[2TKJ4XM]\"p]\u001aLw-F\u0001/!\t9r&\u0003\u00021#\tY1*\u00194lC\u000e{gNZ5h\u0003M\u0019H/\u0019;jGN+'O^3s\u0007>tg-[4!\u0003%\u0011X\r]8si\u0016\u00148\u000fE\u00025y}r!!\u000e\u001e\u000f\u0005YJT\"A\u001c\u000b\u0005a*\u0012A\u0002\u001fs_>$h(C\u0001\u001e\u0013\tYD$A\u0004qC\u000e\\\u0017mZ3\n\u0005ur$aA*fc*\u00111\b\b\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005N\tq!\\3ue&\u001c7/\u0003\u0002E\u0003\n!2*\u00194lC6+GO]5dgJ+\u0007o\u001c:uKJ$2\u0001\n$H\u0011\u0015a\u0003\u00021\u0001/\u0011\u0015\u0011\u0004\u00021\u00014+\u0005I\u0005CA\fK\u0013\tY\u0015CA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\u0018aB:feZ,'\u000f\t\u000b\u0003I9CQaT\u0006A\u00029\nAb]3sm\u0016\u00148i\u001c8gS\u001e\fqa\u001d;beR,\b\u000fF\u0001S!\tY2+\u0003\u0002U9\t!QK\\5u\u0003!\u0019\b.\u001e;e_^t\u0017AD:fiN+'O^3s'R\fG/\u001a\u000b\u0003%bCQ!\u0017\bA\u0002i\u000b\u0001B\\3x'R\fG/\u001a\t\u00037mK!\u0001\u0018\u000f\u0003\t\tKH/Z\u0001\u000eC^\f\u0017\u000e^*ikR$wn\u001e8\t\u000b}\u001b\u0001\u0019\u00011\u0002\u0017M,'O^3s!J|\u0007o\u001d\t\u0003C\u001al\u0011A\u0019\u0006\u0003G\u0012\fA!\u001e;jY*\tQ-\u0001\u0003kCZ\f\u0017BA4c\u0005)\u0001&o\u001c9feRLWm\u001d")
public class KafkaServerStartable
implements Logging {
    private final KafkaConfig staticServerConfig;
    private final KafkaServer server;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static KafkaServerStartable fromProps(Properties properties) {
        return KafkaServerStartable$.MODULE$.fromProps(properties);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        KafkaServerStartable kafkaServerStartable = this;
        synchronized (kafkaServerStartable) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig staticServerConfig() {
        return this.staticServerConfig;
    }

    private KafkaServer server() {
        return this.server;
    }

    public void startup() {
        try {
            this.server().startup();
        }
        catch (Throwable throwable) {
            this.fatal((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Exiting Kafka.");
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
    }

    public void shutdown() {
        try {
            this.server().shutdown();
        }
        catch (Throwable throwable) {
            this.fatal((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Halting Kafka.");
            throw Exit$.MODULE$.halt(1, Exit$.MODULE$.halt$default$2());
        }
    }

    public void setServerState(byte newState) {
        this.server().brokerState().newState(newState);
    }

    public void awaitShutdown() {
        this.server().awaitShutdown();
    }

    public KafkaServerStartable(KafkaConfig staticServerConfig, Seq<KafkaMetricsReporter> reporters) {
        this.staticServerConfig = staticServerConfig;
        Logging.$init$(this);
        KafkaConfig x$1 = staticServerConfig;
        Seq<KafkaMetricsReporter> x$2 = reporters;
        Time x$3 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        Option<String> x$4 = KafkaServer$.MODULE$.$lessinit$greater$default$3();
        this.server = new KafkaServer(x$1, x$3, x$4, x$2);
    }

    public KafkaServerStartable(KafkaConfig serverConfig) {
        this(serverConfig, (Seq<KafkaMetricsReporter>)((Seq)Seq$.MODULE$.empty()));
    }
}

