/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import kafka.common.TopicAndPartition;
import kafka.utils.Json$;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils;
import kafka.zk.ReassignPartitionsZNode$;
import kafka.zk.ZkData$;
import org.I0Itec.zkclient.IZkConnection;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.ZkConnection;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.kafka.common.TopicPartition;
import org.apache.zookeeper.data.ACL;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class ZkUtils$ {
    public static ZkUtils$ MODULE$;
    private final ArrayList<ACL> kafka$utils$ZkUtils$$UseDefaultAcls;
    private final String AdminPath;
    private final String BrokersPath;
    private final String ClusterPath;
    private final String ConfigPath;
    private final String ControllerPath;
    private final String ControllerEpochPath;
    private final String IsrChangeNotificationPath;
    private final String LogDirEventNotificationPath;
    private final String KafkaAclPath;
    private final String KafkaAclChangesPath;
    private final String ConsumersPath;
    private final String ClusterIdPath;
    private final String BrokerIdsPath;
    private final String BrokerTopicsPath;
    private final String ReassignPartitionsPath;
    private final String DeleteTopicsPath;
    private final String PreferredReplicaLeaderElectionPath;
    private final String BrokerSequenceIdPath;
    private final String ConfigChangesPath;
    private final String ConfigUsersPath;
    private final String ConfigBrokersPath;
    private final String ProducerIdBlockPath;
    private final Seq<String> SecureZkRootPaths;
    private final Seq<String> SensitiveZkRootPaths;

    static {
        new ZkUtils$();
    }

    public ArrayList<ACL> kafka$utils$ZkUtils$$UseDefaultAcls() {
        return this.kafka$utils$ZkUtils$$UseDefaultAcls;
    }

    public String AdminPath() {
        return this.AdminPath;
    }

    public String BrokersPath() {
        return this.BrokersPath;
    }

    public String ClusterPath() {
        return this.ClusterPath;
    }

    public String ConfigPath() {
        return this.ConfigPath;
    }

    public String ControllerPath() {
        return this.ControllerPath;
    }

    public String ControllerEpochPath() {
        return this.ControllerEpochPath;
    }

    public String IsrChangeNotificationPath() {
        return this.IsrChangeNotificationPath;
    }

    public String LogDirEventNotificationPath() {
        return this.LogDirEventNotificationPath;
    }

    public String KafkaAclPath() {
        return this.KafkaAclPath;
    }

    public String KafkaAclChangesPath() {
        return this.KafkaAclChangesPath;
    }

    public String ConsumersPath() {
        return this.ConsumersPath;
    }

    public String ClusterIdPath() {
        return this.ClusterIdPath;
    }

    public String BrokerIdsPath() {
        return this.BrokerIdsPath;
    }

    public String BrokerTopicsPath() {
        return this.BrokerTopicsPath;
    }

    public String ReassignPartitionsPath() {
        return this.ReassignPartitionsPath;
    }

    public String DeleteTopicsPath() {
        return this.DeleteTopicsPath;
    }

    public String PreferredReplicaLeaderElectionPath() {
        return this.PreferredReplicaLeaderElectionPath;
    }

    public String BrokerSequenceIdPath() {
        return this.BrokerSequenceIdPath;
    }

    public String ConfigChangesPath() {
        return this.ConfigChangesPath;
    }

    public String ConfigUsersPath() {
        return this.ConfigUsersPath;
    }

    public String ConfigBrokersPath() {
        return this.ConfigBrokersPath;
    }

    public String ProducerIdBlockPath() {
        return this.ProducerIdBlockPath;
    }

    public Seq<String> SecureZkRootPaths() {
        return this.SecureZkRootPaths;
    }

    public Seq<String> SensitiveZkRootPaths() {
        return this.SensitiveZkRootPaths;
    }

    public ZkUtils apply(String zkUrl, int sessionTimeout, int connectionTimeout, boolean isZkSecurityEnabled) {
        Tuple2<ZkClient, ZkConnection> tuple2 = this.createZkClientAndConnection(zkUrl, sessionTimeout, connectionTimeout);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ZkClient zkClient = (ZkClient)tuple2._1();
        ZkConnection zkConnection = (ZkConnection)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)zkClient, (Object)zkConnection);
        Tuple2 tuple23 = tuple22;
        ZkClient zkClient2 = (ZkClient)tuple23._1();
        ZkConnection zkConnection2 = (ZkConnection)tuple23._2();
        return new ZkUtils(zkClient2, zkConnection2, isZkSecurityEnabled);
    }

    public ZkUtils apply(ZkClient zkClient, boolean isZkSecurityEnabled) {
        return new ZkUtils(zkClient, null, isZkSecurityEnabled);
    }

    public ZkClient createZkClient(String zkUrl, int sessionTimeout, int connectionTimeout) {
        ZkClient zkClient = new ZkClient(zkUrl, sessionTimeout, connectionTimeout, (ZkSerializer)ZKStringSerializer$.MODULE$);
        return zkClient;
    }

    public Tuple2<ZkClient, ZkConnection> createZkClientAndConnection(String zkUrl, int sessionTimeout, int connectionTimeout) {
        ZkConnection zkConnection = new ZkConnection(zkUrl, sessionTimeout);
        ZkClient zkClient = new ZkClient((IZkConnection)zkConnection, connectionTimeout, (ZkSerializer)ZKStringSerializer$.MODULE$);
        return new Tuple2((Object)zkClient, (Object)zkConnection);
    }

    public boolean sensitivePath(String path) {
        return ZkData$.MODULE$.sensitivePath(path);
    }

    public List<ACL> defaultAcls(boolean isSecure, String path) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(ZkData$.MODULE$.defaultAcls(isSecure, path)).asJava();
    }

    public void maybeDeletePath(String zkUrl, String dir) {
        try {
            ZkClient zk = this.createZkClient(zkUrl, 30000, 30000);
            zk.deleteRecursive(dir);
            zk.close();
        }
        catch (Throwable throwable) {}
    }

    public String getTopicPath(String topic) {
        return new StringBuilder(1).append(this.BrokerTopicsPath()).append("/").append(topic).toString();
    }

    public String getTopicPartitionsPath(String topic) {
        return new StringBuilder(11).append(this.getTopicPath(topic)).append("/partitions").toString();
    }

    public String getTopicPartitionPath(String topic, int partitionId) {
        return new StringBuilder(1).append(this.getTopicPartitionsPath(topic)).append("/").append(partitionId).toString();
    }

    public String getTopicPartitionLeaderAndIsrPath(String topic, int partitionId) {
        return new StringBuilder(6).append(this.getTopicPartitionPath(topic, partitionId)).append("/").append("state").toString();
    }

    public String getEntityConfigRootPath(String entityType) {
        return new StringBuilder(1).append(this.ConfigPath()).append("/").append(entityType).toString();
    }

    public String getEntityConfigPath(String entityType, String entity) {
        return new StringBuilder(1).append(this.getEntityConfigRootPath(entityType)).append("/").append(entity).toString();
    }

    public String getEntityConfigPath(String entityPath) {
        return new StringBuilder(1).append(this.ConfigPath()).append("/").append(entityPath).toString();
    }

    public String getDeleteTopicPath(String topic) {
        return new StringBuilder(1).append(this.DeleteTopicsPath()).append("/").append(topic).toString();
    }

    public Map<TopicAndPartition, Seq<Object>> parsePartitionReassignmentData(String jsonData) {
        Map result;
        byte[] utf8Bytes = jsonData.getBytes(StandardCharsets.UTF_8);
        Either<JsonProcessingException, Map<TopicPartition, Seq<Object>>> either = ReassignPartitionsZNode$.MODULE$.decode(utf8Bytes);
        if (either instanceof Left) {
            Left left = (Left)either;
            JsonProcessingException e = (JsonProcessingException)left.value();
            throw e;
        }
        if (!(either instanceof Right)) {
            throw new MatchError(either);
        }
        Right right = (Right)either;
        Map map = result = (Map)right.value();
        Map assignments = map;
        return (Map)assignments.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            Seq p = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)new TopicAndPartition(tp), (Object)p);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }

    public String controllerZkData(int brokerId, long timestamp) {
        return Json$.MODULE$.legacyEncodeAsString(Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"brokerid"), (Object)BoxesRunTime.boxToInteger((int)brokerId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestamp"), (Object)((Object)BoxesRunTime.boxToLong((long)timestamp)).toString())})));
    }

    public String preferredReplicaLeaderElectionZkData(Set<TopicAndPartition> partitions) {
        return Json$.MODULE$.legacyEncodeAsString(Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitions"), partitions.map((Function1 & Serializable & scala.Serializable)tp -> (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)tp.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)BoxesRunTime.boxToInteger((int)tp.partition()))})), Set$.MODULE$.canBuildFrom()))})));
    }

    public String formatAsReassignmentJson(Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned) {
        return Json$.MODULE$.legacyEncodeAsString(Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitions"), partitionsToBeReassigned.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Seq replicas;
            TopicAndPartition topicAndPartition;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$1;
                    if (tuple2 == null) break block2;
                    topicAndPartition = (TopicAndPartition)tuple2._1();
                    replicas = (Seq)tuple2._2();
                    if (topicAndPartition != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            String topic = topicAndPartition.topic();
            int partition = topicAndPartition.partition();
            Map map = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)topic), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)BoxesRunTime.boxToInteger((int)partition)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"replicas"), (Object)replicas)}));
            return map;
        }, Iterable$.MODULE$.canBuildFrom()))})));
    }

    public String getReassignmentJson(Map<TopicPartition, Seq<Object>> partitionsToBeReassigned) {
        return Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitions"), JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)partitionsToBeReassigned.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            Seq replicas = (Seq)tuple2._2();
            java.util.Map map = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)tp.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)BoxesRunTime.boxToInteger((int)tp.partition())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"replicas"), JavaConverters$.MODULE$.seqAsJavaListConverter(replicas).asJava())}))).asJava();
            return map;
        }, Iterable$.MODULE$.canBuildFrom())).asJava())}))).asJava());
    }

    private ZkUtils$() {
        MODULE$ = this;
        this.kafka$utils$ZkUtils$$UseDefaultAcls = new ArrayList();
        this.AdminPath = "/admin";
        this.BrokersPath = "/brokers";
        this.ClusterPath = "/cluster";
        this.ConfigPath = "/config";
        this.ControllerPath = "/controller";
        this.ControllerEpochPath = "/controller_epoch";
        this.IsrChangeNotificationPath = "/isr_change_notification";
        this.LogDirEventNotificationPath = "/log_dir_event_notification";
        this.KafkaAclPath = "/kafka-acl";
        this.KafkaAclChangesPath = "/kafka-acl-changes";
        this.ConsumersPath = "/consumers";
        this.ClusterIdPath = new StringBuilder(3).append(this.ClusterPath()).append("/id").toString();
        this.BrokerIdsPath = new StringBuilder(4).append(this.BrokersPath()).append("/ids").toString();
        this.BrokerTopicsPath = new StringBuilder(7).append(this.BrokersPath()).append("/topics").toString();
        this.ReassignPartitionsPath = new StringBuilder(20).append(this.AdminPath()).append("/reassign_partitions").toString();
        this.DeleteTopicsPath = new StringBuilder(14).append(this.AdminPath()).append("/delete_topics").toString();
        this.PreferredReplicaLeaderElectionPath = new StringBuilder(27).append(this.AdminPath()).append("/preferred_replica_election").toString();
        this.BrokerSequenceIdPath = new StringBuilder(6).append(this.BrokersPath()).append("/seqid").toString();
        this.ConfigChangesPath = new StringBuilder(8).append(this.ConfigPath()).append("/changes").toString();
        this.ConfigUsersPath = new StringBuilder(6).append(this.ConfigPath()).append("/users").toString();
        this.ConfigBrokersPath = new StringBuilder(8).append(this.ConfigPath()).append("/brokers").toString();
        this.ProducerIdBlockPath = "/latest_producer_id_block";
        this.SecureZkRootPaths = ZkData$.MODULE$.SecureRootPaths();
        this.SensitiveZkRootPaths = ZkData$.MODULE$.SensitiveRootPaths();
    }
}

