/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import kafka.log.CleanerConfig;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.server.FetchDataInfo;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t5a\u0001\u0002\u00180\u0001QBQa\u000f\u0001\u0005\u0002qBqa\u0010\u0001C\u0002\u0013\u0005\u0001\t\u0003\u0004H\u0001\u0001\u0006I!\u0011\u0005\b\u0011\u0002\u0011\r\u0011\"\u0001J\u0011\u0019i\u0005\u0001)A\u0005\u0015\"9a\n\u0001b\u0001\n\u0003I\u0005BB(\u0001A\u0003%!\nC\u0004Q\u0001\t\u0007I\u0011A)\t\ri\u0003\u0001\u0015!\u0003S\u0011\u001dY\u0006A1A\u0005\u0002qCa\u0001\u0019\u0001!\u0002\u0013i\u0006bB1\u0001\u0001\u0004%\tA\u0019\u0005\bS\u0002\u0001\r\u0011\"\u0001k\u0011\u0019\u0001\b\u0001)Q\u0005G\"9\u0011\u000f\u0001a\u0001\n\u0003\u0011\bb\u0002<\u0001\u0001\u0004%\ta\u001e\u0005\u0007s\u0002\u0001\u000b\u0015B:\t\u000fi\u0004!\u0019!C\u0001w\"9\u0011Q\u0001\u0001!\u0002\u0013a\b\"CA\u0004\u0001\t\u0007I\u0011AA\u0005\u0011!\t\t\u0002\u0001Q\u0001\n\u0005-\u0001bBA\n\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u0003S\u0001A\u0011AA\u000b\u0011\u001d\t\u0019\u0004\u0001C\u0001\u0003+Aq!!\u0010\u0001\t\u0003\t)\u0002C\u0004\u0002B\u0001!\t!!\u0006\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002\u0016!9\u0011\u0011\n\u0001\u0005\u0002\u0005U\u0001bBA'\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u0003#\u0002A\u0011AA\u000b\u0011\u001d\t)\u0006\u0001C\u0005\u0003/Bq!!\u001d\u0001\t\u0003\t)\u0002C\u0004\u0002v\u0001!\t!!\u0006\t\u000f\u0005e\u0004\u0001\"\u0001\u0002\u0016!9\u0011Q\u0010\u0001\u0005\u0002\u0005U\u0001bBAA\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u0003\u000b\u0003A\u0011AA\u000b\u0011\u001d\tI\t\u0001C\u0005\u0003\u0017Cq!!/\u0001\t\u0013\tY\fC\u0005\u0002D\u0002\t\n\u0011\"\u0003\u0002F\"9\u00111\u001c\u0001\u0005\u0002\u0005U\u0001bBAp\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u0003G\u0004A\u0011AA\u000b\u0011\u001d\t9\u000f\u0001C\u0005\u0003SD\u0011Ba\u0002\u0001#\u0003%IA!\u0003\u0003\u001d1{w-T1oC\u001e,'\u000fV3ti*\u0011\u0001'M\u0001\u0004Y><'\"\u0001\u001a\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u000e\t\u0003mej\u0011a\u000e\u0006\u0002q\u0005)1oY1mC&\u0011!h\u000e\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005i\u0004C\u0001 \u0001\u001b\u0005y\u0013\u0001\u0002;j[\u0016,\u0012!\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\tF\nQ!\u001e;jYNL!AR\"\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\nq\"\\1y%>dG.\u00138uKJ4\u0018\r\\\u000b\u0002\u0015B\u0011agS\u0005\u0003\u0019^\u00121!\u00138u\u0003Ai\u0017\r\u001f*pY2Le\u000e^3sm\u0006d\u0007%A\u0006nCbdunZ!hK6\u001b\u0018\u0001D7bq2{w-Q4f\u001bN\u0004\u0013\u0001\u00037pOB\u0013x\u000e]:\u0016\u0003I\u0003\"a\u0015-\u000e\u0003QS!!\u0016,\u0002\tU$\u0018\u000e\u001c\u0006\u0002/\u0006!!.\u0019<b\u0013\tIFK\u0001\u0006Qe>\u0004XM\u001d;jKN\f\u0011\u0002\\8h!J|\u0007o\u001d\u0011\u0002\u00131|wmQ8oM&<W#A/\u0011\u0005yr\u0016BA00\u0005%aunZ\"p]\u001aLw-\u0001\u0006m_\u001e\u001cuN\u001c4jO\u0002\na\u0001\\8h\t&\u0014X#A2\u0011\u0005\u0011<W\"A3\u000b\u0005\u00194\u0016AA5p\u0013\tAWM\u0001\u0003GS2,\u0017A\u00037pO\u0012K'o\u0018\u0013fcR\u00111N\u001c\t\u0003m1L!!\\\u001c\u0003\tUs\u0017\u000e\u001e\u0005\b_6\t\t\u00111\u0001d\u0003\rAH%M\u0001\bY><G)\u001b:!\u0003)awnZ'b]\u0006<WM]\u000b\u0002gB\u0011a\b^\u0005\u0003k>\u0012!\u0002T8h\u001b\u0006t\u0017mZ3s\u00039awnZ'b]\u0006<WM]0%KF$\"a\u001b=\t\u000f=\u0004\u0012\u0011!a\u0001g\u0006YAn\\4NC:\fw-\u001a:!\u0003\u0011q\u0017-\\3\u0016\u0003q\u00042!`A\u0001\u001b\u0005q(BA@W\u0003\u0011a\u0017M\\4\n\u0007\u0005\raP\u0001\u0004TiJLgnZ\u0001\u0006]\u0006lW\rI\u0001\u001am\u0016\u0014\u0018\u0010T1sO\u0016dun\u001a$mkND\u0017J\u001c;feZ\fG.\u0006\u0002\u0002\fA\u0019a'!\u0004\n\u0007\u0005=qG\u0001\u0003M_:<\u0017A\u0007<fefd\u0015M]4f\u0019><g\t\\;tQ&sG/\u001a:wC2\u0004\u0013!B:fiV\u0003H#A6)\u0007Y\tI\u0002\u0005\u0003\u0002\u001c\u0005\u0015RBAA\u000f\u0015\u0011\ty\"!\t\u0002\u000b),h.\u001b;\u000b\u0005\u0005\r\u0012aA8sO&!\u0011qEA\u000f\u0005\u0019\u0011UMZ8sK\u0006AA/Z1s\t><h\u000eK\u0002\u0018\u0003[\u0001B!a\u0007\u00020%!\u0011\u0011GA\u000f\u0005\u0015\te\r^3s\u00035!Xm\u001d;De\u0016\fG/\u001a'pO\"\u001a\u0001$a\u000e\u0011\t\u0005m\u0011\u0011H\u0005\u0005\u0003w\tiB\u0001\u0003UKN$\u0018A\b;fgR\u001c%/Z1uK2{wmV5uQ&sg/\u00197jI2{w\rR5sQ\rI\u0012qG\u0001\u0016i\u0016\u001cHoR3u\u001d>tW\t_5ti\u0016tG\u000fT8hQ\rQ\u0012qG\u0001\u001bi\u0016\u001cHo\u00117fC:,\b/\u0012=qSJ,GmU3h[\u0016tGo\u001d\u0015\u00047\u0005]\u0012!\t;fgR\u001cE.Z1okB\u001cVmZ7f]R\u001cHk\\'bS:$\u0018-\u001b8TSj,\u0007f\u0001\u000f\u00028\u0005QC/Z:u\t>,7O\u001c;DY\u0016\fg\u000eT8hg^KG\u000f[\"p[B\f7\r\u001e#fY\u0016$X\rU8mS\u000eL\bfA\u000f\u00028\u0005!C/Z:u\t>,7O\u001c;DY\u0016\fg\u000eT8hg^KG\u000f[\"p[B\f7\r\u001e)pY&\u001c\u0017\u0010K\u0002\u001f\u0003o\t1\u0003^3ti\u0012{Wm\u001d8u\u00072,\u0017M\u001c'pON$2a[A-\u0011\u001d\tYf\ba\u0001\u0003;\na\u0001]8mS\u000eL\b\u0003BA0\u0003[rA!!\u0019\u0002jA\u0019\u00111M\u001c\u000e\u0005\u0005\u0015$bAA4g\u00051AH]8pizJ1!a\u001b8\u0003\u0019\u0001&/\u001a3fM&!\u00111AA8\u0015\r\tYgN\u0001\u0013i\u0016\u001cH\u000fV5nK\n\u000b7/\u001a3GYV\u001c\b\u000eK\u0002!\u0003o\t\u0011\u0004^3ti2+\u0017m\u001d;M_\u0006$W\rZ!tg&<g.\\3oi\"\u001a\u0011%a\u000e\u0002GQ,7\u000f\u001e+x_2{w-T1oC\u001e,'o]+tS:<7+Y7f\t&\u0014h)Y5mg\"\u001a!%a\u000e\u00029Q,7\u000f^\"iK\u000e\\\u0007o\\5oiJ+7m\u001c<fef\u0004v.\u001b8ug\"\u001a1%a\u000e\u0002[Q,7\u000f\u001e*fG>4XM]=ESJ,7\r^8ss6\u000b\u0007\u000f]5oO^KG\u000f\u001b+sC&d\u0017N\\4TY\u0006\u001c\b\u000eK\u0002%\u0003o\t\u0011\u0007^3tiJ+7m\u001c<fef$\u0015N]3di>\u0014\u00180T1qa&twmV5uQJ+G.\u0019;jm\u0016$\u0015N]3di>\u0014\u0018\u0010K\u0002&\u0003o\t\u0001D^3sS\u001aL8\t[3dWB|\u0017N\u001c;SK\u000e|g/\u001a:z)\u001dY\u0017QRA[\u0003oCq!a$'\u0001\u0004\t\t*A\bu_BL7\rU1si&$\u0018n\u001c8t!\u0019\t\u0019*!(\u0002$:!\u0011QSAM\u001d\u0011\t\u0019'a&\n\u0003aJ1!a'8\u0003\u001d\u0001\u0018mY6bO\u0016LA!a(\u0002\"\n\u00191+Z9\u000b\u0007\u0005mu\u0007\u0005\u0003\u0002&\u0006EVBAAT\u0015\u0011\tI+a+\u0002\r\r|W.\\8o\u0015\r\u0011\u0014Q\u0016\u0006\u0005\u0003_\u000b\t#\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003g\u000b9K\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000bE4\u0003\u0019A:\t\u000b\u00054\u0003\u0019A2\u0002!\r\u0014X-\u0019;f\u0019><W*\u00198bO\u0016\u0014HcA:\u0002>\"I\u0011qX\u0014\u0011\u0002\u0003\u0007\u0011\u0011Y\u0001\bY><G)\u001b:t!\u0015\t\u0019*!(d\u0003i\u0019'/Z1uK2{w-T1oC\u001e,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\t9M\u000b\u0003\u0002B\u0006%7FAAf!\u0011\ti-a6\u000e\u0005\u0005='\u0002BAi\u0003'\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005Uw'\u0001\u0006b]:|G/\u0019;j_:LA!!7\u0002P\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002EQ,7\u000f\u001e$jY\u0016\u0014VMZ3sK:\u001cWm]!gi\u0016\u0014\u0018i]=oG\u0012+G.\u001a;fQ\rI\u0013qG\u0001#i\u0016\u001cHo\u0011:fCR,\u0017I\u001c3EK2,G/Z(wKJd\u0017\u0010T8oOR{\u0007/[2)\u0007)\n9$A\u0011uKN$8\t[3dWB|\u0017N\u001c;G_J|e\u000e\\=BM\u001a,7\r^3e\u0019><7\u000fK\u0002,\u0003o\tqA]3bI2{w\r\u0006\u0005\u0002l\u0006]\u0018q B\u0002!\u0011\ti/a=\u000e\u0005\u0005=(bAAyc\u000511/\u001a:wKJLA!!>\u0002p\nia)\u001a;dQ\u0012\u000bG/Y%oM>Da\u0001\r\u0017A\u0002\u0005e\bc\u0001 \u0002|&\u0019\u0011Q`\u0018\u0003\u00071{w\rC\u0004\u0003\u00021\u0002\r!a\u0003\u0002\r=4gm]3u\u0011!\u0011)\u0001\fI\u0001\u0002\u0004Q\u0015!C7bq2+gn\u001a;i\u0003E\u0011X-\u00193M_\u001e$C-\u001a4bk2$HeM\u000b\u0003\u0005\u0017Q3ASAe\u0001")
public class LogManagerTest {
    private final MockTime time = new MockTime();
    private final int maxRollInterval;
    private final int maxLogAgeMs;
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private File logDir;
    private LogManager logManager;
    private final String name;
    private final long veryLargeLogFlushInterval;

    public MockTime time() {
        return this.time;
    }

    public int maxRollInterval() {
        return this.maxRollInterval;
    }

    public int maxLogAgeMs() {
        return this.maxLogAgeMs;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public String name() {
        return this.name;
    }

    public long veryLargeLogFlushInterval() {
        return this.veryLargeLogFlushInterval;
    }

    @Before
    public void setUp() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1()));
        this.logManager().startup();
    }

    @After
    public void tearDown() {
        if (this.logManager() != null) {
            this.logManager().shutdown();
        }
        Utils.delete((File)this.logDir());
        this.logManager().liveLogDirs().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            LogManagerTest.$anonfun$tearDown$1(x$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCreateLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        LogConfig x$2 = this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        Assert.assertEquals((long)1L, (long)this.logManager().liveLogDirs().size());
        File logFile = new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString());
        Assert.assertTrue((boolean)logFile.exists());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
    }

    @Test
    public void testCreateLogWithInvalidLogDir() {
        Seq dirs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir(), new File("\u0000")}));
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)dirs));
        this.logManager().startup();
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        LogConfig x$2 = this.logConfig();
        boolean x$3 = true;
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        File logFile = new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString());
        Assert.assertTrue((boolean)logFile.exists());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
    }

    @Test
    public void testGetNonExistentLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        boolean x$2 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(x$1, x$2);
        Assert.assertEquals((String)"No log should be found.", (Object)None$.MODULE$, (Object)log);
        File logFile = new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString());
        Assert.assertTrue((!logFile.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testCleanupExpiredSegments() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$12 = new TopicPartition(this.name(), 0);
        LogConfig x$2 = this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$12, x$2, x$3, x$4);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
            offset$1.elem = info.lastOffset();
        });
        Assert.assertTrue((String)"There should be more than one segment now.", (log.numberOfSegments() > 1 ? 1 : 0) != 0);
        log.onHighWatermarkIncremented(log.logEndOffset());
        log.logSegments().foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testCleanupExpiredSegments$2(this, x$1)));
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assert.assertEquals((String)"Now there should only be only one segment in the index.", (long)1L, (long)log.numberOfSegments());
        this.time().sleep(Predef$.MODULE$.Long2long(log.config().fileDeleteDelayMs()) + 1L);
        log.logSegments().foreach((Function1 & Serializable & scala.Serializable)s -> {
            s.lazyOffsetIndex().get();
            return s.lazyTimeIndex().get();
        });
        Assert.assertEquals((String)"Files should have been deleted", (long)(log.numberOfSegments() * 4 + 1), (long)log.dir().list().length);
        Assert.assertEquals((String)"Should get empty fetch off new log.", (long)0L, (long)this.readLog(log, offset.elem + 1L, this.readLog$default$3()).records().sizeInBytes());
        try {
            this.readLog(log, 0L, this.readLog$default$3());
            Assert.fail((String)"Should get exception from fetching earlier.");
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {}
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
    }

    @Test
    public void testCleanupSegmentsToMaintainSize() {
        int setSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()).sizeInBytes();
        this.logManager().shutdown();
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(10 * setSize));
        logProps.put(LogConfig$.MODULE$.RetentionBytesProp(), Predef$.MODULE$.long2Long(50L * (long)setSize + 10L));
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1()));
        this.logManager().startup();
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        LogConfig x$2 = config;
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        LongRef offset = LongRef.create((long)0L);
        int numMessages = 200;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
            offset$2.elem = BoxesRunTime.unboxToLong((Object)info.firstOffset().get());
        });
        log.onHighWatermarkIncremented(log.logEndOffset());
        Assert.assertEquals((String)"Check we have the expected number of segments.", (long)(numMessages * setSize / Predef$.MODULE$.Integer2int(config.segmentSize())), (long)log.numberOfSegments());
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assert.assertEquals((String)"Now there should be exactly 6 segments", (long)6L, (long)log.numberOfSegments());
        this.time().sleep(Predef$.MODULE$.Long2long(log.config().fileDeleteDelayMs()) + 1L);
        Assert.assertEquals((String)"Files should have been deleted", (long)(log.numberOfSegments() * 3 + 3), (long)log.dir().list().length);
        Assert.assertEquals((String)"Should get empty fetch off new log.", (long)0L, (long)this.readLog(log, offset.elem + 1L, this.readLog$default$3()).records().sizeInBytes());
        try {
            this.readLog(log, 0L, this.readLog$default$3());
            Assert.fail((String)"Should get exception from fetching earlier.");
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {}
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
    }

    @Test
    public void testDoesntCleanLogsWithCompactDeletePolicy() {
        this.testDoesntCleanLogs(new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString());
    }

    @Test
    public void testDoesntCleanLogsWithCompactPolicy() {
        this.testDoesntCleanLogs(LogConfig$.MODULE$.Compact());
    }

    private void testDoesntCleanLogs(String policy) {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), policy);
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        LogConfig x$22 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, x$22, x$3, x$4);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
            offset$3.elem = info.lastOffset();
        });
        int numSegments = log.numberOfSegments();
        Assert.assertTrue((String)"There should be more than one segment now.", (log.numberOfSegments() > 1 ? 1 : 0) != 0);
        log.logSegments().foreach((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testDoesntCleanLogs$2(this, x$2)));
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assert.assertEquals((String)"number of segments shouldn't have changed", (long)numSegments, (long)log.numberOfSegments());
    }

    @Test
    public void testTimeBasedFlush() {
        this.logManager().shutdown();
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.FlushMsProp(), Predef$.MODULE$.int2Integer(1000));
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1()));
        this.logManager().startup();
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        LogConfig x$2 = config;
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        long lastFlush = log.lastFlushTime();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach((Function1 & Serializable & scala.Serializable)_ -> LogManagerTest.$anonfun$testTimeBasedFlush$1(log, BoxesRunTime.unboxToInt((Object)_)));
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assert.assertTrue((String)"Time based flush should have been triggered", (lastFlush != log.lastFlushTime() ? 1 : 0) != 0);
    }

    @Test
    public void testLeastLoadedAssignment() {
        Seq dirs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{TestUtils$.MODULE$.tempDir(), TestUtils$.MODULE$.tempDir(), TestUtils$.MODULE$.tempDir()}));
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)dirs));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
            LogManager qual$1 = this.logManager();
            TopicPartition x$1 = new TopicPartition("test", partition);
            LogConfig x$2 = this.logConfig();
            boolean x$32 = qual$1.getOrCreateLog$default$3();
            boolean x$42 = qual$1.getOrCreateLog$default$4();
            qual$1.getOrCreateLog(x$1, x$2, x$32, x$42);
            Assert.assertEquals((String)"We should have created the right number of logs", (long)(partition + 1), (long)this.logManager().allLogs().size());
            Iterable counts = (Iterable)this.logManager().allLogs().groupBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.dir().getParent()).values().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.size()), Iterable$.MODULE$.canBuildFrom());
            Assert.assertTrue((String)"Load should balance evenly", (BoxesRunTime.unboxToInt((Object)counts.max((Ordering)Ordering.Int$.MODULE$)) <= BoxesRunTime.unboxToInt((Object)counts.min((Ordering)Ordering.Int$.MODULE$)) + 1 ? 1 : 0) != 0);
        });
    }

    @Test
    public void testTwoLogManagersUsingSameDirFails() {
        try {
            this.createLogManager(this.createLogManager$default$1());
            Assert.fail((String)"Should not be able to create a second log manager instance with the same data directory");
        }
        catch (KafkaException kafkaException) {}
    }

    @Test
    public void testCheckpointRecoveryPoints() {
        this.verifyCheckpointRecovery((Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 1), new TopicPartition("test-b", 1)}))), this.logManager(), this.logDir());
    }

    @Test
    public void testRecoveryDirectoryMappingWithTrailingSlash() {
        this.logManager().shutdown();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{new File(new StringBuilder(0).append(TestUtils$.MODULE$.tempDir().getAbsolutePath()).append(File.separator).toString())}))), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4()));
        this.logManager().startup();
        this.verifyCheckpointRecovery((Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 1)}))), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    @Test
    public void testRecoveryDirectoryMappingWithRelativeDirectory() {
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{new File("data", this.logDir().getName()).getAbsoluteFile()})))));
        this.logManager().startup();
        this.verifyCheckpointRecovery((Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 1)}))), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    private void verifyCheckpointRecovery(Seq<TopicPartition> topicPartitions, LogManager logManager, File logDir) {
        Seq logs = (Seq)topicPartitions.map((Function1 & Serializable & scala.Serializable)x$5 -> logManager.getOrCreateLog(x$5, this.logConfig(), logManager.getOrCreateLog$default$3(), logManager.getOrCreateLog$default$4()), Seq$.MODULE$.canBuildFrom());
        logs.foreach((Function1 & Serializable & scala.Serializable)log -> {
            LogManagerTest.$anonfun$verifyCheckpointRecovery$2(log);
            return BoxedUnit.UNIT;
        });
        logManager.checkpointLogRecoveryOffsets();
        Map checkpoints = new OffsetCheckpointFile(new File(logDir, LogManager$.MODULE$.RecoveryPointCheckpointFile()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read();
        ((IterableLike)topicPartitions.zip((GenIterable)logs, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LogManagerTest.$anonfun$verifyCheckpointRecovery$4(checkpoints, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private LogManager createLogManager(Seq<File> logDirs) {
        LogConfig x$1 = this.logConfig();
        Seq<File> x$2 = logDirs;
        MockTime x$3 = this.time();
        CleanerConfig x$4 = TestUtils$.MODULE$.createLogManager$default$3();
        return TestUtils$.MODULE$.createLogManager(x$2, x$1, x$4, x$3);
    }

    private Seq<File> createLogManager$default$1() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}));
    }

    @Test
    public void testFileReferencesAfterAsyncDelete() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        LogConfig x$2 = this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        LogSegment activeSegment = log.activeSegment();
        String logName = activeSegment.log().file().getName();
        String indexName = activeSegment.offsetIndex().file().getName();
        String timeIndexName = activeSegment.timeIndex().file().getName();
        String txnIndexName = activeSegment.txnIndex().file().getName();
        File[] indexFilesOnDiskBeforeDelete = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])activeSegment.log().file().getParentFile().listFiles())).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$1(x$6)));
        LogManager qual$2 = this.logManager();
        TopicPartition x$5 = new TopicPartition(this.name(), 0);
        boolean x$62 = qual$2.asyncDelete$default$2();
        Log removedLog = qual$2.asyncDelete(x$5, x$62);
        LogSegment removedSegment = removedLog.activeSegment();
        Seq indexFilesAfterDelete = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{removedSegment.lazyOffsetIndex().file(), removedSegment.lazyTimeIndex().file(), removedSegment.txnIndex().file()}));
        Assert.assertEquals((Object)new File(removedLog.dir(), logName), (Object)removedSegment.log().file());
        Assert.assertEquals((Object)new File(removedLog.dir(), indexName), (Object)removedSegment.lazyOffsetIndex().file());
        Assert.assertEquals((Object)new File(removedLog.dir(), timeIndexName), (Object)removedSegment.lazyTimeIndex().file());
        Assert.assertEquals((Object)new File(removedLog.dir(), txnIndexName), (Object)removedSegment.txnIndex().file());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])indexFilesOnDiskBeforeDelete)).foreach((Function1 & Serializable & scala.Serializable)fileBeforeDelete -> {
            LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$2(indexFilesAfterDelete, fileBeforeDelete);
            return BoxedUnit.UNIT;
        });
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assert.assertTrue((String)"Logs deleted too early", (boolean)this.logManager().hasLogsToBeDeleted());
        this.time().sleep(Predef$.MODULE$.Long2long(this.logManager().currentDefaultConfig().fileDeleteDelayMs()) - (long)this.logManager().InitialTaskDelayMs());
        Assert.assertFalse((String)"Logs not deleted", (boolean)this.logManager().hasLogsToBeDeleted());
    }

    @Test
    public void testCreateAndDeleteOverlyLongTopic() {
        String invalidTopicName = String.join((CharSequence)"", Collections.nCopies(253, "x"));
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(invalidTopicName, 0);
        LogConfig x$2 = this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        LogManager qual$2 = this.logManager();
        TopicPartition x$5 = new TopicPartition(invalidTopicName, 0);
        boolean x$6 = qual$2.asyncDelete$default$2();
        qual$2.asyncDelete(x$5, x$6);
    }

    @Test
    public void testCheckpointForOnlyAffectedLogs() {
        Seq tps = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 0), new TopicPartition("test-a", 1), new TopicPartition("test-a", 2), new TopicPartition("test-b", 0), new TopicPartition("test-b", 1)}));
        Seq allLogs = (Seq)tps.map((Function1 & Serializable & scala.Serializable)x$9 -> {
            LogManager qual$1 = this.logManager();
            TopicPartition x$1 = x$9;
            LogConfig x$2 = this.logConfig();
            boolean x$3 = qual$1.getOrCreateLog$default$3();
            boolean x$4 = qual$1.getOrCreateLog$default$4();
            return qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        }, Seq$.MODULE$.canBuildFrom());
        allLogs.foreach((Function1 & Serializable & scala.Serializable)log -> {
            LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$2(log);
            return BoxedUnit.UNIT;
        });
        this.logManager().checkpointRecoveryOffsetsAndCleanSnapshot(this.logDir(), (Seq)allLogs.filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$4(x$10))));
        Map checkpoints = new OffsetCheckpointFile(new File(this.logDir(), LogManager$.MODULE$.RecoveryPointCheckpointFile()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read();
        ((IterableLike)tps.zip((GenIterable)allLogs, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$5(checkpoints, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private FetchDataInfo readLog(Log log, long offset, int maxLength) {
        return log.read(offset, maxLength, (Option)None$.MODULE$, true, false);
    }

    private int readLog$default$3() {
        return 1024;
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$testCleanupExpiredSegments$2(LogManagerTest $this, LogSegment x$1) {
        return x$1.log().file().setLastModified($this.time().milliseconds());
    }

    public static final /* synthetic */ boolean $anonfun$testDoesntCleanLogs$2(LogManagerTest $this, LogSegment x$2) {
        return x$2.log().file().setLastModified($this.time().milliseconds());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testTimeBasedFlush$1(Log log$4, int _) {
        MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        return log$4.appendAsLeader(set, 0, log$4.appendAsLeader$default$3(), log$4.appendAsLeader$default$4());
    }

    public static final /* synthetic */ void $anonfun$verifyCheckpointRecovery$2(Log log) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4()));
        log.flush();
    }

    public static final /* synthetic */ void $anonfun$verifyCheckpointRecovery$4(Map checkpoints$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        Log log = (Log)tuple2._2();
        Assert.assertEquals((String)"Recovery point should equal checkpoint", (long)BoxesRunTime.unboxToLong((Object)checkpoints$1.apply((Object)tp)), (long)log.recoveryPoint());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)log.minSnapshotsOffsetToRetain())), (Object)log.oldestProducerSnapshotOffset());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$testFileReferencesAfterAsyncDelete$1(File x$6) {
        return x$6.getName().endsWith("index");
    }

    public static final /* synthetic */ boolean $anonfun$testFileReferencesAfterAsyncDelete$3(File fileBeforeDelete$1, File x$7) {
        String string = x$7.getName();
        String string2 = fileBeforeDelete$1.getName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testFileReferencesAfterAsyncDelete$2(Seq indexFilesAfterDelete$1, File fileBeforeDelete) {
        Option fileInIndex = indexFilesAfterDelete$1.find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$3(fileBeforeDelete, x$7)));
        Assert.assertEquals((String)new StringBuilder(51).append("Could not find index file ").append(fileBeforeDelete.getName()).append(" in indexFilesAfterDelete").toString(), (Object)new Some((Object)fileBeforeDelete.getName()), (Object)fileInIndex.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getName()));
        Assert.assertNotEquals((String)"File reference was not updated in index", (Object)fileBeforeDelete.getAbsolutePath(), (Object)((File)fileInIndex.get()).getAbsolutePath());
    }

    public static final /* synthetic */ void $anonfun$testCheckpointForOnlyAffectedLogs$2(Log log) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4()));
        log.flush();
    }

    public static final /* synthetic */ boolean $anonfun$testCheckpointForOnlyAffectedLogs$4(Log x$10) {
        return x$10.dir().getName().contains("test-a");
    }

    public static final /* synthetic */ void $anonfun$testCheckpointForOnlyAffectedLogs$5(Map checkpoints$2, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            Log log = (Log)tuple2._2();
            Assert.assertEquals((String)"Recovery point should equal checkpoint", (long)BoxesRunTime.unboxToLong((Object)checkpoints$2.apply((Object)tp)), (long)log.recoveryPoint());
            if (tp.topic().equals("test-a")) {
                Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)log.minSnapshotsOffsetToRetain())), (Object)log.oldestProducerSnapshotOffset());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Assert.assertNotEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)log.minSnapshotsOffsetToRetain())), (Object)log.oldestProducerSnapshotOffset());
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public LogManagerTest() {
        this.maxRollInterval = 100;
        this.maxLogAgeMs = 600000;
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(4096));
        this.logProps().put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(this.maxLogAgeMs()));
        this.logProps().put(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        this.logConfig = new LogConfig((java.util.Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.logDir = null;
        this.logManager = null;
        this.name = "kafka";
        this.veryLargeLogFlushInterval = 10000000L;
    }
}

