/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import kafka.log.AbortedTxn;
import kafka.log.AbortedTxn$;
import kafka.log.CorruptIndexException;
import kafka.log.TransactionIndex;
import kafka.log.TxnIndexSearchResult;
import kafka.utils.TestUtils$;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function1;
import scala.collection.GenTraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001}4A\u0001F\u000b\u00015!)Q\u0005\u0001C\u0001M!I\u0011\u0006\u0001a\u0001\u0002\u0004%\tA\u000b\u0005\ng\u0001\u0001\r\u00111A\u0005\u0002QB\u0011\"\u0010\u0001A\u0002\u0003\u0005\u000b\u0015B\u0016\t\u0013y\u0002\u0001\u0019!a\u0001\n\u0003y\u0004\"C\"\u0001\u0001\u0004\u0005\r\u0011\"\u0001E\u0011%1\u0005\u00011A\u0001B\u0003&\u0001\tC\u0004H\u0001\t\u0007I\u0011\u0001%\t\r1\u0003\u0001\u0015!\u0003J\u0011\u0015i\u0005\u0001\"\u0001O\u0011\u0015)\u0006\u0001\"\u0001O\u0011\u0015Q\u0006\u0001\"\u0001O\u0011\u0015y\u0006\u0001\"\u0001O\u0011\u00151\u0007\u0001\"\u0001O\u0011\u0015)\b\u0001\"\u0001O\u0011\u00159\b\u0001\"\u0001O\u0011\u0015I\b\u0001\"\u0001O\u0011\u0015Y\b\u0001\"\u0001O\u0011\u0015i\b\u0001\"\u0001O\u0005Q!&/\u00198tC\u000e$\u0018n\u001c8J]\u0012,\u0007\u0010V3ti*\u0011acF\u0001\u0004Y><'\"\u0001\r\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0007\t\u00039\rj\u0011!\b\u0006\u0003=}\tQA[;oSRT!\u0001I\u0011\u0002\u0013M\u001c\u0017\r\\1uKN$(\"\u0001\u0012\u0002\u0007=\u0014x-\u0003\u0002%;\tQ!*\u00168jiN+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u00059\u0003C\u0001\u0015\u0001\u001b\u0005)\u0012\u0001\u00024jY\u0016,\u0012a\u000b\t\u0003YEj\u0011!\f\u0006\u0003]=\n!![8\u000b\u0003A\nAA[1wC&\u0011!'\f\u0002\u0005\r&dW-\u0001\u0005gS2,w\fJ3r)\t)4\b\u0005\u00027s5\tqGC\u00019\u0003\u0015\u00198-\u00197b\u0013\tQtG\u0001\u0003V]&$\bb\u0002\u001f\u0004\u0003\u0003\u0005\raK\u0001\u0004q\u0012\n\u0014!\u00024jY\u0016\u0004\u0013!B5oI\u0016DX#\u0001!\u0011\u0005!\n\u0015B\u0001\"\u0016\u0005A!&/\u00198tC\u000e$\u0018n\u001c8J]\u0012,\u00070A\u0005j]\u0012,\u0007p\u0018\u0013fcR\u0011Q'\u0012\u0005\by\u0019\t\t\u00111\u0001A\u0003\u0019Ig\u000eZ3yA\u00051qN\u001a4tKR,\u0012!\u0013\t\u0003m)K!aS\u001c\u0003\t1{gnZ\u0001\b_\u001a47/\u001a;!\u0003\u0015\u0019X\r^;q)\u0005)\u0004F\u0001\u0006Q!\t\t6+D\u0001S\u0015\tq\u0012%\u0003\u0002U%\n1!)\u001a4pe\u0016\f\u0001\u0002^3be\u0012|wO\u001c\u0015\u0003\u0017]\u0003\"!\u0015-\n\u0005e\u0013&!B!gi\u0016\u0014\u0018A\t;fgR\u0004vn]5uS>t7+\u001a;D_J\u0014Xm\u0019;ms^CWM\\(qK:,G\r\u000b\u0002\r9B\u0011\u0011+X\u0005\u0003=J\u0013A\u0001V3ti\u0006yA/Z:u'\u0006t\u0017\u000e^=DQ\u0016\u001c7\u000e\u000b\u0003\u000e9\u0006\u0014\u0017\u0001C3ya\u0016\u001cG/\u001a3$\u0003\r\u0004\"\u0001\u000b3\n\u0005\u0015,\"!F\"peJ,\b\u000f^%oI\u0016DX\t_2faRLwN\\\u0001\u001bi\u0016\u001cH\u000fT1ti>3gm]3u\u001bV\u001cH/\u00138de\u0016\f7/\u001a\u0015\u0005\u001dq\u000b\u0007nI\u0001j!\tQ'O\u0004\u0002la:\u0011An\\\u0007\u0002[*\u0011a.G\u0001\u0007yI|w\u000e\u001e \n\u0003aJ!!]\u001c\u0002\u000fA\f7m[1hK&\u00111\u000f\u001e\u0002\u0019\u00132dWmZ1m\u0003J<W/\\3oi\u0016C8-\u001a9uS>t'BA98\u0003q!Xm\u001d;MCN$xJ\u001a4tKR\u001c\u0015M\u001c8pi\u0012+7M]3bg\u0016DCa\u0004/bQ\u0006qB/Z:u\u0007>dG.Z2u\u0003\n|'\u000f^3e)J\fgn]1di&|gn\u001d\u0015\u0003!q\u000bA\u0002^3tiR\u0013XO\\2bi\u0016D#!\u0005/\u0002'Q,7\u000f^!c_J$X\r\u001a+y]N+'\u000fZ3)\u0005Ia\u0016a\u0004;fgR\u0014VM\\1nK&sG-\u001a=)\u0005Ma\u0006")
public class TransactionIndexTest
extends JUnitSuite {
    private File file;
    private TransactionIndex index;
    private final long offset;

    public File file() {
        return this.file;
    }

    public void file_$eq(File x$1) {
        this.file = x$1;
    }

    public TransactionIndex index() {
        return this.index;
    }

    public void index_$eq(TransactionIndex x$1) {
        this.index = x$1;
    }

    public long offset() {
        return this.offset;
    }

    @Before
    public void setup() {
        this.file_$eq(TestUtils$.MODULE$.tempFile());
        this.index_$eq(new TransactionIndex(this.offset(), this.file()));
    }

    @After
    public void teardown() {
        this.index().close();
    }

    @Test
    public void testPositionSetCorrectlyWhenOpened() {
        .colon.colon abortedTxns = new .colon.colon((Object)new AbortedTxn(0L, 0L, 10L, 11L), (List)new .colon.colon((Object)new AbortedTxn(1L, 5L, 15L, 13L), (List)new .colon.colon((Object)new AbortedTxn(2L, 18L, 35L, 25L), (List)new .colon.colon((Object)new AbortedTxn(3L, 32L, 50L, 40L), (List)Nil$.MODULE$))));
        TransactionIndex transactionIndex = this.index();
        abortedTxns.foreach((Function1 & Serializable & scala.Serializable)abortedTxn -> {
            transactionIndex.append(abortedTxn);
            return BoxedUnit.UNIT;
        });
        this.index().close();
        TransactionIndex reopenedIndex = new TransactionIndex(0L, this.file());
        AbortedTxn anotherAbortedTxn = new AbortedTxn(3L, 50L, 60L, 55L);
        reopenedIndex.append(anotherAbortedTxn);
        Assert.assertEquals((Object)abortedTxns.$plus$plus((GenTraversableOnce)new .colon.colon((Object)anotherAbortedTxn, (List)Nil$.MODULE$), List$.MODULE$.canBuildFrom()), (Object)reopenedIndex.allAbortedTxns());
    }

    @Test(expected=CorruptIndexException.class)
    public void testSanityCheck() {
        .colon.colon abortedTxns = new .colon.colon((Object)new AbortedTxn(0L, 0L, 10L, 11L), (List)new .colon.colon((Object)new AbortedTxn(1L, 5L, 15L, 13L), (List)new .colon.colon((Object)new AbortedTxn(2L, 18L, 35L, 25L), (List)new .colon.colon((Object)new AbortedTxn(3L, 32L, 50L, 40L), (List)Nil$.MODULE$))));
        TransactionIndex transactionIndex = this.index();
        abortedTxns.foreach((Function1 & Serializable & scala.Serializable)abortedTxn -> {
            transactionIndex.append(abortedTxn);
            return BoxedUnit.UNIT;
        });
        this.index().close();
        TransactionIndex reopenedIndex = new TransactionIndex(100L, this.file());
        reopenedIndex.sanityCheck();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLastOffsetMustIncrease() {
        this.index().append(new AbortedTxn(1L, 5L, 15L, 13L));
        this.index().append(new AbortedTxn(0L, 0L, 15L, 11L));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLastOffsetCannotDecrease() {
        this.index().append(new AbortedTxn(1L, 5L, 15L, 13L));
        this.index().append(new AbortedTxn(0L, 0L, 10L, 11L));
    }

    @Test
    public void testCollectAbortedTransactions() {
        .colon.colon abortedTransactions = new .colon.colon((Object)new AbortedTxn(0L, 0L, 10L, 11L), (List)new .colon.colon((Object)new AbortedTxn(1L, 5L, 15L, 13L), (List)new .colon.colon((Object)new AbortedTxn(2L, 18L, 35L, 25L), (List)new .colon.colon((Object)new AbortedTxn(3L, 32L, 50L, 40L), (List)Nil$.MODULE$))));
        TransactionIndex transactionIndex = this.index();
        abortedTransactions.foreach((Function1 & Serializable & scala.Serializable)abortedTxn -> {
            transactionIndex.append(abortedTxn);
            return BoxedUnit.UNIT;
        });
        TxnIndexSearchResult result = this.index().collectAbortedTxns(0L, 100L);
        Assert.assertEquals((Object)abortedTransactions, (Object)result.abortedTransactions());
        Assert.assertFalse((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(0L, 32L);
        Assert.assertEquals((Object)abortedTransactions.take(3), (Object)result.abortedTransactions());
        Assert.assertTrue((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(0L, 35L);
        Assert.assertEquals((Object)abortedTransactions, (Object)result.abortedTransactions());
        Assert.assertTrue((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(10L, 35L);
        Assert.assertEquals((Object)abortedTransactions, (Object)result.abortedTransactions());
        Assert.assertTrue((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(11L, 35L);
        Assert.assertEquals((Object)abortedTransactions.slice(1, 4), (Object)result.abortedTransactions());
        Assert.assertTrue((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(20L, 41L);
        Assert.assertEquals((Object)abortedTransactions.slice(2, 4), (Object)result.abortedTransactions());
        Assert.assertFalse((boolean)result.isComplete());
    }

    @Test
    public void testTruncate() {
        .colon.colon abortedTransactions = new .colon.colon((Object)new AbortedTxn(0L, 0L, 10L, 2L), (List)new .colon.colon((Object)new AbortedTxn(1L, 5L, 15L, 16L), (List)new .colon.colon((Object)new AbortedTxn(2L, 18L, 35L, 25L), (List)new .colon.colon((Object)new AbortedTxn(3L, 32L, 50L, 40L), (List)Nil$.MODULE$))));
        TransactionIndex transactionIndex = this.index();
        abortedTransactions.foreach((Function1 & Serializable & scala.Serializable)abortedTxn -> {
            transactionIndex.append(abortedTxn);
            return BoxedUnit.UNIT;
        });
        this.index().truncateTo(51L);
        Assert.assertEquals((Object)abortedTransactions, (Object)this.index().collectAbortedTxns(0L, 100L).abortedTransactions());
        this.index().truncateTo(50L);
        Assert.assertEquals((Object)abortedTransactions.take(3), (Object)this.index().collectAbortedTxns(0L, 100L).abortedTransactions());
        this.index().reset();
        Assert.assertEquals((Object)List$.MODULE$.empty(), (Object)this.index().collectAbortedTxns(0L, 100L).abortedTransactions());
    }

    @Test
    public void testAbortedTxnSerde() {
        long pid = 983493L;
        long firstOffset = 137L;
        long lastOffset = 299L;
        long lastStableOffset = 200L;
        AbortedTxn abortedTxn = new AbortedTxn(pid, firstOffset, lastOffset, lastStableOffset);
        Assert.assertEquals((long)AbortedTxn$.MODULE$.CurrentVersion(), (long)abortedTxn.version());
        Assert.assertEquals((long)pid, (long)abortedTxn.producerId());
        Assert.assertEquals((long)firstOffset, (long)abortedTxn.firstOffset());
        Assert.assertEquals((long)lastOffset, (long)abortedTxn.lastOffset());
        Assert.assertEquals((long)lastStableOffset, (long)abortedTxn.lastStableOffset());
    }

    @Test
    public void testRenameIndex() {
        File renamed = TestUtils$.MODULE$.tempFile();
        this.index().append(new AbortedTxn(0L, 0L, 10L, 2L));
        this.index().renameTo(renamed);
        this.index().append(new AbortedTxn(1L, 5L, 15L, 16L));
        List abortedTxns = this.index().collectAbortedTxns(0L, 100L).abortedTransactions();
        Assert.assertEquals((long)2L, (long)abortedTxns.size());
        Assert.assertEquals((long)0L, (long)((AbortedTxn)abortedTxns.apply(0)).firstOffset());
        Assert.assertEquals((long)5L, (long)((AbortedTxn)abortedTxns.apply(1)).firstOffset());
    }

    public TransactionIndexTest() {
        this.offset = 0L;
    }
}

