/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.cluster.BrokerEndPoint;
import kafka.log.LogAppendInfo;
import kafka.message.CompressionCodec;
import kafka.message.NoCompressionCodec$;
import kafka.server.AbstractFetcherThread;
import kafka.server.AbstractFetcherThread$;
import kafka.server.AbstractFetcherThreadTest$MockFetcherThread$;
import kafka.server.FailedPartitions;
import kafka.server.FetcherMetrics$;
import kafka.server.Fetching$;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.Truncating$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.UnknownLeaderEpochException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordConversionStats;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0011=a\u0001B/_\u0001\rDQA\u001b\u0001\u0005\u0002-DqA\u001c\u0001C\u0002\u0013%q\u000e\u0003\u0004|\u0001\u0001\u0006I\u0001\u001d\u0005\by\u0002\u0011\r\u0011\"\u0003p\u0011\u0019i\b\u0001)A\u0005a\"9a\u0010\u0001b\u0001\n\u0013y\b\u0002CA\u0004\u0001\u0001\u0006I!!\u0001\t\u000f\u0005%\u0001\u0001\"\u0001\u0002\f!9\u0011\u0011\u0005\u0001\u0005\n\u0005\r\u0002bBA$\u0001\u0011%\u0011\u0011\n\u0005\b\u0003w\u0002A\u0011BA?\u0011\u001d\tY\t\u0001C\u0001\u0003\u0017Aq!!&\u0001\t\u0003\tY\u0001C\u0004\u0002\u001a\u0002!\t!a\u0003\t\u000f\u0005u\u0005\u0001\"\u0001\u0002\f!9\u0011\u0011\u0015\u0001\u0005\u0002\u0005-\u0001bBAS\u0001\u0011\u0005\u00111\u0002\u0005\b\u0003S\u0003A\u0011AA\u0006\u0011\u001d\ti\u000b\u0001C\u0001\u0003\u0017Aq!!-\u0001\t\u0003\tY\u0001C\u0004\u00026\u0002!\t!a\u0003\t\u000f\u0005e\u0006\u0001\"\u0001\u0002\f!9\u0011Q\u0018\u0001\u0005\u0002\u0005-\u0001bBAa\u0001\u0011\u0005\u00111\u0002\u0005\b\u0003\u000b\u0004A\u0011AA\u0006\u0011\u001d\tI\r\u0001C\u0001\u0003\u0017Aq!!4\u0001\t\u0003\tY\u0001C\u0004\u0002R\u0002!\t!a\u0003\t\u000f\u0005U\u0007\u0001\"\u0001\u0002\f!9\u0011\u0011\u001c\u0001\u0005\u0002\u0005-\u0001bBAo\u0001\u0011%\u0011q\u001c\u0005\b\u0003K\u0004A\u0011AA\u0006\u0011\u001d\tI\u000f\u0001C\u0001\u0003\u0017Aq!!<\u0001\t\u0003\tY\u0001C\u0004\u0002r\u0002!\t!a\u0003\t\u000f\u0005U\b\u0001\"\u0003\u0002x\u001e9!q\u0006\u0001\t\u0002\tEba\u0002B\u0001\u0001!\u0005!1\u0007\u0005\u0007U\u001a\"\tA!\u000e\u0007\r\t]b\u0005\u0001B\u001d\u0011)\u0011Y\u0004\u000bBA\u0002\u0013\u0005!Q\b\u0005\u000b\u0005\u000bB#\u00111A\u0005\u0002\t\u001d\u0003B\u0003B'Q\t\u0005\t\u0015)\u0003\u0003@!Q\u00111\r\u0015\u0003\u0002\u0004%\tA!\u0004\t\u0015\t=\u0003F!a\u0001\n\u0003\u0011\t\u0006\u0003\u0006\u0003V!\u0012\t\u0011)Q\u0005\u0003KB!Ba\u0016)\u0005\u0003\u0007I\u0011\u0001B-\u0011)\u0011Y\u0006\u000bBA\u0002\u0013\u0005!Q\f\u0005\u000b\u0005CB#\u0011!Q!\n\u0005m\u0003B\u0003B2Q\t\u0005\r\u0011\"\u0001\u0003Z!Q!Q\r\u0015\u0003\u0002\u0004%\tAa\u001a\t\u0015\t-\u0004F!A!B\u0013\tY\u0006\u0003\u0006\u0003n!\u0012\t\u0019!C\u0001\u00053B!Ba\u001c)\u0005\u0003\u0007I\u0011\u0001B9\u0011)\u0011)\b\u000bB\u0001B\u0003&\u00111\f\u0005\u0007U\"\"\tAa\u001e\b\u000f\t\u001de\u0005#\u0001\u0003\n\u001a9!q\u0007\u0014\t\u0002\t-\u0005B\u00026;\t\u0003\u0011i\tC\u0004\u0003\u0010j\"\tA!%\t\u000f\t=%\b\"\u0001\u0003,\"I!q\u0016\u0014\u0012\u0002\u0013\u0005!\u0011\u0017\u0005\n\u0005\u000f4\u0013\u0013!C\u0001\u0005c3aA!\u0001\u0001\u0001\t\r\u0001B\u0003B\u0006\u0001\n\u0015\r\u0011\"\u0001\u0003\u000e!Q!q\u0002!\u0003\u0002\u0003\u0006I!!\u001a\t\u0015\tE\u0001I!b\u0001\n\u0003\u0011i\u0001\u0003\u0006\u0003\u0014\u0001\u0013\t\u0011)A\u0005\u0003KBaA\u001b!\u0005\u0002\tU\u0001\"\u0003B\u000e\u0001\n\u0007I\u0011\u0002B\u000f\u0011!\u0011I\r\u0011Q\u0001\n\t}\u0001\"\u0003Bf\u0001\n\u0007I\u0011\u0002B\u000f\u0011!\u0011i\r\u0011Q\u0001\n\t}\u0001b\u0002Bh\u0001\u0012\u0005!\u0011\u001b\u0005\b\u00057\u0004E\u0011\u0001Bo\u0011\u001d\u0011\u0019\u000f\u0011C\u0001\u0005KDqA!;A\t\u0003\u0011Y\u000fC\u0004\u0003p\u0002#\tE!=\t\u000f\rM\u0001\t\"\u0011\u0004\u0016!911\u0005!\u0005B\r\u0015\u0002bBB\u0017\u0001\u0012\u00053q\u0006\u0005\b\u0007W\u0002E\u0011IB7\u0011\u001d\u0011\u0019\u0007\u0011C!\u0007gBqaa\u001eA\t\u0003\u001aI\bC\u0004\u0004\u0004\u0002#Ia!\"\t\u000f\re\u0006\t\"\u0003\u0004<\"91q\u001a!\u0005B\rE\u0007bBBn\u0001\u0012E3Q\u001c\u0005\b\u0007K\u0004E\u0011IBt\u0011\u001d\u0019)\u0010\u0011C\u0005\u0007oDqaa@A\t#\"\t\u0001C\u0004\u0005\b\u0001#\t\u0006\"\u0003\u00033\u0005\u00137\u000f\u001e:bGR4U\r^2iKJ$\u0006N]3bIR+7\u000f\u001e\u0006\u0003?\u0002\faa]3sm\u0016\u0014(\"A1\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u001a\t\u0003K\"l\u0011A\u001a\u0006\u0002O\u0006)1oY1mC&\u0011\u0011N\u001a\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005a\u0007CA7\u0001\u001b\u0005q\u0016A\u00039beRLG/[8ocU\t\u0001\u000f\u0005\u0002rs6\t!O\u0003\u0002ti\u000611m\\7n_:T!!Y;\u000b\u0005Y<\u0018AB1qC\u000eDWMC\u0001y\u0003\ry'oZ\u0005\u0003uJ\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\u0006qCJ$\u0018\u000e^5p]F\u0002\u0013A\u00039beRLG/[8oe\u0005Y\u0001/\u0019:uSRLwN\u001c\u001a!\u0003A1\u0017-\u001b7fIB\u000b'\u000f^5uS>t7/\u0006\u0002\u0002\u0002A\u0019Q.a\u0001\n\u0007\u0005\u0015aL\u0001\tGC&dW\r\u001a)beRLG/[8og\u0006\tb-Y5mK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002'\rdW-\u00198NKR\u0014\u0018n\u0019*fO&\u001cHO]=\u0015\u0005\u00055\u0001cA3\u0002\u0010%\u0019\u0011\u0011\u00034\u0003\tUs\u0017\u000e\u001e\u0015\u0004\u0011\u0005U\u0001\u0003BA\f\u0003;i!!!\u0007\u000b\u0007\u0005mq/A\u0003kk:LG/\u0003\u0003\u0002 \u0005e!A\u0002\"fM>\u0014X-A\bbY2lU\r\u001e:jGNt\u0015-\\3t+\t\t)\u0003\u0005\u0004\u0002(\u00055\u0012\u0011G\u0007\u0003\u0003SQ1!a\u000bg\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003_\tICA\u0002TKR\u0004B!a\r\u0002B9!\u0011QGA\u001f!\r\t9DZ\u0007\u0003\u0003sQ1!a\u000fc\u0003\u0019a$o\\8u}%\u0019\u0011q\b4\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019%!\u0012\u0003\rM#(/\u001b8h\u0015\r\tyDZ\u0001\b[.\u0014\u0015\r^2i)!\tY%a\u0016\u0002b\u0005-\u0004\u0003BA'\u0003'j!!a\u0014\u000b\u0007\u0005E#/\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0003+\nyEA\u0006SK\u000e|'\u000f\u001a\"bi\u000eD\u0007bBA-\u0015\u0001\u0007\u00111L\u0001\u000bE\u0006\u001cXm\u00144gg\u0016$\bcA3\u0002^%\u0019\u0011q\f4\u0003\t1{gn\u001a\u0005\b\u0003GR\u0001\u0019AA3\u0003-aW-\u00193fe\u0016\u0003xn\u00195\u0011\u0007\u0015\f9'C\u0002\u0002j\u0019\u00141!\u00138u\u0011\u001d\tiG\u0003a\u0001\u0003_\nqA]3d_J$7\u000fE\u0003f\u0003c\n)(C\u0002\u0002t\u0019\u0014!\u0002\u0010:fa\u0016\fG/\u001a3?!\u0011\ti%a\u001e\n\t\u0005e\u0014q\n\u0002\r'&l\u0007\u000f\\3SK\u000e|'\u000fZ\u0001\u000f_\u001a47/\u001a;B]\u0012,\u0005o\\2i)\u0019\ty(!\"\u0002\nB\u0019Q.!!\n\u0007\u0005\reL\u0001\bPM\u001a\u001cX\r^!oI\u0016\u0003xn\u00195\t\u000f\u0005\u001d5\u00021\u0001\u0002\\\u0005Ya-\u001a;dQ>3gm]3u\u0011\u001d\t\u0019g\u0003a\u0001\u0003K\nA\u0004^3ti6+GO]5dgJ+Wn\u001c<fI>s7\u000b[;uI><h\u000eK\u0002\r\u0003\u001f\u0003B!a\u0006\u0002\u0012&!\u00111SA\r\u0005\u0011!Vm\u001d;\u0002GQ,7\u000f^\"p]N,X.\u001a:MC\u001e\u0014V-\\8wK\u0012<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]\"\u001aQ\"a$\u0002\u001fQ,7\u000f^*j[BdWMR3uG\"D3ADAH\u0003Q!Xm\u001d;GK:\u001cW\r\u001a+sk:\u001c\u0017\r^5p]\"\u001aq\"a$\u0002\u001fQ,7\u000f\u001e$f]\u000e,GMR3uG\"D3\u0001EAH\u0003\t\"Xm\u001d;V].twn\u001e8MK\u0006$WM]#q_\u000eD\u0017J\u001c+sk:\u001c\u0017\r^5p]\"\u001a\u0011#a$\u0002GQ,7\u000f^+oW:|wO\u001c'fC\u0012,'/\u00129pG\"<\u0006.\u001b7f\r\u0016$8\r[5oO\"\u001a!#a$\u0002\u001dQ,7\u000f\u001e+sk:\u001c\u0017\r^5p]\"\u001a1#a$\u0002wQ,7\u000f\u001e+sk:\u001c\u0017\r^3U_\"Kw\r[,bi\u0016\u0014X.\u0019:l\u0013\u001adU-\u00193fe\u0016\u0003xn\u00195SKF,Xm\u001d;O_R\u001cV\u000f\u001d9peR,G\rK\u0002\u0015\u0003\u001f\u000b\u0001\b^3tiR\u0013XO\\2bi\u0016$v\u000eS5hQ^\u000bG/\u001a:nCJ\\\u0017J\u001a'fC\u0012,'/\u00129pG\"LeNZ8O_R\fe/Y5mC\ndW\rK\u0002\u0016\u0003\u001f\u000b\u0011\u0007^3tiR\u0013XO\\2bi\u0016$v\u000eS5hQ^\u000bG/\u001a:nCJ\\G)\u001e:j]\u001e\u0014V-\\8wKB\u000b'\u000f^5uS>t7\u000fK\u0002\u0017\u0003\u001f\u000bA\u0005^3tiR\u0013XO\\2bi&|gnU6jaB,G-\u00134O_\u0016\u0003xn\u00195DQ\u0006tw-\u001a\u0015\u0004/\u0005=\u0015a\b;fgR4u\u000e\u001c7po\u0016\u0014h)\u001a;dQ>+Ho\u00144SC:<W\rS5hQ\"\u001a\u0001$a$\u0002IQ,7\u000f\u001e$f]\u000e,Gm\u00144gg\u0016$(+Z:fi\u00063G/\u001a:PkR|eMU1oO\u0016D3!GAH\u0003y!Xm\u001d;G_2dwn^3s\r\u0016$8\r[(vi>3'+\u00198hK2{w\u000fK\u0002\u001b\u0003\u001f\u000b1\u0007^3tiJ+GO]=BMR,'/\u00168l]><h\u000eT3bI\u0016\u0014X\t]8dQ&sG*\u0019;fgR|eMZ:fi\u001a+Go\u00195)\u0007m\ty)\u0001\nuKN$8i\u001c:skB$X*Z:tC\u001e,\u0007f\u0001\u000f\u0002\u0010\u00061D/Z:u\u0019\u0016\fG-\u001a:Fa>\u001c\u0007n\u00115b]\u001e,G)\u001e:j]\u001e4UM\\2fI\u001a+Go\u00195Fa>\u001c\u0007n\u001d$s_6dU-\u00193fe\"\u001aQ$a$\u0002uQ,7\u000f\u001e'fC\u0012,'/\u00129pG\"\u001c\u0005.\u00198hK\u0012+(/\u001b8h'V\u001c7-Z:tMVdg)\u001a;dQ\u0016\u0003xn\u00195t\rJ|W\u000eT3bI\u0016\u0014\bf\u0001\u0010\u0002\u0010\u0006\u0001D/Z:u\u0019\u0016\fG-\u001a:Fa>\u001c\u0007n\u00115b]\u001e,G)\u001e:j]\u001e4U\r^2i\u000bB|7\r[:Ge>lG*Z1eKJ$B!!\u0004\u0002b\"9\u00111]\u0010A\u0002\u0005\u0015\u0014a\u00057fC\u0012,'/\u00129pG\"|e\u000eT3bI\u0016\u0014\u0018a\r;fgR$&/\u001e8dCR,Gk\\#q_\u000eDWI\u001c3PM\u001a\u001cX\r^:EkJLgn\u001a*f[>4X\rU1si&$\u0018n\u001c8tQ\r\u0001\u0013qR\u0001Pi\u0016\u001cH\u000f\u0016:v]\u000e\fG/[8o)\"\u0014xn^:Fq\u000e,\u0007\u000f^5p]&3G*Z1eKJ\u0014V\r^;s]N\u0004\u0016M\u001d;ji&|gn\u001d(piJ+\u0017/^3ti\u0016$\u0017J\u001c$fi\u000eDW\t]8dQND3!IAH\u0003a\"Xm\u001d;GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a%b]\u0012d\u0017N\\4QCJ$\u0018\u000e^5p]\u001a\u000b\u0017\u000e\\;sK\u0012+(/\u001b8h\u0003B\u0004XM\u001c3j]\u001eD3AIAH\u0003e\"Xm\u001d;GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a%b]\u0012d\u0017N\\4QCJ$\u0018\u000e^5p]\u001a\u000b\u0017\u000e\\;sK\u0012+(/\u001b8h)J,hnY1uS>t\u0007fA\u0012\u0002\u0010\u0006Yc/\u001a:jMf4U\r^2iKJ$\u0006N]3bI\"\u000bg\u000e\u001a7j]\u001e\u0004\u0016M\u001d;ji&|gNR1jYV\u0014X\r\u0006\u0003\u0002\u000e\u0005e\bbBA~I\u0001\u0007\u0011Q`\u0001\bM\u0016$8\r[3s!\r\ty\u0010Q\u0007\u0002\u0001\t\tRj\\2l\r\u0016$8\r[3s)\"\u0014X-\u00193\u0014\u0007\u0001\u0013)\u0001E\u0002n\u0005\u000fI1A!\u0003_\u0005U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\f\u0011B]3qY&\u001c\u0017-\u00133\u0016\u0005\u0005\u0015\u0014A\u0003:fa2L7-Y%eA\u0005AA.Z1eKJLE-A\u0005mK\u0006$WM]%eAQ1\u0011Q B\f\u00053A\u0011Ba\u0003F!\u0003\u0005\r!!\u001a\t\u0013\tEQ\t%AA\u0002\u0005\u0015\u0014A\u0006:fa2L7-\u0019)beRLG/[8o'R\fG/Z:\u0016\u0005\t}\u0001c\u0002B\u0011\u0005O\u0001(1F\u0007\u0003\u0005GQAA!\n\u0002*\u00059Q.\u001e;bE2,\u0017\u0002\u0002B\u0015\u0005G\u00111!T1q!\r\u0011i\u0003\u000b\b\u0004\u0003\u007f,\u0013!E'pG.4U\r^2iKJ$\u0006N]3bIB\u0019\u0011q \u0014\u0014\u0005\u0019\"GC\u0001B\u0019\u00059\u0001\u0016M\u001d;ji&|gn\u0015;bi\u0016\u001c\"\u0001\u000b3\u0002\u00071|w-\u0006\u0002\u0003@A1!\u0011\u0005B!\u0003\u0017JAAa\u0011\u0003$\t1!)\u001e4gKJ\fq\u0001\\8h?\u0012*\u0017\u000f\u0006\u0003\u0002\u000e\t%\u0003\"\u0003B&U\u0005\u0005\t\u0019\u0001B \u0003\rAH%M\u0001\u0005Y><\u0007%A\bmK\u0006$WM]#q_\u000eDw\fJ3r)\u0011\tiAa\u0015\t\u0013\t-S&!AA\u0002\u0005\u0015\u0014\u0001\u00047fC\u0012,'/\u00129pG\"\u0004\u0013A\u00047pON#\u0018M\u001d;PM\u001a\u001cX\r^\u000b\u0003\u00037\n!\u0003\\8h'R\f'\u000f^(gMN,Go\u0018\u0013fcR!\u0011Q\u0002B0\u0011%\u0011Y\u0005MA\u0001\u0002\u0004\tY&A\bm_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;!\u00031awnZ#oI>3gm]3u\u0003AawnZ#oI>3gm]3u?\u0012*\u0017\u000f\u0006\u0003\u0002\u000e\t%\u0004\"\u0003B&g\u0005\u0005\t\u0019AA.\u00035awnZ#oI>3gm]3uA\u0005i\u0001.[4i/\u0006$XM]7be.\f\u0011\u0003[5hQ^\u000bG/\u001a:nCJ\\w\fJ3r)\u0011\tiAa\u001d\t\u0013\t-c'!AA\u0002\u0005m\u0013A\u00045jO\"<\u0016\r^3s[\u0006\u00148\u000e\t\u000b\r\u0005s\u0012iHa \u0003\u0002\n\r%Q\u0011\t\u0004\u0005wBS\"\u0001\u0014\t\u000f\tm\u0002\b1\u0001\u0003@!9\u00111\r\u001dA\u0002\u0005\u0015\u0004b\u0002B,q\u0001\u0007\u00111\f\u0005\b\u0005GB\u0004\u0019AA.\u0011\u001d\u0011i\u0007\u000fa\u0001\u00037\na\u0002U1si&$\u0018n\u001c8Ti\u0006$X\rE\u0002\u0003|i\u001a\"A\u000f3\u0015\u0005\t%\u0015!B1qa2LH\u0003\u0003B=\u0005'\u00139K!+\t\u000f\tmB\b1\u0001\u0003\u0016B1!q\u0013BQ\u0003\u0017rAA!'\u0003\u001e:!\u0011q\u0007BN\u0013\u00059\u0017b\u0001BPM\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002BR\u0005K\u00131aU3r\u0015\r\u0011yJ\u001a\u0005\b\u0003Gb\u0004\u0019AA3\u0011\u001d\u0011i\u0007\u0010a\u0001\u00037\"BA!\u001f\u0003.\"9\u00111M\u001fA\u0002\u0005\u0015\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00034*\"\u0011Q\rB[W\t\u00119\f\u0005\u0003\u0003:\n\rWB\u0001B^\u0015\u0011\u0011iLa0\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BaM\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0015'1\u0018\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'A\fsKBd\u0017nY1QCJ$\u0018\u000e^5p]N#\u0018\r^3tA\u0005)B.Z1eKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\u001c\u0018A\u00067fC\u0012,'\u000fU1si&$\u0018n\u001c8Ti\u0006$Xm\u001d\u0011\u0002\u001dM,G\u000fT3bI\u0016\u00148\u000b^1uKR1\u0011Q\u0002Bj\u0005/DaA!6K\u0001\u0004\u0001\u0018A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u00053T\u0005\u0019\u0001B\u0016\u0003\u0015\u0019H/\u0019;f\u0003=\u0019X\r\u001e*fa2L7-Y*uCR,GCBA\u0007\u0005?\u0014\t\u000f\u0003\u0004\u0003V.\u0003\r\u0001\u001d\u0005\b\u00053\\\u0005\u0019\u0001B\u0016\u0003U\u0011X\r\u001d7jG\u0006\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016$BAa\u000b\u0003h\"1!Q\u001b'A\u0002A\fA\u0003\\3bI\u0016\u0014\b+\u0019:uSRLwN\\*uCR,G\u0003\u0002B\u0016\u0005[DaA!6N\u0001\u0004\u0001\u0018\u0001\u00069s_\u000e,7o\u001d)beRLG/[8o\t\u0006$\u0018\r\u0006\u0005\u0003t\u000e\r1QAB\u0004!\u0015)'Q\u001fB}\u0013\r\u00119P\u001a\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\tm(q`\u0007\u0003\u0005{T1Aa\u000fa\u0013\u0011\u0019\tA!@\u0003\u001b1{w-\u00119qK:$\u0017J\u001c4p\u0011\u0019\u0011)N\u0014a\u0001a\"9\u0011q\u0011(A\u0002\u0005m\u0003bBB\u0005\u001d\u0002\u000711B\u0001\u000ea\u0006\u0014H/\u001b;j_:$\u0015\r^1\u0011\t\r51qB\u0007\u0002\u0001&!1\u0011\u0003B\u0004\u0005%1U\r^2i\t\u0006$\u0018-\u0001\u0005ueVt7-\u0019;f)\u0019\tiaa\u0006\u0004\u001a!1!Q[(A\u0002ADqaa\u0007P\u0001\u0004\u0019i\"A\bueVt7-\u0019;j_:\u001cF/\u0019;f!\ri7qD\u0005\u0004\u0007Cq&!F(gMN,G\u000f\u0016:v]\u000e\fG/[8o'R\fG/Z\u0001\u0018iJ,hnY1uK\u001a+H\u000e\\=B]\u0012\u001cF/\u0019:u\u0003R$b!!\u0004\u0004(\r%\u0002B\u0002Bk!\u0002\u0007\u0001\u000fC\u0004\u0004,A\u0003\r!a\u0017\u0002\r=4gm]3u\u0003)\u0011W/\u001b7e\r\u0016$8\r\u001b\u000b\u0005\u0007c\u0019i\u0006\u0005\u0004\u00044\r\u00053q\t\b\u0005\u0007k\u0019iD\u0004\u0003\u00048\rmb\u0002BA\u001c\u0007sI\u0011!Y\u0005\u0003?\u0002L1aa\u0010_\u0003U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012LAaa\u0011\u0004F\t!\"+Z:vYR<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]NT1aa\u0010_!\u0015)'Q_B%!\u0011\u0019Yea\u0016\u000f\t\r531K\u0007\u0003\u0007\u001fR1a!\u0015s\u0003!\u0011X-];fgR\u001c\u0018\u0002BB+\u0007\u001f\nABR3uG\"\u0014V-];fgRLAa!\u0017\u0004\\\t9!)^5mI\u0016\u0014(\u0002BB+\u0007\u001fBqaa\u0018R\u0001\u0004\u0019\t'\u0001\u0007qCJ$\u0018\u000e^5p]6\u000b\u0007\u000fE\u0004\u0002(\r\r\u0004o!\u001a\n\t\t%\u0012\u0011\u0006\t\u0004[\u000e\u001d\u0014bAB5=\n\u0019\u0002+\u0019:uSRLwN\u001c$fi\u000eD7\u000b^1uK\u0006YA.\u0019;fgR,\u0005o\\2i)\u0011\u0019yg!\u001d\u0011\u000b\u0015\u0014)0!\u001a\t\r\tU'\u000b1\u0001q)\u0011\tYf!\u001e\t\r\tU7\u000b1\u0001q\u0003E)g\u000eZ(gMN,GOR8s\u000bB|7\r\u001b\u000b\u0007\u0007w\u001aiha \u0011\u000b\u0015\u0014)0a \t\r\tUG\u000b1\u0001q\u0011\u001d\u0019\t\t\u0016a\u0001\u0003K\nQ!\u001a9pG\"\f\u0001d\u00195fG.,\u0005\u0010]3di\u0016$G*Z1eKJ,\u0005o\\2i)\u0019\u00199i!&\u00046B)QM!>\u0004\nB!11RBI\u001b\t\u0019iIC\u0002\u0004\u0010J\f\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0007'\u001biI\u0001\u0004FeJ|'o\u001d\u0005\b\u0007/+\u0006\u0019ABM\u0003A)\u0007\u0010]3di\u0016$W\t]8dQ>\u0003H\u000f\u0005\u0004\u0004\u001c\u000e\u00156\u0011V\u0007\u0003\u0007;SAaa(\u0004\"\u0006!Q\u000f^5m\u0015\t\u0019\u0019+\u0001\u0003kCZ\f\u0017\u0002BBT\u0007;\u0013\u0001b\u00149uS>t\u0017\r\u001c\t\u0005\u0007W\u001b\t,\u0004\u0002\u0004.*!1qVBQ\u0003\u0011a\u0017M\\4\n\t\rM6Q\u0016\u0002\b\u0013:$XmZ3s\u0011\u001d\u00199,\u0016a\u0001\u0005W\ta\u0002]1si&$\u0018n\u001c8Ti\u0006$X-A\fm_>\\W\u000f]#oI>3gm]3u\r>\u0014X\t]8dQR11QXBb\u0007\u001b\u0004Ba!\u0014\u0004@&!1\u0011YB(\u00059)\u0005o\\2i\u000b:$wJ\u001a4tKRDqa!2W\u0001\u0004\u00199-A\u0005fa>\u001c\u0007\u000eR1uCB!1QBBe\u0013\u0011\u0019YMa\u0002\u0003\u0013\u0015\u0003xn\u00195ECR\f\u0007bBB\\-\u0002\u0007!1F\u0001\u0015M\u0016$8\r[#q_\u000eDWI\u001c3PM\u001a\u001cX\r^:\u0015\t\rM7Q\u001b\t\b\u0003O\u0019\u0019\u0007]B_\u0011\u001d\u00199n\u0016a\u0001\u00073\f!\u0002]1si&$\u0018n\u001c8t!\u001d\t9ca\u0019q\u0007\u000f\fq$[:PM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s\u000bB|7\r[*vaB|'\u000f^3e+\t\u0019y\u000eE\u0002f\u0007CL1aa9g\u0005\u001d\u0011un\u001c7fC:\fqBZ3uG\"4%o\\7MK\u0006$WM\u001d\u000b\u0005\u0007S\u001c\t\u0010\u0005\u0004\u0003\u0018\n\u000561\u001e\t\u0007K\u000e5\boa\u0003\n\u0007\r=hM\u0001\u0004UkBdWM\r\u0005\b\u0007gL\u0006\u0019AB%\u000311W\r^2i%\u0016\fX/Z:u\u0003a\u0019\u0007.Z2l\u0019\u0016\fG-\u001a:Fa>\u001c\u0007.\u00118e)\"\u0014xn\u001e\u000b\u0007\u0003\u001b\u0019Ip!@\t\u000f\rm(\f1\u0001\u0002f\u0005iQ\r\u001f9fGR,G-\u00129pG\"Dqaa.[\u0001\u0004\u0011Y#A\u000fgKR\u001c\u0007.R1sY&,7\u000f^(gMN,GO\u0012:p[2+\u0017\rZ3s)\u0019\tY\u0006b\u0001\u0005\u0006!1!Q[.A\u0002ADq!a\u0019\\\u0001\u0004\t)'A\u000egKR\u001c\u0007\u000eT1uKN$xJ\u001a4tKR4%o\\7MK\u0006$WM\u001d\u000b\u0007\u00037\"Y\u0001\"\u0004\t\r\tUG\f1\u0001q\u0011\u001d\t\u0019\u0007\u0018a\u0001\u0003K\u0002")
public class AbstractFetcherThreadTest {
    private volatile AbstractFetcherThreadTest$MockFetcherThread$ MockFetcherThread$module;
    private final TopicPartition kafka$server$AbstractFetcherThreadTest$$partition1 = new TopicPartition("topic1", 0);
    private final TopicPartition partition2 = new TopicPartition("topic2", 0);
    private final FailedPartitions kafka$server$AbstractFetcherThreadTest$$failedPartitions = new FailedPartitions();

    public AbstractFetcherThreadTest$MockFetcherThread$ MockFetcherThread() {
        if (this.MockFetcherThread$module == null) {
            this.MockFetcherThread$lzycompute$1();
        }
        return this.MockFetcherThread$module;
    }

    public TopicPartition kafka$server$AbstractFetcherThreadTest$$partition1() {
        return this.kafka$server$AbstractFetcherThreadTest$$partition1;
    }

    private TopicPartition partition2() {
        return this.partition2;
    }

    public FailedPartitions kafka$server$AbstractFetcherThreadTest$$failedPartitions() {
        return this.kafka$server$AbstractFetcherThreadTest$$failedPartitions;
    }

    @Before
    public void cleanMetricRegistry() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(Metrics.defaultRegistry().allMetrics().keySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)metricName -> {
            AbstractFetcherThreadTest.$anonfun$cleanMetricRegistry$1(metricName);
            return BoxedUnit.UNIT;
        });
    }

    private Set<String> allMetricsNames() {
        return (Set)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).keySet().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getName(), Set$.MODULE$.canBuildFrom());
    }

    private RecordBatch mkBatch(long baseOffset, int leaderEpoch, Seq<SimpleRecord> records) {
        return (RecordBatch)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(MemoryRecords.withRecords((long)baseOffset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(leaderEpoch), (SimpleRecord[])((SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))).batches()).asScala()).head();
    }

    public OffsetAndEpoch kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(long fetchOffset, int leaderEpoch) {
        return new OffsetAndEpoch(fetchOffset, leaderEpoch);
    }

    @Test
    public void testMetricsRemovedOnShutdown() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0))})));
        fetcher.setLeaderState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.start();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Set<String> set = this.allMetricsNames();
            GenTraversable genTraversable = Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{FetcherMetrics$.MODULE$.BytesPerSec(), FetcherMetrics$.MODULE$.RequestsPerSec(), FetcherMetrics$.MODULE$.ConsumerLag()}));
            return !(set != null ? !set.equals((Object)genTraversable) : genTraversable != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed waiting for all fetcher metrics to be registered", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        fetcher.shutdown();
        Assert.assertTrue((boolean)Metrics.defaultRegistry().allMetrics().isEmpty());
    }

    @Test
    public void testConsumerLagRemovedWithPartition() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0))})));
        fetcher.setLeaderState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.doWork();
        Assert.assertTrue((String)"Failed waiting for consumer lag metric", (boolean)this.allMetricsNames().apply((Object)FetcherMetrics$.MODULE$.ConsumerLag()));
        fetcher.removePartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})));
        Assert.assertFalse((boolean)this.allMetricsNames().apply((Object)FetcherMetrics$.MODULE$.ConsumerLag()));
    }

    @Test
    public void testSimpleFetch() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0))})));
        RecordBatch batch = this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{batch}))), 0, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        MockFetcherThread.PartitionState replicaState = fetcher.replicaPartitionState(partition);
        Assert.assertEquals((long)2L, (long)replicaState.logEndOffset());
        Assert.assertEquals((long)2L, (long)replicaState.highWatermark());
    }

    @Test
    public void testFencedTruncation() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0))})));
        RecordBatch batch = this.mkBatch(0L, 1, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{batch}))), 1, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        MockFetcherThread.PartitionState replicaState = fetcher.replicaPartitionState(partition);
        Assert.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assert.assertEquals((long)0L, (long)replicaState.highWatermark());
        Assert.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
        Assert.assertTrue((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(partition));
    }

    @Test
    public void testFencedFetch() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply(0);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0))})));
        RecordBatch batch = this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{batch}))), 0, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((long)2L, (long)replicaState.logEndOffset());
        MockFetcherThread.PartitionState partitionState = fetcher.leaderPartitionState(partition);
        partitionState.leaderEpoch_$eq(partitionState.leaderEpoch() + 1);
        fetcher.doWork();
        Assert.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
        Assert.assertTrue((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(partition));
    }

    @Test
    public void testUnknownLeaderEpochInTruncation() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply(1);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 1))})));
        RecordBatch batch = this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{batch}))), 0, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assert.assertEquals((Object)new Some((Object)Truncating$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.state()));
        MockFetcherThread.PartitionState partitionState = fetcher.leaderPartitionState(partition);
        partitionState.leaderEpoch_$eq(partitionState.leaderEpoch() + 1);
        fetcher.doWork();
        Assert.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Assert.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.state()));
    }

    @Test
    public void testUnknownLeaderEpochWhileFetching() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply(1);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 1))})));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())}))}))), 1, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Assert.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.state()));
        fetcher.leaderPartitionState(partition).leaderEpoch_$eq(0);
        fetcher.doWork();
        Assert.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Assert.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.state()));
        fetcher.leaderPartitionState(partition).leaderEpoch_$eq(1);
        fetcher.doWork();
        Assert.assertEquals((long)2L, (long)replicaState.logEndOffset());
        Assert.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.state()));
    }

    @Test
    public void testTruncation() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 5, 0L);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(3L, 5))})));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 1, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 3, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 5, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, 5, 2L);
        fetcher.setLeaderState(partition, leaderState);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            fetcher.doWork();
            Buffer<RecordBatch> buffer = fetcher.replicaPartitionState(partition).log();
            Buffer<RecordBatch> buffer2 = fetcher.leaderPartitionState(partition).log();
            return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to reconcile leader and follower logs", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertEquals((long)leaderState.logStartOffset(), (long)replicaState.logStartOffset());
        Assert.assertEquals((long)leaderState.logEndOffset(), (long)replicaState.logEndOffset());
        Assert.assertEquals((long)leaderState.highWatermark(), (long)replicaState.highWatermark());
    }

    @Test
    public void testTruncateToHighWatermarkIfLeaderEpochRequestNotSupported() {
        long highWatermark = 2L;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, highWatermark){
            private final long highWatermark$1;

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                Assert.assertEquals((long)this.highWatermark$1, (long)truncationState.offset());
                Assert.assertTrue((boolean)truncationState.truncationCompleted());
                super.truncate(topicPartition, truncationState);
            }

            public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
                throw new UnsupportedOperationException();
            }

            public boolean isOffsetForLeaderEpochSupported() {
                return false;
            }
            {
                this.highWatermark$1 = highWatermark$1;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
            }
        };
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 5, highWatermark);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(highWatermark, 5))})));
        fetcher.doWork();
        Assert.assertEquals((long)highWatermark, (long)replicaState.logEndOffset());
        Assert.assertEquals((long)highWatermark, (long)((PartitionFetchState)fetcher.fetchState(partition).get()).fetchOffset());
        Assert.assertTrue((boolean)((PartitionFetchState)fetcher.fetchState(partition).get()).isReadyForFetch());
    }

    @Test
    public void testTruncateToHighWatermarkIfLeaderEpochInfoNotAvailable() {
        long highWatermark = 2L;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, highWatermark){
            private final long highWatermark$2;

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                Assert.assertEquals((long)this.highWatermark$2, (long)truncationState.offset());
                Assert.assertTrue((boolean)truncationState.truncationCompleted());
                super.truncate(topicPartition, truncationState);
            }

            public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
                throw new UnsupportedOperationException();
            }

            public Option<Object> latestEpoch(TopicPartition topicPartition) {
                return None$.MODULE$;
            }
            {
                this.highWatermark$2 = highWatermark$2;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
            }
        };
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 5, highWatermark);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(highWatermark, 5))})));
        fetcher.doWork();
        Assert.assertEquals((long)highWatermark, (long)replicaState.logEndOffset());
        Assert.assertEquals((long)highWatermark, (long)((PartitionFetchState)fetcher.fetchState(partition).get()).fetchOffset());
        Assert.assertTrue((boolean)((PartitionFetchState)fetcher.fetchState(partition).get()).isReadyForFetch());
    }

    @Test
    public void testTruncateToHighWatermarkDuringRemovePartitions() {
        long highWatermark = 2L;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, partition){
            private final TopicPartition partition$2;

            public void truncateToHighWatermark(Set<TopicPartition> partitions) {
                this.removePartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition$2})));
                super.truncateToHighWatermark(partitions);
            }

            public Option<Object> latestEpoch(TopicPartition topicPartition) {
                return None$.MODULE$;
            }
            {
                this.partition$2 = partition$2;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
            }
        };
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 5, highWatermark);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(highWatermark, 5))})));
        fetcher.doWork();
        Assert.assertEquals((long)((RecordBatch)replicaLog.last()).nextOffset(), (long)replicaState.logEndOffset());
        Assert.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
    }

    @Test
    public void testTruncationSkippedIfNoEpochChange() {
        TopicPartition partition = new TopicPartition("topic", 0);
        IntRef truncations = IntRef.create((int)0);
        MockFetcherThread fetcher = new MockFetcherThread(this, truncations){
            private final IntRef truncations$1;

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                ++this.truncations$1.elem;
                super.truncate(topicPartition, truncationState);
            }
            {
                this.truncations$1 = truncations$1;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
            }
        };
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply(5);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 5))})));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 1, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 3, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 5, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, 5, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Assert.assertEquals((long)1L, (long)truncations.elem);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(3L, 5))})));
        fetcher.doWork();
        Assert.assertEquals((long)1L, (long)truncations.elem);
        Assert.assertEquals((long)2L, (long)replicaState.logEndOffset());
    }

    @Test
    public void testFollowerFetchOutOfRangeHigh() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 4, 0L);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(3L, 4))})));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, 4, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((long)3L, (long)replicaState.logEndOffset());
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.state()));
        leaderState.log().clear();
        leaderState.logEndOffset_$eq(0L);
        leaderState.logStartOffset_$eq(0L);
        leaderState.highWatermark_$eq(0L);
        fetcher.doWork();
        Assert.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assert.assertEquals((long)0L, (long)replicaState.logStartOffset());
        Assert.assertEquals((long)0L, (long)replicaState.highWatermark());
    }

    @Test
    public void testFencedOffsetResetAfterOutOfRange() {
        TopicPartition partition = new TopicPartition("topic", 0);
        BooleanRef fetchedEarliestOffset = BooleanRef.create((boolean)false);
        MockFetcherThread fetcher = new MockFetcherThread(this, fetchedEarliestOffset){
            private final BooleanRef fetchedEarliestOffset$1;

            public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
                this.fetchedEarliestOffset$1.elem = true;
                throw new FencedLeaderEpochException(new StringBuilder(16).append("Epoch ").append(leaderEpoch).append(" is fenced").toString());
            }
            {
                this.fetchedEarliestOffset$1 = fetchedEarliestOffset$1;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
            }
        };
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 4, 0L);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 4))})));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, 4, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assert.assertTrue((boolean)fetchedEarliestOffset.elem);
        Assert.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
        Assert.assertTrue((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(partition));
    }

    @Test
    public void testFollowerFetchOutOfRangeLow() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())}))}));
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 0, 0L);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(3L, 0))})));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, 0, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.state()));
        Assert.assertEquals((long)2L, (long)replicaState.logStartOffset());
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)replicaState.log().toList());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            fetcher.doWork();
            Buffer<RecordBatch> buffer = fetcher.replicaPartitionState(partition).log();
            Buffer<RecordBatch> buffer2 = fetcher.leaderPartitionState(partition).log();
            return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to reconcile leader and follower logs", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertEquals((long)leaderState.logStartOffset(), (long)replicaState.logStartOffset());
        Assert.assertEquals((long)leaderState.logEndOffset(), (long)replicaState.logEndOffset());
        Assert.assertEquals((long)leaderState.highWatermark(), (long)replicaState.highWatermark());
    }

    @Test
    public void testRetryAfterUnknownLeaderEpochInLatestOffsetFetch() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this){
            private final AtomicInteger tries;

            private AtomicInteger tries() {
                return this.tries;
            }

            public long fetchLatestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
                if (this.tries().getAndIncrement() == 0) {
                    throw new UnknownLeaderEpochException("Unexpected leader epoch");
                }
                return super.fetchLatestOffsetFromLeader(topicPartition, leaderEpoch);
            }
            {
                this.tries = new AtomicInteger(0);
            }
        };
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())}))}));
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 0, 0L);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(3L, 0))})));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, 0, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.state()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            fetcher.doWork();
            Buffer<RecordBatch> buffer = fetcher.replicaPartitionState(partition).log();
            Buffer<RecordBatch> buffer2 = fetcher.leaderPartitionState(partition).log();
            return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to reconcile leader and follower logs", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertEquals((long)leaderState.logStartOffset(), (long)replicaState.logStartOffset());
        Assert.assertEquals((long)leaderState.logEndOffset(), (long)replicaState.logEndOffset());
        Assert.assertEquals((long)leaderState.highWatermark(), (long)replicaState.highWatermark());
    }

    @Test
    public void testCorruptMessage() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this){
            private boolean fetchedOnce;

            public boolean fetchedOnce() {
                return this.fetchedOnce;
            }

            public void fetchedOnce_$eq(boolean x$1) {
                this.fetchedOnce = x$1;
            }

            /*
             * WARNING - void declaration
             */
            public Seq<Tuple2<TopicPartition, FetchResponse.PartitionData<Records>>> fetchFromLeader(FetchRequest.Builder fetchRequest) {
                void var2_2;
                block0: {
                    Seq<Tuple2<TopicPartition, FetchResponse.PartitionData<Records>>> fetchedData = super.fetchFromLeader(fetchRequest);
                    if (this.fetchedOnce()) break block0;
                    MemoryRecords records = (MemoryRecords)((FetchResponse.PartitionData)((Tuple2)fetchedData.head())._2()).records;
                    ByteBuffer buffer = records.buffer();
                    buffer.putInt(15, buffer.getInt(15) ^ 0x5B7E);
                    buffer.putInt(30, buffer.getInt(30) ^ 0x16C3A);
                    this.fetchedOnce_$eq(true);
                }
                return var2_2;
            }
            {
                this.fetchedOnce = false;
            }
        };
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0))})));
        RecordBatch batch = this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{batch}))), 0, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        fetcher.doWork();
        MockFetcherThread.PartitionState replicaState = fetcher.replicaPartitionState(partition);
        Assert.assertEquals((long)2L, (long)replicaState.logEndOffset());
    }

    @Test
    public void testLeaderEpochChangeDuringFencedFetchEpochsFromLeader() {
        this.testLeaderEpochChangeDuringFetchEpochsFromLeader(1);
    }

    @Test
    public void testLeaderEpochChangeDuringSuccessfulFetchEpochsFromLeader() {
        this.testLeaderEpochChangeDuringFetchEpochsFromLeader(0);
    }

    private void testLeaderEpochChangeDuringFetchEpochsFromLeader(int leaderEpochOnLeader) {
        TopicPartition partition = new TopicPartition("topic", 0);
        int initialLeaderEpochOnFollower = 0;
        int nextLeaderEpochOnFollower = initialLeaderEpochOnFollower + 1;
        MockFetcherThread fetcher = new MockFetcherThread(this, partition, nextLeaderEpochOnFollower){
            private boolean fetchEpochsFromLeaderOnce;
            private final /* synthetic */ AbstractFetcherThreadTest $outer;
            private final TopicPartition partition$5;
            private final int nextLeaderEpochOnFollower$1;

            public boolean fetchEpochsFromLeaderOnce() {
                return this.fetchEpochsFromLeaderOnce;
            }

            public void fetchEpochsFromLeaderOnce_$eq(boolean x$1) {
                this.fetchEpochsFromLeaderOnce = x$1;
            }

            /*
             * WARNING - void declaration
             */
            public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
                void var2_2;
                block0: {
                    Map<TopicPartition, EpochEndOffset> fetchedEpochs = super.fetchEpochEndOffsets(partitions);
                    if (this.fetchEpochsFromLeaderOnce()) break block0;
                    this.removePartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition$5})));
                    this.setReplicaState(this.partition$5, this.$outer.MockFetcherThread().PartitionState().apply(this.nextLeaderEpochOnFollower$1));
                    this.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition$5), (Object)this.$outer.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, this.nextLeaderEpochOnFollower$1))})));
                    this.fetchEpochsFromLeaderOnce_$eq(true);
                }
                return var2_2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$5 = partition$5;
                this.nextLeaderEpochOnFollower$1 = nextLeaderEpochOnFollower$1;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
                this.fetchEpochsFromLeaderOnce = false;
            }
        };
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(initialLeaderEpochOnFollower));
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, initialLeaderEpochOnFollower))})));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, initialLeaderEpochOnFollower, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, leaderEpochOnLeader, 0L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)Truncating$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.state()));
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)nextLeaderEpochOnFollower)), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.currentLeaderEpoch())));
        if (leaderEpochOnLeader < nextLeaderEpochOnFollower) {
            fetcher.setLeaderState(partition, this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, nextLeaderEpochOnFollower, 0L));
        }
        fetcher.doWork();
        Assert.assertEquals(fetcher.leaderPartitionState(partition).log(), fetcher.replicaPartitionState(partition).log());
    }

    @Test
    public void testTruncateToEpochEndOffsetsDuringRemovePartitions() {
        TopicPartition partition = new TopicPartition("topic", 0);
        int leaderEpochOnLeader = 0;
        int initialLeaderEpochOnFollower = 0;
        int nextLeaderEpochOnFollower = initialLeaderEpochOnFollower + 1;
        MockFetcherThread fetcher = new MockFetcherThread(this, partition, nextLeaderEpochOnFollower){
            private final /* synthetic */ AbstractFetcherThreadTest $outer;
            private final TopicPartition partition$6;
            private final int nextLeaderEpochOnFollower$2;

            /*
             * WARNING - void declaration
             */
            public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
                void var2_2;
                Map<TopicPartition, EpochEndOffset> fetchedEpochs = super.fetchEpochEndOffsets(partitions);
                this.removePartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition$6})));
                this.setReplicaState(this.partition$6, this.$outer.MockFetcherThread().PartitionState().apply(this.nextLeaderEpochOnFollower$2));
                return var2_2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$6 = partition$6;
                this.nextLeaderEpochOnFollower$2 = nextLeaderEpochOnFollower$2;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
            }
        };
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(initialLeaderEpochOnFollower));
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, initialLeaderEpochOnFollower))})));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, initialLeaderEpochOnFollower, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, leaderEpochOnLeader, 0L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((Object)None$.MODULE$, (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.state()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.currentLeaderEpoch())));
        fetcher.setLeaderState(partition, this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, nextLeaderEpochOnFollower, 0L));
        fetcher.doWork();
        Assert.assertEquals((Object)ArrayBuffer$.MODULE$.empty(), fetcher.replicaPartitionState(partition).log());
    }

    @Test
    public void testTruncationThrowsExceptionIfLeaderReturnsPartitionsNotRequestedInFetchEpochs() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this){

            public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
                TopicPartition unrequestedTp = new TopicPartition("topic2", 0);
                return super.fetchEpochEndOffsets(partitions).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unrequestedTp), (Object)new EpochEndOffset(0, 0L)));
            }
        };
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0))})));
        fetcher.setLeaderState(partition, this.MockFetcherThread().PartitionState().apply(0));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fetcher.doWork(), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("AbstractFetcherThreadTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 728));
    }

    @Test
    public void testFetcherThreadHandlingPartitionFailureDuringAppending() {
        MockFetcherThread fetcherForAppend = new MockFetcherThread(this){
            private final /* synthetic */ AbstractFetcherThreadTest $outer;

            public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponse.PartitionData<Records> partitionData) {
                TopicPartition topicPartition2 = topicPartition;
                TopicPartition topicPartition3 = this.$outer.kafka$server$AbstractFetcherThreadTest$$partition1();
                if (!(topicPartition2 != null ? !topicPartition2.equals(topicPartition3) : topicPartition3 != null)) {
                    throw new KafkaException();
                }
                return super.processPartitionData(topicPartition, fetchOffset, partitionData);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
            }
        };
        this.verifyFetcherThreadHandlingPartitionFailure(fetcherForAppend);
    }

    @Test
    public void testFetcherThreadHandlingPartitionFailureDuringTruncation() {
        MockFetcherThread fetcherForTruncation = new MockFetcherThread(this){
            private final /* synthetic */ AbstractFetcherThreadTest $outer;

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                TopicPartition topicPartition2 = topicPartition;
                TopicPartition topicPartition3 = this.$outer.kafka$server$AbstractFetcherThreadTest$$partition1();
                if (!(topicPartition2 != null ? !topicPartition2.equals(topicPartition3) : topicPartition3 != null)) {
                    throw new Exception();
                }
                super.truncate(topicPartition, truncationState);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
            }
        };
        this.verifyFetcherThreadHandlingPartitionFailure(fetcherForTruncation);
    }

    private void verifyFetcherThreadHandlingPartitionFailure(MockFetcherThread fetcher) {
        fetcher.setReplicaState(this.kafka$server$AbstractFetcherThreadTest$$partition1(), this.MockFetcherThread().PartitionState().apply(0));
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$AbstractFetcherThreadTest$$partition1()), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0))})));
        fetcher.setLeaderState(this.kafka$server$AbstractFetcherThreadTest$$partition1(), this.MockFetcherThread().PartitionState().apply(0));
        fetcher.setReplicaState(this.partition2(), this.MockFetcherThread().PartitionState().apply(0));
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition2()), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0))})));
        fetcher.setLeaderState(this.partition2(), this.MockFetcherThread().PartitionState().apply(0));
        fetcher.doWork();
        Assert.assertTrue((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(this.kafka$server$AbstractFetcherThreadTest$$partition1()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)fetcher.fetchState(this.kafka$server$AbstractFetcherThreadTest$$partition1()));
        fetcher.doWork();
        Assert.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(this.partition2()).map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.state()));
        Assert.assertFalse((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(this.partition2()));
        fetcher.removePartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.kafka$server$AbstractFetcherThreadTest$$partition1()})));
        this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().removeAll((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.kafka$server$AbstractFetcherThreadTest$$partition1()})));
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$AbstractFetcherThreadTest$$partition1()), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 1))})));
        Assert.assertEquals((Object)new Some((Object)Truncating$.MODULE$), (Object)fetcher.fetchState(this.kafka$server$AbstractFetcherThreadTest$$partition1()).map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.state()));
        Assert.assertFalse((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(this.kafka$server$AbstractFetcherThreadTest$$partition1()));
    }

    private final void MockFetcherThread$lzycompute$1() {
        AbstractFetcherThreadTest abstractFetcherThreadTest = this;
        synchronized (abstractFetcherThreadTest) {
            if (this.MockFetcherThread$module == null) {
                this.MockFetcherThread$module = new AbstractFetcherThreadTest$MockFetcherThread$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$cleanMetricRegistry$1(MetricName metricName) {
        Metrics.defaultRegistry().removeMetric(metricName);
    }

    public class MockFetcherThread
    extends AbstractFetcherThread {
        private final int replicaId;
        private final int leaderId;
        private final scala.collection.mutable.Map<TopicPartition, PartitionState> replicaPartitionStates;
        private final scala.collection.mutable.Map<TopicPartition, PartitionState> leaderPartitionStates;
        public final /* synthetic */ AbstractFetcherThreadTest $outer;

        public int replicaId() {
            return this.replicaId;
        }

        public int leaderId() {
            return this.leaderId;
        }

        private scala.collection.mutable.Map<TopicPartition, PartitionState> replicaPartitionStates() {
            return this.replicaPartitionStates;
        }

        private scala.collection.mutable.Map<TopicPartition, PartitionState> leaderPartitionStates() {
            return this.leaderPartitionStates;
        }

        public void setLeaderState(TopicPartition topicPartition, PartitionState state) {
            this.leaderPartitionStates().put((Object)topicPartition, (Object)state);
        }

        public void setReplicaState(TopicPartition topicPartition, PartitionState state) {
            this.replicaPartitionStates().put((Object)topicPartition, (Object)state);
        }

        public PartitionState replicaPartitionState(TopicPartition topicPartition) {
            return (PartitionState)this.replicaPartitionStates().getOrElse((Object)topicPartition, (Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(18).append("Unknown partition ").append(topicPartition).toString());
            });
        }

        public PartitionState leaderPartitionState(TopicPartition topicPartition) {
            return (PartitionState)this.leaderPartitionStates().getOrElse((Object)topicPartition, (Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(18).append("Unknown partition ").append(topicPartition).toString());
            });
        }

        public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponse.PartitionData<Records> partitionData) {
            PartitionState state = this.replicaPartitionState(topicPartition);
            if (fetchOffset != state.logEndOffset()) {
                throw new RuntimeException(new StringBuilder(69).append("Offset mismatch for partition ").append(topicPartition).append(": ").append("fetched offset = ").append(fetchOffset).append(", log end offset = ").append(state.logEndOffset()).append(".").toString());
            }
            Iterable batches = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((Records)partitionData.records).batches()).asScala();
            LongRef maxTimestamp = LongRef.create((long)-1L);
            LongRef offsetOfMaxTimestamp = LongRef.create((long)-1L);
            LongRef lastOffset = LongRef.create((long)state.logEndOffset());
            batches.foreach((Function1 & Serializable & scala.Serializable)batch -> {
                MockFetcherThread.$anonfun$processPartitionData$1(maxTimestamp, offsetOfMaxTimestamp, state, lastOffset, batch);
                return BoxedUnit.UNIT;
            });
            state.logStartOffset_$eq(partitionData.logStartOffset);
            state.highWatermark_$eq(partitionData.highWatermark);
            return new Some((Object)new LogAppendInfo((Option)new Some((Object)BoxesRunTime.boxToLong((long)fetchOffset)), lastOffset.elem, maxTimestamp.elem, offsetOfMaxTimestamp.elem, Time.SYSTEM.milliseconds(), state.logStartOffset(), RecordConversionStats.EMPTY, (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, batches.size(), partitionData.records.sizeInBytes(), true, BoxesRunTime.unboxToLong((Object)batches.headOption().map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToLong((long)x$18.lastOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L))));
        }

        public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
            PartitionState state = this.replicaPartitionState(topicPartition);
            state.log_$eq((Buffer<RecordBatch>)((Buffer)state.log().takeWhile((Function1 & Serializable & scala.Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)MockFetcherThread.$anonfun$truncate$1(truncationState, batch)))));
            state.logEndOffset_$eq(BoxesRunTime.unboxToLong((Object)state.log().lastOption().map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToLong((long)MockFetcherThread.$anonfun$truncate$2(x$19))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> state.logStartOffset())));
            state.highWatermark_$eq(package$.MODULE$.min(state.highWatermark(), state.logEndOffset()));
        }

        public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
            PartitionState state = this.replicaPartitionState(topicPartition);
            state.log().clear();
            state.logStartOffset_$eq(offset);
            state.logEndOffset_$eq(offset);
            state.highWatermark_$eq(offset);
        }

        public AbstractFetcherThread.ResultWithPartitions<Option<FetchRequest.Builder>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
            scala.collection.mutable.Map fetchData = Map$.MODULE$.empty();
            partitionMap.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                BoxedUnit boxedUnit;
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition partition = (TopicPartition)tuple2._1();
                    PartitionFetchState state = (PartitionFetchState)tuple2._2();
                    if (state.isReadyForFetch()) {
                        PartitionState replicaState = this.replicaPartitionState(partition);
                        boxedUnit = fetchData.put((Object)partition, (Object)new FetchRequest.PartitionData(state.fetchOffset(), replicaState.logStartOffset(), 0x100000, Optional.of(Predef$.MODULE$.int2Integer(state.currentLeaderEpoch()))));
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return boxedUnit2;
            });
            FetchRequest.Builder fetchRequest = FetchRequest.Builder.forReplica((short)ApiKeys.FETCH.latestVersion(), (int)this.replicaId(), (int)0, (int)1, (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(fetchData).asJava()));
            return new AbstractFetcherThread.ResultWithPartitions((Object)new Some((Object)fetchRequest), Set$.MODULE$.empty());
        }

        public Option<Object> latestEpoch(TopicPartition topicPartition) {
            PartitionState state = this.replicaPartitionState(topicPartition);
            return state.log().lastOption().map((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToInteger((int)x$20.partitionLeaderEpoch())).orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)BoxesRunTime.boxToInteger((int)-1)));
        }

        public long logEndOffset(TopicPartition topicPartition) {
            return this.replicaPartitionState(topicPartition).logEndOffset();
        }

        public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
            OffsetsForLeaderEpochRequest.PartitionData epochData = new OffsetsForLeaderEpochRequest.PartitionData(Optional.empty(), epoch);
            EpochEndOffset result = this.lookupEndOffsetForEpoch(epochData, this.replicaPartitionState(topicPartition));
            return result.endOffset() == -1L ? None$.MODULE$ : new Some((Object)new OffsetAndEpoch(result.endOffset(), result.leaderEpoch()));
        }

        private Option<Errors> checkExpectedLeaderEpoch(Optional<Integer> expectedEpochOpt, PartitionState partitionState) {
            Integer expectedEpoch;
            return expectedEpochOpt.isPresent() ? (Predef$.MODULE$.Integer2int(expectedEpoch = expectedEpochOpt.get()) < partitionState.leaderEpoch() ? new Some((Object)Errors.FENCED_LEADER_EPOCH) : (Predef$.MODULE$.Integer2int(expectedEpoch) > partitionState.leaderEpoch() ? new Some((Object)Errors.UNKNOWN_LEADER_EPOCH) : None$.MODULE$)) : None$.MODULE$;
        }

        private EpochEndOffset lookupEndOffsetForEpoch(OffsetsForLeaderEpochRequest.PartitionData epochData, PartitionState partitionState) {
            EpochEndOffset epochEndOffset;
            Object object = new Object();
            try {
                this.checkExpectedLeaderEpoch(epochData.currentLeaderEpoch, partitionState).foreach((Function1 & Serializable & scala.Serializable)error -> {
                    throw new NonLocalReturnControl(object, (Object)new EpochEndOffset(error, -1, -1L));
                });
                IntRef epochLowerBound = IntRef.create((int)-1);
                partitionState.log().foreach((Function1 & Serializable & scala.Serializable)batch -> {
                    MockFetcherThread.$anonfun$lookupEndOffsetForEpoch$2(epochData, object, epochLowerBound, batch);
                    return BoxedUnit.UNIT;
                });
                epochEndOffset = new EpochEndOffset(Errors.NONE, -1, -1L);
            }
            catch (NonLocalReturnControl ex) {
                if (ex.key() == object) {
                    epochEndOffset = (EpochEndOffset)ex.value();
                }
                throw ex;
            }
            return epochEndOffset;
        }

        /*
         * WARNING - void declaration
         */
        public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
            void var2_2;
            scala.collection.mutable.Map endOffsets = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            partitions.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition partition = (TopicPartition)tuple2._1();
                OffsetsForLeaderEpochRequest.PartitionData epochData = (OffsetsForLeaderEpochRequest.PartitionData)tuple2._2();
                PartitionState leaderState = this.leaderPartitionState(partition);
                EpochEndOffset epochEndOffset = this.lookupEndOffsetForEpoch(epochData, leaderState);
                Option option = endOffsets.put((Object)partition, (Object)epochEndOffset);
                return option;
            });
            return var2_2;
        }

        public boolean isOffsetForLeaderEpochSupported() {
            return true;
        }

        public Seq<Tuple2<TopicPartition, FetchResponse.PartitionData<Records>>> fetchFromLeader(FetchRequest.Builder fetchRequest) {
            return ((scala.collection.mutable.MapLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(fetchRequest.fetchData()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2;
                PartitionState leaderState;
                TopicPartition partition;
                Tuple2 tuple22 = x0$1;
                if (tuple22 != null) {
                    Tuple2 tuple23;
                    Tuple2 tuple24;
                    partition = (TopicPartition)tuple22._1();
                    FetchRequest.PartitionData fetchData = (FetchRequest.PartitionData)tuple22._2();
                    leaderState = this.leaderPartitionState(partition);
                    Option<Errors> epochCheckError = this.checkExpectedLeaderEpoch(fetchData.currentLeaderEpoch, leaderState);
                    if (epochCheckError.isDefined()) {
                        tuple24 = new Tuple2(epochCheckError.get(), (Object)MemoryRecords.EMPTY);
                    } else if (fetchData.fetchOffset > leaderState.logEndOffset() || fetchData.fetchOffset < leaderState.logStartOffset()) {
                        tuple24 = new Tuple2((Object)Errors.OFFSET_OUT_OF_RANGE, (Object)MemoryRecords.EMPTY);
                    } else {
                        MemoryRecords memoryRecords;
                        Option option = leaderState.log().find((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)MockFetcherThread.$anonfun$fetchFromLeader$2(fetchData, x$21)));
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            RecordBatch batch = (RecordBatch)some.value();
                            ByteBuffer buffer = ByteBuffer.allocate(batch.sizeInBytes());
                            batch.writeTo(buffer);
                            buffer.flip();
                            memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
                        } else if (None$.MODULE$.equals(option)) {
                            memoryRecords = MemoryRecords.EMPTY;
                        } else {
                            throw new MatchError((Object)option);
                        }
                        MemoryRecords records = memoryRecords;
                        tuple24 = tuple23 = new Tuple2((Object)Errors.NONE, (Object)records);
                    }
                    if (tuple23 == null) {
                        throw new MatchError((Object)tuple23);
                    }
                    Errors error = (Errors)tuple23._1();
                    MemoryRecords records = (MemoryRecords)tuple23._2();
                    tuple2 = new Tuple2((Object)error, (Object)records);
                } else {
                    throw new MatchError((Object)tuple22);
                }
                Tuple2 tuple25 = tuple2;
                Errors error = (Errors)tuple25._1();
                MemoryRecords records = (MemoryRecords)tuple25._2();
                Tuple2 tuple26 = new Tuple2((Object)partition, (Object)new FetchResponse.PartitionData(error, leaderState.highWatermark(), leaderState.highWatermark(), leaderState.logStartOffset(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava(), (BaseRecords)records));
                return tuple26;
            }, Map$.MODULE$.canBuildFrom())).toSeq();
        }

        private void checkLeaderEpochAndThrow(int expectedEpoch, PartitionState partitionState) {
            this.checkExpectedLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(expectedEpoch)), partitionState).foreach((Function1 & Serializable & scala.Serializable)error -> {
                throw error.exception();
            });
        }

        public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
            PartitionState leaderState = this.leaderPartitionState(topicPartition);
            this.checkLeaderEpochAndThrow(leaderEpoch, leaderState);
            return leaderState.logStartOffset();
        }

        public long fetchLatestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
            PartitionState leaderState = this.leaderPartitionState(topicPartition);
            this.checkLeaderEpochAndThrow(leaderEpoch, leaderState);
            return leaderState.logEndOffset();
        }

        public /* synthetic */ AbstractFetcherThreadTest kafka$server$AbstractFetcherThreadTest$MockFetcherThread$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$processPartitionData$1(LongRef maxTimestamp$1, LongRef offsetOfMaxTimestamp$1, PartitionState state$1, LongRef lastOffset$1, RecordBatch batch) {
            batch.ensureValid();
            if (batch.maxTimestamp() > maxTimestamp$1.elem) {
                maxTimestamp$1.elem = batch.maxTimestamp();
                offsetOfMaxTimestamp$1.elem = batch.baseOffset();
            }
            state$1.log().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{batch}));
            state$1.logEndOffset_$eq(batch.nextOffset());
            lastOffset$1.elem = batch.lastOffset();
        }

        public static final /* synthetic */ boolean $anonfun$truncate$1(OffsetTruncationState truncationState$1, RecordBatch batch) {
            return batch.lastOffset() < truncationState$1.offset();
        }

        public static final /* synthetic */ long $anonfun$truncate$2(RecordBatch x$19) {
            return x$19.lastOffset() + 1L;
        }

        public static final /* synthetic */ void $anonfun$lookupEndOffsetForEpoch$2(OffsetsForLeaderEpochRequest.PartitionData epochData$1, Object nonLocalReturnKey1$1, IntRef epochLowerBound$1, RecordBatch batch) {
            if (batch.partitionLeaderEpoch() > epochData$1.leaderEpoch) {
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new EpochEndOffset(Errors.NONE, epochLowerBound$1.elem, batch.baseOffset()));
            }
            epochLowerBound$1.elem = batch.partitionLeaderEpoch();
        }

        public static final /* synthetic */ boolean $anonfun$fetchFromLeader$2(FetchRequest.PartitionData fetchData$2, RecordBatch x$21) {
            return x$21.baseOffset() >= fetchData$2.fetchOffset;
        }

        public MockFetcherThread(AbstractFetcherThreadTest $outer, int replicaId, int leaderId) {
            this.replicaId = replicaId;
            this.leaderId = leaderId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("mock-fetcher", "mock-fetcher", new BrokerEndPoint(leaderId, "localhost", Random$.MODULE$.nextInt()), $outer.kafka$server$AbstractFetcherThreadTest$$failedPartitions(), AbstractFetcherThread$.MODULE$.$lessinit$greater$default$5(), AbstractFetcherThread$.MODULE$.$lessinit$greater$default$6());
            this.replicaPartitionStates = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            this.leaderPartitionStates = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        }

        public class PartitionState {
            private Buffer<RecordBatch> log;
            private int leaderEpoch;
            private long logStartOffset;
            private long logEndOffset;
            private long highWatermark;
            public final /* synthetic */ AbstractFetcherThreadTest$MockFetcherThread$ $outer;

            public Buffer<RecordBatch> log() {
                return this.log;
            }

            public void log_$eq(Buffer<RecordBatch> x$1) {
                this.log = x$1;
            }

            public int leaderEpoch() {
                return this.leaderEpoch;
            }

            public void leaderEpoch_$eq(int x$1) {
                this.leaderEpoch = x$1;
            }

            public long logStartOffset() {
                return this.logStartOffset;
            }

            public void logStartOffset_$eq(long x$1) {
                this.logStartOffset = x$1;
            }

            public long logEndOffset() {
                return this.logEndOffset;
            }

            public void logEndOffset_$eq(long x$1) {
                this.logEndOffset = x$1;
            }

            public long highWatermark() {
                return this.highWatermark;
            }

            public void highWatermark_$eq(long x$1) {
                this.highWatermark = x$1;
            }

            public /* synthetic */ AbstractFetcherThreadTest$MockFetcherThread$ kafka$server$AbstractFetcherThreadTest$MockFetcherThread$PartitionState$$$outer() {
                return this.$outer;
            }

            public PartitionState(AbstractFetcherThreadTest$MockFetcherThread$ $outer, Buffer<RecordBatch> log, int leaderEpoch, long logStartOffset, long logEndOffset, long highWatermark) {
                this.log = log;
                this.leaderEpoch = leaderEpoch;
                this.logStartOffset = logStartOffset;
                this.logEndOffset = logEndOffset;
                this.highWatermark = highWatermark;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }
    }
}

