/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.AbstractServerThread;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor$;
import kafka.network.Processor$ConnectionId$;
import kafka.network.RequestChannel;
import kafka.network.SocketServer$;
import kafka.security.CredentialProvider;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.stats.Total;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\u0011uuA\u00027n\u0011\u0003y\u0017O\u0002\u0004t[\"\u0005q\u000e\u001e\u0005\u0006w\u0006!\t! \u0005\b}\u0006\u0011\r\u0011\"\u0001\u0000\u0011!\t\t\"\u0001Q\u0001\n\u0005\u0005\u0001\u0002CA\n\u0003\t\u0007I\u0011A@\t\u0011\u0005U\u0011\u0001)A\u0005\u0003\u0003A\u0001\"a\u0006\u0002\u0005\u0004%\ta \u0005\t\u00033\t\u0001\u0015!\u0003\u0002\u0002!I\u00111D\u0001C\u0002\u0013\u0005\u0011Q\u0004\u0005\t\u0003K\t\u0001\u0015!\u0003\u0002 !I\u0011qE\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0006\u0004\u0007g6\u0004q.a\u0010\t\u0015\u0005MCB!b\u0001\n\u0003\ti\u0002\u0003\u0006\u0002V1\u0011\t\u0011)A\u0005\u0003?A!\"a\u0016\r\u0005\u0003\u0005\u000b\u0011BA-\u0011)\t\u0019\b\u0004B\u0001B\u0003%\u0011q\u0004\u0005\u000b\u0003kb!\u0011!Q\u0001\n\u0005]\u0004BCA?\u0019\t\u0005\t\u0015!\u0003\u0002\u0000!Q\u0011Q\u0011\u0007\u0003\u0002\u0003\u0006I!a\"\t\u0015\u00055EB!A!\u0002\u0013\ty\u0002\u0003\u0006\u0002\u00102\u0011\t\u0011)A\u0005\u0003#C!\"a'\r\u0005\u0003\u0005\u000b\u0011BAO\u0011)\ti\u000b\u0004B\u0001B\u0003%\u0011q\u0016\u0005\u000b\u0003\u001bb!\u0011!Q\u0001\n\u0005m\u0006BCAc\u0019\t\u0005\t\u0015!\u0003\u0002H\"Q\u0011\u0011\u001b\u0007\u0003\u0002\u0003\u0006I!a5\t\u0015\u0005}GB!A!\u0002\u0013\t\t\u000f\u0003\u0006\u0002h2\u0011\t\u0011)A\u0005\u0003?Aaa\u001f\u0007\u0005\u0002\u0005%xa\u0002B\u0006\u0019!%!Q\u0002\u0004\b\u0005#a\u0001\u0012\u0002B\n\u0011\u0019Yx\u0004\"\u0001\u0003\u001c!9!QD\u0010\u0005\u0002\t}\u0001\"\u0003Bb?\u0005\u0005I\u0011\u0011Bc\u0011%\u0011\tnHA\u0001\n\u0003\u0013\u0019NB\u0004\u0003\u00121\u0001UN!\u000b\t\u0015\tEBE!f\u0001\n\u0003\u0011\u0019\u0004\u0003\u0006\u0003J\u0011\u0012\t\u0012)A\u0005\u0005kA!Ba\u0013%\u0005+\u0007I\u0011AA\u000f\u0011)\u0011i\u0005\nB\tB\u0003%\u0011q\u0004\u0005\u000b\u0005\u001f\"#Q3A\u0005\u0002\tM\u0002B\u0003B)I\tE\t\u0015!\u0003\u00036!Q!1\u000b\u0013\u0003\u0016\u0004%\t!!\b\t\u0015\tUCE!E!\u0002\u0013\ty\u0002\u0003\u0006\u0003X\u0011\u0012)\u001a!C\u0001\u0003;A!B!\u0017%\u0005#\u0005\u000b\u0011BA\u0010\u0011\u0019YH\u0005\"\u0001\u0003\\!9!q\r\u0013\u0005B\t%\u0004\"\u0003B6I\u0005\u0005I\u0011\u0001B7\u0011%\u0011I\bJI\u0001\n\u0003\u0011Y\bC\u0005\u0003\u0000\u0011\n\n\u0011\"\u0001\u0002*!I!\u0011\u0011\u0013\u0012\u0002\u0013\u0005!1\u0010\u0005\n\u0005\u0007#\u0013\u0013!C\u0001\u0003SA\u0011B!\"%#\u0003%\t!!\u000b\t\u0011\t\u001dE%!A\u0005B}D\u0011B!#%\u0003\u0003%\t!!\b\t\u0013\t-E%!A\u0005\u0002\t5\u0005\"\u0003BMI\u0005\u0005I\u0011\tBN\u0011%\u0011I\u000bJA\u0001\n\u0003\u0011Y\u000bC\u0005\u00036\u0012\n\t\u0011\"\u0011\u00038\"I!\u0011\u0018\u0013\u0002\u0002\u0013\u0005#1\u0018\u0005\n\u0005Cd!\u0019!C\u0005\u0005GD\u0001b!\u0002\rA\u0003%!Q\u001d\u0005\n\u0007\u000fa!\u0019!C\u0005\u0007\u0013A\u0001b!\n\rA\u0003%11\u0002\u0005\n\u0007Oa!\u0019!C\u0005\u0007SA\u0001b!\r\rA\u0003%11\u0006\u0005\u000b\u0007ga!\u0019!C\u0001_\u000eU\u0002\u0002CB\u001f\u0019\u0001\u0006Iaa\u000e\t\u0013\r}BB1A\u0005\u0002\r\u0005\u0003\u0002CB(\u0019\u0001\u0006Iaa\u0011\t\u0013\rECB1A\u0005\n\rM\u0003\u0002CB/\u0019\u0001\u0006Ia!\u0016\t\u0013\r}CB1A\u0005\n\r\u0005\u0004\u0002CB5\u0019\u0001\u0006Iaa\u0019\t\u0011\r-D\u0002\"\u0005n\u0007[B\u0011b!\u001f\r\u0001\u0004%I!!\b\t\u0013\rmD\u00021A\u0005\n\ru\u0004\u0002CBD\u0019\u0001\u0006K!a\b\t\u000f\r%E\u0002\"\u0011\u0004\f\"91Q\u0012\u0007\u0005\n\r=\u0005bBBV\u0019\u0011%1Q\u0016\u0005\b\u0007ocA\u0011BBF\u0011!\u0019I\f\u0004C\t[\u000em\u0006bBBf\u0019\u0011%1Q\u001a\u0005\b\u0007WdA\u0011BBF\u0011\u001d\u0019i\u000f\u0004C\u0005\u0007\u0017Cqaa<\r\t\u0013\u0019Y\tC\u0004\u0004r2!Iaa=\t\u000f\r]H\u0002\"\u0003\u0004\f\"91\u0011 \u0007\u0005\n\r-\u0005bBB~\u0019\u0011%1Q \u0005\b\t\u0007aA\u0011\u0001C\u0003\u0011\u001d!I\u0003\u0004C\u0005\u0007\u0017Cq\u0001b\u000b\r\t\u0013\u0019Y\t\u0003\u0005\u0005\u00021!\t\"\u001cC\u0017\u0011!!y\u0004\u0004C\u0001[\u0012\u0005\u0003b\u0002C#\u0019\u0011%Aq\t\u0005\t\t\u0013bA\u0011A7\u0002\u001e!AA1\n\u0007\u0005\u00025\fi\u0002\u0003\u0005\u0005N1!\t!\u001cC(\u0011\u001d!Y\u0006\u0004C\u0005\t;Bq\u0001b\"\r\t\u0013!I\t\u0003\u0005\u0005\u000e2!\t!\u001cCH\u0011!!\u0019\n\u0004C\u0001[\u0012U\u0005b\u0002CM\u0019\u0011\u000531\u0012\u0005\b\t7cA\u0011IBF\u0003%\u0001&o\\2fgN|'O\u0003\u0002o_\u00069a.\u001a;x_J\\'\"\u00019\u0002\u000b-\fgm[1\u0011\u0005I\fQ\"A7\u0003\u0013A\u0013xnY3tg>\u00148CA\u0001v!\t1\u00180D\u0001x\u0015\u0005A\u0018!B:dC2\f\u0017B\u0001>x\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001r\u0003UIE\r\\3QKJ\u001cWM\u001c;NKR\u0014\u0018n\u0019(b[\u0016,\"!!\u0001\u0011\t\u0005\r\u0011QB\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u0005!A.\u00198h\u0015\t\tY!\u0001\u0003kCZ\f\u0017\u0002BA\b\u0003\u000b\u0011aa\u0015;sS:<\u0017AF%eY\u0016\u0004VM]2f]RlU\r\u001e:jG:\u000bW.\u001a\u0011\u000239+Go^8sWB\u0013xnY3tg>\u0014X*\u001a;sS\u000e$\u0016mZ\u0001\u001b\u001d\u0016$xo\u001c:l!J|7-Z:t_JlU\r\u001e:jGR\u000bw\rI\u0001\u0012\u0019&\u001cH/\u001a8fe6+GO]5d)\u0006<\u0017A\u0005'jgR,g.\u001a:NKR\u0014\u0018n\u0019+bO\u0002\n1cQ8o]\u0016\u001cG/[8o#V,W/Z*ju\u0016,\"!a\b\u0011\u0007Y\f\t#C\u0002\u0002$]\u00141!\u00138u\u0003Q\u0019uN\u001c8fGRLwN\\)vKV,7+\u001b>fA\u0005aB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE*TCAA\u0016U\u0011\ty\"!\f,\u0005\u0005=\u0002\u0003BA\u0019\u0003wi!!a\r\u000b\t\u0005U\u0012qG\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u000fx\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003{\t\u0019DA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u001cR\u0001DA!\u0003\u000f\u00022A]A\"\u0013\r\t)%\u001c\u0002\u0015\u0003\n\u001cHO]1diN+'O^3s)\"\u0014X-\u00193\u0011\t\u0005%\u0013qJ\u0007\u0003\u0003\u0017R1!!\u0014p\u0003\u001diW\r\u001e:jGNLA!!\u0015\u0002L\t\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\u0002\u0005%$\u0017aA5eA\u0005!A/[7f!\u0011\tY&a\u001c\u000e\u0005\u0005u#\u0002BA0\u0003C\nQ!\u001e;jYNTA!a\u0019\u0002f\u000511m\\7n_:T1\u0001]A4\u0015\u0011\tI'a\u001b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\ti'A\u0002pe\u001eLA!!\u001d\u0002^\t!A+[7f\u00039i\u0017\r\u001f*fcV,7\u000f^*ju\u0016\faB]3rk\u0016\u001cHo\u00115b]:,G\u000eE\u0002s\u0003sJ1!a\u001fn\u00059\u0011V-];fgR\u001c\u0005.\u00198oK2\f\u0001cY8o]\u0016\u001cG/[8o#V|G/Y:\u0011\u0007I\f\t)C\u0002\u0002\u00046\u0014\u0001cQ8o]\u0016\u001cG/[8o#V|G/Y:\u0002)\r|gN\\3di&|gn]'bq&#G.Z't!\r1\u0018\u0011R\u0005\u0004\u0003\u0017;(\u0001\u0002'p]\u001e\f1DZ1jY\u0016$\u0017)\u001e;iK:$\u0018nY1uS>tG)\u001a7bs6\u001b\u0018\u0001\u00047jgR,g.\u001a:OC6,\u0007\u0003BAJ\u0003/k!!!&\u000b\u00079\f\t'\u0003\u0003\u0002\u001a\u0006U%\u0001\u0004'jgR,g.\u001a:OC6,\u0017\u0001E:fGV\u0014\u0018\u000e^=Qe>$xnY8m!\u0011\ty*!+\u000e\u0005\u0005\u0005&\u0002BAR\u0003K\u000bA!Y;uQ*!\u0011qUA1\u0003!\u0019XmY;sSRL\u0018\u0002BAV\u0003C\u0013\u0001cU3dkJLG/\u001f)s_R|7m\u001c7\u0002\r\r|gNZ5h!\u0011\t\t,a.\u000e\u0005\u0005M&bAA[_\u000611/\u001a:wKJLA!!/\u00024\nY1*\u00194lC\u000e{gNZ5h!\u0011\ti,!1\u000e\u0005\u0005}&\u0002BA'\u0003CJA!a1\u0002@\n9Q*\u001a;sS\u000e\u001c\u0018AE2sK\u0012,g\u000e^5bYB\u0013xN^5eKJ\u0004B!!3\u0002N6\u0011\u00111\u001a\u0006\u0004\u0003O{\u0017\u0002BAh\u0003\u0017\u0014!c\u0011:fI\u0016tG/[1m!J|g/\u001b3fe\u0006QQ.Z7pef\u0004vn\u001c7\u0011\t\u0005U\u00171\\\u0007\u0003\u0003/TA!!7\u0002b\u00051Q.Z7pefLA!!8\u0002X\nQQ*Z7pef\u0004vn\u001c7\u0002\u00151|wmQ8oi\u0016DH\u000f\u0005\u0003\u0002\\\u0005\r\u0018\u0002BAs\u0003;\u0012!\u0002T8h\u0007>tG/\u001a=u\u0003M\u0019wN\u001c8fGRLwN\\)vKV,7+\u001b>f)\u0001\nY/!<\u0002p\u0006E\u00181_A{\u0003o\fI0a?\u0002~\u0006}(\u0011\u0001B\u0002\u0005\u000b\u00119A!\u0003\u0011\u0005Id\u0001bBA*;\u0001\u0007\u0011q\u0004\u0005\b\u0003/j\u0002\u0019AA-\u0011\u001d\t\u0019(\ba\u0001\u0003?Aq!!\u001e\u001e\u0001\u0004\t9\bC\u0004\u0002~u\u0001\r!a \t\u000f\u0005\u0015U\u00041\u0001\u0002\b\"9\u0011QR\u000fA\u0002\u0005}\u0001bBAH;\u0001\u0007\u0011\u0011\u0013\u0005\b\u00037k\u0002\u0019AAO\u0011\u001d\ti+\ba\u0001\u0003_Cq!!\u0014\u001e\u0001\u0004\tY\fC\u0004\u0002Fv\u0001\r!a2\t\u000f\u0005EW\u00041\u0001\u0002T\"9\u0011q\\\u000fA\u0002\u0005\u0005\b\"CAt;A\u0005\t\u0019AA\u0010\u00031\u0019uN\u001c8fGRLwN\\%e!\r\u0011yaH\u0007\u0002\u0019\ta1i\u001c8oK\u000e$\u0018n\u001c8JIN!q$\u001eB\u000b!\r1(qC\u0005\u0004\u000539(\u0001D*fe&\fG.\u001b>bE2,GC\u0001B\u0007\u0003)1'o\\7TiJLgn\u001a\u000b\u0005\u0005C\u0011y\fE\u0003w\u0005G\u00119#C\u0002\u0003&]\u0014aa\u00149uS>t\u0007c\u0001B\bIM1A%\u001eB\u0016\u0005+\u00012A\u001eB\u0017\u0013\r\u0011yc\u001e\u0002\b!J|G-^2u\u0003%awnY1m\u0011>\u001cH/\u0006\u0002\u00036A!!q\u0007B#\u001d\u0011\u0011ID!\u0011\u0011\u0007\tmr/\u0004\u0002\u0003>)\u0019!q\b?\u0002\rq\u0012xn\u001c;?\u0013\r\u0011\u0019e^\u0001\u0007!J,G-\u001a4\n\t\u0005=!q\t\u0006\u0004\u0005\u0007:\u0018A\u00037pG\u0006d\u0007j\\:uA\u0005IAn\\2bYB{'\u000f^\u0001\u000bY>\u001c\u0017\r\u001c)peR\u0004\u0013A\u0003:f[>$X\rS8ti\u0006Y!/Z7pi\u0016Dun\u001d;!\u0003)\u0011X-\\8uKB{'\u000f^\u0001\fe\u0016lw\u000e^3Q_J$\b%A\u0003j]\u0012,\u00070\u0001\u0004j]\u0012,\u0007\u0010\t\u000b\r\u0005O\u0011iFa\u0018\u0003b\t\r$Q\r\u0005\b\u0005cy\u0003\u0019\u0001B\u001b\u0011\u001d\u0011Ye\fa\u0001\u0003?AqAa\u00140\u0001\u0004\u0011)\u0004C\u0004\u0003T=\u0002\r!a\b\t\u000f\t]s\u00061\u0001\u0002 \u0005AAo\\*ue&tw\r\u0006\u0002\u00036\u0005!1m\u001c9z)1\u00119Ca\u001c\u0003r\tM$Q\u000fB<\u0011%\u0011\t$\rI\u0001\u0002\u0004\u0011)\u0004C\u0005\u0003LE\u0002\n\u00111\u0001\u0002 !I!qJ\u0019\u0011\u0002\u0003\u0007!Q\u0007\u0005\n\u0005'\n\u0004\u0013!a\u0001\u0003?A\u0011Ba\u00162!\u0003\u0005\r!a\b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!Q\u0010\u0016\u0005\u0005k\ti#\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0014AD2paf$C-\u001a4bk2$H%N\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!q\u0012BK!\r1(\u0011S\u0005\u0004\u0005';(aA!os\"I!qS\u001d\u0002\u0002\u0003\u0007\u0011qD\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\tu\u0005C\u0002BP\u0005K\u0013y)\u0004\u0002\u0003\"*\u0019!1U<\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003(\n\u0005&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BA!,\u00034B\u0019aOa,\n\u0007\tEvOA\u0004C_>dW-\u00198\t\u0013\t]5(!AA\u0002\t=\u0015\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005}\u0011AB3rk\u0006d7\u000f\u0006\u0003\u0003.\nu\u0006\"\u0003BL{\u0005\u0005\t\u0019\u0001BH\u0011\u001d\u0011\t-\ta\u0001\u0005k\t\u0011a]\u0001\u0006CB\u0004H.\u001f\u000b\r\u0005O\u00119M!3\u0003L\n5'q\u001a\u0005\b\u0005c\u0011\u0003\u0019\u0001B\u001b\u0011\u001d\u0011YE\ta\u0001\u0003?AqAa\u0014#\u0001\u0004\u0011)\u0004C\u0004\u0003T\t\u0002\r!a\b\t\u000f\t]#\u00051\u0001\u0002 \u00059QO\\1qa2LH\u0003\u0002Bk\u0005;\u0004RA\u001eB\u0012\u0005/\u0004RB\u001eBm\u0005k\tyB!\u000e\u0002 \u0005}\u0011b\u0001Bno\n1A+\u001e9mKVB\u0011Ba8$\u0003\u0003\u0005\rAa\n\u0002\u0007a$\u0003'\u0001\boK^\u001cuN\u001c8fGRLwN\\:\u0016\u0005\t\u0015\bC\u0002Bt\u0005c\u0014)0\u0004\u0002\u0003j*!!1\u001eBw\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0005_\fI!\u0001\u0003vi&d\u0017\u0002\u0002Bz\u0005S\u0014!#\u0011:sCf\u0014En\\2lS:<\u0017+^3vKB!!q_B\u0001\u001b\t\u0011IP\u0003\u0003\u0003|\nu\u0018\u0001C2iC:tW\r\\:\u000b\t\t}\u0018\u0011B\u0001\u0004]&|\u0017\u0002BB\u0002\u0005s\u0014QbU8dW\u0016$8\t[1o]\u0016d\u0017a\u00048fo\u000e{gN\\3di&|gn\u001d\u0011\u0002#%tg\r\\5hQR\u0014Vm\u001d9p]N,7/\u0006\u0002\u0004\fAA1QBB\n\u0005k\u00199\"\u0004\u0002\u0004\u0010)!1\u0011\u0003BQ\u0003\u001diW\u000f^1cY\u0016LAa!\u0006\u0004\u0010\t\u0019Q*\u00199\u0011\t\re1q\u0004\b\u0004e\u000em\u0011bAB\u000f[\u0006q!+Z9vKN$8\t[1o]\u0016d\u0017\u0002BB\u0011\u0007G\u0011\u0001BU3ta>t7/\u001a\u0006\u0004\u0007;i\u0017AE5oM2Lw\r\u001b;SKN\u0004xN\\:fg\u0002\nQB]3ta>t7/Z)vKV,WCAB\u0016!\u0019\u00119o!\f\u0004\u0018%!1q\u0006Bu\u0005Ma\u0015N\\6fI\ncwnY6j]\u001e$U-];f\u00039\u0011Xm\u001d9p]N,\u0017+^3vK\u0002\n!\"\\3ue&\u001cG+Y4t+\t\u00199\u0004\u0005\u0005\u0004:\rm\u0012\u0011AA\u0001\u001b\t\u0011i/\u0003\u0003\u0004\u0016\t5\u0018aC7fiJL7\rV1hg\u0002\nQ$\u001a=qSJ,GmQ8o]\u0016\u001cG/[8og.KG\u000e\\3e\u0007>,h\u000e^\u000b\u0003\u0007\u0007\u0002Ba!\u0012\u0004L5\u00111q\t\u0006\u0005\u0007\u0013\ny,A\u0003ti\u0006$8/\u0003\u0003\u0004N\r\u001d#!\u0002+pi\u0006d\u0017AH3ya&\u0014X\rZ\"p]:,7\r^5p]N\\\u0015\u000e\u001c7fI\u000e{WO\u001c;!\u0003\u001d*\u0007\u0010]5sK\u0012\u001cuN\u001c8fGRLwN\\:LS2dW\rZ\"pk:$X*\u001a;sS\u000et\u0015-\\3\u0016\u0005\rU\u0003\u0003BB,\u00073j!!!\u0019\n\t\rm\u0013\u0011\r\u0002\u000b\u001b\u0016$(/[2OC6,\u0017\u0001K3ya&\u0014X\rZ\"p]:,7\r^5p]N\\\u0015\u000e\u001c7fI\u000e{WO\u001c;NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0013\u0001C:fY\u0016\u001cGo\u001c:\u0016\u0005\r\r\u0004\u0003BAJ\u0007KJAaa\u001a\u0002\u0016\nA1+\u001a7fGR|'/A\u0005tK2,7\r^8sA\u0005q1M]3bi\u0016\u001cV\r\\3di>\u0014H\u0003BB2\u0007_Bqa!\u001dM\u0001\u0004\u0019\u0019(\u0001\bdQ\u0006tg.\u001a7Ck&dG-\u001a:\u0011\t\u0005M5QO\u0005\u0005\u0007o\n)J\u0001\bDQ\u0006tg.\u001a7Ck&dG-\u001a:\u0002'9,\u0007\u0010^\"p]:,7\r^5p]&sG-\u001a=\u0002/9,\u0007\u0010^\"p]:,7\r^5p]&sG-\u001a=`I\u0015\fH\u0003BB@\u0007\u000b\u00032A^BA\u0013\r\u0019\u0019i\u001e\u0002\u0005+:LG\u000fC\u0005\u0003\u0018:\u000b\t\u00111\u0001\u0002 \u0005!b.\u001a=u\u0007>tg.Z2uS>t\u0017J\u001c3fq\u0002\n1A];o)\t\u0019y(\u0001\tqe>\u001cWm]:Fq\u000e,\u0007\u000f^5p]R11qPBI\u0007+Cqaa%R\u0001\u0004\u0011)$\u0001\u0007feJ|'/T3tg\u0006<W\rC\u0004\u0004\u0018F\u0003\ra!'\u0002\u0013QD'o\\<bE2,\u0007\u0003BBN\u0007KsAa!(\u0004\":!!1HBP\u0013\u0005A\u0018bABRo\u00069\u0001/Y2lC\u001e,\u0017\u0002BBT\u0007S\u0013\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\r\rv/A\fqe>\u001cWm]:DQ\u0006tg.\u001a7Fq\u000e,\u0007\u000f^5p]RA1qPBX\u0007g\u001b)\fC\u0004\u00042J\u0003\rA!\u000e\u0002\u0013\rD\u0017M\u001c8fY&#\u0007bBBJ%\u0002\u0007!Q\u0007\u0005\b\u0007/\u0013\u0006\u0019ABM\u0003M\u0001(o\\2fgNtUm\u001e*fgB|gn]3t\u00031\u0019XM\u001c3SKN\u0004xN\\:f)\u0019\u0019yh!0\u0004B\"91q\u0018+A\u0002\r]\u0011\u0001\u0003:fgB|gn]3\t\u000f\r\rG\u000b1\u0001\u0004F\u0006a!/Z:q_:\u001cXmU3oIB!\u00111SBd\u0013\u0011\u0019I-!&\u0003\tM+g\u000eZ\u0001\u0011]><h*\u00198pgN+\b\u000f\u001d7jKJ,\"aa4\u0013\r\rE7Q[Bn\r\u0019\u0019\u0019.\u0016\u0001\u0004P\naAH]3gS:,W.\u001a8u}A!\u00111ABl\u0013\u0011\u0019I.!\u0002\u0003\r=\u0013'.Z2u!\u0019\u0019ina9\u0004h6\u00111q\u001c\u0006\u0005\u0007C\u0014i/\u0001\u0005gk:\u001cG/[8o\u0013\u0011\u0019)oa8\u0003\u0011M+\b\u000f\u001d7jKJ\u0004B!a\u0001\u0004j&!\u00111RA\u0003\u0003\u0011\u0001x\u000e\u001c7\u00021A\u0014xnY3tg\u000e{W\u000e\u001d7fi\u0016$'+Z2fSZ,7/A\u000bqe>\u001cWm]:D_6\u0004H.\u001a;fIN+g\u000eZ:\u0002)U\u0004H-\u0019;f%\u0016\fX/Z:u\u001b\u0016$(/[2t)\u0011\u0019yh!>\t\u000f\r}\u0016\f1\u0001\u0004\u0018\u0005\u0019\u0002O]8dKN\u001cH)[:d_:tWm\u0019;fI\u000612\r\\8tK\u0016C8-Z:t\u0007>tg.Z2uS>t7/A\u0003dY>\u001cX\r\u0006\u0003\u0004\u0000\r}\bb\u0002C\u00019\u0002\u0007!QG\u0001\rG>tg.Z2uS>t\u0017\nZ\u0001\u0007C\u000e\u001cW\r\u001d;\u0015\u0011\t5Fq\u0001C\u0006\t\u001fAq\u0001\"\u0003^\u0001\u0004\u0011)0A\u0007t_\u000e\\W\r^\"iC:tW\r\u001c\u0005\b\t\u001bi\u0006\u0019\u0001BW\u0003!i\u0017-\u001f\"m_\u000e\\\u0007b\u0002C\t;\u0002\u0007A1C\u0001\u0019C\u000e\u001cW\r\u001d;pe&#G.\u001a)fe\u000e,g\u000e^'fi\u0016\u0014\b\u0003\u0002C\u000b\tKi!\u0001b\u0006\u000b\t\u0011eA1D\u0001\u0005G>\u0014XM\u0003\u0003\u0002N\u0011u!\u0002\u0002C\u0010\tC\ta!_1n[\u0016\u0014(B\u0001C\u0012\u0003\r\u0019w.\\\u0005\u0005\tO!9BA\u0003NKR,'/A\fd_:4\u0017nZ;sK:+woQ8o]\u0016\u001cG/[8og\u0006A1\r\\8tK\u0006cG\u000e\u0006\u0003\u00036\u0011=\u0002b\u0002C\u0019A\u0002\u0007A1G\u0001\u0007g>\u001c7.\u001a;\u0011\t\u0011UB1H\u0007\u0003\toQA\u0001\"\u000f\u0002\n\u0005\u0019a.\u001a;\n\t\u0011uBq\u0007\u0002\u0007'>\u001c7.\u001a;\u0002\u001f\u0015t\u0017/^3vKJ+7\u000f]8og\u0016$Baa \u0005D!91qX1A\u0002\r]\u0011a\u00043fcV,W/\u001a*fgB|gn]3\u0015\u0005\r]\u0011!\u0005:fgB|gn]3Rk\u0016,XmU5{K\u0006)\u0012N\u001c4mS\u001eDGOU3ta>t7/Z\"pk:$\u0018\u0001F8qK:|%o\u00117pg&twm\u00115b]:,G\u000e\u0006\u0003\u0005R\u0011e\u0003#\u0002<\u0003$\u0011M\u0003\u0003BAJ\t+JA\u0001b\u0016\u0002\u0016\na1*\u00194lC\u000eC\u0017M\u001c8fY\"9A\u0011A3A\u0002\tU\u0012A\u00065b]\u0012dWm\u00115b]:,G.T;uK\u00163XM\u001c;\u0015\r\r}Dq\fC1\u0011\u001d!\tA\u001aa\u0001\u0005kAq\u0001b\u0019g\u0001\u0004!)'A\u0003fm\u0016tG\u000f\u0005\u0003\u0005h\u0011\u0005e\u0002\u0002C5\t{rA\u0001b\u001b\u0005|9!AQ\u000eC=\u001d\u0011!y\u0007b\u001e\u000f\t\u0011EDQ\u000f\b\u0005\u0005w!\u0019(\u0003\u0002\u0002n%!\u0011\u0011NA6\u0013\r\u0001\u0018qM\u0005\u0005\u0003G\n)'C\u0002o\u0003CJA\u0001b \u0002\u0016\u0006a1*\u00194lC\u000eC\u0017M\u001c8fY&!A1\u0011CC\u0005A\u0019\u0005.\u00198oK2lU\u000f^3Fm\u0016tGO\u0003\u0003\u0005\u0000\u0005U\u0015\u0001\u0005;ssVsW.\u001e;f\u0007\"\fgN\\3m)\u0011\u0019y\bb#\t\u000f\u0011\u0005q\r1\u0001\u00036\u000591\r[1o]\u0016dG\u0003\u0002C)\t#Cq\u0001\"\u0001i\u0001\u0004\u0011)$A\tok6\u001cF/Y4fIJ+7-Z5wKN$B!a\b\u0005\u0018\"9A\u0011A5A\u0002\tU\u0012AB<bW\u0016,\b/\u0001\u0005tQV$Hm\\<o\u0001")
public class Processor
extends AbstractServerThread
implements KafkaMetricsGroup {
    private volatile Processor$ConnectionId$ ConnectionId$module;
    private final int id;
    public final Time kafka$network$Processor$$time;
    private final int maxRequestSize;
    private final RequestChannel requestChannel;
    private final ConnectionQuotas connectionQuotas;
    private final long connectionsMaxIdleMs;
    private final int failedAuthenticationDelayMs;
    private final ListenerName listenerName;
    private final SecurityProtocol securityProtocol;
    private final KafkaConfig config;
    public final Metrics kafka$network$Processor$$metrics;
    private final MemoryPool memoryPool;
    private final LogContext logContext;
    private final int connectionQueueSize;
    private final ArrayBlockingQueue<SocketChannel> newConnections;
    private final scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses;
    private final LinkedBlockingDeque<RequestChannel.Response> responseQueue;
    private final java.util.Map<String, String> metricTags;
    private final Total expiredConnectionsKilledCount;
    private final MetricName expiredConnectionsKilledCountMetricName;
    private final Selector selector;
    private int nextConnectionIndex;

    public static int $lessinit$greater$default$15() {
        return Processor$.MODULE$.$lessinit$greater$default$15();
    }

    public static int ConnectionQueueSize() {
        return Processor$.MODULE$.ConnectionQueueSize();
    }

    public static String ListenerMetricTag() {
        return Processor$.MODULE$.ListenerMetricTag();
    }

    public static String NetworkProcessorMetricTag() {
        return Processor$.MODULE$.NetworkProcessorMetricTag();
    }

    public static String IdlePercentMetricName() {
        return Processor$.MODULE$.IdlePercentMetricName();
    }

    @Override
    public com.yammer.metrics.core.MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public com.yammer.metrics.core.MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    private Processor$ConnectionId$ ConnectionId() {
        if (this.ConnectionId$module == null) {
            this.ConnectionId$lzycompute$1();
        }
        return this.ConnectionId$module;
    }

    public int id() {
        return this.id;
    }

    private ArrayBlockingQueue<SocketChannel> newConnections() {
        return this.newConnections;
    }

    private scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses() {
        return this.inflightResponses;
    }

    private LinkedBlockingDeque<RequestChannel.Response> responseQueue() {
        return this.responseQueue;
    }

    public java.util.Map<String, String> metricTags() {
        return this.metricTags;
    }

    public Total expiredConnectionsKilledCount() {
        return this.expiredConnectionsKilledCount;
    }

    private MetricName expiredConnectionsKilledCountMetricName() {
        return this.expiredConnectionsKilledCountMetricName;
    }

    private Selector selector() {
        return this.selector;
    }

    public Selector createSelector(ChannelBuilder channelBuilder) {
        ChannelBuilder channelBuilder2 = channelBuilder;
        if (channelBuilder2 instanceof Reconfigurable) {
            ChannelBuilder channelBuilder3 = channelBuilder2;
            this.config.addReconfigurable((Reconfigurable)channelBuilder3);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return new Selector(this.maxRequestSize, this.connectionsMaxIdleMs, this.failedAuthenticationDelayMs, this.kafka$network$Processor$$metrics, this.kafka$network$Processor$$time, "socket-server", this.metricTags(), false, true, channelBuilder, this.memoryPool, this.logContext);
    }

    private int nextConnectionIndex() {
        return this.nextConnectionIndex;
    }

    private void nextConnectionIndex_$eq(int x$1) {
        this.nextConnectionIndex = x$1;
    }

    @Override
    public void run() {
        block7: {
            this.startupComplete();
            block5: while (true) {
                while (this.isRunning()) {
                    try {
                        this.configureNewConnections();
                        this.processNewResponses();
                        this.poll();
                        this.processCompletedReceives();
                        this.processCompletedSends();
                        this.processDisconnected();
                        this.closeExcessConnections();
                        continue block5;
                    }
                    catch (Throwable e) {
                        this.processException("Processor got uncaught exception.", e);
                    }
                }
                break block7;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Closing selector - processor ").append(this.id()).toString());
                CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.closeAll(), this, Level.ERROR);
                this.shutdownComplete();
            }
        }
    }

    private void processException(String errorMessage, Throwable throwable) {
        Throwable throwable2 = throwable;
        if (throwable2 instanceof ControlThrowable) {
            ControlThrowable controlThrowable = (ControlThrowable)throwable2;
            throw (Throwable)controlThrowable;
        }
        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMessage, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable2);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void processChannelException(String channelId, String errorMessage, Throwable throwable) {
        if (this.openOrClosingChannel(channelId).isDefined()) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Closing socket for ").append(channelId).append(" because of error").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
            this.close(channelId);
        }
        this.processException(errorMessage, throwable);
    }

    private void processNewResponses() {
        RequestChannel.Response currentResponse = null;
        while ((currentResponse = this.dequeueResponse()) != null) {
            String channelId = currentResponse.request().context().connectionId;
            try {
                BoxedUnit boxedUnit;
                RequestChannel.Response response = currentResponse;
                if (response instanceof RequestChannel.NoOpResponse) {
                    RequestChannel.NoOpResponse noOpResponse = (RequestChannel.NoOpResponse)response;
                    this.updateRequestMetrics(noOpResponse);
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Socket server received empty response to send, registering for read: ").append(noOpResponse).toString());
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.RESPONSE_SENT);
                    this.tryUnmuteChannel(channelId);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (response instanceof RequestChannel.SendResponse) {
                    RequestChannel.SendResponse sendResponse = (RequestChannel.SendResponse)response;
                    this.sendResponse(sendResponse, sendResponse.responseSend());
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (response instanceof RequestChannel.CloseConnectionResponse) {
                    RequestChannel.CloseConnectionResponse closeConnectionResponse = (RequestChannel.CloseConnectionResponse)response;
                    this.updateRequestMetrics(closeConnectionResponse);
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing socket connection actively according to the response code.");
                    this.close(channelId);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (response instanceof RequestChannel.StartThrottlingResponse) {
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.THROTTLE_STARTED);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (response instanceof RequestChannel.EndThrottlingResponse) {
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.THROTTLE_ENDED);
                    this.tryUnmuteChannel(channelId);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw new IllegalArgumentException(new StringBuilder(23).append("Unknown response type: ").append(currentResponse.getClass()).toString());
            }
            catch (Throwable e) {
                this.processChannelException(channelId, new StringBuilder(40).append("Exception while processing response for ").append(channelId).toString(), e);
            }
        }
    }

    public void sendResponse(RequestChannel.Response response, Send responseSend) {
        block1: {
            String connectionId = response.request().context().connectionId;
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(85).append("Socket server received response to send to ").append(connectionId).append(", registering for write and sending data: ").append(response).toString());
            if (this.channel(connectionId).isEmpty()) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(93).append("Attempting to send response via channel for which there is no open connection, connection id ").append(connectionId).toString());
                response.request().updateRequestMetrics(0L, response);
            }
            if (!this.openOrClosingChannel(connectionId).isDefined()) break block1;
            this.selector().send(responseSend);
            this.inflightResponses().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)connectionId), (Object)response));
        }
    }

    private Supplier<Long> nowNanosSupplier() {
        return new Supplier<Long>(this){
            private final /* synthetic */ Processor $outer;

            public Long get() {
                return Predef$.MODULE$.long2Long(this.$outer.kafka$network$Processor$$time.nanoseconds());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    private void poll() {
        int pollTimeout = this.newConnections().isEmpty() ? 300 : 0;
        try {
            this.selector().poll((long)pollTimeout);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof IllegalStateException ? true : throwable2 instanceof IOException;
            if (bl) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Processor ").append(this.id()).append(" poll failed").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable2);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private void processCompletedReceives() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.selector().completedReceives()).asScala()).foreach((Function1 & Serializable & scala.Serializable)receive -> {
            Processor.$anonfun$processCompletedReceives$1(this, receive);
            return BoxedUnit.UNIT;
        });
    }

    private void processCompletedSends() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.selector().completedSends()).asScala()).foreach((Function1 & Serializable & scala.Serializable)send -> {
            Processor.$anonfun$processCompletedSends$1(this, send);
            return BoxedUnit.UNIT;
        });
    }

    private void updateRequestMetrics(RequestChannel.Response response) {
        RequestChannel.Request request = response.request();
        long networkThreadTimeNanos = BoxesRunTime.unboxToLong((Object)this.openOrClosingChannel(request.context().connectionId).fold((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L, (Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToLong((long)x$16.getAndResetNetworkThreadTimeNanos())));
        request.updateRequestMetrics(networkThreadTimeNanos, response);
    }

    private void processDisconnected() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.selector().disconnected().keySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)connectionId -> {
            Processor.$anonfun$processDisconnected$1(this, connectionId);
            return BoxedUnit.UNIT;
        });
    }

    private void closeExcessConnections() {
        block0: {
            KafkaChannel channel;
            if (!this.connectionQuotas.maxConnectionsExceeded(this.listenerName) || (channel = this.selector().lowestPriorityChannel()) == null) break block0;
            this.close(channel.id());
        }
    }

    private void close(String connectionId) {
        this.openOrClosingChannel(connectionId).foreach((Function1 & Serializable & scala.Serializable)channel -> {
            Processor.$anonfun$close$4(this, connectionId, channel);
            return BoxedUnit.UNIT;
        });
    }

    public boolean accept(SocketChannel socketChannel, boolean mayBlock, Meter acceptorIdlePercentMeter) {
        boolean accepted;
        block4: {
            boolean bl;
            if (this.newConnections().offer(socketChannel)) {
                bl = true;
            } else if (mayBlock) {
                long startNs = this.kafka$network$Processor$$time.nanoseconds();
                this.newConnections().put(socketChannel);
                acceptorIdlePercentMeter.mark(this.kafka$network$Processor$$time.nanoseconds() - startNs);
                bl = true;
            } else {
                bl = accepted = false;
            }
            if (!accepted) break block4;
            this.wakeup();
        }
        return accepted;
    }

    private void configureNewConnections() {
        int connectionsProcessed = 0;
        while (connectionsProcessed < this.connectionQueueSize && !this.newConnections().isEmpty()) {
            SocketChannel channel = this.newConnections().poll();
            try {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Processor ").append(this.id()).append(" listening to new connection from ").append(channel.socket().getRemoteSocketAddress()).toString());
                this.selector().register(this.connectionId(channel.socket()), channel);
                ++connectionsProcessed;
            }
            catch (Throwable e) {
                SocketAddress remoteAddress = channel.socket().getRemoteSocketAddress();
                this.close(this.listenerName, channel);
                this.processException(new StringBuilder(34).append("Processor ").append(this.id()).append(" closed connection from ").append(remoteAddress).toString(), e);
            }
        }
    }

    private void closeAll() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.selector().channels()).asScala()).foreach((Function1 & Serializable & scala.Serializable)channel -> {
            this.close(channel.id());
            return BoxedUnit.UNIT;
        });
        this.selector().close();
        this.removeMetric(Processor$.MODULE$.IdlePercentMetricName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag()), (Object)((Object)BoxesRunTime.boxToInteger((int)this.id())).toString())}))));
    }

    public String connectionId(Socket socket) {
        String localHost = socket.getLocalAddress().getHostAddress();
        int localPort = socket.getLocalPort();
        String remoteHost = socket.getInetAddress().getHostAddress();
        int remotePort = socket.getPort();
        String connId = new ConnectionId(this, localHost, localPort, remoteHost, remotePort, this.nextConnectionIndex()).toString();
        this.nextConnectionIndex_$eq(this.nextConnectionIndex() == Integer.MAX_VALUE ? 0 : this.nextConnectionIndex() + 1);
        return connId;
    }

    public void enqueueResponse(RequestChannel.Response response) {
        this.responseQueue().put(response);
        this.wakeup();
    }

    /*
     * WARNING - void declaration
     */
    private RequestChannel.Response dequeueResponse() {
        void var1_1;
        block0: {
            RequestChannel.Response response = this.responseQueue().poll();
            if (response == null) break block0;
            response.request().responseDequeueTimeNanos_$eq(Time.SYSTEM.nanoseconds());
        }
        return var1_1;
    }

    public int responseQueueSize() {
        return this.responseQueue().size();
    }

    public int inflightResponseCount() {
        return this.inflightResponses().size();
    }

    public Option<KafkaChannel> openOrClosingChannel(String connectionId) {
        return Option$.MODULE$.apply((Object)this.selector().channel(connectionId)).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)this.selector().closingChannel(connectionId)));
    }

    private void handleChannelMuteEvent(String connectionId, KafkaChannel.ChannelMuteEvent event) {
        this.openOrClosingChannel(connectionId).foreach((Function1 & Serializable & scala.Serializable)c -> {
            c.handleChannelMuteEvent(event);
            return BoxedUnit.UNIT;
        });
    }

    private void tryUnmuteChannel(String connectionId) {
        this.openOrClosingChannel(connectionId).foreach((Function1 & Serializable & scala.Serializable)c -> {
            Processor.$anonfun$tryUnmuteChannel$1(this, c);
            return BoxedUnit.UNIT;
        });
    }

    public Option<KafkaChannel> channel(String connectionId) {
        return Option$.MODULE$.apply((Object)this.selector().channel(connectionId));
    }

    public int numStagedReceives(String connectionId) {
        return BoxesRunTime.unboxToInt((Object)this.openOrClosingChannel(connectionId).map((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToInteger((int)Processor.$anonfun$numStagedReceives$1(this, c))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    @Override
    public void wakeup() {
        this.selector().wakeup();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.removeMetric("IdlePercent", (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"networkProcessor"), (Object)((Object)BoxesRunTime.boxToInteger((int)this.id())).toString())}))));
        this.kafka$network$Processor$$metrics.removeMetric(this.expiredConnectionsKilledCountMetricName());
    }

    private final void ConnectionId$lzycompute$1() {
        Processor processor = this;
        synchronized (processor) {
            if (this.ConnectionId$module == null) {
                this.ConnectionId$module = new Processor$ConnectionId$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$processCompletedReceives$1(Processor $this, NetworkReceive receive) {
        try {
            BoxedUnit boxedUnit;
            Option<KafkaChannel> option = $this.openOrClosingChannel(receive.source());
            if (option instanceof Some) {
                Some some = (Some)option;
                KafkaChannel channel = (KafkaChannel)some.value();
                RequestHeader header = RequestHeader.parse((ByteBuffer)receive.payload());
                ApiKeys apiKeys = header.apiKey();
                ApiKeys apiKeys2 = ApiKeys.SASL_HANDSHAKE;
                if (!(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null) && channel.maybeBeginServerReauthentication(receive, $this.nowNanosSupplier())) {
                    $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Begin re-authentication: ").append(channel).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    long nowNanos = $this.kafka$network$Processor$$time.nanoseconds();
                    if (channel.serverAuthenticationSessionExpired(nowNanos)) {
                        channel.disconnect();
                        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Disconnected expired channel: ").append(channel).append(" : ").append(header).toString());
                        $this.expiredConnectionsKilledCount().record(null, 1.0, 0L);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        String connectionId = receive.source();
                        RequestContext context = new RequestContext(header, connectionId, channel.socketAddress(), channel.principal(), $this.listenerName, $this.securityProtocol);
                        RequestChannel.Request req = new RequestChannel.Request($this.id(), context, nowNanos, $this.memoryPool, receive.payload(), $this.requestChannel.metrics());
                        $this.requestChannel.sendRequest(req);
                        $this.selector().mute(connectionId);
                        $this.handleChannelMuteEvent(connectionId, KafkaChannel.ChannelMuteEvent.REQUEST_RECEIVED);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            } else {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException(new StringBuilder(66).append("Channel ").append(receive.source()).append(" removed from selector before processing completed receive").toString());
                }
                throw new MatchError(option);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
        catch (Throwable e) {
            $this.processChannelException(receive.source(), new StringBuilder(40).append("Exception while processing request from ").append(receive.source()).toString(), e);
        }
    }

    public static final /* synthetic */ void $anonfun$processCompletedSends$1(Processor $this, Send send) {
        try {
            RequestChannel.Response response = (RequestChannel.Response)$this.inflightResponses().remove((Object)send.destination()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException(new StringBuilder(51).append("Send for ").append(send.destination()).append(" completed, but not in `inflightResponses`").toString());
            });
            $this.updateRequestMetrics(response);
            response.onComplete().foreach((Function1 & Serializable & scala.Serializable)onComplete -> {
                onComplete.apply((Object)send);
                return BoxedUnit.UNIT;
            });
            $this.handleChannelMuteEvent(send.destination(), KafkaChannel.ChannelMuteEvent.RESPONSE_SENT);
            $this.tryUnmuteChannel(send.destination());
        }
        catch (Throwable e) {
            $this.processChannelException(send.destination(), new StringBuilder(45).append("Exception while processing completed send to ").append(send.destination()).toString(), e);
        }
    }

    public static final /* synthetic */ void $anonfun$processDisconnected$1(Processor $this, String connectionId) {
        try {
            String remoteHost = ((ConnectionId)$this.ConnectionId().fromString(connectionId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException(new StringBuilder(36).append("connectionId has unexpected format: ").append(connectionId).toString());
            })).remoteHost();
            $this.inflightResponses().remove((Object)connectionId).foreach((Function1 & Serializable & scala.Serializable)response -> {
                $this.updateRequestMetrics(response);
                return BoxedUnit.UNIT;
            });
            $this.connectionQuotas.dec($this.listenerName, InetAddress.getByName(remoteHost));
        }
        catch (Throwable e) {
            $this.processException(new StringBuilder(44).append("Exception while processing disconnection of ").append(connectionId).toString(), e);
        }
    }

    public static final /* synthetic */ void $anonfun$close$4(Processor $this, String connectionId$3, KafkaChannel channel) {
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Closing selector connection ").append(connectionId$3).toString());
        InetAddress address = channel.socketAddress();
        if (address != null) {
            $this.connectionQuotas.dec($this.listenerName, address);
        }
        $this.selector().close(connectionId$3);
        $this.inflightResponses().remove((Object)connectionId$3).foreach((Function1 & Serializable & scala.Serializable)response -> {
            $this.updateRequestMetrics(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$tryUnmuteChannel$1(Processor $this, KafkaChannel c) {
        $this.selector().unmute(c.id());
    }

    public static final /* synthetic */ int $anonfun$numStagedReceives$1(Processor $this, KafkaChannel c) {
        return $this.selector().numStagedReceives(c);
    }

    public Processor(int id, Time time, int maxRequestSize, RequestChannel requestChannel, ConnectionQuotas connectionQuotas, long connectionsMaxIdleMs, int failedAuthenticationDelayMs, ListenerName listenerName, SecurityProtocol securityProtocol, KafkaConfig config, Metrics metrics, CredentialProvider credentialProvider, MemoryPool memoryPool, LogContext logContext, int connectionQueueSize) {
        this.id = id;
        this.kafka$network$Processor$$time = time;
        this.maxRequestSize = maxRequestSize;
        this.requestChannel = requestChannel;
        this.connectionQuotas = connectionQuotas;
        this.connectionsMaxIdleMs = connectionsMaxIdleMs;
        this.failedAuthenticationDelayMs = failedAuthenticationDelayMs;
        this.listenerName = listenerName;
        this.securityProtocol = securityProtocol;
        this.config = config;
        this.kafka$network$Processor$$metrics = metrics;
        this.memoryPool = memoryPool;
        this.logContext = logContext;
        this.connectionQueueSize = connectionQueueSize;
        super(connectionQuotas);
        KafkaMetricsGroup.$init$(this);
        this.newConnections = new ArrayBlockingQueue(connectionQueueSize);
        this.inflightResponses = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.responseQueue = new LinkedBlockingDeque();
        this.metricTags = (java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)LinkedHashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)listenerName.value()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag()), (Object)((Object)BoxesRunTime.boxToInteger((int)id)).toString())}))).asJava();
        this.newGauge(Processor$.MODULE$.IdlePercentMetricName(), new Gauge<Object>(this){
            private final /* synthetic */ Processor $outer;

            public double value() {
                return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)this.$outer.kafka$network$Processor$$metrics.metric(this.$outer.kafka$network$Processor$$metrics.metricName("io-wait-ratio", SocketServer$.MODULE$.MetricsGroup(), this.$outer.metricTags()))).fold((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, (Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToDouble((double)$anon$7.$anonfun$value$20(m))));
            }

            public static final /* synthetic */ double $anonfun$value$20(KafkaMetric m) {
                return Math.min(BoxesRunTime.unboxToDouble((Object)m.metricValue()), 1.0);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$19(), $anonfun$value$20$adapted(org.apache.kafka.common.metrics.KafkaMetric )}, serializedLambda);
            }
        }, (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag()), (Object)((Object)BoxesRunTime.boxToInteger((int)id)).toString())}))));
        this.expiredConnectionsKilledCount = new Total();
        this.expiredConnectionsKilledCountMetricName = metrics.metricName("expired-connections-killed-count", "socket-server-metrics", this.metricTags());
        metrics.addMetric(this.expiredConnectionsKilledCountMetricName(), (Measurable)this.expiredConnectionsKilledCount());
        ListenerName listenerName2 = listenerName;
        ListenerName listenerName3 = config.interBrokerListenerName();
        this.selector = this.createSelector(ChannelBuilders.serverChannelBuilder((ListenerName)listenerName, (!(listenerName2 != null ? !listenerName2.equals(listenerName3) : listenerName3 != null) ? 1 : 0) != 0, (SecurityProtocol)securityProtocol, (AbstractConfig)config, (CredentialCache)credentialProvider.credentialCache(), (DelegationTokenCache)credentialProvider.tokenCache(), (Time)time));
        this.nextConnectionIndex = 0;
    }

    public class ConnectionId
    implements Product,
    scala.Serializable {
        private final String localHost;
        private final int localPort;
        private final String remoteHost;
        private final int remotePort;
        private final int index;
        public final /* synthetic */ Processor $outer;

        public String localHost() {
            return this.localHost;
        }

        public int localPort() {
            return this.localPort;
        }

        public String remoteHost() {
            return this.remoteHost;
        }

        public int remotePort() {
            return this.remotePort;
        }

        public int index() {
            return this.index;
        }

        public String toString() {
            return new StringBuilder(4).append(this.localHost()).append(":").append(this.localPort()).append("-").append(this.remoteHost()).append(":").append(this.remotePort()).append("-").append(this.index()).toString();
        }

        public ConnectionId copy(String localHost, int localPort, String remoteHost, int remotePort, int index) {
            return new ConnectionId(this.kafka$network$Processor$ConnectionId$$$outer(), localHost, localPort, remoteHost, remotePort, index);
        }

        public String copy$default$1() {
            return this.localHost();
        }

        public int copy$default$2() {
            return this.localPort();
        }

        public String copy$default$3() {
            return this.remoteHost();
        }

        public int copy$default$4() {
            return this.remotePort();
        }

        public int copy$default$5() {
            return this.index();
        }

        public String productPrefix() {
            return "ConnectionId";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.localHost();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this.localPort());
                    break;
                }
                case 2: {
                    object = this.remoteHost();
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToInteger((int)this.remotePort());
                    break;
                }
                case 4: {
                    object = BoxesRunTime.boxToInteger((int)this.index());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ConnectionId;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.localHost()));
            n = Statics.mix((int)n, (int)this.localPort());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.remoteHost()));
            n = Statics.mix((int)n, (int)this.remotePort());
            n = Statics.mix((int)n, (int)this.index());
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ConnectionId)) return false;
            if (((ConnectionId)object).kafka$network$Processor$ConnectionId$$$outer() != this.kafka$network$Processor$ConnectionId$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ConnectionId connectionId = (ConnectionId)x$1;
            String string = this.localHost();
            String string2 = connectionId.localHost();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.localPort() != connectionId.localPort()) return false;
            String string3 = this.remoteHost();
            String string4 = connectionId.remoteHost();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (this.remotePort() != connectionId.remotePort()) return false;
            if (this.index() != connectionId.index()) return false;
            if (!connectionId.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Processor kafka$network$Processor$ConnectionId$$$outer() {
            return this.$outer;
        }

        public ConnectionId(Processor $outer, String localHost, int localPort, String remoteHost, int remotePort, int index) {
            this.localHost = localHost;
            this.localPort = localPort;
            this.remoteHost = remoteHost;
            this.remotePort = remotePort;
            this.index = index;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

