/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.common.RequestAndCompletionHandler;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.DelayedTxnMarker;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TxnMarkerQueue;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.utils.TestUtils$;
import kafka.utils.timer.MockTimer;
import kafka.utils.timer.Timer;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tea\u0001B\u001e=\u0001\rCQA\u0013\u0001\u0005\u0002-CqA\u0014\u0001C\u0002\u0013%q\n\u0003\u0004W\u0001\u0001\u0006I\u0001\u0015\u0005\b/\u0002\u0011\r\u0011\"\u0003Y\u0011\u0019!\u0007\u0001)A\u00053\"9Q\r\u0001b\u0001\n\u00131\u0007B\u00026\u0001A\u0003%q\rC\u0004l\u0001\t\u0007I\u0011\u00027\t\rM\u0004\u0001\u0015!\u0003n\u0011\u001d!\bA1A\u0005\n1Da!\u001e\u0001!\u0002\u0013i\u0007b\u0002<\u0001\u0005\u0004%Ia\u001e\u0005\u0007w\u0002\u0001\u000b\u0011\u0002=\t\u000fq\u0004!\u0019!C\u0005o\"1Q\u0010\u0001Q\u0001\naDqA \u0001C\u0002\u0013%q\u0010\u0003\u0005\u0002\u0012\u0001\u0001\u000b\u0011BA\u0001\u0011!\t\u0019\u0002\u0001b\u0001\n\u0013y\b\u0002CA\u000b\u0001\u0001\u0006I!!\u0001\t\u0013\u0005]\u0001A1A\u0005\n\u0005e\u0001\u0002CA\u0011\u0001\u0001\u0006I!a\u0007\t\u0013\u0005\r\u0002A1A\u0005\n\u0005e\u0001\u0002CA\u0013\u0001\u0001\u0006I!a\u0007\t\u0013\u0005\u001d\u0002A1A\u0005\n\u0005%\u0002\u0002CA\u0019\u0001\u0001\u0006I!a\u000b\t\u0013\u0005M\u0002A1A\u0005\n\u0005U\u0002\u0002CA\u001f\u0001\u0001\u0006I!a\u000e\t\u0013\u0005}\u0002A1A\u0005\n\u0005U\u0002\u0002CA!\u0001\u0001\u0006I!a\u000e\t\u0013\u0005\r\u0003A1A\u0005\n\u0005U\u0002\u0002CA#\u0001\u0001\u0006I!a\u000e\t\u0013\u0005\u001d\u0003A1A\u0005\n\u0005U\u0002\u0002CA%\u0001\u0001\u0006I!a\u000e\t\u0013\u0005-\u0003A1A\u0005\n\u00055\u0003\u0002CA.\u0001\u0001\u0006I!a\u0014\t\u0013\u0005u\u0003A1A\u0005\n\u0005}\u0003\u0002CA4\u0001\u0001\u0006I!!\u0019\t\u0013\u0005%\u0004A1A\u0005\n\u0005}\u0003\u0002CA6\u0001\u0001\u0006I!!\u0019\t\u0013\u00055\u0004A1A\u0005\n\u0005=\u0004\u0002CAK\u0001\u0001\u0006I!!\u001d\t\u0013\u0005]\u0005A1A\u0005\n\u0005e\u0005\u0002CAT\u0001\u0001\u0006I!a'\t\u0013\u0005%\u0006A1A\u0005\n\u0005-\u0006\u0002CA]\u0001\u0001\u0006I!!,\t\u0013\u0005m\u0006A1A\u0005\n\u0005u\u0006\u0002CAc\u0001\u0001\u0006I!a0\t\u000f\u0005\u001d\u0007\u0001\"\u0003\u0002J\"9\u00111\u001a\u0001\u0005\u0002\u0005%\u0007bBAn\u0001\u0011\u0005\u0011\u0011\u001a\u0005\b\u0003?\u0004A\u0011AAe\u0011\u001d\t\u0019\u000f\u0001C\u0001\u0003\u0013Dq!a:\u0001\t\u0003\tI\rC\u0004\u0002l\u0002!\t!!3\t\u000f\u0005=\b\u0001\"\u0001\u0002J\"9\u00111\u001f\u0001\u0005\u0002\u0005%\u0007bBA|\u0001\u0011%\u0011\u0011 \u0005\b\u0005+\u0001A\u0011AAe\u0005\r\"&/\u00198tC\u000e$\u0018n\u001c8NCJ\\WM]\"iC:tW\r\\'b]\u0006<WM\u001d+fgRT!!\u0010 \u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003\u007f\u0001\u000b1bY8pe\u0012Lg.\u0019;pe*\t\u0011)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001!\u0005CA#I\u001b\u00051%\"A$\u0002\u000bM\u001c\u0017\r\\1\n\u0005%3%AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u0019B\u0011Q\nA\u0007\u0002y\u0005iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016,\u0012\u0001\u0015\t\u0003#Rk\u0011A\u0015\u0006\u0003'\u0002\u000baa]3sm\u0016\u0014\u0018BA+S\u00055iU\r^1eCR\f7)Y2iK\u0006qQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016\u0004\u0013!\u00048fi^|'o[\"mS\u0016tG/F\u0001Z!\tQ&-D\u0001\\\u0015\taV,A\u0004dY&,g\u000e^:\u000b\u0005\u0005s&BA0a\u0003\u0019\t\u0007/Y2iK*\t\u0011-A\u0002pe\u001eL!aY.\u0003\u001b9+Go^8sW\u000ec\u0017.\u001a8u\u00039qW\r^<pe.\u001cE.[3oi\u0002\nq\u0002\u001e=o'R\fG/Z'b]\u0006<WM]\u000b\u0002OB\u0011Q\n[\u0005\u0003Sr\u0012q\u0003\u0016:b]N\f7\r^5p]N#\u0018\r^3NC:\fw-\u001a:\u0002!QDhn\u0015;bi\u0016l\u0015M\\1hKJ\u0004\u0013A\u00039beRLG/[8ocU\tQ\u000e\u0005\u0002oc6\tqN\u0003\u0002q;\u000611m\\7n_:L!A]8\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006Y\u0001/\u0019:uSRLwN\\\u0019!\u0003)\u0001\u0018M\u001d;ji&|gNM\u0001\fa\u0006\u0014H/\u001b;j_:\u0014\u0004%A\u0004ce>\\WM]\u0019\u0016\u0003a\u0004\"A\\=\n\u0005i|'\u0001\u0002(pI\u0016\f\u0001B\u0019:pW\u0016\u0014\u0018\u0007I\u0001\bEJ|7.\u001a:3\u0003!\u0011'o\\6feJ\u0002\u0013\u0001\u0005;sC:\u001c\u0018m\u0019;j_:\fG.\u001332+\t\t\t\u0001\u0005\u0003\u0002\u0004\u00055QBAA\u0003\u0015\u0011\t9!!\u0003\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0017\tAA[1wC&!\u0011qBA\u0003\u0005\u0019\u0019FO]5oO\u0006\tBO]1og\u0006\u001cG/[8oC2LE-\r\u0011\u0002!Q\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\u0014\u0014!\u0005;sC:\u001c\u0018m\u0019;j_:\fG.\u001333A\u0005Y\u0001O]8ek\u000e,'/\u001332+\t\tY\u0002E\u0002F\u0003;I1!a\bG\u0005\u0011auN\\4\u0002\u0019A\u0014x\u000eZ;dKJLE-\r\u0011\u0002\u0017A\u0014x\u000eZ;dKJLEMM\u0001\raJ|G-^2fe&#'\u0007I\u0001\u000eaJ|G-^2fe\u0016\u0003xn\u00195\u0016\u0005\u0005-\u0002cA#\u0002.%\u0019\u0011q\u0006$\u0003\u000bMCwN\u001d;\u0002\u001dA\u0014x\u000eZ;dKJ,\u0005o\\2iA\u0005\u0011B\u000f\u001f8U_BL7\rU1si&$\u0018n\u001c82+\t\t9\u0004E\u0002F\u0003sI1!a\u000fG\u0005\rIe\u000e^\u0001\u0014ibtGk\u001c9jGB\u000b'\u000f^5uS>t\u0017\u0007I\u0001\u0013ibtGk\u001c9jGB\u000b'\u000f^5uS>t''A\nuq:$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0014\u0004%\u0001\td_>\u0014H-\u001b8bi>\u0014X\t]8dQ\u0006\t2m\\8sI&t\u0017\r^8s\u000bB|7\r\u001b\u0011\u0002\u0019QDh\u000eV5nK>,H/T:\u0002\u001bQDh\u000eV5nK>,H/T:!\u0003%!\bP\u001c*fgVdG/\u0006\u0002\u0002PA!\u0011\u0011KA,\u001b\t\t\u0019FC\u0002\u0002V=\f\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u00033\n\u0019FA\tUe\u0006t7/Y2uS>t'+Z:vYR\f!\u0002\u001e=o%\u0016\u001cX\u000f\u001c;!\u00031!\bP\\'fi\u0006$\u0017\r^12+\t\t\t\u0007E\u0002N\u0003GJ1!!\u001a=\u0005M!&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b\u00035!\bP\\'fi\u0006$\u0017\r^12A\u0005aA\u000f\u001f8NKR\fG-\u0019;be\u0005iA\u000f\u001f8NKR\fG-\u0019;be\u0001\nacY1qiV\u0014X\rZ#se>\u00148oQ1mY\n\f7m[\u000b\u0003\u0003c\u0002b!a\u001d\u0002z\u0005uTBAA;\u0015\r\t9\bY\u0001\tK\u0006\u001c\u00180\\8dW&!\u00111PA;\u0005\u001d\u0019\u0015\r\u001d;ve\u0016\u0004r!RA@\u0003\u0007\u000by)C\u0002\u0002\u0002\u001a\u0013\u0011BR;oGRLwN\\\u0019\u0011\t\u0005\u0015\u00151R\u0007\u0003\u0003\u000fS1!!#p\u0003!\u0001(o\u001c;pG>d\u0017\u0002BAG\u0003\u000f\u0013a!\u0012:s_J\u001c\bcA#\u0002\u0012&\u0019\u00111\u0013$\u0003\tUs\u0017\u000e^\u0001\u0018G\u0006\u0004H/\u001e:fI\u0016\u0013(o\u001c:t\u0007\u0006dGNY1dW\u0002\n!\u0003\u001e=o\u001b\u0006\u00148.\u001a:QkJ<\u0017\r^8ssV\u0011\u00111\u0014\t\u0006#\u0006u\u0015\u0011U\u0005\u0004\u0003?\u0013&!\u0007#fY\u0006LX\rZ(qKJ\fG/[8o!V\u0014x-\u0019;pef\u00042!TAR\u0013\r\t)\u000b\u0010\u0002\u0011\t\u0016d\u0017-_3e)btW*\u0019:lKJ\f1\u0003\u001e=o\u001b\u0006\u00148.\u001a:QkJ<\u0017\r^8ss\u0002\nA\u0001^5nKV\u0011\u0011Q\u0016\t\u0005\u0003_\u000b),\u0004\u0002\u00022*\u0019\u00111W8\u0002\u000bU$\u0018\u000e\\:\n\t\u0005]\u0016\u0011\u0017\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u0005q1\r[1o]\u0016dW*\u00198bO\u0016\u0014XCAA`!\ri\u0015\u0011Y\u0005\u0004\u0003\u0007d$a\b+sC:\u001c\u0018m\u0019;j_:l\u0015M]6fe\u000eC\u0017M\u001c8fY6\u000bg.Y4fe\u0006y1\r[1o]\u0016dW*\u00198bO\u0016\u0014\b%A\u0005n_\u000e\\7)Y2iKR\u0011\u0011qR\u00010g\"|W\u000f\u001c3HK:,'/\u0019;f\u000b6\u0004H/_'ba^CWM\u001c(p%\u0016\fX/Z:ug>+Ho\u001d;b]\u0012Lgn\u001a\u0015\u0004c\u0005=\u0007\u0003BAi\u0003/l!!a5\u000b\u0007\u0005U\u0007-A\u0003kk:LG/\u0003\u0003\u0002Z\u0006M'\u0001\u0002+fgR\f!f\u001d5pk2$w)\u001a8fe\u0006$XMU3rk\u0016\u001cH\u000fU3s!\u0006\u0014H/\u001b;j_:\u0004VM\u001d\"s_.,'\u000fK\u00023\u0003\u001f\fqe\u001d5pk2$7k[5q'\u0016tG-T1sW\u0016\u00148o\u00165f]2+\u0017\rZ3s\u001d>$hi\\;oI\"\u001a1'a4\u0002eMDw.\u001e7e'\u00064XMR8s\u0019\u0006$XM],iK:dU-\u00193feVs7N\\8x]\n+HOT8u\u0003Z\f\u0017\u000e\\1cY\u0016D3\u0001NAh\u0003a\u001a\bn\\;mIJ+Wn\u001c<f\u001b\u0006\u00148.\u001a:t\r>\u0014H\u000b\u001f8QCJ$\u0018\u000e^5p]^CWM\u001c)beRLG/[8o\u000b6LwM]1uK\u0012D3!NAh\u0003]\u001a\bn\\;mI\u000e{W\u000e\u001d7fi\u0016\f\u0005\u000f]3oIR{Gj\\4P]\u0016sG\r\u0016=o/\",gnU3oI6\u000b'o[3sgN+8mY3fI\"\u001aa'a4\u0002kMDw.\u001e7e\u0003\n|'\u000f^!qa\u0016tG\rV8M_\u001e|e.\u00128e)btw\u000b[3o\u001d>$8i\\8sI&t\u0017\r^8s\u000bJ\u0014xN\u001d\u0015\u0004o\u0005=\u0017AP:i_VdGMU3uef\f\u0005\u000f]3oIR{Gj\\4P]\u0016sG\r\u0016=o/\",gnQ8pe\u0012Lg.\u0019;pe:{G/\u0011<bS2\f'\r\\3FeJ|'\u000fK\u00029\u0003\u001f\f\u0011c\u0019:fCR,\u0007+\u001b3FeJ|'/T1q)\u0011\tYP!\u0005\u0011\u0011\u0005u(1\u0001B\u0004\u0005\u0017i!!a@\u000b\t\t\u0005\u0011\u0011B\u0001\u0005kRLG.\u0003\u0003\u0003\u0006\u0005}(a\u0002%bg\"l\u0015\r\u001d\t\u0005\u0003\u0007\u0011I!\u0003\u0003\u0002 \u0005\u0015\u0001cBA\u007f\u0005\u001bi\u00171Q\u0005\u0005\u0005\u001f\tyPA\u0002NCBDqAa\u0005:\u0001\u0004\t\u0019)\u0001\u0004feJ|'o]\u0001\u001eg\"|W\u000f\u001c3De\u0016\fG/Z'fiJL7m](o'R\f'\u000f^5oO\"\u001a!(a4")
public class TransactionMarkerChannelManagerTest {
    private final MetadataCache metadataCache = (MetadataCache)EasyMock.createNiceMock(MetadataCache.class);
    private final NetworkClient networkClient = (NetworkClient)EasyMock.createNiceMock(NetworkClient.class);
    private final TransactionStateManager txnStateManager = (TransactionStateManager)EasyMock.createNiceMock(TransactionStateManager.class);
    private final TopicPartition partition1 = new TopicPartition("topic1", 0);
    private final TopicPartition partition2 = new TopicPartition("topic1", 1);
    private final Node broker1 = new Node(1, "host", 10);
    private final Node broker2 = new Node(2, "otherhost", 10);
    private final String transactionalId1;
    private final String transactionalId2;
    private final long producerId1;
    private final long producerId2;
    private final short producerEpoch = (short)0;
    private final int txnTopicPartition1;
    private final int txnTopicPartition2;
    private final int coordinatorEpoch;
    private final int txnTimeoutMs;
    private final TransactionResult txnResult = TransactionResult.COMMIT;
    private final TransactionMetadata txnMetadata1 = new TransactionMetadata(this.transactionalId1(), this.producerId1(), this.producerEpoch(), this.txnTimeoutMs(), (TransactionState)PrepareCommit$.MODULE$, (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition1(), this.partition2()})), 0L, 0L);
    private final TransactionMetadata kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2 = new TransactionMetadata(this.transactionalId2(), this.producerId2(), this.producerEpoch(), this.txnTimeoutMs(), (TransactionState)PrepareCommit$.MODULE$, (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition1()})), 0L, 0L);
    private final Capture<Function1<Errors, BoxedUnit>> kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$capturedErrorsCallback = EasyMock.newCapture();
    private final DelayedOperationPurgatory<DelayedTxnMarker> txnMarkerPurgatory;
    private final MockTime time;
    private final TransactionMarkerChannelManager channelManager;

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private NetworkClient networkClient() {
        return this.networkClient;
    }

    private TransactionStateManager txnStateManager() {
        return this.txnStateManager;
    }

    private TopicPartition partition1() {
        return this.partition1;
    }

    private TopicPartition partition2() {
        return this.partition2;
    }

    private Node broker1() {
        return this.broker1;
    }

    private Node broker2() {
        return this.broker2;
    }

    private String transactionalId1() {
        return this.transactionalId1;
    }

    private String transactionalId2() {
        return this.transactionalId2;
    }

    private long producerId1() {
        return this.producerId1;
    }

    private long producerId2() {
        return this.producerId2;
    }

    private short producerEpoch() {
        return this.producerEpoch;
    }

    private int txnTopicPartition1() {
        return this.txnTopicPartition1;
    }

    private int txnTopicPartition2() {
        return this.txnTopicPartition2;
    }

    private int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    private int txnTimeoutMs() {
        return this.txnTimeoutMs;
    }

    private TransactionResult txnResult() {
        return this.txnResult;
    }

    private TransactionMetadata txnMetadata1() {
        return this.txnMetadata1;
    }

    public TransactionMetadata kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2() {
        return this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2;
    }

    public Capture<Function1<Errors, BoxedUnit>> kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$capturedErrorsCallback() {
        return this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$capturedErrorsCallback;
    }

    private DelayedOperationPurgatory<DelayedTxnMarker> txnMarkerPurgatory() {
        return this.txnMarkerPurgatory;
    }

    private MockTime time() {
        return this.time;
    }

    private TransactionMarkerChannelManager channelManager() {
        return this.channelManager;
    }

    private void mockCache() {
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)this.txnStateManager().partitionFor(this.transactionalId1()))).andReturn((Object)BoxesRunTime.boxToInteger((int)this.txnTopicPartition1())).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)this.txnStateManager().partitionFor(this.transactionalId2()))).andReturn((Object)BoxesRunTime.boxToInteger((int)this.txnTopicPartition2())).anyTimes();
        EasyMock.expect((Object)this.txnStateManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId1()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1())))).anyTimes();
        EasyMock.expect((Object)this.txnStateManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId2()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2())))).anyTimes();
        ReentrantReadWriteLock stateLock = new ReentrantReadWriteLock();
        EasyMock.expect((Object)this.txnStateManager().stateReadLock()).andReturn((Object)stateLock.readLock()).anyTimes();
    }

    @Test
    public void shouldGenerateEmptyMapWhenNoRequestsOutstanding() {
        Assert.assertTrue((boolean)this.channelManager().generateRequests().isEmpty());
    }

    @Test
    public void shouldGenerateRequestPerPartitionPerBroker() {
        this.mockCache();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager()});
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition1().topic()), EasyMock.eq((int)this.partition1().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker1())).anyTimes();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition2().topic()), EasyMock.eq((int)this.partition2().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker2())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.metadataCache()});
        this.channelManager().addTxnMarkersToSend(this.transactionalId1(), this.coordinatorEpoch(), this.txnResult(), this.txnMetadata1(), this.txnMetadata1().prepareComplete(this.time().milliseconds()));
        this.channelManager().addTxnMarkersToSend(this.transactionalId2(), this.coordinatorEpoch(), this.txnResult(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().prepareComplete(this.time().milliseconds()));
        Assert.assertEquals((long)2L, (long)this.txnMarkerPurgatory().watched());
        Assert.assertEquals((long)2L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assert.assertEquals((long)0L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        WriteTxnMarkersRequest expectedBroker1Request = (WriteTxnMarkersRequest)new WriteTxnMarkersRequest.Builder(Arrays.asList((Object[])new WriteTxnMarkersRequest.TxnMarkerEntry[]{new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId1(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList((Object[])new TopicPartition[]{this.partition1()})), new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId2(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList((Object[])new TopicPartition[]{this.partition1()}))})).build();
        WriteTxnMarkersRequest expectedBroker2Request = (WriteTxnMarkersRequest)new WriteTxnMarkersRequest.Builder(Arrays.asList((Object[])new WriteTxnMarkersRequest.TxnMarkerEntry[]{new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId1(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList((Object[])new TopicPartition[]{this.partition2()}))})).build();
        scala.collection.immutable.Map requests = ((TraversableOnce)this.channelManager().generateRequests().map((Function1 & Serializable & scala.Serializable)handler -> new Tuple2((Object)handler.destination(), (Object)((WriteTxnMarkersRequest.Builder)handler.request()).build()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.broker1()), (Object)expectedBroker1Request), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.broker2()), (Object)expectedBroker2Request)})), (Object)requests);
        Assert.assertTrue((boolean)this.channelManager().generateRequests().isEmpty());
    }

    @Test
    public void shouldSkipSendMarkersWhenLeaderNotFound() {
        this.mockCache();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager()});
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition1().topic()), EasyMock.eq((int)this.partition1().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)None$.MODULE$).anyTimes();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition2().topic()), EasyMock.eq((int)this.partition2().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker2())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.metadataCache()});
        this.channelManager().addTxnMarkersToSend(this.transactionalId1(), this.coordinatorEpoch(), this.txnResult(), this.txnMetadata1(), this.txnMetadata1().prepareComplete(this.time().milliseconds()));
        this.channelManager().addTxnMarkersToSend(this.transactionalId2(), this.coordinatorEpoch(), this.txnResult(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().prepareComplete(this.time().milliseconds()));
        Assert.assertEquals((long)1L, (long)this.txnMarkerPurgatory().watched());
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assert.assertTrue((boolean)this.channelManager().queueForBroker(this.broker1().id()).isEmpty());
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assert.assertEquals((long)0L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
    }

    @Test
    public void shouldSaveForLaterWhenLeaderUnknownButNotAvailable() {
        this.mockCache();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager()});
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition1().topic()), EasyMock.eq((int)this.partition1().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)Node.noNode())).andReturn((Object)new Some((Object)Node.noNode())).andReturn((Object)new Some((Object)Node.noNode())).andReturn((Object)new Some((Object)Node.noNode())).andReturn((Object)new Some((Object)this.broker1())).andReturn((Object)new Some((Object)this.broker1()));
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition2().topic()), EasyMock.eq((int)this.partition2().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker2())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.metadataCache()});
        this.channelManager().addTxnMarkersToSend(this.transactionalId1(), this.coordinatorEpoch(), this.txnResult(), this.txnMetadata1(), this.txnMetadata1().prepareComplete(this.time().milliseconds()));
        this.channelManager().addTxnMarkersToSend(this.transactionalId2(), this.coordinatorEpoch(), this.txnResult(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().prepareComplete(this.time().milliseconds()));
        Assert.assertEquals((long)2L, (long)this.txnMarkerPurgatory().watched());
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assert.assertTrue((boolean)this.channelManager().queueForBroker(this.broker1().id()).isEmpty());
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assert.assertEquals((long)0L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        Assert.assertEquals((long)2L, (long)this.channelManager().queueForUnknownBroker().totalNumMarkers());
        Assert.assertEquals((long)1L, (long)this.channelManager().queueForUnknownBroker().totalNumMarkers(this.txnTopicPartition1()));
        Assert.assertEquals((long)1L, (long)this.channelManager().queueForUnknownBroker().totalNumMarkers(this.txnTopicPartition2()));
        WriteTxnMarkersRequest expectedBroker1Request = (WriteTxnMarkersRequest)new WriteTxnMarkersRequest.Builder(Arrays.asList((Object[])new WriteTxnMarkersRequest.TxnMarkerEntry[]{new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId1(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList((Object[])new TopicPartition[]{this.partition1()})), new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId2(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList((Object[])new TopicPartition[]{this.partition1()}))})).build();
        WriteTxnMarkersRequest expectedBroker2Request = (WriteTxnMarkersRequest)new WriteTxnMarkersRequest.Builder(Arrays.asList((Object[])new WriteTxnMarkersRequest.TxnMarkerEntry[]{new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId1(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList((Object[])new TopicPartition[]{this.partition2()}))})).build();
        scala.collection.immutable.Map firstDrainedRequests = ((TraversableOnce)this.channelManager().generateRequests().map((Function1 & Serializable & scala.Serializable)handler -> new Tuple2((Object)handler.destination(), (Object)((WriteTxnMarkersRequest.Builder)handler.request()).build()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.broker2()), (Object)expectedBroker2Request)})), (Object)firstDrainedRequests);
        scala.collection.immutable.Map secondDrainedRequests = ((TraversableOnce)this.channelManager().generateRequests().map((Function1 & Serializable & scala.Serializable)handler -> new Tuple2((Object)handler.destination(), (Object)((WriteTxnMarkersRequest.Builder)handler.request()).build()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.broker1()), (Object)expectedBroker1Request)})), (Object)secondDrainedRequests);
    }

    @Test
    public void shouldRemoveMarkersForTxnPartitionWhenPartitionEmigrated() {
        this.mockCache();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager()});
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition1().topic()), EasyMock.eq((int)this.partition1().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker1())).anyTimes();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition2().topic()), EasyMock.eq((int)this.partition2().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker2())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.metadataCache()});
        this.channelManager().addTxnMarkersToSend(this.transactionalId1(), this.coordinatorEpoch(), this.txnResult(), this.txnMetadata1(), this.txnMetadata1().prepareComplete(this.time().milliseconds()));
        this.channelManager().addTxnMarkersToSend(this.transactionalId2(), this.coordinatorEpoch(), this.txnResult(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().prepareComplete(this.time().milliseconds()));
        Assert.assertEquals((long)2L, (long)this.txnMarkerPurgatory().watched());
        Assert.assertEquals((long)2L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assert.assertEquals((long)0L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        this.channelManager().removeMarkersForTxnTopicPartition(this.txnTopicPartition1());
        Assert.assertEquals((long)1L, (long)this.txnMarkerPurgatory().watched());
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assert.assertEquals((long)0L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        Assert.assertEquals((long)0L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assert.assertEquals((long)0L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assert.assertEquals((long)0L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
    }

    @Test
    public void shouldCompleteAppendToLogOnEndTxnWhenSendMarkersSucceed() {
        this.mockCache();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition1().topic()), EasyMock.eq((int)this.partition1().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker1())).anyTimes();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition2().topic()), EasyMock.eq((int)this.partition2().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker2())).anyTimes();
        TxnTransitMetadata txnTransitionMetadata2 = this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().prepareComplete(this.time().milliseconds());
        this.txnStateManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId2()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.eq((Object)txnTransitionMetadata2), (Function1)EasyMock.capture(this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$capturedErrorsCallback()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, txnTransitionMetadata2){
            private final /* synthetic */ TransactionMarkerChannelManagerTest $outer;
            private final TxnTransitMetadata txnTransitionMetadata2$1;

            public void answer() {
                this.$outer.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().completeTransitionTo(this.txnTransitionMetadata2$1);
                ((Function1)this.$outer.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.txnTransitionMetadata2$1 = txnTransitionMetadata2$1;
            }
        }).once();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager(), this.metadataCache()});
        this.channelManager().addTxnMarkersToSend(this.transactionalId2(), this.coordinatorEpoch(), this.txnResult(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2(), txnTransitionMetadata2);
        Iterable requestAndHandlers = this.channelManager().generateRequests();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createPidErrorMap(Errors.NONE));
        requestAndHandlers.foreach((Function1 & Serializable & scala.Serializable)requestAndHandler -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldCompleteAppendToLogOnEndTxnWhenSendMarkersSucceed$1(response, requestAndHandler);
            return BoxedUnit.UNIT;
        });
        EasyMock.verify((Object[])new Object[]{this.txnStateManager()});
        Assert.assertEquals((long)0L, (long)this.txnMarkerPurgatory().watched());
        Assert.assertEquals((long)0L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().pendingState());
        Assert.assertEquals((Object)CompleteCommit$.MODULE$, (Object)this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().state());
    }

    @Test
    public void shouldAbortAppendToLogOnEndTxnWhenNotCoordinatorError() {
        this.mockCache();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition1().topic()), EasyMock.eq((int)this.partition1().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker1())).anyTimes();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition2().topic()), EasyMock.eq((int)this.partition2().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker2())).anyTimes();
        TxnTransitMetadata txnTransitionMetadata2 = this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().prepareComplete(this.time().milliseconds());
        this.txnStateManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId2()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.eq((Object)txnTransitionMetadata2), (Function1)EasyMock.capture(this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$capturedErrorsCallback()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this){
            private final /* synthetic */ TransactionMarkerChannelManagerTest $outer;

            public void answer() {
                this.$outer.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().pendingState_$eq((Option)None$.MODULE$);
                ((Function1)this.$outer.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$capturedErrorsCallback().getValue()).apply((Object)Errors.NOT_COORDINATOR);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).once();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager(), this.metadataCache()});
        this.channelManager().addTxnMarkersToSend(this.transactionalId2(), this.coordinatorEpoch(), this.txnResult(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2(), txnTransitionMetadata2);
        Iterable requestAndHandlers = this.channelManager().generateRequests();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createPidErrorMap(Errors.NONE));
        requestAndHandlers.foreach((Function1 & Serializable & scala.Serializable)requestAndHandler -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldAbortAppendToLogOnEndTxnWhenNotCoordinatorError$1(response, requestAndHandler);
            return BoxedUnit.UNIT;
        });
        EasyMock.verify((Object[])new Object[]{this.txnStateManager()});
        Assert.assertEquals((long)0L, (long)this.txnMarkerPurgatory().watched());
        Assert.assertEquals((long)0L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().pendingState());
        Assert.assertEquals((Object)PrepareCommit$.MODULE$, (Object)this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().state());
    }

    @Test
    public void shouldRetryAppendToLogOnEndTxnWhenCoordinatorNotAvailableError() {
        this.mockCache();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition1().topic()), EasyMock.eq((int)this.partition1().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker1())).anyTimes();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition2().topic()), EasyMock.eq((int)this.partition2().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker2())).anyTimes();
        TxnTransitMetadata txnTransitionMetadata2 = this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().prepareComplete(this.time().milliseconds());
        this.txnStateManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId2()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.eq((Object)txnTransitionMetadata2), (Function1)EasyMock.capture(this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$capturedErrorsCallback()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this){
            private final /* synthetic */ TransactionMarkerChannelManagerTest $outer;

            public void answer() {
                ((Function1)this.$outer.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$capturedErrorsCallback().getValue()).apply((Object)Errors.COORDINATOR_NOT_AVAILABLE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, txnTransitionMetadata2){
            private final /* synthetic */ TransactionMarkerChannelManagerTest $outer;
            private final TxnTransitMetadata txnTransitionMetadata2$2;

            public void answer() {
                this.$outer.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().completeTransitionTo(this.txnTransitionMetadata2$2);
                ((Function1)this.$outer.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.txnTransitionMetadata2$2 = txnTransitionMetadata2$2;
            }
        });
        EasyMock.replay((Object[])new Object[]{this.txnStateManager(), this.metadataCache()});
        this.channelManager().addTxnMarkersToSend(this.transactionalId2(), this.coordinatorEpoch(), this.txnResult(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2(), txnTransitionMetadata2);
        Iterable requestAndHandlers = this.channelManager().generateRequests();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createPidErrorMap(Errors.NONE));
        requestAndHandlers.foreach((Function1 & Serializable & scala.Serializable)requestAndHandler -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldRetryAppendToLogOnEndTxnWhenCoordinatorNotAvailableError$1(response, requestAndHandler);
            return BoxedUnit.UNIT;
        });
        this.channelManager().generateRequests();
        EasyMock.verify((Object[])new Object[]{this.txnStateManager()});
        Assert.assertEquals((long)0L, (long)this.txnMarkerPurgatory().watched());
        Assert.assertEquals((long)0L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().pendingState());
        Assert.assertEquals((Object)CompleteCommit$.MODULE$, (Object)this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().state());
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<Long, Map<TopicPartition, Errors>> createPidErrorMap(Errors errors) {
        void var2_2;
        HashMap pidMap = new HashMap();
        HashMap<TopicPartition, Errors> errorsMap = new HashMap<TopicPartition, Errors>();
        errorsMap.put(this.partition1(), errors);
        pidMap.put(Predef$.MODULE$.long2Long(this.producerId2()), errorsMap);
        return var2_2;
    }

    @Test
    public void shouldCreateMetricsOnStarting() {
        scala.collection.mutable.Map metrics = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala();
        Assert.assertEquals((long)1L, (long)metrics.filterKeys((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManagerTest.$anonfun$shouldCreateMetricsOnStarting$1(x$1))).size());
        Assert.assertEquals((long)1L, (long)metrics.filterKeys((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManagerTest.$anonfun$shouldCreateMetricsOnStarting$2(x$2))).size());
    }

    public static final /* synthetic */ void $anonfun$shouldCompleteAppendToLogOnEndTxnWhenSendMarkersSucceed$1(WriteTxnMarkersResponse response$1, RequestAndCompletionHandler requestAndHandler) {
        requestAndHandler.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response$1));
    }

    public static final /* synthetic */ void $anonfun$shouldAbortAppendToLogOnEndTxnWhenNotCoordinatorError$1(WriteTxnMarkersResponse response$2, RequestAndCompletionHandler requestAndHandler) {
        requestAndHandler.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response$2));
    }

    public static final /* synthetic */ void $anonfun$shouldRetryAppendToLogOnEndTxnWhenCoordinatorNotAvailableError$1(WriteTxnMarkersResponse response$3, RequestAndCompletionHandler requestAndHandler) {
        requestAndHandler.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response$3));
    }

    public static final /* synthetic */ boolean $anonfun$shouldCreateMetricsOnStarting$1(MetricName x$1) {
        String string = x$1.getMBeanName();
        String string2 = "kafka.coordinator.transaction:type=TransactionMarkerChannelManager,name=UnknownDestinationQueueSize";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldCreateMetricsOnStarting$2(MetricName x$2) {
        String string = x$2.getMBeanName();
        String string2 = "kafka.coordinator.transaction:type=TransactionMarkerChannelManager,name=LogAppendRetryQueueSize";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public TransactionMarkerChannelManagerTest() {
        this.transactionalId1 = "txnId1";
        this.transactionalId2 = "txnId2";
        this.producerId1 = 0;
        this.producerId2 = 1;
        this.txnTopicPartition1 = 0;
        this.txnTopicPartition2 = 1;
        this.coordinatorEpoch = 0;
        this.txnTimeoutMs = 0;
        String x$1 = "txn-purgatory-name";
        MockTimer x$2 = new MockTimer();
        boolean x$3 = false;
        int x$4 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$5 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$6 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        this.txnMarkerPurgatory = new DelayedOperationPurgatory(x$1, (Timer)x$2, x$4, x$5, x$3, x$6);
        this.time = new MockTime();
        this.channelManager = new TransactionMarkerChannelManager(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), this.metadataCache(), this.networkClient(), this.txnStateManager(), this.txnMarkerPurgatory(), (Time)this.time());
    }
}

