/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionConfig$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.log.Log;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.ReplicaManager;
import kafka.utils.MockScheduler;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Function5;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\rua\u0001\u0002*T\u0001iCQ!\u0019\u0001\u0005\u0002\tDq!\u001a\u0001C\u0002\u0013\u0005a\r\u0003\u0004k\u0001\u0001\u0006Ia\u001a\u0005\bW\u0002\u0011\r\u0011\"\u0001g\u0011\u0019a\u0007\u0001)A\u0005O\"9Q\u000e\u0001b\u0001\n\u00031\u0007B\u00028\u0001A\u0003%q\rC\u0004p\u0001\t\u0007I\u0011\u00019\t\rq\u0004\u0001\u0015!\u0003r\u0011\u001di\bA1A\u0005\u0002\u0019DaA \u0001!\u0002\u00139\u0007\u0002C@\u0001\u0005\u0004%\t!!\u0001\t\u0011\u0005}\u0001\u0001)A\u0005\u0003\u0007A\u0011\"!\t\u0001\u0005\u0004%\t!a\t\t\u0011\u0005E\u0002\u0001)A\u0005\u0003KA\u0011\"a\r\u0001\u0005\u0004%\t!!\u000e\t\u0011\u0005\u0005\u0003\u0001)A\u0005\u0003oA\u0011\"a\u0011\u0001\u0005\u0004%\t!!\u0012\t\u0011\u0005M\u0003\u0001)A\u0005\u0003\u000fB\u0011\"!\u0016\u0001\u0005\u0004%\t!a\u0016\t\u0011\u0005\u0015\u0004\u0001)A\u0005\u00033B\u0011\"a\u001a\u0001\u0005\u0004%\t!!\u001b\t\u0011\u0005U\u0004\u0001)A\u0005\u0003WB\u0011\"a\u001e\u0001\u0005\u0004%\t!!\u001f\t\u0011\u0005\u0005\u0005\u0001)A\u0005\u0003wB\u0011\"a!\u0001\u0005\u0004%\t!!\"\t\u0011\u00055\u0005\u0001)A\u0005\u0003\u000fC\u0011\"a$\u0001\u0005\u0004%\t!!%\t\u0011\u0005%\u0006\u0001)A\u0005\u0003'C\u0011\"a+\u0001\u0005\u0004%\t!!%\t\u0011\u00055\u0006\u0001)A\u0005\u0003'C\u0011\"a,\u0001\u0005\u0004%\t!!-\t\u0011\u0005}\u0006\u0001)A\u0005\u0003gC\u0011\"!1\u0001\u0005\u0004%\t!!-\t\u0011\u0005\r\u0007\u0001)A\u0005\u0003gC\u0011\"!2\u0001\u0005\u0004%\t!a2\t\u0011\u0005]\u0007\u0001)A\u0005\u0003\u0013D\u0011\"!7\u0001\u0001\u0004%\t!a7\t\u0013\u0005\r\b\u00011A\u0005\u0002\u0005\u0015\b\u0002CAy\u0001\u0001\u0006K!!8\t\u0013\u0005M\b\u00011A\u0005\u0002\u0005m\u0007\"CA{\u0001\u0001\u0007I\u0011AA|\u0011!\tY\u0010\u0001Q!\n\u0005u\u0007\"CA\u007f\u0001\u0001\u0007I\u0011AA\u0000\u0011%\u0011i\u0001\u0001a\u0001\n\u0003\u0011y\u0001\u0003\u0005\u0003\u0014\u0001\u0001\u000b\u0015\u0002B\u0001\u0011\u001d\u0011)\u0002\u0001C\u0001\u0005/AqAa\n\u0001\t\u0003\u00119\u0002C\u0004\u00032\u0001!\tAa\u0006\t\u000f\tm\u0002\u0001\"\u0001\u0003\u0018!9!q\b\u0001\u0005\u0002\t]\u0001b\u0002B\"\u0001\u0011\u0005!q\u0003\u0005\b\u0005\u000f\u0002A\u0011\u0001B\f\u0011\u001d\u0011Y\u0005\u0001C\u0001\u0005/AqAa\u0014\u0001\t\u0003\u00119\u0002C\u0004\u0003T\u0001!\tAa\u0006\t\u000f\t]\u0003\u0001\"\u0001\u0003\u0018!9!1\f\u0001\u0005\u0002\t]\u0001b\u0002B0\u0001\u0011\u0005!q\u0003\u0005\b\u0005o\u0002A\u0011\u0001B\f\u0011\u001d\u0011Y\b\u0001C\u0001\u0005/AqAa \u0001\t\u0003\u00119\u0002C\u0004\u0003\u0004\u0002!\tAa\u0006\t\u000f\t\u001d\u0005\u0001\"\u0001\u0003\u0018!9!1\u0012\u0001\u0005\u0002\t]\u0001b\u0002BH\u0001\u0011\u0005!q\u0003\u0005\b\u0005'\u0003A\u0011\u0001B\f\u0011\u001d\u00119\n\u0001C\u0001\u0005/AqAa'\u0001\t\u0003\u00119\u0002C\u0004\u0003 \u0002!\tAa\u0006\t\u000f\t\r\u0006\u0001\"\u0003\u0003&\"9!1\u0016\u0001\u0005\n\t5\u0006b\u0002BY\u0001\u0011%!1\u0017\u0005\b\u0005\u0007\u0004A\u0011\u0002Bc\u0011\u001d\u0011Y\r\u0001C\u0005\u0005\u001bDqA!5\u0001\t\u0013\u0011\u0019\u000eC\u0005\u0003b\u0002\t\n\u0011\"\u0003\u0003d\"I!\u0011 \u0001\u0012\u0002\u0013%!1 \u0005\b\u0005\u007f\u0004A\u0011BB\u0001\u0011\u001d\u0019\u0019\u0002\u0001C\u0005\u0007+Aqa!\u0007\u0001\t\u0003\u00119BA\u000eUe\u0006t7/Y2uS>t7\u000b^1uK6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003)V\u000b1\u0002\u001e:b]N\f7\r^5p]*\u0011akV\u0001\fG>|'\u000fZ5oCR|'OC\u0001Y\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A.\u0011\u0005q{V\"A/\u000b\u0003y\u000bQa]2bY\u0006L!\u0001Y/\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t1\r\u0005\u0002e\u00015\t1+A\u0006qCJ$\u0018\u000e^5p]&#W#A4\u0011\u0005qC\u0017BA5^\u0005\rIe\u000e^\u0001\ra\u0006\u0014H/\u001b;j_:LE\rI\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\u0002\u001d9,X\u000eU1si&$\u0018n\u001c8tA\u0005!BO]1og\u0006\u001cG/[8o)&lWm\\;u\u001bN\fQ\u0003\u001e:b]N\f7\r^5p]RKW.Z8vi6\u001b\b%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0003E\u0004\"A\u001d>\u000e\u0003MT!\u0001^;\u0002\r\r|W.\\8o\u0015\tAfO\u0003\u0002xq\u00061\u0011\r]1dQ\u0016T\u0011!_\u0001\u0004_J<\u0017BA>t\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eI\u0001\u0011G>|'\u000fZ5oCR|'/\u00129pG\"\f\u0011cY8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195!\u0003)!\bP\u001c*fG>\u0014Hm]\u000b\u0003\u0003\u0007\u0001b!!\u0002\u0002\u0010\u0005MQBAA\u0004\u0015\u0011\tI!a\u0003\u0002\u000f5,H/\u00192mK*\u0019\u0011QB/\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0012\u0005\u001d!aC!se\u0006L()\u001e4gKJ\u0004B!!\u0006\u0002\u001c5\u0011\u0011q\u0003\u0006\u0004\u00033\u0019\u0018A\u0002:fG>\u0014H-\u0003\u0003\u0002\u001e\u0005]!\u0001D*j[BdWMU3d_J$\u0017a\u0003;y]J+7m\u001c:eg\u0002\nA\u0001^5nKV\u0011\u0011Q\u0005\t\u0005\u0003O\ti#\u0004\u0002\u0002*)\u0019\u00111F:\u0002\u000bU$\u0018\u000e\\:\n\t\u0005=\u0012\u0011\u0006\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u0005I1o\u00195fIVdWM]\u000b\u0003\u0003o\u0001B!!\u000f\u0002>5\u0011\u00111\b\u0006\u0004\u0003W9\u0016\u0002BA \u0003w\u0011Q\"T8dWN\u001b\u0007.\u001a3vY\u0016\u0014\u0018AC:dQ\u0016$W\u000f\\3sA\u0005A!p[\"mS\u0016tG/\u0006\u0002\u0002HA!\u0011\u0011JA(\u001b\t\tYEC\u0002\u0002N]\u000b!A_6\n\t\u0005E\u00131\n\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\u0002\u0013i\\7\t\\5f]R\u0004\u0013A\u0004:fa2L7-Y'b]\u0006<WM]\u000b\u0003\u00033\u0002B!a\u0017\u0002b5\u0011\u0011Q\f\u0006\u0004\u0003?:\u0016AB:feZ,'/\u0003\u0003\u0002d\u0005u#A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA\u00059Q.\u001a;sS\u000e\u001cXCAA6!\u0011\ti'!\u001d\u000e\u0005\u0005=$bAA4g&!\u00111OA8\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\nibt7i\u001c8gS\u001e,\"!a\u001f\u0011\u0007\u0011\fi(C\u0002\u0002\u0000M\u0013\u0011\u0003\u0016:b]N\f7\r^5p]\u000e{gNZ5h\u0003)!\bP\\\"p]\u001aLw\rI\u0001\u0013iJ\fgn]1di&|g.T1oC\u001e,'/\u0006\u0002\u0002\bB\u0019A-!#\n\u0007\u0005-5KA\fUe\u0006t7/Y2uS>t7\u000b^1uK6\u000bg.Y4fe\u0006\u0019BO]1og\u0006\u001cG/[8o\u001b\u0006t\u0017mZ3sA\u0005\u0001BO]1og\u0006\u001cG/[8oC2LE-M\u000b\u0003\u0003'\u0003B!!&\u0002$:!\u0011qSAP!\r\tI*X\u0007\u0003\u00037S1!!(Z\u0003\u0019a$o\\8u}%\u0019\u0011\u0011U/\u0002\rA\u0013X\rZ3g\u0013\u0011\t)+a*\u0003\rM#(/\u001b8h\u0015\r\t\t+X\u0001\u0012iJ\fgn]1di&|g.\u00197JIF\u0002\u0013\u0001\u0005;sC:\u001c\u0018m\u0019;j_:\fG.\u001333\u0003E!(/\u00198tC\u000e$\u0018n\u001c8bY&#'\u0007I\u0001\u0014ibtW*Z:tC\u001e,7*Z=CsR,7/M\u000b\u0003\u0003g\u0003R\u0001XA[\u0003sK1!a.^\u0005\u0015\t%O]1z!\ra\u00161X\u0005\u0004\u0003{k&\u0001\u0002\"zi\u0016\fA\u0003\u001e=o\u001b\u0016\u001c8/Y4f\u0017\u0016L()\u001f;fgF\u0002\u0013a\u0005;y]6+7o]1hK.+\u0017PQ=uKN\u0014\u0014\u0001\u0006;y]6+7o]1hK.+\u0017PQ=uKN\u0014\u0004%A\u0006qe>$WoY3s\u0013\u0012\u001cXCAAe!!\tY-!4\u0002\u0014\u0006EWBAA\u0006\u0013\u0011\ty-a\u0003\u0003\u00075\u000b\u0007\u000fE\u0002]\u0003'L1!!6^\u0005\u0011auN\\4\u0002\u0019A\u0014x\u000eZ;dKJLEm\u001d\u0011\u0002\u0019QDh.T3uC\u0012\fG/Y\u0019\u0016\u0005\u0005u\u0007c\u00013\u0002`&\u0019\u0011\u0011]*\u0003'Q\u0013\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1\u0002!QDh.T3uC\u0012\fG/Y\u0019`I\u0015\fH\u0003BAt\u0003[\u00042\u0001XAu\u0013\r\tY/\u0018\u0002\u0005+:LG\u000fC\u0005\u0002p\u001e\n\t\u00111\u0001\u0002^\u0006\u0019\u0001\u0010J\u0019\u0002\u001bQDh.T3uC\u0012\fG/Y\u0019!\u00031!\bP\\'fi\u0006$\u0017\r^13\u0003A!\bP\\'fi\u0006$\u0017\r^13?\u0012*\u0017\u000f\u0006\u0003\u0002h\u0006e\b\"CAxU\u0005\u0005\t\u0019AAo\u00035!\bP\\'fi\u0006$\u0017\r^13A\u0005iQ\r\u001f9fGR,G-\u0012:s_J,\"A!\u0001\u0011\t\t\r!\u0011B\u0007\u0003\u0005\u000bQ1Aa\u0002t\u0003!\u0001(o\u001c;pG>d\u0017\u0002\u0002B\u0006\u0005\u000b\u0011a!\u0012:s_J\u001c\u0018!E3ya\u0016\u001cG/\u001a3FeJ|'o\u0018\u0013fcR!\u0011q\u001dB\t\u0011%\ty/LA\u0001\u0002\u0004\u0011\t!\u0001\bfqB,7\r^3e\u000bJ\u0014xN\u001d\u0011\u0002\u000bM,G/\u00169\u0015\u0005\u0005\u001d\bfA\u0018\u0003\u001cA!!Q\u0004B\u0012\u001b\t\u0011yBC\u0002\u0003\"a\fQA[;oSRLAA!\n\u0003 \t1!)\u001a4pe\u0016\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004a\t-\u0002\u0003\u0002B\u000f\u0005[IAAa\f\u0003 \t)\u0011I\u001a;fe\u0006qB/Z:u-\u0006d\u0017\u000eZ1uKR\u0013\u0018M\\:bGRLwN\u001c+j[\u0016|W\u000f\u001e\u0015\u0004c\tU\u0002\u0003\u0002B\u000f\u0005oIAA!\u000f\u0003 \t!A+Z:u\u00039!Xm\u001d;BI\u0012<U\r\u001e)jIND3A\rB\u001b\u0003%\"Xm\u001d;M_\u0006$\u0017I\u001c3SK6|g/\u001a+sC:\u001c\u0018m\u0019;j_:\u001chi\u001c:QCJ$\u0018\u000e^5p]\"\u001a1G!\u000e\u0002SQ,7\u000f^\"p[BdW\r^3Ue\u0006t7/\u001b;j_:<\u0006.\u001a8BaB,g\u000eZ*vG\u000e,W\rZ3eQ\r!$QG\u0001-i\u0016\u001cH/\u00119qK:$g)Y5m)>\u001cun\u001c:eS:\fGo\u001c:O_R\fe/Y5mC\ndW-\u0012:s_JD3!\u000eB\u001b\u0003\r\"Xm\u001d;BaB,g\u000e\u001a$bS2$vNT8u\u0007>|'\u000fZ5oCR|'/\u0012:s_JD3A\u000eB\u001b\u0003\u001d\"Xm\u001d;BaB,g\u000e\u001a$bS2$vnQ8pe\u0012Lg.\u0019;pe2{\u0017\rZ5oO\u0016\u0013(o\u001c:)\u0007]\u0012)$\u0001\u000fuKN$\u0018\t\u001d9f]\u00124\u0015-\u001b7U_Vs7N\\8x]\u0016\u0013(o\u001c:)\u0007a\u0012)$A\u0013uKN$\b+\u001a8eS:<7\u000b^1uK:{GOU3tKR|eNU3uef\f\u0005\u000f]3oI\"\u001a\u0011H!\u000e\u0002[Q,7\u000f^!qa\u0016tG\r\u0016:b]N\f7\r^5p]R{Gj\\4XQ&dW\r\u0015:pIV\u001cWM\u001d$f]\u000e,G\rK\u0002;\u0005k\t!\u0007^3ti\u0006\u0003\b/\u001a8e)J\fgn]1di&|g\u000eV8M_\u001e<\u0006.\u001b7f!\u0016tG-\u001b8h'R\fG/Z\"iC:<W\r\u001a\u0015\bw\tU\"1\rB3\u0003!)\u0007\u0010]3di\u0016$7E\u0001B4!\u0011\u0011IGa\u001d\u000e\u0005\t-$\u0002\u0002B7\u0005_\nA\u0001\\1oO*\u0011!\u0011O\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003v\t-$!F%mY\u0016<\u0017\r\\*uCR,W\t_2faRLwN\\\u0001@g\"|W\u000f\u001c3SKR,(O\u001c(pi\u000e{wN]5e]\u0006$xN]#se>\u0014\u0018J\u001a+sC:\u001c\u0018m\u0019;j_:LE\rU1si&$\u0018n\u001c8O_R|uO\\3eQ\ra$QG\u00017g\"|W\u000f\u001c3P]2L8i\u001c8tS\u0012,'\u000f\u0016:b]N\f7\r^5p]NLe\u000e\u00165f\u001f:<w.\u001b8h'R\fG/\u001a+p\u0003\n|'\u000f\u001e\u0015\u0004{\tU\u0012\u0001O:i_VdGm\u0016:ji\u0016$\u0006P\\'be.,'o\u001d$peR\u0013\u0018M\\:bGRLwN\\%o!J,\u0007/\u0019:fI\u000e{W.\\5u'R\fG/\u001a\u0015\u0004}\tU\u0012aN:i_VdGm\u0016:ji\u0016$\u0006P\\'be.,'o\u001d$peR\u0013\u0018M\\:bGRLwN\\%o!J,\u0007/\u0019:fI\u0006\u0013wN\u001d;Ti\u0006$X\rK\u0002@\u0005k\t!g\u001d5pk2$'+Z7pm\u0016\u001cu.\u001c9mKR,7i\\7n[&$X\t\u001f9je\u0016$GK]1og\u0006\u001cG/[8oC2LEm\u001d\u0015\u0004\u0001\nU\u0012\u0001M:i_VdGMU3n_Z,7i\\7qY\u0016$X-\u00112peR,\u0005\u0010]5sK\u0012$&/\u00198tC\u000e$\u0018n\u001c8bY&#7\u000fK\u0002B\u0005k\t\u0001f\u001d5pk2$'+Z7pm\u0016,U\u000e\u001d;z\u000bb\u0004\u0018N]3e)J\fgn]1di&|g.\u00197JIND3A\u0011B\u001b\u0003Y\u001a\bn\\;mI:{GOU3n_Z,W\t\u001f9je\u0016$GK]1og\u0006\u001cG/[8oC2LEm]%g\u0019><\u0017\t\u001d9f]\u00124\u0015-\u001b7tQ\r\u0019%QG\u0001'g\"|W\u000f\u001c3O_R\u0014V-\\8wK>swm\\5oOR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012\u001c\bf\u0001#\u00036\u0005Y3\u000f[8vY\u0012tu\u000e\u001e*f[>4X\r\u0015:fa\u0006\u0014X-\u00112peR$&/\u00198tC\u000e$\u0018n\u001c8bY&#7\u000fK\u0002F\u0005k\tAf\u001d5pk2$gj\u001c;SK6|g/\u001a)sKB\f'/Z\"p[6LG\u000f\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ:)\u0007\u0019\u0013)$\u0001\u0012wKJLg-_'fi\u0006$\u0017\r^1E_\u0016\u001cX\t_5ti\u0006sG-S:Vg\u0006\u0014G.\u001a\u000b\u0005\u0003O\u00149\u000bC\u0004\u0003*\u001e\u0003\r!a%\u0002\u001fQ\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\f\u0011D^3sS\u001aLX*\u001a;bI\u0006$\u0018\rR8fg:$X\t_5tiR!\u0011q\u001dBX\u0011\u001d\u0011I\u000b\u0013a\u0001\u0003'\u000bAe]3ukB\fe\u000e\u001a*v]R\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012,\u0005\u0010]5sCRLwN\u001c\u000b\u0007\u0003O\u0014)L!/\t\u000f\t]\u0016\n1\u0001\u0003\u0002\u0005)QM\u001d:pe\"9!1X%A\u0002\tu\u0016\u0001\u0003;y]N#\u0018\r^3\u0011\u0007\u0011\u0014y,C\u0002\u0003BN\u0013\u0001\u0003\u0016:b]N\f7\r^5p]N#\u0018\r^3\u0002IY,'/\u001b4z/JLG/Z:Uq:l\u0015M]6feNLe\u000e\u0015:fa\u0006\u0014Xm\u0015;bi\u0016$B!a:\u0003H\"9!\u0011\u001a&A\u0002\tu\u0016!B:uCR,\u0017AD1tg\u0016\u0014HoQ1mY\n\f7m\u001b\u000b\u0005\u0003O\u0014y\rC\u0004\u00038.\u0003\rA!\u0001\u0002'Q\u0014\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1\u0015\u0015\u0005u'Q\u001bBl\u00057\u0014i\u000eC\u0004\u0003*2\u0003\r!a%\t\u000f\teG\n1\u0001\u0002R\u0006Q\u0001O]8ek\u000e,'/\u00133\t\u0013\t%G\n%AA\u0002\tu\u0006\u0002\u0003Bp\u0019B\u0005\t\u0019A4\u0002\u0015QDh\u000eV5nK>,H/A\u000fue\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011)O\u000b\u0003\u0003>\n\u001d8F\u0001Bu!\u0011\u0011YO!>\u000e\u0005\t5(\u0002\u0002Bx\u0005c\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tMX,\u0001\u0006b]:|G/\u0019;j_:LAAa>\u0003n\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002;Q\u0014\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1%I\u00164\u0017-\u001e7uIQ*\"A!@+\u0007\u001d\u00149/A\u0007qe\u0016\u0004\u0018M]3Uq:dun\u001a\u000b\t\u0003O\u001c\u0019a!\u0002\u0004\n!)qn\u0014a\u0001c\"91qA(A\u0002\u0005E\u0017aC:uCJ$xJ\u001a4tKRDqaa\u0003P\u0001\u0004\u0019i!A\u0004sK\u000e|'\u000fZ:\u0011\t\u0005U1qB\u0005\u0005\u0007#\t9BA\u0007NK6|'/\u001f*fG>\u0014Hm]\u0001\u001baJ,\u0007/\u0019:f\r>\u0014H\u000b\u001f8NKN\u001c\u0018mZ3BaB,g\u000e\u001a\u000b\u0005\u0003O\u001c9\u0002C\u0004\u00038B\u0003\rA!\u0001\u0002/Q,7\u000f\u001e)beRLG/[8o\u0019>\fG-T3ue&\u001c\u0007fA)\u00036\u0001")
public class TransactionStateManagerTest {
    private final int partitionId;
    private final int numPartitions;
    private final int transactionTimeoutMs;
    private final TopicPartition topicPartition = new TopicPartition("__transaction_state", this.partitionId());
    private final int coordinatorEpoch;
    private final ArrayBuffer<SimpleRecord> txnRecords = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final MockTime time = new MockTime();
    private final MockScheduler scheduler = new MockScheduler((Time)this.time());
    private final KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
    private final ReplicaManager replicaManager = (ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class);
    private final Metrics metrics;
    private final TransactionConfig txnConfig;
    private final TransactionStateManager transactionManager;
    private final String transactionalId1;
    private final String transactionalId2;
    private final byte[] txnMessageKeyBytes1;
    private final byte[] txnMessageKeyBytes2;
    private final Map<String, Object> producerIds;
    private TransactionMetadata txnMetadata1;
    private TransactionMetadata txnMetadata2;
    private Errors expectedError;

    public int partitionId() {
        return this.partitionId;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public int transactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    public ArrayBuffer<SimpleRecord> txnRecords() {
        return this.txnRecords;
    }

    public MockTime time() {
        return this.time;
    }

    public MockScheduler scheduler() {
        return this.scheduler;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public TransactionConfig txnConfig() {
        return this.txnConfig;
    }

    public TransactionStateManager transactionManager() {
        return this.transactionManager;
    }

    public String transactionalId1() {
        return this.transactionalId1;
    }

    public String transactionalId2() {
        return this.transactionalId2;
    }

    public byte[] txnMessageKeyBytes1() {
        return this.txnMessageKeyBytes1;
    }

    public byte[] txnMessageKeyBytes2() {
        return this.txnMessageKeyBytes2;
    }

    public Map<String, Object> producerIds() {
        return this.producerIds;
    }

    public TransactionMetadata txnMetadata1() {
        return this.txnMetadata1;
    }

    public void txnMetadata1_$eq(TransactionMetadata x$1) {
        this.txnMetadata1 = x$1;
    }

    public TransactionMetadata txnMetadata2() {
        return this.txnMetadata2;
    }

    public void txnMetadata2_$eq(TransactionMetadata x$1) {
        this.txnMetadata2 = x$1;
    }

    public Errors expectedError() {
        return this.expectedError;
    }

    public void expectedError_$eq(Errors x$1) {
        this.expectedError = x$1;
    }

    @Before
    public void setUp() {
        Assert.assertEquals((long)this.partitionId(), (long)this.transactionManager().partitionFor(this.transactionalId1()));
        Assert.assertEquals((long)this.partitionId(), (long)this.transactionManager().partitionFor(this.transactionalId2()));
    }

    @After
    public void tearDown() {
        EasyMock.reset((Object[])new Object[]{this.zkClient(), this.replicaManager()});
        this.transactionManager().shutdown();
    }

    @Test
    public void testValidateTransactionTimeout() {
        Assert.assertTrue((boolean)this.transactionManager().validateTransactionTimeoutMs(1));
        Assert.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(-1));
        Assert.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(0));
        Assert.assertTrue((boolean)this.transactionManager().validateTransactionTimeoutMs(this.txnConfig().transactionMaxTimeoutMs()));
        Assert.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(this.txnConfig().transactionMaxTimeoutMs() + 1));
    }

    @Test
    public void testAddGetPids() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1())), (Object)this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1()));
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1())), (Object)this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata2()));
    }

    @Test
    public void testLoadAndRemoveTransactionsForPartition() {
        this.txnMetadata1().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0), new TopicPartition("topic2", 1), new TopicPartition("topic2", 2)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata2().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic3", 0), new TopicPartition("topic3", 1), new TopicPartition("topic3", 2)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)PrepareAbort$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)CompleteAbort$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)Empty$.MODULE$);
        this.txnMetadata2().topicPartitions().clear();
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        long startOffset = 15L;
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), startOffset, records);
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$1(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$1 -> Assertions$.MODULE$.fail(new StringBuilder(44).append(this.transactionalId1()).append("'s transaction state is already in the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170)));
        this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$3(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$2 -> Assertions$.MODULE$.fail(new StringBuilder(44).append(this.transactionalId2()).append("'s transaction state is already in the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174)));
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function5 & Serializable & scala.Serializable)(x$3, x$4, x$5, x$6, x$7) -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$5(x$3, BoxesRunTime.unboxToInt((Object)x$4), x$5, x$6, x$7);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> Assertions$.MODULE$.fail(new StringBuilder(42).append(this.transactionalId1()).append("'s transaction state access returns error ").append(err).toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183)), (Function1 & Serializable & scala.Serializable)entry -> (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0 & Serializable & scala.Serializable)() -> Assertions$.MODULE$.fail(new StringBuilder(50).append(this.transactionalId1()).append("'s transaction state was not loaded into the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184))));
        CoordinatorEpochAndTxnMetadata cachedPidMetadata1 = (CoordinatorEpochAndTxnMetadata)this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> Assertions$.MODULE$.fail(new StringBuilder(42).append(this.transactionalId1()).append("'s transaction state access returns error ").append(err).toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188)), (Function1 & Serializable & scala.Serializable)entry -> (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0 & Serializable & scala.Serializable)() -> Assertions$.MODULE$.fail(new StringBuilder(50).append(this.transactionalId1()).append("'s transaction state was not loaded into the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189))));
        CoordinatorEpochAndTxnMetadata cachedPidMetadata2 = (CoordinatorEpochAndTxnMetadata)this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1 & Serializable & scala.Serializable)err -> Assertions$.MODULE$.fail(new StringBuilder(42).append(this.transactionalId2()).append("'s transaction state access returns error ").append(err).toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192)), (Function1 & Serializable & scala.Serializable)entry -> (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0 & Serializable & scala.Serializable)() -> Assertions$.MODULE$.fail(new StringBuilder(50).append(this.transactionalId2()).append("'s transaction state was not loaded into the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193))));
        Assert.assertEquals((Object)this.txnMetadata1(), (Object)cachedPidMetadata1.transactionMetadata());
        Assert.assertEquals((Object)this.txnMetadata2(), (Object)cachedPidMetadata2.transactionMetadata());
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.scheduler().tick();
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$15(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$8 -> Assertions$.MODULE$.fail(new StringBuilder(42).append(this.transactionalId1()).append("'s transaction state is still in the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207)));
        this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$17(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$9 -> Assertions$.MODULE$.fail(new StringBuilder(42).append(this.transactionalId2()).append("'s transaction state is still in the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211)));
    }

    @Test
    public void testCompleteTransitionWhenAppendSucceeded() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.NONE);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), this.coordinatorEpoch(), newMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testAppendFailToCoordinatorNotAvailableError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_NOT_AVAILABLE);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.UNKNOWN_TOPIC_OR_PARTITION);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_ENOUGH_REPLICAS);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.REQUEST_TIMED_OUT);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testAppendFailToNotCoordinatorError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.expectedError_$eq(Errors.NOT_COORDINATOR);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_LEADER_FOR_PARTITION);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch() + 1, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test
    public void testAppendFailToCoordinatorLoadingError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_LOAD_IN_PROGRESS);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadingPartition(this.partitionId(), this.coordinatorEpoch() + 1);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test
    public void testAppendFailToUnknownError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.expectedError_$eq(Errors.UNKNOWN_SERVER_ERROR);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.MESSAGE_TOO_LARGE);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.RECORD_LIST_TOO_LARGE);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testPendingStateNotResetOnRetryAppend() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_NOT_AVAILABLE);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.UNKNOWN_TOPIC_OR_PARTITION);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$testPendingStateNotResetOnRetryAppend$2(x$10)));
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertEquals((Object)new Some((Object)Ongoing$.MODULE$), (Object)this.txnMetadata1().pendingState());
    }

    @Test
    public void testAppendTransactionToLogWhileProducerFenced() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.NOT_COORDINATOR);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.txnMetadata1().producerEpoch_$eq((short)(this.txnMetadata1().producerEpoch() + 1));
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, newMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test(expected=IllegalStateException.class)
    public void testAppendTransactionToLogWhilePendingStateChanged() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.INVALID_PRODUCER_EPOCH);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.txnMetadata1().pendingState_$eq((Option)None$.MODULE$);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, newMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test
    public void shouldReturnNotCooridnatorErrorIfTransactionIdPartitionNotOwned() {
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$shouldReturnNotCooridnatorErrorIfTransactionIdPartitionNotOwned$1(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$11 -> Assertions$.MODULE$.fail(new StringBuilder(44).append(this.transactionalId1()).append("'s transaction state is already in the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389)));
    }

    @Test
    public void shouldOnlyConsiderTransactionsInTheOngoingStateToAbort() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> this.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1())));
        this.transactionManager().putTransactionStateIfNotExists("ongoing", this.transactionMetadata("ongoing", 0L, (TransactionState)Ongoing$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists("not-expiring", this.transactionMetadata("not-expiring", 1L, (TransactionState)Ongoing$.MODULE$, 10000));
        this.transactionManager().putTransactionStateIfNotExists("prepare-commit", this.transactionMetadata("prepare-commit", 2L, (TransactionState)PrepareCommit$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists("prepare-abort", this.transactionMetadata("prepare-abort", 3L, (TransactionState)PrepareAbort$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists("complete-commit", this.transactionMetadata("complete-commit", 4L, (TransactionState)CompleteCommit$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists("complete-abort", this.transactionMetadata("complete-abort", 5L, (TransactionState)CompleteAbort$.MODULE$, this.transactionMetadata$default$4()));
        this.time().sleep(2000L);
        Iterable expiring = this.transactionManager().timedOutTransactions();
        Assert.assertEquals((Object)new .colon.colon((Object)new TransactionalIdAndProducerIdEpoch("ongoing", 0L, 0), (List)Nil$.MODULE$), (Object)expiring);
    }

    @Test
    public void shouldWriteTxnMarkersForTransactionInPreparedCommitState() {
        this.verifyWritesTxnMarkersInPrepareState((TransactionState)PrepareCommit$.MODULE$);
    }

    @Test
    public void shouldWriteTxnMarkersForTransactionInPreparedAbortState() {
        this.verifyWritesTxnMarkersInPrepareState((TransactionState)PrepareAbort$.MODULE$);
    }

    @Test
    public void shouldRemoveCompleteCommmitExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)CompleteCommit$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldRemoveCompleteAbortExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)CompleteAbort$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldRemoveEmptyExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)Empty$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemoveExpiredTransactionalIdsIfLogAppendFails() {
        this.setupAndRunTransactionalIdExpiration(Errors.NOT_ENOUGH_REPLICAS, (TransactionState)CompleteAbort$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemoveOngoingTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)Ongoing$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemovePrepareAbortTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)PrepareAbort$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemovePrepareCommitTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)PrepareCommit$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    private void verifyMetadataDoesExistAndIsUsable(String transactionalId) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either either = this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Left) {
            throw Assertions$.MODULE$.fail("shouldn't have been any errors", new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 472));
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                throw Assertions$.MODULE$.fail("metadata should have been removed", new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 473));
            }
        }
        if (!bl || !((option = (Option)right.value()) instanceof Some)) {
            throw new MatchError((Object)either);
        }
        Some some = (Some)option;
        CoordinatorEpochAndTxnMetadata metadata = (CoordinatorEpochAndTxnMetadata)some.value();
        Assert.assertTrue((String)"metadata shouldn't be in a pending state", (boolean)metadata.transactionMetadata().pendingState().isEmpty());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void verifyMetadataDoesntExist(String transactionalId) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either either = this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Left) {
            throw Assertions$.MODULE$.fail("shouldn't have been any errors", new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 481));
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (option2 instanceof Some) {
                throw Assertions$.MODULE$.fail("metadata should have been removed", new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 482));
            }
        }
        if (!bl || !None$.MODULE$.equals(option = (Option)right.value())) {
            throw new MatchError((Object)either);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void setupAndRunTransactionalIdExpiration(Errors error, TransactionState txnState) {
        BoxedUnit boxedUnit;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> this.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1())));
        Capture capturedArgument = EasyMock.newCapture();
        TopicPartition partition = new TopicPartition("__transaction_state", this.transactionManager().partitionFor(this.transactionalId1()));
        Map recordsByPartition = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)MemoryRecords.withRecords((CompressionType)TransactionLog$.MODULE$.EnforcedCompressionType(), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds() + (long)this.txnConfig().removeExpiredTransactionalIdsIntervalMs(), TransactionLog$.MODULE$.keyToBytes(this.transactionalId1()), null)}))}));
        TransactionState transactionState = txnState;
        boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState));
        if (bl) {
            this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.eq((short)((short)-1)), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false), (Map)EasyMock.eq((Object)recordsByPartition), (Function1)EasyMock.capture((Capture)capturedArgument), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
            boxedUnit = EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, capturedArgument, partition, error){
                private final Capture capturedArgument$1;
                private final TopicPartition partition$1;
                private final Errors error$1;

                public void answer() {
                    ((Function1)this.capturedArgument$1.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition$1), (Object)new ProduceResponse.PartitionResponse(this.error$1, 0L, -1L, 0L))})));
                }
                {
                    this.capturedArgument$1 = capturedArgument$1;
                    this.partition$1 = partition$1;
                    this.error$1 = error$1;
                }
            });
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.txnMetadata1().txnLastUpdateTimestamp_$eq(this.time().milliseconds() - (long)this.txnConfig().transactionalIdExpirationMs());
        this.txnMetadata1().state_$eq(txnState);
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.txnMetadata2().txnLastUpdateTimestamp_$eq(this.time().milliseconds());
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId2(), this.txnMetadata2());
        this.transactionManager().enableTransactionalIdExpiration();
        this.time().sleep((long)this.txnConfig().removeExpiredTransactionalIdsIntervalMs());
        this.scheduler().tick();
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    private void verifyWritesTxnMarkersInPrepareState(TransactionState state) {
        this.txnMetadata1().state_$eq(state);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        long startOffset = 0L;
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        ObjectRef txnId = ObjectRef.create(null);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function5 & Serializable & scala.Serializable)(transactionalId, coordinatorEpoch, command, metadata, newMetadata) -> {
            TransactionStateManagerTest.rememberTxnMarkers$1(transactionalId, BoxesRunTime.unboxToInt((Object)coordinatorEpoch), command, metadata, newMetadata, txnId);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        Assert.assertEquals((Object)this.transactionalId1(), (Object)((String)txnId.elem));
    }

    private void assertCallback(Errors error) {
        Assert.assertEquals((Object)this.expectedError(), (Object)error);
    }

    private TransactionMetadata transactionMetadata(String transactionalId, long producerId, TransactionState state, int txnTimeout) {
        return TransactionMetadata$.MODULE$.apply(transactionalId, producerId, (short)0, txnTimeout, state, this.time().milliseconds());
    }

    private TransactionState transactionMetadata$default$3() {
        return Empty$.MODULE$;
    }

    private int transactionMetadata$default$4() {
        return this.transactionTimeoutMs();
    }

    private void prepareTxnLog(TopicPartition topicPartition, long startOffset, MemoryRecords records) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Log logMock = (Log)EasyMock.mock(Log.class);
        FileRecords fileRecordsMock = (FileRecords)EasyMock.mock(FileRecords.class);
        long endOffset = startOffset + (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size();
        EasyMock.expect((Object)this.replicaManager().getLog(topicPartition)).andStubReturn((Object)new Some((Object)logMock));
        EasyMock.expect((Object)this.replicaManager().getLogEndOffset(topicPartition)).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).andStubReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        EasyMock.expect((Object)logMock.read(EasyMock.eq((long)startOffset), EasyMock.anyInt(), (FetchIsolation)EasyMock.eq((Object)FetchLogEnd$.MODULE$), EasyMock.eq((boolean)true))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)fileRecordsMock, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()));
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)fileRecordsMock.sizeInBytes())).andStubReturn((Object)BoxesRunTime.boxToInteger((int)records.sizeInBytes()));
        Capture bufferCapture = EasyMock.newCapture();
        fileRecordsMock.readInto((ByteBuffer)EasyMock.capture((Capture)bufferCapture), EasyMock.anyInt());
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, bufferCapture, records){
            private final Capture bufferCapture$1;
            private final MemoryRecords records$1;

            public void answer() {
                ByteBuffer buffer = (ByteBuffer)this.bufferCapture$1.getValue();
                buffer.put(this.records$1.buffer().duplicate());
                buffer.flip();
            }
            {
                this.bufferCapture$1 = bufferCapture$1;
                this.records$1 = records$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{logMock, fileRecordsMock, this.replicaManager()});
    }

    private void prepareForTxnMessageAppend(Errors error) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Capture capturedArgument = EasyMock.newCapture();
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false), (Map)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)capturedArgument), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, capturedArgument, error){
            private final /* synthetic */ TransactionStateManagerTest $outer;
            private final Capture capturedArgument$2;
            private final Errors error$2;

            public void answer() {
                ((Function1)this.capturedArgument$2.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("__transaction_state", this.$outer.partitionId())), (Object)new ProduceResponse.PartitionResponse(this.error$2, 0L, -1L, 0L))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.capturedArgument$2 = capturedArgument$2;
                this.error$2 = error$2;
            }
        });
        EasyMock.expect((Object)this.replicaManager().getMagic((TopicPartition)EasyMock.anyObject())).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)1)));
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testPartitionLoadMetric() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        String mBeanName = "kafka.server:type=transaction-coordinator-metrics";
        JmxReporter reporter = new JmxReporter("kafka.server");
        this.metrics().addReporter((MetricsReporter)reporter);
        Assert.assertTrue((boolean)server.isRegistered(new ObjectName(mBeanName)));
        Assert.assertEquals((double)Double.NaN, (double)TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-max", server, mBeanName), (double)0.0);
        Assert.assertEquals((double)Double.NaN, (double)TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-avg", server, mBeanName), (double)0.0);
        Assert.assertTrue((boolean)reporter.containsMbean(mBeanName));
        this.txnMetadata1().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 1), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        long startOffset = 15L;
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), startOffset, records);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function5 & Serializable & scala.Serializable)(x$12, x$13, x$14, x$15, x$16) -> {
            TransactionStateManagerTest.$anonfun$testPartitionLoadMetric$1(x$12, BoxesRunTime.unboxToInt((Object)x$13), x$14, x$15, x$16);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        Assert.assertTrue((TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-max", server, mBeanName) >= 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-avg", server, mBeanName) >= 0.0 ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$1(Errors err) {
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$3(Errors err) {
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$5(String x$3, int x$4, TransactionResult x$5, TransactionMetadata x$6, TxnTransitMetadata x$7) {
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$15(Errors err) {
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$17(Errors err) {
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ boolean $anonfun$testPendingStateNotResetOnRetryAppend$2(Errors x$10) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$shouldReturnNotCooridnatorErrorIfTransactionIdPartitionNotOwned$1(Errors err) {
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    private static final void rememberTxnMarkers$1(String transactionalId, int coordinatorEpoch, TransactionResult command, TransactionMetadata metadata, TxnTransitMetadata newMetadata, ObjectRef txnId$1) {
        txnId$1.elem = transactionalId;
    }

    private static final double partitionLoadTime$1(String attribute, MBeanServer server$1, String mBeanName$1) {
        return BoxesRunTime.unboxToDouble((Object)server$1.getAttribute(new ObjectName(mBeanName$1), attribute));
    }

    public static final /* synthetic */ void $anonfun$testPartitionLoadMetric$1(String x$12, int x$13, TransactionResult x$14, TransactionMetadata x$15, TxnTransitMetadata x$16) {
    }

    public TransactionStateManagerTest() {
        this.partitionId = 0;
        this.numPartitions = 2;
        this.transactionTimeoutMs = 1000;
        this.coordinatorEpoch = 10;
        EasyMock.expect((Object)this.zkClient().getTopicPartitionCount("__transaction_state")).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)this.numPartitions()))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.metrics = new Metrics();
        this.txnConfig = new TransactionConfig(TransactionConfig$.MODULE$.apply$default$1(), TransactionConfig$.MODULE$.apply$default$2(), TransactionConfig$.MODULE$.apply$default$3(), TransactionConfig$.MODULE$.apply$default$4(), TransactionConfig$.MODULE$.apply$default$5(), TransactionConfig$.MODULE$.apply$default$6(), TransactionConfig$.MODULE$.apply$default$7(), TransactionConfig$.MODULE$.apply$default$8(), TransactionConfig$.MODULE$.apply$default$9(), TransactionConfig$.MODULE$.apply$default$10());
        this.transactionManager = new TransactionStateManager(0, this.zkClient(), (Scheduler)this.scheduler(), this.replicaManager(), this.txnConfig(), (Time)this.time(), this.metrics());
        this.transactionalId1 = "one";
        this.transactionalId2 = "two";
        this.txnMessageKeyBytes1 = TransactionLog$.MODULE$.keyToBytes(this.transactionalId1());
        this.txnMessageKeyBytes2 = TransactionLog$.MODULE$.keyToBytes(this.transactionalId2());
        this.producerIds = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.transactionalId1()), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.transactionalId2()), (Object)BoxesRunTime.boxToLong((long)2L))}));
        this.txnMetadata1 = this.transactionMetadata(this.transactionalId1(), BoxesRunTime.unboxToLong((Object)this.producerIds().apply((Object)this.transactionalId1())), this.transactionMetadata$default$3(), this.transactionMetadata$default$4());
        this.txnMetadata2 = this.transactionMetadata(this.transactionalId2(), BoxesRunTime.unboxToLong((Object)this.producerIds().apply((Object)this.transactionalId2())), this.transactionMetadata$default$3(), this.transactionMetadata$default$4());
        this.expectedError = Errors.NONE;
    }
}

