/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import kafka.log.CompletedTxn;
import kafka.log.Log$;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.ProducerStateManager;
import kafka.log.TxnMetadata;
import kafka.log.ValidationType;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.errors.UnknownProducerIdException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Utils;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t5g\u0001\u0002!B\u0001\u0019CQ!\u0014\u0001\u0005\u00029Cq!\u0015\u0001A\u0002\u0013\u0005!\u000bC\u0004\\\u0001\u0001\u0007I\u0011\u0001/\t\r\t\u0004\u0001\u0015)\u0003T\u0011\u001d\u0019\u0007\u00011A\u0005\u0002\u0011Dq\u0001\u001b\u0001A\u0002\u0013\u0005\u0011\u000e\u0003\u0004l\u0001\u0001\u0006K!\u001a\u0005\bY\u0002\u0011\r\u0011\"\u0001n\u0011\u0019I\b\u0001)A\u0005]\"9!\u0010\u0001b\u0001\n\u0003Y\bBB@\u0001A\u0003%A\u0010C\u0005\u0002\u0002\u0001\u0011\r\u0011\"\u0001\u0002\u0004!A\u00111\u0002\u0001!\u0002\u0013\t)\u0001C\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0001\u0002\u0010!A\u0011Q\u0004\u0001!\u0002\u0013\t\t\u0002C\u0004\u0002 \u0001!\t!!\t\t\u000f\u0005E\u0002\u0001\"\u0001\u0002\"!9\u00111\b\u0001\u0005\u0002\u0005\u0005\u0002bBA#\u0001\u0011\u0005\u0011\u0011\u0005\u0005\b\u0003\u0013\u0002A\u0011AA\u0011\u0011\u001d\ti\u0005\u0001C\u0001\u0003CAq!!\u0015\u0001\t\u0003\t\t\u0003C\u0004\u0002f\u0001!\t!!\t\t\u000f\u0005%\u0004\u0001\"\u0001\u0002\"!9\u0011Q\u000e\u0001\u0005\u0002\u0005\u0005\u0002bBA9\u0001\u0011\u0005\u0011\u0011\u0005\u0005\b\u0003k\u0002A\u0011AA\u0011\u0011\u001d\tI\b\u0001C\u0001\u0003CAq!! \u0001\t\u0003\t\t\u0003C\u0004\u0002\u0002\u0002!\t!!\t\t\u000f\u00055\u0005\u0001\"\u0001\u0002\"!9\u0011\u0011\u0013\u0001\u0005\u0002\u0005\u0005\u0002bBAK\u0001\u0011\u0005\u0011\u0011\u0005\u0005\b\u00033\u0003A\u0011AA\u0011\u0011\u001d\t)\u000b\u0001C\u0001\u0003CAq!!+\u0001\t\u0003\t\t\u0003C\u0004\u0002.\u0002!\t!!\t\t\u000f\u0005E\u0006\u0001\"\u0001\u0002\"!9\u0011Q\u0017\u0001\u0005\u0002\u0005\u0005\u0002bBA]\u0001\u0011\u0005\u0011\u0011\u0005\u0005\b\u0003{\u0003A\u0011AA\u0011\u0011\u001d\t\t\r\u0001C\u0001\u0003CAq!!2\u0001\t\u0003\t\t\u0003C\u0004\u0002J\u0002!\t!!\t\t\u000f\u00055\u0007\u0001\"\u0001\u0002\"!9\u0011\u0011\u001b\u0001\u0005\u0002\u0005\u0005\u0002bBAk\u0001\u0011\u0005\u0011\u0011\u0005\u0005\b\u0003C\u0004A\u0011AA\u0011\u0011\u001d\t)\u000f\u0001C\u0001\u0003CAq!!=\u0001\t\u0003\t\t\u0003C\u0004\u0002v\u0002!\t!!\t\t\u000f\u0005e\b\u0001\"\u0001\u0002\"!9\u0011Q \u0001\u0005\u0002\u0005\u0005\u0002b\u0002B\u0001\u0001\u0011%!1\u0001\u0005\b\u0005?\u0001A\u0011\u0002B\u0011\u0011%\u0011Y\u0006AI\u0001\n\u0013\u0011i\u0006C\u0005\u0003t\u0001\t\n\u0011\"\u0003\u0003v!9!\u0011\u0010\u0001\u0005\n\tm\u0004\"\u0003BM\u0001E\u0005I\u0011\u0002B;\u0011%\u0011Y\nAI\u0001\n\u0013\u0011i\nC\u0005\u0003\"\u0002\t\n\u0011\"\u0003\u0003\u001e\"9!\u0011\u0010\u0001\u0005\n\t\r\u0006b\u0002B]\u0001\u0011%!1\u0018\u0002\u0019!J|G-^2feN#\u0018\r^3NC:\fw-\u001a:UKN$(B\u0001\"D\u0003\rawn\u001a\u0006\u0002\t\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001H!\tA5*D\u0001J\u0015\u0005Q\u0015!B:dC2\f\u0017B\u0001'J\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u0014\t\u0003!\u0002i\u0011!Q\u0001\u0007Y><G)\u001b:\u0016\u0003M\u0003\"\u0001V-\u000e\u0003US!AV,\u0002\u0005%|'\"\u0001-\u0002\t)\fg/Y\u0005\u00035V\u0013AAR5mK\u0006QAn\\4ESJ|F%Z9\u0015\u0005u\u0003\u0007C\u0001%_\u0013\ty\u0016J\u0001\u0003V]&$\bbB1\u0004\u0003\u0003\u0005\raU\u0001\u0004q\u0012\n\u0014a\u00027pO\u0012K'\u000fI\u0001\rgR\fG/Z'b]\u0006<WM]\u000b\u0002KB\u0011\u0001KZ\u0005\u0003O\u0006\u0013A\u0003\u0015:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u0014\u0018\u0001E:uCR,W*\u00198bO\u0016\u0014x\fJ3r)\ti&\u000eC\u0004b\r\u0005\u0005\t\u0019A3\u0002\u001bM$\u0018\r^3NC:\fw-\u001a:!\u0003%\u0001\u0018M\u001d;ji&|g.F\u0001o!\tyw/D\u0001q\u0015\t\t(/\u0001\u0004d_6lwN\u001c\u0006\u0003\tNT!\u0001^;\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0018aA8sO&\u0011\u0001\u0010\u001d\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003)\u0001\u0018M\u001d;ji&|g\u000eI\u0001\u000baJ|G-^2fe&#W#\u0001?\u0011\u0005!k\u0018B\u0001@J\u0005\u0011auN\\4\u0002\u0017A\u0014x\u000eZ;dKJLE\rI\u0001\u0013[\u0006D\b+\u001b3FqBL'/\u0019;j_:l5/\u0006\u0002\u0002\u0006A\u0019\u0001*a\u0002\n\u0007\u0005%\u0011JA\u0002J]R\f1#\\1y!&$W\t\u001f9je\u0006$\u0018n\u001c8Ng\u0002\nA\u0001^5nKV\u0011\u0011\u0011\u0003\t\u0005\u0003'\tI\"\u0004\u0002\u0002\u0016)\u0019\u0011q\u00039\u0002\u000bU$\u0018\u000e\\:\n\t\u0005m\u0011Q\u0003\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u0005)1/\u001a;VaR\tQ\fK\u0002\u0011\u0003K\u0001B!a\n\u0002.5\u0011\u0011\u0011\u0006\u0006\u0004\u0003W)\u0018!\u00026v]&$\u0018\u0002BA\u0018\u0003S\u0011aAQ3g_J,\u0017\u0001\u0003;fCJ$un\u001e8)\u0007E\t)\u0004\u0005\u0003\u0002(\u0005]\u0012\u0002BA\u001d\u0003S\u0011Q!\u00114uKJ\f!\u0003^3ti\n\u000b7/[2JI6\u000b\u0007\u000f]5oO\"\u001a!#a\u0010\u0011\t\u0005\u001d\u0012\u0011I\u0005\u0005\u0003\u0007\nIC\u0001\u0003UKN$\u0018A\n;fgR\f\u0005\u000f]3oIRCh.T1sW\u0016\u0014x+\u001b;i\u001d>\u0004&o\u001c3vG\u0016\u00148\u000b^1uK\"\u001a1#a\u0010\u0002=Q,7\u000f\u001e)s_\u0012,8-\u001a:TKF,XM\\2f/J\f\u0007/\u0011:pk:$\u0007f\u0001\u000b\u0002@\u0005iC/Z:u!J|G-^2feN+\u0017/^3oG\u0016<\u0016\u000e\u001e5Xe\u0006\u0004\u0018I]8v]\u0012\u0014\u0015\r^2i%\u0016\u001cwN\u001d3)\u0007U\ty$A\u0013uKN$\bK]8ek\u000e,'oU3rk\u0016t7-Z%om\u0006d\u0017\u000eZ,sCB\f%o\\;oI\":a#a\u0010\u0002V\u0005]\u0013\u0001C3ya\u0016\u001cG/\u001a3$\u0005\u0005e\u0003\u0003BA.\u0003Cj!!!\u0018\u000b\u0007\u0005}\u0003/\u0001\u0004feJ|'o]\u0005\u0005\u0003G\niFA\u000ePkR|em\u0014:eKJ\u001cV-];f]\u000e,W\t_2faRLwN\\\u0001+i\u0016\u001cHOT8WC2LG-\u0019;j_:|eNR5sgR,e\u000e\u001e:z/\",g\u000eT8bI&tw\rT8hQ\r9\u0012qH\u0001\u001ci\u0016\u001cHoQ8oiJ|GNU3d_J$')^7qg\u0016\u0003xn\u00195)\u0007a\ty$\u0001\u0011uKN$H\u000b\u001f8GSJ\u001cHo\u00144gg\u0016$X*\u001a;bI\u0006$\u0018mQ1dQ\u0016$\u0007fA\r\u0002@\u0005\u0001C/Z:u\u0019\u0006\u001cHo\u0015;bE2,wJ\u001a4tKR\u001cu.\u001c9mKR,G\r\u0016=oQ\rQ\u0012qH\u0001\u001fi\u0016\u001cH\u000f\u0015:fa\u0006\u0014X-\u00169eCR,Gi\\3t\u001d>$X*\u001e;bi\u0016D3aGA \u0003y)\b\u000fZ1uKB\u0013x\u000eZ;dKJ$&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X\rK\u0002\u001d\u0003\u007f\tA\u0006^3ti>+Ho\u00144TKF,XM\\2f\u0003\u001a$XM]\"p]R\u0014x\u000e\u001c*fG>\u0014H-\u00129pG\"\u0014U/\u001c9)\u0007u\ty$\u0001\u0019uKN$hj\u001c8Ue\u0006t7/Y2uS>t\u0017\r\\!qa\u0016tGmV5uQ>swm\\5oOR\u0013\u0018M\\:bGRLwN\u001c\u0015\b=\u0005}\u0012QKACG\t\t9\t\u0005\u0003\u0002\\\u0005%\u0015\u0002BAF\u0003;\u0012\u0001$\u00138wC2LG\r\u0016=o'R\fG/Z#yG\u0016\u0004H/[8o\u0003=\"Xm\u001d;UeVt7-\u0019;f\u0003:$'+\u001a7pC\u0012\u0014V-\\8wKN|U\u000f^(g%\u0006tw-Z*oCB\u001c\bn\u001c;tQ\ry\u0012qH\u0001\u0011i\u0016\u001cH\u000fV1lKNs\u0017\r]:i_RD3\u0001IA \u0003]!Xm\u001d;SK\u000e|g/\u001a:Ge>l7K\\1qg\"|G\u000fK\u0002\"\u0003\u007f\tQ\u0004^3tiJ+Wn\u001c<f\u000bb\u0004\u0018N]3e!&$7o\u00148SK2|\u0017\r\u001a\u0015\bE\u0005}\u0012QKAOG\t\ty\n\u0005\u0003\u0002\\\u0005\u0005\u0016\u0002BAR\u0003;\u0012!$\u00168l]><h\u000e\u0015:pIV\u001cWM]%e\u000bb\u001cW\r\u001d;j_:\fQ\u0006^3ti\u0006\u001b7-\u001a9u\u0003B\u0004XM\u001c3XSRDw.\u001e;Qe>$WoY3s'R\fG/Z(o%\u0016\u0004H.[2bQ\r\u0019\u0013qH\u0001*i\u0016\u001cH/Q2dKB$\u0018\t\u001d9f]\u0012<\u0016\u000e\u001e5TKF,XM\\2f\u000f\u0006\u00048o\u00148SKBd\u0017nY1)\u0007\u0011\ny$A\ruKN$H)\u001a7fi\u0016\u001cf.\u00199tQ>$8OQ3g_J,\u0007fA\u0013\u0002@\u0005aA/Z:u)J,hnY1uK\"\u001aa%a\u0010\u0002MQ,7\u000f\u001e$jeN$XK\\:uC\ndWm\u00144gg\u0016$\u0018I\u001a;feR\u0013XO\\2bi&|g\u000eK\u0002(\u0003\u007f\ta\u0006^3ti2{\u0017\r\u001a$s_6\u001cf.\u00199tQ>$(+\u001a;bS:\u001chj\u001c8FqBL'/\u001a3Qe>$WoY3sg\"\u001a\u0001&a\u0010\u0002CQ,7\u000f^*lSB\u001cf.\u00199tQ>$\u0018JZ(gMN,G/\u00168dQ\u0006tw-\u001a3)\u0007%\ny$A\buKN$8\u000b^1si>3gm]3uQ\rQ\u0013qH\u0001\u0019i\u0016\u001cH\u000fU5e\u000bb\u0004\u0018N]1uS>tG+[7f_V$\bfB\u0016\u0002@\u0005U\u0013QT\u0001\u0018i\u0016\u001cHOR5sgR,fn\u001d;bE2,wJ\u001a4tKRD3\u0001LA \u00039\"Xm\u001d;Qe>$WoY3sg^KG\u000f[(oO>Lgn\u001a+sC:\u001c\u0018m\u0019;j_:\u001cHi\u001c8u\u000bb\u0004\u0018N]3)\u00075\ny$A\u0017uKN$8+Z9vK:\u001cWMT8u-\u0006d\u0017\u000eZ1uK\u00124uN]$s_V\u0004X*\u001a;bI\u0006$\u0018\rV8qS\u000eD3ALA \u0003q!Xm\u001d;PY\u0012,\u0005o\\2i\r>\u00148i\u001c8ue>d'+Z2pe\u0012DsaLA \u0003+\nIn\t\u0002\u0002\\B!\u00111LAo\u0013\u0011\ty.!\u0018\u0003/A\u0013x\u000eZ;dKJ4UM\\2fI\u0016C8-\u001a9uS>t\u0017A\u0006;fgR\u001cun\u001c:eS:\fGo\u001c:GK:\u001c\u0017N\\4)\u0007A\ny$\u0001\u0011uKN$8i\\8sI&t\u0017\r^8s\r\u0016t7-\u001a3BMR,'OU3m_\u0006$\u0007fB\u0019\u0002@\u0005U\u0013\u0011^\u0012\u0003\u0003W\u0004B!a\u0017\u0002n&!\u0011q^A/\u0005\u0015\"&/\u00198tC\u000e$\u0018n\u001c8D_>\u0014H-\u001b8bi>\u0014h)\u001a8dK\u0012,\u0005pY3qi&|g.A\u000fuKN$Hj\\1e\rJ|W.R7qif\u001cf.\u00199tQ>$h)\u001b7fQ\r\u0011\u0014qH\u0001\"i\u0016\u001cH\u000fT8bI\u001a\u0013x.\u001c+sk:\u001c\u0017\r^3e':\f\u0007o\u001d5pi\u001aKG.\u001a\u0015\u0004g\u0005}\u0012a\b;fgRdu.\u00193Ge>l7i\u001c:skB$8K\\1qg\"|GOR5mK\"\u001aA'a\u0010\u00027Q,7\u000f^!qa\u0016tG-R7qif\u001cuN\u001c;s_2\u0014\u0015\r^2iQ\r)\u0014qH\u0001\u001ci\u0016\u001cH\u000fT8bI\u001a\u0013x.\\\"peJ,\b\u000f^*oCB\u001c\bn\u001c;\u0015\u0007u\u0013)\u0001C\u0004\u0003\bY\u0002\rA!\u0003\u0002\u001f5\f7.\u001a$jY\u0016\u001cuN\u001d:vaR\u0004b\u0001\u0013B\u0006\u0005\u001fi\u0016b\u0001B\u0007\u0013\nIa)\u001e8di&|g.\r\t\u0005\u0005#\u0011Y\"\u0004\u0002\u0003\u0014)!!Q\u0003B\f\u0003!\u0019\u0007.\u00198oK2\u001c(b\u0001B\r/\u0006\u0019a.[8\n\t\tu!1\u0003\u0002\f\r&dWm\u00115b]:,G.\u0001\nbaB,g\u000eZ#oIRCh.T1sW\u0016\u0014H\u0003\u0005B\u0012\u0005_\u0011\u0019D!\u000e\u0003@\t=#1\u000bB,!\u0019A%Q\u0005B\u0015y&\u0019!qE%\u0003\rQ+\b\u000f\\33!\r\u0001&1F\u0005\u0004\u0005[\t%\u0001D\"p[BdW\r^3e)bt\u0007B\u0002B\u0019o\u0001\u0007Q-A\u0004nCB\u0004\u0018N\\4\t\u000bi<\u0004\u0019\u0001?\t\u000f\t]r\u00071\u0001\u0003:\u0005i\u0001O]8ek\u000e,'/\u00129pG\"\u00042\u0001\u0013B\u001e\u0013\r\u0011i$\u0013\u0002\u0006'\"|'\u000f\u001e\u0005\b\u0005\u0003:\u0004\u0019\u0001B\"\u0003-\u0019wN\u001c;s_2$\u0016\u0010]3\u0011\t\t\u0015#1J\u0007\u0003\u0005\u000fR1A!\u0013q\u0003\u0019\u0011XmY8sI&!!Q\nB$\u0005E\u0019uN\u001c;s_2\u0014VmY8sIRK\b/\u001a\u0005\u0007\u0005#:\u0004\u0019\u0001?\u0002\r=4gm]3u\u0011%\u0011)f\u000eI\u0001\u0002\u0004\t)!\u0001\td_>\u0014H-\u001b8bi>\u0014X\t]8dQ\"A!\u0011L\u001c\u0011\u0002\u0003\u0007A0A\u0005uS6,7\u000f^1na\u0006a\u0012\r\u001d9f]\u0012,e\u000e\u001a+y]6\u000b'o[3sI\u0011,g-Y;mi\u00122TC\u0001B0U\u0011\t)A!\u0019,\u0005\t\r\u0004\u0003\u0002B3\u0005_j!Aa\u001a\u000b\t\t%$1N\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u001cJ\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005c\u00129GA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fA$\u00199qK:$WI\u001c3Uq:l\u0015M]6fe\u0012\"WMZ1vYR$s'\u0006\u0002\u0003x)\u001aAP!\u0019\u0002\r\u0005\u0004\b/\u001a8e)Ei&Q\u0010B@\u0005\u0003\u0013\u0019Ia\"\u0003\n\n-%Q\u0013\u0005\u0006Gj\u0002\r!\u001a\u0005\u0006uj\u0002\r\u0001 \u0005\b\u0005oQ\u0004\u0019\u0001B\u001d\u0011\u001d\u0011)I\u000fa\u0001\u0003\u000b\t1a]3r\u0011\u0019\u0011\tF\u000fa\u0001y\"A!\u0011\f\u001e\u0011\u0002\u0003\u0007A\u0010C\u0005\u0003\u000ej\u0002\n\u00111\u0001\u0003\u0010\u0006y\u0011n\u001d+sC:\u001c\u0018m\u0019;j_:\fG\u000eE\u0002I\u0005#K1Aa%J\u0005\u001d\u0011un\u001c7fC:D\u0011Ba&;!\u0003\u0005\rAa$\u0002\u0019%\u001chI]8n\u00072LWM\u001c;\u0002!\u0005\u0004\b/\u001a8eI\u0011,g-Y;mi\u00122\u0014\u0001E1qa\u0016tG\r\n3fM\u0006,H\u000e\u001e\u00138+\t\u0011yJ\u000b\u0003\u0003\u0010\n\u0005\u0014\u0001E1qa\u0016tG\r\n3fM\u0006,H\u000e\u001e\u00139)5i&Q\u0015BT\u0005S\u0013YK!,\u00038\")1M\u0010a\u0001K\")!P\u0010a\u0001y\"9!q\u0007 A\u0002\te\u0002B\u0002B)}\u0001\u0007A\u0010C\u0004\u00030z\u0002\rA!-\u0002\u000b\t\fGo\u00195\u0011\t\t\u0015#1W\u0005\u0005\u0005k\u00139EA\u0006SK\u000e|'\u000f\u001a\"bi\u000eD\u0007b\u0002BL}\u0001\u0007!qR\u0001\u0017GV\u0014(/\u001a8u':\f\u0007o\u001d5pi>3gm]3ugV\u0011!Q\u0018\t\u0006\u0005\u007f\u0013I\r`\u0007\u0003\u0005\u0003TAAa1\u0003F\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0005\u000fL\u0015AC2pY2,7\r^5p]&!!1\u001aBa\u0005\r\u0019V\r\u001e")
public class ProducerStateManagerTest {
    private File logDir = null;
    private ProducerStateManager stateManager = null;
    private final TopicPartition partition = new TopicPartition("test", 0);
    private final long producerId;
    private final int maxPidExpirationMs;
    private final MockTime time = new MockTime();

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public ProducerStateManager stateManager() {
        return this.stateManager;
    }

    public void stateManager_$eq(ProducerStateManager x$1) {
        this.stateManager = x$1;
    }

    public TopicPartition partition() {
        return this.partition;
    }

    public long producerId() {
        return this.producerId;
    }

    public int maxPidExpirationMs() {
        return this.maxPidExpirationMs;
    }

    public MockTime time() {
        return this.time;
    }

    @Before
    public void setUp() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.stateManager_$eq(new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs()));
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testBasicIdMapping() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, this.append$default$7(), this.append$default$8());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, this.append$default$7(), this.append$default$8()), ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.append(this.stateManager(), this.producerId(), epoch, 5, 0L, 2L, this.append$default$7(), this.append$default$8()), ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.append(this.stateManager(), this.producerId(), (short)(epoch + 1), 0, 0L, 3L, this.append$default$7(), this.append$default$8());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 4L, this.append$default$7(), this.append$default$8()), ClassTag$.MODULE$.apply(ProducerFencedException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
    }

    @Test
    public void testAppendTxnMarkerWithNoProducerState() {
        short producerEpoch = (short)2;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 27L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        ProducerStateEntry firstEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Assertions$.MODULE$.fail("Expected last entry to be defined", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91)));
        Assert.assertEquals((long)producerEpoch, (long)firstEntry.producerEpoch());
        Assert.assertEquals((long)this.producerId(), (long)firstEntry.producerId());
        Assert.assertEquals((long)-1L, (long)firstEntry.lastSeq());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.append(this.stateManager(), this.producerId(), (short)0, 0, 0L, 4L, this.append$default$7(), this.append$default$8()), ClassTag$.MODULE$.apply(ProducerFencedException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.append(this.stateManager(), this.producerId(), producerEpoch, 17, 0L, 4L, this.append$default$7(), this.append$default$8()), ClassTag$.MODULE$.apply(UnknownProducerIdException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, 39L, 4L, this.append$default$7(), this.append$default$8());
        ProducerStateEntry secondEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Assertions$.MODULE$.fail("Expected last entry to be defined", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109)));
        Assert.assertEquals((long)producerEpoch, (long)secondEntry.producerEpoch());
        Assert.assertEquals((long)this.producerId(), (long)secondEntry.producerId());
        Assert.assertEquals((long)0L, (long)secondEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = sequence;
        long x$5 = offset;
        boolean x$6 = false;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$7();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$8, x$6);
        this.append(this.stateManager(), this.producerId(), epoch, 0, offset + 500L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assert.assertEquals((long)epoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)0L, (long)lastEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWithWrapAroundBatchRecord() {
        short epoch = (short)15;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), false);
        appendInfo.append(epoch, 0x7FFFFFF5, 9, this.time().milliseconds(), new LogOffsetMetadata(2000L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 2020L, false);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assert.assertEquals((long)0x7FFFFFF5L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)9L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)2000L, (long)lastEntry.firstOffset());
        Assert.assertEquals((long)2020L, (long)lastEntry.lastDataOffset());
    }

    @Test(expected=OutOfOrderSequenceException.class)
    public void testProducerSequenceInvalidWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = sequence;
        long x$5 = offset;
        boolean x$6 = false;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$7();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$8, x$6);
        this.append(this.stateManager(), this.producerId(), epoch, 1, offset + 500L, this.append$default$6(), this.append$default$7(), this.append$default$8());
    }

    @Test
    public void testNoValidationOnFirstEntryWhenLoadingLog() {
        short epoch = (short)5;
        int sequence = 16;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = sequence;
        long x$5 = offset;
        boolean x$6 = false;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$7();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$8, x$6);
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assert.assertEquals((long)epoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)sequence, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)sequence, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)offset, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((long)offset, (long)lastEntry.firstOffset());
    }

    @Test
    public void testControlRecordBumpsEpoch() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        short bumpedEpoch = (short)1;
        Tuple2<CompletedTxn, Object> tuple2 = this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedEpoch, ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        CompletedTxn completedTxn = (CompletedTxn)tuple2._1();
        long lastStableOffset = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2((Object)completedTxn, (Object)BoxesRunTime.boxToLong((long)lastStableOffset));
        Tuple2 tuple23 = tuple22;
        CompletedTxn completedTxn2 = (CompletedTxn)tuple23._1();
        long lastStableOffset2 = tuple23._2$mcJ$sp();
        Assert.assertEquals((long)1L, (long)completedTxn2.firstOffset());
        Assert.assertEquals((long)1L, (long)completedTxn2.lastOffset());
        Assert.assertEquals((long)2L, (long)lastStableOffset2);
        Assert.assertTrue((boolean)completedTxn2.isAborted());
        Assert.assertEquals((long)this.producerId(), (long)completedTxn2.producerId());
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assert.assertEquals((long)bumpedEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((long)-1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)-1L, (long)lastEntry.lastSeq());
        this.append(this.stateManager(), this.producerId(), bumpedEpoch, 0, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)this.stateManager().lastEntry(this.producerId()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.firstSeq())));
    }

    @Test
    public void testTxnFirstOffsetMetadataCached() {
        short producerEpoch = (short)0;
        long offset = 992342L;
        int seq = 0;
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), this.producerId(), ProducerStateEntry$.MODULE$.empty(this.producerId()), (ValidationType)ValidationType.Full$.MODULE$);
        LogOffsetMetadata firstOffsetMetadata = new LogOffsetMetadata(offset, 990000L, 234224);
        producerAppendInfo.append(producerEpoch, seq, seq, this.time().milliseconds(), firstOffsetMetadata, offset, true);
        this.stateManager().update(producerAppendInfo);
        Assert.assertEquals((Object)new Some((Object)firstOffsetMetadata), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testLastStableOffsetCompletedTxn() {
        short producerEpoch = (short)0;
        long segmentBaseOffset = 990000L;
        long producerId1 = this.producerId();
        long startOffset1 = 992342L;
        this.beginTxn$1(producerId1, startOffset1, segmentBaseOffset, producerEpoch);
        long producerId2 = this.producerId() + 1L;
        long startOffset2 = startOffset1 + 25L;
        this.beginTxn$1(producerId2, startOffset2, segmentBaseOffset, producerEpoch);
        long producerId3 = this.producerId() + 2L;
        long startOffset3 = startOffset1 + 57L;
        this.beginTxn$1(producerId3, startOffset3, segmentBaseOffset, producerEpoch);
        long lastOffset1 = startOffset3 + 15L;
        CompletedTxn completedTxn1 = new CompletedTxn(producerId1, startOffset1, lastOffset1, false);
        Assert.assertEquals((long)startOffset2, (long)this.stateManager().lastStableOffset(completedTxn1));
        this.stateManager().completeTxn(completedTxn1);
        this.stateManager().onHighWatermarkUpdated(lastOffset1 + 1L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)startOffset2)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.messageOffset())));
        long lastOffset3 = lastOffset1 + 20L;
        CompletedTxn completedTxn3 = new CompletedTxn(producerId3, startOffset3, lastOffset3, false);
        Assert.assertEquals((long)startOffset2, (long)this.stateManager().lastStableOffset(completedTxn3));
        this.stateManager().completeTxn(completedTxn3);
        this.stateManager().onHighWatermarkUpdated(lastOffset3 + 1L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)startOffset2)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.messageOffset())));
        long lastOffset2 = lastOffset3 + 78L;
        CompletedTxn completedTxn2 = new CompletedTxn(producerId2, startOffset2, lastOffset2, false);
        Assert.assertEquals((long)(lastOffset2 + 1L), (long)this.stateManager().lastStableOffset(completedTxn2));
        this.stateManager().completeTxn(completedTxn2);
        this.stateManager().onHighWatermarkUpdated(lastOffset2 + 1L);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testPrepareUpdateDoesNotMutate() {
        short producerEpoch = (short)0;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), true);
        appendInfo.append(producerEpoch, 0, 5, this.time().milliseconds(), new LogOffsetMetadata(15L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 20L, false);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerAppendInfo nextAppendInfo = this.stateManager().prepareUpdate(this.producerId(), true);
        nextAppendInfo.append(producerEpoch, 6, 10, this.time().milliseconds(), new LogOffsetMetadata(26L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 30L, false);
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assert.assertEquals((long)0L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)5L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        this.stateManager().update(nextAppendInfo);
        lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assert.assertEquals((long)0L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)10L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
    }

    @Test
    public void updateProducerTransactionState() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 15;
        long offset = 9L;
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, offset, this.append$default$6(), this.append$default$7(), this.append$default$8());
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), true);
        appendInfo.append(producerEpoch, 1, 5, this.time().milliseconds(), new LogOffsetMetadata(16L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 20L, true);
        ProducerStateEntry lastEntry = appendInfo.toEntry();
        Assert.assertEquals((long)producerEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)5L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)16L, (long)lastEntry.firstOffset());
        Assert.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((Object)new .colon.colon((Object)new TxnMetadata(this.producerId(), 16L), (List)Nil$.MODULE$), (Object)appendInfo.startedTransactions());
        appendInfo.append(producerEpoch, 6, 10, this.time().milliseconds(), new LogOffsetMetadata(26L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 30L, true);
        lastEntry = appendInfo.toEntry();
        Assert.assertEquals((long)producerEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)10L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)16L, (long)lastEntry.firstOffset());
        Assert.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((Object)new .colon.colon((Object)new TxnMetadata(this.producerId(), 16L), (List)Nil$.MODULE$), (Object)appendInfo.startedTransactions());
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, coordinatorEpoch);
        CompletedTxn completedTxn = appendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, 40L, this.time().milliseconds());
        Assert.assertEquals((long)this.producerId(), (long)completedTxn.producerId());
        Assert.assertEquals((long)16L, (long)completedTxn.firstOffset());
        Assert.assertEquals((long)40L, (long)completedTxn.lastOffset());
        Assert.assertFalse((boolean)completedTxn.isAborted());
        lastEntry = appendInfo.toEntry();
        Assert.assertEquals((long)producerEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)10L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)16L, (long)lastEntry.firstOffset());
        Assert.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((long)coordinatorEpoch, (long)lastEntry.coordinatorEpoch());
        Assert.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((Object)new .colon.colon((Object)new TxnMetadata(this.producerId(), 16L), (List)Nil$.MODULE$), (Object)appendInfo.startedTransactions());
    }

    @Test
    public void testOutOfSequenceAfterControlRecordEpochBump() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$8();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$6, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        short x$11 = epoch;
        int x$12 = 1;
        long x$13 = 1L;
        boolean x$14 = true;
        long x$15 = this.append$default$6();
        boolean x$16 = this.append$default$8();
        this.append(x$9, x$10, x$11, x$12, x$13, x$15, x$14, x$16);
        short bumpedEpoch = (short)1;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedEpoch, ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ProducerStateManager x$17 = this.stateManager();
            long x$18 = this.producerId();
            short x$19 = bumpedEpoch;
            int x$20 = 2;
            long x$21 = 2L;
            boolean x$22 = true;
            long x$23 = this.append$default$6();
            boolean x$24 = this.append$default$8();
            this.append(x$17, x$18, x$19, x$20, x$21, x$23, x$22, x$24);
        }, ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ProducerStateManager x$25 = this.stateManager();
            long x$26 = this.producerId();
            short x$27 = (short)(bumpedEpoch + 1);
            int x$28 = 2;
            long x$29 = 2L;
            boolean x$30 = true;
            long x$31 = this.append$default$6();
            boolean x$32 = this.append$default$8();
            this.append(x$25, x$26, x$27, x$28, x$29, x$31, x$30, x$32);
        }, ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
        ProducerStateManager x$33 = this.stateManager();
        long x$34 = this.producerId();
        short x$35 = bumpedEpoch;
        int x$36 = 0;
        long x$37 = 0L;
        boolean x$38 = true;
        long x$39 = this.append$default$6();
        boolean x$40 = this.append$default$8();
        this.append(x$33, x$34, x$35, x$36, x$37, x$39, x$38, x$40);
        Assert.assertEquals((long)bumpedEpoch, (long)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).producerEpoch());
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastSeq());
    }

    @Test(expected=InvalidTxnStateException.class)
    public void testNonTransactionalAppendWithOngoingTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$8();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$6, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        short x$11 = epoch;
        int x$12 = 1;
        long x$13 = 1L;
        boolean x$14 = false;
        long x$15 = this.append$default$6();
        boolean x$16 = this.append$default$8();
        this.append(x$9, x$10, x$11, x$12, x$13, x$15, x$14, x$16);
    }

    @Test
    public void testTruncateAndReloadRemovesOutOfRangeSnapshots() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 3, 3L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 4, 4L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.stateManager().truncateAndReload(1L, 3L, this.time().milliseconds());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)this.stateManager().oldestSnapshotOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)3L)), (Object)this.stateManager().latestSnapshotOffset());
    }

    @Test
    public void testTakeSnapshot() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((String)"Directory doesn't contain a single file as expected", (long)1L, (long)this.logDir().list().length);
        Assert.assertTrue((String)"Snapshot file is empty", (((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().list())).head()).length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRecoverFromSnapshot() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        this.append(recoveredMapping, this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
    }

    @Test(expected=UnknownProducerIdException.class)
    public void testRemoveExpiredPidsOnReload() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        this.append(recoveredMapping, this.producerId(), epoch, 2, 2L, 70001L, this.append$default$7(), this.append$default$8());
    }

    @Test
    public void testAcceptAppendWithoutProducerStateOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        int sequence = 2;
        Assert.assertFalse((boolean)recoveredMapping.activeProducers().contains((Object)BoxesRunTime.boxToLong((long)this.producerId())));
        ProducerStateManager x$1 = recoveredMapping;
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = sequence;
        long x$5 = 2L;
        long x$6 = 70001L;
        boolean x$7 = false;
        boolean x$8 = this.append$default$7();
        this.append(x$1, x$2, x$3, x$4, x$5, x$6, x$8, x$7);
        Assert.assertTrue((boolean)recoveredMapping.activeProducers().contains((Object)BoxesRunTime.boxToLong((long)this.producerId())));
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)Option$.MODULE$.option2Iterable(recoveredMapping.activeProducers().get((Object)BoxesRunTime.boxToLong((long)this.producerId()))).head();
        Assert.assertEquals((long)epoch, (long)producerStateEntry.producerEpoch());
        Assert.assertEquals((long)sequence, (long)producerStateEntry.firstSeq());
        Assert.assertEquals((long)sequence, (long)producerStateEntry.lastSeq());
    }

    @Test
    public void testAcceptAppendWithSequenceGapsOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        int outOfOrderSequence = 3;
        try {
            ProducerStateManager x$1 = this.stateManager();
            long x$2 = this.producerId();
            short x$3 = epoch;
            int x$4 = outOfOrderSequence;
            long x$5 = 1L;
            long x$6 = 1L;
            boolean x$7 = true;
            boolean x$8 = this.append$default$7();
            this.append(x$1, x$2, x$3, x$4, x$5, x$6, x$8, x$7);
            throw Assertions$.MODULE$.fail("Expected an OutOfOrderSequenceException to be raised.", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 479));
        }
        catch (OutOfOrderSequenceException outOfOrderSequenceException) {
        }
        catch (Exception exception) {
            throw Assertions$.MODULE$.fail("Expected an OutOfOrderSequenceException to be raised.", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 484));
        }
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)this.stateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)this.producerId()))).lastSeq());
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        short x$11 = epoch;
        int x$12 = outOfOrderSequence;
        long x$13 = 1L;
        long x$14 = 1L;
        boolean x$15 = false;
        boolean x$16 = this.append$default$7();
        this.append(x$9, x$10, x$11, x$12, x$13, x$14, x$16, x$15);
        Assert.assertEquals((long)outOfOrderSequence, (long)((ProducerStateEntry)this.stateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)this.producerId()))).lastSeq());
    }

    @Test
    public void testDeleteSnapshotsBefore() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)2L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(3L);
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(4L);
        Assert.assertEquals((long)0L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
    }

    @Test
    public void testTruncate() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)2L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().truncate();
        Assert.assertEquals((long)0L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testFirstUnstableOffsetAfterTruncation() {
        short epoch = (short)0;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = sequence;
        long x$52 = 99L;
        boolean x$62 = true;
        long x$72 = this.append$default$6();
        boolean x$82 = this.append$default$8();
        this.append(x$1, x$2, x$3, x$4, x$52, x$72, x$62, x$82);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.messageOffset())));
        this.stateManager().takeSnapshot();
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 105L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        this.stateManager().onHighWatermarkUpdated(106L);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.messageOffset())));
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 106L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().truncateAndReload(0L, 106L, this.time().milliseconds());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.messageOffset())));
        this.stateManager().truncateAndReload(0L, 100L, this.time().milliseconds());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.messageOffset())));
    }

    @Test
    public void testLoadFromSnapshotRetainsNonExpiredProducers() {
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        this.append(this.stateManager(), pid1, epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), pid2, epoch, 0, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)2L, (long)this.stateManager().activeProducers().size());
        this.stateManager().truncateAndReload(1L, 2L, this.time().milliseconds());
        Assert.assertEquals((long)2L, (long)this.stateManager().activeProducers().size());
        Option entry1 = this.stateManager().lastEntry(pid1);
        Assert.assertTrue((boolean)entry1.isDefined());
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)entry1.get()).lastSeq());
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)entry1.get()).lastDataOffset());
        Option entry2 = this.stateManager().lastEntry(pid2);
        Assert.assertTrue((boolean)entry2.isDefined());
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)entry2.get()).lastSeq());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)entry2.get()).lastDataOffset());
    }

    @Test
    public void testSkipSnapshotIfOffsetUnchanged() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testStartOffset() {
        short epoch = (short)0;
        long pid2 = 2L;
        this.append(this.stateManager(), pid2, epoch, 0, 0L, 1L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 0, 1L, 2L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 2L, 3L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 3L, 4L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
            recoveredMapping.truncateAndReload(0L, 1L, this.time().milliseconds());
            this.append(recoveredMapping, pid2, epoch, 1, 4L, 5L, this.append$default$7(), this.append$default$8());
        }, ClassTag$.MODULE$.apply(UnknownProducerIdException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 613));
    }

    @Test(expected=UnknownProducerIdException.class)
    public void testPidExpirationTimeout() {
        short epoch = (short)5;
        int sequence = 37;
        this.append(this.stateManager(), this.producerId(), epoch, sequence, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.time().sleep((long)(this.maxPidExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
    }

    @Test
    public void testFirstUnstableOffset() {
        short epoch = (short)5;
        int sequence = 0;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = sequence;
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$8();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$6, x$8);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.messageOffset())));
        long anotherPid = 2L;
        ProducerStateManager x$92 = this.stateManager();
        long x$102 = anotherPid;
        short x$112 = epoch;
        int x$122 = sequence;
        long x$132 = 105L;
        boolean x$142 = true;
        long x$152 = this.append$default$6();
        boolean x$16 = this.append$default$8();
        this.append(x$92, x$102, x$112, x$122, x$132, x$152, x$142, x$16);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.messageOffset())));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 109L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.messageOffset())));
        this.stateManager().onHighWatermarkUpdated(100L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.messageOffset())));
        this.stateManager().onHighWatermarkUpdated(110L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.messageOffset())));
        this.appendEndTxnMarker(this.stateManager(), anotherPid, epoch, ControlRecordType.ABORT, 112L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.messageOffset())));
        this.stateManager().onHighWatermarkUpdated(113L);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToLong((long)x$15.messageOffset())));
    }

    @Test
    public void testProducersWithOngoingTransactionsDontExpire() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = sequence;
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$8();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$6, x$8);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        this.time().sleep((long)(this.maxPidExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
    }

    @Test
    public void testSequenceNotValidatedForGroupMetadataTopic() {
        TopicPartition partition = new TopicPartition("__consumer_offsets", 0);
        ProducerStateManager stateManager = new ProducerStateManager(partition, this.logDir(), this.maxPidExpirationMs());
        short epoch = (short)0;
        ProducerStateManager x$1 = stateManager;
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = -1;
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$8();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$6, x$8);
        ProducerStateManager x$9 = stateManager;
        long x$10 = this.producerId();
        short x$11 = epoch;
        int x$12 = -1;
        long x$13 = 100L;
        boolean x$14 = true;
        long x$15 = this.append$default$6();
        boolean x$16 = this.append$default$8();
        this.append(x$9, x$10, x$11, x$12, x$13, x$15, x$14, x$16);
    }

    @Test(expected=ProducerFencedException.class)
    public void testOldEpochForControlRecord() {
        short epoch = (short)5;
        int sequence = 0;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = sequence;
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$8();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$6, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)3, ControlRecordType.COMMIT, 100L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
    }

    @Test
    public void testCoordinatorFencing() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = sequence;
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$8();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$6, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        Option lastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)lastEntry.map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToInteger((int)x$16.coordinatorEpoch())));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 101L, 1, this.appendEndTxnMarker$default$7());
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 102L, 2, this.appendEndTxnMarker$default$7());
        try {
            this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 103L, 1, this.appendEndTxnMarker$default$7());
            throw Assertions$.MODULE$.fail("Expected coordinator to be fenced", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 724));
        }
        catch (TransactionCoordinatorFencedException e) {
            return;
        }
    }

    @Test(expected=TransactionCoordinatorFencedException.class)
    public void testCoordinatorFencedAfterReload() {
        short producerEpoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = producerEpoch;
        int x$4 = 0;
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$8();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$6, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 2L, 70000L);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 0, this.appendEndTxnMarker$default$7());
    }

    @Test
    public void testLoadFromEmptySnapshotFile() {
        this.testLoadFromCorruptSnapshot((Function1<FileChannel, BoxedUnit>)(Function1 & Serializable & scala.Serializable)file -> {
            file.truncate(0L);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testLoadFromTruncatedSnapshotFile() {
        this.testLoadFromCorruptSnapshot((Function1<FileChannel, BoxedUnit>)(Function1 & Serializable & scala.Serializable)file -> {
            ProducerStateManagerTest.$anonfun$testLoadFromTruncatedSnapshotFile$1(file);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testLoadFromCorruptSnapshotFile() {
        this.testLoadFromCorruptSnapshot((Function1<FileChannel, BoxedUnit>)(Function1 & Serializable & scala.Serializable)file -> {
            ProducerStateManagerTest.$anonfun$testLoadFromCorruptSnapshotFile$1(file);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAppendEmptyControlBatch() {
        long producerId = 23423L;
        short producerEpoch = (short)145;
        int baseOffset = 15;
        RecordBatch batch = (RecordBatch)EasyMock.createMock(RecordBatch.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.expect((Object)batch.iterator()).andReturn(Collections.emptyIterator()).once();
        EasyMock.replay((Object[])new Object[]{batch});
        this.append(this.stateManager(), producerId, producerEpoch, baseOffset, batch, true);
        Assert.assertEquals((Object)None$.MODULE$, (Object)((ProducerStateEntry)this.stateManager().lastEntry(producerId).get()).currentTxnFirstOffset());
    }

    private void testLoadFromCorruptSnapshot(Function1<FileChannel, BoxedUnit> makeFileCorrupt) {
        short epoch = (short)0;
        long producerId = 1L;
        this.append(this.stateManager(), producerId, epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), producerId, epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Option latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)latestSnapshotOffset);
        File snapshotToTruncate = Log$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)latestSnapshotOffset.get()));
        try (FileChannel channel = FileChannel.open(snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            makeFileCorrupt.apply((Object)channel);
        }
        ProducerStateManager reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assert.assertFalse((boolean)snapshotToTruncate.exists());
        ProducerStateEntry loadedProducerState = (ProducerStateEntry)reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)producerId));
        Assert.assertEquals((long)0L, (long)loadedProducerState.lastDataOffset());
    }

    private Tuple2<CompletedTxn, Object> appendEndTxnMarker(ProducerStateManager mapping, long producerId, short producerEpoch, ControlRecordType controlType, long offset, int coordinatorEpoch, long timestamp) {
        ProducerAppendInfo producerAppendInfo = this.stateManager().prepareUpdate(producerId, true);
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlType, coordinatorEpoch);
        CompletedTxn completedTxn = producerAppendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, offset, timestamp);
        mapping.update(producerAppendInfo);
        long lastStableOffset = mapping.lastStableOffset(completedTxn);
        mapping.completeTxn(completedTxn);
        mapping.updateMapEndOffset(offset + 1L);
        return new Tuple2((Object)completedTxn, (Object)BoxesRunTime.boxToLong((long)lastStableOffset));
    }

    private void append(ProducerStateManager stateManager, long producerId, short producerEpoch, int seq, long offset, long timestamp, boolean isTransactional, boolean isFromClient) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, isFromClient);
        producerAppendInfo.append(producerEpoch, seq, seq, timestamp, new LogOffsetMetadata(offset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), offset, isTransactional);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private void append(ProducerStateManager stateManager, long producerId, short producerEpoch, long offset, RecordBatch batch, boolean isFromClient) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, isFromClient);
        producerAppendInfo.append(batch, (Option)None$.MODULE$);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private int appendEndTxnMarker$default$6() {
        return 0;
    }

    private long appendEndTxnMarker$default$7() {
        return this.time().milliseconds();
    }

    private long append$default$6() {
        return this.time().milliseconds();
    }

    private boolean append$default$7() {
        return false;
    }

    private boolean append$default$8() {
        return true;
    }

    private Set<Object> currentSnapshotOffsets() {
        return new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).map((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFile(file)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).toSet();
    }

    private final void beginTxn$1(long producerId, long startOffset, long segmentBaseOffset$1, short producerEpoch$2) {
        int relativeOffset = (int)(startOffset - segmentBaseOffset$1);
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), producerId, ProducerStateEntry$.MODULE$.empty(producerId), (ValidationType)ValidationType.Full$.MODULE$);
        LogOffsetMetadata firstOffsetMetadata = new LogOffsetMetadata(startOffset, segmentBaseOffset$1, 50 * relativeOffset);
        producerAppendInfo.append(producerEpoch$2, 0, 0, this.time().milliseconds(), firstOffsetMetadata, startOffset, true);
        this.stateManager().update(producerAppendInfo);
    }

    public static final /* synthetic */ void $anonfun$testLoadFromTruncatedSnapshotFile$1(FileChannel file) {
        Assert.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.truncate(file.size() / 2L);
    }

    public static final /* synthetic */ void $anonfun$testLoadFromCorruptSnapshotFile$1(FileChannel file) {
        Assert.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.write(ByteBuffer.wrap((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{37}), ClassTag$.MODULE$.Byte())), file.size() / 2L);
    }

    public ProducerStateManagerTest() {
        this.producerId = 1L;
        this.maxPidExpirationMs = 60000;
    }
}

