/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import kafka.server.MetadataCache;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Range;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001\u0002\b\u0010\u0001QAQa\u0007\u0001\u0005\u0002qAqa\b\u0001C\u0002\u0013\u0005\u0001\u0005\u0003\u0004%\u0001\u0001\u0006I!\t\u0005\u0006K\u0001!\tA\n\u0005\u0006g\u0001!\tA\n\u0005\u0006k\u0001!\tA\n\u0005\u0006o\u0001!\tA\n\u0005\u0006s\u0001!\tA\n\u0005\u0006w\u0001!I\u0001\u0010\u0005\u0006{\u0002!\tA\n\u0005\u0006\u007f\u0002!\tA\n\u0005\u0007\u0003\u0007\u0001A\u0011\u0001\u0014\t\r\u0005\u001d\u0001\u0001\"\u0001'\u0005EiU\r^1eCR\f7)Y2iKR+7\u000f\u001e\u0006\u0003!E\taa]3sm\u0016\u0014(\"\u0001\n\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0006\t\u0003-ei\u0011a\u0006\u0006\u00021\u0005)1oY1mC&\u0011!d\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005y\u0011a\u00032s_.,'/\u00129pG\",\u0012!\t\t\u0003-\tJ!aI\f\u0003\t1{gnZ\u0001\rEJ|7.\u001a:Fa>\u001c\u0007\u000eI\u0001\"O\u0016$Hk\u001c9jG6+G/\u00193bi\u0006tuN\\#ySN$\u0018N\\4U_BL7m\u001d\u000b\u0002OA\u0011a\u0003K\u0005\u0003S]\u0011A!\u00168ji\"\u0012Aa\u000b\t\u0003YEj\u0011!\f\u0006\u0003]=\nQA[;oSRT\u0011\u0001M\u0001\u0004_J<\u0017B\u0001\u001a.\u0005\u0011!Vm\u001d;\u0002!\u001d,G\u000fV8qS\u000elU\r^1eCR\f\u0007FA\u0003,\u0003-:W\r\u001e+pa&\u001cW*\u001a;bI\u0006$\u0018\rU1si&$\u0018n\u001c8MK\u0006$WM\u001d(pi\u00063\u0018-\u001b7bE2,\u0007F\u0001\u0004,\u0003U:W\r\u001e+pa&\u001cW*\u001a;bI\u0006$\u0018\rU1si&$\u0018n\u001c8MSN$XM\\3s\u001d>$\u0018I^1jY\u0006\u0014G.Z(o\u0019\u0016\fG-\u001a:)\u0005\u001dY\u0013aR4fiR{\u0007/[2NKR\fG-\u0019;b!\u0006\u0014H/\u001b;j_:d\u0015n\u001d;f]\u0016\u0014hj\u001c;Bm\u0006LG.\u00192mK>sG*Z1eKJ|E\u000eZ'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8)\u0005!Y\u0013\u0001\u000f<fe&4\u0017\u0010V8qS\u000elU\r^1eCR\f\u0007+\u0019:uSRLwN\u001c'fC\u0012,'o\u0014:F]\u0012\u0004x.\u001b8u\u001d>$\u0018I^1jY\u0006\u0014G.\u001a\u000b\u0007Ou\u001a7\u000e\u001d=\t\u000byJ\u0001\u0019A \u0002\u000f\t\u0014xn[3sgB\u0019\u0001\tS&\u000f\u0005\u00053eB\u0001\"F\u001b\u0005\u0019%B\u0001#\u0014\u0003\u0019a$o\\8u}%\t\u0001$\u0003\u0002H/\u00059\u0001/Y2lC\u001e,\u0017BA%K\u0005\r\u0019V-\u001d\u0006\u0003\u000f^\u0001\"\u0001\u00141\u000f\u00055kfB\u0001([\u001d\tyuK\u0004\u0002Q+:\u0011\u0011k\u0015\b\u0003\u0005JK\u0011\u0001M\u0005\u0003)>\na!\u00199bG\",\u0017B\u0001\nW\u0015\t!v&\u0003\u0002Y3\u000611m\\7n_:T!A\u0005,\n\u0005mc\u0016aB7fgN\fw-\u001a\u0006\u00031fK!AX0\u00023U\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti\u0012\u000bG/\u0019\u0006\u00037rK!!\u00192\u0003)U\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uC\n\u0013xn[3s\u0015\tqv\fC\u0003e\u0013\u0001\u0007Q-\u0001\u0007mSN$XM\\3s\u001d\u0006lW\r\u0005\u0002gS6\tqM\u0003\u0002i9\u00069a.\u001a;x_J\\\u0017B\u00016h\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f\u0011\u0015a\u0017\u00021\u0001n\u0003\u0019aW-\u00193feB\u0011aC\\\u0005\u0003_^\u00111!\u00138u\u0011\u0015\t\u0018\u00021\u0001s\u00035)\u0007\u0010]3di\u0016$WI\u001d:peB\u00111O^\u0007\u0002i*\u0011Q\u000fX\u0001\taJ|Go\\2pY&\u0011q\u000f\u001e\u0002\u0007\u000bJ\u0014xN]:\t\u000beL\u0001\u0019\u0001>\u00023\u0015\u0014(o\u001c:V]\u00064\u0018-\u001b7bE2,G*[:uK:,'o\u001d\t\u0003-mL!\u0001`\f\u0003\u000f\t{w\u000e\\3b]\u0006\u0019s-\u001a;U_BL7-T3uC\u0012\fG/\u0019*fa2L7-\u0019(pi\u00063\u0018-\u001b7bE2,\u0007F\u0001\u0006,\u0003}9W\r\u001e+pa&\u001cW*\u001a;bI\u0006$\u0018-S:s\u001d>$\u0018I^1jY\u0006\u0014G.\u001a\u0015\u0003\u0017-\n\u0001gZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1XSRDgj\u001c8TkB\u0004xN\u001d;fIN+7-\u001e:jif\u0004&o\u001c;pG>d\u0007F\u0001\u0007,\u00039:W\r^!mSZ,'I]8lKJ\u001c8\u000b[8vY\u0012tu\u000e\u001e\"f\u001bV$\u0018\r^3e\u0005f,\u0006\u000fZ1uK\u000e\u000b7\r[3)\u00055Y\u0003")
public class MetadataCacheTest {
    private final long brokerEpoch;

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    @Test
    public void getTopicMetadataNonExistingTopics() {
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        Seq topicMetadata = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), cache.getTopicMetadata$default$3(), cache.getTopicMetadata$default$4());
        Assert.assertTrue((boolean)topicMetadata.isEmpty());
    }

    @Test
    public void getTopicMetadata() {
        String topic0 = "topic-0";
        String topic1 = "topic-1";
        MetadataCache cache = new MetadataCache(1);
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable & scala.Serializable)brokerId -> MetadataCacheTest.$anonfun$getTopicMetadata$1(BoxesRunTime.unboxToInt((Object)brokerId)), IndexedSeq$.MODULE$.canBuildFrom());
        Seq partitionStates = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataPartitionState[]{new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic0).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(0).setLeaderEpoch(0).setIsr(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3)})).setZkVersion(zkVersion).setReplicas(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3)})), new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic0).setPartitionIndex(1).setControllerEpoch(controllerEpoch).setLeader(1).setLeaderEpoch(1).setIsr(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)})).setZkVersion(zkVersion).setReplicas(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(4)})), new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic1).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(2).setLeaderEpoch(2).setIsr(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1)})).setZkVersion(zkVersion).setReplicas(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3)}))}));
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(partitionStates).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)brokers).asJava()).build();
        cache.updateMetadata(15, updateMetadataRequest);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SecurityProtocol[]{SecurityProtocol.PLAINTEXT, SecurityProtocol.SSL}))).foreach((Function1 & Serializable & scala.Serializable)securityProtocol -> {
            MetadataCacheTest.$anonfun$getTopicMetadata$2(cache, partitionStates, topic0, topic1, securityProtocol);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void getTopicMetadataPartitionLeaderNotAvailable() {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        Seq brokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataBroker[]{new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataEndpoint[]{new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value())}))).asJava())}));
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable((Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, listenerName, 1, Errors.LEADER_NOT_AVAILABLE, false);
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable((Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, listenerName, 1, Errors.LEADER_NOT_AVAILABLE, true);
    }

    @Test
    public void getTopicMetadataPartitionListenerNotAvailableOnLeader() {
        ListenerName plaintextListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        ListenerName sslListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL);
        Seq broker0Endpoints = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataEndpoint[]{new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host0").setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(plaintextListenerName.value()), new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host0").setPort(9093).setSecurityProtocol(SecurityProtocol.SSL.id).setListener(sslListenerName.value())}));
        Seq broker1Endpoints = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataEndpoint[]{new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host1").setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(plaintextListenerName.value())}));
        Seq brokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataBroker[]{new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints((List)JavaConverters$.MODULE$.seqAsJavaListConverter(broker0Endpoints).asJava()), new UpdateMetadataRequestData.UpdateMetadataBroker().setId(1).setEndpoints((List)JavaConverters$.MODULE$.seqAsJavaListConverter(broker1Endpoints).asJava())}));
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable((Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, sslListenerName, 1, Errors.LISTENER_NOT_FOUND, true);
    }

    @Test
    public void getTopicMetadataPartitionListenerNotAvailableOnLeaderOldMetadataVersion() {
        ListenerName plaintextListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        ListenerName sslListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL);
        Seq broker0Endpoints = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataEndpoint[]{new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host0").setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(plaintextListenerName.value()), new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host0").setPort(9093).setSecurityProtocol(SecurityProtocol.SSL.id).setListener(sslListenerName.value())}));
        Seq broker1Endpoints = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataEndpoint[]{new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host1").setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(plaintextListenerName.value())}));
        Seq brokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataBroker[]{new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints((List)JavaConverters$.MODULE$.seqAsJavaListConverter(broker0Endpoints).asJava()), new UpdateMetadataRequestData.UpdateMetadataBroker().setId(1).setEndpoints((List)JavaConverters$.MODULE$.seqAsJavaListConverter(broker1Endpoints).asJava())}));
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable((Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, sslListenerName, 1, Errors.LEADER_NOT_AVAILABLE, false);
    }

    private void verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(Seq<UpdateMetadataRequestData.UpdateMetadataBroker> brokers, ListenerName listenerName, int leader, Errors expectedError, boolean errorUnavailableListeners) {
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        int leaderEpoch = 1;
        Seq partitionStates = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataPartitionState[]{new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)})).setZkVersion(zkVersion).setReplicas(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)}))}));
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(partitionStates).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(brokers).asJava()).build();
        cache.updateMetadata(15, updateMetadataRequest);
        scala.collection.immutable.Set x$1 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}));
        ListenerName x$2 = listenerName;
        boolean x$3 = errorUnavailableListeners;
        boolean x$4 = cache.getTopicMetadata$default$3();
        Seq topicMetadatas = cache.getTopicMetadata((Set)x$1, x$2, x$4, x$3);
        Assert.assertEquals((long)1L, (long)topicMetadatas.size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)topicMetadatas.head();
        Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
        List partitionMetadatas = topicMetadata.partitionMetadata();
        Assert.assertEquals((long)1L, (long)partitionMetadatas.size());
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)partitionMetadatas.get(0);
        Assert.assertEquals((long)0L, (long)partitionMetadata.partition());
        Assert.assertEquals((Object)expectedError, (Object)partitionMetadata.error());
        Assert.assertFalse((boolean)partitionMetadata.isr().isEmpty());
        Assert.assertEquals((long)1L, (long)partitionMetadata.replicas().size());
        Assert.assertEquals((long)0L, (long)((Node)partitionMetadata.replicas().get(0)).id());
    }

    @Test
    public void getTopicMetadataReplicaNotAvailable() {
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        Seq brokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataBroker[]{new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataEndpoint[]{new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value())}))).asJava())}));
        int leader = 0;
        int leaderEpoch = 0;
        List<Object> replicas = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)});
        List<Object> isr = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)});
        Seq partitionStates = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataPartitionState[]{new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(zkVersion).setReplicas(replicas)}));
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(partitionStates).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(brokers).asJava()).build();
        cache.updateMetadata(15, updateMetadataRequest);
        Seq topicMetadatas = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, false, cache.getTopicMetadata$default$4());
        Assert.assertEquals((long)1L, (long)topicMetadatas.size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)topicMetadatas.head();
        Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
        List partitionMetadatas = topicMetadata.partitionMetadata();
        Assert.assertEquals((long)1L, (long)partitionMetadatas.size());
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)partitionMetadatas.get(0);
        Assert.assertEquals((long)0L, (long)partitionMetadata.partition());
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionMetadata.error());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.id()), Buffer$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.isr()).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.id()), Buffer$.MODULE$.canBuildFrom())).toSet());
        Seq topicMetadatasWithError = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, true, cache.getTopicMetadata$default$4());
        Assert.assertEquals((long)1L, (long)topicMetadatasWithError.size());
        MetadataResponse.TopicMetadata topicMetadataWithError = (MetadataResponse.TopicMetadata)topicMetadatasWithError.head();
        Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadataWithError.error());
        List partitionMetadatasWithError = topicMetadataWithError.partitionMetadata();
        Assert.assertEquals((long)1L, (long)partitionMetadatasWithError.size());
        MetadataResponse.PartitionMetadata partitionMetadataWithError = (MetadataResponse.PartitionMetadata)partitionMetadatasWithError.get(0);
        Assert.assertEquals((long)0L, (long)partitionMetadataWithError.partition());
        Assert.assertEquals((Object)Errors.REPLICA_NOT_AVAILABLE, (Object)partitionMetadataWithError.error());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadataWithError.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.id()), Buffer$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadataWithError.isr()).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.id()), Buffer$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void getTopicMetadataIsrNotAvailable() {
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        Seq brokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataBroker[]{new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("rack1").setEndpoints((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataEndpoint[]{new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value())}))).asJava())}));
        int leader = 0;
        int leaderEpoch = 0;
        List<Object> replicas = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)});
        List<Object> isr = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)});
        Seq partitionStates = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataPartitionState[]{new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(zkVersion).setReplicas(replicas)}));
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(partitionStates).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(brokers).asJava()).build();
        cache.updateMetadata(15, updateMetadataRequest);
        Seq topicMetadatas = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, false, cache.getTopicMetadata$default$4());
        Assert.assertEquals((long)1L, (long)topicMetadatas.size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)topicMetadatas.head();
        Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
        List partitionMetadatas = topicMetadata.partitionMetadata();
        Assert.assertEquals((long)1L, (long)partitionMetadatas.size());
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)partitionMetadatas.get(0);
        Assert.assertEquals((long)0L, (long)partitionMetadata.partition());
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionMetadata.error());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.id()), Buffer$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.isr()).asScala()).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.id()), Buffer$.MODULE$.canBuildFrom())).toSet());
        Seq topicMetadatasWithError = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, true, cache.getTopicMetadata$default$4());
        Assert.assertEquals((long)1L, (long)topicMetadatasWithError.size());
        MetadataResponse.TopicMetadata topicMetadataWithError = (MetadataResponse.TopicMetadata)topicMetadatasWithError.head();
        Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadataWithError.error());
        List partitionMetadatasWithError = topicMetadataWithError.partitionMetadata();
        Assert.assertEquals((long)1L, (long)partitionMetadatasWithError.size());
        MetadataResponse.PartitionMetadata partitionMetadataWithError = (MetadataResponse.PartitionMetadata)partitionMetadatasWithError.get(0);
        Assert.assertEquals((long)0L, (long)partitionMetadataWithError.partition());
        Assert.assertEquals((Object)Errors.REPLICA_NOT_AVAILABLE, (Object)partitionMetadataWithError.error());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadataWithError.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.id()), Buffer$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadataWithError.isr()).asScala()).map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.id()), Buffer$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void getTopicMetadataWithNonSupportedSecurityProtocol() {
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        Seq brokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataBroker[]{new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("").setEndpoints((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataEndpoint[]{new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).value())}))).asJava())}));
        int controllerEpoch = 1;
        int leader = 0;
        int leaderEpoch = 0;
        List<Object> replicas = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)});
        List<Object> isr = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)});
        Seq partitionStates = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataPartitionState[]{new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(3).setReplicas(replicas)}));
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(partitionStates).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(brokers).asJava()).build();
        cache.updateMetadata(15, updateMetadataRequest);
        Seq topicMetadata = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL), cache.getTopicMetadata$default$3(), cache.getTopicMetadata$default$4());
        Assert.assertEquals((long)1L, (long)topicMetadata.size());
        Assert.assertEquals((long)1L, (long)((MetadataResponse.TopicMetadata)topicMetadata.head()).partitionMetadata().size());
        Assert.assertEquals((long)-1L, (long)((MetadataResponse.PartitionMetadata)((MetadataResponse.TopicMetadata)topicMetadata.head()).partitionMetadata().get(0)).leaderId());
    }

    @Test
    public void getAliveBrokersShouldNotBeMutatedByUpdateCache() {
        String topic = "topic";
        MetadataCache cache = new MetadataCache(1);
        Range.Inclusive initialBrokerIds = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2);
        this.updateCache$1((Seq)initialBrokerIds, topic, cache);
        Seq aliveBrokersFromCache = cache.getAliveBrokers();
        this.updateCache$1((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3), topic, cache);
        Assert.assertEquals((Object)initialBrokerIds.toSet(), (Object)((TraversableOnce)aliveBrokersFromCache.map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.id()), Seq$.MODULE$.canBuildFrom())).toSet());
    }

    private static final Seq endpoints$1(int brokerId) {
        String host = new StringBuilder(4).append("foo-").append(brokerId).toString();
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataEndpoint[]{new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(host).setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT).value()), new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(host).setPort(9093).setSecurityProtocol(SecurityProtocol.SSL.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL).value())}));
    }

    public static final /* synthetic */ UpdateMetadataRequestData.UpdateMetadataBroker $anonfun$getTopicMetadata$1(int brokerId) {
        return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(brokerId).setEndpoints((List)JavaConverters$.MODULE$.seqAsJavaListConverter(MetadataCacheTest.endpoints$1(brokerId)).asJava()).setRack("rack1");
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$3(String topic$1, UpdateMetadataRequestData.UpdateMetadataPartitionState ps) {
        String string = ps.topicName();
        String string2 = topic$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$6(int partitionId$1, UpdateMetadataRequestData.UpdateMetadataPartitionState x$2) {
        return x$2.partitionIndex() == partitionId$1;
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$10(ListenerName listenerName$1, UpdateMetadataRequestData.UpdateMetadataEndpoint x$5) {
        String string = x$5.listener();
        String string2 = listenerName$1.value();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$getTopicMetadata$5(Seq topicPartitionStates$1, ListenerName listenerName$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)tuple2._1();
        int partitionId = tuple2._2$mcI$sp();
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionMetadata.error());
        Assert.assertEquals((long)partitionId, (long)partitionMetadata.partition());
        Node leader = partitionMetadata.leader();
        UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)topicPartitionStates$1.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetadataCacheTest.$anonfun$getTopicMetadata$6(partitionId, x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Assertions$.MODULE$.fail(new StringBuilder(45).append("Unable to find partition state for partition ").append(partitionId).toString(), new Position("MetadataCacheTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133)));
        Assert.assertEquals((long)partitionState.leader(), (long)leader.id());
        Assert.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)partitionState.leaderEpoch())), (Object)partitionMetadata.leaderEpoch());
        Assert.assertEquals((Object)partitionState.isr(), (Object)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.isr()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.id()), Buffer$.MODULE$.canBuildFrom())).asJava());
        Assert.assertEquals((Object)partitionState.replicas(), (Object)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Buffer$.MODULE$.canBuildFrom())).asJava());
        UpdateMetadataRequestData.UpdateMetadataEndpoint endpoint = (UpdateMetadataRequestData.UpdateMetadataEndpoint)MetadataCacheTest.endpoints$1(partitionMetadata.leader().id()).find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetadataCacheTest.$anonfun$getTopicMetadata$10(listenerName$1, x$5))).get();
        Assert.assertEquals((Object)endpoint.host(), (Object)leader.host());
        Assert.assertEquals((long)endpoint.port(), (long)leader.port());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final void checkTopicMetadata$1(String topic, MetadataCache cache$1, ListenerName listenerName$1, Seq partitionStates$1) {
        Seq topicMetadatas = cache$1.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName$1, cache$1.getTopicMetadata$default$3(), cache$1.getTopicMetadata$default$4());
        Assert.assertEquals((long)1L, (long)topicMetadatas.size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)topicMetadatas.head();
        Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
        Assert.assertEquals((Object)topic, (Object)topicMetadata.topic());
        Seq topicPartitionStates = (Seq)partitionStates$1.filter((Function1 & Serializable & scala.Serializable)ps -> BoxesRunTime.boxToBoolean((boolean)MetadataCacheTest.$anonfun$getTopicMetadata$3(topic, ps)));
        Buffer partitionMetadatas = (Buffer)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(topicMetadata.partitionMetadata()).asScala()).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.partition()), (Ordering)Ordering.Int$.MODULE$);
        Assert.assertEquals((String)new StringBuilder(37).append("Unexpected partition count for topic ").append(topic).toString(), (long)topicPartitionStates.size(), (long)partitionMetadatas.size());
        ((IterableLike)partitionMetadatas.zipWithIndex(Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            MetadataCacheTest.$anonfun$getTopicMetadata$5(topicPartitionStates, listenerName$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$getTopicMetadata$2(MetadataCache cache$1, Seq partitionStates$1, String topic0$1, String topic1$1, SecurityProtocol securityProtocol) {
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        MetadataCacheTest.checkTopicMetadata$1(topic0$1, cache$1, listenerName, partitionStates$1);
        MetadataCacheTest.checkTopicMetadata$1(topic1$1, cache$1, listenerName, partitionStates$1);
    }

    public static final /* synthetic */ UpdateMetadataRequestData.UpdateMetadataBroker $anonfun$getAliveBrokersShouldNotBeMutatedByUpdateCache$1(int brokerId) {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(brokerId).setRack("").setEndpoints((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataEndpoint[]{new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).value())}))).asJava());
    }

    private final void updateCache$1(Seq brokerIds, String topic$2, MetadataCache cache$2) {
        Seq brokers = (Seq)brokerIds.map((Function1 & Serializable & scala.Serializable)brokerId -> MetadataCacheTest.$anonfun$getAliveBrokersShouldNotBeMutatedByUpdateCache$1(BoxesRunTime.unboxToInt((Object)brokerId)), Seq$.MODULE$.canBuildFrom());
        int controllerEpoch = 1;
        int leader = 0;
        int leaderEpoch = 0;
        List<Object> replicas = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)});
        List<Object> isr = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)});
        Seq partitionStates = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataPartitionState[]{new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic$2).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(3).setReplicas(replicas)}));
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, this.brokerEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(partitionStates).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(brokers).asJava()).build();
        cache$2.updateMetadata(15, updateMetadataRequest);
    }

    public MetadataCacheTest() {
        this.brokerEpoch = 0L;
    }
}

