/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaType;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001B\r\u001b\u0001}AQA\n\u0001\u0005\u0002\u001dBQA\u000b\u0001\u0005\u0002-Bq!\u000f\u0001C\u0002\u0013\u0005!\b\u0003\u0004B\u0001\u0001\u0006Ia\u000f\u0005\b\u0005\u0002\u0001\r\u0011\"\u0001D\u0011\u001d\u0019\u0006\u00011A\u0005\u0002QCaA\u0017\u0001!B\u0013!\u0005bB.\u0001\u0005\u0004%\t\u0001\u0018\u0005\u0007K\u0002\u0001\u000b\u0011B/\t\u000f\u0019\u0004\u0001\u0019!C\u0001O\"9A\u000f\u0001a\u0001\n\u0003)\bBB<\u0001A\u0003&\u0001\u000eC\u0003y\u0001\u0011\u0005\u0013\u0010\u0003\u0004\u0002\u0004\u0001!\t!\u001f\u0005\u0007\u0003\u001b\u0001A\u0011A=\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014!9\u0011q\u0004\u0001\u0005\u0002\u0005\u0005\u0002BBA\u001a\u0001\u0011\u0005\u0011\u0010C\u0004\u00028\u0001!\t!!\u000f\t\u000f\u0005\r\u0003\u0001\"\u0003\u0002F!9\u00111\u000b\u0001\u0005\n\u0005U\u0003bBA.\u0001\u0011\u0005\u0011Q\f\u0005\b\u0003K\u0002A\u0011BA4\u0011\u001d\tY\b\u0001C\u0005\u0003{\u0012QCU3qY&\u001c\u0017\r^5p]F+x\u000e^1t)\u0016\u001cHO\u0003\u0002\u001c9\u000511/\u001a:wKJT\u0011!H\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0005\u0005\u0002\"I5\t!E\u0003\u0002$9\u0005\u0011!p[\u0005\u0003K\t\u0012ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001)!\tI\u0003!D\u0001\u001b\u00031\u0001XM]2f]R,%O]8s)\ra#g\u000e\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0005\u0019>tw\rC\u00034\u0005\u0001\u0007A'A\u0004qKJ\u001cWM\u001c;\u0011\u00055*\u0014B\u0001\u001c/\u0005\rIe\u000e\u001e\u0005\u0006q\t\u0001\r\u0001L\u0001\u0006m\u0006dW/Z\u0001\t[N<\u0017\u0007\r\u0019L\u0005V\t1\bE\u0002.yyJ!!\u0010\u0018\u0003\u000b\u0005\u0013(/Y=\u0011\u00055z\u0014B\u0001!/\u0005\u0011\u0011\u0015\u0010^3\u0002\u00135\u001cx-\r\u00191\u0017\n\u0003\u0013a\u00022s_.,'o]\u000b\u0002\tB\u0019Q)\u0014)\u000f\u0005\u0019[eBA$K\u001b\u0005A%BA%\u001f\u0003\u0019a$o\\8u}%\tq&\u0003\u0002M]\u00059\u0001/Y2lC\u001e,\u0017B\u0001(P\u0005\r\u0019V-\u001d\u0006\u0003\u0019:\u0002\"!K)\n\u0005IS\"aC&bM.\f7+\u001a:wKJ\f1B\u0019:pW\u0016\u00148o\u0018\u0013fcR\u0011Q\u000b\u0017\t\u0003[YK!a\u0016\u0018\u0003\tUs\u0017\u000e\u001e\u0005\b3\u001a\t\t\u00111\u0001E\u0003\rAH%M\u0001\tEJ|7.\u001a:tA\u0005)Ao\u001c9jGV\tQ\f\u0005\u0002_G6\tqL\u0003\u0002aC\u0006!A.\u00198h\u0015\u0005\u0011\u0017\u0001\u00026bm\u0006L!\u0001Z0\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u0005A\u0001O]8ek\u000e,'/F\u0001i!\u0011I'oO\u001e\u000e\u0003)T!AZ6\u000b\u00051l\u0017aB2mS\u0016tGo\u001d\u0006\u0003;9T!a\u001c9\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0018aA8sO&\u00111O\u001b\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\u0002\u0019A\u0014x\u000eZ;dKJ|F%Z9\u0015\u0005U3\bbB-\f\u0003\u0003\u0005\r\u0001[\u0001\naJ|G-^2fe\u0002\n\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002+\"\u0012Qb\u001f\t\u0003y~l\u0011! \u0006\u0003}B\fQA[;oSRL1!!\u0001~\u0005\u0015\te\r^3s\u0003-\u001a\bn\\;mI\n{w\u000e^:ue\u0006\u0004Hk^8Ce>\\WM]:XSRDG*Z1eKJ$\u0006N]8ui2,\u0007f\u0001\b\u0002\bA\u0019A0!\u0003\n\u0007\u0005-QP\u0001\u0003UKN$\u0018!L:i_VdGMQ8piN$(/\u00199Uo>\u0014%o\\6feN<\u0016\u000e\u001e5G_2dwn^3s)\"\u0014x\u000e\u001e;mK\"\u001aq\"a\u0002\u0002mMDw.\u001e7e\u001b\u0006$8\r[)v_R\f'+\u001a9mS\u000e\fG/\u001b8h)\"\u0014x.^4i\u0003:\f5/_7nKR\u0014\u0018n\u0019+pa>dwnZ=\u0015\u0007U\u000b)\u0002C\u0004\u0002\u0018A\u0001\r!!\u0007\u0002\u001d1,\u0017\rZ3s)\"\u0014x\u000e\u001e;mKB\u0019Q&a\u0007\n\u0007\u0005uaFA\u0004C_>dW-\u00198\u0002\u0005Q\u0004H\u0003BA\u0012\u0003_\u0001B!!\n\u0002,5\u0011\u0011q\u0005\u0006\u0004\u0003Si\u0017AB2p[6|g.\u0003\u0003\u0002.\u0005\u001d\"A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0007\u0003c\t\u0002\u0019\u0001\u001b\u0002\u0013A\f'\u000f^5uS>t\u0017!G:i_VdG\r\u00165s_R$H.Z(mIN+w-\\3oiND3AEA\u0004\u0003\u001d\tG\r\u001a#bi\u0006$R!VA\u001e\u0003\u007fAa!!\u0010\u0014\u0001\u0004!\u0014\u0001C7tO\u000e{WO\u001c;\t\r\u0005\u00053\u00031\u0001<\u0003\ri7oZ\u0001\u0016o\u0006LGOR8s\u001f\u001a47/\u001a;t)>l\u0015\r^2i)\u001d)\u0016qIA&\u0003\u001fBa!!\u0013\u0015\u0001\u0004!\u0014AB8gMN,G\u000f\u0003\u0004\u0002NQ\u0001\r\u0001N\u0001\fa\u0006\u0014H/\u001b;j_:LE\r\u0003\u0004\u0002RQ\u0001\r\u0001N\u0001\tEJ|7.\u001a:JI\u0006I!M]8lKJ4uN\u001d\u000b\u0004!\u0006]\u0003BBA-+\u0001\u0007A'\u0001\u0002jI\u0006i1M]3bi\u0016\u0014%o\\6feN$2!VA0\u0011\u001d\t\tG\u0006a\u0001\u0003G\n\u0011B\u0019:pW\u0016\u0014\u0018\nZ:\u0011\u0007\u0015kE'\u0001\u0004bmJ\u000bG/\u001a\u000b\u0007\u0003S\ny'!\u001f\u0011\u00075\nY'C\u0002\u0002n9\u0012a\u0001R8vE2,\u0007bBA9/\u0001\u0007\u00111O\u0001\u0010e\u0016\u0004H.[2bi&|g\u000eV=qKB\u0019\u0011&!\u001e\n\u0007\u0005]$DA\u0005Rk>$\u0018\rV=qK\"1!i\u0006a\u0001\u0003G\nA\"\\3bgV\u0014X\r\u001a*bi\u0016$b!!\u001b\u0002\u0000\u0005\r\u0005BBAA1\u0001\u0007\u0001+\u0001\u0004ce>\\WM\u001d\u0005\b\u0003\u000bC\u0002\u0019AA:\u0003\u001d\u0011X\r\u001d+za\u0016\u0004")
public class ReplicationQuotasTest
extends ZooKeeperTestHarness {
    private final byte[] msg100KB = new byte[100000];
    private Seq<KafkaServer> brokers = null;
    private final String topic;
    private KafkaProducer<byte[], byte[]> producer = null;

    public long percentError(int percent, long value) {
        return Math.round(value * (long)percent / 100L);
    }

    public byte[] msg100KB() {
        return this.msg100KB;
    }

    public Seq<KafkaServer> brokers() {
        return this.brokers;
    }

    public void brokers_$eq(Seq<KafkaServer> x$1) {
        this.brokers = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    @Override
    @After
    public void tearDown() {
        this.producer().close();
        TestUtils$.MODULE$.shutdownServers(this.brokers());
        super.tearDown();
    }

    @Test
    public void shouldBootstrapTwoBrokersWithLeaderThrottle() {
        this.shouldMatchQuotaReplicatingThroughAnAsymmetricTopology(true);
    }

    @Test
    public void shouldBootstrapTwoBrokersWithFollowerThrottle() {
        this.shouldMatchQuotaReplicatingThroughAnAsymmetricTopology(false);
    }

    public void shouldMatchQuotaReplicatingThroughAnAsymmetricTopology(boolean leaderThrottle) {
        this.brokers_$eq((Seq<KafkaServer>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 105).map((Function1 & Serializable & scala.Serializable)id -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(BoxesRunTime.unboxToInt((Object)id), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), TestUtils$.MODULE$.createServer$default$2()), IndexedSeq$.MODULE$.canBuildFrom())));
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{102, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{104, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{105, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 107})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)assignment, this.brokers());
        byte[] msg = this.msg100KB();
        int msgCount = 100;
        int expectedDuration = 10;
        LongRef throttle = LongRef.create((long)(msgCount * msg.length / expectedDuration));
        if (!leaderThrottle) {
            throttle.elem *= 3L;
        }
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 107).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> this.adminZkClient().changeBrokerConfig((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{brokerId})), CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)((Object)BoxesRunTime.boxToLong((long)throttle$1.elem)).toString()), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)((Object)BoxesRunTime.boxToLong((long)throttle$1.elem)).toString())}))));
        if (leaderThrottle) {
            this.adminZkClient().changeTopicConfig(this.topic(), CoreUtils$.MODULE$.propsWith(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "0:100,1:101,2:102,3:103,4:104,5:105"));
        } else {
            this.adminZkClient().changeTopicConfig(this.topic(), CoreUtils$.MODULE$.propsWith(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), "0:106,1:106,2:106,3:107,4:107,5:107"));
        }
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), 1, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), msgCount).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 7).foreach((Function1 & Serializable & scala.Serializable)partition -> ReplicationQuotasTest.$anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$4(this, msg, BoxesRunTime.unboxToInt((Object)partition))));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)id -> this.waitForOffsetsToMatch(msgCount, id, 100 + id));
        this.waitForOffsetsToMatch(msgCount, 6, 100);
        this.waitForOffsetsToMatch(msgCount, 7, 101);
        long start = System.currentTimeMillis();
        this.createBrokers((Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(106), 107));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(106), 107).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Assert.assertEquals((long)throttle$1.elem, (long)this.brokerFor(brokerId).quotaManagers().follower().upperBound()));
        if (!leaderThrottle) {
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> Assert.assertTrue((boolean)this.brokerFor(106).quotaManagers().follower().isThrottled(this.tp(partition))));
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(3), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> Assert.assertTrue((boolean)this.brokerFor(107).quotaManagers().follower().isThrottled(this.tp(partition))));
        }
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(6), 7).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)id -> this.waitForOffsetsToMatch(msgCount, id, 100 + id));
        long unthrottledTook = System.currentTimeMillis() - start;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)id -> this.waitForOffsetsToMatch(msgCount, id, 106));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(3), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)id -> this.waitForOffsetsToMatch(msgCount, id, 107));
        long throttledTook = System.currentTimeMillis() - start;
        double throttledLowerBound = (double)(expectedDuration * 1000) * 0.9;
        int throttledUpperBound = expectedDuration * 1000 * 3;
        Assert.assertTrue((String)new StringBuilder(12).append("Expected ").append(unthrottledTook).append(" < ").append(throttledLowerBound).toString(), ((double)unthrottledTook < throttledLowerBound ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringBuilder(12).append("Expected ").append(throttledTook).append(" > ").append(throttledLowerBound).toString(), ((double)throttledTook > throttledLowerBound ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringBuilder(12).append("Expected ").append(throttledTook).append(" < ").append(throttledUpperBound).toString(), (throttledTook < (long)throttledUpperBound ? 1 : 0) != 0);
        double rateUpperBound = (double)throttle.elem * 1.1;
        double rateLowerBound = (double)throttle.elem * 0.5;
        double rate = leaderThrottle ? this.avRate((QuotaType)QuotaType.LeaderReplication$.MODULE$, (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 105)) : this.avRate((QuotaType)QuotaType.FollowerReplication$.MODULE$, (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(106), 107));
        Assert.assertTrue((String)new StringBuilder(12).append("Expected ").append(rate).append(" < ").append(rateUpperBound).toString(), (rate < rateUpperBound ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringBuilder(12).append("Expected ").append(rate).append(" > ").append(rateLowerBound).toString(), (rate > rateLowerBound ? 1 : 0) != 0);
    }

    public TopicPartition tp(int partition) {
        return new TopicPartition(this.topic(), partition);
    }

    @Test
    public void shouldThrottleOldSegments() {
        Properties config = TestUtils$.MODULE$.createBrokerConfig(100, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        config.put("log.segment.bytes", ((Object)BoxesRunTime.boxToInteger((int)0x100000)).toString());
        this.brokers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), TestUtils$.MODULE$.createServer$default$2())}))));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.brokers());
        byte[] msg = this.msg100KB();
        int msgCount = 200;
        int expectedDuration = 4;
        long throttle = msg.length * msgCount / expectedDuration;
        this.adminZkClient().changeBrokerConfig((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})), CoreUtils$.MODULE$.propsWith(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), ((Object)BoxesRunTime.boxToLong((long)throttle)).toString()));
        this.adminZkClient().changeTopicConfig(this.topic(), CoreUtils$.MODULE$.propsWith(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "0:100"));
        this.addData(msgCount, msg);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting new broker");
        this.brokers_$eq((Seq<KafkaServer>)((Seq)this.brokers().$colon$plus((Object)TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(101, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        long start = System.currentTimeMillis();
        this.waitForOffsetsToMatch(msgCount, 0, 101);
        long throttledTook = System.currentTimeMillis() - start;
        Assert.assertTrue((String)new StringBuilder(42).append("Throttled replication of ").append(throttledTook).append("ms should be > ").append((double)(expectedDuration * 1000) * 0.9).append("ms").toString(), ((double)throttledTook > (double)(expectedDuration * 1000) * 0.9 ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringBuilder(42).append("Throttled replication of ").append(throttledTook).append("ms should be < ").append(expectedDuration * 1500).append("ms").toString(), ((double)throttledTook < (double)(expectedDuration * 1000) * 1.5 ? 1 : 0) != 0);
    }

    public void addData(int msgCount, byte[] msg) {
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), 0, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15()));
        ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), msgCount).map((Function1 & Serializable & scala.Serializable)x$2 -> ReplicationQuotasTest.$anonfun$addData$1(this, msg, BoxesRunTime.unboxToInt((Object)x$2)), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$3 -> (RecordMetadata)x$3.get());
        this.waitForOffsetsToMatch(msgCount, 0, 100);
    }

    private void waitForOffsetsToMatch(int offset, int partitionId, int brokerId) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            LogManager qual$1 = this.brokerFor(brokerId).getLogManager();
            TopicPartition x$1 = new TopicPartition(this.topic(), partitionId);
            boolean x$2 = qual$1.getLog$default$2();
            return BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)offset), (Object)qual$1.getLog(x$1, x$2).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.logEndOffset())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Offsets did not match for partition ").append(partitionId).append(" on broker ").append(brokerId).toString(), 60000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private KafkaServer brokerFor(int id) {
        return (KafkaServer)((IterableLike)this.brokers().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ReplicationQuotasTest.$anonfun$brokerFor$1(id, x$5)))).head();
    }

    public void createBrokers(Seq<Object> brokerIds) {
        brokerIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)id -> this.brokers_$eq((Seq<KafkaServer>)((Seq)this.brokers().$colon$plus((Object)TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(id, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom()))));
    }

    private double avRate(QuotaType replicationType, Seq<Object> brokers) {
        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)brokers.map((Function1 & Serializable & scala.Serializable)id -> this.brokerFor(BoxesRunTime.unboxToInt((Object)id)), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToDouble((double)this.measuredRate(x$6, replicationType)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)brokers.length();
    }

    private double measuredRate(KafkaServer broker, QuotaType repType) {
        MetricName metricName = broker.metrics().metricName("byte-rate", repType.toString());
        return BoxesRunTime.unboxToDouble((Object)((KafkaMetric)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(broker.metrics().metrics()).asScala()).apply((Object)metricName)).metricValue());
    }

    public static final /* synthetic */ Future $anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$4(ReplicationQuotasTest $this, byte[] msg$1, int partition) {
        return $this.producer().send(new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)msg$1));
    }

    public static final /* synthetic */ Future $anonfun$addData$1(ReplicationQuotasTest $this, byte[] msg$2, int x$2) {
        return $this.producer().send(new ProducerRecord($this.topic(), (Object)msg$2));
    }

    public static final /* synthetic */ boolean $anonfun$brokerFor$1(int id$1, KafkaServer x$5) {
        return x$5.config().brokerId() == id$1;
    }

    public ReplicationQuotasTest() {
        this.topic = "topic1";
    }
}

