/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Optional;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_0_10_1_IV0$;
import kafka.api.KAFKA_2_1_IV0$;
import kafka.api.KAFKA_2_1_IV1$;
import kafka.api.KAFKA_2_3_IV0$;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.coordinator.group.BaseKey;
import kafka.coordinator.group.Empty$;
import kafka.coordinator.group.GroupMetadata;
import kafka.coordinator.group.GroupMetadata$;
import kafka.coordinator.group.GroupMetadataKey;
import kafka.coordinator.group.GroupState;
import kafka.coordinator.group.GroupTopicPartition;
import kafka.coordinator.group.MemberMetadata;
import kafka.coordinator.group.OffsetKey;
import kafka.coordinator.group.Stable$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.BoundField;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class GroupMetadataManager$ {
    public static GroupMetadataManager$ MODULE$;
    private final short CURRENT_OFFSET_KEY_SCHEMA_VERSION;
    private final short CURRENT_GROUP_KEY_SCHEMA_VERSION;
    private final Schema OFFSET_COMMIT_KEY_SCHEMA;
    private final BoundField OFFSET_KEY_GROUP_FIELD;
    private final BoundField OFFSET_KEY_TOPIC_FIELD;
    private final BoundField OFFSET_KEY_PARTITION_FIELD;
    private final Schema OFFSET_COMMIT_VALUE_SCHEMA_V0;
    private final BoundField OFFSET_VALUE_OFFSET_FIELD_V0;
    private final BoundField OFFSET_VALUE_METADATA_FIELD_V0;
    private final BoundField OFFSET_VALUE_TIMESTAMP_FIELD_V0;
    private final Schema OFFSET_COMMIT_VALUE_SCHEMA_V1;
    private final BoundField OFFSET_VALUE_OFFSET_FIELD_V1;
    private final BoundField OFFSET_VALUE_METADATA_FIELD_V1;
    private final BoundField OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1;
    private final BoundField OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1;
    private final Schema OFFSET_COMMIT_VALUE_SCHEMA_V2;
    private final BoundField OFFSET_VALUE_OFFSET_FIELD_V2;
    private final BoundField OFFSET_VALUE_METADATA_FIELD_V2;
    private final BoundField OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V2;
    private final Schema OFFSET_COMMIT_VALUE_SCHEMA_V3;
    private final BoundField OFFSET_VALUE_OFFSET_FIELD_V3;
    private final BoundField OFFSET_VALUE_LEADER_EPOCH_FIELD_V3;
    private final BoundField OFFSET_VALUE_METADATA_FIELD_V3;
    private final BoundField OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V3;
    private final Schema GROUP_METADATA_KEY_SCHEMA;
    private final BoundField GROUP_KEY_GROUP_FIELD;
    private final String MEMBER_ID_KEY;
    private final String GROUP_INSTANCE_ID_KEY;
    private final String CLIENT_ID_KEY;
    private final String CLIENT_HOST_KEY;
    private final String REBALANCE_TIMEOUT_KEY;
    private final String SESSION_TIMEOUT_KEY;
    private final String SUBSCRIPTION_KEY;
    private final String ASSIGNMENT_KEY;
    private final Schema MEMBER_METADATA_V0;
    private final Schema MEMBER_METADATA_V1;
    private final Schema MEMBER_METADATA_V2;
    private final Schema MEMBER_METADATA_V3;
    private final String PROTOCOL_TYPE_KEY;
    private final String GENERATION_KEY;
    private final String PROTOCOL_KEY;
    private final String LEADER_KEY;
    private final String CURRENT_STATE_TIMESTAMP_KEY;
    private final String MEMBERS_KEY;
    private final Schema GROUP_METADATA_VALUE_SCHEMA_V0;
    private final Schema GROUP_METADATA_VALUE_SCHEMA_V1;
    private final Schema GROUP_METADATA_VALUE_SCHEMA_V2;
    private final Schema GROUP_METADATA_VALUE_SCHEMA_V3;
    private final Map<Object, Schema> MESSAGE_TYPE_SCHEMAS;
    private final Map<Object, Schema> OFFSET_VALUE_SCHEMAS;
    private final Map<Object, Schema> GROUP_VALUE_SCHEMAS;
    private final Schema CURRENT_OFFSET_KEY_SCHEMA;
    private final Schema CURRENT_GROUP_KEY_SCHEMA;

    static {
        new GroupMetadataManager$();
    }

    private short CURRENT_OFFSET_KEY_SCHEMA_VERSION() {
        return this.CURRENT_OFFSET_KEY_SCHEMA_VERSION;
    }

    private short CURRENT_GROUP_KEY_SCHEMA_VERSION() {
        return this.CURRENT_GROUP_KEY_SCHEMA_VERSION;
    }

    private Schema OFFSET_COMMIT_KEY_SCHEMA() {
        return this.OFFSET_COMMIT_KEY_SCHEMA;
    }

    private BoundField OFFSET_KEY_GROUP_FIELD() {
        return this.OFFSET_KEY_GROUP_FIELD;
    }

    private BoundField OFFSET_KEY_TOPIC_FIELD() {
        return this.OFFSET_KEY_TOPIC_FIELD;
    }

    private BoundField OFFSET_KEY_PARTITION_FIELD() {
        return this.OFFSET_KEY_PARTITION_FIELD;
    }

    private Schema OFFSET_COMMIT_VALUE_SCHEMA_V0() {
        return this.OFFSET_COMMIT_VALUE_SCHEMA_V0;
    }

    private BoundField OFFSET_VALUE_OFFSET_FIELD_V0() {
        return this.OFFSET_VALUE_OFFSET_FIELD_V0;
    }

    private BoundField OFFSET_VALUE_METADATA_FIELD_V0() {
        return this.OFFSET_VALUE_METADATA_FIELD_V0;
    }

    private BoundField OFFSET_VALUE_TIMESTAMP_FIELD_V0() {
        return this.OFFSET_VALUE_TIMESTAMP_FIELD_V0;
    }

    private Schema OFFSET_COMMIT_VALUE_SCHEMA_V1() {
        return this.OFFSET_COMMIT_VALUE_SCHEMA_V1;
    }

    private BoundField OFFSET_VALUE_OFFSET_FIELD_V1() {
        return this.OFFSET_VALUE_OFFSET_FIELD_V1;
    }

    private BoundField OFFSET_VALUE_METADATA_FIELD_V1() {
        return this.OFFSET_VALUE_METADATA_FIELD_V1;
    }

    private BoundField OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1() {
        return this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1;
    }

    private BoundField OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1() {
        return this.OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1;
    }

    private Schema OFFSET_COMMIT_VALUE_SCHEMA_V2() {
        return this.OFFSET_COMMIT_VALUE_SCHEMA_V2;
    }

    private BoundField OFFSET_VALUE_OFFSET_FIELD_V2() {
        return this.OFFSET_VALUE_OFFSET_FIELD_V2;
    }

    private BoundField OFFSET_VALUE_METADATA_FIELD_V2() {
        return this.OFFSET_VALUE_METADATA_FIELD_V2;
    }

    private BoundField OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V2() {
        return this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V2;
    }

    private Schema OFFSET_COMMIT_VALUE_SCHEMA_V3() {
        return this.OFFSET_COMMIT_VALUE_SCHEMA_V3;
    }

    private BoundField OFFSET_VALUE_OFFSET_FIELD_V3() {
        return this.OFFSET_VALUE_OFFSET_FIELD_V3;
    }

    private BoundField OFFSET_VALUE_LEADER_EPOCH_FIELD_V3() {
        return this.OFFSET_VALUE_LEADER_EPOCH_FIELD_V3;
    }

    private BoundField OFFSET_VALUE_METADATA_FIELD_V3() {
        return this.OFFSET_VALUE_METADATA_FIELD_V3;
    }

    private BoundField OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V3() {
        return this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V3;
    }

    private Schema GROUP_METADATA_KEY_SCHEMA() {
        return this.GROUP_METADATA_KEY_SCHEMA;
    }

    private BoundField GROUP_KEY_GROUP_FIELD() {
        return this.GROUP_KEY_GROUP_FIELD;
    }

    private String MEMBER_ID_KEY() {
        return this.MEMBER_ID_KEY;
    }

    private String GROUP_INSTANCE_ID_KEY() {
        return this.GROUP_INSTANCE_ID_KEY;
    }

    private String CLIENT_ID_KEY() {
        return this.CLIENT_ID_KEY;
    }

    private String CLIENT_HOST_KEY() {
        return this.CLIENT_HOST_KEY;
    }

    private String REBALANCE_TIMEOUT_KEY() {
        return this.REBALANCE_TIMEOUT_KEY;
    }

    private String SESSION_TIMEOUT_KEY() {
        return this.SESSION_TIMEOUT_KEY;
    }

    private String SUBSCRIPTION_KEY() {
        return this.SUBSCRIPTION_KEY;
    }

    private String ASSIGNMENT_KEY() {
        return this.ASSIGNMENT_KEY;
    }

    private Schema MEMBER_METADATA_V0() {
        return this.MEMBER_METADATA_V0;
    }

    private Schema MEMBER_METADATA_V1() {
        return this.MEMBER_METADATA_V1;
    }

    private Schema MEMBER_METADATA_V2() {
        return this.MEMBER_METADATA_V2;
    }

    private Schema MEMBER_METADATA_V3() {
        return this.MEMBER_METADATA_V3;
    }

    private String PROTOCOL_TYPE_KEY() {
        return this.PROTOCOL_TYPE_KEY;
    }

    private String GENERATION_KEY() {
        return this.GENERATION_KEY;
    }

    private String PROTOCOL_KEY() {
        return this.PROTOCOL_KEY;
    }

    private String LEADER_KEY() {
        return this.LEADER_KEY;
    }

    private String CURRENT_STATE_TIMESTAMP_KEY() {
        return this.CURRENT_STATE_TIMESTAMP_KEY;
    }

    private String MEMBERS_KEY() {
        return this.MEMBERS_KEY;
    }

    private Schema GROUP_METADATA_VALUE_SCHEMA_V0() {
        return this.GROUP_METADATA_VALUE_SCHEMA_V0;
    }

    private Schema GROUP_METADATA_VALUE_SCHEMA_V1() {
        return this.GROUP_METADATA_VALUE_SCHEMA_V1;
    }

    private Schema GROUP_METADATA_VALUE_SCHEMA_V2() {
        return this.GROUP_METADATA_VALUE_SCHEMA_V2;
    }

    private Schema GROUP_METADATA_VALUE_SCHEMA_V3() {
        return this.GROUP_METADATA_VALUE_SCHEMA_V3;
    }

    private Map<Object, Schema> MESSAGE_TYPE_SCHEMAS() {
        return this.MESSAGE_TYPE_SCHEMAS;
    }

    private Map<Object, Schema> OFFSET_VALUE_SCHEMAS() {
        return this.OFFSET_VALUE_SCHEMAS;
    }

    private Map<Object, Schema> GROUP_VALUE_SCHEMAS() {
        return this.GROUP_VALUE_SCHEMAS;
    }

    private Schema CURRENT_OFFSET_KEY_SCHEMA() {
        return this.CURRENT_OFFSET_KEY_SCHEMA;
    }

    private Schema CURRENT_GROUP_KEY_SCHEMA() {
        return this.CURRENT_GROUP_KEY_SCHEMA;
    }

    private Schema schemaForKey(int version) {
        Schema schema;
        Option schemaOpt = this.MESSAGE_TYPE_SCHEMAS().get((Object)BoxesRunTime.boxToInteger((int)version));
        Option option = schemaOpt;
        if (!(option instanceof Some)) {
            throw new KafkaException(new StringBuilder(35).append("Unknown message key schema version ").append(version).toString());
        }
        Some some = (Some)option;
        Schema schema2 = schema = (Schema)some.value();
        return schema2;
    }

    private Schema schemaForOffsetValue(int version) {
        Schema schema;
        Option schemaOpt = this.OFFSET_VALUE_SCHEMAS().get((Object)BoxesRunTime.boxToInteger((int)version));
        Option option = schemaOpt;
        if (!(option instanceof Some)) {
            throw new KafkaException(new StringBuilder(30).append("Unknown offset schema version ").append(version).toString());
        }
        Some some = (Some)option;
        Schema schema2 = schema = (Schema)some.value();
        return schema2;
    }

    private Schema schemaForGroupValue(int version) {
        Schema schema;
        Option schemaOpt = this.GROUP_VALUE_SCHEMAS().get((Object)BoxesRunTime.boxToInteger((int)version));
        Option option = schemaOpt;
        if (!(option instanceof Some)) {
            throw new KafkaException(new StringBuilder(31).append("Unknown group metadata version ").append(version).toString());
        }
        Some some = (Some)option;
        Schema schema2 = schema = (Schema)some.value();
        return schema2;
    }

    public byte[] offsetCommitKey(String group, TopicPartition topicPartition) {
        Struct key = new Struct(this.CURRENT_OFFSET_KEY_SCHEMA());
        key.set(this.OFFSET_KEY_GROUP_FIELD(), (Object)group);
        key.set(this.OFFSET_KEY_TOPIC_FIELD(), (Object)topicPartition.topic());
        key.set(this.OFFSET_KEY_PARTITION_FIELD(), (Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()));
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + key.sizeOf());
        byteBuffer.putShort(this.CURRENT_OFFSET_KEY_SCHEMA_VERSION());
        key.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public byte[] groupMetadataKey(String group) {
        Struct key = new Struct(this.CURRENT_GROUP_KEY_SCHEMA());
        key.set(this.GROUP_KEY_GROUP_FIELD(), (Object)group);
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + key.sizeOf());
        byteBuffer.putShort(this.CURRENT_GROUP_KEY_SCHEMA_VERSION());
        key.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public byte[] offsetCommitValue(OffsetAndMetadata offsetAndMetadata, ApiVersion apiVersion) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        if (apiVersion.$less(KAFKA_2_1_IV0$.MODULE$) || offsetAndMetadata.expireTimestamp().nonEmpty()) {
            Struct value = new Struct(this.OFFSET_COMMIT_VALUE_SCHEMA_V1());
            value.set(this.OFFSET_VALUE_OFFSET_FIELD_V1(), (Object)BoxesRunTime.boxToLong((long)offsetAndMetadata.offset()));
            value.set(this.OFFSET_VALUE_METADATA_FIELD_V1(), (Object)offsetAndMetadata.metadata());
            value.set(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1(), (Object)BoxesRunTime.boxToLong((long)offsetAndMetadata.commitTimestamp()));
            value.set(this.OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1(), offsetAndMetadata.expireTimestamp().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
            tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)value);
        } else if (apiVersion.$less(KAFKA_2_1_IV1$.MODULE$)) {
            Struct value = new Struct(this.OFFSET_COMMIT_VALUE_SCHEMA_V2());
            value.set(this.OFFSET_VALUE_OFFSET_FIELD_V2(), (Object)BoxesRunTime.boxToLong((long)offsetAndMetadata.offset()));
            value.set(this.OFFSET_VALUE_METADATA_FIELD_V2(), (Object)offsetAndMetadata.metadata());
            value.set(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V2(), (Object)BoxesRunTime.boxToLong((long)offsetAndMetadata.commitTimestamp()));
            tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)value);
        } else {
            Struct value = new Struct(this.OFFSET_COMMIT_VALUE_SCHEMA_V3());
            value.set(this.OFFSET_VALUE_OFFSET_FIELD_V3(), (Object)BoxesRunTime.boxToLong((long)offsetAndMetadata.offset()));
            value.set(this.OFFSET_VALUE_LEADER_EPOCH_FIELD_V3(), (Object)offsetAndMetadata.leaderEpoch().orElse(Predef$.MODULE$.int2Integer(-1)));
            value.set(this.OFFSET_VALUE_METADATA_FIELD_V3(), (Object)offsetAndMetadata.metadata());
            value.set(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V3(), (Object)BoxesRunTime.boxToLong((long)offsetAndMetadata.commitTimestamp()));
            tuple22 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)3), (Object)value);
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int version = tuple2._1$mcI$sp();
        Struct value = (Struct)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)version), (Object)value);
        Tuple2 tuple24 = tuple23;
        int version2 = tuple24._1$mcI$sp();
        Struct value2 = (Struct)tuple24._2();
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + value2.sizeOf());
        byteBuffer.putShort((short)version2);
        value2.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public byte[] groupMetadataValue(GroupMetadata groupMetadata, Map<String, byte[]> assignment, ApiVersion apiVersion) {
        Tuple2 tuple2;
        Tuple2 tuple22 = apiVersion.$less(KAFKA_0_10_1_IV0$.MODULE$) ? new Tuple2((Object)BoxesRunTime.boxToShort((short)((short)0)), (Object)new Struct(this.GROUP_METADATA_VALUE_SCHEMA_V0())) : (apiVersion.$less(KAFKA_2_1_IV0$.MODULE$) ? new Tuple2((Object)BoxesRunTime.boxToShort((short)((short)1)), (Object)new Struct(this.GROUP_METADATA_VALUE_SCHEMA_V1())) : (tuple2 = apiVersion.$less(KAFKA_2_3_IV0$.MODULE$) ? new Tuple2((Object)BoxesRunTime.boxToShort((short)((short)2)), (Object)new Struct(this.GROUP_METADATA_VALUE_SCHEMA_V2())) : new Tuple2((Object)BoxesRunTime.boxToShort((short)((short)3)), (Object)new Struct(this.GROUP_METADATA_VALUE_SCHEMA_V3()))));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        short version = BoxesRunTime.unboxToShort((Object)tuple2._1());
        Struct value = (Struct)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToShort((short)version), (Object)value);
        Tuple2 tuple24 = tuple23;
        short version2 = BoxesRunTime.unboxToShort((Object)tuple24._1());
        Struct value2 = (Struct)tuple24._2();
        value2.set(this.PROTOCOL_TYPE_KEY(), groupMetadata.protocolType().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        value2.set(this.GENERATION_KEY(), (Object)BoxesRunTime.boxToInteger((int)groupMetadata.generationId()));
        value2.set(this.PROTOCOL_KEY(), (Object)groupMetadata.protocolOrNull());
        value2.set(this.LEADER_KEY(), (Object)groupMetadata.leaderOrNull());
        Object object = version2 >= 2 ? value2.set(this.CURRENT_STATE_TIMESTAMP_KEY(), (Object)BoxesRunTime.boxToLong((long)groupMetadata.currentStateTimestampOrDefault())) : BoxedUnit.UNIT;
        List memberArray = (List)groupMetadata.allMemberMetadata().map((Function1 & Serializable & scala.Serializable)memberMetadata -> {
            Struct memberStruct = value2.instance(MODULE$.MEMBERS_KEY());
            memberStruct.set(MODULE$.MEMBER_ID_KEY(), (Object)memberMetadata.memberId());
            memberStruct.set(MODULE$.CLIENT_ID_KEY(), (Object)memberMetadata.clientId());
            memberStruct.set(MODULE$.CLIENT_HOST_KEY(), (Object)memberMetadata.clientHost());
            memberStruct.set(MODULE$.SESSION_TIMEOUT_KEY(), (Object)BoxesRunTime.boxToInteger((int)memberMetadata.sessionTimeoutMs()));
            Object object = version2 > 0 ? memberStruct.set(MODULE$.REBALANCE_TIMEOUT_KEY(), (Object)BoxesRunTime.boxToInteger((int)memberMetadata.rebalanceTimeoutMs())) : BoxedUnit.UNIT;
            Object object2 = version2 >= 3 ? memberStruct.set(MODULE$.GROUP_INSTANCE_ID_KEY(), memberMetadata.groupInstanceId().orNull(Predef$.MODULE$.$conforms())) : BoxedUnit.UNIT;
            String protocol = groupMetadata.protocolOrNull();
            if (protocol == null) {
                throw new IllegalStateException("Attempted to write non-empty group metadata with no defined protocol");
            }
            byte[] metadata = memberMetadata.metadata(protocol);
            memberStruct.set(MODULE$.SUBSCRIPTION_KEY(), (Object)ByteBuffer.wrap(metadata));
            byte[] memberAssignment = (byte[])assignment.apply((Object)memberMetadata.memberId());
            Predef$.MODULE$.assert(memberAssignment != null);
            memberStruct.set(MODULE$.ASSIGNMENT_KEY(), (Object)ByteBuffer.wrap(memberAssignment));
            return memberStruct;
        }, List$.MODULE$.canBuildFrom());
        value2.set(this.MEMBERS_KEY(), memberArray.toArray(ClassTag$.MODULE$.apply(Struct.class)));
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + value2.sizeOf());
        byteBuffer.putShort(version2);
        value2.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public BaseKey readMessageKey(ByteBuffer buffer) {
        Product product;
        short version = buffer.getShort();
        Schema keySchema = this.schemaForKey(version);
        Struct key = keySchema.read(buffer);
        if (version <= this.CURRENT_OFFSET_KEY_SCHEMA_VERSION()) {
            String group = (String)key.get(this.OFFSET_KEY_GROUP_FIELD());
            String topic = (String)key.get(this.OFFSET_KEY_TOPIC_FIELD());
            int partition = BoxesRunTime.unboxToInt((Object)key.get(this.OFFSET_KEY_PARTITION_FIELD()));
            product = new OffsetKey(version, new GroupTopicPartition(group, new TopicPartition(topic, partition)));
        } else if (version == this.CURRENT_GROUP_KEY_SCHEMA_VERSION()) {
            String group = (String)key.get(this.GROUP_KEY_GROUP_FIELD());
            product = new GroupMetadataKey(version, group);
        } else {
            throw new IllegalStateException(new StringBuilder(40).append("Unknown group metadata message version: ").append(version).toString());
        }
        return product;
    }

    public OffsetAndMetadata readOffsetMessageValue(ByteBuffer buffer) {
        OffsetAndMetadata offsetAndMetadata;
        if (buffer == null) {
            offsetAndMetadata = null;
        } else {
            short version = buffer.getShort();
            Schema valueSchema = this.schemaForOffsetValue(version);
            Struct value = valueSchema.read(buffer);
            if (version == 0) {
                long offset = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_OFFSET_FIELD_V0()));
                String metadata = (String)value.get(this.OFFSET_VALUE_METADATA_FIELD_V0());
                long timestamp = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_TIMESTAMP_FIELD_V0()));
                offsetAndMetadata = OffsetAndMetadata$.MODULE$.apply(offset, metadata, timestamp);
            } else if (version == 1) {
                long offset = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_OFFSET_FIELD_V1()));
                String metadata = (String)value.get(this.OFFSET_VALUE_METADATA_FIELD_V1());
                long commitTimestamp = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1()));
                long expireTimestamp = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1()));
                offsetAndMetadata = expireTimestamp == -1L ? OffsetAndMetadata$.MODULE$.apply(offset, metadata, commitTimestamp) : OffsetAndMetadata$.MODULE$.apply(offset, metadata, commitTimestamp, expireTimestamp);
            } else if (version == 2) {
                long offset = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_OFFSET_FIELD_V2()));
                String metadata = (String)value.get(this.OFFSET_VALUE_METADATA_FIELD_V2());
                long commitTimestamp = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V2()));
                offsetAndMetadata = OffsetAndMetadata$.MODULE$.apply(offset, metadata, commitTimestamp);
            } else if (version == 3) {
                long offset = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_OFFSET_FIELD_V3()));
                int leaderEpoch = BoxesRunTime.unboxToInt((Object)value.get(this.OFFSET_VALUE_LEADER_EPOCH_FIELD_V3()));
                String metadata = (String)value.get(this.OFFSET_VALUE_METADATA_FIELD_V3());
                long commitTimestamp = BoxesRunTime.unboxToLong((Object)value.get(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V3()));
                Optional<Integer> leaderEpochOpt = leaderEpoch < 0 ? Optional.empty() : Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch));
                offsetAndMetadata = OffsetAndMetadata$.MODULE$.apply(offset, leaderEpochOpt, metadata, commitTimestamp);
            } else {
                throw new IllegalStateException(new StringBuilder(32).append("Unknown offset message version: ").append(version).toString());
            }
        }
        return offsetAndMetadata;
    }

    public GroupMetadata readGroupMessageValue(String groupId, ByteBuffer buffer, Time time) {
        GroupMetadata groupMetadata;
        if (buffer == null) {
            groupMetadata = null;
        } else {
            short version = buffer.getShort();
            Schema valueSchema = this.schemaForGroupValue(version);
            Struct value = valueSchema.read(buffer);
            if (version >= 0 && version <= 3) {
                Long timestamp;
                int generationId = BoxesRunTime.unboxToInt((Object)value.get(this.GENERATION_KEY()));
                String protocolType = (String)value.get(this.PROTOCOL_TYPE_KEY());
                String protocol = (String)value.get(this.PROTOCOL_KEY());
                String leaderId = (String)value.get(this.LEADER_KEY());
                Object[] memberMetadataArray = value.getArray(this.MEMBERS_KEY());
                Product initialState = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(memberMetadataArray)).isEmpty() ? Empty$.MODULE$ : Stable$.MODULE$;
                short s = version;
                switch (s) {
                    default: 
                }
                None$ currentStateTimestamp = s == 2 ? (value.hasField(this.CURRENT_STATE_TIMESTAMP_KEY()) ? (BoxesRunTime.equalsNumObject((Number)(timestamp = value.getLong(this.CURRENT_STATE_TIMESTAMP_KEY())), (Object)BoxesRunTime.boxToInteger((int)-1)) ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(timestamp)))) : None$.MODULE$) : None$.MODULE$;
                MemberMetadata[] members = (MemberMetadata[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(memberMetadataArray)).map((Function1 & Serializable & scala.Serializable)memberMetadataObj -> {
                    Struct memberMetadata = (Struct)memberMetadataObj;
                    String memberId = (String)memberMetadata.get(MODULE$.MEMBER_ID_KEY());
                    None$ groupInstanceId = version >= 3 ? new Some((Object)((String)memberMetadata.get(MODULE$.GROUP_INSTANCE_ID_KEY()))) : None$.MODULE$;
                    String clientId = (String)memberMetadata.get(MODULE$.CLIENT_ID_KEY());
                    String clientHost = (String)memberMetadata.get(MODULE$.CLIENT_HOST_KEY());
                    int sessionTimeout = BoxesRunTime.unboxToInt((Object)memberMetadata.get(MODULE$.SESSION_TIMEOUT_KEY()));
                    int rebalanceTimeout = version == 0 ? sessionTimeout : BoxesRunTime.unboxToInt((Object)memberMetadata.get(MODULE$.REBALANCE_TIMEOUT_KEY()));
                    byte[] subscription = Utils.toArray((ByteBuffer)((ByteBuffer)memberMetadata.get(MODULE$.SUBSCRIPTION_KEY())));
                    MemberMetadata member = new MemberMetadata(memberId, groupId, (Option<String>)groupInstanceId, clientId, clientHost, rebalanceTimeout, sessionTimeout, protocolType, (List<Tuple2<String, byte[]>>)new .colon.colon((Object)new Tuple2((Object)protocol, (Object)subscription), (List)Nil$.MODULE$));
                    member.assignment_$eq(Utils.toArray((ByteBuffer)((ByteBuffer)memberMetadata.get(MODULE$.ASSIGNMENT_KEY()))));
                    return member;
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(MemberMetadata.class)));
                groupMetadata = GroupMetadata$.MODULE$.loadGroup(groupId, (GroupState)initialState, generationId, protocolType, protocol, leaderId, (Option<Object>)currentStateTimestamp, (Iterable<MemberMetadata>)Predef$.MODULE$.wrapRefArray((Object[])members), time);
            } else {
                throw new IllegalStateException(new StringBuilder(40).append("Unknown group metadata message version: ").append(version).toString());
            }
        }
        return groupMetadata;
    }

    private GroupMetadataManager$() {
        MODULE$ = this;
        this.CURRENT_OFFSET_KEY_SCHEMA_VERSION = (short)1;
        this.CURRENT_GROUP_KEY_SCHEMA_VERSION = (short)2;
        this.OFFSET_COMMIT_KEY_SCHEMA = new Schema(new Field[]{new Field("group", (Type)Type.STRING), new Field("topic", (Type)Type.STRING), new Field("partition", (Type)Type.INT32)});
        this.OFFSET_KEY_GROUP_FIELD = this.OFFSET_COMMIT_KEY_SCHEMA().get("group");
        this.OFFSET_KEY_TOPIC_FIELD = this.OFFSET_COMMIT_KEY_SCHEMA().get("topic");
        this.OFFSET_KEY_PARTITION_FIELD = this.OFFSET_COMMIT_KEY_SCHEMA().get("partition");
        this.OFFSET_COMMIT_VALUE_SCHEMA_V0 = new Schema(new Field[]{new Field("offset", (Type)Type.INT64), new Field("metadata", (Type)Type.STRING, "Associated metadata.", (Object)""), new Field("timestamp", (Type)Type.INT64)});
        this.OFFSET_VALUE_OFFSET_FIELD_V0 = this.OFFSET_COMMIT_VALUE_SCHEMA_V0().get("offset");
        this.OFFSET_VALUE_METADATA_FIELD_V0 = this.OFFSET_COMMIT_VALUE_SCHEMA_V0().get("metadata");
        this.OFFSET_VALUE_TIMESTAMP_FIELD_V0 = this.OFFSET_COMMIT_VALUE_SCHEMA_V0().get("timestamp");
        this.OFFSET_COMMIT_VALUE_SCHEMA_V1 = new Schema(new Field[]{new Field("offset", (Type)Type.INT64), new Field("metadata", (Type)Type.STRING, "Associated metadata.", (Object)""), new Field("commit_timestamp", (Type)Type.INT64), new Field("expire_timestamp", (Type)Type.INT64)});
        this.OFFSET_VALUE_OFFSET_FIELD_V1 = this.OFFSET_COMMIT_VALUE_SCHEMA_V1().get("offset");
        this.OFFSET_VALUE_METADATA_FIELD_V1 = this.OFFSET_COMMIT_VALUE_SCHEMA_V1().get("metadata");
        this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1 = this.OFFSET_COMMIT_VALUE_SCHEMA_V1().get("commit_timestamp");
        this.OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1 = this.OFFSET_COMMIT_VALUE_SCHEMA_V1().get("expire_timestamp");
        this.OFFSET_COMMIT_VALUE_SCHEMA_V2 = new Schema(new Field[]{new Field("offset", (Type)Type.INT64), new Field("metadata", (Type)Type.STRING, "Associated metadata.", (Object)""), new Field("commit_timestamp", (Type)Type.INT64)});
        this.OFFSET_VALUE_OFFSET_FIELD_V2 = this.OFFSET_COMMIT_VALUE_SCHEMA_V2().get("offset");
        this.OFFSET_VALUE_METADATA_FIELD_V2 = this.OFFSET_COMMIT_VALUE_SCHEMA_V2().get("metadata");
        this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V2 = this.OFFSET_COMMIT_VALUE_SCHEMA_V2().get("commit_timestamp");
        this.OFFSET_COMMIT_VALUE_SCHEMA_V3 = new Schema(new Field[]{new Field("offset", (Type)Type.INT64), new Field("leader_epoch", (Type)Type.INT32), new Field("metadata", (Type)Type.STRING, "Associated metadata.", (Object)""), new Field("commit_timestamp", (Type)Type.INT64)});
        this.OFFSET_VALUE_OFFSET_FIELD_V3 = this.OFFSET_COMMIT_VALUE_SCHEMA_V3().get("offset");
        this.OFFSET_VALUE_LEADER_EPOCH_FIELD_V3 = this.OFFSET_COMMIT_VALUE_SCHEMA_V3().get("leader_epoch");
        this.OFFSET_VALUE_METADATA_FIELD_V3 = this.OFFSET_COMMIT_VALUE_SCHEMA_V3().get("metadata");
        this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V3 = this.OFFSET_COMMIT_VALUE_SCHEMA_V3().get("commit_timestamp");
        this.GROUP_METADATA_KEY_SCHEMA = new Schema(new Field[]{new Field("group", (Type)Type.STRING)});
        this.GROUP_KEY_GROUP_FIELD = this.GROUP_METADATA_KEY_SCHEMA().get("group");
        this.MEMBER_ID_KEY = "member_id";
        this.GROUP_INSTANCE_ID_KEY = "group_instance_id";
        this.CLIENT_ID_KEY = "client_id";
        this.CLIENT_HOST_KEY = "client_host";
        this.REBALANCE_TIMEOUT_KEY = "rebalance_timeout";
        this.SESSION_TIMEOUT_KEY = "session_timeout";
        this.SUBSCRIPTION_KEY = "subscription";
        this.ASSIGNMENT_KEY = "assignment";
        this.MEMBER_METADATA_V0 = new Schema(new Field[]{new Field(this.MEMBER_ID_KEY(), (Type)Type.STRING), new Field(this.CLIENT_ID_KEY(), (Type)Type.STRING), new Field(this.CLIENT_HOST_KEY(), (Type)Type.STRING), new Field(this.SESSION_TIMEOUT_KEY(), (Type)Type.INT32), new Field(this.SUBSCRIPTION_KEY(), (Type)Type.BYTES), new Field(this.ASSIGNMENT_KEY(), (Type)Type.BYTES)});
        this.MEMBER_METADATA_V1 = new Schema(new Field[]{new Field(this.MEMBER_ID_KEY(), (Type)Type.STRING), new Field(this.CLIENT_ID_KEY(), (Type)Type.STRING), new Field(this.CLIENT_HOST_KEY(), (Type)Type.STRING), new Field(this.REBALANCE_TIMEOUT_KEY(), (Type)Type.INT32), new Field(this.SESSION_TIMEOUT_KEY(), (Type)Type.INT32), new Field(this.SUBSCRIPTION_KEY(), (Type)Type.BYTES), new Field(this.ASSIGNMENT_KEY(), (Type)Type.BYTES)});
        this.MEMBER_METADATA_V2 = this.MEMBER_METADATA_V1();
        this.MEMBER_METADATA_V3 = new Schema(new Field[]{new Field(this.MEMBER_ID_KEY(), (Type)Type.STRING), new Field(this.GROUP_INSTANCE_ID_KEY(), (Type)Type.NULLABLE_STRING), new Field(this.CLIENT_ID_KEY(), (Type)Type.STRING), new Field(this.CLIENT_HOST_KEY(), (Type)Type.STRING), new Field(this.REBALANCE_TIMEOUT_KEY(), (Type)Type.INT32), new Field(this.SESSION_TIMEOUT_KEY(), (Type)Type.INT32), new Field(this.SUBSCRIPTION_KEY(), (Type)Type.BYTES), new Field(this.ASSIGNMENT_KEY(), (Type)Type.BYTES)});
        this.PROTOCOL_TYPE_KEY = "protocol_type";
        this.GENERATION_KEY = "generation";
        this.PROTOCOL_KEY = "protocol";
        this.LEADER_KEY = "leader";
        this.CURRENT_STATE_TIMESTAMP_KEY = "current_state_timestamp";
        this.MEMBERS_KEY = "members";
        this.GROUP_METADATA_VALUE_SCHEMA_V0 = new Schema(new Field[]{new Field(this.PROTOCOL_TYPE_KEY(), (Type)Type.STRING), new Field(this.GENERATION_KEY(), (Type)Type.INT32), new Field(this.PROTOCOL_KEY(), (Type)Type.NULLABLE_STRING), new Field(this.LEADER_KEY(), (Type)Type.NULLABLE_STRING), new Field(this.MEMBERS_KEY(), (Type)new ArrayOf((Type)this.MEMBER_METADATA_V0()))});
        this.GROUP_METADATA_VALUE_SCHEMA_V1 = new Schema(new Field[]{new Field(this.PROTOCOL_TYPE_KEY(), (Type)Type.STRING), new Field(this.GENERATION_KEY(), (Type)Type.INT32), new Field(this.PROTOCOL_KEY(), (Type)Type.NULLABLE_STRING), new Field(this.LEADER_KEY(), (Type)Type.NULLABLE_STRING), new Field(this.MEMBERS_KEY(), (Type)new ArrayOf((Type)this.MEMBER_METADATA_V1()))});
        this.GROUP_METADATA_VALUE_SCHEMA_V2 = new Schema(new Field[]{new Field(this.PROTOCOL_TYPE_KEY(), (Type)Type.STRING), new Field(this.GENERATION_KEY(), (Type)Type.INT32), new Field(this.PROTOCOL_KEY(), (Type)Type.NULLABLE_STRING), new Field(this.LEADER_KEY(), (Type)Type.NULLABLE_STRING), new Field(this.CURRENT_STATE_TIMESTAMP_KEY(), (Type)Type.INT64), new Field(this.MEMBERS_KEY(), (Type)new ArrayOf((Type)this.MEMBER_METADATA_V2()))});
        this.GROUP_METADATA_VALUE_SCHEMA_V3 = new Schema(new Field[]{new Field(this.PROTOCOL_TYPE_KEY(), (Type)Type.STRING), new Field(this.GENERATION_KEY(), (Type)Type.INT32), new Field(this.PROTOCOL_KEY(), (Type)Type.NULLABLE_STRING), new Field(this.LEADER_KEY(), (Type)Type.NULLABLE_STRING), new Field(this.CURRENT_STATE_TIMESTAMP_KEY(), (Type)Type.INT64), new Field(this.MEMBERS_KEY(), (Type)new ArrayOf((Type)this.MEMBER_METADATA_V3()))});
        this.MESSAGE_TYPE_SCHEMAS = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)this.OFFSET_COMMIT_KEY_SCHEMA()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)this.OFFSET_COMMIT_KEY_SCHEMA()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)this.GROUP_METADATA_KEY_SCHEMA())}));
        this.OFFSET_VALUE_SCHEMAS = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)this.OFFSET_COMMIT_VALUE_SCHEMA_V0()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)this.OFFSET_COMMIT_VALUE_SCHEMA_V1()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)this.OFFSET_COMMIT_VALUE_SCHEMA_V2()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)this.OFFSET_COMMIT_VALUE_SCHEMA_V3())}));
        this.GROUP_VALUE_SCHEMAS = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)this.GROUP_METADATA_VALUE_SCHEMA_V0()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)this.GROUP_METADATA_VALUE_SCHEMA_V1()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)this.GROUP_METADATA_VALUE_SCHEMA_V2()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)this.GROUP_METADATA_VALUE_SCHEMA_V3())}));
        this.CURRENT_OFFSET_KEY_SCHEMA = this.schemaForKey(this.CURRENT_OFFSET_KEY_SCHEMA_VERSION());
        this.CURRENT_GROUP_KEY_SCHEMA = this.schemaForKey(this.CURRENT_GROUP_KEY_SCHEMA_VERSION());
    }
}

