/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.utils.ShutdownableThread$;
import org.apache.kafka.common.internals.FatalExitError;
import scala.Function0;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ua!B\u000e\u001d\u0003\u0003\t\u0003\u0002\u0003\u0018\u0001\u0005\u000b\u0007I\u0011A\u0018\t\u0011u\u0002!\u0011!Q\u0001\nAB\u0001B\u0010\u0001\u0003\u0006\u0004%\ta\u0010\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u0001\")Q\t\u0001C\u0001\r\"9!\n\u0001b\u0001\n\u0013Y\u0005B\u0002+\u0001A\u0003%A\nC\u0004V\u0001\t\u0007I\u0011B&\t\rY\u0003\u0001\u0015!\u0003M\u0011\u001d9\u0006\u00011A\u0005\n}Bq\u0001\u0017\u0001A\u0002\u0013%\u0011\f\u0003\u0004`\u0001\u0001\u0006K\u0001\u0011\u0005\u0006I\u0002!\t!\u001a\u0005\u0006M\u0002!\ta\u0010\u0005\u0006O\u0002!\ta\u0010\u0005\u0006Q\u0002!\ta\u0010\u0005\u0006S\u0002!\tA\u001b\u0005\u0006W\u0002!\t!\u001a\u0005\u0006Y\u0002!\t!\u001c\u0005\u0006q\u00021\t!\u001a\u0005\u0006s\u0002!\t%\u001a\u0005\u0006u\u0002!\taP\u0004\bwr\t\t\u0011#\u0001}\r\u001dYB$!A\t\u0002uDa!\u0012\r\u0005\u0002\u0005\r\u0001\"CA\u00031E\u0005I\u0011AA\u0004\u0005I\u0019\u0006.\u001e;e_^t\u0017M\u00197f)\"\u0014X-\u00193\u000b\u0005uq\u0012!B;uS2\u001c(\"A\u0010\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001A\t\u0016\u0011\u0005\rBS\"\u0001\u0013\u000b\u0005\u00152\u0013\u0001\u00027b]\u001eT\u0011aJ\u0001\u0005U\u00064\u0018-\u0003\u0002*I\t1A\u000b\u001b:fC\u0012\u0004\"a\u000b\u0017\u000e\u0003qI!!\f\u000f\u0003\u000f1{wmZ5oO\u0006!a.Y7f+\u0005\u0001\u0004CA\u0019;\u001d\t\u0011\u0004\b\u0005\u00024m5\tAG\u0003\u00026A\u00051AH]8pizR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\na\u0001\u0015:fI\u00164\u0017BA\u001e=\u0005\u0019\u0019FO]5oO*\u0011\u0011HN\u0001\u0006]\u0006lW\rI\u0001\u0010SNLe\u000e^3seV\u0004H/\u001b2mKV\t\u0001\t\u0005\u0002B\u00056\ta'\u0003\u0002Dm\t9!i\\8mK\u0006t\u0017\u0001E5t\u0013:$XM\u001d:vaRL'\r\\3!\u0003\u0019a\u0014N\\5u}Q\u0019q\tS%\u0011\u0005-\u0002\u0001\"\u0002\u0018\u0006\u0001\u0004\u0001\u0004b\u0002 \u0006!\u0003\u0005\r\u0001Q\u0001\u0012g\",H\u000fZ8x]&s\u0017\u000e^5bi\u0016$W#\u0001'\u0011\u00055\u0013V\"\u0001(\u000b\u0005=\u0003\u0016AC2p]\u000e,(O]3oi*\u0011\u0011KJ\u0001\u0005kRLG.\u0003\u0002T\u001d\nq1i\\;oi\u0012{wO\u001c'bi\u000eD\u0017AE:ikR$wn\u001e8J]&$\u0018.\u0019;fI\u0002\n\u0001c\u001d5vi\u0012|wO\\\"p[BdW\r^3\u0002#MDW\u000f\u001e3po:\u001cu.\u001c9mKR,\u0007%A\u0005jgN#\u0018M\u001d;fI\u0006i\u0011n]*uCJ$X\rZ0%KF$\"AW/\u0011\u0005\u0005[\u0016B\u0001/7\u0005\u0011)f.\u001b;\t\u000fy[\u0011\u0011!a\u0001\u0001\u0006\u0019\u0001\u0010J\u0019\u0002\u0015%\u001c8\u000b^1si\u0016$\u0007\u0005\u000b\u0002\rCB\u0011\u0011IY\u0005\u0003GZ\u0012\u0001B^8mCRLG.Z\u0001\tg\",H\u000fZ8x]R\t!,A\njgNCW\u000f\u001e3po:Le.\u001b;jCR,G-\u0001\njgNCW\u000f\u001e3po:\u001cu.\u001c9mKR,\u0017AD5t)\"\u0014X-\u00193GC&dW\rZ\u0001\u0011S:LG/[1uKNCW\u000f\u001e3po:$\u0012\u0001Q\u0001\u000eC^\f\u0017\u000e^*ikR$wn\u001e8\u0002\u000bA\fWo]3\u0015\u0007is7\u000fC\u0003p'\u0001\u0007\u0001/A\u0004uS6,w.\u001e;\u0011\u0005\u0005\u000b\u0018B\u0001:7\u0005\u0011auN\\4\t\u000bQ\u001c\u0002\u0019A;\u0002\tUt\u0017\u000e\u001e\t\u0003\u001bZL!a\u001e(\u0003\u0011QKW.Z+oSR\fa\u0001Z8X_J\\\u0017a\u0001:v]\u0006I\u0011n\u001d*v]:LgnZ\u0001\u0013'\",H\u000fZ8x]\u0006\u0014G.\u001a+ie\u0016\fG\r\u0005\u0002,1M\u0011\u0001D \t\u0003\u0003~L1!!\u00017\u0005\u0019\te.\u001f*fMR\tA0A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0003\u0003\u0013Q3\u0001QA\u0006W\t\ti\u0001\u0005\u0003\u0002\u0010\u0005eQBAA\t\u0015\u0011\t\u0019\"!\u0006\u0002\u0013Ut7\r[3dW\u0016$'bAA\fm\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0011\u0011\u0003\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public abstract class ShutdownableThread
extends Thread
implements Logging {
    private final String name;
    private final boolean isInterruptible;
    private final CountDownLatch shutdownInitiated;
    private final CountDownLatch shutdownComplete;
    private volatile boolean isStarted;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$2() {
        return ShutdownableThread$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ShutdownableThread shutdownableThread = this;
        synchronized (shutdownableThread) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String name() {
        return this.name;
    }

    public boolean isInterruptible() {
        return this.isInterruptible;
    }

    private CountDownLatch shutdownInitiated() {
        return this.shutdownInitiated;
    }

    private CountDownLatch shutdownComplete() {
        return this.shutdownComplete;
    }

    private boolean isStarted() {
        return this.isStarted;
    }

    private void isStarted_$eq(boolean x$1) {
        this.isStarted = x$1;
    }

    public void shutdown() {
        this.initiateShutdown();
        this.awaitShutdown();
    }

    public boolean isShutdownInitiated() {
        return this.shutdownInitiated().getCount() == 0L;
    }

    public boolean isShutdownComplete() {
        return this.shutdownComplete().getCount() == 0L;
    }

    public boolean isThreadFailed() {
        return this.isShutdownComplete() && !this.isShutdownInitiated();
    }

    public synchronized boolean initiateShutdown() {
        boolean bl;
        if (this.isRunning()) {
            this.info((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Shutting down");
            this.shutdownInitiated().countDown();
            if (this.isInterruptible()) {
                this.interrupt();
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public void awaitShutdown() {
        if (!this.isShutdownInitiated()) {
            throw new IllegalStateException("initiateShutdown() was not called before awaitShutdown()");
        }
        if (this.isStarted()) {
            this.shutdownComplete().await();
        }
        this.info((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Shutdown completed");
    }

    public void pause(long timeout, TimeUnit unit) {
        block0: {
            if (!this.shutdownInitiated().await(timeout, unit)) break block0;
            this.trace((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "shutdownInitiated latch count reached zero. Shutdown called.");
        }
    }

    public abstract void doWork();

    @Override
    public void run() {
        this.isStarted_$eq(true);
        this.info((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Starting");
        try {
            try {
                while (this.isRunning()) {
                    this.doWork();
                }
            }
            catch (FatalExitError e) {
                this.shutdownInitiated().countDown();
                this.shutdownComplete().countDown();
                this.info((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Stopped");
                throw Exit$.MODULE$.exit(e.statusCode(), Exit$.MODULE$.exit$default$2());
            }
            catch (Throwable e) {
                if (this.isRunning()) {
                    this.error((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Error due to", (Function0<Throwable>)(Function0 & java.io.Serializable & Serializable)() -> e);
                }
            }
        }
        finally {
            this.shutdownComplete().countDown();
        }
        this.info((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Stopped");
    }

    public boolean isRunning() {
        return !this.isShutdownInitiated();
    }

    public ShutdownableThread(String name, boolean isInterruptible) {
        this.name = name;
        this.isInterruptible = isInterruptible;
        super(name);
        Logging.$init$(this);
        this.setDaemon(false);
        this.logIdent_$eq(new StringBuilder(4).append("[").append(name).append("]: ").toString());
        this.shutdownInitiated = new CountDownLatch(1);
        this.shutdownComplete = new CountDownLatch(1);
        this.isStarted = false;
    }
}

