/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Properties;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommandTest;
import kafka.server.Defaults$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005]d\u0001\u0002\f\u0018\u0001qAQ!\t\u0001\u0005\u0002\tBQ\u0001\n\u0001\u0005\u0002\u0015BQa\u000f\u0001\u0005\u0002qBQ!\u0013\u0001\u0005\u0002qBQa\u0013\u0001\u0005\u0002qBQ!\u0014\u0001\u0005\u0002qBQa\u0014\u0001\u0005\u0002qBQ!\u0015\u0001\u0005\u0002qBQa\u0015\u0001\u0005\u0002qBQ!\u0016\u0001\u0005\u0002qBQa\u0016\u0001\u0005\u0002qBQ!\u0017\u0001\u0005\niCQ!\u001d\u0001\u0005\nIDQa\u001e\u0001\u0005\naDa!a\u0003\u0001\t\u0013a\u0004bBA\u0007\u0001\u0011%\u0011q\u0002\u0005\b\u0003+\u0001A\u0011BA\f\u0011\u001d\tY\u0002\u0001C\u0005\u0003;A\u0011\"a\u0013\u0001#\u0003%I!!\u0014\t\u000f\u0005\r\u0004\u0001\"\u0003\u0002f!I\u0011Q\u000f\u0001\u0012\u0002\u0013%\u0011Q\n\u00021\t\u0016dW\r^3PM\u001a\u001cX\r^:D_:\u001cX/\\3s\u000fJ|W\u000f]\"p[6\fg\u000eZ%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u0005aI\u0012!B1e[&t'\"\u0001\u000e\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\b\t\u0003=}i\u0011aF\u0005\u0003A]\u0011\u0001dQ8ogVlWM]$s_V\u00048i\\7nC:$G+Z:u\u0003\u0019a\u0014N\\5u}Q\t1\u0005\u0005\u0002\u001f\u0001\u00059q-\u001a;Be\u001e\u001cHc\u0001\u00148sA\u0019qE\u000b\u0017\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u0012Q!\u0011:sCf\u0004\"!\f\u001b\u000f\u00059\u0012\u0004CA\u0018)\u001b\u0005\u0001$BA\u0019\u001c\u0003\u0019a$o\\8u}%\u00111\u0007K\u0001\u0007!J,G-\u001a4\n\u0005U2$AB*ue&twM\u0003\u00024Q!)\u0001H\u0001a\u0001Y\u0005)qM]8va\")!H\u0001a\u0001Y\u0005)Ao\u001c9jG\u0006\tC/Z:u\t\u0016dW\r^3PM\u001a\u001cX\r^:O_:,\u00050[:uS:<wI]8vaR\tQ\b\u0005\u0002(}%\u0011q\b\u000b\u0002\u0005+:LG\u000f\u000b\u0002\u0004\u0003B\u0011!iR\u0007\u0002\u0007*\u0011A)R\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\r\u0006\u0019qN]4\n\u0005!\u001b%\u0001\u0002+fgR\f\u0001\b^3ti\u0012+G.\u001a;f\u001f\u001a47/\u001a;t\u001f\u001a\u001cF/\u00192mK\u000e{gn];nKJ<%o\\;q/&$\b\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u000b\u0002\u0005\u0003\u0006\u0019D/Z:u\t\u0016dW\r^3PM\u001a\u001cX\r^:PMN#\u0018M\u00197f\u0007>t7/^7fe\u001e\u0013x.\u001e9XSRDGk\u001c9jG>sG.\u001f\u0015\u0003\u000b\u0005\u000bq\b^3ti\u0012+G.\u001a;f\u001f\u001a47/\u001a;t\u001f\u001a\u001cF/\u00192mK\u000e{gn];nKJ<%o\\;q/&$\b.\u00168l]><h\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u000b\u0002\u0007\u0003\u0006QD/Z:u\t\u0016dW\r^3PM\u001a\u001cX\r^:PMN#\u0018M\u00197f\u0007>t7/^7fe\u001e\u0013x.\u001e9XSRDWK\\6o_^tGk\u001c9jG>sG.\u001f\u0015\u0003\u000f\u0005\u000bq\u0007^3ti\u0012+G.\u001a;f\u001f\u001a47/\u001a;t\u001f\u001a,U\u000e\u001d;z\u0007>t7/^7fe\u001e\u0013x.\u001e9XSRDGk\u001c9jGB\u000b'\u000f^5uS>t\u0007F\u0001\u0005B\u0003I\"Xm\u001d;EK2,G/Z(gMN,Go](g\u000b6\u0004H/_\"p]N,X.\u001a:He>,\boV5uQR{\u0007/[2P]2L\bFA\u0005B\u0003y\"Xm\u001d;EK2,G/Z(gMN,Go](g\u000b6\u0004H/_\"p]N,X.\u001a:He>,\boV5uQVs7N\\8x]R{\u0007/[2QCJ$\u0018\u000e^5p]\"\u0012!\"Q\u0001:i\u0016\u001cH\u000fR3mKR,wJ\u001a4tKR\u001cxJZ#naRL8i\u001c8tk6,'o\u0012:pkB<\u0016\u000e\u001e5V].twn\u001e8U_BL7m\u00148ms\"\u00121\"Q\u0001\u001ci\u0016\u001cHoV5uQN#\u0018M\u00197f\u0007>t7/^7fe\u001e\u0013x.\u001e9\u0015\u000buZVL\u00193\t\u000bqc\u0001\u0019\u0001\u0017\u0002\u0015%t\u0007/\u001e;U_BL7\rC\u0003_\u0019\u0001\u0007q,\u0001\bj]B,H\u000fU1si&$\u0018n\u001c8\u0011\u0005\u001d\u0002\u0017BA1)\u0005\rIe\u000e\u001e\u0005\u0006G2\u0001\raX\u0001\u0012Kb\u0004Xm\u0019;fIB\u000b'\u000f^5uS>t\u0007\"B3\r\u0001\u00041\u0017!D3ya\u0016\u001cG/\u001a3FeJ|'\u000f\u0005\u0002h_6\t\u0001N\u0003\u0002jU\u0006A\u0001O]8u_\u000e|GN\u0003\u0002lY\u000611m\\7n_:T!AG7\u000b\u00059,\u0015AB1qC\u000eDW-\u0003\u0002qQ\n1QI\u001d:peN\f!\u0004^3ti^KG\u000f[#naRL8i\u001c8tk6,'o\u0012:pkB$R!P:ukZDQ\u0001X\u0007A\u00021BQAX\u0007A\u0002}CQaY\u0007A\u0002}CQ!Z\u0007A\u0002\u0019\fQ\u0003^3ti^KG\u000f[\"p]N,X.\u001a:He>,\b\u000f\u0006\u0006>s\u0006\r\u0011QAA\u0004\u0003\u0013AQA\u001f\bA\u0002m\f\u0011c^5uQ\u000e{gn];nKJ<%o\\;q!\u00119CP`\u001f\n\u0005uD#!\u0003$v]\u000e$\u0018n\u001c82!\r9s0P\u0005\u0004\u0003\u0003A#\u0001\u0003\u001fcs:\fW.\u001a \t\u000bqs\u0001\u0019\u0001\u0017\t\u000bys\u0001\u0019A0\t\u000b\rt\u0001\u0019A0\t\u000b\u0015t\u0001\u0019\u00014\u0002\u001bA\u0014x\u000eZ;dKJ+7m\u001c:e\u0003]9\u0018\u000e\u001e5Ti\u0006\u0014G.Z\"p]N,X.\u001a:He>,\b\u000fF\u0002>\u0003#Aq!a\u0005\u0011\t\u0003\u0007a0\u0001\u0003c_\u0012L\u0018AF<ji\",U\u000e\u001d;z\u0007>t7/^7fe\u001e\u0013x.\u001e9\u0015\u0007u\nI\u0002C\u0004\u0002\u0014E!\t\u0019\u0001@\u0002\u001d\r\u0014X-\u0019;f!J|G-^2feR!\u0011qDA\u001c!!\t\t#a\u000b\u00020\u0005=RBAA\u0012\u0015\u0011\t)#a\n\u0002\u0011A\u0014x\u000eZ;dKJT1!!\u000bm\u0003\u001d\u0019G.[3oiNLA!!\f\u0002$\ti1*\u00194lCB\u0013x\u000eZ;dKJ\u0004Ba\n\u0016\u00022A\u0019q%a\r\n\u0007\u0005U\u0002F\u0001\u0003CsR,\u0007\"CA\u001d%A\u0005\t\u0019AA\u001e\u0003\u0019\u0019wN\u001c4jOB!\u0011QHA$\u001b\t\tyD\u0003\u0003\u0002B\u0005\r\u0013\u0001B;uS2T!!!\u0012\u0002\t)\fg/Y\u0005\u0005\u0003\u0013\nyD\u0001\u0006Qe>\u0004XM\u001d;jKN\f\u0001d\u0019:fCR,\u0007K]8ek\u000e,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\tyE\u000b\u0003\u0002<\u0005E3FAA*!\u0011\t)&a\u0018\u000e\u0005\u0005]#\u0002BA-\u00037\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005u\u0003&\u0001\u0006b]:|G/\u0019;j_:LA!!\u0019\u0002X\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r\u0014X-\u0019;f\u0007>t7/^7feR!\u0011qMA:!!\tI'a\u001c\u00020\u0005=RBAA6\u0015\u0011\ti'a\n\u0002\u0011\r|gn];nKJLA!!\u001d\u0002l\ti1*\u00194lC\u000e{gn];nKJD\u0011\"!\u000f\u0015!\u0003\u0005\r!a\u000f\u00021\r\u0014X-\u0019;f\u0007>t7/^7fe\u0012\"WMZ1vYR$\u0013\u0007")
public class DeleteOffsetsConsumerGroupCommandIntegrationTest
extends ConsumerGroupCommandTest {
    public String[] getArgs(String group, String topic) {
        return (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete-offsets", "--group", group, "--topic", topic});
    }

    @Test
    public void testDeleteOffsetsNonExistingGroup() {
        Errors error;
        String group = "missing.group";
        String topic = "foo:1";
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(this.getArgs(group, topic));
        Tuple2 tuple2 = service.deleteOffsets(group, (List)new .colon.colon((Object)topic, (List)Nil$.MODULE$));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Errors errors = error = (Errors)tuple2._1();
        Errors error2 = errors;
        Assert.assertEquals((Object)Errors.GROUP_ID_NOT_FOUND, (Object)error2);
    }

    @Test
    public void testDeleteOffsetsOfStableConsumerGroupWithTopicPartition() {
        this.testWithStableConsumerGroup(this.topic(), 0, 0, Errors.GROUP_SUBSCRIBED_TO_TOPIC);
    }

    @Test
    public void testDeleteOffsetsOfStableConsumerGroupWithTopicOnly() {
        this.testWithStableConsumerGroup(this.topic(), -1, 0, Errors.GROUP_SUBSCRIBED_TO_TOPIC);
    }

    @Test
    public void testDeleteOffsetsOfStableConsumerGroupWithUnknownTopicPartition() {
        this.testWithStableConsumerGroup("foobar", 0, 0, Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    @Test
    public void testDeleteOffsetsOfStableConsumerGroupWithUnknownTopicOnly() {
        this.testWithStableConsumerGroup("foobar", -1, -1, Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    @Test
    public void testDeleteOffsetsOfEmptyConsumerGroupWithTopicPartition() {
        this.testWithEmptyConsumerGroup(this.topic(), 0, 0, Errors.NONE);
    }

    @Test
    public void testDeleteOffsetsOfEmptyConsumerGroupWithTopicOnly() {
        this.testWithEmptyConsumerGroup(this.topic(), -1, 0, Errors.NONE);
    }

    @Test
    public void testDeleteOffsetsOfEmptyConsumerGroupWithUnknownTopicPartition() {
        this.testWithEmptyConsumerGroup("foobar", 0, 0, Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    @Test
    public void testDeleteOffsetsOfEmptyConsumerGroupWithUnknownTopicOnly() {
        this.testWithEmptyConsumerGroup("foobar", -1, -1, Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    private void testWithStableConsumerGroup(String inputTopic, int inputPartition, int expectedPartition, Errors expectedError) {
        this.testWithConsumerGroup((Function1<Function0<BoxedUnit>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)body -> {
            this.withStableConsumerGroup((Function0<BoxedUnit>)body);
            return BoxedUnit.UNIT;
        }, inputTopic, inputPartition, expectedPartition, expectedError);
    }

    private void testWithEmptyConsumerGroup(String inputTopic, int inputPartition, int expectedPartition, Errors expectedError) {
        this.testWithConsumerGroup((Function1<Function0<BoxedUnit>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)body -> {
            this.withEmptyConsumerGroup((Function0<BoxedUnit>)body);
            return BoxedUnit.UNIT;
        }, inputTopic, inputPartition, expectedPartition, expectedError);
    }

    private void testWithConsumerGroup(Function1<Function0<BoxedUnit>, BoxedUnit> withConsumerGroup, String inputTopic, int inputPartition, int expectedPartition, Errors expectedError) {
        this.produceRecord();
        withConsumerGroup.apply((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String topic = inputPartition >= 0 ? new StringBuilder(1).append(inputTopic).append(":").append(inputPartition).toString() : inputTopic;
            ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(this.getArgs(this.group(), topic));
            Tuple2 tuple2 = service.deleteOffsets(this.group(), (List)new .colon.colon((Object)topic, (List)Nil$.MODULE$));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Errors topLevelError = (Errors)tuple2._1();
            Map partitions = (Map)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)topLevelError, (Object)partitions);
            Tuple2 tuple23 = tuple22;
            Errors topLevelError2 = (Errors)tuple23._1();
            Map partitions2 = (Map)tuple23._2();
            TopicPartition tp = new TopicPartition(inputTopic, expectedPartition);
            if (inputPartition >= 0) {
                Assert.assertEquals((Object)expectedError, (Object)topLevelError2);
            }
            Errors errors = expectedError;
            Errors errors2 = Errors.NONE;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                Assert.assertNull((Object)partitions2.apply((Object)tp));
            } else {
                Assert.assertEquals((Object)((Object)expectedError.exception()), (Object)((Throwable)partitions2.apply((Object)tp)).getCause());
            }
        });
    }

    private void produceRecord() {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1());
        try {
            producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, null)).get();
        }
        finally {
            Utils.closeQuietly(producer, (String)"producer");
        }
    }

    private void withStableConsumerGroup(Function0<BoxedUnit> body) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumer(this.createConsumer$default$1());
        try {
            TestUtils$.MODULE$.subscribeAndWaitForRecords(this.topic(), consumer, TestUtils$.MODULE$.subscribeAndWaitForRecords$default$3());
            consumer.commitSync();
            body.apply$mcV$sp();
        }
        finally {
            Utils.closeQuietly(consumer, (String)"consumer");
        }
    }

    private void withEmptyConsumerGroup(Function0<BoxedUnit> body) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumer(this.createConsumer$default$1());
        try {
            TestUtils$.MODULE$.subscribeAndWaitForRecords(this.topic(), consumer, TestUtils$.MODULE$.subscribeAndWaitForRecords$default$3());
            consumer.commitSync();
        }
        finally {
            Utils.closeQuietly(consumer, (String)"consumer");
        }
        body.apply$mcV$sp();
    }

    private KafkaProducer<byte[], byte[]> createProducer(Properties config) {
        config.putIfAbsent("bootstrap.servers", this.brokerList());
        config.putIfAbsent("acks", "-1");
        config.putIfAbsent("key.serializer", ByteArraySerializer.class.getName());
        config.putIfAbsent("value.serializer", ByteArraySerializer.class.getName());
        return new KafkaProducer(config);
    }

    private Properties createProducer$default$1() {
        return new Properties();
    }

    private KafkaConsumer<byte[], byte[]> createConsumer(Properties config) {
        config.putIfAbsent("bootstrap.servers", this.brokerList());
        config.putIfAbsent("auto.offset.reset", "earliest");
        config.putIfAbsent("group.id", this.group());
        config.putIfAbsent("key.deserializer", ByteArrayDeserializer.class.getName());
        config.putIfAbsent("value.deserializer", ByteArrayDeserializer.class.getName());
        config.putIfAbsent("max.poll.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)).toString());
        config.putIfAbsent("session.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.GroupMaxSessionTimeoutMs())).toString());
        return new KafkaConsumer(config);
    }

    private Properties createConsumer$default$1() {
        return new Properties();
    }
}

