/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.admin.RackAwareMode;
import kafka.api.BaseProducerSendTest;
import kafka.api.BaseProducerSendTest$callback$1$;
import kafka.api.BaseProducerSendTest$callback$3$;
import kafka.controller.ReplicaAssignment;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ug!\u0002\u0012$\u0003\u0003A\u0003\"B\u0018\u0001\t\u0003\u0001\u0004\"B\u001a\u0001\t\u0003!\u0004\"C\"\u0001\u0001\u0004\u0005\r\u0011\"\u0003E\u0011%A\u0006\u00011AA\u0002\u0013%\u0011\fC\u0005`\u0001\u0001\u0007\t\u0011)Q\u0005\u000b\"9\u0001\r\u0001b\u0001\n\u0013\t\u0007B\u00028\u0001A\u0003%!\rC\u0004p\u0001\t\u0007I\u0011\u00039\t\re\u0004\u0001\u0015!\u0003r\u0011\u001dQ\bA1A\u0005\nmDaa \u0001!\u0002\u0013a\bbBA\u0001\u0001\u0011\u0005\u00131\u0001\u0005\b\u0003'\u0001A\u0011IA\u0002\u0011\u001d\ti\u0002\u0001C\t\u0003?A\u0011\"a\u0015\u0001#\u0003%\t\"!\u0016\t\u0013\u0005-\u0004!%A\u0005\u0012\u0005U\u0003\"CA7\u0001E\u0005I\u0011CA+\u0011%\ty\u0007AI\u0001\n#\t\t\bC\u0005\u0002v\u0001\t\n\u0011\"\u0005\u0002x!9\u00111\u0010\u0001\u0005\u0012\u0005u\u0004bBAA\u0001\u0011\u0005\u00111\u0001\u0005\b\u0003\u0017\u0003A\u0011AA\u0002\u0011\u001d\ty\t\u0001C\u0001\u0003\u0007Aq!a%\u0001\t#\t)\nC\u0005\u0002 \u0002\t\n\u0011\"\u0005\u0002V!I\u0011\u0011\u0015\u0001\u0012\u0002\u0013E\u0011q\u000f\u0005\b\u0003G\u0003A\u0011CAS\u0011\u001d\ti\f\u0001C\u0001\u0003\u0007Aq!!1\u0001\t\u0003\t\u0019\u0001C\u0004\u0002F\u0002!\t!a\u0001\t\u000f\u0005%\u0007\u0001\"\u0001\u0002\u0004!9\u0011Q\u001a\u0001\u0005\u0002\u0005\r\u0001bBAi\u0001\u0011\u0005\u00111\u0001\u0002\u0015\u0005\u0006\u001cX\r\u0015:pIV\u001cWM]*f]\u0012$Vm\u001d;\u000b\u0005\u0011*\u0013aA1qS*\ta%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001I\u0003C\u0001\u0016.\u001b\u0005Y#B\u0001\u0017&\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u00059Z#AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005\t\u0004C\u0001\u001a\u0001\u001b\u0005\u0019\u0013aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0016\u0003U\u00022AN\u001e>\u001b\u00059$B\u0001\u001d:\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002u\u0005)1oY1mC&\u0011Ah\u000e\u0002\u0004'\u0016\f\bC\u0001 B\u001b\u0005y$B\u0001!&\u0003\u0019\u0019XM\u001d<fe&\u0011!i\u0010\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u0005d_:\u001cX/\\3s+\u0005)\u0005\u0003\u0002$P#Fk\u0011a\u0012\u0006\u0003\u0007\"S!!\u0013&\u0002\u000f\rd\u0017.\u001a8ug*\u0011ae\u0013\u0006\u0003\u00196\u000ba!\u00199bG\",'\"\u0001(\u0002\u0007=\u0014x-\u0003\u0002Q\u000f\ni1*\u00194lC\u000e{gn];nKJ\u00042AU*V\u001b\u0005I\u0014B\u0001+:\u0005\u0015\t%O]1z!\t\u0011f+\u0003\u0002Xs\t!!)\u001f;f\u00031\u0019wN\\:v[\u0016\u0014x\fJ3r)\tQV\f\u0005\u0002S7&\u0011A,\u000f\u0002\u0005+:LG\u000fC\u0004_\t\u0005\u0005\t\u0019A#\u0002\u0007a$\u0013'A\u0005d_:\u001cX/\\3sA\u0005I\u0001O]8ek\u000e,'o]\u000b\u0002EB\u00191M\u001a5\u000e\u0003\u0011T!!Z\u001c\u0002\u000f5,H/\u00192mK&\u0011q\r\u001a\u0002\u0007\u0005V4g-\u001a:\u0011\t%d\u0017+U\u0007\u0002U*\u00111\u000eS\u0001\taJ|G-^2fe&\u0011QN\u001b\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\u0002\u0015A\u0014x\u000eZ;dKJ\u001c\b%A\u0003u_BL7-F\u0001r!\t\u0011x/D\u0001t\u0015\t!X/\u0001\u0003mC:<'\"\u0001<\u0002\t)\fg/Y\u0005\u0003qN\u0014aa\u0015;sS:<\u0017A\u0002;pa&\u001c\u0007%\u0001\u0006ok6\u0014VmY8sIN,\u0012\u0001 \t\u0003%vL!A`\u001d\u0003\u0007%sG/A\u0006ok6\u0014VmY8sIN\u0004\u0013!B:fiV\u0003H#\u0001.)\u00071\t9\u0001\u0005\u0003\u0002\n\u0005=QBAA\u0006\u0015\r\ti!T\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003#\tYA\u0001\u0004CK\u001a|'/Z\u0001\ti\u0016\f'\u000fR8x]\"\u001aQ\"a\u0006\u0011\t\u0005%\u0011\u0011D\u0005\u0005\u00037\tYAA\u0003BMR,'/\u0001\bde\u0016\fG/\u001a)s_\u0012,8-\u001a:\u0015\u001b!\f\t#!\u000f\u0002>\u0005\u0005\u0013QIA%\u0011\u001d\t\u0019C\u0004a\u0001\u0003K\t!B\u0019:pW\u0016\u0014H*[:u!\u0011\t9#!\u000e\u000f\t\u0005%\u0012\u0011\u0007\t\u0004\u0003WITBAA\u0017\u0015\r\tycJ\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005M\u0012(\u0001\u0004Qe\u0016$WMZ\u0005\u0004q\u0006]\"bAA\u001as!A\u00111\b\b\u0011\u0002\u0003\u0007A0\u0001\u0005mS:<WM]'t\u0011!\tyD\u0004I\u0001\u0002\u0004a\u0018!\u00053fY&4XM]=US6,w.\u001e;Ng\"A\u00111\t\b\u0011\u0002\u0003\u0007A0A\u0005cCR\u001c\u0007nU5{K\"I\u0011q\t\b\u0011\u0002\u0003\u0007\u0011QE\u0001\u0010G>l\u0007O]3tg&|g\u000eV=qK\"I\u00111\n\b\u0011\u0002\u0003\u0007\u0011QJ\u0001\u000b[\u0006D(\t\\8dW6\u001b\bc\u0001*\u0002P%\u0019\u0011\u0011K\u001d\u0003\t1{gnZ\u0001\u0019GJ,\u0017\r^3Qe>$WoY3sI\u0011,g-Y;mi\u0012\u0012TCAA,U\ra\u0018\u0011L\u0016\u0003\u00037\u0002B!!\u0018\u0002h5\u0011\u0011q\f\u0006\u0005\u0003C\n\u0019'A\u0005v]\u000eDWmY6fI*\u0019\u0011QM\u001d\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002j\u0005}#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006A2M]3bi\u0016\u0004&o\u001c3vG\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u00021\r\u0014X-\u0019;f!J|G-^2fe\u0012\"WMZ1vYR$C'\u0001\rde\u0016\fG/\u001a)s_\u0012,8-\u001a:%I\u00164\u0017-\u001e7uIU*\"!a\u001d+\t\u0005\u0015\u0012\u0011L\u0001\u0019GJ,\u0017\r^3Qe>$WoY3sI\u0011,g-Y;mi\u00122TCAA=U\u0011\ti%!\u0017\u0002!I,w-[:uKJ\u0004&o\u001c3vG\u0016\u0014Hc\u00015\u0002\u0000!)1\u000e\u0006a\u0001Q\u0006qA/Z:u'\u0016tGm\u00144gg\u0016$\bfA\u000b\u0002\u0006B!\u0011\u0011BAD\u0013\u0011\tI)a\u0003\u0003\tQ+7\u000f^\u0001(i\u0016\u001cHoU3oI\u000e{W\u000e\u001d:fgN,G-T3tg\u0006<WmV5uQ\u000e\u0013X-\u0019;f)&lW\rK\u0002\u0017\u0003\u000b\u000b!\u0006^3tiN+g\u000e\u001a(p]\u000e{W\u000e\u001d:fgN,G-T3tg\u0006<WmV5uQ\u000e\u0013X-\u0019;f)&lW\rK\u0002\u0018\u0003\u000b\u000bQb]3oI\u0006sGMV3sS\u001aLHc\u0002.\u0002\u0018\u0006e\u00151\u0014\u0005\u0006Wb\u0001\r\u0001\u001b\u0005\bub\u0001\n\u00111\u0001}\u0011%\ti\n\u0007I\u0001\u0002\u0004\ti%A\u0005uS6,w.\u001e;Ng\u000692/\u001a8e\u0003:$g+\u001a:jMf$C-\u001a4bk2$HEM\u0001\u0018g\u0016tG-\u00118e-\u0016\u0014\u0018NZ=%I\u00164\u0017-\u001e7uIM\nac]3oI\u0006sGMV3sS\u001aLH+[7fgR\fW\u000e\u001d\u000b\u00065\u0006\u001d\u0016\u0011\u0016\u0005\u0006Wn\u0001\r\u0001\u001b\u0005\b\u0003W[\u0002\u0019AAW\u00035!\u0018.\\3ti\u0006l\u0007\u000fV=qKB!\u0011qVA]\u001b\t\t\tL\u0003\u0003\u00024\u0006U\u0016A\u0002:fG>\u0014HMC\u0002\u00028*\u000baaY8n[>t\u0017\u0002BA^\u0003c\u0013Q\u0002V5nKN$\u0018-\u001c9UsB,\u0017!\u0003;fgR\u001cEn\\:fQ\ra\u0012QQ\u0001\u0014i\u0016\u001cHoU3oIR{\u0007+\u0019:uSRLwN\u001c\u0015\u0004;\u0005\u0015\u0015\u0001\u000b;fgR\u001cVM\u001c3CK\u001a|'/Z!oI\u00063G/\u001a:QCJ$\u0018\u000e^5p]\u0016C\b/\u00198tS>t\u0007f\u0001\u0010\u0002\u0006\u0006IA/Z:u\r2,8\u000f\u001b\u0015\u0004?\u0005\u0015\u0015\u0001\u000b;fgR\u001cEn\\:f/&$\bNW3s_RKW.Z8vi\u001a\u0013x.\\\"bY2,'\u000f\u00165sK\u0006$\u0007f\u0001\u0011\u0002\u0006\u0006AC/Z:u\u00072|7/Z,ji\"TVM]8US6,w.\u001e;Ge>l7+\u001a8eKJ$\u0006N]3bI\"\u001a\u0011%!\"")
public abstract class BaseProducerSendTest
extends KafkaServerTestHarness {
    private KafkaConsumer<byte[], byte[]> consumer;
    private final Buffer<KafkaProducer<byte[], byte[]>> producers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final String topic;
    private final int kafka$api$BaseProducerSendTest$$numRecords;

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Properties overridingProps = new Properties();
        int numServers = 2;
        overridingProps.put(KafkaConfig$.MODULE$.NumPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)4)).toString());
        int x$12 = numServers;
        String x$2 = this.zkConnect();
        boolean x$3 = false;
        Some x$4 = new Some((Object)this.securityProtocol());
        Option<File> x$5 = this.trustStoreFile();
        Option<Properties> x$6 = this.serverSaslProperties();
        boolean x$7 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        boolean x$8 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Map<Object, String> x$122 = TestUtils$.MODULE$.createBrokerConfigs$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfigs$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfigs$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfigs$default$15();
        short x$16 = TestUtils$.MODULE$.createBrokerConfigs$default$16();
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$12, x$2, x$3, x$7, (Option<SecurityProtocol>)x$4, x$5, x$6, x$8, x$9, x$10, x$11, x$122, x$13, x$14, x$15, x$16).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, overridingProps), Seq$.MODULE$.canBuildFrom());
    }

    private KafkaConsumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    private void consumer_$eq(KafkaConsumer<byte[], byte[]> x$1) {
        this.consumer = x$1;
    }

    private Buffer<KafkaProducer<byte[], byte[]>> producers() {
        return this.producers;
    }

    public String topic() {
        return this.topic;
    }

    public int kafka$api$BaseProducerSendTest$$numRecords() {
        return this.kafka$api$BaseProducerSendTest$$numRecords;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        SecurityProtocol x$2 = SecurityProtocol.PLAINTEXT;
        String x$3 = TestUtils$.MODULE$.createConsumer$default$2();
        String x$4 = TestUtils$.MODULE$.createConsumer$default$3();
        boolean x$5 = TestUtils$.MODULE$.createConsumer$default$4();
        boolean x$6 = TestUtils$.MODULE$.createConsumer$default$5();
        int x$7 = TestUtils$.MODULE$.createConsumer$default$6();
        Option<File> x$8 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$9 = TestUtils$.MODULE$.createConsumer$default$9();
        ByteArrayDeserializer x$10 = TestUtils$.MODULE$.createConsumer$default$10();
        ByteArrayDeserializer x$11 = TestUtils$.MODULE$.createConsumer$default$11();
        this.consumer_$eq(TestUtils$.MODULE$.createConsumer(x$1, x$3, x$4, x$5, x$6, x$7, x$2, x$8, x$9, x$10, x$11));
    }

    @Override
    @After
    public void tearDown() {
        this.consumer().close();
        this.producers().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    public KafkaProducer<byte[], byte[]> createProducer(String brokerList, int lingerMs, int deliveryTimeoutMs, int batchSize, String compressionType, long maxBlockMs) {
        String x$1 = brokerList;
        String x$2 = compressionType;
        SecurityProtocol x$3 = this.securityProtocol();
        Option<File> x$4 = this.trustStoreFile();
        Option<Properties> x$5 = this.clientSaslProperties();
        int x$6 = lingerMs;
        int x$7 = deliveryTimeoutMs;
        long x$8 = maxBlockMs;
        int x$9 = TestUtils$.MODULE$.createProducer$default$2();
        long x$10 = TestUtils$.MODULE$.createProducer$default$4();
        int x$11 = TestUtils$.MODULE$.createProducer$default$5();
        int x$12 = TestUtils$.MODULE$.createProducer$default$8();
        int x$13 = TestUtils$.MODULE$.createProducer$default$10();
        ByteArraySerializer x$14 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$15 = TestUtils$.MODULE$.createProducer$default$15();
        KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$1, x$9, x$8, x$10, x$11, x$7, x$6, x$12, x$2, x$13, x$3, x$4, x$5, x$14, x$15);
        return this.registerProducer(producer);
    }

    public int createProducer$default$2() {
        return 0;
    }

    public int createProducer$default$3() {
        return 120000;
    }

    public int createProducer$default$4() {
        return 16384;
    }

    public String createProducer$default$5() {
        return "none";
    }

    public long createProducer$default$6() {
        return 60000L;
    }

    public KafkaProducer<byte[], byte[]> registerProducer(KafkaProducer<byte[], byte[]> producer) {
        this.producers().$plus$eq(producer);
        return producer;
    }

    @Test
    public void testSendOffset() {
        LazyRef callback$module = new LazyRef();
        int partition = 0;
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());){
            this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
            ProducerRecord record0 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((String)"Should have offset 0", (long)0L, (long)((RecordMetadata)producer.send(record0, (Callback)this.callback$2(callback$module, partition)).get()).offset());
            ProducerRecord record1 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), (Object)"key".getBytes(StandardCharsets.UTF_8), null);
            Assert.assertEquals((String)"Should have offset 1", (long)1L, (long)((RecordMetadata)producer.send(record1, (Callback)this.callback$2(callback$module, partition)).get()).offset());
            ProducerRecord record2 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((String)"Should have offset 2", (long)2L, (long)((RecordMetadata)producer.send(record2, (Callback)this.callback$2(callback$module, partition)).get()).offset());
            ProducerRecord record3 = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((String)"Should have offset 3", (long)3L, (long)((RecordMetadata)producer.send(record3, (Callback)this.callback$2(callback$module, partition)).get()).offset());
            try {
                ProducerRecord record4 = new ProducerRecord(null, Predef$.MODULE$.int2Integer(partition), (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
                producer.send(record4, (Callback)this.callback$2(callback$module, partition));
                throw Assertions$.MODULE$.fail("Should not allow sending a record without topic", new Position("BaseProducerSendTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1 & Serializable & scala.Serializable)_ -> producer.send(record0, (Callback)this.callback$2(callback$module, partition)));
                Assert.assertEquals((String)new StringBuilder(19).append("Should have offset ").append(this.kafka$api$BaseProducerSendTest$$numRecords() + 4).toString(), (long)((long)this.kafka$api$BaseProducerSendTest$$numRecords() + 4L), (long)((RecordMetadata)producer.send(record0, (Callback)this.callback$2(callback$module, partition)).get()).offset());
            }
        }
    }

    @Test
    public void testSendCompressedMessageWithCreateTime() {
        String x$1 = this.brokerList();
        String x$2 = "gzip";
        int x$3 = Integer.MAX_VALUE;
        int x$4 = Integer.MAX_VALUE;
        int x$5 = this.createProducer$default$4();
        long x$6 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$1, x$3, x$4, x$5, x$2, x$6);
        this.sendAndVerifyTimestamp(producer, TimestampType.CREATE_TIME);
    }

    @Test
    public void testSendNonCompressedMessageWithCreateTime() {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), Integer.MAX_VALUE, Integer.MAX_VALUE, this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        this.sendAndVerifyTimestamp(producer, TimestampType.CREATE_TIME);
    }

    public void sendAndVerify(KafkaProducer<byte[], byte[]> producer, int numRecords, long timeoutMs) {
        int partition = 0;
        try {
            this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
            IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numRecords).map((Function1 & Serializable & scala.Serializable)i -> BaseProducerSendTest.$anonfun$sendAndVerify$1(this, partition, producer, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            producer.close(Duration.ofMillis(timeoutMs));
            int lastOffset = BoxesRunTime.unboxToInt((Object)futures.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(offset, future) -> BoxesRunTime.boxToInteger((int)BaseProducerSendTest.$anonfun$sendAndVerify$2(this, partition, BoxesRunTime.unboxToInt((Object)offset), future))));
            Assert.assertEquals((long)numRecords, (long)lastOffset);
        }
        finally {
            producer.close();
        }
    }

    public int sendAndVerify$default$2() {
        return this.kafka$api$BaseProducerSendTest$$numRecords();
    }

    public long sendAndVerify$default$3() {
        return 20000L;
    }

    public void sendAndVerifyTimestamp(KafkaProducer<byte[], byte[]> producer, TimestampType timestampType) {
        LazyRef callback$module = new LazyRef();
        int partition = 0;
        long baseTimestamp = 123456L;
        long startTime = System.currentTimeMillis();
        try {
            Properties topicProps = new Properties();
            TimestampType timestampType2 = timestampType;
            TimestampType timestampType3 = TimestampType.LOG_APPEND_TIME;
            Object object = !(timestampType2 != null ? !timestampType2.equals(timestampType3) : timestampType3 != null) ? topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "LogAppendTime") : topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "CreateTime");
            this.createTopic(this.topic(), 1, 2, topicProps);
            IndexedSeq recordAndFutures = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)i -> BaseProducerSendTest.$anonfun$sendAndVerifyTimestamp$1(this, partition, baseTimestamp, producer, callback$module, timestampType, startTime, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            producer.close(Duration.ofSeconds(20L));
            recordAndFutures.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                BaseProducerSendTest.$anonfun$sendAndVerifyTimestamp$2(timestampType, startTime, x0$1);
                return BoxedUnit.UNIT;
            });
            Assert.assertEquals((String)new StringBuilder(47).append("Should have offset ").append(this.kafka$api$BaseProducerSendTest$$numRecords()).append(" but only successfully sent ").append(this.callback$4(callback$module, timestampType, baseTimestamp, startTime, partition).offset()).toString(), (long)this.kafka$api$BaseProducerSendTest$$numRecords(), (long)this.callback$4(callback$module, timestampType, baseTimestamp, startTime, partition).offset());
        }
        finally {
            producer.close();
        }
    }

    @Test
    public void testClose() {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());){
            this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
            ProducerRecord record0 = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1 & Serializable & scala.Serializable)_ -> producer.send(record0));
            Future response0 = producer.send(record0);
            producer.close();
            Assert.assertTrue((String)"The last message should be acked before producer is shutdown", (boolean)response0.isDone());
            Assert.assertEquals((String)new StringBuilder(19).append("Should have offset ").append(this.kafka$api$BaseProducerSendTest$$numRecords()).toString(), (long)this.kafka$api$BaseProducerSendTest$$numRecords(), (long)((RecordMetadata)response0.get()).offset());
        }
    }

    @Test
    public void testSendToPartition() {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());){
            this.createTopic(this.topic(), 2, 2, this.createTopic$default$4());
            int partition = 1;
            long now = System.currentTimeMillis();
            IndexedSeq futures = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), Predef$.MODULE$.long2Long(now), null, (Object)new StringBuilder(5).append("value").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(StandardCharsets.UTF_8))), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$3 -> (RecordMetadata)x$3.get(30L, TimeUnit.SECONDS), IndexedSeq$.MODULE$.canBuildFrom());
            ((TraversableLike)futures.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testSendToPartition$3(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                BaseProducerSendTest.$anonfun$testSendToPartition$4(this, partition, x$4);
                return BoxedUnit.UNIT;
            });
            this.consumer().assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new TopicPartition(this.topic(), partition), (List)Nil$.MODULE$)).asJava());
            Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.consumeRecords(this.consumer(), this.kafka$api$BaseProducerSendTest$$numRecords(), TestUtils$.MODULE$.consumeRecords$default$3());
            ((IterableLike)records.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                BaseProducerSendTest.$anonfun$testSendToPartition$5(this, partition, now, x0$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testSendBeforeAndAfterPartitionExpansion() {
        String x$1 = this.brokerList();
        long x$2 = 5000L;
        int x$3 = this.createProducer$default$2();
        int x$4 = this.createProducer$default$3();
        int x$52 = this.createProducer$default$4();
        String x$62 = this.createProducer$default$5();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$1, x$3, x$4, x$52, x$62, x$2);
        this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
        int partition0 = 0;
        IndexedSeq futures0 = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition0), null, (Object)new StringBuilder(5).append("value").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(StandardCharsets.UTF_8))), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$5 -> (RecordMetadata)x$5.get(30L, TimeUnit.SECONDS), IndexedSeq$.MODULE$.canBuildFrom());
        ((TraversableLike)futures0.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$3(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$4(this, partition0, x$6);
            return BoxedUnit.UNIT;
        });
        int partition1 = 1;
        try {
            producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition1), null, (Object)"value".getBytes(StandardCharsets.UTF_8))).get();
            throw Assertions$.MODULE$.fail("Should not allow sending a record to a partition not present in the metadata", new Position("BaseProducerSendTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (!(throwable instanceof TimeoutException)) {
                throw new Exception("Sending to a partition not present in the metadata should result in a TimeoutException", throwable);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            Map existingAssignment = (Map)this.zkClient().getFullReplicaAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                ReplicaAssignment assignment = (ReplicaAssignment)tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())), (Object)assignment);
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
            AdminZkClient qual$1 = this.adminZkClient();
            String x$92 = this.topic();
            Map x$102 = existingAssignment;
            AdminZkClient qual$2 = this.adminZkClient();
            RackAwareMode x$72 = qual$2.getBrokerMetadatas$default$1();
            Option x$82 = qual$2.getBrokerMetadatas$default$2();
            Seq x$11 = qual$2.getBrokerMetadatas(x$72, x$82);
            int x$12 = 2;
            Option x$13 = qual$1.addPartitions$default$5();
            boolean x$14 = qual$1.addPartitions$default$6();
            qual$1.addPartitions(x$92, x$102, x$11, x$12, x$13, x$14);
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            IndexedSeq futures1 = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition1), null, (Object)new StringBuilder(5).append("value").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(StandardCharsets.UTF_8))), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$7 -> (RecordMetadata)x$7.get(30L, TimeUnit.SECONDS), IndexedSeq$.MODULE$.canBuildFrom());
            ((TraversableLike)futures1.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$8(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$9(this, partition1, x$8);
                return BoxedUnit.UNIT;
            });
            futures0 = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition0), null, (Object)new StringBuilder(5).append("value").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(StandardCharsets.UTF_8))), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$9 -> (RecordMetadata)x$9.get(30L, TimeUnit.SECONDS), IndexedSeq$.MODULE$.canBuildFrom());
            ((TraversableLike)futures0.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.kafka$api$BaseProducerSendTest$$numRecords()), 2 * this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$12(check$ifrefutable$4))).foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
                BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$13(this, partition0, x$10);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Test
    public void testFlush() {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), Integer.MAX_VALUE, Integer.MAX_VALUE, this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());){
            this.createTopic(this.topic(), 2, 2, this.createTopic$default$4());
            ProducerRecord record = new ProducerRecord(this.topic(), (Object)"value".getBytes(StandardCharsets.UTF_8));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)x$11 -> producer.send(record), IndexedSeq$.MODULE$.canBuildFrom());
                Assert.assertTrue((String)"No request is complete.", (boolean)responses.forall((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testFlush$3(x$12))));
                producer.flush();
                Assert.assertTrue((String)"All requests are complete.", (boolean)responses.forall((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.isDone())));
            });
        }
    }

    @Test
    public void testCloseWithZeroTimeoutFromCallerThread() {
        this.createTopic(this.topic(), 2, 2, this.createTopic$default$4());
        int partition = 0;
        this.consumer().assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new TopicPartition(this.topic(), partition), (List)Nil$.MODULE$)).asJava());
        ProducerRecord record0 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes(StandardCharsets.UTF_8));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), Integer.MAX_VALUE, Integer.MAX_VALUE, this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
            IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)x$14 -> producer.send(record0), IndexedSeq$.MODULE$.canBuildFrom());
            Assert.assertTrue((String)"No request is complete.", (boolean)responses.forall((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromCallerThread$3(x$15))));
            producer.close(Duration.ZERO);
            responses.foreach((Function1 & Serializable & scala.Serializable)future -> {
                BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromCallerThread$4(future);
                return BoxedUnit.UNIT;
            });
            Assert.assertEquals((String)"Fetch response should have no message returned.", (long)0L, (long)this.consumer().poll(Duration.ofMillis(50L)).count());
        });
    }

    @Test
    public void testCloseWithZeroTimeoutFromSenderThread() {
        this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
        int partition = 0;
        this.consumer().assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new TopicPartition(this.topic(), partition), (List)Nil$.MODULE$)).asJava());
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes(StandardCharsets.UTF_8));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable & scala.Serializable)i -> BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromSenderThread$1(this, record, BoxesRunTime.unboxToInt((Object)i)));
    }

    private final /* synthetic */ BaseProducerSendTest$callback$1$ callback$lzycompute$1(LazyRef callback$module$1, int partition$1) {
        BaseProducerSendTest$callback$1$ baseProducerSendTest$callback$1$;
        LazyRef lazyRef = callback$module$1;
        synchronized (lazyRef) {
            baseProducerSendTest$callback$1$ = callback$module$1.initialized() ? (BaseProducerSendTest$callback$1$)callback$module$1.value() : (BaseProducerSendTest$callback$1$)callback$module$1.initialize((Object)new BaseProducerSendTest$callback$1$(this, partition$1));
        }
        return baseProducerSendTest$callback$1$;
    }

    private final BaseProducerSendTest$callback$1$ callback$2(LazyRef callback$module$1, int partition$1) {
        return callback$module$1.initialized() ? (BaseProducerSendTest$callback$1$)callback$module$1.value() : this.callback$lzycompute$1(callback$module$1, partition$1);
    }

    public static final /* synthetic */ Future $anonfun$sendAndVerify$1(BaseProducerSendTest $this, int partition$2, KafkaProducer producer$2, int i) {
        ProducerRecord record = new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(partition$2), (Object)new StringBuilder(3).append("key").append(i).toString().getBytes(StandardCharsets.UTF_8), (Object)new StringBuilder(5).append("value").append(i).toString().getBytes(StandardCharsets.UTF_8));
        return producer$2.send(record);
    }

    public static final /* synthetic */ int $anonfun$sendAndVerify$2(BaseProducerSendTest $this, int partition$2, int offset, Future future) {
        RecordMetadata recordMetadata = (RecordMetadata)future.get();
        Assert.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
        Assert.assertEquals((long)partition$2, (long)recordMetadata.partition());
        Assert.assertEquals((long)offset, (long)recordMetadata.offset());
        return offset + 1;
    }

    private final /* synthetic */ BaseProducerSendTest$callback$3$ callback$lzycompute$2(LazyRef callback$module$2, TimestampType timestampType$1, long baseTimestamp$1, long startTime$1, int partition$3) {
        BaseProducerSendTest$callback$3$ baseProducerSendTest$callback$3$;
        LazyRef lazyRef = callback$module$2;
        synchronized (lazyRef) {
            baseProducerSendTest$callback$3$ = callback$module$2.initialized() ? (BaseProducerSendTest$callback$3$)callback$module$2.value() : (BaseProducerSendTest$callback$3$)callback$module$2.initialize((Object)new BaseProducerSendTest$callback$3$(this, timestampType$1, baseTimestamp$1, startTime$1, partition$3));
        }
        return baseProducerSendTest$callback$3$;
    }

    private final BaseProducerSendTest$callback$3$ callback$4(LazyRef callback$module$2, TimestampType timestampType$1, long baseTimestamp$1, long startTime$1, int partition$3) {
        return callback$module$2.initialized() ? (BaseProducerSendTest$callback$3$)callback$module$2.value() : this.callback$lzycompute$2(callback$module$2, timestampType$1, baseTimestamp$1, startTime$1, partition$3);
    }

    public static final /* synthetic */ Tuple2 $anonfun$sendAndVerifyTimestamp$1(BaseProducerSendTest $this, int partition$3, long baseTimestamp$1, KafkaProducer producer$3, LazyRef callback$module$2, TimestampType timestampType$1, long startTime$1, int i) {
        ProducerRecord record = new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(partition$3), Predef$.MODULE$.long2Long(baseTimestamp$1 + (long)i), (Object)new StringBuilder(3).append("key").append(i).toString().getBytes(StandardCharsets.UTF_8), (Object)new StringBuilder(5).append("value").append(i).toString().getBytes(StandardCharsets.UTF_8));
        return new Tuple2((Object)record, (Object)producer$3.send(record, (Callback)$this.callback$4(callback$module$2, timestampType$1, baseTimestamp$1, startTime$1, partition$3)));
    }

    public static final /* synthetic */ void $anonfun$sendAndVerifyTimestamp$2(TimestampType timestampType$1, long startTime$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            ProducerRecord record = (ProducerRecord)tuple2._1();
            Future future = (Future)tuple2._2();
            RecordMetadata recordMetadata = (RecordMetadata)future.get();
            TimestampType timestampType = timestampType$1;
            TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
            if (!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null)) {
                Assert.assertTrue((recordMetadata.timestamp() >= startTime$1 && recordMetadata.timestamp() <= System.currentTimeMillis() ? 1 : 0) != 0);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Assert.assertEquals((Object)record.timestamp(), (Object)BoxesRunTime.boxToLong((long)recordMetadata.timestamp()));
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$testSendToPartition$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testSendToPartition$4(BaseProducerSendTest $this, int partition$4, Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RecordMetadata recordMetadata = (RecordMetadata)tuple2._1();
        int offset = tuple2._2$mcI$sp();
        Assert.assertEquals((long)offset, (long)recordMetadata.offset());
        Assert.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
        Assert.assertEquals((long)partition$4, (long)recordMetadata.partition());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testSendToPartition$5(BaseProducerSendTest $this, int partition$4, long now$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ConsumerRecord record = (ConsumerRecord)tuple2._1();
        int i = tuple2._2$mcI$sp();
        Assert.assertEquals((Object)$this.topic(), (Object)record.topic());
        Assert.assertEquals((long)partition$4, (long)record.partition());
        Assert.assertEquals((long)i, (long)record.offset());
        Assert.assertNull((Object)record.key());
        Assert.assertEquals((Object)new StringBuilder(5).append("value").append(i + 1).toString(), (Object)new String((byte[])record.value()));
        Assert.assertEquals((long)now$1, (long)record.timestamp());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$testSendBeforeAndAfterPartitionExpansion$3(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testSendBeforeAndAfterPartitionExpansion$4(BaseProducerSendTest $this, int partition0$1, Tuple2 x$6) {
        Tuple2 tuple2 = x$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RecordMetadata recordMetadata = (RecordMetadata)tuple2._1();
        int offset = tuple2._2$mcI$sp();
        Assert.assertEquals((long)offset, (long)recordMetadata.offset());
        Assert.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
        Assert.assertEquals((long)partition0$1, (long)recordMetadata.partition());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$testSendBeforeAndAfterPartitionExpansion$8(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testSendBeforeAndAfterPartitionExpansion$9(BaseProducerSendTest $this, int partition1$1, Tuple2 x$8) {
        Tuple2 tuple2 = x$8;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RecordMetadata recordMetadata = (RecordMetadata)tuple2._1();
        int offset = tuple2._2$mcI$sp();
        Assert.assertEquals((long)offset, (long)recordMetadata.offset());
        Assert.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
        Assert.assertEquals((long)partition1$1, (long)recordMetadata.partition());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$testSendBeforeAndAfterPartitionExpansion$12(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testSendBeforeAndAfterPartitionExpansion$13(BaseProducerSendTest $this, int partition0$1, Tuple2 x$10) {
        Tuple2 tuple2 = x$10;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RecordMetadata recordMetadata = (RecordMetadata)tuple2._1();
        int offset = tuple2._2$mcI$sp();
        Assert.assertEquals((long)offset, (long)recordMetadata.offset());
        Assert.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
        Assert.assertEquals((long)partition0$1, (long)recordMetadata.partition());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$testFlush$3(Future x$12) {
        return !x$12.isDone();
    }

    public static final /* synthetic */ boolean $anonfun$testCloseWithZeroTimeoutFromCallerThread$3(Future x$15) {
        return !x$15.isDone();
    }

    public static final /* synthetic */ void $anonfun$testCloseWithZeroTimeoutFromCallerThread$4(Future future) {
        try {
            future.get();
            throw Assertions$.MODULE$.fail("No message should be sent successfully.", new Position("BaseProducerSendTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 457));
        }
        catch (ExecutionException e) {
            Assert.assertEquals(KafkaException.class, e.getCause().getClass());
            return;
        }
    }

    public static final /* synthetic */ Future $anonfun$testCloseWithZeroTimeoutFromSenderThread$2(BaseProducerSendTest $this, KafkaProducer producer$9, ProducerRecord record$2, int i) {
        public class Kafka_api_BaseProducerSendTest$CloseCallback$1
        implements Callback {
            private final KafkaProducer<byte[], byte[]> producer;
            private final boolean sendRecords;
            private final /* synthetic */ BaseProducerSendTest $outer;
            private final ProducerRecord record$2;

            public void onCompletion(RecordMetadata metadata, Exception exception) {
                if (this.sendRecords) {
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1 & Serializable & scala.Serializable)x$16 -> Kafka_api_BaseProducerSendTest$CloseCallback$1.$anonfun$onCompletion$1(this, BoxesRunTime.unboxToInt((Object)x$16)));
                }
                this.producer.close(Duration.ZERO);
                this.producer.close();
            }

            public static final /* synthetic */ Future $anonfun$onCompletion$1(Kafka_api_BaseProducerSendTest$CloseCallback$1 $this, int x$16) {
                return $this.producer.send($this.record$2);
            }

            /*
             * WARNING - void declaration
             */
            public Kafka_api_BaseProducerSendTest$CloseCallback$1(KafkaProducer<byte[], byte[]> producer, boolean sendRecords) {
                void var4_4;
                this.producer = producer;
                this.sendRecords = sendRecords;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$2 = var4_4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onCompletion$1$adapted(kafka.api.BaseProducerSendTest$CloseCallback$1 java.lang.Object )}, serializedLambda);
            }
        }
        return producer$9.send(record$2, (Callback)new Kafka_api_BaseProducerSendTest$CloseCallback$1($this, producer$9, i == 0, record$2));
    }

    public static final /* synthetic */ boolean $anonfun$testCloseWithZeroTimeoutFromSenderThread$3(Future x$17) {
        return !x$17.isDone();
    }

    public static final /* synthetic */ Seq $anonfun$testCloseWithZeroTimeoutFromSenderThread$1(BaseProducerSendTest $this, ProducerRecord record$2, int i2) {
        Seq<ConsumerRecord<byte[], byte[]>> seq;
        try (KafkaProducer<byte[], byte[]> producer = $this.createProducer($this.brokerList(), Integer.MAX_VALUE, Integer.MAX_VALUE, $this.createProducer$default$4(), $this.createProducer$default$5(), $this.createProducer$default$6());){
            IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), $this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)i -> BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromSenderThread$2($this, producer, record$2, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            Assert.assertTrue((String)"No request is complete.", (boolean)responses.forall((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromSenderThread$3(x$17))));
            producer.flush();
            Assert.assertTrue((String)"All requests are complete.", (boolean)responses.forall((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isDone())));
            seq = TestUtils$.MODULE$.pollUntilAtLeastNumRecords($this.consumer(), $this.kafka$api$BaseProducerSendTest$$numRecords(), TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
        }
        return seq;
    }

    public BaseProducerSendTest() {
        this.topic = "topic";
        this.kafka$api$BaseProducerSendTest$$numRecords = 100;
    }
}

